# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class BulkLoadResultModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'load_tag': 'str',
        'job_id': 'str',
        'total_files': 'int',
        'succeeded_files': 'int',
        'failed_files': 'int',
        'not_tried_files': 'int'
    }

    attribute_map = {
        'load_tag': 'loadTag',
        'job_id': 'jobId',
        'total_files': 'totalFiles',
        'succeeded_files': 'succeededFiles',
        'failed_files': 'failedFiles',
        'not_tried_files': 'notTriedFiles'
    }

    def __init__(self, load_tag=None, job_id=None, total_files=None, succeeded_files=None, failed_files=None, not_tried_files=None, local_vars_configuration=None):  # noqa: E501
        """BulkLoadResultModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._load_tag = None
        self._job_id = None
        self._total_files = None
        self._succeeded_files = None
        self._failed_files = None
        self._not_tried_files = None
        self.discriminator = None

        if load_tag is not None:
            self.load_tag = load_tag
        if job_id is not None:
            self.job_id = job_id
        if total_files is not None:
            self.total_files = total_files
        if succeeded_files is not None:
            self.succeeded_files = succeeded_files
        if failed_files is not None:
            self.failed_files = failed_files
        if not_tried_files is not None:
            self.not_tried_files = not_tried_files

    @property
    def load_tag(self):
        """Gets the load_tag of this BulkLoadResultModel.  # noqa: E501

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :return: The load_tag of this BulkLoadResultModel.  # noqa: E501
        :rtype: str
        """
        return self._load_tag

    @load_tag.setter
    def load_tag(self, load_tag):
        """Sets the load_tag of this BulkLoadResultModel.

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :param load_tag: The load_tag of this BulkLoadResultModel.  # noqa: E501
        :type: str
        """

        self._load_tag = load_tag

    @property
    def job_id(self):
        """Gets the job_id of this BulkLoadResultModel.  # noqa: E501


        :return: The job_id of this BulkLoadResultModel.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this BulkLoadResultModel.


        :param job_id: The job_id of this BulkLoadResultModel.  # noqa: E501
        :type: str
        """

        self._job_id = job_id

    @property
    def total_files(self):
        """Gets the total_files of this BulkLoadResultModel.  # noqa: E501


        :return: The total_files of this BulkLoadResultModel.  # noqa: E501
        :rtype: int
        """
        return self._total_files

    @total_files.setter
    def total_files(self, total_files):
        """Sets the total_files of this BulkLoadResultModel.


        :param total_files: The total_files of this BulkLoadResultModel.  # noqa: E501
        :type: int
        """

        self._total_files = total_files

    @property
    def succeeded_files(self):
        """Gets the succeeded_files of this BulkLoadResultModel.  # noqa: E501


        :return: The succeeded_files of this BulkLoadResultModel.  # noqa: E501
        :rtype: int
        """
        return self._succeeded_files

    @succeeded_files.setter
    def succeeded_files(self, succeeded_files):
        """Sets the succeeded_files of this BulkLoadResultModel.


        :param succeeded_files: The succeeded_files of this BulkLoadResultModel.  # noqa: E501
        :type: int
        """

        self._succeeded_files = succeeded_files

    @property
    def failed_files(self):
        """Gets the failed_files of this BulkLoadResultModel.  # noqa: E501


        :return: The failed_files of this BulkLoadResultModel.  # noqa: E501
        :rtype: int
        """
        return self._failed_files

    @failed_files.setter
    def failed_files(self, failed_files):
        """Sets the failed_files of this BulkLoadResultModel.


        :param failed_files: The failed_files of this BulkLoadResultModel.  # noqa: E501
        :type: int
        """

        self._failed_files = failed_files

    @property
    def not_tried_files(self):
        """Gets the not_tried_files of this BulkLoadResultModel.  # noqa: E501


        :return: The not_tried_files of this BulkLoadResultModel.  # noqa: E501
        :rtype: int
        """
        return self._not_tried_files

    @not_tried_files.setter
    def not_tried_files(self, not_tried_files):
        """Sets the not_tried_files of this BulkLoadResultModel.


        :param not_tried_files: The not_tried_files of this BulkLoadResultModel.  # noqa: E501
        :type: int
        """

        self._not_tried_files = not_tried_files

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BulkLoadResultModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BulkLoadResultModel):
            return True

        return self.to_dict() != other.to_dict()
