# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class DataDeletionTableModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'table_name': 'str',
        'gcs_file_spec': 'DataDeletionGcsFileModel',
        'json_array_spec': 'DataDeletionJsonArrayModel'
    }

    attribute_map = {
        'table_name': 'tableName',
        'gcs_file_spec': 'gcsFileSpec',
        'json_array_spec': 'jsonArraySpec'
    }

    def __init__(self, table_name=None, gcs_file_spec=None, json_array_spec=None, local_vars_configuration=None):  # noqa: E501
        """DataDeletionTableModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._table_name = None
        self._gcs_file_spec = None
        self._json_array_spec = None
        self.discriminator = None

        self.table_name = table_name
        if gcs_file_spec is not None:
            self.gcs_file_spec = gcs_file_spec
        if json_array_spec is not None:
            self.json_array_spec = json_array_spec

    @property
    def table_name(self):
        """Gets the table_name of this DataDeletionTableModel.  # noqa: E501

        the name of a table in the dataset  # noqa: E501

        :return: The table_name of this DataDeletionTableModel.  # noqa: E501
        :rtype: str
        """
        return self._table_name

    @table_name.setter
    def table_name(self, table_name):
        """Sets the table_name of this DataDeletionTableModel.

        the name of a table in the dataset  # noqa: E501

        :param table_name: The table_name of this DataDeletionTableModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and table_name is None:  # noqa: E501
            raise ValueError("Invalid value for `table_name`, must not be `None`")  # noqa: E501

        self._table_name = table_name

    @property
    def gcs_file_spec(self):
        """Gets the gcs_file_spec of this DataDeletionTableModel.  # noqa: E501


        :return: The gcs_file_spec of this DataDeletionTableModel.  # noqa: E501
        :rtype: DataDeletionGcsFileModel
        """
        return self._gcs_file_spec

    @gcs_file_spec.setter
    def gcs_file_spec(self, gcs_file_spec):
        """Sets the gcs_file_spec of this DataDeletionTableModel.


        :param gcs_file_spec: The gcs_file_spec of this DataDeletionTableModel.  # noqa: E501
        :type: DataDeletionGcsFileModel
        """

        self._gcs_file_spec = gcs_file_spec

    @property
    def json_array_spec(self):
        """Gets the json_array_spec of this DataDeletionTableModel.  # noqa: E501


        :return: The json_array_spec of this DataDeletionTableModel.  # noqa: E501
        :rtype: DataDeletionJsonArrayModel
        """
        return self._json_array_spec

    @json_array_spec.setter
    def json_array_spec(self, json_array_spec):
        """Sets the json_array_spec of this DataDeletionTableModel.


        :param json_array_spec: The json_array_spec of this DataDeletionTableModel.  # noqa: E501
        :type: DataDeletionJsonArrayModel
        """

        self._json_array_spec = json_array_spec

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DataDeletionTableModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DataDeletionTableModel):
            return True

        return self.to_dict() != other.to_dict()
