# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class DatasetRequestModelPolicies(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'stewards': 'list[str]',
        'custodians': 'list[str]',
        'snapshot_creators': 'list[str]'
    }

    attribute_map = {
        'stewards': 'stewards',
        'custodians': 'custodians',
        'snapshot_creators': 'snapshotCreators'
    }

    def __init__(self, stewards=None, custodians=None, snapshot_creators=None, local_vars_configuration=None):  # noqa: E501
        """DatasetRequestModelPolicies - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._stewards = None
        self._custodians = None
        self._snapshot_creators = None
        self.discriminator = None

        if stewards is not None:
            self.stewards = stewards
        if custodians is not None:
            self.custodians = custodians
        if snapshot_creators is not None:
            self.snapshot_creators = snapshot_creators

    @property
    def stewards(self):
        """Gets the stewards of this DatasetRequestModelPolicies.  # noqa: E501


        :return: The stewards of this DatasetRequestModelPolicies.  # noqa: E501
        :rtype: list[str]
        """
        return self._stewards

    @stewards.setter
    def stewards(self, stewards):
        """Sets the stewards of this DatasetRequestModelPolicies.


        :param stewards: The stewards of this DatasetRequestModelPolicies.  # noqa: E501
        :type: list[str]
        """

        self._stewards = stewards

    @property
    def custodians(self):
        """Gets the custodians of this DatasetRequestModelPolicies.  # noqa: E501


        :return: The custodians of this DatasetRequestModelPolicies.  # noqa: E501
        :rtype: list[str]
        """
        return self._custodians

    @custodians.setter
    def custodians(self, custodians):
        """Sets the custodians of this DatasetRequestModelPolicies.


        :param custodians: The custodians of this DatasetRequestModelPolicies.  # noqa: E501
        :type: list[str]
        """

        self._custodians = custodians

    @property
    def snapshot_creators(self):
        """Gets the snapshot_creators of this DatasetRequestModelPolicies.  # noqa: E501


        :return: The snapshot_creators of this DatasetRequestModelPolicies.  # noqa: E501
        :rtype: list[str]
        """
        return self._snapshot_creators

    @snapshot_creators.setter
    def snapshot_creators(self, snapshot_creators):
        """Sets the snapshot_creators of this DatasetRequestModelPolicies.


        :param snapshot_creators: The snapshot_creators of this DatasetRequestModelPolicies.  # noqa: E501
        :type: list[str]
        """

        self._snapshot_creators = snapshot_creators

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatasetRequestModelPolicies):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DatasetRequestModelPolicies):
            return True

        return self.to_dict() != other.to_dict()
