# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class IngestRequestModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'table': 'str',
        'path': 'str',
        'records': 'list[object]',
        'format': 'str',
        'load_tag': 'str',
        'profile_id': 'str',
        'max_bad_records': 'int',
        'max_failed_file_loads': 'int',
        'ignore_unknown_values': 'bool',
        'csv_field_delimiter': 'str',
        'csv_quote': 'str',
        'csv_skip_leading_rows': 'int',
        'csv_allow_quoted_newlines': 'bool',
        'csv_null_marker': 'str',
        'csv_generate_row_ids': 'bool',
        'resolve_existing_files': 'bool',
        'transaction_id': 'str',
        'update_strategy': 'str',
        'bulk_mode': 'bool'
    }

    attribute_map = {
        'table': 'table',
        'path': 'path',
        'records': 'records',
        'format': 'format',
        'load_tag': 'load_tag',
        'profile_id': 'profile_id',
        'max_bad_records': 'max_bad_records',
        'max_failed_file_loads': 'max_failed_file_loads',
        'ignore_unknown_values': 'ignore_unknown_values',
        'csv_field_delimiter': 'csv_field_delimiter',
        'csv_quote': 'csv_quote',
        'csv_skip_leading_rows': 'csv_skip_leading_rows',
        'csv_allow_quoted_newlines': 'csv_allow_quoted_newlines',
        'csv_null_marker': 'csv_null_marker',
        'csv_generate_row_ids': 'csv_generate_row_ids',
        'resolve_existing_files': 'resolve_existing_files',
        'transaction_id': 'transactionId',
        'update_strategy': 'updateStrategy',
        'bulk_mode': 'bulkMode'
    }

    def __init__(self, table=None, path=None, records=None, format=None, load_tag=None, profile_id=None, max_bad_records=0, max_failed_file_loads=0, ignore_unknown_values=True, csv_field_delimiter=',', csv_quote='"', csv_skip_leading_rows=None, csv_allow_quoted_newlines=True, csv_null_marker='', csv_generate_row_ids=True, resolve_existing_files=False, transaction_id=None, update_strategy=None, bulk_mode=False, local_vars_configuration=None):  # noqa: E501
        """IngestRequestModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._table = None
        self._path = None
        self._records = None
        self._format = None
        self._load_tag = None
        self._profile_id = None
        self._max_bad_records = None
        self._max_failed_file_loads = None
        self._ignore_unknown_values = None
        self._csv_field_delimiter = None
        self._csv_quote = None
        self._csv_skip_leading_rows = None
        self._csv_allow_quoted_newlines = None
        self._csv_null_marker = None
        self._csv_generate_row_ids = None
        self._resolve_existing_files = None
        self._transaction_id = None
        self._update_strategy = None
        self._bulk_mode = None
        self.discriminator = None

        self.table = table
        if path is not None:
            self.path = path
        if records is not None:
            self.records = records
        self.format = format
        if load_tag is not None:
            self.load_tag = load_tag
        if profile_id is not None:
            self.profile_id = profile_id
        self.max_bad_records = max_bad_records
        self.max_failed_file_loads = max_failed_file_loads
        if ignore_unknown_values is not None:
            self.ignore_unknown_values = ignore_unknown_values
        if csv_field_delimiter is not None:
            self.csv_field_delimiter = csv_field_delimiter
        if csv_quote is not None:
            self.csv_quote = csv_quote
        if csv_skip_leading_rows is not None:
            self.csv_skip_leading_rows = csv_skip_leading_rows
        if csv_allow_quoted_newlines is not None:
            self.csv_allow_quoted_newlines = csv_allow_quoted_newlines
        if csv_null_marker is not None:
            self.csv_null_marker = csv_null_marker
        if csv_generate_row_ids is not None:
            self.csv_generate_row_ids = csv_generate_row_ids
        if resolve_existing_files is not None:
            self.resolve_existing_files = resolve_existing_files
        if transaction_id is not None:
            self.transaction_id = transaction_id
        if update_strategy is not None:
            self.update_strategy = update_strategy
        if bulk_mode is not None:
            self.bulk_mode = bulk_mode

    @property
    def table(self):
        """Gets the table of this IngestRequestModel.  # noqa: E501

        Table names follow this pattern. This should be used for the name of any non-column object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra tables the DR adds. For table names, this is shorter than what BigQuery allows.   # noqa: E501

        :return: The table of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._table

    @table.setter
    def table(self, table):
        """Sets the table of this IngestRequestModel.

        Table names follow this pattern. This should be used for the name of any non-column object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra tables the DR adds. For table names, this is shorter than what BigQuery allows.   # noqa: E501

        :param table: The table of this IngestRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and table is None:  # noqa: E501
            raise ValueError("Invalid value for `table`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                table is not None and len(table) > 63):
            raise ValueError("Invalid value for `table`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                table is not None and len(table) < 1):
            raise ValueError("Invalid value for `table`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                table is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', table)):  # noqa: E501
            raise ValueError(r"Invalid value for `table`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._table = table

    @property
    def path(self):
        """Gets the path of this IngestRequestModel.  # noqa: E501

        cloud path to a file in a bucket accessible to data repo (e.g. gs path for GCP datasets or https path for Azure datasets).  Required if the format is `csv` or `json`. Do not specify if the ingest format is `array`   # noqa: E501

        :return: The path of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this IngestRequestModel.

        cloud path to a file in a bucket accessible to data repo (e.g. gs path for GCP datasets or https path for Azure datasets).  Required if the format is `csv` or `json`. Do not specify if the ingest format is `array`   # noqa: E501

        :param path: The path of this IngestRequestModel.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def records(self):
        """Gets the records of this IngestRequestModel.  # noqa: E501

        an array of json metadata records to ingest   # noqa: E501

        :return: The records of this IngestRequestModel.  # noqa: E501
        :rtype: list[object]
        """
        return self._records

    @records.setter
    def records(self, records):
        """Sets the records of this IngestRequestModel.

        an array of json metadata records to ingest   # noqa: E501

        :param records: The records of this IngestRequestModel.  # noqa: E501
        :type: list[object]
        """

        self._records = records

    @property
    def format(self):
        """Gets the format of this IngestRequestModel.  # noqa: E501

        format of the data to ingest.  Currently supported formats are `csv`, `json`, and `array` `array` indicates loading from a JSON object payload in the records field. Note: when ingesting from a CSV file into an Azure dataset, no string or text field may be larger than 8000 bytes   # noqa: E501

        :return: The format of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this IngestRequestModel.

        format of the data to ingest.  Currently supported formats are `csv`, `json`, and `array` `array` indicates loading from a JSON object payload in the records field. Note: when ingesting from a CSV file into an Azure dataset, no string or text field may be larger than 8000 bytes   # noqa: E501

        :param format: The format of this IngestRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and format is None:  # noqa: E501
            raise ValueError("Invalid value for `format`, must not be `None`")  # noqa: E501
        allowed_values = ["csv", "json", "array"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and format not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `format` ({0}), must be one of {1}"  # noqa: E501
                .format(format, allowed_values)
            )

        self._format = format

    @property
    def load_tag(self):
        """Gets the load_tag of this IngestRequestModel.  # noqa: E501

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :return: The load_tag of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._load_tag

    @load_tag.setter
    def load_tag(self, load_tag):
        """Sets the load_tag of this IngestRequestModel.

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :param load_tag: The load_tag of this IngestRequestModel.  # noqa: E501
        :type: str
        """

        self._load_tag = load_tag

    @property
    def profile_id(self):
        """Gets the profile_id of this IngestRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The profile_id of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._profile_id

    @profile_id.setter
    def profile_id(self, profile_id):
        """Sets the profile_id of this IngestRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param profile_id: The profile_id of this IngestRequestModel.  # noqa: E501
        :type: str
        """

        self._profile_id = profile_id

    @property
    def max_bad_records(self):
        """Gets the max_bad_records of this IngestRequestModel.  # noqa: E501

        max number of bad records to skip; applies to all ingest formats  # noqa: E501

        :return: The max_bad_records of this IngestRequestModel.  # noqa: E501
        :rtype: int
        """
        return self._max_bad_records

    @max_bad_records.setter
    def max_bad_records(self, max_bad_records):
        """Sets the max_bad_records of this IngestRequestModel.

        max number of bad records to skip; applies to all ingest formats  # noqa: E501

        :param max_bad_records: The max_bad_records of this IngestRequestModel.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and max_bad_records is None:  # noqa: E501
            raise ValueError("Invalid value for `max_bad_records`, must not be `None`")  # noqa: E501

        self._max_bad_records = max_bad_records

    @property
    def max_failed_file_loads(self):
        """Gets the max_failed_file_loads of this IngestRequestModel.  # noqa: E501

        max number of failed file loads before stopping; if -1, allow any number of errors  # noqa: E501

        :return: The max_failed_file_loads of this IngestRequestModel.  # noqa: E501
        :rtype: int
        """
        return self._max_failed_file_loads

    @max_failed_file_loads.setter
    def max_failed_file_loads(self, max_failed_file_loads):
        """Sets the max_failed_file_loads of this IngestRequestModel.

        max number of failed file loads before stopping; if -1, allow any number of errors  # noqa: E501

        :param max_failed_file_loads: The max_failed_file_loads of this IngestRequestModel.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and max_failed_file_loads is None:  # noqa: E501
            raise ValueError("Invalid value for `max_failed_file_loads`, must not be `None`")  # noqa: E501

        self._max_failed_file_loads = max_failed_file_loads

    @property
    def ignore_unknown_values(self):
        """Gets the ignore_unknown_values of this IngestRequestModel.  # noqa: E501

        skip extra data; applies to all ingest formats  # noqa: E501

        :return: The ignore_unknown_values of this IngestRequestModel.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_unknown_values

    @ignore_unknown_values.setter
    def ignore_unknown_values(self, ignore_unknown_values):
        """Sets the ignore_unknown_values of this IngestRequestModel.

        skip extra data; applies to all ingest formats  # noqa: E501

        :param ignore_unknown_values: The ignore_unknown_values of this IngestRequestModel.  # noqa: E501
        :type: bool
        """

        self._ignore_unknown_values = ignore_unknown_values

    @property
    def csv_field_delimiter(self):
        """Gets the csv_field_delimiter of this IngestRequestModel.  # noqa: E501

        field separator  # noqa: E501

        :return: The csv_field_delimiter of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._csv_field_delimiter

    @csv_field_delimiter.setter
    def csv_field_delimiter(self, csv_field_delimiter):
        """Sets the csv_field_delimiter of this IngestRequestModel.

        field separator  # noqa: E501

        :param csv_field_delimiter: The csv_field_delimiter of this IngestRequestModel.  # noqa: E501
        :type: str
        """

        self._csv_field_delimiter = csv_field_delimiter

    @property
    def csv_quote(self):
        """Gets the csv_quote of this IngestRequestModel.  # noqa: E501

        quoting character  # noqa: E501

        :return: The csv_quote of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._csv_quote

    @csv_quote.setter
    def csv_quote(self, csv_quote):
        """Sets the csv_quote of this IngestRequestModel.

        quoting character  # noqa: E501

        :param csv_quote: The csv_quote of this IngestRequestModel.  # noqa: E501
        :type: str
        """

        self._csv_quote = csv_quote

    @property
    def csv_skip_leading_rows(self):
        """Gets the csv_skip_leading_rows of this IngestRequestModel.  # noqa: E501

        number of header rows to skip  # noqa: E501

        :return: The csv_skip_leading_rows of this IngestRequestModel.  # noqa: E501
        :rtype: int
        """
        return self._csv_skip_leading_rows

    @csv_skip_leading_rows.setter
    def csv_skip_leading_rows(self, csv_skip_leading_rows):
        """Sets the csv_skip_leading_rows of this IngestRequestModel.

        number of header rows to skip  # noqa: E501

        :param csv_skip_leading_rows: The csv_skip_leading_rows of this IngestRequestModel.  # noqa: E501
        :type: int
        """

        self._csv_skip_leading_rows = csv_skip_leading_rows

    @property
    def csv_allow_quoted_newlines(self):
        """Gets the csv_allow_quoted_newlines of this IngestRequestModel.  # noqa: E501


        :return: The csv_allow_quoted_newlines of this IngestRequestModel.  # noqa: E501
        :rtype: bool
        """
        return self._csv_allow_quoted_newlines

    @csv_allow_quoted_newlines.setter
    def csv_allow_quoted_newlines(self, csv_allow_quoted_newlines):
        """Sets the csv_allow_quoted_newlines of this IngestRequestModel.


        :param csv_allow_quoted_newlines: The csv_allow_quoted_newlines of this IngestRequestModel.  # noqa: E501
        :type: bool
        """

        self._csv_allow_quoted_newlines = csv_allow_quoted_newlines

    @property
    def csv_null_marker(self):
        """Gets the csv_null_marker of this IngestRequestModel.  # noqa: E501


        :return: The csv_null_marker of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._csv_null_marker

    @csv_null_marker.setter
    def csv_null_marker(self, csv_null_marker):
        """Sets the csv_null_marker of this IngestRequestModel.


        :param csv_null_marker: The csv_null_marker of this IngestRequestModel.  # noqa: E501
        :type: str
        """

        self._csv_null_marker = csv_null_marker

    @property
    def csv_generate_row_ids(self):
        """Gets the csv_generate_row_ids of this IngestRequestModel.  # noqa: E501

        Whether the data repo should generate datarepo_row_ids on CSV ingest. Defaults to true.  # noqa: E501

        :return: The csv_generate_row_ids of this IngestRequestModel.  # noqa: E501
        :rtype: bool
        """
        return self._csv_generate_row_ids

    @csv_generate_row_ids.setter
    def csv_generate_row_ids(self, csv_generate_row_ids):
        """Sets the csv_generate_row_ids of this IngestRequestModel.

        Whether the data repo should generate datarepo_row_ids on CSV ingest. Defaults to true.  # noqa: E501

        :param csv_generate_row_ids: The csv_generate_row_ids of this IngestRequestModel.  # noqa: E501
        :type: bool
        """

        self._csv_generate_row_ids = csv_generate_row_ids

    @property
    def resolve_existing_files(self):
        """Gets the resolve_existing_files of this IngestRequestModel.  # noqa: E501

        When true, the combined ingest will look for files that already exist and substitute their fileIds in instead of ingesting duplicate files.   # noqa: E501

        :return: The resolve_existing_files of this IngestRequestModel.  # noqa: E501
        :rtype: bool
        """
        return self._resolve_existing_files

    @resolve_existing_files.setter
    def resolve_existing_files(self, resolve_existing_files):
        """Sets the resolve_existing_files of this IngestRequestModel.

        When true, the combined ingest will look for files that already exist and substitute their fileIds in instead of ingesting duplicate files.   # noqa: E501

        :param resolve_existing_files: The resolve_existing_files of this IngestRequestModel.  # noqa: E501
        :type: bool
        """

        self._resolve_existing_files = resolve_existing_files

    @property
    def transaction_id(self):
        """Gets the transaction_id of this IngestRequestModel.  # noqa: E501

        If specified, the ingested data will remain invisible to users and snapshot creation until the transaction in question is committed. If the transaction is rolled back, then the changes from this ingest and any other operations using this transaction will be undone.   # noqa: E501

        :return: The transaction_id of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this IngestRequestModel.

        If specified, the ingested data will remain invisible to users and snapshot creation until the transaction in question is committed. If the transaction is rolled back, then the changes from this ingest and any other operations using this transaction will be undone.   # noqa: E501

        :param transaction_id: The transaction_id of this IngestRequestModel.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def update_strategy(self):
        """Gets the update_strategy of this IngestRequestModel.  # noqa: E501

        Approach for how to treat updates to the target table:  * `append` (GCP, Azure) - Default: only ever insert rows, regardless of whether or not the primary key value exists  * `replace` (GCP only) - If a primary key is present on the table, treat rows with matching primary keys              as updates. If duplicate IDs are found in your ingest, the ingest job              will fail. If your rows specify `datarepo_row_id`, it will be ignored and              TDR will generate new row IDs for your new records. Note: the full new              record must be specified.  * `merge` (GCP only) - If a primary key is present on the table, treat rows with matching primary keys              as partial updates. Any fields specified will overwrite their current values              in the matching table row. If your rows specify `datarepo_row_id`, it will              be ignored and TDR will generate new row IDs for your new records. Each              ingest row must match exactly one table row, and no duplicate IDs should be              found in your ingest, otherwise the ingest job will fail.   # noqa: E501

        :return: The update_strategy of this IngestRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._update_strategy

    @update_strategy.setter
    def update_strategy(self, update_strategy):
        """Sets the update_strategy of this IngestRequestModel.

        Approach for how to treat updates to the target table:  * `append` (GCP, Azure) - Default: only ever insert rows, regardless of whether or not the primary key value exists  * `replace` (GCP only) - If a primary key is present on the table, treat rows with matching primary keys              as updates. If duplicate IDs are found in your ingest, the ingest job              will fail. If your rows specify `datarepo_row_id`, it will be ignored and              TDR will generate new row IDs for your new records. Note: the full new              record must be specified.  * `merge` (GCP only) - If a primary key is present on the table, treat rows with matching primary keys              as partial updates. Any fields specified will overwrite their current values              in the matching table row. If your rows specify `datarepo_row_id`, it will              be ignored and TDR will generate new row IDs for your new records. Each              ingest row must match exactly one table row, and no duplicate IDs should be              found in your ingest, otherwise the ingest job will fail.   # noqa: E501

        :param update_strategy: The update_strategy of this IngestRequestModel.  # noqa: E501
        :type: str
        """
        allowed_values = ["append", "replace", "merge"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and update_strategy not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `update_strategy` ({0}), must be one of {1}"  # noqa: E501
                .format(update_strategy, allowed_values)
            )

        self._update_strategy = update_strategy

    @property
    def bulk_mode(self):
        """Gets the bulk_mode of this IngestRequestModel.  # noqa: E501

        If true, file ingest will be performed in bulk mode.  The tradeoff for the performance improvements are that: - the dataset will be locked exclusively - some safeguards can not be enforced during loads.  Given that, it's recommended that   you use a max_failed_file_loads value of 0 - the assumption is that file metadata must all fit into memory so configure the   deployment accordingly   # noqa: E501

        :return: The bulk_mode of this IngestRequestModel.  # noqa: E501
        :rtype: bool
        """
        return self._bulk_mode

    @bulk_mode.setter
    def bulk_mode(self, bulk_mode):
        """Sets the bulk_mode of this IngestRequestModel.

        If true, file ingest will be performed in bulk mode.  The tradeoff for the performance improvements are that: - the dataset will be locked exclusively - some safeguards can not be enforced during loads.  Given that, it's recommended that   you use a max_failed_file_loads value of 0 - the assumption is that file metadata must all fit into memory so configure the   deployment accordingly   # noqa: E501

        :param bulk_mode: The bulk_mode of this IngestRequestModel.  # noqa: E501
        :type: bool
        """

        self._bulk_mode = bulk_mode

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IngestRequestModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IngestRequestModel):
            return True

        return self.to_dict() != other.to_dict()
