# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class ProfileOwnedResourceModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'created_date': 'str',
        'type': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'created_date': 'createdDate',
        'type': 'type'
    }

    def __init__(self, id=None, name=None, description=None, created_date=None, type=None, local_vars_configuration=None):  # noqa: E501
        """ProfileOwnedResourceModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._created_date = None
        self._type = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if created_date is not None:
            self.created_date = created_date
        if type is not None:
            self.type = type

    @property
    def id(self):
        """Gets the id of this ProfileOwnedResourceModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The id of this ProfileOwnedResourceModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProfileOwnedResourceModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param id: The id of this ProfileOwnedResourceModel.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ProfileOwnedResourceModel.  # noqa: E501

        Name of the resource  # noqa: E501

        :return: The name of this ProfileOwnedResourceModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProfileOwnedResourceModel.

        Name of the resource  # noqa: E501

        :param name: The name of this ProfileOwnedResourceModel.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this ProfileOwnedResourceModel.  # noqa: E501

        Description of the resource  # noqa: E501

        :return: The description of this ProfileOwnedResourceModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ProfileOwnedResourceModel.

        Description of the resource  # noqa: E501

        :param description: The description of this ProfileOwnedResourceModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def created_date(self):
        """Gets the created_date of this ProfileOwnedResourceModel.  # noqa: E501

        Date the resource was created  # noqa: E501

        :return: The created_date of this ProfileOwnedResourceModel.  # noqa: E501
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """Sets the created_date of this ProfileOwnedResourceModel.

        Date the resource was created  # noqa: E501

        :param created_date: The created_date of this ProfileOwnedResourceModel.  # noqa: E501
        :type: str
        """

        self._created_date = created_date

    @property
    def type(self):
        """Gets the type of this ProfileOwnedResourceModel.  # noqa: E501

        Type of the resource  # noqa: E501

        :return: The type of this ProfileOwnedResourceModel.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ProfileOwnedResourceModel.

        Type of the resource  # noqa: E501

        :param type: The type of this ProfileOwnedResourceModel.  # noqa: E501
        :type: str
        """
        allowed_values = ["DATASET", "SNAPSHOT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProfileOwnedResourceModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProfileOwnedResourceModel):
            return True

        return self.to_dict() != other.to_dict()
