# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class QueryDataRequestModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'offset': 'int',
        'limit': 'int',
        'sort': 'str',
        'direction': 'SqlSortDirectionAscDefault',
        'filter': 'str'
    }

    attribute_map = {
        'offset': 'offset',
        'limit': 'limit',
        'sort': 'sort',
        'direction': 'direction',
        'filter': 'filter'
    }

    def __init__(self, offset=0, limit=30, sort='datarepo_row_id', direction=None, filter='', local_vars_configuration=None):  # noqa: E501
        """QueryDataRequestModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._offset = None
        self._limit = None
        self._sort = None
        self._direction = None
        self._filter = None
        self.discriminator = None

        if offset is not None:
            self.offset = offset
        if limit is not None:
            self.limit = limit
        if sort is not None:
            self.sort = sort
        if direction is not None:
            self.direction = direction
        if filter is not None:
            self.filter = filter

    @property
    def offset(self):
        """Gets the offset of this QueryDataRequestModel.  # noqa: E501

        The number of rows to skip when retrieving the next page  # noqa: E501

        :return: The offset of this QueryDataRequestModel.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this QueryDataRequestModel.

        The number of rows to skip when retrieving the next page  # noqa: E501

        :param offset: The offset of this QueryDataRequestModel.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                offset is not None and offset < 0):  # noqa: E501
            raise ValueError("Invalid value for `offset`, must be a value greater than or equal to `0`")  # noqa: E501

        self._offset = offset

    @property
    def limit(self):
        """Gets the limit of this QueryDataRequestModel.  # noqa: E501

        The number of rows to return for the data  # noqa: E501

        :return: The limit of this QueryDataRequestModel.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this QueryDataRequestModel.

        The number of rows to return for the data  # noqa: E501

        :param limit: The limit of this QueryDataRequestModel.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                limit is not None and limit > 1000):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                limit is not None and limit < 1):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value greater than or equal to `1`")  # noqa: E501

        self._limit = limit

    @property
    def sort(self):
        """Gets the sort of this QueryDataRequestModel.  # noqa: E501

        The table column to sort by  # noqa: E501

        :return: The sort of this QueryDataRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this QueryDataRequestModel.

        The table column to sort by  # noqa: E501

        :param sort: The sort of this QueryDataRequestModel.  # noqa: E501
        :type: str
        """

        self._sort = sort

    @property
    def direction(self):
        """Gets the direction of this QueryDataRequestModel.  # noqa: E501


        :return: The direction of this QueryDataRequestModel.  # noqa: E501
        :rtype: SqlSortDirectionAscDefault
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this QueryDataRequestModel.


        :param direction: The direction of this QueryDataRequestModel.  # noqa: E501
        :type: SqlSortDirectionAscDefault
        """

        self._direction = direction

    @property
    def filter(self):
        """Gets the filter of this QueryDataRequestModel.  # noqa: E501

        A SQL WHERE clause to filter the table results.  # noqa: E501

        :return: The filter of this QueryDataRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """Sets the filter of this QueryDataRequestModel.

        A SQL WHERE clause to filter the table results.  # noqa: E501

        :param filter: The filter of this QueryDataRequestModel.  # noqa: E501
        :type: str
        """

        self._filter = filter

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryDataRequestModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QueryDataRequestModel):
            return True

        return self.to_dict() != other.to_dict()
