# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotAccessRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'source_snapshot_id': 'str',
        'name': 'str',
        'research_purpose_statement': 'str',
        'snapshot_builder_request': 'SnapshotBuilderRequest'
    }

    attribute_map = {
        'source_snapshot_id': 'sourceSnapshotId',
        'name': 'name',
        'research_purpose_statement': 'researchPurposeStatement',
        'snapshot_builder_request': 'snapshotBuilderRequest'
    }

    def __init__(self, source_snapshot_id=None, name=None, research_purpose_statement=None, snapshot_builder_request=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotAccessRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._source_snapshot_id = None
        self._name = None
        self._research_purpose_statement = None
        self._snapshot_builder_request = None
        self.discriminator = None

        if source_snapshot_id is not None:
            self.source_snapshot_id = source_snapshot_id
        if name is not None:
            self.name = name
        if research_purpose_statement is not None:
            self.research_purpose_statement = research_purpose_statement
        if snapshot_builder_request is not None:
            self.snapshot_builder_request = snapshot_builder_request

    @property
    def source_snapshot_id(self):
        """Gets the source_snapshot_id of this SnapshotAccessRequest.  # noqa: E501


        :return: The source_snapshot_id of this SnapshotAccessRequest.  # noqa: E501
        :rtype: str
        """
        return self._source_snapshot_id

    @source_snapshot_id.setter
    def source_snapshot_id(self, source_snapshot_id):
        """Sets the source_snapshot_id of this SnapshotAccessRequest.


        :param source_snapshot_id: The source_snapshot_id of this SnapshotAccessRequest.  # noqa: E501
        :type: str
        """

        self._source_snapshot_id = source_snapshot_id

    @property
    def name(self):
        """Gets the name of this SnapshotAccessRequest.  # noqa: E501


        :return: The name of this SnapshotAccessRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotAccessRequest.


        :param name: The name of this SnapshotAccessRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def research_purpose_statement(self):
        """Gets the research_purpose_statement of this SnapshotAccessRequest.  # noqa: E501


        :return: The research_purpose_statement of this SnapshotAccessRequest.  # noqa: E501
        :rtype: str
        """
        return self._research_purpose_statement

    @research_purpose_statement.setter
    def research_purpose_statement(self, research_purpose_statement):
        """Sets the research_purpose_statement of this SnapshotAccessRequest.


        :param research_purpose_statement: The research_purpose_statement of this SnapshotAccessRequest.  # noqa: E501
        :type: str
        """

        self._research_purpose_statement = research_purpose_statement

    @property
    def snapshot_builder_request(self):
        """Gets the snapshot_builder_request of this SnapshotAccessRequest.  # noqa: E501


        :return: The snapshot_builder_request of this SnapshotAccessRequest.  # noqa: E501
        :rtype: SnapshotBuilderRequest
        """
        return self._snapshot_builder_request

    @snapshot_builder_request.setter
    def snapshot_builder_request(self, snapshot_builder_request):
        """Sets the snapshot_builder_request of this SnapshotAccessRequest.


        :param snapshot_builder_request: The snapshot_builder_request of this SnapshotAccessRequest.  # noqa: E501
        :type: SnapshotBuilderRequest
        """

        self._snapshot_builder_request = snapshot_builder_request

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotAccessRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotAccessRequest):
            return True

        return self.to_dict() != other.to_dict()
