# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotBuilderRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cohorts': 'list[SnapshotBuilderCohort]',
        'output_tables': 'list[SnapshotBuilderOutputTable]'
    }

    attribute_map = {
        'cohorts': 'cohorts',
        'output_tables': 'outputTables'
    }

    def __init__(self, cohorts=None, output_tables=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotBuilderRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._cohorts = None
        self._output_tables = None
        self.discriminator = None

        if cohorts is not None:
            self.cohorts = cohorts
        if output_tables is not None:
            self.output_tables = output_tables

    @property
    def cohorts(self):
        """Gets the cohorts of this SnapshotBuilderRequest.  # noqa: E501


        :return: The cohorts of this SnapshotBuilderRequest.  # noqa: E501
        :rtype: list[SnapshotBuilderCohort]
        """
        return self._cohorts

    @cohorts.setter
    def cohorts(self, cohorts):
        """Sets the cohorts of this SnapshotBuilderRequest.


        :param cohorts: The cohorts of this SnapshotBuilderRequest.  # noqa: E501
        :type: list[SnapshotBuilderCohort]
        """

        self._cohorts = cohorts

    @property
    def output_tables(self):
        """Gets the output_tables of this SnapshotBuilderRequest.  # noqa: E501


        :return: The output_tables of this SnapshotBuilderRequest.  # noqa: E501
        :rtype: list[SnapshotBuilderOutputTable]
        """
        return self._output_tables

    @output_tables.setter
    def output_tables(self, output_tables):
        """Sets the output_tables of this SnapshotBuilderRequest.


        :param output_tables: The output_tables of this SnapshotBuilderRequest.  # noqa: E501
        :type: list[SnapshotBuilderOutputTable]
        """

        self._output_tables = output_tables

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotBuilderRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotBuilderRequest):
            return True

        return self.to_dict() != other.to_dict()
