# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotBuilderTable(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'dataset_table_name': 'str',
        'columns': 'list[str]',
        'primary_table_relationship': 'str',
        'secondary_table_relationships': 'list[str]'
    }

    attribute_map = {
        'dataset_table_name': 'datasetTableName',
        'columns': 'columns',
        'primary_table_relationship': 'primaryTableRelationship',
        'secondary_table_relationships': 'secondaryTableRelationships'
    }

    def __init__(self, dataset_table_name=None, columns=None, primary_table_relationship=None, secondary_table_relationships=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotBuilderTable - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._dataset_table_name = None
        self._columns = None
        self._primary_table_relationship = None
        self._secondary_table_relationships = None
        self.discriminator = None

        self.dataset_table_name = dataset_table_name
        self.columns = columns
        if primary_table_relationship is not None:
            self.primary_table_relationship = primary_table_relationship
        if secondary_table_relationships is not None:
            self.secondary_table_relationships = secondary_table_relationships

    @property
    def dataset_table_name(self):
        """Gets the dataset_table_name of this SnapshotBuilderTable.  # noqa: E501


        :return: The dataset_table_name of this SnapshotBuilderTable.  # noqa: E501
        :rtype: str
        """
        return self._dataset_table_name

    @dataset_table_name.setter
    def dataset_table_name(self, dataset_table_name):
        """Sets the dataset_table_name of this SnapshotBuilderTable.


        :param dataset_table_name: The dataset_table_name of this SnapshotBuilderTable.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and dataset_table_name is None:  # noqa: E501
            raise ValueError("Invalid value for `dataset_table_name`, must not be `None`")  # noqa: E501

        self._dataset_table_name = dataset_table_name

    @property
    def columns(self):
        """Gets the columns of this SnapshotBuilderTable.  # noqa: E501


        :return: The columns of this SnapshotBuilderTable.  # noqa: E501
        :rtype: list[str]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this SnapshotBuilderTable.


        :param columns: The columns of this SnapshotBuilderTable.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and columns is None:  # noqa: E501
            raise ValueError("Invalid value for `columns`, must not be `None`")  # noqa: E501

        self._columns = columns

    @property
    def primary_table_relationship(self):
        """Gets the primary_table_relationship of this SnapshotBuilderTable.  # noqa: E501


        :return: The primary_table_relationship of this SnapshotBuilderTable.  # noqa: E501
        :rtype: str
        """
        return self._primary_table_relationship

    @primary_table_relationship.setter
    def primary_table_relationship(self, primary_table_relationship):
        """Sets the primary_table_relationship of this SnapshotBuilderTable.


        :param primary_table_relationship: The primary_table_relationship of this SnapshotBuilderTable.  # noqa: E501
        :type: str
        """

        self._primary_table_relationship = primary_table_relationship

    @property
    def secondary_table_relationships(self):
        """Gets the secondary_table_relationships of this SnapshotBuilderTable.  # noqa: E501


        :return: The secondary_table_relationships of this SnapshotBuilderTable.  # noqa: E501
        :rtype: list[str]
        """
        return self._secondary_table_relationships

    @secondary_table_relationships.setter
    def secondary_table_relationships(self, secondary_table_relationships):
        """Sets the secondary_table_relationships of this SnapshotBuilderTable.


        :param secondary_table_relationships: The secondary_table_relationships of this SnapshotBuilderTable.  # noqa: E501
        :type: list[str]
        """

        self._secondary_table_relationships = secondary_table_relationships

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotBuilderTable):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotBuilderTable):
            return True

        return self.to_dict() != other.to_dict()
