# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotRequestModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'consent_code': 'str',
        'duos_id': 'str',
        'data_access_control_groups': 'list[str]',
        'contents': 'list[SnapshotRequestContentsModel]',
        'readers': 'list[str]',
        'profile_id': 'str',
        'properties': 'object',
        'policies': 'SnapshotRequestModelPolicies',
        'global_file_ids': 'bool',
        'compact_id_prefix': 'str',
        'tags': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'consent_code': 'consentCode',
        'duos_id': 'duosId',
        'data_access_control_groups': 'dataAccessControlGroups',
        'contents': 'contents',
        'readers': 'readers',
        'profile_id': 'profileId',
        'properties': 'properties',
        'policies': 'policies',
        'global_file_ids': 'globalFileIds',
        'compact_id_prefix': 'compactIdPrefix',
        'tags': 'tags'
    }

    def __init__(self, name=None, description=None, consent_code=None, duos_id=None, data_access_control_groups=None, contents=None, readers=None, profile_id=None, properties=None, policies=None, global_file_ids=False, compact_id_prefix=None, tags=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotRequestModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._consent_code = None
        self._duos_id = None
        self._data_access_control_groups = None
        self._contents = None
        self._readers = None
        self._profile_id = None
        self._properties = None
        self._policies = None
        self._global_file_ids = None
        self._compact_id_prefix = None
        self._tags = None
        self.discriminator = None

        self.name = name
        if description is not None:
            self.description = description
        if consent_code is not None:
            self.consent_code = consent_code
        if duos_id is not None:
            self.duos_id = duos_id
        if data_access_control_groups is not None:
            self.data_access_control_groups = data_access_control_groups
        self.contents = contents
        if readers is not None:
            self.readers = readers
        if profile_id is not None:
            self.profile_id = profile_id
        if properties is not None:
            self.properties = properties
        if policies is not None:
            self.policies = policies
        if global_file_ids is not None:
            self.global_file_ids = global_file_ids
        if compact_id_prefix is not None:
            self.compact_id_prefix = compact_id_prefix
        if tags is not None:
            self.tags = tags

    @property
    def name(self):
        """Gets the name of this SnapshotRequestModel.  # noqa: E501

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :return: The name of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotRequestModel.

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :param name: The name of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 511):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `511`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this SnapshotRequestModel.  # noqa: E501

        Description of the snapshot  # noqa: E501

        :return: The description of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SnapshotRequestModel.

        Description of the snapshot  # noqa: E501

        :param description: The description of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def consent_code(self):
        """Gets the consent_code of this SnapshotRequestModel.  # noqa: E501

        Consent code together with PHS ID that will determine user access  # noqa: E501

        :return: The consent_code of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._consent_code

    @consent_code.setter
    def consent_code(self, consent_code):
        """Sets the consent_code of this SnapshotRequestModel.

        Consent code together with PHS ID that will determine user access  # noqa: E501

        :param consent_code: The consent_code of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._consent_code = consent_code

    @property
    def duos_id(self):
        """Gets the duos_id of this SnapshotRequestModel.  # noqa: E501

        DUOS dataset identifier  # noqa: E501

        :return: The duos_id of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._duos_id

    @duos_id.setter
    def duos_id(self, duos_id):
        """Sets the duos_id of this SnapshotRequestModel.

        DUOS dataset identifier  # noqa: E501

        :param duos_id: The duos_id of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._duos_id = duos_id

    @property
    def data_access_control_groups(self):
        """Gets the data_access_control_groups of this SnapshotRequestModel.  # noqa: E501

        Add data access control groups to the snapshot. The provided user groups will be registered as a group constraint policy in Terra Policy Service, and as an auth domain in Sam. *** WARNING - Once this is set it cannot be modified *** If a snapshot has data access controls, a user must have access to the resource directly (via a policy) and belong to all of its data access control groups in order to view and export the data. For example, if a user is a steward of a snapshot but is not a member of its data access control groups, Sam will prevent that user from accessing the resource.   # noqa: E501

        :return: The data_access_control_groups of this SnapshotRequestModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._data_access_control_groups

    @data_access_control_groups.setter
    def data_access_control_groups(self, data_access_control_groups):
        """Sets the data_access_control_groups of this SnapshotRequestModel.

        Add data access control groups to the snapshot. The provided user groups will be registered as a group constraint policy in Terra Policy Service, and as an auth domain in Sam. *** WARNING - Once this is set it cannot be modified *** If a snapshot has data access controls, a user must have access to the resource directly (via a policy) and belong to all of its data access control groups in order to view and export the data. For example, if a user is a steward of a snapshot but is not a member of its data access control groups, Sam will prevent that user from accessing the resource.   # noqa: E501

        :param data_access_control_groups: The data_access_control_groups of this SnapshotRequestModel.  # noqa: E501
        :type: list[str]
        """

        self._data_access_control_groups = data_access_control_groups

    @property
    def contents(self):
        """Gets the contents of this SnapshotRequestModel.  # noqa: E501


        :return: The contents of this SnapshotRequestModel.  # noqa: E501
        :rtype: list[SnapshotRequestContentsModel]
        """
        return self._contents

    @contents.setter
    def contents(self, contents):
        """Sets the contents of this SnapshotRequestModel.


        :param contents: The contents of this SnapshotRequestModel.  # noqa: E501
        :type: list[SnapshotRequestContentsModel]
        """
        if self.local_vars_configuration.client_side_validation and contents is None:  # noqa: E501
            raise ValueError("Invalid value for `contents`, must not be `None`")  # noqa: E501

        self._contents = contents

    @property
    def readers(self):
        """Gets the readers of this SnapshotRequestModel.  # noqa: E501

        Deprecated -- use `policies.readers` instead. Any readers specified here will supplement those set in `policies.readers`.   # noqa: E501

        :return: The readers of this SnapshotRequestModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._readers

    @readers.setter
    def readers(self, readers):
        """Sets the readers of this SnapshotRequestModel.

        Deprecated -- use `policies.readers` instead. Any readers specified here will supplement those set in `policies.readers`.   # noqa: E501

        :param readers: The readers of this SnapshotRequestModel.  # noqa: E501
        :type: list[str]
        """

        self._readers = readers

    @property
    def profile_id(self):
        """Gets the profile_id of this SnapshotRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The profile_id of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._profile_id

    @profile_id.setter
    def profile_id(self, profile_id):
        """Sets the profile_id of this SnapshotRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param profile_id: The profile_id of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._profile_id = profile_id

    @property
    def properties(self):
        """Gets the properties of this SnapshotRequestModel.  # noqa: E501

        Additional JSON metadata about the snapshot (this does not need to adhere to a particular schema)  # noqa: E501

        :return: The properties of this SnapshotRequestModel.  # noqa: E501
        :rtype: object
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this SnapshotRequestModel.

        Additional JSON metadata about the snapshot (this does not need to adhere to a particular schema)  # noqa: E501

        :param properties: The properties of this SnapshotRequestModel.  # noqa: E501
        :type: object
        """

        self._properties = properties

    @property
    def policies(self):
        """Gets the policies of this SnapshotRequestModel.  # noqa: E501


        :return: The policies of this SnapshotRequestModel.  # noqa: E501
        :rtype: SnapshotRequestModelPolicies
        """
        return self._policies

    @policies.setter
    def policies(self, policies):
        """Sets the policies of this SnapshotRequestModel.


        :param policies: The policies of this SnapshotRequestModel.  # noqa: E501
        :type: SnapshotRequestModelPolicies
        """

        self._policies = policies

    @property
    def global_file_ids(self):
        """Gets the global_file_ids of this SnapshotRequestModel.  # noqa: E501

        if false, the drs ids will be in the format: v1_<snapshotid>_<fileid> if true, drs ids will be in the format: v2_<fileid>   # noqa: E501

        :return: The global_file_ids of this SnapshotRequestModel.  # noqa: E501
        :rtype: bool
        """
        return self._global_file_ids

    @global_file_ids.setter
    def global_file_ids(self, global_file_ids):
        """Sets the global_file_ids of this SnapshotRequestModel.

        if false, the drs ids will be in the format: v1_<snapshotid>_<fileid> if true, drs ids will be in the format: v2_<fileid>   # noqa: E501

        :param global_file_ids: The global_file_ids of this SnapshotRequestModel.  # noqa: E501
        :type: bool
        """

        self._global_file_ids = global_file_ids

    @property
    def compact_id_prefix(self):
        """Gets the compact_id_prefix of this SnapshotRequestModel.  # noqa: E501

        if present, the drs URIs will be rendered using the compact id format (drs://<compactIdPrefix>:<drsId>) instead of the original format (drs://<hostname>/<drsId>).  The format is [A-Za-z0-9._] and the prefix must be registered at identifiers.org   # noqa: E501

        :return: The compact_id_prefix of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._compact_id_prefix

    @compact_id_prefix.setter
    def compact_id_prefix(self, compact_id_prefix):
        """Sets the compact_id_prefix of this SnapshotRequestModel.

        if present, the drs URIs will be rendered using the compact id format (drs://<compactIdPrefix>:<drsId>) instead of the original format (drs://<hostname>/<drsId>).  The format is [A-Za-z0-9._] and the prefix must be registered at identifiers.org   # noqa: E501

        :param compact_id_prefix: The compact_id_prefix of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._compact_id_prefix = compact_id_prefix

    @property
    def tags(self):
        """Gets the tags of this SnapshotRequestModel.  # noqa: E501

        Tags to add to the resource on its creation.  User-inputted tags will be stripped of leading and trailing whitespace, filtered of empty elements, and deduplicated.   # noqa: E501

        :return: The tags of this SnapshotRequestModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this SnapshotRequestModel.

        Tags to add to the resource on its creation.  User-inputted tags will be stripped of leading and trailing whitespace, filtered of empty elements, and deduplicated.   # noqa: E501

        :param tags: The tags of this SnapshotRequestModel.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotRequestModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotRequestModel):
            return True

        return self.to_dict() != other.to_dict()
