# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotRequestModelPolicies(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'stewards': 'list[str]',
        'readers': 'list[str]',
        'discoverers': 'list[str]',
        'aggregate_data_readers': 'list[str]'
    }

    attribute_map = {
        'stewards': 'stewards',
        'readers': 'readers',
        'discoverers': 'discoverers',
        'aggregate_data_readers': 'aggregateDataReaders'
    }

    def __init__(self, stewards=None, readers=None, discoverers=None, aggregate_data_readers=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotRequestModelPolicies - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._stewards = None
        self._readers = None
        self._discoverers = None
        self._aggregate_data_readers = None
        self.discriminator = None

        if stewards is not None:
            self.stewards = stewards
        if readers is not None:
            self.readers = readers
        if discoverers is not None:
            self.discoverers = discoverers
        if aggregate_data_readers is not None:
            self.aggregate_data_readers = aggregate_data_readers

    @property
    def stewards(self):
        """Gets the stewards of this SnapshotRequestModelPolicies.  # noqa: E501


        :return: The stewards of this SnapshotRequestModelPolicies.  # noqa: E501
        :rtype: list[str]
        """
        return self._stewards

    @stewards.setter
    def stewards(self, stewards):
        """Sets the stewards of this SnapshotRequestModelPolicies.


        :param stewards: The stewards of this SnapshotRequestModelPolicies.  # noqa: E501
        :type: list[str]
        """

        self._stewards = stewards

    @property
    def readers(self):
        """Gets the readers of this SnapshotRequestModelPolicies.  # noqa: E501


        :return: The readers of this SnapshotRequestModelPolicies.  # noqa: E501
        :rtype: list[str]
        """
        return self._readers

    @readers.setter
    def readers(self, readers):
        """Sets the readers of this SnapshotRequestModelPolicies.


        :param readers: The readers of this SnapshotRequestModelPolicies.  # noqa: E501
        :type: list[str]
        """

        self._readers = readers

    @property
    def discoverers(self):
        """Gets the discoverers of this SnapshotRequestModelPolicies.  # noqa: E501


        :return: The discoverers of this SnapshotRequestModelPolicies.  # noqa: E501
        :rtype: list[str]
        """
        return self._discoverers

    @discoverers.setter
    def discoverers(self, discoverers):
        """Sets the discoverers of this SnapshotRequestModelPolicies.


        :param discoverers: The discoverers of this SnapshotRequestModelPolicies.  # noqa: E501
        :type: list[str]
        """

        self._discoverers = discoverers

    @property
    def aggregate_data_readers(self):
        """Gets the aggregate_data_readers of this SnapshotRequestModelPolicies.  # noqa: E501


        :return: The aggregate_data_readers of this SnapshotRequestModelPolicies.  # noqa: E501
        :rtype: list[str]
        """
        return self._aggregate_data_readers

    @aggregate_data_readers.setter
    def aggregate_data_readers(self, aggregate_data_readers):
        """Sets the aggregate_data_readers of this SnapshotRequestModelPolicies.


        :param aggregate_data_readers: The aggregate_data_readers of this SnapshotRequestModelPolicies.  # noqa: E501
        :type: list[str]
        """

        self._aggregate_data_readers = aggregate_data_readers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotRequestModelPolicies):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotRequestModelPolicies):
            return True

        return self.to_dict() != other.to_dict()
