# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class UpgradeResponseModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'upgrade_name': 'str',
        'start_time': 'str',
        'end_time': 'str'
    }

    attribute_map = {
        'upgrade_name': 'upgradeName',
        'start_time': 'startTime',
        'end_time': 'endTime'
    }

    def __init__(self, upgrade_name=None, start_time=None, end_time=None, local_vars_configuration=None):  # noqa: E501
        """UpgradeResponseModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._upgrade_name = None
        self._start_time = None
        self._end_time = None
        self.discriminator = None

        if upgrade_name is not None:
            self.upgrade_name = upgrade_name
        if start_time is not None:
            self.start_time = start_time
        if end_time is not None:
            self.end_time = end_time

    @property
    def upgrade_name(self):
        """Gets the upgrade_name of this UpgradeResponseModel.  # noqa: E501

        Unique name for the upgrade  # noqa: E501

        :return: The upgrade_name of this UpgradeResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._upgrade_name

    @upgrade_name.setter
    def upgrade_name(self, upgrade_name):
        """Sets the upgrade_name of this UpgradeResponseModel.

        Unique name for the upgrade  # noqa: E501

        :param upgrade_name: The upgrade_name of this UpgradeResponseModel.  # noqa: E501
        :type: str
        """

        self._upgrade_name = upgrade_name

    @property
    def start_time(self):
        """Gets the start_time of this UpgradeResponseModel.  # noqa: E501

        Timestamp the upgrade was started  # noqa: E501

        :return: The start_time of this UpgradeResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this UpgradeResponseModel.

        Timestamp the upgrade was started  # noqa: E501

        :param start_time: The start_time of this UpgradeResponseModel.  # noqa: E501
        :type: str
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this UpgradeResponseModel.  # noqa: E501

        Timestamp the upgrade completed  # noqa: E501

        :return: The end_time of this UpgradeResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this UpgradeResponseModel.

        Timestamp the upgrade completed  # noqa: E501

        :param end_time: The end_time of this UpgradeResponseModel.  # noqa: E501
        :type: str
        """

        self._end_time = end_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpgradeResponseModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpgradeResponseModel):
            return True

        return self.to_dict() != other.to_dict()
