"""
Autogenerated from API functions.

Do not modify manually.
"""
# ruff: noqa: F401
# pyright: reportReturnType=false
# pyright: reportUnusedImport=false
# pyright: reportUnusedParameter=false

from . import (
    AgentType,
    CellInfo,
    Direction,
    Location,
    Rubble,
    Survivor,
    Team,
)


def get_round_number() -> int:
    """Return the current round number."""


def get_id() -> int:
    """Return the id of the agent."""


def get_type() -> AgentType:
    """Return the type of the agent."""


def get_team() -> Team:
    """Return the current team of the agent."""


def get_location() -> Location:
    """Return the current location of the agent."""


def get_energy_level() -> int:
    """Return the current energy level of the agent."""


def move(direction: Direction) -> None:
    """
    Move the agent in the specified direction.

    Args:
        direction: The direction in which the agent should move.

    Raises:
        AgentError: If the move is invalid.

    """


def save() -> None:
    """
    Save a survivor located at the agent's current location.

    If no survivor is present, the function has no effect.

    Raises:
        AgentError: If saving is invalid according to game rules.

    """


def recharge() -> None:
    """
    Recharge the agent's energy if on a charging cell.

    Energy restored is equal to `Constants.NORMAL_CHARGE` per recharge,
    but cannot exceed `Constants.MAX_ENERGY_LEVEL`.

    Does nothing if the agent is not on a charging cell.

    """


def dig() -> None:
    """
    Dig rubble at the agent's current location.

    Raises:
        AgentError: If digging is invalid according to game rules.

    """


def drone_scan(loc: Location) -> None:
    """
    Scan a location using a drone.

    Args:
        loc: The location to scan.

    Raises:
        AgentError: If drone scan is not enabled or location is invalid.

    """


def get_cell_info_at(loc: Location) -> CellInfo:
    """
    Return the cell info at a given location.

    If the location is adjacent (1 tile away) to the agent or has been scanned by a drone,
    all layers and agents at that location are visible. Otherwise, only the top layer is
    visible and agent presence is hidden.

    If `HIDDEN_MOVE_COSTS` feature is enabled, unvisited cells have `move_cost = 1`.

    Args:
        loc: The location to query.

    Returns:
        Information about the cell at the given location.

    """


def log(*args: object) -> None:
    """
    Log a message.

    Args:
        *args: One or more items to log.

    """


def on_map(loc: Location) -> bool:
    """
    Check whether a location is within the bounds of the world.

    Args:
        loc: The location to check.

    Returns:
        True if the location is on the map, False otherwise.

    """


def get_survs() -> list[Location]:
    """Return a list of survivor locations."""


def get_charging_cells() -> list[Location]:
    """Return a list of charging locations."""
