import os
import subprocess
import platform

def make_name_caden(name: str):
    return "caden"

def showInstallHook():
    try:
        log_path = os.path.join(os.getcwd(), "cadens_install_log.txt")
        with open(log_path, "w") as f:
            f.write("cadens_package simulated install hook triggered.\n")
        print(f"[cadens_package] Wrote log to {log_path}")
    except Exception as e:
        print(f"[cadens_package] Failed to write log: {e}")

def commandExecution():
    try:
        print("[cadens_package] Simulating command execution: running 'ls'")

        result = subprocess.run(
            ["ls"],
            capture_output=True,
            text=True
        )
        
        command_log = os.path.join(os.getcwd(), "cadens_command_output.txt")
        with open(command_log, "w") as f:
            f.write("Simulated command executed: ls\n")
            f.write("Output:\n")
            f.write(result.stdout)

        print(f"[cadens_package] Command output saved to {command_log}")

    except Exception as e:
        print(f"[cadens_package] Error during command simulation: {e}")

def persistCommands_macos_linux():
    try:
        home = os.path.expanduser("~")

        # Determine which shell config file to edit
        zshrc = os.path.join(home, ".zshrc")
        bashrc = os.path.join(home, ".bashrc")

        if os.path.exists(zshrc):
            target_file = zshrc
        elif os.path.exists(bashrc):
            target_file = bashrc
        else:
            # Default to .zshrc if neither exists
            target_file = zshrc

        persistence_line = (
            "\n# [cadens_package] MITRE T1547.001 persistence demo\n"
            "echo '[cadens_package] persistence hook executed.'\n"
        )

        with open(target_file, "a") as f:
            f.write(persistence_line)

        print(f"[cadens_package] Persistence simulated via {target_file}")

    except Exception as e:
        print(f"[cadens_package] Failed to simulate persistence on macOS/Linux: {e}")


def persistCommands_windows():
    try:
        profile_path = os.path.expanduser(
            "~/Documents/WindowsPowerShell/Microsoft.PowerShell_profile.ps1"
        )

        os.makedirs(os.path.dirname(profile_path), exist_ok=True)

        persistence_line = (
            "\n# [cadens_package] MITRE T1547.001 persistence demo\n"
            "Write-Output '[cadens_package] persistence hook executed.'\n"
        )

        with open(profile_path, "a") as f:
            f.write(persistence_line)

        print(f"[cadens_package] Persistence simulated via PowerShell profile:\n{profile_path}")

    except Exception as e:
        print(f"[cadens_package] Failed to simulate persistence on Windows: {e}")


def persistCommands():
    current_os = platform.system()

    print(f"[cadens_package] Detected OS: {current_os}")

    if current_os == "Windows":
        persistCommands_windows()
    elif current_os in ["Darwin", "Linux"]:
        persistCommands_macos_linux()
    else:
        print("[cadens_package] Unsupported OS for this demo.")



