# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from lakefs_sdk.models.statement import Statement

class Policy(BaseModel):
    """
    Policy
    """
    id: StrictStr = Field(...)
    creation_date: Optional[StrictInt] = Field(None, description="Unix Epoch in seconds")
    statement: conlist(Statement, min_items=1) = Field(...)
    __properties = ["id", "creation_date", "statement"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Policy:
        """Create an instance of Policy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in statement (list)
        _items = []
        if self.statement:
            for _item in self.statement:
                if _item:
                    _items.append(_item.to_dict())
            _dict['statement'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Policy:
        """Create an instance of Policy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Policy.parse_obj(obj)

        _obj = Policy.parse_obj({
            "id": obj.get("id"),
            "creation_date": obj.get("creation_date"),
            "statement": [Statement.from_dict(_item) for _item in obj.get("statement")] if obj.get("statement") is not None else None
        })
        return _obj


