# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



try:
    from pydantic.v1 import BaseModel, Field, StrictStr
except ImportError:
    from pydantic import BaseModel, Field, StrictStr
from lakefs_sdk.models.copy_part_source import CopyPartSource

class UploadPartCopyFrom(BaseModel):
    """
    UploadPartCopyFrom
    """
    physical_address: StrictStr = Field(..., description="The physical address (of the entire intended object) returned from createPresignMultipartUpload. ")
    copy_source: CopyPartSource = Field(...)
    __properties = ["physical_address", "copy_source"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UploadPartCopyFrom:
        """Create an instance of UploadPartCopyFrom from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of copy_source
        if self.copy_source:
            _dict['copy_source'] = self.copy_source.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UploadPartCopyFrom:
        """Create an instance of UploadPartCopyFrom from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UploadPartCopyFrom.parse_obj(obj)

        _obj = UploadPartCopyFrom.parse_obj({
            "physical_address": obj.get("physical_address"),
            "copy_source": CopyPartSource.from_dict(obj.get("copy_source")) if obj.get("copy_source") is not None else None
        })
        return _obj


