# Documentation [![documentation](https://readthedocs.org/projects/spatial-model-editor/badge/)](https://spatial-model-editor.readthedocs.io/en/stable/)

- user documentation is written in [reStructuredText](https://www.sphinx-doc.org/en/master/usage/restructuredtext/basics.html) format

- `sme` Python API documentation is generated from the [Google style Docstrings](https://www.sphinx-doc.org/en/master/usage/extensions/example_google.html#example-google)

- `core` C++ documentation is generated from the [Doxygen documentation](https://www.doxygen.nl/index.html)

- documentation should be updated along with source code changes in pull requests

## Read the Docs

- on each commit, docs are automatically compiled and uploaded to [readthedocs](https://spatial-model-editor.readthedocs.io/)

- note: `sme` API documentation is generated by readthedocs from the [latest](https://github.com/spatial-model-editor/spatial-model-editor/releases/tag/latest) pre-release `sme` module

- open pull request docs are also compiled and can be previewed on readthedocs

## Animated screenshots

- the quickstart guide contains animated screenshots in `apng` format

- [peek.sh](peek.sh) is a simple script to help record these using [peek](https://github.com/phw/peek) (on linux)
