# Tests

## C++ tests

The C++ tests are located in the same place as the corresponding source files:
each component `X` has
- a header file `X.hpp`
- a source file `X.cpp`
- a tests source file `X_t.cpp`.

They can be executed using CTest:

- Run default core tests (excludes gui tests, uses all cpu cores)
  - `make test`
- Run all tests using up to 24 threads
  - `ctest -j 24`

Alternatively you can get more output and control over which tests to run by directly running the
Catch2 test executable and passing it command line arguments.

For example to exclude tests tagged with `[gui]`, show successful tests results (`-s`), and abort at the first failed test (`-a`):

```
./test/tests -as "~[gui]"
```

Or to list (without running) all tests that are tagged `[simulate]` and not tagged `[gui]`:

```
./test/tests -l "[simulate]~[gui]"
```

See the Catch2 [command-line documentation](https://github.com/catchorg/Catch2/blob/master/docs/command-line.md#top) for more options.

Note: currently the GUI tests are only tested in CI on linux,
and the mouse and keyboard should not be used while the tests are running,
as this can interfere with the simulated mouse and keyboard events generated by the test.

Any tests that are tagged `[gui]` will not run in parallel with any other tests with this tag.
Any tests that are tagged `[expensive]` are not ran in the debug/coverage CI builds.

## Python tests

The python tests are in [../sme/test](../sme/test), and can be ran from this directory with

```
python -m pytest -v
```

The Docstrings also contain example code snippets along with the expected output in doctest format,
which can be tested with

```
python sme_doctest.py -v
```
