"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.14
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.admin_status import AdminStatus
from agilicus_api.model.agent_connector import AgentConnector
from agilicus_api.model.agent_connector_dynamic_stats import AgentConnectorDynamicStats
from agilicus_api.model.agent_connector_info import AgentConnectorInfo
from agilicus_api.model.agent_connector_instance import AgentConnectorInstance
from agilicus_api.model.agent_connector_proxy import AgentConnectorProxy
from agilicus_api.model.agent_connector_queue import AgentConnectorQueue
from agilicus_api.model.agent_connector_queue_response import AgentConnectorQueueResponse
from agilicus_api.model.agent_connector_stats import AgentConnectorStats
from agilicus_api.model.agent_local_auth_info import AgentLocalAuthInfo
from agilicus_api.model.applied_connector_stats_config import AppliedConnectorStatsConfig
from agilicus_api.model.csr_reason_enum import CSRReasonEnum
from agilicus_api.model.cert_signing_req import CertSigningReq
from agilicus_api.model.configure_connector_stats_publishing_request import ConfigureConnectorStatsPublishingRequest
from agilicus_api.model.connector import Connector
from agilicus_api.model.connector_secure_transfer import ConnectorSecureTransfer
from agilicus_api.model.connector_service import ConnectorService
from agilicus_api.model.encrypted_data import EncryptedData
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.ipsec_connector import IpsecConnector
from agilicus_api.model.list_agent_connector_instance_response import ListAgentConnectorInstanceResponse
from agilicus_api.model.list_agent_connector_proxy_response import ListAgentConnectorProxyResponse
from agilicus_api.model.list_agent_connector_response import ListAgentConnectorResponse
from agilicus_api.model.list_cert_signing_req_response import ListCertSigningReqResponse
from agilicus_api.model.list_connector_response import ListConnectorResponse
from agilicus_api.model.list_connector_secure_transfer_response import ListConnectorSecureTransferResponse
from agilicus_api.model.list_connector_service_response import ListConnectorServiceResponse
from agilicus_api.model.list_connector_stats_response import ListConnectorStatsResponse
from agilicus_api.model.list_guid_metadata_response import ListGuidMetadataResponse
from agilicus_api.model.list_ipsec_connector_response import ListIpsecConnectorResponse
from agilicus_api.model.usage_metrics import UsageMetrics


class ConnectorsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_agent_connector(
            self,
            agent_connector,
            **kwargs
        ):
            """Create an agent connector  # noqa: E501

            Create an agent connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_agent_connector(agent_connector, async_req=True)
            >>> result = thread.get()

            Args:
                agent_connector (AgentConnector):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['agent_connector'] = \
                agent_connector
            return self.call_with_http_info(**kwargs)

        if self.create_agent_connector is None:
            self.create_agent_connector = _Endpoint(
                settings={
                    'response_type': (AgentConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors',
                    'operation_id': 'create_agent_connector',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'agent_connector',
                    ],
                    'required': [
                        'agent_connector',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'agent_connector':
                            (AgentConnector,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'agent_connector': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_agent_connector
            )

        def __create_agent_csr(
            self,
            connector_id,
            cert_signing_req,
            **kwargs
        ):
            """Creates a CertSigningReq  # noqa: E501

            Creates a CertSigningReq   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_agent_csr(connector_id, cert_signing_req, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                cert_signing_req (CertSigningReq):

            Keyword Args:
                private_key_id (str): query by private key id. [optional]
                target_issuer ([str]): A list of target issuers to search for. If an item matches an entry in the list, is returned. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CertSigningReq
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['cert_signing_req'] = \
                cert_signing_req
            return self.call_with_http_info(**kwargs)

        if self.create_agent_csr is None:
            self.create_agent_csr = _Endpoint(
                settings={
                    'response_type': (CertSigningReq,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/certificate_signing_requests',
                    'operation_id': 'create_agent_csr',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'cert_signing_req',
                        'private_key_id',
                        'target_issuer',
                    ],
                    'required': [
                        'connector_id',
                        'cert_signing_req',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'cert_signing_req':
                            (CertSigningReq,),
                        'private_key_id':
                            (str,),
                        'target_issuer':
                            ([str],),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'private_key_id': 'private_key_id',
                        'target_issuer': 'target_issuer',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'cert_signing_req': 'body',
                        'private_key_id': 'query',
                        'target_issuer': 'query',
                    },
                    'collection_format_map': {
                        'target_issuer': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_agent_csr
            )

        def __create_agent_stats(
            self,
            connector_id,
            agent_connector_stats,
            **kwargs
        ):
            """Creates an AgentConnectorStats record.  # noqa: E501

            Publishes the most recent stats collected by the AgentConnector. Currently only the most recent AgentCollectorStats is retained, but in the future some history may be recorded.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_agent_stats(connector_id, agent_connector_stats, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                agent_connector_stats (AgentConnectorStats):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorStats
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['agent_connector_stats'] = \
                agent_connector_stats
            return self.call_with_http_info(**kwargs)

        if self.create_agent_stats is None:
            self.create_agent_stats = _Endpoint(
                settings={
                    'response_type': (AgentConnectorStats,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/stats',
                    'operation_id': 'create_agent_stats',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'agent_connector_stats',
                    ],
                    'required': [
                        'connector_id',
                        'agent_connector_stats',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'agent_connector_stats':
                            (AgentConnectorStats,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'agent_connector_stats': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_agent_stats
            )

        def __create_configure_publishing_request(
            self,
            configure_connector_stats_publishing_request,
            **kwargs
        ):
            """Configure stats publishing for a group of connectors  # noqa: E501

            Applies the provided publishing configuration to a group of connectors.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_configure_publishing_request(configure_connector_stats_publishing_request, async_req=True)
            >>> result = thread.get()

            Args:
                configure_connector_stats_publishing_request (ConfigureConnectorStatsPublishingRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConfigureConnectorStatsPublishingRequest
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['configure_connector_stats_publishing_request'] = \
                configure_connector_stats_publishing_request
            return self.call_with_http_info(**kwargs)

        if self.create_configure_publishing_request is None:
            self.create_configure_publishing_request = _Endpoint(
                settings={
                    'response_type': (ConfigureConnectorStatsPublishingRequest,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/stats/configure_publishing',
                    'operation_id': 'create_configure_publishing_request',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'configure_connector_stats_publishing_request',
                    ],
                    'required': [
                        'configure_connector_stats_publishing_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'configure_connector_stats_publishing_request':
                            (ConfigureConnectorStatsPublishingRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'configure_connector_stats_publishing_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_configure_publishing_request
            )

        def __create_connector_proxy(
            self,
            agent_connector_proxy,
            **kwargs
        ):
            """Creates a connector proxy  # noqa: E501

            Creates a connector proxy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_connector_proxy(agent_connector_proxy, async_req=True)
            >>> result = thread.get()

            Args:
                agent_connector_proxy (AgentConnectorProxy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorProxy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['agent_connector_proxy'] = \
                agent_connector_proxy
            return self.call_with_http_info(**kwargs)

        if self.create_connector_proxy is None:
            self.create_connector_proxy = _Endpoint(
                settings={
                    'response_type': (AgentConnectorProxy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/proxies',
                    'operation_id': 'create_connector_proxy',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'agent_connector_proxy',
                    ],
                    'required': [
                        'agent_connector_proxy',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'agent_connector_proxy':
                            (AgentConnectorProxy,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'agent_connector_proxy': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_connector_proxy
            )

        def __create_csr(
            self,
            cert_signing_req,
            **kwargs
        ):
            """Creates a CertSigningReq  # noqa: E501

            Creates a CertSigningReq   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_csr(cert_signing_req, async_req=True)
            >>> result = thread.get()

            Args:
                cert_signing_req (CertSigningReq):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CertSigningReq
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['cert_signing_req'] = \
                cert_signing_req
            return self.call_with_http_info(**kwargs)

        if self.create_csr is None:
            self.create_csr = _Endpoint(
                settings={
                    'response_type': (CertSigningReq,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificate_signing_requests',
                    'operation_id': 'create_csr',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'cert_signing_req',
                    ],
                    'required': [
                        'cert_signing_req',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'cert_signing_req':
                            (CertSigningReq,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'cert_signing_req': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_csr
            )

        def __create_instance(
            self,
            connector_id,
            agent_connector_instance,
            **kwargs
        ):
            """Creates an AgentConnectorInstance  # noqa: E501

            Create an AgentConnectorInstance of an AgentConnector   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_instance(connector_id, agent_connector_instance, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                agent_connector_instance (AgentConnectorInstance):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['agent_connector_instance'] = \
                agent_connector_instance
            return self.call_with_http_info(**kwargs)

        if self.create_instance is None:
            self.create_instance = _Endpoint(
                settings={
                    'response_type': (AgentConnectorInstance,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/instances',
                    'operation_id': 'create_instance',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'agent_connector_instance',
                    ],
                    'required': [
                        'connector_id',
                        'agent_connector_instance',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'agent_connector_instance':
                            (AgentConnectorInstance,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'agent_connector_instance': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_instance
            )

        def __create_ipsec_connector(
            self,
            ipsec_connector,
            **kwargs
        ):
            """Create an IPsec connector  # noqa: E501

            Create an IPsec connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_ipsec_connector(ipsec_connector, async_req=True)
            >>> result = thread.get()

            Args:
                ipsec_connector (IpsecConnector):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IpsecConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['ipsec_connector'] = \
                ipsec_connector
            return self.call_with_http_info(**kwargs)

        if self.create_ipsec_connector is None:
            self.create_ipsec_connector = _Endpoint(
                settings={
                    'response_type': (IpsecConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ipsec_connectors',
                    'operation_id': 'create_ipsec_connector',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'ipsec_connector',
                    ],
                    'required': [
                        'ipsec_connector',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'ipsec_connector':
                            (IpsecConnector,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'ipsec_connector': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_ipsec_connector
            )

        def __create_queue(
            self,
            connector_id,
            agent_connector_queue,
            **kwargs
        ):
            """Creates an AgentConnectorQueue for receiving updates.  # noqa: E501

            Agent Connectors are notified on changes to its configuration via a AMQ Stomp queue.  The agent connector may create queues for various purposes, such as receiving notifications about configuration updates.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_queue(connector_id, agent_connector_queue, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                agent_connector_queue (AgentConnectorQueue):

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorQueue
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['agent_connector_queue'] = \
                agent_connector_queue
            return self.call_with_http_info(**kwargs)

        if self.create_queue is None:
            self.create_queue = _Endpoint(
                settings={
                    'response_type': (AgentConnectorQueue,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/queues',
                    'operation_id': 'create_queue',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'agent_connector_queue',
                        'limit',
                        'page_at_id',
                    ],
                    'required': [
                        'connector_id',
                        'agent_connector_queue',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'agent_connector_queue':
                            (AgentConnectorQueue,),
                        'limit':
                            (int,),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'limit': 'limit',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'agent_connector_queue': 'body',
                        'limit': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_queue
            )

        def __create_service(
            self,
            connector_id,
            connector_service,
            **kwargs
        ):
            """Creates an ConnectorServices  # noqa: E501

            Create an ConnectorService of an Connector   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_service(connector_id, connector_service, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                connector_service (ConnectorService):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectorService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['connector_service'] = \
                connector_service
            return self.call_with_http_info(**kwargs)

        if self.create_service is None:
            self.create_service = _Endpoint(
                settings={
                    'response_type': (ConnectorService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/services',
                    'operation_id': 'create_service',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'connector_service',
                    ],
                    'required': [
                        'connector_id',
                        'connector_service',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'connector_service':
                            (ConnectorService,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'connector_service': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_service
            )

        def __create_transfer(
            self,
            connector_id,
            connector_secure_transfer,
            **kwargs
        ):
            """Creates an ConnectorSecureTransfer  # noqa: E501

            Create an ConnectorSecureTransfer of an Connector   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_transfer(connector_id, connector_secure_transfer, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                connector_secure_transfer (ConnectorSecureTransfer):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectorSecureTransfer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['connector_secure_transfer'] = \
                connector_secure_transfer
            return self.call_with_http_info(**kwargs)

        if self.create_transfer is None:
            self.create_transfer = _Endpoint(
                settings={
                    'response_type': (ConnectorSecureTransfer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/secure_transfers',
                    'operation_id': 'create_transfer',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'connector_secure_transfer',
                    ],
                    'required': [
                        'connector_id',
                        'connector_secure_transfer',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'connector_secure_transfer':
                            (ConnectorSecureTransfer,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'connector_secure_transfer': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_transfer
            )

        def __delete_agent_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Delete a agent  # noqa: E501

            Delete a agent  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_agent_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.delete_agent_connector is None:
            self.delete_agent_connector = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}',
                    'operation_id': 'delete_agent_connector',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_agent_connector
            )

        def __delete_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Delete a connector  # noqa: E501

            Delete a connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.delete_connector is None:
            self.delete_connector = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}',
                    'operation_id': 'delete_connector',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_connector
            )

        def __delete_connector_queue(
            self,
            connector_id,
            queue_id,
            **kwargs
        ):
            """Delete a connector queue  # noqa: E501

            Delete a connector queue  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_connector_queue(connector_id, queue_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                queue_id (str): queue id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['queue_id'] = \
                queue_id
            return self.call_with_http_info(**kwargs)

        if self.delete_connector_queue is None:
            self.delete_connector_queue = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/queues/{queue_id}',
                    'operation_id': 'delete_connector_queue',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'queue_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'queue_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'queue_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'queue_id': 'queue_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'queue_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_connector_queue
            )

        def __delete_instance(
            self,
            connector_id,
            connector_instance_id,
            **kwargs
        ):
            """delete_instance  # noqa: E501

            Delete an agent connector instance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_instance(connector_id, connector_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                connector_instance_id (str): connector instance id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['connector_instance_id'] = \
                connector_instance_id
            return self.call_with_http_info(**kwargs)

        if self.delete_instance is None:
            self.delete_instance = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/instances/{connector_instance_id}',
                    'operation_id': 'delete_instance',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'connector_instance_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'connector_instance_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'connector_instance_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'connector_instance_id': 'connector_instance_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'connector_instance_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_instance
            )

        def __delete_ipsec_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Delete an IPsec connector  # noqa: E501

            Delete an IPsec connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_ipsec_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.delete_ipsec_connector is None:
            self.delete_ipsec_connector = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ipsec_connectors/{connector_id}',
                    'operation_id': 'delete_ipsec_connector',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_ipsec_connector
            )

        def __delete_proxy(
            self,
            connector_proxy_id,
            **kwargs
        ):
            """delete_proxy  # noqa: E501

            Delete an AgentConnectorProxy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_proxy(connector_proxy_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_proxy_id (str): connector proxy id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_proxy_id'] = \
                connector_proxy_id
            return self.call_with_http_info(**kwargs)

        if self.delete_proxy is None:
            self.delete_proxy = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/proxies/{connector_proxy_id}',
                    'operation_id': 'delete_proxy',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_proxy_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_proxy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_proxy_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_proxy_id': 'connector_proxy_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_proxy_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_proxy
            )

        def __delete_service(
            self,
            connector_id,
            connector_service,
            **kwargs
        ):
            """Delete a connector service  # noqa: E501

            Delete a connector service  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_service(connector_id, connector_service, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                connector_service (str): connector service path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['connector_service'] = \
                connector_service
            return self.call_with_http_info(**kwargs)

        if self.delete_service is None:
            self.delete_service = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/services/{connector_service}',
                    'operation_id': 'delete_service',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'connector_service',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'connector_service',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'connector_service':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'connector_service': 'connector_service',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'connector_service': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_service
            )

        def __delete_transfer(
            self,
            connector_id,
            transfer_id,
            **kwargs
        ):
            """delete_transfer  # noqa: E501

            Delete an ConnectorSecureTransfer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_transfer(connector_id, transfer_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                transfer_id (str): connector id secure transfer id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['transfer_id'] = \
                transfer_id
            return self.call_with_http_info(**kwargs)

        if self.delete_transfer is None:
            self.delete_transfer = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/secure_transfers/{transfer_id}',
                    'operation_id': 'delete_transfer',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'transfer_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'transfer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'transfer_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'transfer_id': 'transfer_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'transfer_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_transfer
            )

        def __get_agent_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Get an agent  # noqa: E501

            Get an agent  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_agent_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_agent_connector is None:
            self.get_agent_connector = _Endpoint(
                settings={
                    'response_type': (AgentConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}',
                    'operation_id': 'get_agent_connector',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_agent_connector
            )

        def __get_agent_connector_dynamic_stats(
            self,
            connector_id,
            **kwargs
        ):
            """Get the AgentConnector dynamic stats for many instances  # noqa: E501

            Gets the most recent dynamic stats published by the AgentConnector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_agent_connector_dynamic_stats(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                collected_by (datetime): Restrict stats to those collected since this value. Stats collected prior to this date and time are skipped. This has been deprecated because its meaning was reversed from its name. Use `collected_since` instead. . [optional]
                collected_since (datetime): Restrict stats to those collected since this value. Stats collected prior to this date and time are skipped. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorDynamicStats
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_agent_connector_dynamic_stats is None:
            self.get_agent_connector_dynamic_stats = _Endpoint(
                settings={
                    'response_type': (AgentConnectorDynamicStats,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/dynamic_stats',
                    'operation_id': 'get_agent_connector_dynamic_stats',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                        'collected_by',
                        'collected_since',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                        'collected_by':
                            (datetime,),
                        'collected_since':
                            (datetime,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                        'collected_by': 'collected_by',
                        'collected_since': 'collected_since',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                        'collected_by': 'query',
                        'collected_since': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_agent_connector_dynamic_stats
            )

        def __get_agent_csr(
            self,
            connector_id,
            csr_id,
            **kwargs
        ):
            """Update a CertSigningReq  # noqa: E501

            Update a CertSigningReq  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_agent_csr(connector_id, csr_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                csr_id (str): A certificate signing request id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit_csr_certificates (int): limit the number of certficates returned in a csr. [optional] if omitted the server will use the default value of 10
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CertSigningReq
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['csr_id'] = \
                csr_id
            return self.call_with_http_info(**kwargs)

        if self.get_agent_csr is None:
            self.get_agent_csr = _Endpoint(
                settings={
                    'response_type': (CertSigningReq,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/certificate_signing_requests/{csr_id}',
                    'operation_id': 'get_agent_csr',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'csr_id',
                        'org_id',
                        'limit_csr_certificates',
                    ],
                    'required': [
                        'connector_id',
                        'csr_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit_csr_certificates',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit_csr_certificates',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'csr_id':
                            (str,),
                        'org_id':
                            (str,),
                        'limit_csr_certificates':
                            (int,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'csr_id': 'csr_id',
                        'org_id': 'org_id',
                        'limit_csr_certificates': 'limit_csr_certificates',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'csr_id': 'path',
                        'org_id': 'query',
                        'limit_csr_certificates': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_agent_csr
            )

        def __get_agent_info(
            self,
            connector_id,
            **kwargs
        ):
            """Get information associated with connector  # noqa: E501

            Get information associated with connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_agent_info(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                allow_list (bool): Perform a query that returns the allow list in the response. . [optional]
                service_forwarders (bool): Perform a query that returns the service forwarders in the response. . [optional]
                authz_public_key (bool): Perform a query that returns the authz public key . [optional]
                active_transfers (bool): Perform a query that returns the active transfers in the response. . [optional]
                instance_id (str): The id of the instance to get. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_agent_info is None:
            self.get_agent_info = _Endpoint(
                settings={
                    'response_type': (AgentConnectorInfo,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/info',
                    'operation_id': 'get_agent_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                        'allow_list',
                        'service_forwarders',
                        'authz_public_key',
                        'active_transfers',
                        'instance_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                        'allow_list':
                            (bool,),
                        'service_forwarders':
                            (bool,),
                        'authz_public_key':
                            (bool,),
                        'active_transfers':
                            (bool,),
                        'instance_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                        'allow_list': 'allow_list',
                        'service_forwarders': 'service_forwarders',
                        'authz_public_key': 'authz_public_key',
                        'active_transfers': 'active_transfers',
                        'instance_id': 'instance_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                        'allow_list': 'query',
                        'service_forwarders': 'query',
                        'authz_public_key': 'query',
                        'active_transfers': 'query',
                        'instance_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_agent_info
            )

        def __get_agent_stats(
            self,
            connector_id,
            **kwargs
        ):
            """Get the AgentConnector stats  # noqa: E501

            Gets the most recent stats published by the AgentConnector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_agent_stats(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorStats
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_agent_stats is None:
            self.get_agent_stats = _Endpoint(
                settings={
                    'response_type': (AgentConnectorStats,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/stats',
                    'operation_id': 'get_agent_stats',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_agent_stats
            )

        def __get_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Get a connector  # noqa: E501

            Get a connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Connector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_connector is None:
            self.get_connector = _Endpoint(
                settings={
                    'response_type': (Connector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}',
                    'operation_id': 'get_connector',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_connector
            )

        def __get_connector_queue(
            self,
            connector_id,
            queue_id,
            **kwargs
        ):
            """Get a connector queue  # noqa: E501

            Get a connector queue  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_connector_queue(connector_id, queue_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                queue_id (str): queue id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorQueue
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['queue_id'] = \
                queue_id
            return self.call_with_http_info(**kwargs)

        if self.get_connector_queue is None:
            self.get_connector_queue = _Endpoint(
                settings={
                    'response_type': (AgentConnectorQueue,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/queues/{queue_id}',
                    'operation_id': 'get_connector_queue',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'queue_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'queue_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'queue_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'queue_id': 'queue_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'queue_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_connector_queue
            )

        def __get_connector_queues(
            self,
            connector_id,
            **kwargs
        ):
            """Get all AgentConnectorQueues for a connector_id  # noqa: E501

            Get all AgentConnectorQueues for a connector_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_connector_queues(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorQueueResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_connector_queues is None:
            self.get_connector_queues = _Endpoint(
                settings={
                    'response_type': (AgentConnectorQueueResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/queues',
                    'operation_id': 'get_connector_queues',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'limit',
                        'page_at_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'limit':
                            (int,),
                        'page_at_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'limit': 'limit',
                        'page_at_id': 'page_at_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'limit': 'query',
                        'page_at_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_connector_queues
            )

        def __get_connector_usage_metrics(
            self,
            **kwargs
        ):
            """Get all connector metrics  # noqa: E501

            Retrieves all connector metrics for a specified the org_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_connector_usage_metrics(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UsageMetrics
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.get_connector_usage_metrics is None:
            self.get_connector_usage_metrics = _Endpoint(
                settings={
                    'response_type': (UsageMetrics,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/usage_metrics',
                    'operation_id': 'get_connector_usage_metrics',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'org_ids',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'org_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'org_ids': 'org_ids',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'org_ids': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_connector_usage_metrics
            )

        def __get_encrypted_data(
            self,
            connector_id,
            transfer_id,
            **kwargs
        ):
            """get_encrypted_data  # noqa: E501

            Retrieve the EncryptedData data for a given connector_id and transfer_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_encrypted_data(connector_id, transfer_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                transfer_id (str): connector id secure transfer id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EncryptedData
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['transfer_id'] = \
                transfer_id
            return self.call_with_http_info(**kwargs)

        if self.get_encrypted_data is None:
            self.get_encrypted_data = _Endpoint(
                settings={
                    'response_type': (EncryptedData,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/secure_transfers/{transfer_id}/encrypted_data',
                    'operation_id': 'get_encrypted_data',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'transfer_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'transfer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'transfer_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'transfer_id': 'transfer_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'transfer_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_encrypted_data
            )

        def __get_instance(
            self,
            connector_id,
            connector_instance_id,
            **kwargs
        ):
            """get_instance  # noqa: E501

            Retrieve the AgentConnectorInstance for a given connector_id and connector_instance_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_instance(connector_id, connector_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                connector_instance_id (str): connector instance id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['connector_instance_id'] = \
                connector_instance_id
            return self.call_with_http_info(**kwargs)

        if self.get_instance is None:
            self.get_instance = _Endpoint(
                settings={
                    'response_type': (AgentConnectorInstance,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/instances/{connector_instance_id}',
                    'operation_id': 'get_instance',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'connector_instance_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'connector_instance_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'connector_instance_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'connector_instance_id': 'connector_instance_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'connector_instance_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_instance
            )

        def __get_ipsec_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Get an IPsec connector  # noqa: E501

            Get an IPsec connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ipsec_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IpsecConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_ipsec_connector is None:
            self.get_ipsec_connector = _Endpoint(
                settings={
                    'response_type': (IpsecConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ipsec_connectors/{connector_id}',
                    'operation_id': 'get_ipsec_connector',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_ipsec_connector
            )

        def __get_ipsec_connector_info(
            self,
            connector_id,
            **kwargs
        ):
            """Get IPsec connector runtime information  # noqa: E501

            Get IPsec connector runtime information.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ipsec_connector_info(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IpsecConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_ipsec_connector_info is None:
            self.get_ipsec_connector_info = _Endpoint(
                settings={
                    'response_type': (IpsecConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ipsec_connectors/{connector_id}/info',
                    'operation_id': 'get_ipsec_connector_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_ipsec_connector_info
            )

        def __get_proxy(
            self,
            connector_proxy_id,
            **kwargs
        ):
            """get_proxy  # noqa: E501

            Retrieve a AgentConnectorProxy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_proxy(connector_proxy_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_proxy_id (str): connector proxy id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorProxy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_proxy_id'] = \
                connector_proxy_id
            return self.call_with_http_info(**kwargs)

        if self.get_proxy is None:
            self.get_proxy = _Endpoint(
                settings={
                    'response_type': (AgentConnectorProxy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/proxies/{connector_proxy_id}',
                    'operation_id': 'get_proxy',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_proxy_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_proxy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_proxy_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_proxy_id': 'connector_proxy_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_proxy_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_proxy
            )

        def __get_queues(
            self,
            **kwargs
        ):
            """Get all AgentConnectorQueues  # noqa: E501

            Get all AgentConnectorQueues  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_queues(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorQueueResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.get_queues is None:
            self.get_queues = _Endpoint(
                settings={
                    'response_type': (AgentConnectorQueueResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/queues',
                    'operation_id': 'get_queues',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'limit',
                        'page_at_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'limit': 'limit',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'limit': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_queues
            )

        def __get_service(
            self,
            connector_id,
            connector_service,
            **kwargs
        ):
            """Get ConnectorService  # noqa: E501

            Get ConnectorService  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_service(connector_id, connector_service, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                connector_service (str): connector service path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectorService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['connector_service'] = \
                connector_service
            return self.call_with_http_info(**kwargs)

        if self.get_service is None:
            self.get_service = _Endpoint(
                settings={
                    'response_type': (ConnectorService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/services/{connector_service}',
                    'operation_id': 'get_service',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'connector_service',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'connector_service',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'connector_service':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'connector_service': 'connector_service',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'connector_service': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_service
            )

        def __get_stats_config(
            self,
            connector_id,
            **kwargs
        ):
            """Get the Connector stats configuration  # noqa: E501

            Gets the current stats configuration for the Connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_stats_config(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AppliedConnectorStatsConfig
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.get_stats_config is None:
            self.get_stats_config = _Endpoint(
                settings={
                    'response_type': (AppliedConnectorStatsConfig,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/stats/config',
                    'operation_id': 'get_stats_config',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_stats_config
            )

        def __get_transfer(
            self,
            connector_id,
            transfer_id,
            **kwargs
        ):
            """get_transfer  # noqa: E501

            Retrieve the ConnectorSecureTransfer for a given connector_id and transfer_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_transfer(connector_id, transfer_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                transfer_id (str): connector id secure transfer id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectorSecureTransfer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['transfer_id'] = \
                transfer_id
            return self.call_with_http_info(**kwargs)

        if self.get_transfer is None:
            self.get_transfer = _Endpoint(
                settings={
                    'response_type': (ConnectorSecureTransfer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/secure_transfers/{transfer_id}',
                    'operation_id': 'get_transfer',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'transfer_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'transfer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'transfer_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'transfer_id': 'transfer_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'transfer_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_transfer
            )

        def __list_agent_connector(
            self,
            **kwargs
        ):
            """list agent connectors  # noqa: E501

            list agent connectors. By default, an AgentConnector will not show stats when listed to speed up the query. Setting the show_stats parameter to true retrieve the stats for every AgentConnector.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_agent_connector(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                name (str): Query the connector by name.  The allow_partial_match can be used to perform a partial match of the name. . [optional]
                show_stats (bool): Whether the return value should include the stats for included objects. If false the query may run faster but will not include statistics. If not present, defaults to false. . [optional] if omitted the server will use the default value of False
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                admin_status (AdminStatus): admin status query. [optional]
                show_deleted (bool): Allows overriding certain queries in the system to show deleted objects.. [optional]
                page_at_name (str): Pagination based query with the name as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_name` field from the list response. . [optional]
                allow_partial_match (bool): Perform a case insensitive partial match of any string query parameters included in the query . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAgentConnectorResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_agent_connector is None:
            self.list_agent_connector = _Endpoint(
                settings={
                    'response_type': (ListAgentConnectorResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors',
                    'operation_id': 'list_agent_connector',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'name',
                        'show_stats',
                        'page_at_id',
                        'admin_status',
                        'show_deleted',
                        'page_at_name',
                        'allow_partial_match',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'show_stats':
                            (bool,),
                        'page_at_id':
                            (str,),
                        'admin_status':
                            (AdminStatus,),
                        'show_deleted':
                            (bool,),
                        'page_at_name':
                            (str,),
                        'allow_partial_match':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'name': 'name',
                        'show_stats': 'show_stats',
                        'page_at_id': 'page_at_id',
                        'admin_status': 'admin_status',
                        'show_deleted': 'show_deleted',
                        'page_at_name': 'page_at_name',
                        'allow_partial_match': 'allow_partial_match',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'name': 'query',
                        'show_stats': 'query',
                        'page_at_id': 'query',
                        'admin_status': 'query',
                        'show_deleted': 'query',
                        'page_at_name': 'query',
                        'allow_partial_match': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_agent_connector
            )

        def __list_agent_csr(
            self,
            connector_id,
            **kwargs
        ):
            """list agent connector certificate signing requests  # noqa: E501

            List agent connector certificate signing requests.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_agent_csr(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                private_key_id (str): query by private key id. [optional]
                target_issuer ([str]): A list of target issuers to search for. If an item matches an entry in the list, is returned. . [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                reason (CSRReasonEnum): Query a CSR based on its certificate reason status. This option is deprecated, as all csr queries will return only issued certificates. . [optional]
                not_valid_after (str): Search criteria for finding expired certificates * In UTC. * Supports human-friendly values. * Example, find all expired certificates in 30 days: not_after_after=\"in 30 days\" * Example, find all expired certificates today:  not_valid_after=\"tomorrow\" * Example, find all expired now:  not_valid_after=\"now\" . [optional]
                limit_csr_certificates (int): limit the number of certficates returned in a csr. [optional] if omitted the server will use the default value of 10
                auto_renew (bool): When enabled, query only certificate requests that have their auto_renew status enabled, when false, query only certificate requests that have their auto_renew as false. If not set (neither true or false), certificate requests are returned regardless of the auto_renew status. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCertSigningReqResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.list_agent_csr is None:
            self.list_agent_csr = _Endpoint(
                settings={
                    'response_type': (ListCertSigningReqResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/certificate_signing_requests',
                    'operation_id': 'list_agent_csr',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'private_key_id',
                        'target_issuer',
                        'limit',
                        'org_id',
                        'reason',
                        'not_valid_after',
                        'limit_csr_certificates',
                        'auto_renew',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                        'limit_csr_certificates',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('limit_csr_certificates',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'private_key_id':
                            (str,),
                        'target_issuer':
                            ([str],),
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'reason':
                            (CSRReasonEnum,),
                        'not_valid_after':
                            (str,),
                        'limit_csr_certificates':
                            (int,),
                        'auto_renew':
                            (bool,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'private_key_id': 'private_key_id',
                        'target_issuer': 'target_issuer',
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'reason': 'reason',
                        'not_valid_after': 'not_valid_after',
                        'limit_csr_certificates': 'limit_csr_certificates',
                        'auto_renew': 'auto_renew',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'private_key_id': 'query',
                        'target_issuer': 'query',
                        'limit': 'query',
                        'org_id': 'query',
                        'reason': 'query',
                        'not_valid_after': 'query',
                        'limit_csr_certificates': 'query',
                        'auto_renew': 'query',
                    },
                    'collection_format_map': {
                        'target_issuer': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_agent_csr
            )

        def __list_connector(
            self,
            **kwargs
        ):
            """List connectors  # noqa: E501

            List connectors. By default, Connectors will not show stats when listed to speed up the query. Set the show_stats parameter to true to retrieve the stats for every Connector.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_connector(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                name (str): Query the connector by name.  The allow_partial_match can be used to perform a partial match of the name. . [optional]
                type (str): connector type. [optional]
                show_stats (bool): Whether the return value should include the stats for included objects. If false the query may run faster but will not include statistics. If not present, defaults to false. . [optional] if omitted the server will use the default value of False
                admin_status (AdminStatus): admin status query. [optional]
                show_deleted (bool): Allows overriding certain queries in the system to show deleted objects.. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                page_at_name (str): Pagination based query with the name as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_name` field from the list response. . [optional]
                allow_partial_match (bool): Perform a case insensitive partial match of any string query parameters included in the query . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListConnectorResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_connector is None:
            self.list_connector = _Endpoint(
                settings={
                    'response_type': (ListConnectorResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors',
                    'operation_id': 'list_connector',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'name',
                        'type',
                        'show_stats',
                        'admin_status',
                        'show_deleted',
                        'page_at_id',
                        'page_at_name',
                        'allow_partial_match',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'type',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('type',): {

                            "AGENT": "agent",
                            "IPSEC": "ipsec"
                        },
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'type':
                            (str,),
                        'show_stats':
                            (bool,),
                        'admin_status':
                            (AdminStatus,),
                        'show_deleted':
                            (bool,),
                        'page_at_id':
                            (str,),
                        'page_at_name':
                            (str,),
                        'allow_partial_match':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'name': 'name',
                        'type': 'type',
                        'show_stats': 'show_stats',
                        'admin_status': 'admin_status',
                        'show_deleted': 'show_deleted',
                        'page_at_id': 'page_at_id',
                        'page_at_name': 'page_at_name',
                        'allow_partial_match': 'allow_partial_match',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'name': 'query',
                        'type': 'query',
                        'show_stats': 'query',
                        'admin_status': 'query',
                        'show_deleted': 'query',
                        'page_at_id': 'query',
                        'page_at_name': 'query',
                        'allow_partial_match': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_connector
            )

        def __list_connector_guid_mapping(
            self,
            **kwargs
        ):
            """Get all connector guids and a unique name mapping  # noqa: E501

            Get all connector guids and a unique name mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_connector_guid_mapping(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                connector_id (str): connector id in query. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                previous_guid (str): Pagination based query with the guid as the key. To get the initial entries supply an empty string.. [optional]
                updated_since (datetime): query since updated. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListGuidMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_connector_guid_mapping is None:
            self.list_connector_guid_mapping = _Endpoint(
                settings={
                    'response_type': (ListGuidMetadataResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/guids',
                    'operation_id': 'list_connector_guid_mapping',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'connector_id',
                        'limit',
                        'previous_guid',
                        'updated_since',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'connector_id':
                            (str,),
                        'limit':
                            (int,),
                        'previous_guid':
                            (str,),
                        'updated_since':
                            (datetime,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'connector_id': 'connector_id',
                        'limit': 'limit',
                        'previous_guid': 'previous_guid',
                        'updated_since': 'updated_since',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'connector_id': 'query',
                        'limit': 'query',
                        'previous_guid': 'query',
                        'updated_since': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_connector_guid_mapping
            )

        def __list_connector_stats(
            self,
            **kwargs
        ):
            """Get the Connector stats for many connectors  # noqa: E501

            Gets the most recent stats published by many instances. Use `collected_since` to filter out any stale stats. Use show_dynamic and show_static to choose the type of information to show.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_connector_stats(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                connector_id_list ([str]): connector id list in query. [optional]
                collected_since (datetime): Restrict stats to those collected since this value. Stats collected prior to this date and time are skipped. . [optional]
                show_dynamic (bool): Show dynamic stats for connectors that have them. [optional] if omitted the server will use the default value of False
                show_static (bool): Show static stats for connectors that have them. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListConnectorStatsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_connector_stats is None:
            self.list_connector_stats = _Endpoint(
                settings={
                    'response_type': (ListConnectorStatsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/stats',
                    'operation_id': 'list_connector_stats',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'connector_id_list',
                        'collected_since',
                        'show_dynamic',
                        'show_static',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'connector_id_list':
                            ([str],),
                        'collected_since':
                            (datetime,),
                        'show_dynamic':
                            (bool,),
                        'show_static':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'connector_id_list': 'connector_id_list',
                        'collected_since': 'collected_since',
                        'show_dynamic': 'show_dynamic',
                        'show_static': 'show_static',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'connector_id_list': 'query',
                        'collected_since': 'query',
                        'show_dynamic': 'query',
                        'show_static': 'query',
                    },
                    'collection_format_map': {
                        'connector_id_list': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_connector_stats
            )

        def __list_instances(
            self,
            connector_id,
            **kwargs
        ):
            """Get all AgentConnectorInstances for a connector_id  # noqa: E501

            Get all AgentConnectorInstances for a connector_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_instances(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAgentConnectorInstanceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.list_instances is None:
            self.list_instances = _Endpoint(
                settings={
                    'response_type': (ListAgentConnectorInstanceResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/instances',
                    'operation_id': 'list_instances',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                        'limit',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_instances
            )

        def __list_ipsec_connector(
            self,
            **kwargs
        ):
            """list IPsec connectors  # noqa: E501

            list IPsec connectors.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ipsec_connector(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                name (str): Query the connector by name.  The allow_partial_match can be used to perform a partial match of the name. . [optional]
                render_inheritance (bool): Returns connections with their spec inherited as per their inherited_from property . [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListIpsecConnectorResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_ipsec_connector is None:
            self.list_ipsec_connector = _Endpoint(
                settings={
                    'response_type': (ListIpsecConnectorResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ipsec_connectors',
                    'operation_id': 'list_ipsec_connector',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'name',
                        'render_inheritance',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'render_inheritance':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'name': 'name',
                        'render_inheritance': 'render_inheritance',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'name': 'query',
                        'render_inheritance': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_ipsec_connector
            )

        def __list_proxies(
            self,
            **kwargs
        ):
            """List connector proxies  # noqa: E501

            List connector proxies  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_proxies(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                inner_connector_id (str): Query connector proxies based on inner_connector_id. [optional]
                outer_connector_id (str): Query connector proxies based on outer_connector_id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAgentConnectorProxyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_proxies is None:
            self.list_proxies = _Endpoint(
                settings={
                    'response_type': (ListAgentConnectorProxyResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/proxies',
                    'operation_id': 'list_proxies',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'page_at_id',
                        'inner_connector_id',
                        'outer_connector_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'page_at_id':
                            (str,),
                        'inner_connector_id':
                            (str,),
                        'outer_connector_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'page_at_id': 'page_at_id',
                        'inner_connector_id': 'inner_connector_id',
                        'outer_connector_id': 'outer_connector_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'page_at_id': 'query',
                        'inner_connector_id': 'query',
                        'outer_connector_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_proxies
            )

        def __list_services(
            self,
            connector_id,
            **kwargs
        ):
            """Get all ConnectorServices for a connector_id  # noqa: E501

            Get all ConnectorServices for a connector_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_services(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListConnectorServiceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.list_services is None:
            self.list_services = _Endpoint(
                settings={
                    'response_type': (ListConnectorServiceResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/services',
                    'operation_id': 'list_services',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                        'limit',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_services
            )

        def __list_transfers(
            self,
            connector_id,
            **kwargs
        ):
            """Get all ConnectorSecureTransfers for a connector_id  # noqa: E501

            Get all ConnectorSecureTransfers for a connector_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_transfers(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListConnectorSecureTransferResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.list_transfers is None:
            self.list_transfers = _Endpoint(
                settings={
                    'response_type': (ListConnectorSecureTransferResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/secure_transfers',
                    'operation_id': 'list_transfers',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                        'limit',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_transfers
            )

        def __replace_agent_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Update an agent  # noqa: E501

            Update an agent  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_agent_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                agent_connector (AgentConnector): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.replace_agent_connector is None:
            self.replace_agent_connector = _Endpoint(
                settings={
                    'response_type': (AgentConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}',
                    'operation_id': 'replace_agent_connector',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                        'agent_connector',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                        'agent_connector':
                            (AgentConnector,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                        'agent_connector': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_agent_connector
            )

        def __replace_agent_connector_local_auth_info(
            self,
            connector_id,
            **kwargs
        ):
            """Update an agent's local authentication information  # noqa: E501

            Update an agent's local authentication information. This is typically modified by the agent itself.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_agent_connector_local_auth_info(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                agent_local_auth_info (AgentLocalAuthInfo): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.replace_agent_connector_local_auth_info is None:
            self.replace_agent_connector_local_auth_info = _Endpoint(
                settings={
                    'response_type': (AgentConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/local_auth_info',
                    'operation_id': 'replace_agent_connector_local_auth_info',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'agent_local_auth_info',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'agent_local_auth_info':
                            (AgentLocalAuthInfo,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'agent_local_auth_info': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_agent_connector_local_auth_info
            )

        def __replace_agent_csr(
            self,
            connector_id,
            csr_id,
            **kwargs
        ):
            """Update a CertSigningReq  # noqa: E501

            Update a CertSigningReq  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_agent_csr(connector_id, csr_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                csr_id (str): A certificate signing request id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                cert_signing_req (CertSigningReq): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CertSigningReq
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['csr_id'] = \
                csr_id
            return self.call_with_http_info(**kwargs)

        if self.replace_agent_csr is None:
            self.replace_agent_csr = _Endpoint(
                settings={
                    'response_type': (CertSigningReq,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/certificate_signing_requests/{csr_id}',
                    'operation_id': 'replace_agent_csr',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'csr_id',
                        'org_id',
                        'cert_signing_req',
                    ],
                    'required': [
                        'connector_id',
                        'csr_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'csr_id':
                            (str,),
                        'org_id':
                            (str,),
                        'cert_signing_req':
                            (CertSigningReq,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'csr_id': 'csr_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'csr_id': 'path',
                        'org_id': 'query',
                        'cert_signing_req': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_agent_csr
            )

        def __replace_encrypted_data(
            self,
            connector_id,
            transfer_id,
            **kwargs
        ):
            """replace_encrypted_data  # noqa: E501

            Update EncryptedData  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_encrypted_data(connector_id, transfer_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                transfer_id (str): connector id secure transfer id path

            Keyword Args:
                encrypted_data (EncryptedData): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EncryptedData
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['transfer_id'] = \
                transfer_id
            return self.call_with_http_info(**kwargs)

        if self.replace_encrypted_data is None:
            self.replace_encrypted_data = _Endpoint(
                settings={
                    'response_type': (EncryptedData,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/secure_transfers/{transfer_id}/encrypted_data',
                    'operation_id': 'replace_encrypted_data',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'transfer_id',
                        'encrypted_data',
                    ],
                    'required': [
                        'connector_id',
                        'transfer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'transfer_id':
                            (str,),
                        'encrypted_data':
                            (EncryptedData,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'transfer_id': 'transfer_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'transfer_id': 'path',
                        'encrypted_data': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_encrypted_data
            )

        def __replace_instance(
            self,
            connector_id,
            connector_instance_id,
            **kwargs
        ):
            """replace_instance  # noqa: E501

            Update an agent connector instance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_instance(connector_id, connector_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                connector_instance_id (str): connector instance id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                agent_connector_instance (AgentConnectorInstance): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['connector_instance_id'] = \
                connector_instance_id
            return self.call_with_http_info(**kwargs)

        if self.replace_instance is None:
            self.replace_instance = _Endpoint(
                settings={
                    'response_type': (AgentConnectorInstance,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/instances/{connector_instance_id}',
                    'operation_id': 'replace_instance',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'connector_instance_id',
                        'org_id',
                        'agent_connector_instance',
                    ],
                    'required': [
                        'connector_id',
                        'connector_instance_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'connector_instance_id':
                            (str,),
                        'org_id':
                            (str,),
                        'agent_connector_instance':
                            (AgentConnectorInstance,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'connector_instance_id': 'connector_instance_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'connector_instance_id': 'path',
                        'org_id': 'query',
                        'agent_connector_instance': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_instance
            )

        def __replace_ipsec_connector(
            self,
            connector_id,
            **kwargs
        ):
            """Update an IPsec connector  # noqa: E501

            Update an IPsec connector  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_ipsec_connector(connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                ipsec_connector (IpsecConnector): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IpsecConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            return self.call_with_http_info(**kwargs)

        if self.replace_ipsec_connector is None:
            self.replace_ipsec_connector = _Endpoint(
                settings={
                    'response_type': (IpsecConnector,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ipsec_connectors/{connector_id}',
                    'operation_id': 'replace_ipsec_connector',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'org_id',
                        'ipsec_connector',
                    ],
                    'required': [
                        'connector_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'org_id':
                            (str,),
                        'ipsec_connector':
                            (IpsecConnector,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'org_id': 'query',
                        'ipsec_connector': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_ipsec_connector
            )

        def __replace_proxy(
            self,
            connector_proxy_id,
            **kwargs
        ):
            """replace_proxy  # noqa: E501

            Update an AgentConnectorProxy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_proxy(connector_proxy_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_proxy_id (str): connector proxy id

            Keyword Args:
                agent_connector_proxy (AgentConnectorProxy): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AgentConnectorProxy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_proxy_id'] = \
                connector_proxy_id
            return self.call_with_http_info(**kwargs)

        if self.replace_proxy is None:
            self.replace_proxy = _Endpoint(
                settings={
                    'response_type': (AgentConnectorProxy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/proxies/{connector_proxy_id}',
                    'operation_id': 'replace_proxy',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_proxy_id',
                        'agent_connector_proxy',
                    ],
                    'required': [
                        'connector_proxy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_proxy_id':
                            (str,),
                        'agent_connector_proxy':
                            (AgentConnectorProxy,),
                    },
                    'attribute_map': {
                        'connector_proxy_id': 'connector_proxy_id',
                    },
                    'location_map': {
                        'connector_proxy_id': 'path',
                        'agent_connector_proxy': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_proxy
            )

        def __replace_transfer(
            self,
            connector_id,
            transfer_id,
            **kwargs
        ):
            """replace_transfer  # noqa: E501

            Update an ConnectorSecureTransfer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_transfer(connector_id, transfer_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                transfer_id (str): connector id secure transfer id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                connector_secure_transfer (ConnectorSecureTransfer): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectorSecureTransfer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['transfer_id'] = \
                transfer_id
            return self.call_with_http_info(**kwargs)

        if self.replace_transfer is None:
            self.replace_transfer = _Endpoint(
                settings={
                    'response_type': (ConnectorSecureTransfer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/connectors/{connector_id}/secure_transfers/{transfer_id}',
                    'operation_id': 'replace_transfer',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'transfer_id',
                        'org_id',
                        'connector_secure_transfer',
                    ],
                    'required': [
                        'connector_id',
                        'transfer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'transfer_id':
                            (str,),
                        'org_id':
                            (str,),
                        'connector_secure_transfer':
                            (ConnectorSecureTransfer,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'transfer_id': 'transfer_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'transfer_id': 'path',
                        'org_id': 'query',
                        'connector_secure_transfer': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_transfer
            )

    create_agent_connector = None 
    create_agent_csr = None 
    create_agent_stats = None 
    create_configure_publishing_request = None 
    create_connector_proxy = None 
    create_csr = None 
    create_instance = None 
    create_ipsec_connector = None 
    create_queue = None 
    create_service = None 
    create_transfer = None 
    delete_agent_connector = None 
    delete_connector = None 
    delete_connector_queue = None 
    delete_instance = None 
    delete_ipsec_connector = None 
    delete_proxy = None 
    delete_service = None 
    delete_transfer = None 
    get_agent_connector = None 
    get_agent_connector_dynamic_stats = None 
    get_agent_csr = None 
    get_agent_info = None 
    get_agent_stats = None 
    get_connector = None 
    get_connector_queue = None 
    get_connector_queues = None 
    get_connector_usage_metrics = None 
    get_encrypted_data = None 
    get_instance = None 
    get_ipsec_connector = None 
    get_ipsec_connector_info = None 
    get_proxy = None 
    get_queues = None 
    get_service = None 
    get_stats_config = None 
    get_transfer = None 
    list_agent_connector = None 
    list_agent_csr = None 
    list_connector = None 
    list_connector_guid_mapping = None 
    list_connector_stats = None 
    list_instances = None 
    list_ipsec_connector = None 
    list_proxies = None 
    list_services = None 
    list_transfers = None 
    replace_agent_connector = None 
    replace_agent_connector_local_auth_info = None 
    replace_agent_csr = None 
    replace_encrypted_data = None 
    replace_instance = None 
    replace_ipsec_connector = None 
    replace_proxy = None 
    replace_transfer = None 
