"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.14
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.cipher_diffie_hellman_group import CipherDiffieHellmanGroup
    from agilicus_api.model.cipher_encryption_algorithm import CipherEncryptionAlgorithm
    from agilicus_api.model.cipher_integrity_algorithm import CipherIntegrityAlgorithm
    from agilicus_api.model.ipsec_connection_ipv4_block import IpsecConnectionIpv4Block
    globals()['CipherDiffieHellmanGroup'] = CipherDiffieHellmanGroup
    globals()['CipherEncryptionAlgorithm'] = CipherEncryptionAlgorithm
    globals()['CipherIntegrityAlgorithm'] = CipherIntegrityAlgorithm
    globals()['IpsecConnectionIpv4Block'] = IpsecConnectionIpv4Block


class IpsecConnectionSpec(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('ike_version',): {
            'IKEV1': "ikev1",
            'IKEV2': "ikev2",
        },
        ('ike_authentication_type',): {
            'IKE_PRESHARED_KEY': "ike_preshared_key",
            'CERTIFICATE': "certificate",
        },
    }

    validations = {
    }

    @property
    def ike_version(self):
       return self.get("ike_version")

    @ike_version.setter
    def ike_version(self, new_value):
       self.ike_version = new_value

    @property
    def remote_ipv4_address(self):
       return self.get("remote_ipv4_address")

    @remote_ipv4_address.setter
    def remote_ipv4_address(self, new_value):
       self.remote_ipv4_address = new_value

    @property
    def remote_dns_ipv4_address(self):
       return self.get("remote_dns_ipv4_address")

    @remote_dns_ipv4_address.setter
    def remote_dns_ipv4_address(self, new_value):
       self.remote_dns_ipv4_address = new_value

    @property
    def remote_healthcheck_ipv4_address(self):
       return self.get("remote_healthcheck_ipv4_address")

    @remote_healthcheck_ipv4_address.setter
    def remote_healthcheck_ipv4_address(self, new_value):
       self.remote_healthcheck_ipv4_address = new_value

    @property
    def ike_cipher_encryption_algorithm(self):
       return self.get("ike_cipher_encryption_algorithm")

    @ike_cipher_encryption_algorithm.setter
    def ike_cipher_encryption_algorithm(self, new_value):
       self.ike_cipher_encryption_algorithm = new_value

    @property
    def ike_cipher_integrity_algorithm(self):
       return self.get("ike_cipher_integrity_algorithm")

    @ike_cipher_integrity_algorithm.setter
    def ike_cipher_integrity_algorithm(self, new_value):
       self.ike_cipher_integrity_algorithm = new_value

    @property
    def ike_cipher_diffie_hellman_group(self):
       return self.get("ike_cipher_diffie_hellman_group")

    @ike_cipher_diffie_hellman_group.setter
    def ike_cipher_diffie_hellman_group(self, new_value):
       self.ike_cipher_diffie_hellman_group = new_value

    @property
    def esp_cipher_encryption_algorithm(self):
       return self.get("esp_cipher_encryption_algorithm")

    @esp_cipher_encryption_algorithm.setter
    def esp_cipher_encryption_algorithm(self, new_value):
       self.esp_cipher_encryption_algorithm = new_value

    @property
    def esp_cipher_integrity_algorithm(self):
       return self.get("esp_cipher_integrity_algorithm")

    @esp_cipher_integrity_algorithm.setter
    def esp_cipher_integrity_algorithm(self, new_value):
       self.esp_cipher_integrity_algorithm = new_value

    @property
    def esp_cipher_diffie_hellman_group(self):
       return self.get("esp_cipher_diffie_hellman_group")

    @esp_cipher_diffie_hellman_group.setter
    def esp_cipher_diffie_hellman_group(self, new_value):
       self.esp_cipher_diffie_hellman_group = new_value

    @property
    def esp_lifetime(self):
       return self.get("esp_lifetime")

    @esp_lifetime.setter
    def esp_lifetime(self, new_value):
       self.esp_lifetime = new_value

    @property
    def ike_lifetime(self):
       return self.get("ike_lifetime")

    @ike_lifetime.setter
    def ike_lifetime(self, new_value):
       self.ike_lifetime = new_value

    @property
    def ike_rekey(self):
       return self.get("ike_rekey")

    @ike_rekey.setter
    def ike_rekey(self, new_value):
       self.ike_rekey = new_value

    @property
    def ike_reauth(self):
       return self.get("ike_reauth")

    @ike_reauth.setter
    def ike_reauth(self, new_value):
       self.ike_reauth = new_value

    @property
    def ike_authentication_type(self):
       return self.get("ike_authentication_type")

    @ike_authentication_type.setter
    def ike_authentication_type(self, new_value):
       self.ike_authentication_type = new_value

    @property
    def ike_preshared_key(self):
       return self.get("ike_preshared_key")

    @ike_preshared_key.setter
    def ike_preshared_key(self, new_value):
       self.ike_preshared_key = new_value

    @property
    def ike_chain_of_trust_certificates(self):
       return self.get("ike_chain_of_trust_certificates")

    @ike_chain_of_trust_certificates.setter
    def ike_chain_of_trust_certificates(self, new_value):
       self.ike_chain_of_trust_certificates = new_value

    @property
    def ike_certificate_dn(self):
       return self.get("ike_certificate_dn")

    @ike_certificate_dn.setter
    def ike_certificate_dn(self, new_value):
       self.ike_certificate_dn = new_value

    @property
    def ike_remote_identity(self):
       return self.get("ike_remote_identity")

    @ike_remote_identity.setter
    def ike_remote_identity(self, new_value):
       self.ike_remote_identity = new_value

    @property
    def local_ipv4_block(self):
       return self.get("local_ipv4_block")

    @local_ipv4_block.setter
    def local_ipv4_block(self, new_value):
       self.local_ipv4_block = new_value

    @property
    def remote_ipv4_ranges(self):
       return self.get("remote_ipv4_ranges")

    @remote_ipv4_ranges.setter
    def remote_ipv4_ranges(self, new_value):
       self.remote_ipv4_ranges = new_value

    @property
    def use_cert_hash(self):
       return self.get("use_cert_hash")

    @use_cert_hash.setter
    def use_cert_hash(self, new_value):
       self.use_cert_hash = new_value

    @property
    def local_certificate_uribase(self):
       return self.get("local_certificate_uribase")

    @local_certificate_uribase.setter
    def local_certificate_uribase(self, new_value):
       self.local_certificate_uribase = new_value

    @property
    def remote_certificate_uribase(self):
       return self.get("remote_certificate_uribase")

    @remote_certificate_uribase.setter
    def remote_certificate_uribase(self, new_value):
       self.remote_certificate_uribase = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'ike_version': (str,),  # noqa: E501
            'remote_ipv4_address': (str,),  # noqa: E501
            'remote_dns_ipv4_address': (str,),  # noqa: E501
            'remote_healthcheck_ipv4_address': (str,),  # noqa: E501
            'ike_cipher_encryption_algorithm': (CipherEncryptionAlgorithm,),  # noqa: E501
            'ike_cipher_integrity_algorithm': (CipherIntegrityAlgorithm,),  # noqa: E501
            'ike_cipher_diffie_hellman_group': (CipherDiffieHellmanGroup,),  # noqa: E501
            'esp_cipher_encryption_algorithm': (CipherEncryptionAlgorithm,),  # noqa: E501
            'esp_cipher_integrity_algorithm': (CipherIntegrityAlgorithm,),  # noqa: E501
            'esp_cipher_diffie_hellman_group': (CipherDiffieHellmanGroup,),  # noqa: E501
            'esp_lifetime': (int,),  # noqa: E501
            'ike_lifetime': (int,),  # noqa: E501
            'ike_rekey': (bool,),  # noqa: E501
            'ike_reauth': (bool,),  # noqa: E501
            'ike_authentication_type': (str,),  # noqa: E501
            'ike_preshared_key': (str,),  # noqa: E501
            'ike_chain_of_trust_certificates': (str,),  # noqa: E501
            'ike_certificate_dn': (str,),  # noqa: E501
            'ike_remote_identity': (str,),  # noqa: E501
            'local_ipv4_block': (str,),  # noqa: E501
            'remote_ipv4_ranges': ([IpsecConnectionIpv4Block],),  # noqa: E501
            'use_cert_hash': (bool,),  # noqa: E501
            'local_certificate_uribase': (str,),  # noqa: E501
            'remote_certificate_uribase': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'ike_version': 'ike_version',  # noqa: E501
        'remote_ipv4_address': 'remote_ipv4_address',  # noqa: E501
        'remote_dns_ipv4_address': 'remote_dns_ipv4_address',  # noqa: E501
        'remote_healthcheck_ipv4_address': 'remote_healthcheck_ipv4_address',  # noqa: E501
        'ike_cipher_encryption_algorithm': 'ike_cipher_encryption_algorithm',  # noqa: E501
        'ike_cipher_integrity_algorithm': 'ike_cipher_integrity_algorithm',  # noqa: E501
        'ike_cipher_diffie_hellman_group': 'ike_cipher_diffie_hellman_group',  # noqa: E501
        'esp_cipher_encryption_algorithm': 'esp_cipher_encryption_algorithm',  # noqa: E501
        'esp_cipher_integrity_algorithm': 'esp_cipher_integrity_algorithm',  # noqa: E501
        'esp_cipher_diffie_hellman_group': 'esp_cipher_diffie_hellman_group',  # noqa: E501
        'esp_lifetime': 'esp_lifetime',  # noqa: E501
        'ike_lifetime': 'ike_lifetime',  # noqa: E501
        'ike_rekey': 'ike_rekey',  # noqa: E501
        'ike_reauth': 'ike_reauth',  # noqa: E501
        'ike_authentication_type': 'ike_authentication_type',  # noqa: E501
        'ike_preshared_key': 'ike_preshared_key',  # noqa: E501
        'ike_chain_of_trust_certificates': 'ike_chain_of_trust_certificates',  # noqa: E501
        'ike_certificate_dn': 'ike_certificate_dn',  # noqa: E501
        'ike_remote_identity': 'ike_remote_identity',  # noqa: E501
        'local_ipv4_block': 'local_ipv4_block',  # noqa: E501
        'remote_ipv4_ranges': 'remote_ipv4_ranges',  # noqa: E501
        'use_cert_hash': 'use_cert_hash',  # noqa: E501
        'local_certificate_uribase': 'local_certificate_uribase',  # noqa: E501
        'remote_certificate_uribase': 'remote_certificate_uribase',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """IpsecConnectionSpec - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            ike_version (str): The IKE version. [optional]  # noqa: E501
            remote_ipv4_address (str): remote peer IPv4 address. [optional]  # noqa: E501
            remote_dns_ipv4_address (str): remote peer DNS IPv4 address. [optional]  # noqa: E501
            remote_healthcheck_ipv4_address (str): Remote peer healthcheck IPv4 address. The remote peer address must respond to ping (ICMP). This is used to validate the health of the connection. . [optional]  # noqa: E501
            ike_cipher_encryption_algorithm (CipherEncryptionAlgorithm): [optional]  # noqa: E501
            ike_cipher_integrity_algorithm (CipherIntegrityAlgorithm): [optional]  # noqa: E501
            ike_cipher_diffie_hellman_group (CipherDiffieHellmanGroup): [optional]  # noqa: E501
            esp_cipher_encryption_algorithm (CipherEncryptionAlgorithm): [optional]  # noqa: E501
            esp_cipher_integrity_algorithm (CipherIntegrityAlgorithm): [optional]  # noqa: E501
            esp_cipher_diffie_hellman_group (CipherDiffieHellmanGroup): [optional]  # noqa: E501
            esp_lifetime (int): Absolute time after which an IPsec security association expires, in minutes. . [optional]  # noqa: E501
            ike_lifetime (int): Absolute time after which an IKE security association expires, in minutes. . [optional]  # noqa: E501
            ike_rekey (bool): Allows control of IKE rekey. true is enabled, false is disabled. . [optional]  # noqa: E501
            ike_reauth (bool): Allows control of IKE re-authentication. true is enabled, false is disabled. . [optional]  # noqa: E501
            ike_authentication_type (str): The IKE authentication type.. [optional]  # noqa: E501
            ike_preshared_key (str): ike preshared key. [optional]  # noqa: E501
            ike_chain_of_trust_certificates (str): Chain of trust certficates. Certificates are PEM encoded and are separated by a newline.  ie. A signed by B would be a string where A is first, newline, followed by B. . [optional]  # noqa: E501
            ike_certificate_dn (str): certificate distinguished name (DN) Deprecated in favour of the generic ike_remote_identity field. . [optional]  # noqa: E501
            ike_remote_identity (str): The identity of the remote peer. The remote peer will send credentials including this identity as part of the IKE authentication exchange.  The meaning of the identity depends on the authentication type.   - `ike_preshared_key`: This is an arbitrary value provisioned on the remote     peer, often a FQDN or email address. E.g. \"vpn.my-org.example.com\".   - `certificate`: This is the distinguished name (DN) of the entity certificate     presented by the remote peer. E.g. \"C=CA; O=Agilicus; CN=vpn-1.ca-1.agilicus.ca\". . [optional]  # noqa: E501
            local_ipv4_block (str): The local IP block that used by the tunnel. A tunnel requires a /30 subnet, within the following IP address ranges    192.168.0.0 -> 192.168.255.252   172.16.0.0 -> 172.31.255.255 . [optional]  # noqa: E501
            remote_ipv4_ranges ([IpsecConnectionIpv4Block]): One or more IP address ranges that define the peer network range. . [optional]  # noqa: E501
            use_cert_hash (bool): Controls if certificate exchange using hash is enabled. . [optional]  # noqa: E501
            local_certificate_uribase (str): Provides the local endpoint uri base for certificate hash lookup. See https://tools.ietf.org/html/rfc7296#section-3.6 (Hash and URL encoding). Note that since the ultimate URL is constructed through concatenation, the final `/` is important. . [optional]  # noqa: E501
            remote_certificate_uribase (str): Provides the remote endpoint uri base for certificate hash lookup. See https://tools.ietf.org/html/rfc7296#section-3.6 (Hash and URL encoding). Note that since the ultimate URL is constructed through concatenation, the final `/` is important. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """IpsecConnectionSpec - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            ike_version (str): The IKE version. [optional]  # noqa: E501
            remote_ipv4_address (str): remote peer IPv4 address. [optional]  # noqa: E501
            remote_dns_ipv4_address (str): remote peer DNS IPv4 address. [optional]  # noqa: E501
            remote_healthcheck_ipv4_address (str): Remote peer healthcheck IPv4 address. The remote peer address must respond to ping (ICMP). This is used to validate the health of the connection. . [optional]  # noqa: E501
            ike_cipher_encryption_algorithm (CipherEncryptionAlgorithm): [optional]  # noqa: E501
            ike_cipher_integrity_algorithm (CipherIntegrityAlgorithm): [optional]  # noqa: E501
            ike_cipher_diffie_hellman_group (CipherDiffieHellmanGroup): [optional]  # noqa: E501
            esp_cipher_encryption_algorithm (CipherEncryptionAlgorithm): [optional]  # noqa: E501
            esp_cipher_integrity_algorithm (CipherIntegrityAlgorithm): [optional]  # noqa: E501
            esp_cipher_diffie_hellman_group (CipherDiffieHellmanGroup): [optional]  # noqa: E501
            esp_lifetime (int): Absolute time after which an IPsec security association expires, in minutes. . [optional]  # noqa: E501
            ike_lifetime (int): Absolute time after which an IKE security association expires, in minutes. . [optional]  # noqa: E501
            ike_rekey (bool): Allows control of IKE rekey. true is enabled, false is disabled. . [optional]  # noqa: E501
            ike_reauth (bool): Allows control of IKE re-authentication. true is enabled, false is disabled. . [optional]  # noqa: E501
            ike_authentication_type (str): The IKE authentication type.. [optional]  # noqa: E501
            ike_preshared_key (str): ike preshared key. [optional]  # noqa: E501
            ike_chain_of_trust_certificates (str): Chain of trust certficates. Certificates are PEM encoded and are separated by a newline.  ie. A signed by B would be a string where A is first, newline, followed by B. . [optional]  # noqa: E501
            ike_certificate_dn (str): certificate distinguished name (DN) Deprecated in favour of the generic ike_remote_identity field. . [optional]  # noqa: E501
            ike_remote_identity (str): The identity of the remote peer. The remote peer will send credentials including this identity as part of the IKE authentication exchange.  The meaning of the identity depends on the authentication type.   - `ike_preshared_key`: This is an arbitrary value provisioned on the remote     peer, often a FQDN or email address. E.g. \"vpn.my-org.example.com\".   - `certificate`: This is the distinguished name (DN) of the entity certificate     presented by the remote peer. E.g. \"C=CA; O=Agilicus; CN=vpn-1.ca-1.agilicus.ca\". . [optional]  # noqa: E501
            local_ipv4_block (str): The local IP block that used by the tunnel. A tunnel requires a /30 subnet, within the following IP address ranges    192.168.0.0 -> 192.168.255.252   172.16.0.0 -> 172.31.255.255 . [optional]  # noqa: E501
            remote_ipv4_ranges ([IpsecConnectionIpv4Block]): One or more IP address ranges that define the peer network range. . [optional]  # noqa: E501
            use_cert_hash (bool): Controls if certificate exchange using hash is enabled. . [optional]  # noqa: E501
            local_certificate_uribase (str): Provides the local endpoint uri base for certificate hash lookup. See https://tools.ietf.org/html/rfc7296#section-3.6 (Hash and URL encoding). Note that since the ultimate URL is constructed through concatenation, the final `/` is important. . [optional]  # noqa: E501
            remote_certificate_uribase (str): Provides the remote endpoint uri base for certificate hash lookup. See https://tools.ietf.org/html/rfc7296#section-3.6 (Hash and URL encoding). Note that since the ultimate URL is constructed through concatenation, the final `/` is important. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

