"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.14
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.message_action import MessageAction
    from agilicus_api.model.message_class import MessageClass
    from agilicus_api.model.message_tag import MessageTag
    from agilicus_api.model.message_type import MessageType
    globals()['MessageAction'] = MessageAction
    globals()['MessageClass'] = MessageClass
    globals()['MessageTag'] = MessageTag
    globals()['MessageType'] = MessageType


class Message(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('title',): {
            'max_length': 100,
        },
        ('sub_header',): {
            'max_length': 100,
        },
        ('actions',): {
        },
        ('push_probability',): {
            'inclusive_maximum': 1,
            'inclusive_minimum': 0,
        },
    }

    @property
    def id(self):
       return self.get("id")

    @id.setter
    def id(self, new_value):
       self.id = new_value

    @property
    def title(self):
       return self.get("title")

    @title.setter
    def title(self, new_value):
       self.title = new_value

    @property
    def sub_header(self):
       return self.get("sub_header")

    @sub_header.setter
    def sub_header(self, new_value):
       self.sub_header = new_value

    @property
    def icon(self):
       return self.get("icon")

    @icon.setter
    def icon(self, new_value):
       self.icon = new_value

    @property
    def image(self):
       return self.get("image")

    @image.setter
    def image(self, new_value):
       self.image = new_value

    @property
    def text(self):
       return self.get("text")

    @text.setter
    def text(self, new_value):
       self.text = new_value

    @property
    def uri(self):
       return self.get("uri")

    @uri.setter
    def uri(self, new_value):
       self.uri = new_value

    @property
    def context(self):
       return self.get("context")

    @context.setter
    def context(self, new_value):
       self.context = new_value

    @property
    def actions(self):
       return self.get("actions")

    @actions.setter
    def actions(self, new_value):
       self.actions = new_value

    @property
    def message_type(self):
       return self.get("message_type")

    @message_type.setter
    def message_type(self, new_value):
       self.message_type = new_value

    @property
    def message_class(self):
       return self.get("message_class")

    @message_class.setter
    def message_class(self, new_value):
       self.message_class = new_value

    @property
    def expiry_date(self):
       return self.get("expiry_date")

    @expiry_date.setter
    def expiry_date(self, new_value):
       self.expiry_date = new_value

    @property
    def tag(self):
       return self.get("tag")

    @tag.setter
    def tag(self, new_value):
       self.tag = new_value

    @property
    def push_probability(self):
       return self.get("push_probability")

    @push_probability.setter
    def push_probability(self, new_value):
       self.push_probability = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'text': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'title': (str,),  # noqa: E501
            'sub_header': (str,),  # noqa: E501
            'icon': (str,),  # noqa: E501
            'image': (str,),  # noqa: E501
            'uri': (str,),  # noqa: E501
            'context': (str,),  # noqa: E501
            'actions': ([MessageAction],),  # noqa: E501
            'message_type': (MessageType,),  # noqa: E501
            'message_class': (MessageClass,),  # noqa: E501
            'expiry_date': (datetime,),  # noqa: E501
            'tag': (MessageTag,),  # noqa: E501
            'push_probability': (float,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'text': 'text',  # noqa: E501
        'id': 'id',  # noqa: E501
        'title': 'title',  # noqa: E501
        'sub_header': 'sub_header',  # noqa: E501
        'icon': 'icon',  # noqa: E501
        'image': 'image',  # noqa: E501
        'uri': 'uri',  # noqa: E501
        'context': 'context',  # noqa: E501
        'actions': 'actions',  # noqa: E501
        'message_type': 'message_type',  # noqa: E501
        'message_class': 'message_class',  # noqa: E501
        'expiry_date': 'expiry_date',  # noqa: E501
        'tag': 'tag',  # noqa: E501
        'push_probability': 'push_probability',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, text, *args, **kwargs):  # noqa: E501
        """Message - a model defined in OpenAPI

        Args:
            text (str): The text string of the message

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Unique identifier. [optional]  # noqa: E501
            title (str): The title of the message (if medium allows). [optional]  # noqa: E501
            sub_header (str): The sub-header of the message (if medium allows). [optional]  # noqa: E501
            icon (str): The icon (uri) of the message (if medium allows). [optional]  # noqa: E501
            image (str): The image (uri) of the message (if medium allows). [optional]  # noqa: E501
            uri (str): The overall uri of the message (eg if clicked on). In some medium (e.g. Chrome WebPush) we can have individual actions, in others (e.g. Firefox WebPush) we only get the entire message as link. . [optional]  # noqa: E501
            context (str): A blob of context, message-type dependent. [optional]  # noqa: E501
            actions ([MessageAction]): A list of action buttons (if supported). [optional]  # noqa: E501
            message_type (MessageType): [optional]  # noqa: E501
            message_class (MessageClass): [optional]  # noqa: E501
            expiry_date (datetime): An optional expiry time for the message. An expired message may be deleted at any point by the system. . [optional]  # noqa: E501
            tag (MessageTag): [optional]  # noqa: E501
            push_probability (float): The probability the message will be pushed to a user when an event occurs. A value of 1.0 means there is a 100% chance that the message will be pushed. A value of 0.0 means that there is a 0% chance. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.text = text
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, text, *args, **kwargs):  # noqa: E501
        """Message - a model defined in OpenAPI

        Args:
            text (str): The text string of the message

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Unique identifier. [optional]  # noqa: E501
            title (str): The title of the message (if medium allows). [optional]  # noqa: E501
            sub_header (str): The sub-header of the message (if medium allows). [optional]  # noqa: E501
            icon (str): The icon (uri) of the message (if medium allows). [optional]  # noqa: E501
            image (str): The image (uri) of the message (if medium allows). [optional]  # noqa: E501
            uri (str): The overall uri of the message (eg if clicked on). In some medium (e.g. Chrome WebPush) we can have individual actions, in others (e.g. Firefox WebPush) we only get the entire message as link. . [optional]  # noqa: E501
            context (str): A blob of context, message-type dependent. [optional]  # noqa: E501
            actions ([MessageAction]): A list of action buttons (if supported). [optional]  # noqa: E501
            message_type (MessageType): [optional]  # noqa: E501
            message_class (MessageClass): [optional]  # noqa: E501
            expiry_date (datetime): An optional expiry time for the message. An expired message may be deleted at any point by the system. . [optional]  # noqa: E501
            tag (MessageTag): [optional]  # noqa: E501
            push_probability (float): The probability the message will be pushed to a user when an event occurs. A value of 1.0 means there is a 100% chance that the message will be pushed. A value of 0.0 means that there is a 0% chance. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.text = text
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

