"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.14
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.permissions_api import PermissionsApi  # noqa: E501


class TestPermissionsApi(unittest.TestCase):
    """PermissionsApi unit test stubs"""

    def setUp(self):
        self.api = PermissionsApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_bulk_delete_resource_permission(self):
        """Test case for bulk_delete_resource_permission

        Delete a set of resource permissions matching the resource id  # noqa: E501
        """
        pass

    def test_create_resource_permission(self):
        """Test case for create_resource_permission

        Create a ResourcePermission  # noqa: E501
        """
        pass

    def test_create_resource_role(self):
        """Test case for create_resource_role

        Create a ResourceRole  # noqa: E501
        """
        pass

    def test_delete_resource_permission(self):
        """Test case for delete_resource_permission

        Delete a ResourcePermission  # noqa: E501
        """
        pass

    def test_delete_resource_role(self):
        """Test case for delete_resource_role

        Delete a ResourceRole  # noqa: E501
        """
        pass

    def test_get_elevated_user_roles(self):
        """Test case for get_elevated_user_roles

        Get elevated roles for a user  # noqa: E501
        """
        pass

    def test_get_resource_permission(self):
        """Test case for get_resource_permission

        Get a ResourcePermission  # noqa: E501
        """
        pass

    def test_get_resource_role(self):
        """Test case for get_resource_role

        Get a ResourceRole  # noqa: E501
        """
        pass

    def test_list_elevated_user_roles(self):
        """Test case for list_elevated_user_roles

        List all elevated users and their roles  # noqa: E501
        """
        pass

    def test_list_resource_permissions(self):
        """Test case for list_resource_permissions

        List all ResourcePermissions  # noqa: E501
        """
        pass

    def test_list_resource_roles(self):
        """Test case for list_resource_roles

        List all ResourceRoles  # noqa: E501
        """
        pass

    def test_list_resource_roles_for_type(self):
        """Test case for list_resource_roles_for_type

        List all ResourceRoles  # noqa: E501
        """
        pass

    def test_replace_elevated_user_role(self):
        """Test case for replace_elevated_user_role

        Create or update an elevated user role  # noqa: E501
        """
        pass

    def test_replace_resource_permission(self):
        """Test case for replace_resource_permission

        Update a ResourcePermission  # noqa: E501
        """
        pass

    def test_replace_resource_role(self):
        """Test case for replace_resource_role

        Update a ResourceRole  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
