"""
SEE COPYRIGHT, LICENCE, and DOCUMENTATION NOTICES: files
README-COPYRIGHT-utf8.txt, README-LICENCE-utf8.txt, and README-DOCUMENTATION.txt
at project source root.
"""

import time

from logger_36.config.message import (
    ELAPSED_TIME_SEPARATOR,
    PROCESS_SEPARATOR,
    TIME_FORMAT,
    WHERE_SEPARATOR,
)

TIME_LENGTH = time.strftime(TIME_FORMAT, time.gmtime(0)).__len__()
CONTEXT_LENGTH = TIME_LENGTH + 2  # 2=<underscore><level name first letter>.
CONTEXT_LENGTH_p_1 = CONTEXT_LENGTH + 1
LINE_INDENT = (CONTEXT_LENGTH + 1) * " "
NEXT_LINE_PROLOGUE = "\n" + LINE_INDENT
WHERE_PROLOGUE = NEXT_LINE_PROLOGUE[:-2] + WHERE_SEPARATOR + " "
PROCESS_PROLOGUE = NEXT_LINE_PROLOGUE[:-2] + PROCESS_SEPARATOR + " "

TIME_PLACEHOLDER = TIME_LENGTH * ELAPSED_TIME_SEPARATOR

LINE_BREAK = "↲"
LINE_BREAK_AND_SPACE = f"{LINE_BREAK} "
