"""
SEE COPYRIGHT, LICENCE, and DOCUMENTATION NOTICES: files
README-COPYRIGHT-utf8.txt, README-LICENCE-utf8.txt, and README-DOCUMENTATION.txt
at project source root.
"""

LAYOUT_ON_BACKGROUND = "_on_"

"""
Sources:
https://rich.readthedocs.io/en/stable/appendix/colors.html
https://vim.fandom.com/wiki/Xterm256_color_names_for_console_Vim
https://www.ditig.com/256-colors-cheat-sheet
"""

# Some names get one or two underscores as a postfix because of duplicates.
COLORS_TERMINAL_256 = {
    # Names specific to Rich for the first 16 colors.
    "red": (1, "800000", (128, 0, 0)),
    "yellow": (3, "808000", (128, 128, 0)),
    "blue": (4, "000080", (0, 0, 128)),
    "magenta": (5, "800080", (128, 0, 128)),
    "cyan": (6, "008080", (0, 128, 128)),
    "white": (7, "c0c0c0", (192, 192, 192)),
    "brightblack": (8, "808080", (128, 128, 128)),
    "brightred": (9, "ff0000", (255, 0, 0)),
    "brightgreen": (10, "00ff00", (0, 255, 0)),
    "brightyellow": (11, "ffff00", (255, 255, 0)),
    "brightblue": (12, "0000ff", (0, 0, 255)),
    "brightmagenta": (13, "ff00ff", (255, 0, 255)),
    "brightcyan": (14, "00ffff", (0, 255, 255)),
    "brightwhite": (15, "ffffff", (255, 255, 255)),
    #
    "black": (0, "000000", (0, 0, 0)),
    "maroon": (1, "800000", (128, 0, 0)),
    "green": (2, "008000", (0, 128, 0)),
    "olive": (3, "808000", (128, 128, 0)),
    "navy": (4, "000080", (0, 0, 128)),
    "purple": (5, "800080", (128, 0, 128)),
    "teal": (6, "008080", (0, 128, 128)),
    "silver": (7, "c0c0c0", (192, 192, 192)),
    "grey": (8, "808080", (128, 128, 128)),
    "red_": (9, "ff0000", (255, 0, 0)),  # Renaming because of Rich.
    "lime": (10, "00ff00", (0, 255, 0)),
    "yellow_": (11, "ffff00", (255, 255, 0)),  # Renaming because of Rich.
    "blue_": (12, "0000ff", (0, 0, 255)),  # Renaming because of Rich.
    "fuchsia": (13, "ff00ff", (255, 0, 255)),
    "aqua": (14, "00ffff", (0, 255, 255)),
    "white_": (15, "ffffff", (255, 255, 255)),  # Renaming because of Rich.
    #
    "grey0": (16, "000000", (0, 0, 0)),
    "navyblue": (17, "00005f", (0, 0, 95)),
    "darkblue": (18, "000087", (0, 0, 135)),
    "blue3_": (19, "0000af", (0, 0, 175)),
    "blue3": (20, "0000d7", (0, 0, 215)),
    "blue1": (21, "0000ff", (0, 0, 255)),
    "darkgreen": (22, "005f00", (0, 95, 0)),
    "deepskyblue4_": (23, "005f5f", (0, 95, 95)),
    "deepskyblue4__": (24, "005f87", (0, 95, 135)),
    "deepskyblue4": (25, "005faf", (0, 95, 175)),
    "dodgerblue3": (26, "005fd7", (0, 95, 215)),
    "dodgerblue2": (27, "005fff", (0, 95, 255)),
    "green4": (28, "008700", (0, 135, 0)),
    "springgreen4": (29, "00875f", (0, 135, 95)),
    "turquoise4": (30, "008787", (0, 135, 135)),
    "deepskyblue3_": (31, "0087af", (0, 135, 175)),
    "deepskyblue3": (32, "0087d7", (0, 135, 215)),
    "dodgerblue1": (33, "0087ff", (0, 135, 255)),
    "green3": (34, "00af00", (0, 175, 0)),
    "springgreen3": (35, "00af5f", (0, 175, 95)),
    "darkcyan": (36, "00af87", (0, 175, 135)),
    "lightseagreen": (37, "00afaf", (0, 175, 175)),
    "deepskyblue2": (38, "00afd7", (0, 175, 215)),
    "deepskyblue1": (39, "00afff", (0, 175, 255)),
    "green3_": (40, "00d700", (0, 215, 0)),
    "springgreen3_": (41, "00d75f", (0, 215, 95)),
    "springgreen2": (42, "00d787", (0, 215, 135)),
    "cyan3": (43, "00d7af", (0, 215, 175)),
    "darkturquoise": (44, "00d7d7", (0, 215, 215)),
    "turquoise2": (45, "00d7ff", (0, 215, 255)),
    "green1": (46, "00ff00", (0, 255, 0)),
    "springgreen2_": (47, "00ff5f", (0, 255, 95)),
    "springgreen1": (48, "00ff87", (0, 255, 135)),
    "mediumspringgreen": (49, "00ffaf", (0, 255, 175)),
    "cyan2": (50, "00ffd7", (0, 255, 215)),
    "cyan1": (51, "00ffff", (0, 255, 255)),
    "darkred": (52, "5f0000", (95, 0, 0)),
    "deeppink4": (53, "5f005f", (95, 0, 95)),
    "purple4_": (54, "5f0087", (95, 0, 135)),
    "purple4": (55, "5f00af", (95, 0, 175)),
    "purple3": (56, "5f00d7", (95, 0, 215)),
    "blueviolet": (57, "5f00ff", (95, 0, 255)),
    "orange4": (58, "5f5f00", (95, 95, 0)),
    "grey37": (59, "5f5f5f", (95, 95, 95)),
    "mediumpurple4": (60, "5f5f87", (95, 95, 135)),
    "slateblue3_": (61, "5f5faf", (95, 95, 175)),
    "slateblue3": (62, "5f5fd7", (95, 95, 215)),
    "royalblue1": (63, "5f5fff", (95, 95, 255)),
    "chartreuse4": (64, "5f8700", (95, 135, 0)),
    "darkseagreen4": (65, "5f875f", (95, 135, 95)),
    "paleturquoise4": (66, "5f8787", (95, 135, 135)),
    "steelblue": (67, "5f87af", (95, 135, 175)),
    "steelblue3": (68, "5f87d7", (95, 135, 215)),
    "cornflowerblue": (69, "5f87ff", (95, 135, 255)),
    "chartreuse3": (70, "5faf00", (95, 175, 0)),
    "darkseagreen4_": (71, "5faf5f", (95, 175, 95)),
    "cadetblue_": (72, "5faf87", (95, 175, 135)),
    "cadetblue": (73, "5fafaf", (95, 175, 175)),
    "skyblue3": (74, "5fafd7", (95, 175, 215)),
    "steelblue1": (75, "5fafff", (95, 175, 255)),
    "chartreuse3_": (76, "5fd700", (95, 215, 0)),
    "palegreen3": (77, "5fd75f", (95, 215, 95)),
    "seagreen3": (78, "5fd787", (95, 215, 135)),
    "aquamarine3": (79, "5fd7af", (95, 215, 175)),
    "mediumturquoise": (80, "5fd7d7", (95, 215, 215)),
    "steelblue1_": (81, "5fd7ff", (95, 215, 255)),
    "chartreuse2": (82, "5fff00", (95, 255, 0)),
    "seagreen2": (83, "5fff5f", (95, 255, 95)),
    "seagreen1_": (84, "5fff87", (95, 255, 135)),
    "seagreen1": (85, "5fffaf", (95, 255, 175)),
    "aquamarine1": (86, "5fffd7", (95, 255, 215)),
    "darkslategray2": (87, "5fffff", (95, 255, 255)),
    "darkred_": (88, "870000", (135, 0, 0)),
    "deeppink4__": (89, "87005f", (135, 0, 95)),
    "darkmagenta_": (90, "870087", (135, 0, 135)),
    "darkmagenta": (91, "8700af", (135, 0, 175)),
    "darkviolet": (92, "8700d7", (135, 0, 215)),
    "purple_": (93, "8700ff", (135, 0, 255)),
    "orange4_": (94, "875f00", (135, 95, 0)),
    "lightpink4": (95, "875f5f", (135, 95, 95)),
    "plum4": (96, "875f87", (135, 95, 135)),
    "mediumpurple3_": (97, "875faf", (135, 95, 175)),
    "mediumpurple3": (98, "875fd7", (135, 95, 215)),
    "slateblue1": (99, "875fff", (135, 95, 255)),
    "yellow4": (100, "878700", (135, 135, 0)),
    "wheat4": (101, "87875f", (135, 135, 95)),
    "grey53": (102, "878787", (135, 135, 135)),
    "lightslategrey": (103, "8787af", (135, 135, 175)),
    "mediumpurple": (104, "8787d7", (135, 135, 215)),
    "lightslateblue": (105, "8787ff", (135, 135, 255)),
    "yellow4_": (106, "87af00", (135, 175, 0)),
    "darkolivegreen3": (107, "87af5f", (135, 175, 95)),
    "darkseagreen": (108, "87af87", (135, 175, 135)),
    "lightskyblue3_": (109, "87afaf", (135, 175, 175)),
    "lightskyblue3": (110, "87afd7", (135, 175, 215)),
    "skyblue2": (111, "87afff", (135, 175, 255)),
    "chartreuse_2": (112, "87d700", (135, 215, 0)),
    "darkolivegreen3__": (113, "87d75f", (135, 215, 95)),
    "palegreen3_": (114, "87d787", (135, 215, 135)),
    "darkseagreen3": (115, "87d7af", (135, 215, 175)),
    "darkslategray3": (116, "87d7d7", (135, 215, 215)),
    "skyblue1": (117, "87d7ff", (135, 215, 255)),
    "chartreuse1": (118, "87ff00", (135, 255, 0)),
    "lightgreen_": (119, "87ff5f", (135, 255, 95)),
    "lightgreen": (120, "87ff87", (135, 255, 135)),
    "palegreen1": (121, "87ffaf", (135, 255, 175)),
    "aquamarine1_": (122, "87ffd7", (135, 255, 215)),
    "darkslategray1": (123, "87ffff", (135, 255, 255)),
    "red3": (124, "af0000", (175, 0, 0)),
    "deeppink4_": (125, "af005f", (175, 0, 95)),
    "mediumvioletred": (126, "af0087", (175, 0, 135)),
    "magenta3": (127, "af00af", (175, 0, 175)),
    "darkviolet_": (128, "af00d7", (175, 0, 215)),
    "purple__": (129, "af00ff", (175, 0, 255)),
    "darkorange3": (130, "af5f00", (175, 95, 0)),
    "indianred": (131, "af5f5f", (175, 95, 95)),
    "hotpink3": (132, "af5f87", (175, 95, 135)),
    "mediumorchid3": (133, "af5faf", (175, 95, 175)),
    "mediumorchid": (134, "af5fd7", (175, 95, 215)),
    "mediumpurple2": (135, "af5fff", (175, 95, 255)),
    "darkgoldenrod": (136, "af8700", (175, 135, 0)),
    "lightsalmon3": (137, "af875f", (175, 135, 95)),
    "rosybrown": (138, "af8787", (175, 135, 135)),
    "grey63": (139, "af87af", (175, 135, 175)),
    "mediumpurple2_": (140, "af87d7", (175, 135, 215)),
    "mediumpurple1": (141, "af87ff", (175, 135, 255)),
    "gold3": (142, "afaf00", (175, 175, 0)),
    "darkkhaki": (143, "afaf5f", (175, 175, 95)),
    "navajowhite3": (144, "afaf87", (175, 175, 135)),
    "grey69": (145, "afafaf", (175, 175, 175)),
    "lightsteelblue3": (146, "afafd7", (175, 175, 215)),
    "lightsteelblue": (147, "afafff", (175, 175, 255)),
    "yellow3": (148, "afd700", (175, 215, 0)),
    "darkolivegreen3_": (149, "afd75f", (175, 215, 95)),
    "darkseagreen3_": (150, "afd787", (175, 215, 135)),
    "darkseagreen2": (151, "afd7af", (175, 215, 175)),
    "lightcyan3": (152, "afd7d7", (175, 215, 215)),
    "lightskyblue1": (153, "afd7ff", (175, 215, 255)),
    "greenyellow": (154, "afff00", (175, 255, 0)),
    "darkolivegreen2": (155, "afff5f", (175, 255, 95)),
    "palegreen1_": (156, "afff87", (175, 255, 135)),
    "darkseagreen2_": (157, "afffaf", (175, 255, 175)),
    "darkseagreen1": (158, "afffd7", (175, 255, 215)),
    "paleturquoise1": (159, "afffff", (175, 255, 255)),
    "red3_": (160, "d70000", (215, 0, 0)),
    "deeppink3_": (161, "d7005f", (215, 0, 95)),
    "deeppink3": (162, "d70087", (215, 0, 135)),
    "magenta3_": (163, "d700af", (215, 0, 175)),
    "magenta3__": (164, "d700d7", (215, 0, 215)),
    "magenta2": (165, "d700ff", (215, 0, 255)),
    "darkorange3_": (166, "d75f00", (215, 95, 0)),
    "indianred_": (167, "d75f5f", (215, 95, 95)),
    "hotpink3_": (168, "d75f87", (215, 95, 135)),
    "hotpink2": (169, "d75faf", (215, 95, 175)),
    "orchid": (170, "d75fd7", (215, 95, 215)),
    "mediumorchid1": (171, "d75fff", (215, 95, 255)),
    "orange3": (172, "d78700", (215, 135, 0)),
    "lightsalmon3_": (173, "d7875f", (215, 135, 95)),
    "lightpink3": (174, "d78787", (215, 135, 135)),
    "pink3": (175, "d787af", (215, 135, 175)),
    "plum3": (176, "d787d7", (215, 135, 215)),
    "violet": (177, "d787ff", (215, 135, 255)),
    "gold3_": (178, "d7af00", (215, 175, 0)),
    "lightgoldenrod3": (179, "d7af5f", (215, 175, 95)),
    "tan": (180, "d7af87", (215, 175, 135)),
    "mistyrose3": (181, "d7afaf", (215, 175, 175)),
    "thistle3": (182, "d7afd7", (215, 175, 215)),
    "plum2": (183, "d7afff", (215, 175, 255)),
    "yellow3_": (184, "d7d700", (215, 215, 0)),
    "khaki3": (185, "d7d75f", (215, 215, 95)),
    "lightgoldenrod2": (186, "d7d787", (215, 215, 135)),
    "lightyellow3": (187, "d7d7af", (215, 215, 175)),
    "grey84": (188, "d7d7d7", (215, 215, 215)),
    "lightsteelblue1": (189, "d7d7ff", (215, 215, 255)),
    "yellow2": (190, "d7ff00", (215, 255, 0)),
    "darkolivegreen1_": (191, "d7ff5f", (215, 255, 95)),
    "darkolivegreen1": (192, "d7ff87", (215, 255, 135)),
    "darkseagreen1_": (193, "d7ffaf", (215, 255, 175)),
    "honeydew2": (194, "d7ffd7", (215, 255, 215)),
    "lightcyan1": (195, "d7ffff", (215, 255, 255)),
    "red1": (196, "ff0000", (255, 0, 0)),
    "deeppink2": (197, "ff005f", (255, 0, 95)),
    "deeppink1_": (198, "ff0087", (255, 0, 135)),
    "deeppink1": (199, "ff00af", (255, 0, 175)),
    "magenta2_": (200, "ff00d7", (255, 0, 215)),
    "magenta1": (201, "ff00ff", (255, 0, 255)),
    "orangered1": (202, "ff5f00", (255, 95, 0)),
    "indianred1_": (203, "ff5f5f", (255, 95, 95)),
    "indianred1": (204, "ff5f87", (255, 95, 135)),
    "hotpink_": (205, "ff5faf", (255, 95, 175)),
    "hotpink": (206, "ff5fd7", (255, 95, 215)),
    "mediumorchid1_": (207, "ff5fff", (255, 95, 255)),
    "darkorange": (208, "ff8700", (255, 135, 0)),
    "salmon1": (209, "ff875f", (255, 135, 95)),
    "lightcoral": (210, "ff8787", (255, 135, 135)),
    "palevioletred1": (211, "ff87af", (255, 135, 175)),
    "orchid2": (212, "ff87d7", (255, 135, 215)),
    "orchid1": (213, "ff87ff", (255, 135, 255)),
    "orange1": (214, "ffaf00", (255, 175, 0)),
    "sandybrown": (215, "ffaf5f", (255, 175, 95)),
    "lightsalmon1": (216, "ffaf87", (255, 175, 135)),
    "lightpink1": (217, "ffafaf", (255, 175, 175)),
    "pink1": (218, "ffafd7", (255, 175, 215)),
    "plum1": (219, "ffafff", (255, 175, 255)),
    "gold1": (220, "ffd700", (255, 215, 0)),
    "lightgoldenrod2_": (221, "ffd75f", (255, 215, 95)),
    "lightgoldenrod2__": (222, "ffd787", (255, 215, 135)),
    "navajowhite1": (223, "ffd7af", (255, 215, 175)),
    "mistyrose1": (224, "ffd7d7", (255, 215, 215)),
    "thistle1": (225, "ffd7ff", (255, 215, 255)),
    "yellow1": (226, "ffff00", (255, 255, 0)),
    "lightgoldenrod1": (227, "ffff5f", (255, 255, 95)),
    "khaki1": (228, "ffff87", (255, 255, 135)),
    "wheat1": (229, "ffffaf", (255, 255, 175)),
    "cornsilk1": (230, "ffffd7", (255, 255, 215)),
    "grey100": (231, "ffffff", (255, 255, 255)),
    "grey3": (232, "080808", (8, 8, 8)),
    "grey7": (233, "121212", (18, 18, 18)),
    "grey11": (234, "1c1c1c", (28, 28, 28)),
    "grey15": (235, "262626", (38, 38, 38)),
    "grey19": (236, "303030", (48, 48, 48)),
    "grey23": (237, "3a3a3a", (58, 58, 58)),
    "grey27": (238, "444444", (68, 68, 68)),
    "grey30": (239, "4e4e4e", (78, 78, 78)),
    "grey35": (240, "585858", (88, 88, 88)),
    "grey39": (241, "626262", (98, 98, 98)),
    "grey42": (242, "6c6c6c", (108, 108, 108)),
    "grey46": (243, "767676", (118, 118, 118)),
    "grey50": (244, "808080", (128, 128, 128)),
    "grey54": (245, "8a8a8a", (138, 138, 138)),
    "grey58": (246, "949494", (148, 148, 148)),
    "grey62": (247, "9e9e9e", (158, 158, 158)),
    "grey66": (248, "a8a8a8", (168, 168, 168)),
    "grey70": (249, "b2b2b2", (178, 178, 178)),
    "grey74": (250, "bcbcbc", (188, 188, 188)),
    "grey78": (251, "c6c6c6", (198, 198, 198)),
    "grey82": (252, "d0d0d0", (208, 208, 208)),
    "grey85": (253, "dadada", (218, 218, 218)),
    "grey89": (254, "e4e4e4", (228, 228, 228)),
    "grey93": (255, "eeeeee", (238, 238, 238)),
}
