"""
SEE COPYRIGHT, LICENCE, and DOCUMENTATION NOTICES: files
README-COPYRIGHT-utf8.txt, README-LICENCE-utf8.txt, and README-DOCUMENTATION.txt
at project source root.
"""

import typing as h

try:
    from psutil import Process as process_t  # noqa
except ModuleNotFoundError:
    process_t = None


def CanCheckUsage() -> bool:
    """"""
    return process_t is not None


def CurrentUsage(
    *, process: h.Any | None = None, root_pid: int | None = None
) -> tuple[int, int]:
    """
    process: Any object with a "pid" attribute (e.g., multiprocessing and psutil process
    classes).
    """
    if process_t is None:
        return -1, -1

    if process is None:
        process = process_t()
    else:
        process = process_t(process.pid)
    usage = process.memory_info().rss

    if root_pid is None:
        total = -1
    else:
        total = usage
        for subprocess in process_t(root_pid).children(recursive=True):
            total += subprocess.memory_info().rss

    return usage, total
