When a function only involves one geometry column, such as [`area`][polars_st.GeoExprNameSpace.area] or [`buffer`][polars_st.GeoExprNameSpace.buffer], it is possible to call that function directly from the `polars_st` module, allowing us to write: `gdf.select(st.area())` instead of `gdf.select(st.geom().st.area())`.

The following functions can be used that way:

::: polars_st
    options:
        show_object_full_path: true
        show_root_toc_entry: false
        members:
            - geometry_type
            - dimensions
            - coordinate_dimension
            - area
            - bounds
            - length
            - minimum_clearance
            - x
            - y
            - z
            - m
            - count_coordinates
            - coordinates
            - count_geometries
            - get_geometry
            - count_points
            - get_point
            - exterior_ring
            - interior_rings
            - count_interior_rings
            - get_interior_ring
            - parts
            - precision
            - set_precision
            - srid
            - set_srid
            - to_srid
            - to_wkt
            - to_ewkt
            - to_wkb
            - to_geojson
            - to_shapely
            - to_dict
            - cast
            - multi
            - has_z
            - has_m
            - is_ccw
            - is_closed
            - is_empty
            - is_ring
            - is_simple
            - is_valid
            - is_valid_reason
            - unary_union
            - coverage_union
            - boundary
            - buffer
            - offset_curve
            - centroid
            - center
            - clip_by_rect
            - convex_hull
            - concave_hull
            - segmentize
            - envelope
            - extract_unique_points
            - build_area
            - make_valid
            - normalize
            - node
            - point_on_surface
            - remove_repeated_points
            - reverse
            - simplify
            - force_2d
            - force_3d
            - flip_coordinates
            - minimum_rotated_rectangle
            - affine_transform
            - translate
            - rotate
            - scale
            - skew
            - interpolate
            - substring
            - line_merge
            - total_bounds
            - collect
            - union_all
            - coverage_union_all
            - intersection_all
            - difference_all
            - symmetric_difference_all
            - polygonize
            - voronoi_polygons
            - delaunay_triangles
