# Django Welcome Template

Modern, responsive landing page for Django projects generated by Projex CLI.

## Design
- Clean grid, subtle animations, dark mode friendly
- Works without JavaScript; small script decorates version text

## Colors
- Primary: `#0C4B33`
- Secondary: `#44B78B`
- Accent: `#2BA977`
- Background: Light `#FFFFFF` / Dark `#0A2F23`

## Integration
Add a root view and URL pattern (see `integration.py`).

```python
from django.http import HttpResponse
from pathlib import Path
WELCOME_HTML = Path("templates/django/welcome.html").read_text()

def welcome(_req):
    return HttpResponse(WELCOME_HTML)
```

## Customize
- Replace icon in `.logo` with your SVG or image
- Tweak feature cards and quick links
- Update CSS variables in `:root`

## Assets
- Fonts: Inter (Google Fonts)
- Icons: Font Awesome (CDN)

