# FastAPI Welcome Template

A modern, responsive, animated welcome page for FastAPI projects generated by Projex CLI.

## Design
- Clean card-based layout with smooth fade and pulse animations
- Responsive grid using CSS Grid/Flexbox
- Progressive enhancement: works without JS; a tiny script enriches version info
- Accessible: semantic HTML, ARIA where appropriate, good contrast (dark-mode aware)

## Color Scheme
- Primary: `#009688`
- Secondary: `#00695C`
- Accent: `#26A69A`
- Background: Light `#FAFAFA` / Dark `#1E1E1E`

## Integration
- Root `/` serves `welcome.html`
- `/api` returns JSON with helpful links
- Interactive docs at `/docs` and `/redoc`

Example (see `integration.py`):
```python
from fastapi import FastAPI
from fastapi.responses import HTMLResponse
from pathlib import Path

app = FastAPI(title="My API", version="1.0.0")
WELCOME_HTML = Path("templates/fastapi/welcome.html").read_text(encoding="utf-8")

@app.get("/", response_class=HTMLResponse)
async def root():
    return WELCOME_HTML
```

## Customize
- Replace logo icon in `.logo` or swap with your SVG
- Edit colors in `:root` CSS variables
- Update feature cards / links in markup

## Assets
- Google Fonts: Inter
- Icons: Font Awesome (CDN)

## Performance
- Single file, no heavy dependencies
- CSS and minimal JS inline for fast first load
