# Flask Welcome Template

A sleek, responsive landing page for Flask projects generated by Projex CLI.

## Colors
- Primary: `#000000`
- Secondary: `#CCCCCC`
- Accent: `#FF6B6B`
- Background: Light `#FFFFFF` / Dark `#1A1A1A`

## Integration
Serve `welcome.html` at root and a JSON `/api` (see `integration.py`).

```python
from flask import Flask, Response
from pathlib import Path
app = Flask(__name__)
WELCOME_HTML = Path("templates/flask/welcome.html").read_text()
@app.get("/")
def root():
    return Response(WELCOME_HTML, mimetype="text/html")
```

## Customize
- Update icons and feature cards
- Edit CSS variables in `:root`

## Assets
- Inter font (Google Fonts)
- Font Awesome icons (CDN)

