"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_athena_1 = require("aws-cdk-lib/aws-athena");
const nag_rules_1 = require("../../nag-rules");
/**
 * Athena workgroups encrypt query results
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_athena_1.CfnWorkGroup) {
        const workGroupConfiguration = aws_cdk_lib_1.Stack.of(node).resolve(node.workGroupConfiguration);
        const enforceWorkGroupConfiguration = nag_rules_1.NagRules.resolveIfPrimitive(node, workGroupConfiguration?.enforceWorkGroupConfiguration);
        if (!enforceWorkGroupConfiguration) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        const resultConfiguration = aws_cdk_lib_1.Stack.of(node).resolve(workGroupConfiguration.resultConfiguration);
        if (resultConfiguration === undefined) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        const encryptionConfiguration = aws_cdk_lib_1.Stack.of(node).resolve(resultConfiguration.encryptionConfiguration);
        if (encryptionConfiguration === undefined) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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