# Abaqus Session

Session commands are used to create objects that are not stored with the model; for example, viewports and display groups. Abaqus/CAE retains Session objects only for the duration of the session; they are not saved when the model database is saved.

```{toctree}
:caption: Objects of Session
:maxdepth: 1

animation
canvas
display_options
display
field_report
odb_display
path
plot_options
print
xy
```

## Classes

### Session

```{eval-rst}
.. autoclass:: abaqus.Session.Session.Session
    :members:
    :show-inheritance:

    .. autoclasstoc::
```

### Other Classes

```{eval-rst}

.. toggle::

    .. automembers:: abaqus.Session
        :recursive:
        :exclude: Session

    .. placeholder for empty members
```
