# Introduction to Python

This section provides a basic introduction to the Python programming language. You are encouraged to try the examples and to experiment with Python statements.

The Python language is used throughout Abaqus, not only in the Abaqus Scripting Interface. Python is also used by Abaqus/Design to perform parametric studies and in the Abaqus/Standard, Abaqus/Explicit, and Abaqus/CAE environment file. For more information, see [Parametric Studies](https://help.3ds.com/2021/english/dssimulia_established/SIMACAEANLRefMap/simaanl-m-ParametricStudies-sb.htm?contextscope=all) and [Environment File Settings](https://help.3ds.com/2021/english/dssimulia_established/SIMACAEEXCRefMap/simaexc-c-envfile.htm?contextscope=all).

```{toctree}
:caption: Contents
:maxdepth: 1

python-abaqus
python-resources
python-interpreter
oop-basics
python-basics
programming
further-reading
```
