# Fix Agent Web 应用

一个简洁实用的AI代码助手Web应用，专注于提供最佳的人机交互体验。

## 🎯 项目特点

- ✅ **简洁实用** - 专注核心功能，避免复杂设计
- ✅ **路径输入** - 提供文件绝对路径，让AI代理使用工具访问
- ✅ **实时通信** - WebSocket流式响应，即时反馈
- ✅ **现代界面** - 清爽美观的Web界面，响应式设计
- ✅ **一键启动** - 简单的启动和管理脚本

## 🚀 快速开始

### 启动应用
```bash
# 在 web_app 目录下运行
./run.sh
```

### 停止应用
```bash
./stop.sh
```

### 访问应用
启动成功后访问：http://localhost:8000

## 💬 使用方法

### 1. 基本对话
直接在输入框中输入你的问题：
- 🔍 分析代码缺陷
- 🛠️ 修复代码问题
- 📊 优化代码性能
- 🧪 生成测试用例
- 📚 代码重构建议

### 2. 文件访问（推荐方式）
提供文件的绝对路径，让 AI 代理使用工具来访问和分析文件：

**示例：**
```
请分析这个Python文件的质量：/Users/macbookair/project/main.py
```

```
请修复这个JavaScript文件中的bug：/home/user/src/app.js
```

```
请优化这个Go文件的性能：/path/to/your/project/handler.go
```

### 3. 快速操作
使用右侧的快速按钮：
- 🔍 **分析代码** - 快速开始代码分析
- 🛠️ **修复缺陷** - 快速开始缺陷修复
- 📊 **优化性能** - 快速开始性能优化
- 🧪 **生成测试** - 快速生成测试用例

## 📁 项目结构

```
web_app/
├── index.html              # 主界面文件
├── run.sh                  # 启动脚本
├── stop.sh                 # 停止脚本
├── USAGE.md                # 使用指南
├── README.md               # 项目说明
└── backend/               # 后端服务
    ├── main.py           # FastAPI应用入口
    ├── app/
    │   ├── api/          # API路由
    │   ├── core/         # 核心功能
    │   ├── models/       # 数据模型
    │   ├── services/     # 业务逻辑
    │   └── websocket/    # WebSocket通信
    └── requirements.txt # Python依赖
```

## 🔧 技术架构

### 后端
- **FastAPI** - 现代Python Web框架
- **WebSocket** - 实时双向通信
- **SQLAlchemy** - 数据库ORM
- **AI适配器** - 桥接CLI逻辑

### 前端
- **原生HTML/CSS/JavaScript** - 轻量级，无依赖
- **响应式设计** - 适配各种设备
- **实时更新** - WebSocket连接管理

## 📚 详细文档

- **使用指南**: [USAGE.md](USAGE.md) - 详细的使用说明和最佳实践
- **API文档**: http://localhost:8000/docs - 完整的API接口文档

## 🎨 界面特性

### 主界面
- 现代化设计，简洁美观
- 实时连接状态显示
- 流畅的动画效果
- 响应式布局

### 聊天功能
- 实时消息传输
- 输入状态指示
- 消息历史记录
- 自动滚动到最新消息

### 会话管理
- 会话信息显示
- 快速操作按钮
- 对话导出功能
- 一键清空对话

## 💡 使用技巧

1. **提供具体路径** - 使用绝对路径让AI代理准确访问文件
2. **明确问题描述** - 清晰描述需要分析或修复的问题
3. **分步骤解决** - 对于复杂问题，可以分多个消息逐步解决
4. **利用记忆功能** - AI会记住之前的对话，保持上下文理解

## 🔧 故障排除

### 服务无法启动
1. 确保在 `web_app` 目录下运行脚本
2. 检查Python 3.8+ 是否已安装
3. 确保端口8000未被占用

### AI无法访问文件
1. 确保使用绝对路径
2. 确保文件存在且有读取权限
3. 检查文件路径是否有特殊字符

### 连接问题
1. 检查服务是否正在运行
2. 刷新浏览器页面
3. 查看服务器日志 `server.log`

## 🛡️ 安全说明

- AI代理只能访问你明确提供的文件路径
- 不会自动扫描或访问其他文件
- 所有对话内容仅在本地存储
- 不会上传代码到外部服务

## 📈 性能优化

- 前端零依赖，加载速度快
- WebSocket连接，实时响应
- 本地数据库，快速访问
- 优化的UI动画，流畅体验

## 🎯 设计理念

这个Web应用遵循以下设计理念：

1. **简洁至上** - 专注核心功能，避免花哨的设计
2. **用户友好** - 直观的界面，清晰的操作指引
3. **高效实用** - 快速启动，即用即走
4. **可靠稳定** - 健壮的错误处理，良好的用户体验

## 🚀 部署说明

### 开发环境
```bash
./run.sh
```

### 生产环境
```bash
# 使用Python直接运行
cd backend
python3 -m uvicorn main:app --host 0.0.0.0 --port 8000
```

## 📞 支持

如有问题或建议，请：
1. 查看使用指南 [USAGE.md](USAGE.md)
2. 检查API文档 http://localhost:8000/docs
3. 查看服务日志 `server.log`

---

**Fix Agent Web** - 让AI代码助手变得简单实用！