# Fix Agent Web 使用指南

## 🚀 快速开始

### 启动应用
```bash
# 在 web_app 目录下运行
./run.sh
```

### 停止应用
```bash
./stop.sh
```

## 📱 访问应用

启动成功后，在浏览器中访问：
- **主界面**: http://localhost:8000
- **API文档**: http://localhost:8000/docs

## 💬 使用方法

### 1. 基本对话
直接在输入框中输入你的问题，Fix Agent 会帮助你：
- 🔍 分析代码缺陷
- 🛠️ 修复代码问题
- 📊 优化代码性能
- 🧪 生成测试用例
- 📚 代码重构建议

### 2. 文件访问（推荐方式）
提供文件的绝对路径，让 AI 代理使用工具来访问和分析文件：

**示例：**
```
请分析这个Python文件的质量：/Users/macbookair/project/main.py
```

```
请修复这个JavaScript文件中的bug：/home/user/src/app.js
```

```
请优化这个Go文件的性能：/path/to/your/project/handler.go
```

### 3. 快速操作
使用右侧的快速按钮：
- 🔍 **分析代码** - 快速开始代码分析
- 🛠️ **修复缺陷** - 快速开始缺陷修复
- 📊 **优化性能** - 快速开始性能优化
- 🧪 **生成测试** - 快速生成测试用例

## 🎯 最佳实践

### 提供有效的文件路径
- ✅ **使用绝对路径**：`/Users/macbookair/project/src/main.py`
- ✅ **确保文件存在**：AI代理需要能够访问到文件
- ✅ **明确文件类型**：在请求中说明文件类型（Python、JavaScript等）

### 清晰的问题描述
- ✅ **具体说明问题**：不要只说"有问题"，要说清楚是什么问题
- ✅ **提供上下文**：说明你的项目背景和需求
- ✅ **分步骤描述**：对于复杂问题，可以分步骤描述

### 示例对话

**好的示例：**
```
请分析这个Python文件的代码质量：/Users/macbookair/myproject/app.py
重点关注：
1. 性能瓶颈
2. 潜在的安全问题
3. 代码风格问题
4. 可维护性建议
```

**不好的示例：**
```
分析一下这个文件
```

## 🔧 高级功能

### 会话管理
- **新建会话**：右侧面板点击"新建会话"
- **清空对话**：右侧面板点击"清空对话"
- **导出对话**：右侧面板点击"导出对话"

### 记忆系统
Fix Agent 具有记忆功能，可以：
- 记住之前的对话内容
- 保持对项目上下文的理解
- 跨会话保留重要信息

## ⚡ 快捷键

- `Enter` - 发送消息
- `Shift+Enter` - 换行

## 🔧 故障排除

### 服务无法启动
1. 确保在 `web_app` 目录下运行脚本
2. 检查Python 3.8+ 是否已安装
3. 确保端口8000未被占用

### AI无法访问文件
1. 确保使用绝对路径
2. 确保文件存在且有读取权限
3. 检查文件路径是否有特殊字符

### 连接问题
1. 检查服务是否正在运行
2. 刷新浏览器页面
3. 检查网络连接

## 📚 支持的文件类型

Fix Agent 支持分析各种编程语言的文件：
- Python (.py)
- JavaScript (.js, .jsx, .ts, .tsx)
- Java (.java)
- Go (.go)
- Rust (.rs)
- C/C++ (.c, .cpp, .h)
- SQL (.sql)
- 配置文件 (.json, .yaml, .toml, .xml)
- Markdown (.md)
- 更多...

## 🛡️ 安全说明

- AI代理只能访问你明确提供的文件路径
- 不会自动扫描或访问其他文件
- 所有对话内容仅在本地存储
- 不会上传代码到外部服务

## 💡 使用技巧

1. **从简单开始**：先让AI分析单个文件，再处理复杂问题
2. **分步骤解决**：对于复杂问题，可以分多个消息逐步解决
3. **提供具体需求**：明确告诉AI你的目标和约束条件
4. **利用记忆功能**：AI会记住之前的对话，可以基于上下文继续讨论
5. **及时反馈**：如果AI的建议不合适，及时反馈和纠正

---

如有问题，请查看服务日志 `server.log` 或访问 API 文档了解更多技术细节。