# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr 
from lusid.models.currency_and_amount import CurrencyAndAmount

class Bucket(BaseModel):
    """
    Bucket
    """
    tax_lot_id:  Optional[StrictStr] = Field(None,alias="taxLotId", description="The identifier of the tax lot this bucket is for.") 
    movement_name:  Optional[StrictStr] = Field(None,alias="movementName", description="The name of the movement.") 
    holding_type:  Optional[StrictStr] = Field(None,alias="holdingType", description="The type of the holding.") 
    economic_bucket:  Optional[StrictStr] = Field(None,alias="economicBucket", description="The economic bucket.") 
    economic_bucket_component:  Optional[StrictStr] = Field(None,alias="economicBucketComponent", description="The economic bucket component.") 
    economic_bucket_variant:  Optional[StrictStr] = Field(None,alias="economicBucketVariant", description="The economic bucket component.") 
    holding_sign:  Optional[StrictStr] = Field(None,alias="holdingSign", description="The holding sign.") 
    local: Optional[CurrencyAndAmount] = None
    base: Optional[CurrencyAndAmount] = None
    units: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The units.")
    activity_date: Optional[datetime] = Field(None, alias="activityDate", description="The activity date of the bucket.")
    __properties = ["taxLotId", "movementName", "holdingType", "economicBucket", "economicBucketComponent", "economicBucketVariant", "holdingSign", "local", "base", "units", "activityDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Bucket:
        """Create an instance of Bucket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of local
        if self.local:
            _dict['local'] = self.local.to_dict()
        # override the default output from pydantic by calling `to_dict()` of base
        if self.base:
            _dict['base'] = self.base.to_dict()
        # set to None if tax_lot_id (nullable) is None
        # and __fields_set__ contains the field
        if self.tax_lot_id is None and "tax_lot_id" in self.__fields_set__:
            _dict['taxLotId'] = None

        # set to None if movement_name (nullable) is None
        # and __fields_set__ contains the field
        if self.movement_name is None and "movement_name" in self.__fields_set__:
            _dict['movementName'] = None

        # set to None if holding_type (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_type is None and "holding_type" in self.__fields_set__:
            _dict['holdingType'] = None

        # set to None if economic_bucket (nullable) is None
        # and __fields_set__ contains the field
        if self.economic_bucket is None and "economic_bucket" in self.__fields_set__:
            _dict['economicBucket'] = None

        # set to None if economic_bucket_component (nullable) is None
        # and __fields_set__ contains the field
        if self.economic_bucket_component is None and "economic_bucket_component" in self.__fields_set__:
            _dict['economicBucketComponent'] = None

        # set to None if economic_bucket_variant (nullable) is None
        # and __fields_set__ contains the field
        if self.economic_bucket_variant is None and "economic_bucket_variant" in self.__fields_set__:
            _dict['economicBucketVariant'] = None

        # set to None if holding_sign (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_sign is None and "holding_sign" in self.__fields_set__:
            _dict['holdingSign'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Bucket:
        """Create an instance of Bucket from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Bucket.parse_obj(obj)

        _obj = Bucket.parse_obj({
            "tax_lot_id": obj.get("taxLotId"),
            "movement_name": obj.get("movementName"),
            "holding_type": obj.get("holdingType"),
            "economic_bucket": obj.get("economicBucket"),
            "economic_bucket_component": obj.get("economicBucketComponent"),
            "economic_bucket_variant": obj.get("economicBucketVariant"),
            "holding_sign": obj.get("holdingSign"),
            "local": CurrencyAndAmount.from_dict(obj.get("local")) if obj.get("local") is not None else None,
            "base": CurrencyAndAmount.from_dict(obj.get("base")) if obj.get("base") is not None else None,
            "units": obj.get("units"),
            "activity_date": obj.get("activityDate")
        })
        return _obj
