# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictInt 

class ExDividendConfiguration(BaseModel):
    """
    Configure the ex-dividend periods for the instrument.  # noqa: E501
    """
    use_business_days: Optional[StrictBool] = Field(None, alias="useBusinessDays", description="Is the ex-dividend period counted in business days or calendar days.  Defaults to false if not set.")
    ex_dividend_days: StrictInt = Field(..., alias="exDividendDays", description="Number of days in the ex-dividend period.  If the settlement date falls in the ex-dividend period then the coupon paid is zero and the accrued interest is negative.  If set, this must be a non-negative number.  If not set, or set to 0, than there is no ex-dividend period.")
    return_negative_accrued: Optional[StrictBool] = Field(None, alias="returnNegativeAccrued", description="Does the accrued interest go negative in the ex-dividend period, or does it go to zero.  Defaults to true if not set.")
    apply_thirty360_pay_delay: Optional[StrictBool] = Field(None, alias="applyThirty360PayDelay", description="Set this flag to true if the ex-dividend days represent a pay delay from the accrual end date in calendar  days under the 30/360 day count convention. The typical use case for this flag are Mortgage Backed Securities  with pay delay between 1 and 60 days, such as FreddieMac and FannieMae. If this flag is set, the useBusinessDays  setting will be ignored.  Defaults to false if not provided.")
    __properties = ["useBusinessDays", "exDividendDays", "returnNegativeAccrued", "applyThirty360PayDelay"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExDividendConfiguration:
        """Create an instance of ExDividendConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExDividendConfiguration:
        """Create an instance of ExDividendConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExDividendConfiguration.parse_obj(obj)

        _obj = ExDividendConfiguration.parse_obj({
            "use_business_days": obj.get("useBusinessDays"),
            "ex_dividend_days": obj.get("exDividendDays"),
            "return_negative_accrued": obj.get("returnNegativeAccrued"),
            "apply_thirty360_pay_delay": obj.get("applyThirty360PayDelay")
        })
        return _obj
