# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, constr 

class GroupReconciliationRunDetails(BaseModel):
    """
    GroupReconciliationRunDetails
    """
    completion_status:  StrictStr = Field(...,alias="completionStatus", description="Provides the reconciliation completion status \"Completed\" | \"FailedToComplete\"") 
    error_detail:  Optional[StrictStr] = Field(None,alias="errorDetail", description="Error information if the reconciliation failed to complete") 
    __properties = ["completionStatus", "errorDetail"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationRunDetails:
        """Create an instance of GroupReconciliationRunDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if error_detail (nullable) is None
        # and __fields_set__ contains the field
        if self.error_detail is None and "error_detail" in self.__fields_set__:
            _dict['errorDetail'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationRunDetails:
        """Create an instance of GroupReconciliationRunDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationRunDetails.parse_obj(obj)

        _obj = GroupReconciliationRunDetails.parse_obj({
            "completion_status": obj.get("completionStatus"),
            "error_detail": obj.get("errorDetail")
        })
        return _obj
