# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 

class InstrumentDefinitionFormat(BaseModel):
    """
    What is the provenance of an instrument. This defines who creates/owns it, what format it is in (e.g. a proprietary format or a common and known one)              and what the version of that is.  # noqa: E501
    """
    source_system:  StrictStr = Field(...,alias="sourceSystem", description="which source system does the format originate from") 
    vendor:  StrictStr = Field(...,alias="vendor", description="An instrument will potentially have been created by any number of different organisations. Some will be understood completely (e.g. LUSID's), some won't.              The provenance of an instrument indicates who \"owns\" the associated format.") 
    version:  StrictStr = Field(...,alias="version", description="Version of the document. Would be preferable to avoid the need, but LUSID will not control other organisations' trade formats.") 
    __properties = ["sourceSystem", "vendor", "version"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentDefinitionFormat:
        """Create an instance of InstrumentDefinitionFormat from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentDefinitionFormat:
        """Create an instance of InstrumentDefinitionFormat from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentDefinitionFormat.parse_obj(obj)

        _obj = InstrumentDefinitionFormat.parse_obj({
            "source_system": obj.get("sourceSystem"),
            "vendor": obj.get("vendor"),
            "version": obj.get("version")
        })
        return _obj
