# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist 
from lusid.models.mapped_string import MappedString

class MappingRule(BaseModel):
    """
    An individual mapping rule, for mapping between a left and right field/property.  # noqa: E501
    """
    left:  Optional[StrictStr] = Field(None,alias="left", description="The name of the field/property in the left resource (e.g. a transaction)") 
    right:  Optional[StrictStr] = Field(None,alias="right", description="The name of the field/property in the right resource (e.g. a transaction)") 
    comparison_type:  Optional[StrictStr] = Field(None,alias="comparisonType", description="The type of comparison to be performed") 
    comparison_value: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="comparisonValue", description="The (optional) value used with ComparisonType.")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="A factor used to influence the importance of this item.")
    mapped_strings: Optional[conlist(MappedString)] = Field(None, alias="mappedStrings", description="The (optional) value used to map string values.")
    is_case_sensitive: Optional[StrictBool] = Field(None, alias="isCaseSensitive", description="Should string comparisons take case into account, defaults to `false`.")
    __properties = ["left", "right", "comparisonType", "comparisonValue", "weight", "mappedStrings", "isCaseSensitive"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MappingRule:
        """Create an instance of MappingRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in mapped_strings (list)
        _items = []
        if self.mapped_strings:
            for _item in self.mapped_strings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mappedStrings'] = _items
        # set to None if left (nullable) is None
        # and __fields_set__ contains the field
        if self.left is None and "left" in self.__fields_set__:
            _dict['left'] = None

        # set to None if right (nullable) is None
        # and __fields_set__ contains the field
        if self.right is None and "right" in self.__fields_set__:
            _dict['right'] = None

        # set to None if comparison_type (nullable) is None
        # and __fields_set__ contains the field
        if self.comparison_type is None and "comparison_type" in self.__fields_set__:
            _dict['comparisonType'] = None

        # set to None if comparison_value (nullable) is None
        # and __fields_set__ contains the field
        if self.comparison_value is None and "comparison_value" in self.__fields_set__:
            _dict['comparisonValue'] = None

        # set to None if mapped_strings (nullable) is None
        # and __fields_set__ contains the field
        if self.mapped_strings is None and "mapped_strings" in self.__fields_set__:
            _dict['mappedStrings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MappingRule:
        """Create an instance of MappingRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MappingRule.parse_obj(obj)

        _obj = MappingRule.parse_obj({
            "left": obj.get("left"),
            "right": obj.get("right"),
            "comparison_type": obj.get("comparisonType"),
            "comparison_value": obj.get("comparisonValue"),
            "weight": obj.get("weight"),
            "mapped_strings": [MappedString.from_dict(_item) for _item in obj.get("mappedStrings")] if obj.get("mappedStrings") is not None else None,
            "is_case_sensitive": obj.get("isCaseSensitive")
        })
        return _obj
