# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictFloat, StrictInt, conlist 
from lusid.models.transaction import Transaction

class ReconciledTransaction(BaseModel):
    """
    Information about reconciled transactions.  At least one of Left and Right will be populated.  # noqa: E501
    """
    left: Optional[Transaction] = None
    right: Optional[Transaction] = None
    percentage_match: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="percentageMatch", description="How good a match this is considered to be.")
    mapping_rule_set_results: Optional[conlist(StrictBool)] = Field(None, alias="mappingRuleSetResults", description="The result of each individual mapping rule result.  Will only be present if both Left and Right are populated.")
    __properties = ["left", "right", "percentageMatch", "mappingRuleSetResults"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReconciledTransaction:
        """Create an instance of ReconciledTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of left
        if self.left:
            _dict['left'] = self.left.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right
        if self.right:
            _dict['right'] = self.right.to_dict()
        # set to None if mapping_rule_set_results (nullable) is None
        # and __fields_set__ contains the field
        if self.mapping_rule_set_results is None and "mapping_rule_set_results" in self.__fields_set__:
            _dict['mappingRuleSetResults'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReconciledTransaction:
        """Create an instance of ReconciledTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReconciledTransaction.parse_obj(obj)

        _obj = ReconciledTransaction.parse_obj({
            "left": Transaction.from_dict(obj.get("left")) if obj.get("left") is not None else None,
            "right": Transaction.from_dict(obj.get("right")) if obj.get("right") is not None else None,
            "percentage_match": obj.get("percentageMatch"),
            "mapping_rule_set_results": obj.get("mappingRuleSetResults")
        })
        return _obj
