# Contributing to GaitSetPy

Thank you for considering contributing to GaitSetPy! We welcome contributions from the community and are excited to collaborate with you.

## How to Contribute

### Reporting Bugs
If you find a bug, please report it by opening an issue on GitHub. Include as much detail as possible to help us understand and reproduce the issue.

### Feature Requests
We welcome new feature requests! Please open an issue on GitHub and describe the feature you would like to see, including any relevant use cases.

### Submitting Changes
1. Fork the repository.
2. Create a new branch for your changes: `git checkout -b feat|improv|bug/<feature-name>`.
3. Make your changes and commit them with clear and concise commit messages.
4. Push your changes to your fork: `git push origin feat|improv|bug/<feature-name>`.
5. Open a pull request on the main repository.

### Code Style
Please follow the existing code style and conventions used in the project. This helps maintain consistency and readability.

### Testing
Ensure that your changes do not break existing tests and add new tests for any new functionality. Run the test suite to verify.

### Documentation
Update the documentation to reflect your changes, including any new features or modifications to existing ones.

### Adding a New Dataset
If you want to add support for a new dataset, please follow the step-by-step guide in [CONTRIBUTING_DATASET.md](CONTRIBUTING_DATASET.md).

## Code of Conduct
Please adhere to our [Code of Conduct](CODE_OF_CONDUCT.md) in all interactions.

Thank you for your contributions!
