window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"gaitsetpy": {"fullname": "gaitsetpy", "modulename": "gaitsetpy", "kind": "module", "doc": "<p>GaitSetPy - A Python package for gait analysis and recognition.</p>\n\n<p>This package provides a comprehensive toolkit for gait data analysis with both\na modern class-based architecture and legacy function-based API for backward compatibility.</p>\n\n<p>Features:</p>\n\n<ul>\n<li>Modular architecture with singleton design pattern</li>\n<li>Plugin-based system for easy extension</li>\n<li>Comprehensive dataset loaders (Daphnet, MobiFall, Arduous, PhysioNet)</li>\n<li>Feature extraction and preprocessing pipelines</li>\n<li>Machine learning models for classification</li>\n<li>Exploratory data analysis tools</li>\n<li>Backward compatibility with legacy API</li>\n</ul>\n\n<p>Architecture:</p>\n\n<ul>\n<li>Core: Base classes and singleton managers</li>\n<li>Dataset: Data loading and preprocessing</li>\n<li>Features: Feature extraction and analysis</li>\n<li>Preprocessing: Data cleaning and transformation</li>\n<li>EDA: Exploratory data analysis and visualization</li>\n<li>Classification: Machine learning models and evaluation</li>\n</ul>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.BaseDatasetLoader": {"fullname": "gaitsetpy.BaseDatasetLoader", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader", "kind": "class", "doc": "<p>Base class for all dataset loaders.</p>\n\n<p>All dataset loaders should inherit from this class and implement the required methods.\nThis class provides thread-safe concurrent downloading capabilities for efficient data retrieval.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.BaseDatasetLoader.__init__": {"fullname": "gaitsetpy.BaseDatasetLoader.__init__", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.__init__", "kind": "function", "doc": "<p>Initialize the dataset loader.</p>\n\n<p>Args:\n    name: Name of the dataset\n    description: Description of the dataset\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>, </span><span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.BaseDatasetLoader.name": {"fullname": "gaitsetpy.BaseDatasetLoader.name", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseDatasetLoader.description": {"fullname": "gaitsetpy.BaseDatasetLoader.description", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseDatasetLoader.data": {"fullname": "gaitsetpy.BaseDatasetLoader.data", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.data", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseDatasetLoader.metadata": {"fullname": "gaitsetpy.BaseDatasetLoader.metadata", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseDatasetLoader.max_workers": {"fullname": "gaitsetpy.BaseDatasetLoader.max_workers", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.max_workers", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseDatasetLoader.load_data": {"fullname": "gaitsetpy.BaseDatasetLoader.load_data", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.load_data", "kind": "function", "doc": "<p>Load dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    **kwargs: Additional arguments specific to the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseDatasetLoader.create_sliding_windows": {"fullname": "gaitsetpy.BaseDatasetLoader.create_sliding_windows", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the loaded data.</p>\n\n<p>Args:\n    data: List of DataFrames\n    names: List of names corresponding to the data\n    window_size: Size of each sliding window\n    step_size: Step size for sliding windows</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseDatasetLoader.get_supported_formats": {"fullname": "gaitsetpy.BaseDatasetLoader.get_supported_formats", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseDatasetLoader.download_files_concurrent": {"fullname": "gaitsetpy.BaseDatasetLoader.download_files_concurrent", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.download_files_concurrent", "kind": "function", "doc": "<p>Download multiple files concurrently using a thread pool.</p>\n\n<p>Args:\n    download_tasks: List of dicts with 'url' and 'dest_path' keys\n    show_progress: Whether to show progress bar (default: True)\n    desc: Description for progress bar</p>\n\n<p>Returns:\n    Dictionary with download statistics and results</p>\n\n<p>Example:\n    tasks = [\n        {'url': 'http://example.com/file1.txt', 'dest_path': '/path/to/file1.txt'},\n        {'url': 'http://example.com/file2.txt', 'dest_path': '/path/to/file2.txt'}\n    ]\n    results = loader.download_files_concurrent(tasks)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">download_tasks</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">show_progress</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">desc</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Downloading files&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseDatasetLoader.set_max_workers": {"fullname": "gaitsetpy.BaseDatasetLoader.set_max_workers", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.set_max_workers", "kind": "function", "doc": "<p>Set the maximum number of concurrent download threads.</p>\n\n<p>Args:\n    max_workers: Maximum number of threads (must be positive)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseDatasetLoader.get_download_stats": {"fullname": "gaitsetpy.BaseDatasetLoader.get_download_stats", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.get_download_stats", "kind": "function", "doc": "<p>Get statistics from the last download operation.</p>\n\n<p>Returns:\n    Dictionary with success, failed, and skipped counts</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseDatasetLoader.get_info": {"fullname": "gaitsetpy.BaseDatasetLoader.get_info", "modulename": "gaitsetpy", "qualname": "BaseDatasetLoader.get_info", "kind": "function", "doc": "<p>Get information about the dataset.</p>\n\n<p>Returns:\n    Dictionary containing dataset information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseFeatureExtractor": {"fullname": "gaitsetpy.BaseFeatureExtractor", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor", "kind": "class", "doc": "<p>Base class for all feature extractors.</p>\n\n<p>All feature extractors should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.BaseFeatureExtractor.__init__": {"fullname": "gaitsetpy.BaseFeatureExtractor.__init__", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.BaseFeatureExtractor.name": {"fullname": "gaitsetpy.BaseFeatureExtractor.name", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseFeatureExtractor.description": {"fullname": "gaitsetpy.BaseFeatureExtractor.description", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseFeatureExtractor.config": {"fullname": "gaitsetpy.BaseFeatureExtractor.config", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseFeatureExtractor.extract_features": {"fullname": "gaitsetpy.BaseFeatureExtractor.extract_features", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.BaseFeatureExtractor.get_feature_names", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of features extracted by this extractor.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseFeatureExtractor.configure": {"fullname": "gaitsetpy.BaseFeatureExtractor.configure", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.configure", "kind": "function", "doc": "<p>Configure the feature extractor.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseFeatureExtractor.get_info": {"fullname": "gaitsetpy.BaseFeatureExtractor.get_info", "modulename": "gaitsetpy", "qualname": "BaseFeatureExtractor.get_info", "kind": "function", "doc": "<p>Get information about the feature extractor.</p>\n\n<p>Returns:\n    Dictionary containing feature extractor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BasePreprocessor": {"fullname": "gaitsetpy.BasePreprocessor", "modulename": "gaitsetpy", "qualname": "BasePreprocessor", "kind": "class", "doc": "<p>Base class for all preprocessors.</p>\n\n<p>All preprocessors should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.BasePreprocessor.__init__": {"fullname": "gaitsetpy.BasePreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.BasePreprocessor.name": {"fullname": "gaitsetpy.BasePreprocessor.name", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BasePreprocessor.description": {"fullname": "gaitsetpy.BasePreprocessor.description", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BasePreprocessor.config": {"fullname": "gaitsetpy.BasePreprocessor.config", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BasePreprocessor.fitted": {"fullname": "gaitsetpy.BasePreprocessor.fitted", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.fitted", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BasePreprocessor.fit": {"fullname": "gaitsetpy.BasePreprocessor.fit", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor to the data.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments for fitting</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BasePreprocessor.transform": {"fullname": "gaitsetpy.BasePreprocessor.transform", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.transform", "kind": "function", "doc": "<p>Transform the data using the fitted preprocessor.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments for transformation</p>\n\n<p>Returns:\n    Transformed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BasePreprocessor.fit_transform": {"fullname": "gaitsetpy.BasePreprocessor.fit_transform", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.fit_transform", "kind": "function", "doc": "<p>Fit the preprocessor and transform the data.</p>\n\n<p>Args:\n    data: Input data to fit and transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Transformed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BasePreprocessor.configure": {"fullname": "gaitsetpy.BasePreprocessor.configure", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.configure", "kind": "function", "doc": "<p>Configure the preprocessor.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BasePreprocessor.get_info": {"fullname": "gaitsetpy.BasePreprocessor.get_info", "modulename": "gaitsetpy", "qualname": "BasePreprocessor.get_info", "kind": "function", "doc": "<p>Get information about the preprocessor.</p>\n\n<p>Returns:\n    Dictionary containing preprocessor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseEDAAnalyzer": {"fullname": "gaitsetpy.BaseEDAAnalyzer", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer", "kind": "class", "doc": "<p>Base class for all EDA analyzers.</p>\n\n<p>All EDA analyzers should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.BaseEDAAnalyzer.__init__": {"fullname": "gaitsetpy.BaseEDAAnalyzer.__init__", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.BaseEDAAnalyzer.name": {"fullname": "gaitsetpy.BaseEDAAnalyzer.name", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseEDAAnalyzer.description": {"fullname": "gaitsetpy.BaseEDAAnalyzer.description", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseEDAAnalyzer.config": {"fullname": "gaitsetpy.BaseEDAAnalyzer.config", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseEDAAnalyzer.analyze": {"fullname": "gaitsetpy.BaseEDAAnalyzer.analyze", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.analyze", "kind": "function", "doc": "<p>Perform analysis on the data.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments for analysis</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseEDAAnalyzer.visualize": {"fullname": "gaitsetpy.BaseEDAAnalyzer.visualize", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of the data.</p>\n\n<p>Args:\n    data: Input data to visualize\n    **kwargs: Additional arguments for visualization</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseEDAAnalyzer.configure": {"fullname": "gaitsetpy.BaseEDAAnalyzer.configure", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.configure", "kind": "function", "doc": "<p>Configure the EDA analyzer.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseEDAAnalyzer.get_info": {"fullname": "gaitsetpy.BaseEDAAnalyzer.get_info", "modulename": "gaitsetpy", "qualname": "BaseEDAAnalyzer.get_info", "kind": "function", "doc": "<p>Get information about the EDA analyzer.</p>\n\n<p>Returns:\n    Dictionary containing EDA analyzer information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseClassificationModel": {"fullname": "gaitsetpy.BaseClassificationModel", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel", "kind": "class", "doc": "<p>Base class for all classification models.</p>\n\n<p>All classification models should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.BaseClassificationModel.__init__": {"fullname": "gaitsetpy.BaseClassificationModel.__init__", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.BaseClassificationModel.name": {"fullname": "gaitsetpy.BaseClassificationModel.name", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseClassificationModel.description": {"fullname": "gaitsetpy.BaseClassificationModel.description", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseClassificationModel.model": {"fullname": "gaitsetpy.BaseClassificationModel.model", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseClassificationModel.config": {"fullname": "gaitsetpy.BaseClassificationModel.config", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseClassificationModel.trained": {"fullname": "gaitsetpy.BaseClassificationModel.trained", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.trained", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaseClassificationModel.train": {"fullname": "gaitsetpy.BaseClassificationModel.train", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseClassificationModel.predict": {"fullname": "gaitsetpy.BaseClassificationModel.predict", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseClassificationModel.evaluate": {"fullname": "gaitsetpy.BaseClassificationModel.evaluate", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaseClassificationModel.save_model": {"fullname": "gaitsetpy.BaseClassificationModel.save_model", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseClassificationModel.load_model": {"fullname": "gaitsetpy.BaseClassificationModel.load_model", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseClassificationModel.configure": {"fullname": "gaitsetpy.BaseClassificationModel.configure", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.configure", "kind": "function", "doc": "<p>Configure the classification model.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaseClassificationModel.get_info": {"fullname": "gaitsetpy.BaseClassificationModel.get_info", "modulename": "gaitsetpy", "qualname": "BaseClassificationModel.get_info", "kind": "function", "doc": "<p>Get information about the classification model.</p>\n\n<p>Returns:\n    Dictionary containing model information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DatasetManager": {"fullname": "gaitsetpy.DatasetManager", "modulename": "gaitsetpy", "qualname": "DatasetManager", "kind": "class", "doc": "<p>Singleton manager for dataset loaders.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.DatasetManager.register_dataset": {"fullname": "gaitsetpy.DatasetManager.register_dataset", "modulename": "gaitsetpy", "qualname": "DatasetManager.register_dataset", "kind": "function", "doc": "<p>Register a dataset loader.</p>\n\n<p>Args:\n    name: Name to register the dataset under\n    dataset_class: Dataset loader class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">dataset_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseDatasetLoader</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.DatasetManager.load_dataset": {"fullname": "gaitsetpy.DatasetManager.load_dataset", "modulename": "gaitsetpy", "qualname": "DatasetManager.load_dataset", "kind": "function", "doc": "<p>Load a dataset using the registered loader.</p>\n\n<p>Args:\n    name: Name of the dataset loader\n    data_dir: Directory containing the dataset\n    **kwargs: Additional arguments for the loader</p>\n\n<p>Returns:\n    Dataset loader instance with loaded data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseDatasetLoader</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.FeatureManager": {"fullname": "gaitsetpy.FeatureManager", "modulename": "gaitsetpy", "qualname": "FeatureManager", "kind": "class", "doc": "<p>Singleton manager for feature extractors.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.FeatureManager.register_extractor": {"fullname": "gaitsetpy.FeatureManager.register_extractor", "modulename": "gaitsetpy", "qualname": "FeatureManager.register_extractor", "kind": "function", "doc": "<p>Register a feature extractor.</p>\n\n<p>Args:\n    name: Name to register the extractor under\n    extractor_class: Feature extractor class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">extractor_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseFeatureExtractor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.FeatureManager.extract_features": {"fullname": "gaitsetpy.FeatureManager.extract_features", "modulename": "gaitsetpy", "qualname": "FeatureManager.extract_features", "kind": "function", "doc": "<p>Extract features using the specified extractor.</p>\n\n<p>Args:\n    extractor_name: Name of the feature extractor\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">extractor_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PreprocessingManager": {"fullname": "gaitsetpy.PreprocessingManager", "modulename": "gaitsetpy", "qualname": "PreprocessingManager", "kind": "class", "doc": "<p>Singleton manager for preprocessors.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.PreprocessingManager.register_preprocessor": {"fullname": "gaitsetpy.PreprocessingManager.register_preprocessor", "modulename": "gaitsetpy", "qualname": "PreprocessingManager.register_preprocessor", "kind": "function", "doc": "<p>Register a preprocessor.</p>\n\n<p>Args:\n    name: Name to register the preprocessor under\n    preprocessor_class: Preprocessor class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">preprocessor_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BasePreprocessor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.PreprocessingManager.preprocess_data": {"fullname": "gaitsetpy.PreprocessingManager.preprocess_data", "modulename": "gaitsetpy", "qualname": "PreprocessingManager.preprocess_data", "kind": "function", "doc": "<p>Preprocess data using the specified preprocessor.</p>\n\n<p>Args:\n    preprocessor_name: Name of the preprocessor\n    data: Input data to preprocess\n    **kwargs: Additional arguments for preprocessing</p>\n\n<p>Returns:\n    Preprocessed data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">preprocessor_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.EDAManager": {"fullname": "gaitsetpy.EDAManager", "modulename": "gaitsetpy", "qualname": "EDAManager", "kind": "class", "doc": "<p>Singleton manager for EDA analyzers.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.EDAManager.register_analyzer": {"fullname": "gaitsetpy.EDAManager.register_analyzer", "modulename": "gaitsetpy", "qualname": "EDAManager.register_analyzer", "kind": "function", "doc": "<p>Register an EDA analyzer.</p>\n\n<p>Args:\n    name: Name to register the analyzer under\n    analyzer_class: EDA analyzer class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">analyzer_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseEDAAnalyzer</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.EDAManager.analyze_data": {"fullname": "gaitsetpy.EDAManager.analyze_data", "modulename": "gaitsetpy", "qualname": "EDAManager.analyze_data", "kind": "function", "doc": "<p>Analyze data using the specified analyzer.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to analyze\n    **kwargs: Additional arguments for analysis</p>\n\n<p>Returns:\n    Analysis results dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.EDAManager.visualize_data": {"fullname": "gaitsetpy.EDAManager.visualize_data", "modulename": "gaitsetpy", "qualname": "EDAManager.visualize_data", "kind": "function", "doc": "<p>Create visualizations using the specified analyzer.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to visualize\n    **kwargs: Additional arguments for visualization</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.ClassificationManager": {"fullname": "gaitsetpy.ClassificationManager", "modulename": "gaitsetpy", "qualname": "ClassificationManager", "kind": "class", "doc": "<p>Singleton manager for classification models.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.ClassificationManager.register_model": {"fullname": "gaitsetpy.ClassificationManager.register_model", "modulename": "gaitsetpy", "qualname": "ClassificationManager.register_model", "kind": "function", "doc": "<p>Register a classification model.</p>\n\n<p>Args:\n    name: Name to register the model under\n    model_class: Classification model class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">model_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseClassificationModel</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.ClassificationManager.train_model": {"fullname": "gaitsetpy.ClassificationManager.train_model", "modulename": "gaitsetpy", "qualname": "ClassificationManager.train_model", "kind": "function", "doc": "<p>Train a classification model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n\n<p>Returns:\n    Trained model instance</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseClassificationModel</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ClassificationManager.predict": {"fullname": "gaitsetpy.ClassificationManager.predict", "modulename": "gaitsetpy", "qualname": "ClassificationManager.predict", "kind": "function", "doc": "<p>Make predictions using a trained model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Predictions array</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ClassificationManager.evaluate_model": {"fullname": "gaitsetpy.ClassificationManager.evaluate_model", "modulename": "gaitsetpy", "qualname": "ClassificationManager.evaluate_model", "kind": "function", "doc": "<p>Evaluate a classification model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Evaluation metrics dictionary</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DaphnetLoader": {"fullname": "gaitsetpy.DaphnetLoader", "modulename": "gaitsetpy", "qualname": "DaphnetLoader", "kind": "class", "doc": "<p>Daphnet dataset loader class.</p>\n\n<p>This class handles loading and processing of the Daphnet dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.DaphnetLoader.__init__": {"fullname": "gaitsetpy.DaphnetLoader.__init__", "modulename": "gaitsetpy", "qualname": "DaphnetLoader.__init__", "kind": "function", "doc": "<p>Initialize Daphnet loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.DaphnetLoader.metadata": {"fullname": "gaitsetpy.DaphnetLoader.metadata", "modulename": "gaitsetpy", "qualname": "DaphnetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.DaphnetLoader.load_data": {"fullname": "gaitsetpy.DaphnetLoader.load_data", "modulename": "gaitsetpy", "qualname": "DaphnetLoader.load_data", "kind": "function", "doc": "<p>Load Daphnet dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for Daphnet)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DaphnetLoader.create_sliding_windows": {"fullname": "gaitsetpy.DaphnetLoader.create_sliding_windows", "modulename": "gaitsetpy", "qualname": "DaphnetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the Daphnet dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing Daphnet data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DaphnetLoader.get_supported_formats": {"fullname": "gaitsetpy.DaphnetLoader.get_supported_formats", "modulename": "gaitsetpy", "qualname": "DaphnetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for Daphnet dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DaphnetLoader.get_sensor_info": {"fullname": "gaitsetpy.DaphnetLoader.get_sensor_info", "modulename": "gaitsetpy", "qualname": "DaphnetLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DaphnetLoader.get_annotation_info": {"fullname": "gaitsetpy.DaphnetLoader.get_annotation_info", "modulename": "gaitsetpy", "qualname": "DaphnetLoader.get_annotation_info", "kind": "function", "doc": "<p>Get information about annotations in the dataset.</p>\n\n<p>Returns:\n    Dictionary mapping annotation values to descriptions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.MobiFallLoader": {"fullname": "gaitsetpy.MobiFallLoader", "modulename": "gaitsetpy", "qualname": "MobiFallLoader", "kind": "class", "doc": "<p>MobiFall dataset loader class.</p>\n\n<p>This class handles loading and processing of the MobiFall dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.MobiFallLoader.__init__": {"fullname": "gaitsetpy.MobiFallLoader.__init__", "modulename": "gaitsetpy", "qualname": "MobiFallLoader.__init__", "kind": "function", "doc": "<p>Initialize MobiFall loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.MobiFallLoader.metadata": {"fullname": "gaitsetpy.MobiFallLoader.metadata", "modulename": "gaitsetpy", "qualname": "MobiFallLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.MobiFallLoader.load_data": {"fullname": "gaitsetpy.MobiFallLoader.load_data", "modulename": "gaitsetpy", "qualname": "MobiFallLoader.load_data", "kind": "function", "doc": "<p>Load MobiFall dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for MobiFall)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.MobiFallLoader.create_sliding_windows": {"fullname": "gaitsetpy.MobiFallLoader.create_sliding_windows", "modulename": "gaitsetpy", "qualname": "MobiFallLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the MobiFall dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing MobiFall data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.MobiFallLoader.get_supported_formats": {"fullname": "gaitsetpy.MobiFallLoader.get_supported_formats", "modulename": "gaitsetpy", "qualname": "MobiFallLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for MobiFall dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.MobiFallLoader.get_sensor_info": {"fullname": "gaitsetpy.MobiFallLoader.get_sensor_info", "modulename": "gaitsetpy", "qualname": "MobiFallLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.MobiFallLoader.get_activity_info": {"fullname": "gaitsetpy.MobiFallLoader.get_activity_info", "modulename": "gaitsetpy", "qualname": "MobiFallLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    List of activity types</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ArduousLoader": {"fullname": "gaitsetpy.ArduousLoader", "modulename": "gaitsetpy", "qualname": "ArduousLoader", "kind": "class", "doc": "<p>Arduous dataset loader class.</p>\n\n<p>This class handles loading and processing of the Arduous dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.ArduousLoader.__init__": {"fullname": "gaitsetpy.ArduousLoader.__init__", "modulename": "gaitsetpy", "qualname": "ArduousLoader.__init__", "kind": "function", "doc": "<p>Initialize Arduous loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.ArduousLoader.metadata": {"fullname": "gaitsetpy.ArduousLoader.metadata", "modulename": "gaitsetpy", "qualname": "ArduousLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.ArduousLoader.load_data": {"fullname": "gaitsetpy.ArduousLoader.load_data", "modulename": "gaitsetpy", "qualname": "ArduousLoader.load_data", "kind": "function", "doc": "<p>Load Arduous dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for Arduous)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ArduousLoader.create_sliding_windows": {"fullname": "gaitsetpy.ArduousLoader.create_sliding_windows", "modulename": "gaitsetpy", "qualname": "ArduousLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the Arduous dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing Arduous data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ArduousLoader.get_supported_formats": {"fullname": "gaitsetpy.ArduousLoader.get_supported_formats", "modulename": "gaitsetpy", "qualname": "ArduousLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for Arduous dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ArduousLoader.get_sensor_info": {"fullname": "gaitsetpy.ArduousLoader.get_sensor_info", "modulename": "gaitsetpy", "qualname": "ArduousLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ArduousLoader.get_activity_info": {"fullname": "gaitsetpy.ArduousLoader.get_activity_info", "modulename": "gaitsetpy", "qualname": "ArduousLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    List of activity types</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetLoader": {"fullname": "gaitsetpy.PhysioNetLoader", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader", "kind": "class", "doc": "<p>PhysioNet VGRF dataset loader class.</p>\n\n<p>This class handles loading and processing of the PhysioNet Gait in Parkinson's Disease dataset.\nThe dataset contains vertical ground reaction force (VGRF) data from subjects with Parkinson's \ndisease and healthy controls.</p>\n\n<p>Features concurrent downloading for efficient data retrieval.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.PhysioNetLoader.__init__": {"fullname": "gaitsetpy.PhysioNetLoader.__init__", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.__init__", "kind": "function", "doc": "<p>Initialize PhysioNet loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.PhysioNetLoader.metadata": {"fullname": "gaitsetpy.PhysioNetLoader.metadata", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.PhysioNetLoader.labels": {"fullname": "gaitsetpy.PhysioNetLoader.labels", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.labels", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.PhysioNetLoader.subject_types": {"fullname": "gaitsetpy.PhysioNetLoader.subject_types", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.subject_types", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.PhysioNetLoader.load_data": {"fullname": "gaitsetpy.PhysioNetLoader.load_data", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.load_data", "kind": "function", "doc": "<p>Load PhysioNet VGRF dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for PhysioNet)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetLoader.create_sliding_windows": {"fullname": "gaitsetpy.PhysioNetLoader.create_sliding_windows", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the PhysioNet dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing PhysioNet data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 600 for 6 seconds at 100Hz)\n    step_size: Step size for the sliding window (default: 100)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">600</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetLoader.get_supported_formats": {"fullname": "gaitsetpy.PhysioNetLoader.get_supported_formats", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for PhysioNet dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetLoader.get_sensor_info": {"fullname": "gaitsetpy.PhysioNetLoader.get_sensor_info", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetLoader.get_subject_info": {"fullname": "gaitsetpy.PhysioNetLoader.get_subject_info", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.get_subject_info", "kind": "function", "doc": "<p>Get information about subjects in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing subject information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetLoader.get_labels": {"fullname": "gaitsetpy.PhysioNetLoader.get_labels", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.get_labels", "kind": "function", "doc": "<p>Get labels for loaded data.</p>\n\n<p>Returns:\n    List of labels corresponding to loaded data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetLoader.filter_by_subject_type": {"fullname": "gaitsetpy.PhysioNetLoader.filter_by_subject_type", "modulename": "gaitsetpy", "qualname": "PhysioNetLoader.filter_by_subject_type", "kind": "function", "doc": "<p>Filter loaded data by subject type.</p>\n\n<p>Args:\n    subject_type: 'Control' or 'Patient'</p>\n\n<p>Returns:\n    Tuple of (filtered_data, filtered_names)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">subject_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.GaitFeatureExtractor": {"fullname": "gaitsetpy.GaitFeatureExtractor", "modulename": "gaitsetpy", "qualname": "GaitFeatureExtractor", "kind": "class", "doc": "<p>Comprehensive gait feature extractor class.</p>\n\n<p>This class extracts various time-domain, frequency-domain, and statistical features\nfrom gait data sliding windows.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.GaitFeatureExtractor.__init__": {"fullname": "gaitsetpy.GaitFeatureExtractor.__init__", "modulename": "gaitsetpy", "qualname": "GaitFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.GaitFeatureExtractor.verbose": {"fullname": "gaitsetpy.GaitFeatureExtractor.verbose", "modulename": "gaitsetpy", "qualname": "GaitFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.GaitFeatureExtractor.config": {"fullname": "gaitsetpy.GaitFeatureExtractor.config", "modulename": "gaitsetpy", "qualname": "GaitFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.GaitFeatureExtractor.extract_features": {"fullname": "gaitsetpy.GaitFeatureExtractor.extract_features", "modulename": "gaitsetpy", "qualname": "GaitFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract gait features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments including time_domain, frequency_domain, statistical flags</p>\n\n<p>Returns:\n    List of feature dictionaries for each sensor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.GaitFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.GaitFeatureExtractor.get_feature_names", "modulename": "gaitsetpy", "qualname": "GaitFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of all features that can be extracted.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.GaitFeatureExtractor.print_extraction_summary": {"fullname": "gaitsetpy.GaitFeatureExtractor.print_extraction_summary", "modulename": "gaitsetpy", "qualname": "GaitFeatureExtractor.print_extraction_summary", "kind": "function", "doc": "<p>Print a detailed summary of extracted features.</p>\n\n<p>Args:\n    features: List of feature dictionaries returned by extract_features</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.LBPFeatureExtractor": {"fullname": "gaitsetpy.LBPFeatureExtractor", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor", "kind": "class", "doc": "<p>Local Binary Pattern (LBP) feature extractor for VGRF data.</p>\n\n<p>This extractor converts time-series data into LBP codes and extracts\nhistogram features from the LBP representation.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.LBPFeatureExtractor.__init__": {"fullname": "gaitsetpy.LBPFeatureExtractor.__init__", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.LBPFeatureExtractor.verbose": {"fullname": "gaitsetpy.LBPFeatureExtractor.verbose", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.LBPFeatureExtractor.config": {"fullname": "gaitsetpy.LBPFeatureExtractor.config", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.LBPFeatureExtractor.lbp_1d": {"fullname": "gaitsetpy.LBPFeatureExtractor.lbp_1d", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor.lbp_1d", "kind": "function", "doc": "<p>Compute 1D Local Binary Pattern for time-series data.</p>\n\n<p>Args:\n    data: Input time-series data\n    radius: Radius for LBP computation</p>\n\n<p>Returns:\n    LBP code as binary string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>, </span><span class=\"param\"><span class=\"n\">radius</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.LBPFeatureExtractor.lbp_to_histogram": {"fullname": "gaitsetpy.LBPFeatureExtractor.lbp_to_histogram", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor.lbp_to_histogram", "kind": "function", "doc": "<p>Convert LBP code to histogram features.</p>\n\n<p>Args:\n    lbp_code: Binary LBP code string\n    n_bins: Number of histogram bins\n    normalize: Whether to normalize histogram</p>\n\n<p>Returns:\n    Histogram features as numpy array</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lbp_code</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">n_bins</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">256</span>,</span><span class=\"param\">\t<span class=\"n\">normalize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.LBPFeatureExtractor.extract_features": {"fullname": "gaitsetpy.LBPFeatureExtractor.extract_features", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract LBP features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency (unused for LBP)\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.LBPFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.LBPFeatureExtractor.get_feature_names", "modulename": "gaitsetpy", "qualname": "LBPFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of LBP features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.FourierSeriesFeatureExtractor": {"fullname": "gaitsetpy.FourierSeriesFeatureExtractor", "modulename": "gaitsetpy", "qualname": "FourierSeriesFeatureExtractor", "kind": "class", "doc": "<p>Fourier Series feature extractor for VGRF data.</p>\n\n<p>This extractor fits Fourier series to time-series data and extracts\ncoefficients and reconstruction features.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.FourierSeriesFeatureExtractor.__init__": {"fullname": "gaitsetpy.FourierSeriesFeatureExtractor.__init__", "modulename": "gaitsetpy", "qualname": "FourierSeriesFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.FourierSeriesFeatureExtractor.verbose": {"fullname": "gaitsetpy.FourierSeriesFeatureExtractor.verbose", "modulename": "gaitsetpy", "qualname": "FourierSeriesFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.FourierSeriesFeatureExtractor.config": {"fullname": "gaitsetpy.FourierSeriesFeatureExtractor.config", "modulename": "gaitsetpy", "qualname": "FourierSeriesFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.FourierSeriesFeatureExtractor.fit_fourier_series": {"fullname": "gaitsetpy.FourierSeriesFeatureExtractor.fit_fourier_series", "modulename": "gaitsetpy", "qualname": "FourierSeriesFeatureExtractor.fit_fourier_series", "kind": "function", "doc": "<p>Fit Fourier series to signal.</p>\n\n<p>Args:\n    signal: Input signal\n    time_points: Time points\n    period: Period of the Fourier series\n    n_terms: Number of Fourier terms</p>\n\n<p>Returns:\n    Dictionary containing Fourier series parameters</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">signal</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">time_points</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">period</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">3.0</span>,</span><span class=\"param\">\t<span class=\"n\">n_terms</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.FourierSeriesFeatureExtractor.extract_features": {"fullname": "gaitsetpy.FourierSeriesFeatureExtractor.extract_features", "modulename": "gaitsetpy", "qualname": "FourierSeriesFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract Fourier series features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.FourierSeriesFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.FourierSeriesFeatureExtractor.get_feature_names", "modulename": "gaitsetpy", "qualname": "FourierSeriesFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of Fourier series features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetFeatureExtractor": {"fullname": "gaitsetpy.PhysioNetFeatureExtractor", "modulename": "gaitsetpy", "qualname": "PhysioNetFeatureExtractor", "kind": "class", "doc": "<p>Combined feature extractor for PhysioNet VGRF data.</p>\n\n<p>This extractor combines LBP and Fourier series features along with\nbasic statistical features specific to VGRF data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.PhysioNetFeatureExtractor.__init__": {"fullname": "gaitsetpy.PhysioNetFeatureExtractor.__init__", "modulename": "gaitsetpy", "qualname": "PhysioNetFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.PhysioNetFeatureExtractor.verbose": {"fullname": "gaitsetpy.PhysioNetFeatureExtractor.verbose", "modulename": "gaitsetpy", "qualname": "PhysioNetFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.PhysioNetFeatureExtractor.lbp_extractor": {"fullname": "gaitsetpy.PhysioNetFeatureExtractor.lbp_extractor", "modulename": "gaitsetpy", "qualname": "PhysioNetFeatureExtractor.lbp_extractor", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.PhysioNetFeatureExtractor.fourier_extractor": {"fullname": "gaitsetpy.PhysioNetFeatureExtractor.fourier_extractor", "modulename": "gaitsetpy", "qualname": "PhysioNetFeatureExtractor.fourier_extractor", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.PhysioNetFeatureExtractor.extract_features": {"fullname": "gaitsetpy.PhysioNetFeatureExtractor.extract_features", "modulename": "gaitsetpy", "qualname": "PhysioNetFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract combined features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.PhysioNetFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.PhysioNetFeatureExtractor.get_feature_names", "modulename": "gaitsetpy", "qualname": "PhysioNetFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of all features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ClippingPreprocessor": {"fullname": "gaitsetpy.ClippingPreprocessor", "modulename": "gaitsetpy", "qualname": "ClippingPreprocessor", "kind": "class", "doc": "<p>Preprocessor for clipping values to a specified range.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.ClippingPreprocessor.__init__": {"fullname": "gaitsetpy.ClippingPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "ClippingPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span>)</span>"}, "gaitsetpy.ClippingPreprocessor.config": {"fullname": "gaitsetpy.ClippingPreprocessor.config", "modulename": "gaitsetpy", "qualname": "ClippingPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.ClippingPreprocessor.fit": {"fullname": "gaitsetpy.ClippingPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "ClippingPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for clipping).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.ClippingPreprocessor.transform": {"fullname": "gaitsetpy.ClippingPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "ClippingPreprocessor.transform", "kind": "function", "doc": "<p>Clip values in the data to be within the specified range.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Clipped data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.NoiseRemovalPreprocessor": {"fullname": "gaitsetpy.NoiseRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "NoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing noise using moving average filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.NoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.NoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "NoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">5</span></span>)</span>"}, "gaitsetpy.NoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.NoiseRemovalPreprocessor.config", "modulename": "gaitsetpy", "qualname": "NoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.NoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.NoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "NoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for noise removal).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.NoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.NoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "NoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a moving average filter to reduce noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Noise-reduced data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.OutlierRemovalPreprocessor": {"fullname": "gaitsetpy.OutlierRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "OutlierRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing outliers using Z-score method.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.OutlierRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.OutlierRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "OutlierRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">threshold</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">3</span></span>)</span>"}, "gaitsetpy.OutlierRemovalPreprocessor.config": {"fullname": "gaitsetpy.OutlierRemovalPreprocessor.config", "modulename": "gaitsetpy", "qualname": "OutlierRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.OutlierRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.OutlierRemovalPreprocessor.mean_", "modulename": "gaitsetpy", "qualname": "OutlierRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.OutlierRemovalPreprocessor.std_": {"fullname": "gaitsetpy.OutlierRemovalPreprocessor.std_", "modulename": "gaitsetpy", "qualname": "OutlierRemovalPreprocessor.std_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.OutlierRemovalPreprocessor.fit": {"fullname": "gaitsetpy.OutlierRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "OutlierRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing mean and standard deviation.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.OutlierRemovalPreprocessor.transform": {"fullname": "gaitsetpy.OutlierRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "OutlierRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove outliers beyond the threshold using Z-score method.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Data with outliers removed</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.BaselineRemovalPreprocessor": {"fullname": "gaitsetpy.BaselineRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "BaselineRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing baseline by subtracting the mean.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.BaselineRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.BaselineRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "BaselineRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.BaselineRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.BaselineRemovalPreprocessor.mean_", "modulename": "gaitsetpy", "qualname": "BaselineRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.BaselineRemovalPreprocessor.fit": {"fullname": "gaitsetpy.BaselineRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "BaselineRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing the mean.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.BaselineRemovalPreprocessor.transform": {"fullname": "gaitsetpy.BaselineRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "BaselineRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove baseline by subtracting the mean.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Baseline-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DriftRemovalPreprocessor": {"fullname": "gaitsetpy.DriftRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "DriftRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing low-frequency drift using high-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.DriftRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.DriftRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "DriftRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.01</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.DriftRemovalPreprocessor.config": {"fullname": "gaitsetpy.DriftRemovalPreprocessor.config", "modulename": "gaitsetpy", "qualname": "DriftRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.DriftRemovalPreprocessor.fit": {"fullname": "gaitsetpy.DriftRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "DriftRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for drift removal).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.DriftRemovalPreprocessor.transform": {"fullname": "gaitsetpy.DriftRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "DriftRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove low-frequency drift using a high-pass filter.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Drift-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor": {"fullname": "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "HighFrequencyNoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing high-frequency noise using low-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "HighFrequencyNoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.config", "modulename": "gaitsetpy", "qualname": "HighFrequencyNoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "HighFrequencyNoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for filtering).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "HighFrequencyNoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a low-pass filter to remove high-frequency noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Filtered data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor": {"fullname": "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "LowFrequencyNoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing low-frequency noise using high-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "LowFrequencyNoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.config", "modulename": "gaitsetpy", "qualname": "LowFrequencyNoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "LowFrequencyNoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for filtering).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "LowFrequencyNoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a high-pass filter to remove low-frequency noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Filtered data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.ArtifactRemovalPreprocessor": {"fullname": "gaitsetpy.ArtifactRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "ArtifactRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing artifacts by interpolating missing values.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.ArtifactRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.ArtifactRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "ArtifactRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">method</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;linear&#39;</span></span>)</span>"}, "gaitsetpy.ArtifactRemovalPreprocessor.config": {"fullname": "gaitsetpy.ArtifactRemovalPreprocessor.config", "modulename": "gaitsetpy", "qualname": "ArtifactRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.ArtifactRemovalPreprocessor.fit": {"fullname": "gaitsetpy.ArtifactRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "ArtifactRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for interpolation).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.ArtifactRemovalPreprocessor.transform": {"fullname": "gaitsetpy.ArtifactRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "ArtifactRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove artifacts by interpolating missing values.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Artifact-free data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.TrendRemovalPreprocessor": {"fullname": "gaitsetpy.TrendRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "TrendRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing trends using polynomial fitting.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.TrendRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.TrendRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "TrendRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">order</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span>)</span>"}, "gaitsetpy.TrendRemovalPreprocessor.config": {"fullname": "gaitsetpy.TrendRemovalPreprocessor.config", "modulename": "gaitsetpy", "qualname": "TrendRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.TrendRemovalPreprocessor.fit": {"fullname": "gaitsetpy.TrendRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "TrendRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for detrending).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.TrendRemovalPreprocessor.transform": {"fullname": "gaitsetpy.TrendRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "TrendRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove trends using polynomial fitting.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Detrended data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DCOffsetRemovalPreprocessor": {"fullname": "gaitsetpy.DCOffsetRemovalPreprocessor", "modulename": "gaitsetpy", "qualname": "DCOffsetRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing DC offset by subtracting the mean.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.DCOffsetRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.DCOffsetRemovalPreprocessor.__init__", "modulename": "gaitsetpy", "qualname": "DCOffsetRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.DCOffsetRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.DCOffsetRemovalPreprocessor.mean_", "modulename": "gaitsetpy", "qualname": "DCOffsetRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.DCOffsetRemovalPreprocessor.fit": {"fullname": "gaitsetpy.DCOffsetRemovalPreprocessor.fit", "modulename": "gaitsetpy", "qualname": "DCOffsetRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing the mean.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.DCOffsetRemovalPreprocessor.transform": {"fullname": "gaitsetpy.DCOffsetRemovalPreprocessor.transform", "modulename": "gaitsetpy", "qualname": "DCOffsetRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove DC offset by subtracting the mean.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    DC-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DaphnetVisualizationAnalyzer": {"fullname": "gaitsetpy.DaphnetVisualizationAnalyzer", "modulename": "gaitsetpy", "qualname": "DaphnetVisualizationAnalyzer", "kind": "class", "doc": "<p>EDA analyzer for Daphnet dataset visualization.</p>\n\n<p>This analyzer provides comprehensive visualization capabilities for Daphnet dataset\nincluding thigh, shank, and trunk sensor data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseEDAAnalyzer"}, "gaitsetpy.DaphnetVisualizationAnalyzer.__init__": {"fullname": "gaitsetpy.DaphnetVisualizationAnalyzer.__init__", "modulename": "gaitsetpy", "qualname": "DaphnetVisualizationAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.DaphnetVisualizationAnalyzer.config": {"fullname": "gaitsetpy.DaphnetVisualizationAnalyzer.config", "modulename": "gaitsetpy", "qualname": "DaphnetVisualizationAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.DaphnetVisualizationAnalyzer.analyze": {"fullname": "gaitsetpy.DaphnetVisualizationAnalyzer.analyze", "modulename": "gaitsetpy", "qualname": "DaphnetVisualizationAnalyzer.analyze", "kind": "function", "doc": "<p>Analyze the data and return statistical summaries.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.DaphnetVisualizationAnalyzer.visualize": {"fullname": "gaitsetpy.DaphnetVisualizationAnalyzer.visualize", "modulename": "gaitsetpy", "qualname": "DaphnetVisualizationAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of the data.</p>\n\n<p>Args:\n    data: Input data to visualize\n    **kwargs: Additional arguments including sensor_type, dataset_index, names</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.SensorStatisticsAnalyzer": {"fullname": "gaitsetpy.SensorStatisticsAnalyzer", "modulename": "gaitsetpy", "qualname": "SensorStatisticsAnalyzer", "kind": "class", "doc": "<p>EDA analyzer for sensor data statistics and feature visualization.</p>\n\n<p>This analyzer provides statistical analysis and feature visualization capabilities\nfor sensor data including sliding windows and extracted features.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseEDAAnalyzer"}, "gaitsetpy.SensorStatisticsAnalyzer.__init__": {"fullname": "gaitsetpy.SensorStatisticsAnalyzer.__init__", "modulename": "gaitsetpy", "qualname": "SensorStatisticsAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.SensorStatisticsAnalyzer.config": {"fullname": "gaitsetpy.SensorStatisticsAnalyzer.config", "modulename": "gaitsetpy", "qualname": "SensorStatisticsAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.SensorStatisticsAnalyzer.analyze": {"fullname": "gaitsetpy.SensorStatisticsAnalyzer.analyze", "modulename": "gaitsetpy", "qualname": "SensorStatisticsAnalyzer.analyze", "kind": "function", "doc": "<p>Analyze sensor data and return statistical summaries.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.SensorStatisticsAnalyzer.visualize": {"fullname": "gaitsetpy.SensorStatisticsAnalyzer.visualize", "modulename": "gaitsetpy", "qualname": "SensorStatisticsAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of sensor data with overlaid features.</p>\n\n<p>Args:\n    sliding_windows: List of sliding window dictionaries\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including sensor_name, start_idx, end_idx, num_windows</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sliding_windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.RandomForestModel": {"fullname": "gaitsetpy.RandomForestModel", "modulename": "gaitsetpy", "qualname": "RandomForestModel", "kind": "class", "doc": "<p>Random Forest classification model.</p>\n\n<p>This class provides Random Forest classification functionality with\ncomprehensive training, prediction, and evaluation capabilities.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.RandomForestModel.__init__": {"fullname": "gaitsetpy.RandomForestModel.__init__", "modulename": "gaitsetpy", "qualname": "RandomForestModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">n_estimators</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">random_state</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">42</span>,</span><span class=\"param\">\t<span class=\"n\">max_depth</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "gaitsetpy.RandomForestModel.config": {"fullname": "gaitsetpy.RandomForestModel.config", "modulename": "gaitsetpy", "qualname": "RandomForestModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.RandomForestModel.model": {"fullname": "gaitsetpy.RandomForestModel.model", "modulename": "gaitsetpy", "qualname": "RandomForestModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.RandomForestModel.feature_names": {"fullname": "gaitsetpy.RandomForestModel.feature_names", "modulename": "gaitsetpy", "qualname": "RandomForestModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.RandomForestModel.class_names": {"fullname": "gaitsetpy.RandomForestModel.class_names", "modulename": "gaitsetpy", "qualname": "RandomForestModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.RandomForestModel.train": {"fullname": "gaitsetpy.RandomForestModel.train", "modulename": "gaitsetpy", "qualname": "RandomForestModel.train", "kind": "function", "doc": "<p>Train the Random Forest model on the given features.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including test_size, validation_split</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.RandomForestModel.predict": {"fullname": "gaitsetpy.RandomForestModel.predict", "modulename": "gaitsetpy", "qualname": "RandomForestModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained Random Forest model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including return_probabilities</p>\n\n<p>Returns:\n    Array of predictions or probabilities</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.RandomForestModel.evaluate": {"fullname": "gaitsetpy.RandomForestModel.evaluate", "modulename": "gaitsetpy", "qualname": "RandomForestModel.evaluate", "kind": "function", "doc": "<p>Evaluate the Random Forest model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including detailed_report</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.RandomForestModel.save_model": {"fullname": "gaitsetpy.RandomForestModel.save_model", "modulename": "gaitsetpy", "qualname": "RandomForestModel.save_model", "kind": "function", "doc": "<p>Save the trained Random Forest model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.RandomForestModel.load_model": {"fullname": "gaitsetpy.RandomForestModel.load_model", "modulename": "gaitsetpy", "qualname": "RandomForestModel.load_model", "kind": "function", "doc": "<p>Load a trained Random Forest model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.RandomForestModel.get_feature_importance": {"fullname": "gaitsetpy.RandomForestModel.get_feature_importance", "modulename": "gaitsetpy", "qualname": "RandomForestModel.get_feature_importance", "kind": "function", "doc": "<p>Get feature importance scores.</p>\n\n<p>Returns:\n    Dictionary mapping feature names to importance scores</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.RandomForestModel.predict_single": {"fullname": "gaitsetpy.RandomForestModel.predict_single", "modulename": "gaitsetpy", "qualname": "RandomForestModel.predict_single", "kind": "function", "doc": "<p>Make prediction for a single feature vector.</p>\n\n<p>Args:\n    single_features: Dictionary containing features for a single sample</p>\n\n<p>Returns:\n    Predicted class</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">single_features</span><span class=\"p\">:</span> <span class=\"n\">Dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.get_dataset_manager": {"fullname": "gaitsetpy.get_dataset_manager", "modulename": "gaitsetpy", "qualname": "get_dataset_manager", "kind": "function", "doc": "<p>Get the singleton DatasetManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_feature_manager": {"fullname": "gaitsetpy.get_feature_manager", "modulename": "gaitsetpy", "qualname": "get_feature_manager", "kind": "function", "doc": "<p>Get the singleton FeatureManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_preprocessing_manager": {"fullname": "gaitsetpy.get_preprocessing_manager", "modulename": "gaitsetpy", "qualname": "get_preprocessing_manager", "kind": "function", "doc": "<p>Get the singleton PreprocessingManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_eda_manager": {"fullname": "gaitsetpy.get_eda_manager", "modulename": "gaitsetpy", "qualname": "get_eda_manager", "kind": "function", "doc": "<p>Get the singleton EDAManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_classification_manager": {"fullname": "gaitsetpy.get_classification_manager", "modulename": "gaitsetpy", "qualname": "get_classification_manager", "kind": "function", "doc": "<p>Get the singleton ClassificationManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_all_managers": {"fullname": "gaitsetpy.get_all_managers", "modulename": "gaitsetpy", "qualname": "get_all_managers", "kind": "function", "doc": "<p>Get all singleton managers.</p>\n\n<p>Returns:\n    Dictionary containing all manager instances</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_available_datasets": {"fullname": "gaitsetpy.get_available_datasets", "modulename": "gaitsetpy", "qualname": "get_available_datasets", "kind": "function", "doc": "<p>Get list of available dataset names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_available_extractors": {"fullname": "gaitsetpy.get_available_extractors", "modulename": "gaitsetpy", "qualname": "get_available_extractors", "kind": "function", "doc": "<p>Get list of available feature extractor names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_available_preprocessors": {"fullname": "gaitsetpy.get_available_preprocessors", "modulename": "gaitsetpy", "qualname": "get_available_preprocessors", "kind": "function", "doc": "<p>Get list of available preprocessor names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_available_analyzers": {"fullname": "gaitsetpy.get_available_analyzers", "modulename": "gaitsetpy", "qualname": "get_available_analyzers", "kind": "function", "doc": "<p>Get list of available EDA analyzer names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_available_models": {"fullname": "gaitsetpy.get_available_models", "modulename": "gaitsetpy", "qualname": "get_available_models", "kind": "function", "doc": "<p>Get list of available classification model names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_system_info": {"fullname": "gaitsetpy.get_system_info", "modulename": "gaitsetpy", "qualname": "get_system_info", "kind": "function", "doc": "<p>Get information about the available components in the system.</p>\n\n<p>Returns:\n    Dictionary containing system information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.load_and_analyze_daphnet": {"fullname": "gaitsetpy.load_and_analyze_daphnet", "modulename": "gaitsetpy", "qualname": "load_and_analyze_daphnet", "kind": "function", "doc": "<p>Complete workflow for loading and analyzing Daphnet data.</p>\n\n<p>Args:\n    data_dir: Directory containing the Daphnet dataset\n    sensor_type: Type of sensor to analyze ('all', 'thigh', 'shank', 'trunk')\n    window_size: Size of sliding windows for feature extraction</p>\n\n<p>Returns:\n    Dictionary containing data, features, and analysis results</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">sensor_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;all&#39;</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.load_and_analyze_physionet": {"fullname": "gaitsetpy.load_and_analyze_physionet", "modulename": "gaitsetpy", "qualname": "load_and_analyze_physionet", "kind": "function", "doc": "<p>Complete workflow for loading and analyzing PhysioNet VGRF data.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the PhysioNet dataset\n    window_size: Size of sliding windows for feature extraction (default: 600)\n    step_size: Step size for sliding windows (default: 100)</p>\n\n<p>Returns:\n    Dictionary containing data, features, and analysis results</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">600</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.train_gait_classifier": {"fullname": "gaitsetpy.train_gait_classifier", "modulename": "gaitsetpy", "qualname": "train_gait_classifier", "kind": "function", "doc": "<p>Train a gait classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    model_type: Type of model to train ('random_forest', etc.)\n    **kwargs: Additional arguments for model training</p>\n\n<p>Returns:\n    Trained model instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">features</span>, </span><span class=\"param\"><span class=\"n\">model_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;random_forest&#39;</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.load_daphnet_data": {"fullname": "gaitsetpy.load_daphnet_data", "modulename": "gaitsetpy", "qualname": "load_daphnet_data", "kind": "function", "doc": "<p>Legacy function for loading Daphnet data.</p>\n\n<p>Args:\n    data_dir: Directory to store the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.create_sliding_windows": {"fullname": "gaitsetpy.create_sliding_windows", "modulename": "gaitsetpy", "qualname": "create_sliding_windows", "kind": "function", "doc": "<p>Legacy function for creating sliding windows.</p>\n\n<p>Args:\n    daphnet: List of dataframes containing Daphnet data\n    daphnet_names: List of names of the Daphnet dataframes\n    window_size: Size of the sliding window\n    step_size: Step size for the sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnet</span>, </span><span class=\"param\"><span class=\"n\">daphnet_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">192</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">32</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.load_mobifall_data": {"fullname": "gaitsetpy.load_mobifall_data", "modulename": "gaitsetpy", "qualname": "load_mobifall_data", "kind": "function", "doc": "<p>Legacy function for loading MobiFall data.</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.load_arduous_data": {"fullname": "gaitsetpy.load_arduous_data", "modulename": "gaitsetpy", "qualname": "load_arduous_data", "kind": "function", "doc": "<p>Legacy function for loading Arduous data.</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.load_physionet_data": {"fullname": "gaitsetpy.load_physionet_data", "modulename": "gaitsetpy", "qualname": "load_physionet_data", "kind": "function", "doc": "<p>Legacy function to load PhysioNet data.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.create_physionet_windows": {"fullname": "gaitsetpy.create_physionet_windows", "modulename": "gaitsetpy", "qualname": "create_physionet_windows", "kind": "function", "doc": "<p>Legacy function to create sliding windows from PhysioNet data.</p>\n\n<p>Args:\n    data: List of DataFrames\n    names: List of names\n    window_size: Size of sliding window\n    step_size: Step size for sliding window</p>\n\n<p>Returns:\n    List of sliding window dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">600</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.load_harup_data": {"fullname": "gaitsetpy.load_harup_data", "modulename": "gaitsetpy", "qualname": "load_harup_data", "kind": "function", "doc": "<p>Legacy function for loading HAR-UP data.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    subjects: List of subject IDs to load (default: all subjects)\n    activities: List of activity IDs to load (default: all activities)\n    trials: List of trial IDs to load (default: all trials)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">subjects</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">activities</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">trials</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.create_harup_windows": {"fullname": "gaitsetpy.create_harup_windows", "modulename": "gaitsetpy", "qualname": "create_harup_windows", "kind": "function", "doc": "<p>Legacy function for creating sliding windows from HAR-UP data.</p>\n\n<p>Args:\n    harup_data: List of dataframes containing HAR-UP data\n    harup_names: List of names of the HAR-UP dataframes\n    window_size: Size of the sliding window\n    step_size: Step size for the sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_data</span>, </span><span class=\"param\"><span class=\"n\">harup_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">50</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.extract_harup_features": {"fullname": "gaitsetpy.extract_harup_features", "modulename": "gaitsetpy", "qualname": "extract_harup_features", "kind": "function", "doc": "<p>Legacy function for extracting features from HAR-UP windows.</p>\n\n<p>Args:\n    windows_data: List of dictionaries containing sliding windows\n    time_domain: Whether to extract time domain features\n    freq_domain: Whether to extract frequency domain features</p>\n\n<p>Returns:\n    List of dictionaries containing extracted features</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows_data</span>, </span><span class=\"param\"><span class=\"n\">time_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">freq_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.download_dataset": {"fullname": "gaitsetpy.download_dataset", "modulename": "gaitsetpy", "qualname": "download_dataset", "kind": "function", "doc": "<p>Download the dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dataset_name</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.extract_dataset": {"fullname": "gaitsetpy.extract_dataset", "modulename": "gaitsetpy", "qualname": "extract_dataset", "kind": "function", "doc": "<p>Extract the dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dataset_name</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.sliding_window": {"fullname": "gaitsetpy.sliding_window", "modulename": "gaitsetpy", "qualname": "sliding_window", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">window_size</span>, </span><span class=\"param\"><span class=\"n\">step_size</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_mean": {"fullname": "gaitsetpy.calculate_mean", "modulename": "gaitsetpy", "qualname": "calculate_mean", "kind": "function", "doc": "<p>Calculate the mean of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_standard_deviation": {"fullname": "gaitsetpy.calculate_standard_deviation", "modulename": "gaitsetpy", "qualname": "calculate_standard_deviation", "kind": "function", "doc": "<p>Calculate the standard deviation of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    std_dev (float): Standard deviation.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_variance": {"fullname": "gaitsetpy.calculate_variance", "modulename": "gaitsetpy", "qualname": "calculate_variance", "kind": "function", "doc": "<p>Calculate the variance of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    variance (float): Variance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_skewness": {"fullname": "gaitsetpy.calculate_skewness", "modulename": "gaitsetpy", "qualname": "calculate_skewness", "kind": "function", "doc": "<p>Calculate the skewness of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_kurtosis": {"fullname": "gaitsetpy.calculate_kurtosis", "modulename": "gaitsetpy", "qualname": "calculate_kurtosis", "kind": "function", "doc": "<p>Calculate the kurtosis of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    kurtosis_value (float): Kurtosis.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_root_mean_square": {"fullname": "gaitsetpy.calculate_root_mean_square", "modulename": "gaitsetpy", "qualname": "calculate_root_mean_square", "kind": "function", "doc": "<p>Calculate the root mean square of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_range": {"fullname": "gaitsetpy.calculate_range", "modulename": "gaitsetpy", "qualname": "calculate_range", "kind": "function", "doc": "<p>Calculate the range of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_median": {"fullname": "gaitsetpy.calculate_median", "modulename": "gaitsetpy", "qualname": "calculate_median", "kind": "function", "doc": "<p>Calculate the median of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_mode": {"fullname": "gaitsetpy.calculate_mode", "modulename": "gaitsetpy", "qualname": "calculate_mode", "kind": "function", "doc": "<p>Calculate the mode of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_mean_absolute_value": {"fullname": "gaitsetpy.calculate_mean_absolute_value", "modulename": "gaitsetpy", "qualname": "calculate_mean_absolute_value", "kind": "function", "doc": "<p>Calculate the mean absolute value of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_median_absolute_deviation": {"fullname": "gaitsetpy.calculate_median_absolute_deviation", "modulename": "gaitsetpy", "qualname": "calculate_median_absolute_deviation", "kind": "function", "doc": "<p>Calculate the median absolute deviation of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_peak_height": {"fullname": "gaitsetpy.calculate_peak_height", "modulename": "gaitsetpy", "qualname": "calculate_peak_height", "kind": "function", "doc": "<p>Calculate the peak height of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_stride_times": {"fullname": "gaitsetpy.calculate_stride_times", "modulename": "gaitsetpy", "qualname": "calculate_stride_times", "kind": "function", "doc": "<p>Calculate stride times from a signal using peak detection.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    avg_stride_time (float): Average stride time.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_step_time": {"fullname": "gaitsetpy.calculate_step_time", "modulename": "gaitsetpy", "qualname": "calculate_step_time", "kind": "function", "doc": "<p>Calculate step times from a signal using peak detection.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    step_times (np.array): Array of step times.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_cadence": {"fullname": "gaitsetpy.calculate_cadence", "modulename": "gaitsetpy", "qualname": "calculate_cadence", "kind": "function", "doc": "<p>Calculate the cadence (steps per minute) of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_freezing_index": {"fullname": "gaitsetpy.calculate_freezing_index", "modulename": "gaitsetpy", "qualname": "calculate_freezing_index", "kind": "function", "doc": "<p>Calculate the freezing index of a signal.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    freezing_index (float): Freezing index.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_dominant_frequency": {"fullname": "gaitsetpy.calculate_dominant_frequency", "modulename": "gaitsetpy", "qualname": "calculate_dominant_frequency", "kind": "function", "doc": "<p>Calculate the dominant frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_peak_frequency": {"fullname": "gaitsetpy.calculate_peak_frequency", "modulename": "gaitsetpy", "qualname": "calculate_peak_frequency", "kind": "function", "doc": "<p>Calculate the peak frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_power_spectral_entropy": {"fullname": "gaitsetpy.calculate_power_spectral_entropy", "modulename": "gaitsetpy", "qualname": "calculate_power_spectral_entropy", "kind": "function", "doc": "<p>Calculate the power spectral entropy of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_principal_harmonic_frequency": {"fullname": "gaitsetpy.calculate_principal_harmonic_frequency", "modulename": "gaitsetpy", "qualname": "calculate_principal_harmonic_frequency", "kind": "function", "doc": "<p>Calculate the principal harmonic frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_entropy": {"fullname": "gaitsetpy.calculate_entropy", "modulename": "gaitsetpy", "qualname": "calculate_entropy", "kind": "function", "doc": "<p>Calculate the entropy of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    entropy_value (float): Entropy.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_interquartile_range": {"fullname": "gaitsetpy.calculate_interquartile_range", "modulename": "gaitsetpy", "qualname": "calculate_interquartile_range", "kind": "function", "doc": "<p>Calculate the interquartile range of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_correlation": {"fullname": "gaitsetpy.calculate_correlation", "modulename": "gaitsetpy", "qualname": "calculate_correlation", "kind": "function", "doc": "<p>Calculate the correlation between two signals.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal1</span>, </span><span class=\"param\"><span class=\"n\">signal2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.calculate_auto_regression_coefficients": {"fullname": "gaitsetpy.calculate_auto_regression_coefficients", "modulename": "gaitsetpy", "qualname": "calculate_auto_regression_coefficients", "kind": "function", "doc": "<p>Calculate the auto-regression coefficients of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_mean_for_windows": {"fullname": "gaitsetpy.get_mean_for_windows", "modulename": "gaitsetpy", "qualname": "get_mean_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_standard_deviation_for_windows": {"fullname": "gaitsetpy.get_standard_deviation_for_windows", "modulename": "gaitsetpy", "qualname": "get_standard_deviation_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.get_variance_for_windows": {"fullname": "gaitsetpy.get_variance_for_windows", "modulename": "gaitsetpy", "qualname": "get_variance_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.clip_sliding_windows": {"fullname": "gaitsetpy.clip_sliding_windows", "modulename": "gaitsetpy", "qualname": "clip_sliding_windows", "kind": "function", "doc": "<p>Clip values in the sliding windows to be within a specified range.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_noise": {"fullname": "gaitsetpy.remove_noise", "modulename": "gaitsetpy", "qualname": "remove_noise", "kind": "function", "doc": "<p>Apply a moving average filter to reduce noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">5</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_outliers": {"fullname": "gaitsetpy.remove_outliers", "modulename": "gaitsetpy", "qualname": "remove_outliers", "kind": "function", "doc": "<p>Remove outliers beyond a given threshold using the Z-score method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">threshold</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_baseline": {"fullname": "gaitsetpy.remove_baseline", "modulename": "gaitsetpy", "qualname": "remove_baseline", "kind": "function", "doc": "<p>Remove baseline by subtracting the mean.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_drift": {"fullname": "gaitsetpy.remove_drift", "modulename": "gaitsetpy", "qualname": "remove_drift", "kind": "function", "doc": "<p>Remove low-frequency drift using a high-pass filter.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mf\">0.01</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_artifacts": {"fullname": "gaitsetpy.remove_artifacts", "modulename": "gaitsetpy", "qualname": "remove_artifacts", "kind": "function", "doc": "<p>Remove artifacts by interpolating missing values.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;interpolate&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_trend": {"fullname": "gaitsetpy.remove_trend", "modulename": "gaitsetpy", "qualname": "remove_trend", "kind": "function", "doc": "<p>Remove trends using polynomial fitting.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_dc_offset": {"fullname": "gaitsetpy.remove_dc_offset", "modulename": "gaitsetpy", "qualname": "remove_dc_offset", "kind": "function", "doc": "<p>Remove DC offset by subtracting the mean.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_high_frequency_noise": {"fullname": "gaitsetpy.remove_high_frequency_noise", "modulename": "gaitsetpy", "qualname": "remove_high_frequency_noise", "kind": "function", "doc": "<p>Apply a low-pass filter to remove high-frequency noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.remove_low_frequency_noise": {"fullname": "gaitsetpy.remove_low_frequency_noise", "modulename": "gaitsetpy", "qualname": "remove_low_frequency_noise", "kind": "function", "doc": "<p>Apply a high-pass filter to remove low-frequency noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_thigh_data": {"fullname": "gaitsetpy.plot_thigh_data", "modulename": "gaitsetpy", "qualname": "plot_thigh_data", "kind": "function", "doc": "<p>Plot thigh acceleration data for a specific dataset.\nArgs:\n    daphnetThigh (list): List of DataFrames containing thigh acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_shank_data": {"fullname": "gaitsetpy.plot_shank_data", "modulename": "gaitsetpy", "qualname": "plot_shank_data", "kind": "function", "doc": "<p>Plot shank acceleration data for a specific dataset.\nArgs:\n    daphnetShank (list): List of DataFrames containing shank acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_trunk_data": {"fullname": "gaitsetpy.plot_trunk_data", "modulename": "gaitsetpy", "qualname": "plot_trunk_data", "kind": "function", "doc": "<p>Plot trunk acceleration data for a specific dataset.\nArgs:\n    daphnetTrunk (list): List of DataFrames containing trunk acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_all_data": {"fullname": "gaitsetpy.plot_all_data", "modulename": "gaitsetpy", "qualname": "plot_all_data", "kind": "function", "doc": "<p>Plot thigh, shank, and trunk acceleration data for a specific dataset.\nArgs:\n    daphnetThigh (list): List of DataFrames containing thigh acceleration data.\n    daphnetShank (list): List of DataFrames containing shank acceleration data.\n    daphnetTrunk (list): List of DataFrames containing trunk acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_all_thigh_data": {"fullname": "gaitsetpy.plot_all_thigh_data", "modulename": "gaitsetpy", "qualname": "plot_all_thigh_data", "kind": "function", "doc": "<p>Plot thigh acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_all_shank_data": {"fullname": "gaitsetpy.plot_all_shank_data", "modulename": "gaitsetpy", "qualname": "plot_all_shank_data", "kind": "function", "doc": "<p>Plot shank acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_all_trunk_data": {"fullname": "gaitsetpy.plot_all_trunk_data", "modulename": "gaitsetpy", "qualname": "plot_all_trunk_data", "kind": "function", "doc": "<p>Plot trunk acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_all_datasets": {"fullname": "gaitsetpy.plot_all_datasets", "modulename": "gaitsetpy", "qualname": "plot_all_datasets", "kind": "function", "doc": "<p>Plot thigh, shank, and trunk acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.plot_sensor_with_features": {"fullname": "gaitsetpy.plot_sensor_with_features", "modulename": "gaitsetpy", "qualname": "plot_sensor_with_features", "kind": "function", "doc": "<p>@brief Plots sliding windows of a sensor's time series data with overlaid statistical features.</p>\n\n<p>This function plots the first <code>num_windows</code> sliding windows within the given <code>start_idx</code> and <code>end_idx</code>\nfor a specified sensor and overlays feature values at their corresponding time indices. \nIt also displays entropy and dominant frequency in a separate plot.</p>\n\n<p>@param[in] sliding_windows List of dictionaries, where each dictionary contains:\n               - 'name': sensor name (str)\n               - 'data': List of time-series windows (each as a Pandas Series)\n@param[in] features List of dictionaries, where each dictionary contains:\n               - 'name': sensor name (str)\n               - 'features': Dictionary of extracted feature lists\n@param[in] start_idx Start index of the time window to be plotted.\n@param[in] end_idx End index of the time window to be plotted.\n@param[in] sensor_name Name of the sensor to be plotted (default: \"shank\").\n@param[in] num_windows Number of sliding windows to plot (default: 10).\n@param[in] save If True, saves the plot to a file instead of displaying it.</p>\n\n<p>@return None</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sliding_windows</span>,</span><span class=\"param\">\t<span class=\"n\">features</span>,</span><span class=\"param\">\t<span class=\"n\">start_idx</span>,</span><span class=\"param\">\t<span class=\"n\">end_idx</span>,</span><span class=\"param\">\t<span class=\"n\">sensor_name</span><span class=\"o\">=</span><span class=\"s1\">&#39;shank&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">num_windows</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">save</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.create_random_forest_model": {"fullname": "gaitsetpy.create_random_forest_model", "modulename": "gaitsetpy", "qualname": "create_random_forest_model", "kind": "function", "doc": "<p>Create a Random Forest model with specified parameters.</p>\n\n<p>Args:\n    n_estimators: Number of trees in the forest\n    random_state: Random state for reproducibility\n    max_depth: Maximum depth of the tree</p>\n\n<p>Returns:\n    RandomForestModel instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n_estimators</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">random_state</span><span class=\"o\">=</span><span class=\"mi\">42</span>, </span><span class=\"param\"><span class=\"n\">max_depth</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocess_features": {"fullname": "gaitsetpy.preprocess_features", "modulename": "gaitsetpy", "qualname": "preprocess_features", "kind": "function", "doc": "<p>Convert the features dictionary into X (feature matrix) and y (labels),\nensuring all feature vectors have a consistent length.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">features</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.evaluate_model": {"fullname": "gaitsetpy.evaluate_model", "modulename": "gaitsetpy", "qualname": "evaluate_model", "kind": "function", "doc": "<p>Evaluates the given model on the provided features and prints accuracy and confusion matrix.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">model</span>, </span><span class=\"param\"><span class=\"n\">features</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification": {"fullname": "gaitsetpy.classification", "modulename": "gaitsetpy.classification", "kind": "module", "doc": "<p>classification: A module for training and evaluating classification models.</p>\n\n<p>This module provides both the new class-based classification models and legacy function-based API.\nAll classification models inherit from BaseClassificationModel and are registered with the ClassificationManager.</p>\n\n<p>Available Models:</p>\n\n<ul>\n<li>Random Forest (fully implemented)</li>\n<li>MLP (PyTorch) - TODO</li>\n<li>LSTM (PyTorch) - TODO  </li>\n<li>BiLSTM (PyTorch) - TODO</li>\n<li>GNN (PyTorch Geometric) - TODO</li>\n</ul>\n\n<p>Utilities:</p>\n\n<ul>\n<li>Dataset loading and preprocessing</li>\n<li>Model training and evaluation</li>\n<li>Feature preprocessing and preparation</li>\n</ul>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.classification.RandomForestModel": {"fullname": "gaitsetpy.classification.RandomForestModel", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel", "kind": "class", "doc": "<p>Random Forest classification model.</p>\n\n<p>This class provides Random Forest classification functionality with\ncomprehensive training, prediction, and evaluation capabilities.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.classification.RandomForestModel.__init__": {"fullname": "gaitsetpy.classification.RandomForestModel.__init__", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">n_estimators</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">random_state</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">42</span>,</span><span class=\"param\">\t<span class=\"n\">max_depth</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "gaitsetpy.classification.RandomForestModel.config": {"fullname": "gaitsetpy.classification.RandomForestModel.config", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.RandomForestModel.model": {"fullname": "gaitsetpy.classification.RandomForestModel.model", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.RandomForestModel.feature_names": {"fullname": "gaitsetpy.classification.RandomForestModel.feature_names", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.RandomForestModel.class_names": {"fullname": "gaitsetpy.classification.RandomForestModel.class_names", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.RandomForestModel.train": {"fullname": "gaitsetpy.classification.RandomForestModel.train", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.train", "kind": "function", "doc": "<p>Train the Random Forest model on the given features.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including test_size, validation_split</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.RandomForestModel.predict": {"fullname": "gaitsetpy.classification.RandomForestModel.predict", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained Random Forest model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including return_probabilities</p>\n\n<p>Returns:\n    Array of predictions or probabilities</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.RandomForestModel.evaluate": {"fullname": "gaitsetpy.classification.RandomForestModel.evaluate", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.evaluate", "kind": "function", "doc": "<p>Evaluate the Random Forest model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including detailed_report</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.RandomForestModel.save_model": {"fullname": "gaitsetpy.classification.RandomForestModel.save_model", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.save_model", "kind": "function", "doc": "<p>Save the trained Random Forest model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.RandomForestModel.load_model": {"fullname": "gaitsetpy.classification.RandomForestModel.load_model", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.load_model", "kind": "function", "doc": "<p>Load a trained Random Forest model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.RandomForestModel.get_feature_importance": {"fullname": "gaitsetpy.classification.RandomForestModel.get_feature_importance", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.get_feature_importance", "kind": "function", "doc": "<p>Get feature importance scores.</p>\n\n<p>Returns:\n    Dictionary mapping feature names to importance scores</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.RandomForestModel.predict_single": {"fullname": "gaitsetpy.classification.RandomForestModel.predict_single", "modulename": "gaitsetpy.classification", "qualname": "RandomForestModel.predict_single", "kind": "function", "doc": "<p>Make prediction for a single feature vector.</p>\n\n<p>Args:\n    single_features: Dictionary containing features for a single sample</p>\n\n<p>Returns:\n    Predicted class</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">single_features</span><span class=\"p\">:</span> <span class=\"n\">Dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.create_random_forest_model": {"fullname": "gaitsetpy.classification.create_random_forest_model", "modulename": "gaitsetpy.classification", "qualname": "create_random_forest_model", "kind": "function", "doc": "<p>Create a Random Forest model with specified parameters.</p>\n\n<p>Args:\n    n_estimators: Number of trees in the forest\n    random_state: Random state for reproducibility\n    max_depth: Maximum depth of the tree</p>\n\n<p>Returns:\n    RandomForestModel instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n_estimators</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">random_state</span><span class=\"o\">=</span><span class=\"mi\">42</span>, </span><span class=\"param\"><span class=\"n\">max_depth</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.preprocess_features": {"fullname": "gaitsetpy.classification.preprocess_features", "modulename": "gaitsetpy.classification", "qualname": "preprocess_features", "kind": "function", "doc": "<p>Convert the features dictionary into X (feature matrix) and y (labels),\nensuring all feature vectors have a consistent length.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">features</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.evaluate_model": {"fullname": "gaitsetpy.classification.evaluate_model", "modulename": "gaitsetpy.classification", "qualname": "evaluate_model", "kind": "function", "doc": "<p>Evaluates the given model on the provided features and prints accuracy and confusion matrix.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">model</span>, </span><span class=\"param\"><span class=\"n\">features</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.get_classification_manager": {"fullname": "gaitsetpy.classification.get_classification_manager", "modulename": "gaitsetpy.classification", "qualname": "get_classification_manager", "kind": "function", "doc": "<p>Get the singleton ClassificationManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.get_available_models": {"fullname": "gaitsetpy.classification.get_available_models", "modulename": "gaitsetpy.classification", "qualname": "get_available_models", "kind": "function", "doc": "<p>Get list of available classification model names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.train_model": {"fullname": "gaitsetpy.classification.train_model", "modulename": "gaitsetpy.classification", "qualname": "train_model", "kind": "function", "doc": "<p>Train a classification model using the ClassificationManager.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n\n<p>Returns:\n    Trained model instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">features</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.predict": {"fullname": "gaitsetpy.classification.predict", "modulename": "gaitsetpy.classification", "qualname": "predict", "kind": "function", "doc": "<p>Make predictions using the ClassificationManager.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Predictions array</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">features</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.evaluate_model_performance": {"fullname": "gaitsetpy.classification.evaluate_model_performance", "modulename": "gaitsetpy.classification", "qualname": "evaluate_model_performance", "kind": "function", "doc": "<p>Evaluate a classification model using the ClassificationManager.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Evaluation metrics dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">features</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.create_random_forest": {"fullname": "gaitsetpy.classification.create_random_forest", "modulename": "gaitsetpy.classification", "qualname": "create_random_forest", "kind": "function", "doc": "<p>Create a Random Forest model with specified parameters.</p>\n\n<p>Args:\n    n_estimators: Number of trees in the forest\n    random_state: Random state for reproducibility\n    max_depth: Maximum depth of the tree</p>\n\n<p>Returns:\n    RandomForestModel instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n_estimators</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">random_state</span><span class=\"o\">=</span><span class=\"mi\">42</span>, </span><span class=\"param\"><span class=\"n\">max_depth</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.train_random_forest": {"fullname": "gaitsetpy.classification.train_random_forest", "modulename": "gaitsetpy.classification", "qualname": "train_random_forest", "kind": "function", "doc": "<p>Train a Random Forest model on the given features.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n\n<p>Returns:\n    Trained RandomForestModel instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">features</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models": {"fullname": "gaitsetpy.classification.models", "modulename": "gaitsetpy.classification.models", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.get_classification_model": {"fullname": "gaitsetpy.classification.models.get_classification_model", "modulename": "gaitsetpy.classification.models", "qualname": "get_classification_model", "kind": "function", "doc": "<p>Factory function to get a classification model by name.</p>\n\n<p>Args:\n    name (str): Name of the model. One of: 'random_forest', 'mlp', 'lstm', 'bilstm', 'gnn', 'cnn'.\n    **kwargs: Model-specific parameters.</p>\n\n<p>Returns:\n    An instance of the requested model.</p>\n\n<p>Raises:\n    ValueError: If the model name is not recognized or PyTorch is not available for PyTorch models.</p>\n\n<p>Example:\n    model = get_classification_model('cnn', input_channels=20, num_classes=4)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.bilstm": {"fullname": "gaitsetpy.classification.models.bilstm", "modulename": "gaitsetpy.classification.models.bilstm", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMNet": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMNet", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMNet", "kind": "class", "doc": "<p>Base class for all neural network modules.</p>\n\n<p>Your models should also subclass this class.</p>\n\n<p>Modules can also contain other Modules, allowing them to be nested in\na tree structure. You can assign the submodules as regular attributes::</p>\n\n<pre><code>import torch.nn as nn\nimport torch.nn.functional as F\n\n\nclass Model(nn.Module):\n    def __init__(self) -&gt; None:\n        super().__init__()\n        self.conv1 = nn.Conv2d(1, 20, 5)\n        self.conv2 = nn.Conv2d(20, 20, 5)\n\n    def forward(self, x):\n        x = F.relu(self.conv1(x))\n        return F.relu(self.conv2(x))\n</code></pre>\n\n<p>Submodules assigned in this way will be registered, and will also have their\nparameters converted when you call <code>to()</code>, etc.</p>\n\n<div class=\"alert note\">\n\n<p>As per the example above, an <code>__init__()</code> call to the parent class\nmust be made before assignment on the child.</p>\n\n</div>\n\n<p>:ivar training: Boolean represents whether this module is in training or\n                evaluation mode.\n:vartype training: bool</p>\n", "bases": "torch.nn.modules.module.Module"}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.__init__": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMNet.__init__", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMNet.__init__", "kind": "function", "doc": "<p>Initialize internal Module state, shared by both nn.Module and ScriptModule.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_size</span>, </span><span class=\"param\"><span class=\"n\">hidden_size</span>, </span><span class=\"param\"><span class=\"n\">num_layers</span>, </span><span class=\"param\"><span class=\"n\">num_classes</span>, </span><span class=\"param\"><span class=\"n\">dropout</span><span class=\"o\">=</span><span class=\"mf\">0.2</span></span>)</span>"}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.lstm": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMNet.lstm", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMNet.lstm", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.fc": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMNet.fc", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMNet.fc", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.forward": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMNet.forward", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMNet.forward", "kind": "function", "doc": "<p>Define the computation performed at every call.</p>\n\n<p>Should be overridden by all subclasses.</p>\n\n<div class=\"alert note\">\n\n<p>Although the recipe for forward pass needs to be defined within\nthis function, one should call the <code>Module</code> instance afterwards\ninstead of this since the former takes care of running the\nregistered hooks while the latter silently ignores them.</p>\n\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel", "kind": "class", "doc": "<p>Bidirectional LSTM classification model using PyTorch.\nImplements the BaseClassificationModel interface.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.__init__": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.__init__", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">input_size</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">hidden_size</span><span class=\"o\">=</span><span class=\"mi\">64</span>,</span><span class=\"param\">\t<span class=\"n\">num_layers</span><span class=\"o\">=</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">num_classes</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">lr</span><span class=\"o\">=</span><span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">epochs</span><span class=\"o\">=</span><span class=\"mi\">20</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"o\">=</span><span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.config": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.config", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.device": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.device", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.device", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.model": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.model", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.epochs": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.epochs", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.epochs", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.batch_size": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.batch_size", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.batch_size", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.trained": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.trained", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.trained", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.feature_names": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.feature_names", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.class_names": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.class_names", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.train": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.train", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.predict": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.predict", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.evaluate": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.evaluate", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.save_model": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.save_model", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.load_model": {"fullname": "gaitsetpy.classification.models.bilstm.BiLSTMModel.load_model", "modulename": "gaitsetpy.classification.models.bilstm", "qualname": "BiLSTMModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.cnn": {"fullname": "gaitsetpy.classification.models.cnn", "modulename": "gaitsetpy.classification.models.cnn", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.SimpleCNN": {"fullname": "gaitsetpy.classification.models.cnn.SimpleCNN", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "SimpleCNN", "kind": "class", "doc": "<p>Base class for all neural network modules.</p>\n\n<p>Your models should also subclass this class.</p>\n\n<p>Modules can also contain other Modules, allowing them to be nested in\na tree structure. You can assign the submodules as regular attributes::</p>\n\n<pre><code>import torch.nn as nn\nimport torch.nn.functional as F\n\n\nclass Model(nn.Module):\n    def __init__(self) -&gt; None:\n        super().__init__()\n        self.conv1 = nn.Conv2d(1, 20, 5)\n        self.conv2 = nn.Conv2d(20, 20, 5)\n\n    def forward(self, x):\n        x = F.relu(self.conv1(x))\n        return F.relu(self.conv2(x))\n</code></pre>\n\n<p>Submodules assigned in this way will be registered, and will also have their\nparameters converted when you call <code>to()</code>, etc.</p>\n\n<div class=\"alert note\">\n\n<p>As per the example above, an <code>__init__()</code> call to the parent class\nmust be made before assignment on the child.</p>\n\n</div>\n\n<p>:ivar training: Boolean represents whether this module is in training or\n                evaluation mode.\n:vartype training: bool</p>\n", "bases": "torch.nn.modules.module.Module"}, "gaitsetpy.classification.models.cnn.SimpleCNN.__init__": {"fullname": "gaitsetpy.classification.models.cnn.SimpleCNN.__init__", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "SimpleCNN.__init__", "kind": "function", "doc": "<p>Initialize internal Module state, shared by both nn.Module and ScriptModule.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_channels</span>, </span><span class=\"param\"><span class=\"n\">num_classes</span>, </span><span class=\"param\"><span class=\"n\">seq_len</span><span class=\"o\">=</span><span class=\"mi\">1</span></span>)</span>"}, "gaitsetpy.classification.models.cnn.SimpleCNN.conv1": {"fullname": "gaitsetpy.classification.models.cnn.SimpleCNN.conv1", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "SimpleCNN.conv1", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.SimpleCNN.relu": {"fullname": "gaitsetpy.classification.models.cnn.SimpleCNN.relu", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "SimpleCNN.relu", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.SimpleCNN.pool": {"fullname": "gaitsetpy.classification.models.cnn.SimpleCNN.pool", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "SimpleCNN.pool", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.SimpleCNN.fc": {"fullname": "gaitsetpy.classification.models.cnn.SimpleCNN.fc", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "SimpleCNN.fc", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.SimpleCNN.forward": {"fullname": "gaitsetpy.classification.models.cnn.SimpleCNN.forward", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "SimpleCNN.forward", "kind": "function", "doc": "<p>Define the computation performed at every call.</p>\n\n<p>Should be overridden by all subclasses.</p>\n\n<div class=\"alert note\">\n\n<p>Although the recipe for forward pass needs to be defined within\nthis function, one should call the <code>Module</code> instance afterwards\ninstead of this since the former takes care of running the\nregistered hooks while the latter silently ignores them.</p>\n\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.cnn.CNNModel": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel", "kind": "class", "doc": "<p>Simple 1D CNN classification model using PyTorch.\nImplements the BaseClassificationModel interface.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.classification.models.cnn.CNNModel.__init__": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.__init__", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">input_channels</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">num_classes</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">lr</span><span class=\"o\">=</span><span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">epochs</span><span class=\"o\">=</span><span class=\"mi\">20</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"o\">=</span><span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "gaitsetpy.classification.models.cnn.CNNModel.config": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.config", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.device": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.device", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.device", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.model": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.model", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.epochs": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.epochs", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.epochs", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.batch_size": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.batch_size", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.batch_size", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.trained": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.trained", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.trained", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.feature_names": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.feature_names", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.class_names": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.class_names", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.cnn.CNNModel.train": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.train", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.cnn.CNNModel.predict": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.predict", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.cnn.CNNModel.evaluate": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.evaluate", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.cnn.CNNModel.save_model": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.save_model", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.cnn.CNNModel.load_model": {"fullname": "gaitsetpy.classification.models.cnn.CNNModel.load_model", "modulename": "gaitsetpy.classification.models.cnn", "qualname": "CNNModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.gnn": {"fullname": "gaitsetpy.classification.models.gnn", "modulename": "gaitsetpy.classification.models.gnn", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.SimpleGCN": {"fullname": "gaitsetpy.classification.models.gnn.SimpleGCN", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "SimpleGCN", "kind": "class", "doc": "<p>Base class for all neural network modules.</p>\n\n<p>Your models should also subclass this class.</p>\n\n<p>Modules can also contain other Modules, allowing them to be nested in\na tree structure. You can assign the submodules as regular attributes::</p>\n\n<pre><code>import torch.nn as nn\nimport torch.nn.functional as F\n\n\nclass Model(nn.Module):\n    def __init__(self) -&gt; None:\n        super().__init__()\n        self.conv1 = nn.Conv2d(1, 20, 5)\n        self.conv2 = nn.Conv2d(20, 20, 5)\n\n    def forward(self, x):\n        x = F.relu(self.conv1(x))\n        return F.relu(self.conv2(x))\n</code></pre>\n\n<p>Submodules assigned in this way will be registered, and will also have their\nparameters converted when you call <code>to()</code>, etc.</p>\n\n<div class=\"alert note\">\n\n<p>As per the example above, an <code>__init__()</code> call to the parent class\nmust be made before assignment on the child.</p>\n\n</div>\n\n<p>:ivar training: Boolean represents whether this module is in training or\n                evaluation mode.\n:vartype training: bool</p>\n", "bases": "torch.nn.modules.module.Module"}, "gaitsetpy.classification.models.gnn.SimpleGCN.__init__": {"fullname": "gaitsetpy.classification.models.gnn.SimpleGCN.__init__", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "SimpleGCN.__init__", "kind": "function", "doc": "<p>Initialize internal Module state, shared by both nn.Module and ScriptModule.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_dim</span>, </span><span class=\"param\"><span class=\"n\">hidden_dim</span>, </span><span class=\"param\"><span class=\"n\">output_dim</span></span>)</span>"}, "gaitsetpy.classification.models.gnn.SimpleGCN.fc1": {"fullname": "gaitsetpy.classification.models.gnn.SimpleGCN.fc1", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "SimpleGCN.fc1", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.SimpleGCN.fc2": {"fullname": "gaitsetpy.classification.models.gnn.SimpleGCN.fc2", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "SimpleGCN.fc2", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.SimpleGCN.forward": {"fullname": "gaitsetpy.classification.models.gnn.SimpleGCN.forward", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "SimpleGCN.forward", "kind": "function", "doc": "<p>Define the computation performed at every call.</p>\n\n<p>Should be overridden by all subclasses.</p>\n\n<div class=\"alert note\">\n\n<p>Although the recipe for forward pass needs to be defined within\nthis function, one should call the <code>Module</code> instance afterwards\ninstead of this since the former takes care of running the\nregistered hooks while the latter silently ignores them.</p>\n\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">adj</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.gnn.GNNModel": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel", "kind": "class", "doc": "<p>Simple Graph Neural Network (GCN) classification model using PyTorch.\nImplements the BaseClassificationModel interface.\nExpects features as node features and adjacency matrix in kwargs.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.classification.models.gnn.GNNModel.__init__": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.__init__", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">input_dim</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">hidden_dim</span><span class=\"o\">=</span><span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">output_dim</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">lr</span><span class=\"o\">=</span><span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">epochs</span><span class=\"o\">=</span><span class=\"mi\">20</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "gaitsetpy.classification.models.gnn.GNNModel.config": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.config", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.GNNModel.device": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.device", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.device", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.GNNModel.model": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.model", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.GNNModel.epochs": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.epochs", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.epochs", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.GNNModel.trained": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.trained", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.trained", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.GNNModel.feature_names": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.feature_names", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.GNNModel.class_names": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.class_names", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.gnn.GNNModel.train": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.train", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.gnn.GNNModel.predict": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.predict", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.gnn.GNNModel.evaluate": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.evaluate", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.gnn.GNNModel.save_model": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.save_model", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.gnn.GNNModel.load_model": {"fullname": "gaitsetpy.classification.models.gnn.GNNModel.load_model", "modulename": "gaitsetpy.classification.models.gnn", "qualname": "GNNModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.lstm": {"fullname": "gaitsetpy.classification.models.lstm", "modulename": "gaitsetpy.classification.models.lstm", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMNet": {"fullname": "gaitsetpy.classification.models.lstm.LSTMNet", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMNet", "kind": "class", "doc": "<p>Base class for all neural network modules.</p>\n\n<p>Your models should also subclass this class.</p>\n\n<p>Modules can also contain other Modules, allowing them to be nested in\na tree structure. You can assign the submodules as regular attributes::</p>\n\n<pre><code>import torch.nn as nn\nimport torch.nn.functional as F\n\n\nclass Model(nn.Module):\n    def __init__(self) -&gt; None:\n        super().__init__()\n        self.conv1 = nn.Conv2d(1, 20, 5)\n        self.conv2 = nn.Conv2d(20, 20, 5)\n\n    def forward(self, x):\n        x = F.relu(self.conv1(x))\n        return F.relu(self.conv2(x))\n</code></pre>\n\n<p>Submodules assigned in this way will be registered, and will also have their\nparameters converted when you call <code>to()</code>, etc.</p>\n\n<div class=\"alert note\">\n\n<p>As per the example above, an <code>__init__()</code> call to the parent class\nmust be made before assignment on the child.</p>\n\n</div>\n\n<p>:ivar training: Boolean represents whether this module is in training or\n                evaluation mode.\n:vartype training: bool</p>\n", "bases": "torch.nn.modules.module.Module"}, "gaitsetpy.classification.models.lstm.LSTMNet.__init__": {"fullname": "gaitsetpy.classification.models.lstm.LSTMNet.__init__", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMNet.__init__", "kind": "function", "doc": "<p>Initialize internal Module state, shared by both nn.Module and ScriptModule.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_size</span>, </span><span class=\"param\"><span class=\"n\">hidden_size</span>, </span><span class=\"param\"><span class=\"n\">num_layers</span>, </span><span class=\"param\"><span class=\"n\">num_classes</span>, </span><span class=\"param\"><span class=\"n\">dropout</span><span class=\"o\">=</span><span class=\"mf\">0.2</span></span>)</span>"}, "gaitsetpy.classification.models.lstm.LSTMNet.lstm": {"fullname": "gaitsetpy.classification.models.lstm.LSTMNet.lstm", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMNet.lstm", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMNet.fc": {"fullname": "gaitsetpy.classification.models.lstm.LSTMNet.fc", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMNet.fc", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMNet.forward": {"fullname": "gaitsetpy.classification.models.lstm.LSTMNet.forward", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMNet.forward", "kind": "function", "doc": "<p>Define the computation performed at every call.</p>\n\n<p>Should be overridden by all subclasses.</p>\n\n<div class=\"alert note\">\n\n<p>Although the recipe for forward pass needs to be defined within\nthis function, one should call the <code>Module</code> instance afterwards\ninstead of this since the former takes care of running the\nregistered hooks while the latter silently ignores them.</p>\n\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.lstm.LSTMModel": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel", "kind": "class", "doc": "<p>LSTM classification model using PyTorch.\nImplements the BaseClassificationModel interface.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.classification.models.lstm.LSTMModel.__init__": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.__init__", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">input_size</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">hidden_size</span><span class=\"o\">=</span><span class=\"mi\">64</span>,</span><span class=\"param\">\t<span class=\"n\">num_layers</span><span class=\"o\">=</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">num_classes</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">lr</span><span class=\"o\">=</span><span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">epochs</span><span class=\"o\">=</span><span class=\"mi\">20</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"o\">=</span><span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "gaitsetpy.classification.models.lstm.LSTMModel.config": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.config", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.device": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.device", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.device", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.model": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.model", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.epochs": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.epochs", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.epochs", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.batch_size": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.batch_size", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.batch_size", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.trained": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.trained", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.trained", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.feature_names": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.feature_names", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.class_names": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.class_names", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.lstm.LSTMModel.train": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.train", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.lstm.LSTMModel.predict": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.predict", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.lstm.LSTMModel.evaluate": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.evaluate", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.lstm.LSTMModel.save_model": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.save_model", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.lstm.LSTMModel.load_model": {"fullname": "gaitsetpy.classification.models.lstm.LSTMModel.load_model", "modulename": "gaitsetpy.classification.models.lstm", "qualname": "LSTMModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.mlp": {"fullname": "gaitsetpy.classification.models.mlp", "modulename": "gaitsetpy.classification.models.mlp", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.mlp.MLPModel": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel", "kind": "class", "doc": "<p>Multi-Layer Perceptron (MLP) classification model.\nImplements the BaseClassificationModel interface using scikit-learn's MLPClassifier.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.classification.models.mlp.MLPModel.__init__": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.__init__", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">hidden_layer_sizes</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"mi\">100</span><span class=\"p\">,)</span>,</span><span class=\"param\">\t<span class=\"n\">activation</span><span class=\"o\">=</span><span class=\"s1\">&#39;relu&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">solver</span><span class=\"o\">=</span><span class=\"s1\">&#39;adam&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">random_state</span><span class=\"o\">=</span><span class=\"mi\">42</span>,</span><span class=\"param\">\t<span class=\"n\">max_iter</span><span class=\"o\">=</span><span class=\"mi\">200</span></span>)</span>"}, "gaitsetpy.classification.models.mlp.MLPModel.config": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.config", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.mlp.MLPModel.model": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.model", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.mlp.MLPModel.feature_names": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.feature_names", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.mlp.MLPModel.class_names": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.class_names", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.mlp.MLPModel.train": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.train", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.mlp.MLPModel.predict": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.predict", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.mlp.MLPModel.evaluate": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.evaluate", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.mlp.MLPModel.save_model": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.save_model", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.mlp.MLPModel.load_model": {"fullname": "gaitsetpy.classification.models.mlp.MLPModel.load_model", "modulename": "gaitsetpy.classification.models.mlp", "qualname": "MLPModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest": {"fullname": "gaitsetpy.classification.models.random_forest", "modulename": "gaitsetpy.classification.models.random_forest", "kind": "module", "doc": "<p>Random Forest Classification Model</p>\n\n<p>This module contains the RandomForestModel class which inherits from BaseClassificationModel\nand provides Random Forest classification functionality.</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.classification.models.random_forest.RandomForestModel": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel", "kind": "class", "doc": "<p>Random Forest classification model.</p>\n\n<p>This class provides Random Forest classification functionality with\ncomprehensive training, prediction, and evaluation capabilities.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseClassificationModel"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.__init__": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.__init__", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">n_estimators</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">random_state</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">42</span>,</span><span class=\"param\">\t<span class=\"n\">max_depth</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.config": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.config", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.model": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.model", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.feature_names": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.feature_names", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.feature_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.class_names": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.class_names", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.class_names", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.train": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.train", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.train", "kind": "function", "doc": "<p>Train the Random Forest model on the given features.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including test_size, validation_split</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.predict": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.predict", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained Random Forest model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including return_probabilities</p>\n\n<p>Returns:\n    Array of predictions or probabilities</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.evaluate": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.evaluate", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.evaluate", "kind": "function", "doc": "<p>Evaluate the Random Forest model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including detailed_report</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.save_model": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.save_model", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.save_model", "kind": "function", "doc": "<p>Save the trained Random Forest model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.load_model": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.load_model", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.load_model", "kind": "function", "doc": "<p>Load a trained Random Forest model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.get_feature_importance": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.get_feature_importance", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.get_feature_importance", "kind": "function", "doc": "<p>Get feature importance scores.</p>\n\n<p>Returns:\n    Dictionary mapping feature names to importance scores</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest.RandomForestModel.predict_single": {"fullname": "gaitsetpy.classification.models.random_forest.RandomForestModel.predict_single", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "RandomForestModel.predict_single", "kind": "function", "doc": "<p>Make prediction for a single feature vector.</p>\n\n<p>Args:\n    single_features: Dictionary containing features for a single sample</p>\n\n<p>Returns:\n    Predicted class</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">single_features</span><span class=\"p\">:</span> <span class=\"n\">Dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.classification.models.random_forest.create_random_forest_model": {"fullname": "gaitsetpy.classification.models.random_forest.create_random_forest_model", "modulename": "gaitsetpy.classification.models.random_forest", "qualname": "create_random_forest_model", "kind": "function", "doc": "<p>Create a Random Forest model with specified parameters.</p>\n\n<p>Args:\n    n_estimators: Number of trees in the forest\n    random_state: Random state for reproducibility\n    max_depth: Maximum depth of the tree</p>\n\n<p>Returns:\n    RandomForestModel instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n_estimators</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">random_state</span><span class=\"o\">=</span><span class=\"mi\">42</span>, </span><span class=\"param\"><span class=\"n\">max_depth</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.utils": {"fullname": "gaitsetpy.classification.utils", "modulename": "gaitsetpy.classification.utils", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.utils.dataset": {"fullname": "gaitsetpy.classification.utils.dataset", "modulename": "gaitsetpy.classification.utils.dataset", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.classification.utils.eval": {"fullname": "gaitsetpy.classification.utils.eval", "modulename": "gaitsetpy.classification.utils.eval", "kind": "module", "doc": "<p>For evaluation of a classification model</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.classification.utils.eval.evaluate_model": {"fullname": "gaitsetpy.classification.utils.eval.evaluate_model", "modulename": "gaitsetpy.classification.utils.eval", "qualname": "evaluate_model", "kind": "function", "doc": "<p>Evaluates the given model on the provided features and prints accuracy and confusion matrix.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">model</span>, </span><span class=\"param\"><span class=\"n\">features</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.utils.preprocess": {"fullname": "gaitsetpy.classification.utils.preprocess", "modulename": "gaitsetpy.classification.utils.preprocess", "kind": "module", "doc": "<p>Data Preprocessing for Classification</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.classification.utils.preprocess.preprocess_features": {"fullname": "gaitsetpy.classification.utils.preprocess.preprocess_features", "modulename": "gaitsetpy.classification.utils.preprocess", "qualname": "preprocess_features", "kind": "function", "doc": "<p>Convert the features dictionary into X (feature matrix) and y (labels),\nensuring all feature vectors have a consistent length.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">features</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.classification.utils.train": {"fullname": "gaitsetpy.classification.utils.train", "modulename": "gaitsetpy.classification.utils.train", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.core": {"fullname": "gaitsetpy.core", "modulename": "gaitsetpy.core", "kind": "module", "doc": "<p>Core module for GaitSetPy - Contains base classes and singleton managers for modular architecture.</p>\n\n<p>This module provides:</p>\n\n<ul>\n<li>Base classes for different components (DatasetLoader, FeatureExtractor, etc.)</li>\n<li>Singleton managers for plugin-based architecture</li>\n<li>Registry system for easy extension</li>\n</ul>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.core.BaseDatasetLoader": {"fullname": "gaitsetpy.core.BaseDatasetLoader", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader", "kind": "class", "doc": "<p>Base class for all dataset loaders.</p>\n\n<p>All dataset loaders should inherit from this class and implement the required methods.\nThis class provides thread-safe concurrent downloading capabilities for efficient data retrieval.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.BaseDatasetLoader.__init__": {"fullname": "gaitsetpy.core.BaseDatasetLoader.__init__", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.__init__", "kind": "function", "doc": "<p>Initialize the dataset loader.</p>\n\n<p>Args:\n    name: Name of the dataset\n    description: Description of the dataset\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>, </span><span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.core.BaseDatasetLoader.name": {"fullname": "gaitsetpy.core.BaseDatasetLoader.name", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseDatasetLoader.description": {"fullname": "gaitsetpy.core.BaseDatasetLoader.description", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseDatasetLoader.data": {"fullname": "gaitsetpy.core.BaseDatasetLoader.data", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.data", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseDatasetLoader.metadata": {"fullname": "gaitsetpy.core.BaseDatasetLoader.metadata", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseDatasetLoader.max_workers": {"fullname": "gaitsetpy.core.BaseDatasetLoader.max_workers", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.max_workers", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseDatasetLoader.load_data": {"fullname": "gaitsetpy.core.BaseDatasetLoader.load_data", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.load_data", "kind": "function", "doc": "<p>Load dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    **kwargs: Additional arguments specific to the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseDatasetLoader.create_sliding_windows": {"fullname": "gaitsetpy.core.BaseDatasetLoader.create_sliding_windows", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the loaded data.</p>\n\n<p>Args:\n    data: List of DataFrames\n    names: List of names corresponding to the data\n    window_size: Size of each sliding window\n    step_size: Step size for sliding windows</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseDatasetLoader.get_supported_formats": {"fullname": "gaitsetpy.core.BaseDatasetLoader.get_supported_formats", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseDatasetLoader.download_files_concurrent": {"fullname": "gaitsetpy.core.BaseDatasetLoader.download_files_concurrent", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.download_files_concurrent", "kind": "function", "doc": "<p>Download multiple files concurrently using a thread pool.</p>\n\n<p>Args:\n    download_tasks: List of dicts with 'url' and 'dest_path' keys\n    show_progress: Whether to show progress bar (default: True)\n    desc: Description for progress bar</p>\n\n<p>Returns:\n    Dictionary with download statistics and results</p>\n\n<p>Example:\n    tasks = [\n        {'url': 'http://example.com/file1.txt', 'dest_path': '/path/to/file1.txt'},\n        {'url': 'http://example.com/file2.txt', 'dest_path': '/path/to/file2.txt'}\n    ]\n    results = loader.download_files_concurrent(tasks)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">download_tasks</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">show_progress</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">desc</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Downloading files&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseDatasetLoader.set_max_workers": {"fullname": "gaitsetpy.core.BaseDatasetLoader.set_max_workers", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.set_max_workers", "kind": "function", "doc": "<p>Set the maximum number of concurrent download threads.</p>\n\n<p>Args:\n    max_workers: Maximum number of threads (must be positive)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseDatasetLoader.get_download_stats": {"fullname": "gaitsetpy.core.BaseDatasetLoader.get_download_stats", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.get_download_stats", "kind": "function", "doc": "<p>Get statistics from the last download operation.</p>\n\n<p>Returns:\n    Dictionary with success, failed, and skipped counts</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseDatasetLoader.get_info": {"fullname": "gaitsetpy.core.BaseDatasetLoader.get_info", "modulename": "gaitsetpy.core", "qualname": "BaseDatasetLoader.get_info", "kind": "function", "doc": "<p>Get information about the dataset.</p>\n\n<p>Returns:\n    Dictionary containing dataset information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseFeatureExtractor": {"fullname": "gaitsetpy.core.BaseFeatureExtractor", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor", "kind": "class", "doc": "<p>Base class for all feature extractors.</p>\n\n<p>All feature extractors should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.BaseFeatureExtractor.__init__": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.__init__", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.BaseFeatureExtractor.name": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.name", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseFeatureExtractor.description": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.description", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseFeatureExtractor.config": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.config", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseFeatureExtractor.extract_features": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.extract_features", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of features extracted by this extractor.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseFeatureExtractor.configure": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.configure", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.configure", "kind": "function", "doc": "<p>Configure the feature extractor.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseFeatureExtractor.get_info": {"fullname": "gaitsetpy.core.BaseFeatureExtractor.get_info", "modulename": "gaitsetpy.core", "qualname": "BaseFeatureExtractor.get_info", "kind": "function", "doc": "<p>Get information about the feature extractor.</p>\n\n<p>Returns:\n    Dictionary containing feature extractor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BasePreprocessor": {"fullname": "gaitsetpy.core.BasePreprocessor", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor", "kind": "class", "doc": "<p>Base class for all preprocessors.</p>\n\n<p>All preprocessors should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.BasePreprocessor.__init__": {"fullname": "gaitsetpy.core.BasePreprocessor.__init__", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.BasePreprocessor.name": {"fullname": "gaitsetpy.core.BasePreprocessor.name", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BasePreprocessor.description": {"fullname": "gaitsetpy.core.BasePreprocessor.description", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BasePreprocessor.config": {"fullname": "gaitsetpy.core.BasePreprocessor.config", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BasePreprocessor.fitted": {"fullname": "gaitsetpy.core.BasePreprocessor.fitted", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.fitted", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BasePreprocessor.fit": {"fullname": "gaitsetpy.core.BasePreprocessor.fit", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor to the data.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments for fitting</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BasePreprocessor.transform": {"fullname": "gaitsetpy.core.BasePreprocessor.transform", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.transform", "kind": "function", "doc": "<p>Transform the data using the fitted preprocessor.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments for transformation</p>\n\n<p>Returns:\n    Transformed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BasePreprocessor.fit_transform": {"fullname": "gaitsetpy.core.BasePreprocessor.fit_transform", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.fit_transform", "kind": "function", "doc": "<p>Fit the preprocessor and transform the data.</p>\n\n<p>Args:\n    data: Input data to fit and transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Transformed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BasePreprocessor.configure": {"fullname": "gaitsetpy.core.BasePreprocessor.configure", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.configure", "kind": "function", "doc": "<p>Configure the preprocessor.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BasePreprocessor.get_info": {"fullname": "gaitsetpy.core.BasePreprocessor.get_info", "modulename": "gaitsetpy.core", "qualname": "BasePreprocessor.get_info", "kind": "function", "doc": "<p>Get information about the preprocessor.</p>\n\n<p>Returns:\n    Dictionary containing preprocessor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseEDAAnalyzer": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer", "kind": "class", "doc": "<p>Base class for all EDA analyzers.</p>\n\n<p>All EDA analyzers should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.BaseEDAAnalyzer.__init__": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.__init__", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.BaseEDAAnalyzer.name": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.name", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseEDAAnalyzer.description": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.description", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseEDAAnalyzer.config": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.config", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseEDAAnalyzer.analyze": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.analyze", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.analyze", "kind": "function", "doc": "<p>Perform analysis on the data.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments for analysis</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseEDAAnalyzer.visualize": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.visualize", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of the data.</p>\n\n<p>Args:\n    data: Input data to visualize\n    **kwargs: Additional arguments for visualization</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseEDAAnalyzer.configure": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.configure", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.configure", "kind": "function", "doc": "<p>Configure the EDA analyzer.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseEDAAnalyzer.get_info": {"fullname": "gaitsetpy.core.BaseEDAAnalyzer.get_info", "modulename": "gaitsetpy.core", "qualname": "BaseEDAAnalyzer.get_info", "kind": "function", "doc": "<p>Get information about the EDA analyzer.</p>\n\n<p>Returns:\n    Dictionary containing EDA analyzer information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseClassificationModel": {"fullname": "gaitsetpy.core.BaseClassificationModel", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel", "kind": "class", "doc": "<p>Base class for all classification models.</p>\n\n<p>All classification models should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.BaseClassificationModel.__init__": {"fullname": "gaitsetpy.core.BaseClassificationModel.__init__", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.BaseClassificationModel.name": {"fullname": "gaitsetpy.core.BaseClassificationModel.name", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseClassificationModel.description": {"fullname": "gaitsetpy.core.BaseClassificationModel.description", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseClassificationModel.model": {"fullname": "gaitsetpy.core.BaseClassificationModel.model", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseClassificationModel.config": {"fullname": "gaitsetpy.core.BaseClassificationModel.config", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseClassificationModel.trained": {"fullname": "gaitsetpy.core.BaseClassificationModel.trained", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.trained", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.BaseClassificationModel.train": {"fullname": "gaitsetpy.core.BaseClassificationModel.train", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseClassificationModel.predict": {"fullname": "gaitsetpy.core.BaseClassificationModel.predict", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseClassificationModel.evaluate": {"fullname": "gaitsetpy.core.BaseClassificationModel.evaluate", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseClassificationModel.save_model": {"fullname": "gaitsetpy.core.BaseClassificationModel.save_model", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseClassificationModel.load_model": {"fullname": "gaitsetpy.core.BaseClassificationModel.load_model", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseClassificationModel.configure": {"fullname": "gaitsetpy.core.BaseClassificationModel.configure", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.configure", "kind": "function", "doc": "<p>Configure the classification model.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.BaseClassificationModel.get_info": {"fullname": "gaitsetpy.core.BaseClassificationModel.get_info", "modulename": "gaitsetpy.core", "qualname": "BaseClassificationModel.get_info", "kind": "function", "doc": "<p>Get information about the classification model.</p>\n\n<p>Returns:\n    Dictionary containing model information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.DatasetManager": {"fullname": "gaitsetpy.core.DatasetManager", "modulename": "gaitsetpy.core", "qualname": "DatasetManager", "kind": "class", "doc": "<p>Singleton manager for dataset loaders.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.core.DatasetManager.register_dataset": {"fullname": "gaitsetpy.core.DatasetManager.register_dataset", "modulename": "gaitsetpy.core", "qualname": "DatasetManager.register_dataset", "kind": "function", "doc": "<p>Register a dataset loader.</p>\n\n<p>Args:\n    name: Name to register the dataset under\n    dataset_class: Dataset loader class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">dataset_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseDatasetLoader</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.DatasetManager.load_dataset": {"fullname": "gaitsetpy.core.DatasetManager.load_dataset", "modulename": "gaitsetpy.core", "qualname": "DatasetManager.load_dataset", "kind": "function", "doc": "<p>Load a dataset using the registered loader.</p>\n\n<p>Args:\n    name: Name of the dataset loader\n    data_dir: Directory containing the dataset\n    **kwargs: Additional arguments for the loader</p>\n\n<p>Returns:\n    Dataset loader instance with loaded data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseDatasetLoader</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.FeatureManager": {"fullname": "gaitsetpy.core.FeatureManager", "modulename": "gaitsetpy.core", "qualname": "FeatureManager", "kind": "class", "doc": "<p>Singleton manager for feature extractors.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.core.FeatureManager.register_extractor": {"fullname": "gaitsetpy.core.FeatureManager.register_extractor", "modulename": "gaitsetpy.core", "qualname": "FeatureManager.register_extractor", "kind": "function", "doc": "<p>Register a feature extractor.</p>\n\n<p>Args:\n    name: Name to register the extractor under\n    extractor_class: Feature extractor class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">extractor_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseFeatureExtractor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.FeatureManager.extract_features": {"fullname": "gaitsetpy.core.FeatureManager.extract_features", "modulename": "gaitsetpy.core", "qualname": "FeatureManager.extract_features", "kind": "function", "doc": "<p>Extract features using the specified extractor.</p>\n\n<p>Args:\n    extractor_name: Name of the feature extractor\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">extractor_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.PreprocessingManager": {"fullname": "gaitsetpy.core.PreprocessingManager", "modulename": "gaitsetpy.core", "qualname": "PreprocessingManager", "kind": "class", "doc": "<p>Singleton manager for preprocessors.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.core.PreprocessingManager.register_preprocessor": {"fullname": "gaitsetpy.core.PreprocessingManager.register_preprocessor", "modulename": "gaitsetpy.core", "qualname": "PreprocessingManager.register_preprocessor", "kind": "function", "doc": "<p>Register a preprocessor.</p>\n\n<p>Args:\n    name: Name to register the preprocessor under\n    preprocessor_class: Preprocessor class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">preprocessor_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BasePreprocessor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.PreprocessingManager.preprocess_data": {"fullname": "gaitsetpy.core.PreprocessingManager.preprocess_data", "modulename": "gaitsetpy.core", "qualname": "PreprocessingManager.preprocess_data", "kind": "function", "doc": "<p>Preprocess data using the specified preprocessor.</p>\n\n<p>Args:\n    preprocessor_name: Name of the preprocessor\n    data: Input data to preprocess\n    **kwargs: Additional arguments for preprocessing</p>\n\n<p>Returns:\n    Preprocessed data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">preprocessor_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.EDAManager": {"fullname": "gaitsetpy.core.EDAManager", "modulename": "gaitsetpy.core", "qualname": "EDAManager", "kind": "class", "doc": "<p>Singleton manager for EDA analyzers.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.core.EDAManager.register_analyzer": {"fullname": "gaitsetpy.core.EDAManager.register_analyzer", "modulename": "gaitsetpy.core", "qualname": "EDAManager.register_analyzer", "kind": "function", "doc": "<p>Register an EDA analyzer.</p>\n\n<p>Args:\n    name: Name to register the analyzer under\n    analyzer_class: EDA analyzer class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">analyzer_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseEDAAnalyzer</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.EDAManager.analyze_data": {"fullname": "gaitsetpy.core.EDAManager.analyze_data", "modulename": "gaitsetpy.core", "qualname": "EDAManager.analyze_data", "kind": "function", "doc": "<p>Analyze data using the specified analyzer.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to analyze\n    **kwargs: Additional arguments for analysis</p>\n\n<p>Returns:\n    Analysis results dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.EDAManager.visualize_data": {"fullname": "gaitsetpy.core.EDAManager.visualize_data", "modulename": "gaitsetpy.core", "qualname": "EDAManager.visualize_data", "kind": "function", "doc": "<p>Create visualizations using the specified analyzer.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to visualize\n    **kwargs: Additional arguments for visualization</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.ClassificationManager": {"fullname": "gaitsetpy.core.ClassificationManager", "modulename": "gaitsetpy.core", "qualname": "ClassificationManager", "kind": "class", "doc": "<p>Singleton manager for classification models.</p>\n", "bases": "gaitsetpy.core.managers.BaseManager"}, "gaitsetpy.core.ClassificationManager.register_model": {"fullname": "gaitsetpy.core.ClassificationManager.register_model", "modulename": "gaitsetpy.core", "qualname": "ClassificationManager.register_model", "kind": "function", "doc": "<p>Register a classification model.</p>\n\n<p>Args:\n    name: Name to register the model under\n    model_class: Classification model class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">model_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseClassificationModel</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.ClassificationManager.train_model": {"fullname": "gaitsetpy.core.ClassificationManager.train_model", "modulename": "gaitsetpy.core", "qualname": "ClassificationManager.train_model", "kind": "function", "doc": "<p>Train a classification model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n\n<p>Returns:\n    Trained model instance</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseClassificationModel</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.ClassificationManager.predict": {"fullname": "gaitsetpy.core.ClassificationManager.predict", "modulename": "gaitsetpy.core", "qualname": "ClassificationManager.predict", "kind": "function", "doc": "<p>Make predictions using a trained model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Predictions array</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.ClassificationManager.evaluate_model": {"fullname": "gaitsetpy.core.ClassificationManager.evaluate_model", "modulename": "gaitsetpy.core", "qualname": "ClassificationManager.evaluate_model", "kind": "function", "doc": "<p>Evaluate a classification model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Evaluation metrics dictionary</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes": {"fullname": "gaitsetpy.core.base_classes", "modulename": "gaitsetpy.core.base_classes", "kind": "module", "doc": "<p>Base classes for GaitSetPy components.</p>\n\n<p>This module defines abstract base classes that all components should inherit from.\nEach base class defines the interface and common functionality for its respective component type.</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.core.base_classes.BaseDatasetLoader": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader", "kind": "class", "doc": "<p>Base class for all dataset loaders.</p>\n\n<p>All dataset loaders should inherit from this class and implement the required methods.\nThis class provides thread-safe concurrent downloading capabilities for efficient data retrieval.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.__init__": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.__init__", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.__init__", "kind": "function", "doc": "<p>Initialize the dataset loader.</p>\n\n<p>Args:\n    name: Name of the dataset\n    description: Description of the dataset\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>, </span><span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.name": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.name", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.description": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.description", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.data": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.data", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.data", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.metadata": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.metadata", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.max_workers": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.max_workers", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.max_workers", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.load_data": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.load_data", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.load_data", "kind": "function", "doc": "<p>Load dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    **kwargs: Additional arguments specific to the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.create_sliding_windows": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.create_sliding_windows", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the loaded data.</p>\n\n<p>Args:\n    data: List of DataFrames\n    names: List of names corresponding to the data\n    window_size: Size of each sliding window\n    step_size: Step size for sliding windows</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.get_supported_formats": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.get_supported_formats", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.download_files_concurrent": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.download_files_concurrent", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.download_files_concurrent", "kind": "function", "doc": "<p>Download multiple files concurrently using a thread pool.</p>\n\n<p>Args:\n    download_tasks: List of dicts with 'url' and 'dest_path' keys\n    show_progress: Whether to show progress bar (default: True)\n    desc: Description for progress bar</p>\n\n<p>Returns:\n    Dictionary with download statistics and results</p>\n\n<p>Example:\n    tasks = [\n        {'url': 'http://example.com/file1.txt', 'dest_path': '/path/to/file1.txt'},\n        {'url': 'http://example.com/file2.txt', 'dest_path': '/path/to/file2.txt'}\n    ]\n    results = loader.download_files_concurrent(tasks)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">download_tasks</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">show_progress</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">desc</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Downloading files&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.set_max_workers": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.set_max_workers", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.set_max_workers", "kind": "function", "doc": "<p>Set the maximum number of concurrent download threads.</p>\n\n<p>Args:\n    max_workers: Maximum number of threads (must be positive)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.get_download_stats": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.get_download_stats", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.get_download_stats", "kind": "function", "doc": "<p>Get statistics from the last download operation.</p>\n\n<p>Returns:\n    Dictionary with success, failed, and skipped counts</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseDatasetLoader.get_info": {"fullname": "gaitsetpy.core.base_classes.BaseDatasetLoader.get_info", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseDatasetLoader.get_info", "kind": "function", "doc": "<p>Get information about the dataset.</p>\n\n<p>Returns:\n    Dictionary containing dataset information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor", "kind": "class", "doc": "<p>Base class for all feature extractors.</p>\n\n<p>All feature extractors should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.__init__": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.__init__", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.name": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.name", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.description": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.description", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.config": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.config", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.extract_features": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.extract_features", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of features extracted by this extractor.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.configure": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.configure", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.configure", "kind": "function", "doc": "<p>Configure the feature extractor.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.get_info": {"fullname": "gaitsetpy.core.base_classes.BaseFeatureExtractor.get_info", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseFeatureExtractor.get_info", "kind": "function", "doc": "<p>Get information about the feature extractor.</p>\n\n<p>Returns:\n    Dictionary containing feature extractor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BasePreprocessor": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor", "kind": "class", "doc": "<p>Base class for all preprocessors.</p>\n\n<p>All preprocessors should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.base_classes.BasePreprocessor.__init__": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.__init__", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.base_classes.BasePreprocessor.name": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.name", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BasePreprocessor.description": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.description", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BasePreprocessor.config": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.config", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BasePreprocessor.fitted": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.fitted", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.fitted", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BasePreprocessor.fit": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.fit", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor to the data.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments for fitting</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BasePreprocessor.transform": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.transform", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.transform", "kind": "function", "doc": "<p>Transform the data using the fitted preprocessor.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments for transformation</p>\n\n<p>Returns:\n    Transformed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BasePreprocessor.fit_transform": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.fit_transform", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.fit_transform", "kind": "function", "doc": "<p>Fit the preprocessor and transform the data.</p>\n\n<p>Args:\n    data: Input data to fit and transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Transformed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BasePreprocessor.configure": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.configure", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.configure", "kind": "function", "doc": "<p>Configure the preprocessor.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BasePreprocessor.get_info": {"fullname": "gaitsetpy.core.base_classes.BasePreprocessor.get_info", "modulename": "gaitsetpy.core.base_classes", "qualname": "BasePreprocessor.get_info", "kind": "function", "doc": "<p>Get information about the preprocessor.</p>\n\n<p>Returns:\n    Dictionary containing preprocessor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer", "kind": "class", "doc": "<p>Base class for all EDA analyzers.</p>\n\n<p>All EDA analyzers should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.__init__": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.__init__", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.name": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.name", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.description": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.description", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.config": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.config", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.analyze": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.analyze", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.analyze", "kind": "function", "doc": "<p>Perform analysis on the data.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments for analysis</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.visualize": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.visualize", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of the data.</p>\n\n<p>Args:\n    data: Input data to visualize\n    **kwargs: Additional arguments for visualization</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.configure": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.configure", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.configure", "kind": "function", "doc": "<p>Configure the EDA analyzer.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.get_info": {"fullname": "gaitsetpy.core.base_classes.BaseEDAAnalyzer.get_info", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseEDAAnalyzer.get_info", "kind": "function", "doc": "<p>Get information about the EDA analyzer.</p>\n\n<p>Returns:\n    Dictionary containing EDA analyzer information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseClassificationModel": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel", "kind": "class", "doc": "<p>Base class for all classification models.</p>\n\n<p>All classification models should inherit from this class and implement the required methods.</p>\n", "bases": "abc.ABC"}, "gaitsetpy.core.base_classes.BaseClassificationModel.__init__": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.__init__", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.__init__", "kind": "function", "doc": "<p>Initialize the classification model.</p>\n\n<p>Args:\n    name: Name of the classification model\n    description: Description of the classification model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "gaitsetpy.core.base_classes.BaseClassificationModel.name": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.name", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.name", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseClassificationModel.description": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.description", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.description", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseClassificationModel.model": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.model", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.model", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseClassificationModel.config": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.config", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseClassificationModel.trained": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.trained", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.trained", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.core.base_classes.BaseClassificationModel.train": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.train", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.train", "kind": "function", "doc": "<p>Train the classification model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseClassificationModel.predict": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.predict", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.predict", "kind": "function", "doc": "<p>Make predictions using the trained model.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Array of predictions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseClassificationModel.evaluate": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.evaluate", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.evaluate", "kind": "function", "doc": "<p>Evaluate the model performance.</p>\n\n<p>Args:\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Dictionary containing evaluation metrics</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseClassificationModel.save_model": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.save_model", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.save_model", "kind": "function", "doc": "<p>Save the trained model to a file.</p>\n\n<p>Args:\n    filepath: Path to save the model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseClassificationModel.load_model": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.load_model", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.load_model", "kind": "function", "doc": "<p>Load a trained model from a file.</p>\n\n<p>Args:\n    filepath: Path to the saved model</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseClassificationModel.configure": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.configure", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.configure", "kind": "function", "doc": "<p>Configure the classification model.</p>\n\n<p>Args:\n    config: Configuration dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.base_classes.BaseClassificationModel.get_info": {"fullname": "gaitsetpy.core.base_classes.BaseClassificationModel.get_info", "modulename": "gaitsetpy.core.base_classes", "qualname": "BaseClassificationModel.get_info", "kind": "function", "doc": "<p>Get information about the classification model.</p>\n\n<p>Returns:\n    Dictionary containing model information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers": {"fullname": "gaitsetpy.core.managers", "modulename": "gaitsetpy.core.managers", "kind": "module", "doc": "<p>Singleton managers for GaitSetPy components.</p>\n\n<p>This module provides singleton managers for each component type that handle\nplugin registration, discovery, and instantiation.</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.core.managers.SingletonMeta": {"fullname": "gaitsetpy.core.managers.SingletonMeta", "modulename": "gaitsetpy.core.managers", "qualname": "SingletonMeta", "kind": "class", "doc": "<p>Metaclass for implementing singleton pattern with thread safety.</p>\n", "bases": "builtins.type"}, "gaitsetpy.core.managers.BaseManager": {"fullname": "gaitsetpy.core.managers.BaseManager", "modulename": "gaitsetpy.core.managers", "qualname": "BaseManager", "kind": "class", "doc": "<p>Base manager class for all component managers.</p>\n"}, "gaitsetpy.core.managers.BaseManager.register": {"fullname": "gaitsetpy.core.managers.BaseManager.register", "modulename": "gaitsetpy.core.managers", "qualname": "BaseManager.register", "kind": "function", "doc": "<p>Register a component class.</p>\n\n<p>Args:\n    name: Name to register the component under\n    component_class: Component class to register</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">component_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.BaseManager.unregister": {"fullname": "gaitsetpy.core.managers.BaseManager.unregister", "modulename": "gaitsetpy.core.managers", "qualname": "BaseManager.unregister", "kind": "function", "doc": "<p>Unregister a component.</p>\n\n<p>Args:\n    name: Name of the component to unregister</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.BaseManager.get_available_components": {"fullname": "gaitsetpy.core.managers.BaseManager.get_available_components", "modulename": "gaitsetpy.core.managers", "qualname": "BaseManager.get_available_components", "kind": "function", "doc": "<p>Get list of available component names.</p>\n\n<p>Returns:\n    List of registered component names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.BaseManager.get_component_info": {"fullname": "gaitsetpy.core.managers.BaseManager.get_component_info", "modulename": "gaitsetpy.core.managers", "qualname": "BaseManager.get_component_info", "kind": "function", "doc": "<p>Get information about a registered component.</p>\n\n<p>Args:\n    name: Name of the component</p>\n\n<p>Returns:\n    Component information dictionary or None if not found</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.BaseManager.create_instance": {"fullname": "gaitsetpy.core.managers.BaseManager.create_instance", "modulename": "gaitsetpy.core.managers", "qualname": "BaseManager.create_instance", "kind": "function", "doc": "<p>Create an instance of a registered component.</p>\n\n<p>Args:\n    name: Name of the component\n    <em>args: Positional arguments for component constructor\n    *</em>kwargs: Keyword arguments for component constructor</p>\n\n<p>Returns:\n    Component instance</p>\n\n<p>Raises:\n    ValueError: If component is not registered</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.BaseManager.get_cached_instance": {"fullname": "gaitsetpy.core.managers.BaseManager.get_cached_instance", "modulename": "gaitsetpy.core.managers", "qualname": "BaseManager.get_cached_instance", "kind": "function", "doc": "<p>Get a cached instance of a component, creating it if it doesn't exist.</p>\n\n<p>Args:\n    name: Name of the component\n    <em>args: Positional arguments for component constructor\n    *</em>kwargs: Keyword arguments for component constructor</p>\n\n<p>Returns:\n    Component instance</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.DatasetManager": {"fullname": "gaitsetpy.core.managers.DatasetManager", "modulename": "gaitsetpy.core.managers", "qualname": "DatasetManager", "kind": "class", "doc": "<p>Singleton manager for dataset loaders.</p>\n", "bases": "BaseManager"}, "gaitsetpy.core.managers.DatasetManager.register_dataset": {"fullname": "gaitsetpy.core.managers.DatasetManager.register_dataset", "modulename": "gaitsetpy.core.managers", "qualname": "DatasetManager.register_dataset", "kind": "function", "doc": "<p>Register a dataset loader.</p>\n\n<p>Args:\n    name: Name to register the dataset under\n    dataset_class: Dataset loader class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">dataset_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseDatasetLoader</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.DatasetManager.load_dataset": {"fullname": "gaitsetpy.core.managers.DatasetManager.load_dataset", "modulename": "gaitsetpy.core.managers", "qualname": "DatasetManager.load_dataset", "kind": "function", "doc": "<p>Load a dataset using the registered loader.</p>\n\n<p>Args:\n    name: Name of the dataset loader\n    data_dir: Directory containing the dataset\n    **kwargs: Additional arguments for the loader</p>\n\n<p>Returns:\n    Dataset loader instance with loaded data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseDatasetLoader</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.FeatureManager": {"fullname": "gaitsetpy.core.managers.FeatureManager", "modulename": "gaitsetpy.core.managers", "qualname": "FeatureManager", "kind": "class", "doc": "<p>Singleton manager for feature extractors.</p>\n", "bases": "BaseManager"}, "gaitsetpy.core.managers.FeatureManager.register_extractor": {"fullname": "gaitsetpy.core.managers.FeatureManager.register_extractor", "modulename": "gaitsetpy.core.managers", "qualname": "FeatureManager.register_extractor", "kind": "function", "doc": "<p>Register a feature extractor.</p>\n\n<p>Args:\n    name: Name to register the extractor under\n    extractor_class: Feature extractor class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">extractor_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseFeatureExtractor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.FeatureManager.extract_features": {"fullname": "gaitsetpy.core.managers.FeatureManager.extract_features", "modulename": "gaitsetpy.core.managers", "qualname": "FeatureManager.extract_features", "kind": "function", "doc": "<p>Extract features using the specified extractor.</p>\n\n<p>Args:\n    extractor_name: Name of the feature extractor\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">extractor_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.PreprocessingManager": {"fullname": "gaitsetpy.core.managers.PreprocessingManager", "modulename": "gaitsetpy.core.managers", "qualname": "PreprocessingManager", "kind": "class", "doc": "<p>Singleton manager for preprocessors.</p>\n", "bases": "BaseManager"}, "gaitsetpy.core.managers.PreprocessingManager.register_preprocessor": {"fullname": "gaitsetpy.core.managers.PreprocessingManager.register_preprocessor", "modulename": "gaitsetpy.core.managers", "qualname": "PreprocessingManager.register_preprocessor", "kind": "function", "doc": "<p>Register a preprocessor.</p>\n\n<p>Args:\n    name: Name to register the preprocessor under\n    preprocessor_class: Preprocessor class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">preprocessor_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BasePreprocessor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.PreprocessingManager.preprocess_data": {"fullname": "gaitsetpy.core.managers.PreprocessingManager.preprocess_data", "modulename": "gaitsetpy.core.managers", "qualname": "PreprocessingManager.preprocess_data", "kind": "function", "doc": "<p>Preprocess data using the specified preprocessor.</p>\n\n<p>Args:\n    preprocessor_name: Name of the preprocessor\n    data: Input data to preprocess\n    **kwargs: Additional arguments for preprocessing</p>\n\n<p>Returns:\n    Preprocessed data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">preprocessor_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.EDAManager": {"fullname": "gaitsetpy.core.managers.EDAManager", "modulename": "gaitsetpy.core.managers", "qualname": "EDAManager", "kind": "class", "doc": "<p>Singleton manager for EDA analyzers.</p>\n", "bases": "BaseManager"}, "gaitsetpy.core.managers.EDAManager.register_analyzer": {"fullname": "gaitsetpy.core.managers.EDAManager.register_analyzer", "modulename": "gaitsetpy.core.managers", "qualname": "EDAManager.register_analyzer", "kind": "function", "doc": "<p>Register an EDA analyzer.</p>\n\n<p>Args:\n    name: Name to register the analyzer under\n    analyzer_class: EDA analyzer class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">analyzer_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseEDAAnalyzer</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.EDAManager.analyze_data": {"fullname": "gaitsetpy.core.managers.EDAManager.analyze_data", "modulename": "gaitsetpy.core.managers", "qualname": "EDAManager.analyze_data", "kind": "function", "doc": "<p>Analyze data using the specified analyzer.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to analyze\n    **kwargs: Additional arguments for analysis</p>\n\n<p>Returns:\n    Analysis results dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.EDAManager.visualize_data": {"fullname": "gaitsetpy.core.managers.EDAManager.visualize_data", "modulename": "gaitsetpy.core.managers", "qualname": "EDAManager.visualize_data", "kind": "function", "doc": "<p>Create visualizations using the specified analyzer.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to visualize\n    **kwargs: Additional arguments for visualization</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.ClassificationManager": {"fullname": "gaitsetpy.core.managers.ClassificationManager", "modulename": "gaitsetpy.core.managers", "qualname": "ClassificationManager", "kind": "class", "doc": "<p>Singleton manager for classification models.</p>\n", "bases": "BaseManager"}, "gaitsetpy.core.managers.ClassificationManager.register_model": {"fullname": "gaitsetpy.core.managers.ClassificationManager.register_model", "modulename": "gaitsetpy.core.managers", "qualname": "ClassificationManager.register_model", "kind": "function", "doc": "<p>Register a classification model.</p>\n\n<p>Args:\n    name: Name to register the model under\n    model_class: Classification model class</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">model_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseClassificationModel</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.ClassificationManager.train_model": {"fullname": "gaitsetpy.core.managers.ClassificationManager.train_model", "modulename": "gaitsetpy.core.managers", "qualname": "ClassificationManager.train_model", "kind": "function", "doc": "<p>Train a classification model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for training</p>\n\n<p>Returns:\n    Trained model instance</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">gaitsetpy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">base_classes</span><span class=\"o\">.</span><span class=\"n\">BaseClassificationModel</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.ClassificationManager.predict": {"fullname": "gaitsetpy.core.managers.ClassificationManager.predict", "modulename": "gaitsetpy.core.managers", "qualname": "ClassificationManager.predict", "kind": "function", "doc": "<p>Make predictions using a trained model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for prediction</p>\n\n<p>Returns:\n    Predictions array</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.core.managers.ClassificationManager.evaluate_model": {"fullname": "gaitsetpy.core.managers.ClassificationManager.evaluate_model", "modulename": "gaitsetpy.core.managers", "qualname": "ClassificationManager.evaluate_model", "kind": "function", "doc": "<p>Evaluate a classification model.</p>\n\n<p>Args:\n    model_name: Name of the classification model\n    features: List of feature dictionaries\n    **kwargs: Additional arguments for evaluation</p>\n\n<p>Returns:\n    Evaluation metrics dictionary</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset": {"fullname": "gaitsetpy.dataset", "modulename": "gaitsetpy.dataset", "kind": "module", "doc": "<p>dataset: Handles loading and processing of supported datasets.</p>\n\n<p>This module provides both the new class-based dataset loaders and legacy function-based API.\nAll dataset loaders inherit from BaseDatasetLoader and are registered with the DatasetManager.</p>\n\n<p>Supported datasets:</p>\n\n<ul>\n<li>Daphnet: Freezing of Gait dataset</li>\n<li>MobiFall: Fall detection dataset</li>\n<li>Arduous: Daily activity recognition dataset</li>\n<li>PhysioNet: VGRF dataset for Parkinson's disease gait analysis</li>\n<li>HAR-UP: Multimodal System for Fall Detection and Human Activity Recognition</li>\n<li>UrFall: University of Rzeszow Fall Detection Dataset with multimodal data</li>\n</ul>\n"}, "gaitsetpy.dataset.DaphnetLoader": {"fullname": "gaitsetpy.dataset.DaphnetLoader", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader", "kind": "class", "doc": "<p>Daphnet dataset loader class.</p>\n\n<p>This class handles loading and processing of the Daphnet dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.DaphnetLoader.__init__": {"fullname": "gaitsetpy.dataset.DaphnetLoader.__init__", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader.__init__", "kind": "function", "doc": "<p>Initialize Daphnet loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.DaphnetLoader.metadata": {"fullname": "gaitsetpy.dataset.DaphnetLoader.metadata", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.DaphnetLoader.load_data": {"fullname": "gaitsetpy.dataset.DaphnetLoader.load_data", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader.load_data", "kind": "function", "doc": "<p>Load Daphnet dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for Daphnet)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.DaphnetLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.DaphnetLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the Daphnet dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing Daphnet data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.DaphnetLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.DaphnetLoader.get_supported_formats", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for Daphnet dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.DaphnetLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.DaphnetLoader.get_sensor_info", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.DaphnetLoader.get_annotation_info": {"fullname": "gaitsetpy.dataset.DaphnetLoader.get_annotation_info", "modulename": "gaitsetpy.dataset", "qualname": "DaphnetLoader.get_annotation_info", "kind": "function", "doc": "<p>Get information about annotations in the dataset.</p>\n\n<p>Returns:\n    Dictionary mapping annotation values to descriptions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.MobiFallLoader": {"fullname": "gaitsetpy.dataset.MobiFallLoader", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader", "kind": "class", "doc": "<p>MobiFall dataset loader class.</p>\n\n<p>This class handles loading and processing of the MobiFall dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.MobiFallLoader.__init__": {"fullname": "gaitsetpy.dataset.MobiFallLoader.__init__", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader.__init__", "kind": "function", "doc": "<p>Initialize MobiFall loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.MobiFallLoader.metadata": {"fullname": "gaitsetpy.dataset.MobiFallLoader.metadata", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.MobiFallLoader.load_data": {"fullname": "gaitsetpy.dataset.MobiFallLoader.load_data", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader.load_data", "kind": "function", "doc": "<p>Load MobiFall dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for MobiFall)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.MobiFallLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.MobiFallLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the MobiFall dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing MobiFall data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.MobiFallLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.MobiFallLoader.get_supported_formats", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for MobiFall dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.MobiFallLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.MobiFallLoader.get_sensor_info", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.MobiFallLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.MobiFallLoader.get_activity_info", "modulename": "gaitsetpy.dataset", "qualname": "MobiFallLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    List of activity types</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.ArduousLoader": {"fullname": "gaitsetpy.dataset.ArduousLoader", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader", "kind": "class", "doc": "<p>Arduous dataset loader class.</p>\n\n<p>This class handles loading and processing of the Arduous dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.ArduousLoader.__init__": {"fullname": "gaitsetpy.dataset.ArduousLoader.__init__", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader.__init__", "kind": "function", "doc": "<p>Initialize Arduous loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.ArduousLoader.metadata": {"fullname": "gaitsetpy.dataset.ArduousLoader.metadata", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.ArduousLoader.load_data": {"fullname": "gaitsetpy.dataset.ArduousLoader.load_data", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader.load_data", "kind": "function", "doc": "<p>Load Arduous dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for Arduous)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.ArduousLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.ArduousLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the Arduous dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing Arduous data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.ArduousLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.ArduousLoader.get_supported_formats", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for Arduous dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.ArduousLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.ArduousLoader.get_sensor_info", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.ArduousLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.ArduousLoader.get_activity_info", "modulename": "gaitsetpy.dataset", "qualname": "ArduousLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    List of activity types</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.PhysioNetLoader": {"fullname": "gaitsetpy.dataset.PhysioNetLoader", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader", "kind": "class", "doc": "<p>PhysioNet VGRF dataset loader class.</p>\n\n<p>This class handles loading and processing of the PhysioNet Gait in Parkinson's Disease dataset.\nThe dataset contains vertical ground reaction force (VGRF) data from subjects with Parkinson's \ndisease and healthy controls.</p>\n\n<p>Features concurrent downloading for efficient data retrieval.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.PhysioNetLoader.__init__": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.__init__", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.__init__", "kind": "function", "doc": "<p>Initialize PhysioNet loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.PhysioNetLoader.metadata": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.metadata", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.PhysioNetLoader.labels": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.labels", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.labels", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.PhysioNetLoader.subject_types": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.subject_types", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.subject_types", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.PhysioNetLoader.load_data": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.load_data", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.load_data", "kind": "function", "doc": "<p>Load PhysioNet VGRF dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for PhysioNet)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.PhysioNetLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the PhysioNet dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing PhysioNet data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 600 for 6 seconds at 100Hz)\n    step_size: Step size for the sliding window (default: 100)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">600</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.PhysioNetLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.get_supported_formats", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for PhysioNet dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.PhysioNetLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.get_sensor_info", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.PhysioNetLoader.get_subject_info": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.get_subject_info", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.get_subject_info", "kind": "function", "doc": "<p>Get information about subjects in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing subject information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.PhysioNetLoader.get_labels": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.get_labels", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.get_labels", "kind": "function", "doc": "<p>Get labels for loaded data.</p>\n\n<p>Returns:\n    List of labels corresponding to loaded data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.PhysioNetLoader.filter_by_subject_type": {"fullname": "gaitsetpy.dataset.PhysioNetLoader.filter_by_subject_type", "modulename": "gaitsetpy.dataset", "qualname": "PhysioNetLoader.filter_by_subject_type", "kind": "function", "doc": "<p>Filter loaded data by subject type.</p>\n\n<p>Args:\n    subject_type: 'Control' or 'Patient'</p>\n\n<p>Returns:\n    Tuple of (filtered_data, filtered_names)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">subject_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.HARUPLoader": {"fullname": "gaitsetpy.dataset.HARUPLoader", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader", "kind": "class", "doc": "<p>HAR-UP dataset loader class.</p>\n\n<p>This class handles loading and processing of the HAR-UP dataset for human activity recognition\nand fall detection analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.HARUPLoader.__init__": {"fullname": "gaitsetpy.dataset.HARUPLoader.__init__", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.__init__", "kind": "function", "doc": "<p>Initialize HAR-UP loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.HARUPLoader.metadata": {"fullname": "gaitsetpy.dataset.HARUPLoader.metadata", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.HARUPLoader.features": {"fullname": "gaitsetpy.dataset.HARUPLoader.features", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.features", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.HARUPLoader.download_harup_data": {"fullname": "gaitsetpy.dataset.HARUPLoader.download_harup_data", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.download_harup_data", "kind": "function", "doc": "<p>Download HAR-UP dataset if not already present.</p>\n\n<p>Args:\n    data_dir: Directory to store the dataset</p>\n\n<p>Returns:\n    Path to the extracted dataset or None if not found</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.HARUPLoader.load_data": {"fullname": "gaitsetpy.dataset.HARUPLoader.load_data", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.load_data", "kind": "function", "doc": "<p>Load HAR-UP dataset from the specified directory.\nArgs:\n    data_dir: Directory containing the dataset\n    subjects: List of subject IDs to load (default: all subjects)\n    activities: List of activity IDs to load (default: all activities)\n    trials: List of trial IDs to load (default: all trials)\n    **kwargs: Additional arguments\nReturns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">subjects</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">activities</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">trials</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.HARUPLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.HARUPLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the HAR-UP dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing HAR-UP data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 100 = 1 second at 100Hz)\n    step_size: Step size for the sliding window (default: 50 = 0.5 seconds at 100Hz)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">50</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.HARUPLoader.extract_features": {"fullname": "gaitsetpy.dataset.HARUPLoader.extract_features", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows using HAR-UP feature extraction methods.\nArgs:\n    windows_data: List of dictionaries containing sliding windows\n    time_domain_features: Whether to extract time domain features\n    freq_domain_features: Whether to extract frequency domain features\nReturns:\n    List of dictionaries containing extracted features</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">windows_data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">time_domain_features</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">freq_domain_features</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.HARUPLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.HARUPLoader.get_supported_formats", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for HAR-UP dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.HARUPLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.HARUPLoader.get_sensor_info", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.HARUPLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.HARUPLoader.get_activity_info", "modulename": "gaitsetpy.dataset", "qualname": "HARUPLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    Dictionary mapping activity IDs to descriptions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.UrFallLoader": {"fullname": "gaitsetpy.dataset.UrFallLoader", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader", "kind": "class", "doc": "<p>UrFall dataset loader class.</p>\n\n<p>This class handles loading and processing of the UrFall dataset for fall detection.\nSupports multiple data types: Depth, RGB, Accelerometer, Synchronization, Video,\nand pre-extracted features from depth maps.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.UrFallLoader.__init__": {"fullname": "gaitsetpy.dataset.UrFallLoader.__init__", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.__init__", "kind": "function", "doc": "<p>Initialize UrFall loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.UrFallLoader.metadata": {"fullname": "gaitsetpy.dataset.UrFallLoader.metadata", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.UrFallLoader.load_data": {"fullname": "gaitsetpy.dataset.UrFallLoader.load_data", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.load_data", "kind": "function", "doc": "<p>Load UrFall dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    data_types: List of data types to load. Options: 'depth', 'rgb', 'accelerometer',\n               'synchronization', 'video', 'features' (default: ['features'])\n    sequences: List of specific sequences to load (e.g., ['fall-01', 'adl-01'])\n              If None, loads all based on use_falls and use_adls\n    use_falls: Whether to load fall sequences (default: True)\n    use_adls: Whether to load ADL (Activities of Daily Living) sequences (default: True)\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_types</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sequences</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">use_falls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_adls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.UrFallLoader.get_file_paths": {"fullname": "gaitsetpy.dataset.UrFallLoader.get_file_paths", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.get_file_paths", "kind": "function", "doc": "<p>Get file paths for image/video data types (depth, RGB, video).</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    data_type: Type of data ('depth', 'rgb', 'video')\n    sequences: Specific sequences to get paths for\n    use_falls: Whether to include fall sequences\n    use_adls: Whether to include ADL sequences</p>\n\n<p>Returns:\n    Dictionary mapping sequence names to file paths</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">sequences</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">use_falls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_adls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.UrFallLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.UrFallLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the loaded data.</p>\n\n<p>Args:\n    data: List of DataFrames containing the dataset\n    names: List of names corresponding to each DataFrame\n    window_size: Size of the sliding window (default: 30 frames for depth features)\n    step_size: Step size for sliding window (default: 15 frames)</p>\n\n<p>Returns:\n    List of dictionaries containing windowed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">30</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">15</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.UrFallLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.UrFallLoader.get_supported_formats", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for UrFall dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.UrFallLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.UrFallLoader.get_sensor_info", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">&lt;</span><span class=\"n\">built</span><span class=\"o\">-</span><span class=\"ow\">in</span> <span class=\"n\">function</span> <span class=\"nb\">any</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.UrFallLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.UrFallLoader.get_activity_info", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    Dictionary mapping activity IDs to labels</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.UrFallLoader.get_feature_info": {"fullname": "gaitsetpy.dataset.UrFallLoader.get_feature_info", "modulename": "gaitsetpy.dataset", "qualname": "UrFallLoader.get_feature_info", "kind": "function", "doc": "<p>Get information about pre-extracted features.</p>\n\n<p>Returns:\n    Dictionary mapping feature names to descriptions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.load_daphnet_data": {"fullname": "gaitsetpy.dataset.load_daphnet_data", "modulename": "gaitsetpy.dataset", "qualname": "load_daphnet_data", "kind": "function", "doc": "<p>Legacy function for loading Daphnet data.</p>\n\n<p>Args:\n    data_dir: Directory to store the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.create_sliding_windows": {"fullname": "gaitsetpy.dataset.create_sliding_windows", "modulename": "gaitsetpy.dataset", "qualname": "create_sliding_windows", "kind": "function", "doc": "<p>Legacy function for creating sliding windows.</p>\n\n<p>Args:\n    daphnet: List of dataframes containing Daphnet data\n    daphnet_names: List of names of the Daphnet dataframes\n    window_size: Size of the sliding window\n    step_size: Step size for the sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnet</span>, </span><span class=\"param\"><span class=\"n\">daphnet_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">192</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">32</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.load_mobifall_data": {"fullname": "gaitsetpy.dataset.load_mobifall_data", "modulename": "gaitsetpy.dataset", "qualname": "load_mobifall_data", "kind": "function", "doc": "<p>Legacy function for loading MobiFall data.</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.load_arduous_data": {"fullname": "gaitsetpy.dataset.load_arduous_data", "modulename": "gaitsetpy.dataset", "qualname": "load_arduous_data", "kind": "function", "doc": "<p>Legacy function for loading Arduous data.</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.load_physionet_data": {"fullname": "gaitsetpy.dataset.load_physionet_data", "modulename": "gaitsetpy.dataset", "qualname": "load_physionet_data", "kind": "function", "doc": "<p>Legacy function to load PhysioNet data.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.create_physionet_windows": {"fullname": "gaitsetpy.dataset.create_physionet_windows", "modulename": "gaitsetpy.dataset", "qualname": "create_physionet_windows", "kind": "function", "doc": "<p>Legacy function to create sliding windows from PhysioNet data.</p>\n\n<p>Args:\n    data: List of DataFrames\n    names: List of names\n    window_size: Size of sliding window\n    step_size: Step size for sliding window</p>\n\n<p>Returns:\n    List of sliding window dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">600</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.load_harup_data": {"fullname": "gaitsetpy.dataset.load_harup_data", "modulename": "gaitsetpy.dataset", "qualname": "load_harup_data", "kind": "function", "doc": "<p>Legacy function for loading HAR-UP data.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    subjects: List of subject IDs to load (default: all subjects)\n    activities: List of activity IDs to load (default: all activities)\n    trials: List of trial IDs to load (default: all trials)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">subjects</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">activities</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">trials</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.create_harup_windows": {"fullname": "gaitsetpy.dataset.create_harup_windows", "modulename": "gaitsetpy.dataset", "qualname": "create_harup_windows", "kind": "function", "doc": "<p>Legacy function for creating sliding windows from HAR-UP data.</p>\n\n<p>Args:\n    harup_data: List of dataframes containing HAR-UP data\n    harup_names: List of names of the HAR-UP dataframes\n    window_size: Size of the sliding window\n    step_size: Step size for the sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_data</span>, </span><span class=\"param\"><span class=\"n\">harup_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">50</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.extract_harup_features": {"fullname": "gaitsetpy.dataset.extract_harup_features", "modulename": "gaitsetpy.dataset", "qualname": "extract_harup_features", "kind": "function", "doc": "<p>Legacy function for extracting features from HAR-UP windows.</p>\n\n<p>Args:\n    windows_data: List of dictionaries containing sliding windows\n    time_domain: Whether to extract time domain features\n    freq_domain: Whether to extract frequency domain features</p>\n\n<p>Returns:\n    List of dictionaries containing extracted features</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows_data</span>, </span><span class=\"param\"><span class=\"n\">time_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">freq_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.load_urfall_data": {"fullname": "gaitsetpy.dataset.load_urfall_data", "modulename": "gaitsetpy.dataset", "qualname": "load_urfall_data", "kind": "function", "doc": "<p>Load UrFall dataset using the legacy function interface.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    data_types: List of data types to load\n    sequences: List of specific sequences to load\n    use_falls: Whether to load fall sequences\n    use_adls: Whether to load ADL sequences</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_types</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sequences</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">use_falls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_adls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.create_urfall_windows": {"fullname": "gaitsetpy.dataset.create_urfall_windows", "modulename": "gaitsetpy.dataset", "qualname": "create_urfall_windows", "kind": "function", "doc": "<p>Create sliding windows from UrFall data using the legacy function interface.</p>\n\n<p>Args:\n    urfall_data: List of DataFrames\n    urfall_names: List of names\n    window_size: Size of sliding window\n    step_size: Step size for sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing windowed data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">urfall_data</span>, </span><span class=\"param\"><span class=\"n\">urfall_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">30</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">15</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.download_dataset": {"fullname": "gaitsetpy.dataset.download_dataset", "modulename": "gaitsetpy.dataset", "qualname": "download_dataset", "kind": "function", "doc": "<p>Download the dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dataset_name</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.extract_dataset": {"fullname": "gaitsetpy.dataset.extract_dataset", "modulename": "gaitsetpy.dataset", "qualname": "extract_dataset", "kind": "function", "doc": "<p>Extract the dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dataset_name</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.sliding_window": {"fullname": "gaitsetpy.dataset.sliding_window", "modulename": "gaitsetpy.dataset", "qualname": "sliding_window", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">window_size</span>, </span><span class=\"param\"><span class=\"n\">step_size</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.get_dataset_manager": {"fullname": "gaitsetpy.dataset.get_dataset_manager", "modulename": "gaitsetpy.dataset", "qualname": "get_dataset_manager", "kind": "function", "doc": "<p>Get the singleton DatasetManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.get_available_datasets": {"fullname": "gaitsetpy.dataset.get_available_datasets", "modulename": "gaitsetpy.dataset", "qualname": "get_available_datasets", "kind": "function", "doc": "<p>Get list of available dataset names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.load_dataset": {"fullname": "gaitsetpy.dataset.load_dataset", "modulename": "gaitsetpy.dataset", "qualname": "load_dataset", "kind": "function", "doc": "<p>Load a dataset using the DatasetManager.</p>\n\n<p>Args:\n    name: Name of the dataset loader\n    data_dir: Directory containing the dataset\n    **kwargs: Additional arguments for the loader</p>\n\n<p>Returns:\n    Dataset loader instance with loaded data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.arduous": {"fullname": "gaitsetpy.dataset.arduous", "modulename": "gaitsetpy.dataset.arduous", "kind": "module", "doc": "<p>Arduous Dataset Loader.\nMaintainer: @aharshit123456</p>\n\n<p>This file contains the Arduous dataset loader class that inherits from BaseDatasetLoader.</p>\n"}, "gaitsetpy.dataset.arduous.ArduousLoader": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader", "kind": "class", "doc": "<p>Arduous dataset loader class.</p>\n\n<p>This class handles loading and processing of the Arduous dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.arduous.ArduousLoader.__init__": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader.__init__", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader.__init__", "kind": "function", "doc": "<p>Initialize Arduous loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.arduous.ArduousLoader.metadata": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader.metadata", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.arduous.ArduousLoader.load_data": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader.load_data", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader.load_data", "kind": "function", "doc": "<p>Load Arduous dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for Arduous)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.arduous.ArduousLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the Arduous dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing Arduous data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.arduous.ArduousLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader.get_supported_formats", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for Arduous dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.arduous.ArduousLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader.get_sensor_info", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.arduous.ArduousLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.arduous.ArduousLoader.get_activity_info", "modulename": "gaitsetpy.dataset.arduous", "qualname": "ArduousLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    List of activity types</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.arduous.load_arduous_data": {"fullname": "gaitsetpy.dataset.arduous.load_arduous_data", "modulename": "gaitsetpy.dataset.arduous", "qualname": "load_arduous_data", "kind": "function", "doc": "<p>Legacy function for loading Arduous data.</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet": {"fullname": "gaitsetpy.dataset.daphnet", "modulename": "gaitsetpy.dataset.daphnet", "kind": "module", "doc": "<p>Daphnet Dataset Loader and Utils.\nMaintainer: @aharshit123456</p>\n\n<p>This file contains the Daphnet dataset loader class that inherits from BaseDatasetLoader.</p>\n"}, "gaitsetpy.dataset.daphnet.DaphnetLoader": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader", "kind": "class", "doc": "<p>Daphnet dataset loader class.</p>\n\n<p>This class handles loading and processing of the Daphnet dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.daphnet.DaphnetLoader.__init__": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader.__init__", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader.__init__", "kind": "function", "doc": "<p>Initialize Daphnet loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.daphnet.DaphnetLoader.metadata": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader.metadata", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.daphnet.DaphnetLoader.load_data": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader.load_data", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader.load_data", "kind": "function", "doc": "<p>Load Daphnet dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for Daphnet)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.DaphnetLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the Daphnet dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing Daphnet data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.DaphnetLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader.get_supported_formats", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for Daphnet dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.DaphnetLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader.get_sensor_info", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.DaphnetLoader.get_annotation_info": {"fullname": "gaitsetpy.dataset.daphnet.DaphnetLoader.get_annotation_info", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "DaphnetLoader.get_annotation_info", "kind": "function", "doc": "<p>Get information about annotations in the dataset.</p>\n\n<p>Returns:\n    Dictionary mapping annotation values to descriptions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.load_daphnet_data": {"fullname": "gaitsetpy.dataset.daphnet.load_daphnet_data", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "load_daphnet_data", "kind": "function", "doc": "<p>Legacy function for loading Daphnet data.</p>\n\n<p>Args:\n    data_dir: Directory to store the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.create_sliding_windows": {"fullname": "gaitsetpy.dataset.daphnet.create_sliding_windows", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "create_sliding_windows", "kind": "function", "doc": "<p>Legacy function for creating sliding windows.</p>\n\n<p>Args:\n    daphnet: List of dataframes containing Daphnet data\n    daphnet_names: List of names of the Daphnet dataframes\n    window_size: Size of the sliding window\n    step_size: Step size for the sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnet</span>, </span><span class=\"param\"><span class=\"n\">daphnet_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">192</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">32</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.plot_dataset_sample": {"fullname": "gaitsetpy.dataset.daphnet.plot_dataset_sample", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "plot_dataset_sample", "kind": "function", "doc": "<p>Placeholder for dataset sample plotting.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.daphnet.plot_sliding_window": {"fullname": "gaitsetpy.dataset.daphnet.plot_sliding_window", "modulename": "gaitsetpy.dataset.daphnet", "qualname": "plot_sliding_window", "kind": "function", "doc": "<p>Placeholder for sliding window plotting.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup": {"fullname": "gaitsetpy.dataset.harup", "modulename": "gaitsetpy.dataset.harup", "kind": "module", "doc": "<p>HAR-UP Dataset Loader and Utils.\nMaintainer: @aharshit123456</p>\n\n<p>This file contains the HAR-UP dataset loader class that inherits from BaseDatasetLoader.\nHAR-UP is a multimodal dataset for human activity recognition and fall detection.</p>\n\n<p>Reference:</p>\n\n<ul>\n<li>Website: <a href=\"https://sites.google.com/up.edu.mx/har-up/\">https://sites.google.com/up.edu.mx/har-up/</a></li>\n<li>GitHub: <a href=\"https://github.com/jpnm561/HAR-UP\">https://github.com/jpnm561/HAR-UP</a></li>\n</ul>\n"}, "gaitsetpy.dataset.harup.HARUPLoader": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader", "kind": "class", "doc": "<p>HAR-UP dataset loader class.</p>\n\n<p>This class handles loading and processing of the HAR-UP dataset for human activity recognition\nand fall detection analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.harup.HARUPLoader.__init__": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.__init__", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.__init__", "kind": "function", "doc": "<p>Initialize HAR-UP loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.harup.HARUPLoader.metadata": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.metadata", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.harup.HARUPLoader.features": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.features", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.features", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.harup.HARUPLoader.download_harup_data": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.download_harup_data", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.download_harup_data", "kind": "function", "doc": "<p>Download HAR-UP dataset if not already present.</p>\n\n<p>Args:\n    data_dir: Directory to store the dataset</p>\n\n<p>Returns:\n    Path to the extracted dataset or None if not found</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.HARUPLoader.load_data": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.load_data", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.load_data", "kind": "function", "doc": "<p>Load HAR-UP dataset from the specified directory.\nArgs:\n    data_dir: Directory containing the dataset\n    subjects: List of subject IDs to load (default: all subjects)\n    activities: List of activity IDs to load (default: all activities)\n    trials: List of trial IDs to load (default: all trials)\n    **kwargs: Additional arguments\nReturns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">subjects</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">activities</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">trials</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.HARUPLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the HAR-UP dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing HAR-UP data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 100 = 1 second at 100Hz)\n    step_size: Step size for the sliding window (default: 50 = 0.5 seconds at 100Hz)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">50</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.HARUPLoader.extract_features": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.extract_features", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows using HAR-UP feature extraction methods.\nArgs:\n    windows_data: List of dictionaries containing sliding windows\n    time_domain_features: Whether to extract time domain features\n    freq_domain_features: Whether to extract frequency domain features\nReturns:\n    List of dictionaries containing extracted features</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">windows_data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">time_domain_features</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">freq_domain_features</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.HARUPLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.get_supported_formats", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for HAR-UP dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.HARUPLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.get_sensor_info", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.HARUPLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.harup.HARUPLoader.get_activity_info", "modulename": "gaitsetpy.dataset.harup", "qualname": "HARUPLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    Dictionary mapping activity IDs to descriptions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.load_harup_data": {"fullname": "gaitsetpy.dataset.harup.load_harup_data", "modulename": "gaitsetpy.dataset.harup", "qualname": "load_harup_data", "kind": "function", "doc": "<p>Legacy function for loading HAR-UP data.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    subjects: List of subject IDs to load (default: all subjects)\n    activities: List of activity IDs to load (default: all activities)\n    trials: List of trial IDs to load (default: all trials)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">subjects</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">activities</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">trials</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.create_harup_windows": {"fullname": "gaitsetpy.dataset.harup.create_harup_windows", "modulename": "gaitsetpy.dataset.harup", "qualname": "create_harup_windows", "kind": "function", "doc": "<p>Legacy function for creating sliding windows from HAR-UP data.</p>\n\n<p>Args:\n    harup_data: List of dataframes containing HAR-UP data\n    harup_names: List of names of the HAR-UP dataframes\n    window_size: Size of the sliding window\n    step_size: Step size for the sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_data</span>, </span><span class=\"param\"><span class=\"n\">harup_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">50</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.harup.extract_harup_features": {"fullname": "gaitsetpy.dataset.harup.extract_harup_features", "modulename": "gaitsetpy.dataset.harup", "qualname": "extract_harup_features", "kind": "function", "doc": "<p>Legacy function for extracting features from HAR-UP windows.</p>\n\n<p>Args:\n    windows_data: List of dictionaries containing sliding windows\n    time_domain: Whether to extract time domain features\n    freq_domain: Whether to extract frequency domain features</p>\n\n<p>Returns:\n    List of dictionaries containing extracted features</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows_data</span>, </span><span class=\"param\"><span class=\"n\">time_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">freq_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.mobifall": {"fullname": "gaitsetpy.dataset.mobifall", "modulename": "gaitsetpy.dataset.mobifall", "kind": "module", "doc": "<p>MobiFall Dataset Loader.\nMaintainer: @aharshit123456</p>\n\n<p>This file contains the MobiFall dataset loader class that inherits from BaseDatasetLoader.</p>\n"}, "gaitsetpy.dataset.mobifall.MobiFallLoader": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader", "kind": "class", "doc": "<p>MobiFall dataset loader class.</p>\n\n<p>This class handles loading and processing of the MobiFall dataset for gait analysis.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.mobifall.MobiFallLoader.__init__": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader.__init__", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader.__init__", "kind": "function", "doc": "<p>Initialize MobiFall loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.mobifall.MobiFallLoader.metadata": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader.metadata", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.mobifall.MobiFallLoader.load_data": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader.load_data", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader.load_data", "kind": "function", "doc": "<p>Load MobiFall dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for MobiFall)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.mobifall.MobiFallLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the MobiFall dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing MobiFall data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 192)\n    step_size: Step size for the sliding window (default: 32)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">192</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.mobifall.MobiFallLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader.get_supported_formats", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for MobiFall dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.mobifall.MobiFallLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader.get_sensor_info", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.mobifall.MobiFallLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.mobifall.MobiFallLoader.get_activity_info", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "MobiFallLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    List of activity types</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.mobifall.load_mobifall_data": {"fullname": "gaitsetpy.dataset.mobifall.load_mobifall_data", "modulename": "gaitsetpy.dataset.mobifall", "qualname": "load_mobifall_data", "kind": "function", "doc": "<p>Legacy function for loading MobiFall data.</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet": {"fullname": "gaitsetpy.dataset.physionet", "modulename": "gaitsetpy.dataset.physionet", "kind": "module", "doc": "<p>PhysioNet VGRF Dataset Loader.\nMaintainer: @aharshit123456</p>\n\n<p>This file contains the PhysioNet VGRF dataset loader class that inherits from BaseDatasetLoader.\nThe PhysioNet dataset contains vertical ground reaction force (VGRF) data from subjects with \nParkinson's disease and healthy controls.</p>\n\n<p>Dataset source: <a href=\"https://physionet.org/content/gaitpdb/1.0.0/\">https://physionet.org/content/gaitpdb/1.0.0/</a></p>\n"}, "gaitsetpy.dataset.physionet.PhysioNetLoader": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader", "kind": "class", "doc": "<p>PhysioNet VGRF dataset loader class.</p>\n\n<p>This class handles loading and processing of the PhysioNet Gait in Parkinson's Disease dataset.\nThe dataset contains vertical ground reaction force (VGRF) data from subjects with Parkinson's \ndisease and healthy controls.</p>\n\n<p>Features concurrent downloading for efficient data retrieval.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.__init__": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.__init__", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.__init__", "kind": "function", "doc": "<p>Initialize PhysioNet loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.metadata": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.metadata", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.labels": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.labels", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.labels", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.subject_types": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.subject_types", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.subject_types", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.load_data": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.load_data", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.load_data", "kind": "function", "doc": "<p>Load PhysioNet VGRF dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory to store/find the dataset\n    **kwargs: Additional arguments (unused for PhysioNet)</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the PhysioNet dataset.</p>\n\n<p>Args:\n    data: List of DataFrames containing PhysioNet data\n    names: List of names corresponding to the data\n    window_size: Size of the sliding window (default: 600 for 6 seconds at 100Hz)\n    step_size: Step size for the sliding window (default: 100)</p>\n\n<p>Returns:\n    List of dictionaries containing sliding windows for each DataFrame</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">600</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.get_supported_formats", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for PhysioNet dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.get_sensor_info", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_subject_info": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.get_subject_info", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.get_subject_info", "kind": "function", "doc": "<p>Get information about subjects in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing subject information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_labels": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.get_labels", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.get_labels", "kind": "function", "doc": "<p>Get labels for loaded data.</p>\n\n<p>Returns:\n    List of labels corresponding to loaded data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.PhysioNetLoader.filter_by_subject_type": {"fullname": "gaitsetpy.dataset.physionet.PhysioNetLoader.filter_by_subject_type", "modulename": "gaitsetpy.dataset.physionet", "qualname": "PhysioNetLoader.filter_by_subject_type", "kind": "function", "doc": "<p>Filter loaded data by subject type.</p>\n\n<p>Args:\n    subject_type: 'Control' or 'Patient'</p>\n\n<p>Returns:\n    Tuple of (filtered_data, filtered_names)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">subject_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.load_physionet_data": {"fullname": "gaitsetpy.dataset.physionet.load_physionet_data", "modulename": "gaitsetpy.dataset.physionet", "qualname": "load_physionet_data", "kind": "function", "doc": "<p>Legacy function to load PhysioNet data.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.physionet.create_physionet_windows": {"fullname": "gaitsetpy.dataset.physionet.create_physionet_windows", "modulename": "gaitsetpy.dataset.physionet", "qualname": "create_physionet_windows", "kind": "function", "doc": "<p>Legacy function to create sliding windows from PhysioNet data.</p>\n\n<p>Args:\n    data: List of DataFrames\n    names: List of names\n    window_size: Size of sliding window\n    step_size: Step size for sliding window</p>\n\n<p>Returns:\n    List of sliding window dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">600</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall": {"fullname": "gaitsetpy.dataset.urfall", "modulename": "gaitsetpy.dataset.urfall", "kind": "module", "doc": "<p>UrFall Dataset Loader and Utils.\nMaintainer: @aharshit123456</p>\n\n<p>This file contains the UrFall dataset loader class that inherits from BaseDatasetLoader.\nUrFall is a fall detection dataset with multimodal data including depth, RGB, accelerometer,\nand pre-extracted features from depth maps.</p>\n\n<p>Reference:</p>\n\n<ul>\n<li>Website: <a href=\"https://fenix.ur.edu.pl/~mkepski/ds/uf.html\">https://fenix.ur.edu.pl/~mkepski/ds/uf.html</a></li>\n<li>Dataset: University of Rzeszow Fall Detection Dataset</li>\n</ul>\n"}, "gaitsetpy.dataset.urfall.UrFallLoader": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader", "kind": "class", "doc": "<p>UrFall dataset loader class.</p>\n\n<p>This class handles loading and processing of the UrFall dataset for fall detection.\nSupports multiple data types: Depth, RGB, Accelerometer, Synchronization, Video,\nand pre-extracted features from depth maps.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseDatasetLoader"}, "gaitsetpy.dataset.urfall.UrFallLoader.__init__": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.__init__", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.__init__", "kind": "function", "doc": "<p>Initialize UrFall loader with concurrent download support.</p>\n\n<p>Args:\n    max_workers: Maximum number of concurrent download threads (default: 8)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span>)</span>"}, "gaitsetpy.dataset.urfall.UrFallLoader.metadata": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.metadata", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.metadata", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.dataset.urfall.UrFallLoader.load_data": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.load_data", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.load_data", "kind": "function", "doc": "<p>Load UrFall dataset from the specified directory.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    data_types: List of data types to load. Options: 'depth', 'rgb', 'accelerometer',\n               'synchronization', 'video', 'features' (default: ['features'])\n    sequences: List of specific sequences to load (e.g., ['fall-01', 'adl-01'])\n              If None, loads all based on use_falls and use_adls\n    use_falls: Whether to load fall sequences (default: True)\n    use_adls: Whether to load ADL (Activities of Daily Living) sequences (default: True)\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_types</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sequences</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">use_falls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_adls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.UrFallLoader.get_file_paths": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.get_file_paths", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.get_file_paths", "kind": "function", "doc": "<p>Get file paths for image/video data types (depth, RGB, video).</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    data_type: Type of data ('depth', 'rgb', 'video')\n    sequences: Specific sequences to get paths for\n    use_falls: Whether to include fall sequences\n    use_adls: Whether to include ADL sequences</p>\n\n<p>Returns:\n    Dictionary mapping sequence names to file paths</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">sequences</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">use_falls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_adls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.UrFallLoader.create_sliding_windows": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.create_sliding_windows", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.create_sliding_windows", "kind": "function", "doc": "<p>Create sliding windows from the loaded data.</p>\n\n<p>Args:\n    data: List of DataFrames containing the dataset\n    names: List of names corresponding to each DataFrame\n    window_size: Size of the sliding window (default: 30 frames for depth features)\n    step_size: Step size for sliding window (default: 15 frames)</p>\n\n<p>Returns:\n    List of dictionaries containing windowed data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">30</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">15</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.UrFallLoader.get_supported_formats": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.get_supported_formats", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.get_supported_formats", "kind": "function", "doc": "<p>Get list of supported file formats for UrFall dataset.</p>\n\n<p>Returns:\n    List of supported file extensions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.UrFallLoader.get_sensor_info": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.get_sensor_info", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.get_sensor_info", "kind": "function", "doc": "<p>Get information about sensors in the dataset.</p>\n\n<p>Returns:\n    Dictionary containing sensor information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">&lt;</span><span class=\"n\">built</span><span class=\"o\">-</span><span class=\"ow\">in</span> <span class=\"n\">function</span> <span class=\"nb\">any</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.UrFallLoader.get_activity_info": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.get_activity_info", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.get_activity_info", "kind": "function", "doc": "<p>Get information about activities in the dataset.</p>\n\n<p>Returns:\n    Dictionary mapping activity IDs to labels</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.UrFallLoader.get_feature_info": {"fullname": "gaitsetpy.dataset.urfall.UrFallLoader.get_feature_info", "modulename": "gaitsetpy.dataset.urfall", "qualname": "UrFallLoader.get_feature_info", "kind": "function", "doc": "<p>Get information about pre-extracted features.</p>\n\n<p>Returns:\n    Dictionary mapping feature names to descriptions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.load_urfall_data": {"fullname": "gaitsetpy.dataset.urfall.load_urfall_data", "modulename": "gaitsetpy.dataset.urfall", "qualname": "load_urfall_data", "kind": "function", "doc": "<p>Load UrFall dataset using the legacy function interface.</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    data_types: List of data types to load\n    sequences: List of specific sequences to load\n    use_falls: Whether to load fall sequences\n    use_adls: Whether to load ADL sequences</p>\n\n<p>Returns:\n    Tuple of (data_list, names_list)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data_types</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sequences</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">use_falls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_adls</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.urfall.create_urfall_windows": {"fullname": "gaitsetpy.dataset.urfall.create_urfall_windows", "modulename": "gaitsetpy.dataset.urfall", "qualname": "create_urfall_windows", "kind": "function", "doc": "<p>Create sliding windows from UrFall data using the legacy function interface.</p>\n\n<p>Args:\n    urfall_data: List of DataFrames\n    urfall_names: List of names\n    window_size: Size of sliding window\n    step_size: Step size for sliding window</p>\n\n<p>Returns:\n    List of dictionaries containing windowed data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">urfall_data</span>, </span><span class=\"param\"><span class=\"n\">urfall_names</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">30</span>, </span><span class=\"param\"><span class=\"n\">step_size</span><span class=\"o\">=</span><span class=\"mi\">15</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils": {"fullname": "gaitsetpy.dataset.utils", "modulename": "gaitsetpy.dataset.utils", "kind": "module", "doc": "<p>This file contains the utility functions to download and extract the datasets.\n    Supported datasets:\n    - Daphnet</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.dataset.utils.download_dataset": {"fullname": "gaitsetpy.dataset.utils.download_dataset", "modulename": "gaitsetpy.dataset.utils", "qualname": "download_dataset", "kind": "function", "doc": "<p>Download the dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dataset_name</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.download_daphnet_data": {"fullname": "gaitsetpy.dataset.utils.download_daphnet_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "download_daphnet_data", "kind": "function", "doc": "<p>Download the Daphnet dataset.</p>\n\n<p>This function downloads the Daphnet Freezing of Gait dataset from the UCI Machine Learning Repository.\nIt shows a progress bar during download and handles various potential errors.\nIf the file already exists in the specified directory, it skips the download.</p>\n\n<p>Args:\n    data_dir (str): Directory where the dataset will be downloaded</p>\n\n<p>Returns:\n    str: Path to the downloaded file</p>\n\n<p>Raises:\n    ConnectionError: If unable to connect to the download URL\n    IOError: If unable to create or write to the download directory/file\n    Exception: For other unexpected errors during download</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.download_mobifall_data": {"fullname": "gaitsetpy.dataset.utils.download_mobifall_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "download_mobifall_data", "kind": "function", "doc": "<p>Download the MobiFall dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.download_arduous_data": {"fullname": "gaitsetpy.dataset.utils.download_arduous_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "download_arduous_data", "kind": "function", "doc": "<p>Download the Arduous dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.download_urfall_data": {"fullname": "gaitsetpy.dataset.utils.download_urfall_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "download_urfall_data", "kind": "function", "doc": "<p>Download the UrFall dataset files.</p>\n\n<p>Args:\n    data_dir: Directory where the dataset will be downloaded\n    sequences: List of specific sequences to download (e.g., ['fall-01', 'adl-01'])\n              If None, downloads based on use_falls and use_adls\n    data_types: List of data types to download. Options: 'depth', 'rgb', 'accelerometer',\n               'synchronization', 'video', 'features' (default: ['features'])\n    use_falls: Whether to download fall sequences (default: True)\n    use_adls: Whether to download ADL sequences (default: True)\n    max_workers: Max concurrent download workers (default: 8)</p>\n\n<p>Returns:\n    str: Path to the data directory</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data_dir</span>,</span><span class=\"param\">\t<span class=\"n\">sequences</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">data_types</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">use_falls</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_adls</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.extract_dataset": {"fullname": "gaitsetpy.dataset.utils.extract_dataset", "modulename": "gaitsetpy.dataset.utils", "qualname": "extract_dataset", "kind": "function", "doc": "<p>Extract the dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dataset_name</span>, </span><span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.extract_daphnet_data": {"fullname": "gaitsetpy.dataset.utils.extract_daphnet_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "extract_daphnet_data", "kind": "function", "doc": "<p>Extract the Daphnet dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.extract_mobifall_data": {"fullname": "gaitsetpy.dataset.utils.extract_mobifall_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "extract_mobifall_data", "kind": "function", "doc": "<p>Extract the MobiFall dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.extract_arduous_data": {"fullname": "gaitsetpy.dataset.utils.extract_arduous_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "extract_arduous_data", "kind": "function", "doc": "<p>Extract the Arduous dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.extract_urfall_data": {"fullname": "gaitsetpy.dataset.utils.extract_urfall_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "extract_urfall_data", "kind": "function", "doc": "<p>Extract the UrFall dataset zip files (depth and RGB data).</p>\n\n<p>Args:\n    data_dir: Directory containing the dataset\n    sequences: List of specific sequences to extract\n    use_falls: Whether to extract fall sequences\n    use_adls: Whether to extract ADL sequences</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span>, </span><span class=\"param\"><span class=\"n\">sequences</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">use_falls</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">use_adls</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.sliding_window": {"fullname": "gaitsetpy.dataset.utils.sliding_window", "modulename": "gaitsetpy.dataset.utils", "qualname": "sliding_window", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">window_size</span>, </span><span class=\"param\"><span class=\"n\">step_size</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.download_harup_data": {"fullname": "gaitsetpy.dataset.utils.download_harup_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "download_harup_data", "kind": "function", "doc": "<p>Download the HAR-UP dataset.</p>\n\n<p>This function provides instructions for downloading the HAR-UP dataset and offers\nan option to download it directly from Google Drive as a ZIP file.</p>\n\n<p>Args:\n    data_dir (str): Directory where the dataset will be downloaded</p>\n\n<p>Returns:\n    str: Path to the extracted dataset directory or None if not performed</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.dataset.utils.extract_harup_data": {"fullname": "gaitsetpy.dataset.utils.extract_harup_data", "modulename": "gaitsetpy.dataset.utils", "qualname": "extract_harup_data", "kind": "function", "doc": "<p>Extract the HAR-UP dataset zip file if not already extracted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_dir</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda": {"fullname": "gaitsetpy.eda", "modulename": "gaitsetpy.eda", "kind": "module", "doc": "<p>eda: Provides exploratory data analysis tools for gait datasets.</p>\n\n<p>This module provides both the new class-based EDA analyzers and legacy function-based API.\nAll EDA analyzers inherit from BaseEDAAnalyzer and are registered with the EDAManager.</p>\n\n<p>Features:</p>\n\n<ul>\n<li>Comprehensive visualization of sensor data (thigh, shank, trunk)</li>\n<li>Statistical analysis and summaries</li>\n<li>Feature visualization and overlay</li>\n<li>Dataset comparison and analysis</li>\n</ul>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer": {"fullname": "gaitsetpy.eda.DaphnetVisualizationAnalyzer", "modulename": "gaitsetpy.eda", "qualname": "DaphnetVisualizationAnalyzer", "kind": "class", "doc": "<p>EDA analyzer for Daphnet dataset visualization.</p>\n\n<p>This analyzer provides comprehensive visualization capabilities for Daphnet dataset\nincluding thigh, shank, and trunk sensor data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseEDAAnalyzer"}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.__init__": {"fullname": "gaitsetpy.eda.DaphnetVisualizationAnalyzer.__init__", "modulename": "gaitsetpy.eda", "qualname": "DaphnetVisualizationAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.config": {"fullname": "gaitsetpy.eda.DaphnetVisualizationAnalyzer.config", "modulename": "gaitsetpy.eda", "qualname": "DaphnetVisualizationAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.analyze": {"fullname": "gaitsetpy.eda.DaphnetVisualizationAnalyzer.analyze", "modulename": "gaitsetpy.eda", "qualname": "DaphnetVisualizationAnalyzer.analyze", "kind": "function", "doc": "<p>Analyze the data and return statistical summaries.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.visualize": {"fullname": "gaitsetpy.eda.DaphnetVisualizationAnalyzer.visualize", "modulename": "gaitsetpy.eda", "qualname": "DaphnetVisualizationAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of the data.</p>\n\n<p>Args:\n    data: Input data to visualize\n    **kwargs: Additional arguments including sensor_type, dataset_index, names</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.SensorStatisticsAnalyzer": {"fullname": "gaitsetpy.eda.SensorStatisticsAnalyzer", "modulename": "gaitsetpy.eda", "qualname": "SensorStatisticsAnalyzer", "kind": "class", "doc": "<p>EDA analyzer for sensor data statistics and feature visualization.</p>\n\n<p>This analyzer provides statistical analysis and feature visualization capabilities\nfor sensor data including sliding windows and extracted features.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseEDAAnalyzer"}, "gaitsetpy.eda.SensorStatisticsAnalyzer.__init__": {"fullname": "gaitsetpy.eda.SensorStatisticsAnalyzer.__init__", "modulename": "gaitsetpy.eda", "qualname": "SensorStatisticsAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.eda.SensorStatisticsAnalyzer.config": {"fullname": "gaitsetpy.eda.SensorStatisticsAnalyzer.config", "modulename": "gaitsetpy.eda", "qualname": "SensorStatisticsAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.eda.SensorStatisticsAnalyzer.analyze": {"fullname": "gaitsetpy.eda.SensorStatisticsAnalyzer.analyze", "modulename": "gaitsetpy.eda", "qualname": "SensorStatisticsAnalyzer.analyze", "kind": "function", "doc": "<p>Analyze sensor data and return statistical summaries.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.eda.SensorStatisticsAnalyzer.visualize": {"fullname": "gaitsetpy.eda.SensorStatisticsAnalyzer.visualize", "modulename": "gaitsetpy.eda", "qualname": "SensorStatisticsAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of sensor data with overlaid features.</p>\n\n<p>Args:\n    sliding_windows: List of sliding window dictionaries\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including sensor_name, start_idx, end_idx, num_windows</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sliding_windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_thigh_data": {"fullname": "gaitsetpy.eda.plot_thigh_data", "modulename": "gaitsetpy.eda", "qualname": "plot_thigh_data", "kind": "function", "doc": "<p>Plot thigh acceleration data for a specific dataset.\nArgs:\n    daphnetThigh (list): List of DataFrames containing thigh acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_shank_data": {"fullname": "gaitsetpy.eda.plot_shank_data", "modulename": "gaitsetpy.eda", "qualname": "plot_shank_data", "kind": "function", "doc": "<p>Plot shank acceleration data for a specific dataset.\nArgs:\n    daphnetShank (list): List of DataFrames containing shank acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_trunk_data": {"fullname": "gaitsetpy.eda.plot_trunk_data", "modulename": "gaitsetpy.eda", "qualname": "plot_trunk_data", "kind": "function", "doc": "<p>Plot trunk acceleration data for a specific dataset.\nArgs:\n    daphnetTrunk (list): List of DataFrames containing trunk acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_all_data": {"fullname": "gaitsetpy.eda.plot_all_data", "modulename": "gaitsetpy.eda", "qualname": "plot_all_data", "kind": "function", "doc": "<p>Plot thigh, shank, and trunk acceleration data for a specific dataset.\nArgs:\n    daphnetThigh (list): List of DataFrames containing thigh acceleration data.\n    daphnetShank (list): List of DataFrames containing shank acceleration data.\n    daphnetTrunk (list): List of DataFrames containing trunk acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_all_thigh_data": {"fullname": "gaitsetpy.eda.plot_all_thigh_data", "modulename": "gaitsetpy.eda", "qualname": "plot_all_thigh_data", "kind": "function", "doc": "<p>Plot thigh acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_all_shank_data": {"fullname": "gaitsetpy.eda.plot_all_shank_data", "modulename": "gaitsetpy.eda", "qualname": "plot_all_shank_data", "kind": "function", "doc": "<p>Plot shank acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_all_trunk_data": {"fullname": "gaitsetpy.eda.plot_all_trunk_data", "modulename": "gaitsetpy.eda", "qualname": "plot_all_trunk_data", "kind": "function", "doc": "<p>Plot trunk acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_all_datasets": {"fullname": "gaitsetpy.eda.plot_all_datasets", "modulename": "gaitsetpy.eda", "qualname": "plot_all_datasets", "kind": "function", "doc": "<p>Plot thigh, shank, and trunk acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_sensor_with_features": {"fullname": "gaitsetpy.eda.plot_sensor_with_features", "modulename": "gaitsetpy.eda", "qualname": "plot_sensor_with_features", "kind": "function", "doc": "<p>@brief Plots sliding windows of a sensor's time series data with overlaid statistical features.</p>\n\n<p>This function plots the first <code>num_windows</code> sliding windows within the given <code>start_idx</code> and <code>end_idx</code>\nfor a specified sensor and overlays feature values at their corresponding time indices. \nIt also displays entropy and dominant frequency in a separate plot.</p>\n\n<p>@param[in] sliding_windows List of dictionaries, where each dictionary contains:\n               - 'name': sensor name (str)\n               - 'data': List of time-series windows (each as a Pandas Series)\n@param[in] features List of dictionaries, where each dictionary contains:\n               - 'name': sensor name (str)\n               - 'features': Dictionary of extracted feature lists\n@param[in] start_idx Start index of the time window to be plotted.\n@param[in] end_idx End index of the time window to be plotted.\n@param[in] sensor_name Name of the sensor to be plotted (default: \"shank\").\n@param[in] num_windows Number of sliding windows to plot (default: 10).\n@param[in] save If True, saves the plot to a file instead of displaying it.</p>\n\n<p>@return None</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sliding_windows</span>,</span><span class=\"param\">\t<span class=\"n\">features</span>,</span><span class=\"param\">\t<span class=\"n\">start_idx</span>,</span><span class=\"param\">\t<span class=\"n\">end_idx</span>,</span><span class=\"param\">\t<span class=\"n\">sensor_name</span><span class=\"o\">=</span><span class=\"s1\">&#39;shank&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">num_windows</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">save</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.get_eda_manager": {"fullname": "gaitsetpy.eda.get_eda_manager", "modulename": "gaitsetpy.eda", "qualname": "get_eda_manager", "kind": "function", "doc": "<p>Get the singleton EDAManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.get_available_analyzers": {"fullname": "gaitsetpy.eda.get_available_analyzers", "modulename": "gaitsetpy.eda", "qualname": "get_available_analyzers", "kind": "function", "doc": "<p>Get list of available EDA analyzer names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyze_data": {"fullname": "gaitsetpy.eda.analyze_data", "modulename": "gaitsetpy.eda", "qualname": "analyze_data", "kind": "function", "doc": "<p>Analyze data using the EDAManager.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to analyze\n    **kwargs: Additional arguments for analysis</p>\n\n<p>Returns:\n    Analysis results dictionary</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualize_data": {"fullname": "gaitsetpy.eda.visualize_data", "modulename": "gaitsetpy.eda", "qualname": "visualize_data", "kind": "function", "doc": "<p>Create visualizations using the EDAManager.</p>\n\n<p>Args:\n    analyzer_name: Name of the EDA analyzer\n    data: Input data to visualize\n    **kwargs: Additional arguments for visualization</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">analyzer_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_daphnet_data": {"fullname": "gaitsetpy.eda.plot_daphnet_data", "modulename": "gaitsetpy.eda", "qualname": "plot_daphnet_data", "kind": "function", "doc": "<p>Plot Daphnet dataset using the DaphnetVisualizationAnalyzer.</p>\n\n<p>Args:\n    data: Input data (DataFrame or list of DataFrames)\n    names: List of dataset names\n    sensor_type: Type of sensor to plot ('all', 'thigh', 'shank', 'trunk')\n    dataset_index: Index of dataset to plot (if data is a list)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">names</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">sensor_type</span><span class=\"o\">=</span><span class=\"s1\">&#39;all&#39;</span>, </span><span class=\"param\"><span class=\"n\">dataset_index</span><span class=\"o\">=</span><span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyze_sensor_statistics": {"fullname": "gaitsetpy.eda.analyze_sensor_statistics", "modulename": "gaitsetpy.eda", "qualname": "analyze_sensor_statistics", "kind": "function", "doc": "<p>Analyze sensor statistics using the SensorStatisticsAnalyzer.</p>\n\n<p>Args:\n    data: Input data (DataFrame or list of DataFrames)</p>\n\n<p>Returns:\n    Dictionary containing statistical analysis results</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.plot_sensor_features": {"fullname": "gaitsetpy.eda.plot_sensor_features", "modulename": "gaitsetpy.eda", "qualname": "plot_sensor_features", "kind": "function", "doc": "<p>Plot sensor data with overlaid features using the SensorStatisticsAnalyzer.</p>\n\n<p>Args:\n    sliding_windows: List of sliding window dictionaries\n    features: List of feature dictionaries\n    sensor_name: Name of the sensor to plot\n    start_idx: Start index of the time window\n    end_idx: End index of the time window\n    num_windows: Number of sliding windows to plot</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sliding_windows</span>,</span><span class=\"param\">\t<span class=\"n\">features</span>,</span><span class=\"param\">\t<span class=\"n\">sensor_name</span><span class=\"o\">=</span><span class=\"s1\">&#39;shank&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">start_idx</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">end_idx</span><span class=\"o\">=</span><span class=\"mi\">1000</span>,</span><span class=\"param\">\t<span class=\"n\">num_windows</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyzers": {"fullname": "gaitsetpy.eda.analyzers", "modulename": "gaitsetpy.eda.analyzers", "kind": "module", "doc": "<p>EDA analyzer classes for gait data analysis.</p>\n\n<p>This module contains individual EDA analyzer classes that inherit from BaseEDAAnalyzer\nand provide specific analysis and visualization functionality.</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer": {"fullname": "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer", "modulename": "gaitsetpy.eda.analyzers", "qualname": "DaphnetVisualizationAnalyzer", "kind": "class", "doc": "<p>EDA analyzer for Daphnet dataset visualization.</p>\n\n<p>This analyzer provides comprehensive visualization capabilities for Daphnet dataset\nincluding thigh, shank, and trunk sensor data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseEDAAnalyzer"}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.__init__": {"fullname": "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.__init__", "modulename": "gaitsetpy.eda.analyzers", "qualname": "DaphnetVisualizationAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.config": {"fullname": "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.config", "modulename": "gaitsetpy.eda.analyzers", "qualname": "DaphnetVisualizationAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.analyze": {"fullname": "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.analyze", "modulename": "gaitsetpy.eda.analyzers", "qualname": "DaphnetVisualizationAnalyzer.analyze", "kind": "function", "doc": "<p>Analyze the data and return statistical summaries.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.visualize": {"fullname": "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.visualize", "modulename": "gaitsetpy.eda.analyzers", "qualname": "DaphnetVisualizationAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of the data.</p>\n\n<p>Args:\n    data: Input data to visualize\n    **kwargs: Additional arguments including sensor_type, dataset_index, names</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer": {"fullname": "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer", "modulename": "gaitsetpy.eda.analyzers", "qualname": "SensorStatisticsAnalyzer", "kind": "class", "doc": "<p>EDA analyzer for sensor data statistics and feature visualization.</p>\n\n<p>This analyzer provides statistical analysis and feature visualization capabilities\nfor sensor data including sliding windows and extracted features.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseEDAAnalyzer"}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.__init__": {"fullname": "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.__init__", "modulename": "gaitsetpy.eda.analyzers", "qualname": "SensorStatisticsAnalyzer.__init__", "kind": "function", "doc": "<p>Initialize the EDA analyzer.</p>\n\n<p>Args:\n    name: Name of the EDA analyzer\n    description: Description of the EDA analyzer</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.config": {"fullname": "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.config", "modulename": "gaitsetpy.eda.analyzers", "qualname": "SensorStatisticsAnalyzer.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.analyze": {"fullname": "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.analyze", "modulename": "gaitsetpy.eda.analyzers", "qualname": "SensorStatisticsAnalyzer.analyze", "kind": "function", "doc": "<p>Analyze sensor data and return statistical summaries.</p>\n\n<p>Args:\n    data: Input data to analyze\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Dictionary containing analysis results</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.visualize": {"fullname": "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.visualize", "modulename": "gaitsetpy.eda.analyzers", "qualname": "SensorStatisticsAnalyzer.visualize", "kind": "function", "doc": "<p>Create visualizations of sensor data with overlaid features.</p>\n\n<p>Args:\n    sliding_windows: List of sliding window dictionaries\n    features: List of feature dictionaries\n    **kwargs: Additional arguments including sensor_name, start_idx, end_idx, num_windows</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sliding_windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyzers.harup_basic_stats": {"fullname": "gaitsetpy.eda.analyzers.harup_basic_stats", "modulename": "gaitsetpy.eda.analyzers", "qualname": "harup_basic_stats", "kind": "function", "doc": "<p>Print and return basic statistics for each sensor column in a HAR-UP DataFrame.\nArgs:\n    harup_df (pd.DataFrame): DataFrame containing HAR-UP data.\nReturns:\n    pd.DataFrame: DataFrame of statistics.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_df</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyzers.harup_missing_data_report": {"fullname": "gaitsetpy.eda.analyzers.harup_missing_data_report", "modulename": "gaitsetpy.eda.analyzers", "qualname": "harup_missing_data_report", "kind": "function", "doc": "<p>Print and return missing value counts for each column in a HAR-UP DataFrame.\nArgs:\n    harup_df (pd.DataFrame): DataFrame containing HAR-UP data.\nReturns:\n    pd.Series: Series of missing value counts.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_df</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.analyzers.harup_activity_stats": {"fullname": "gaitsetpy.eda.analyzers.harup_activity_stats", "modulename": "gaitsetpy.eda.analyzers", "qualname": "harup_activity_stats", "kind": "function", "doc": "<p>Print and return counts for each activity label in a HAR-UP DataFrame.\nArgs:\n    harup_df (pd.DataFrame): DataFrame containing HAR-UP data.\nReturns:\n    pd.Series: Series of activity label counts.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_df</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.statistics": {"fullname": "gaitsetpy.eda.statistics", "modulename": "gaitsetpy.eda.statistics", "kind": "module", "doc": "<p>This module contains functions for statistical analysis of sensor data.</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.eda.statistics.plot_sensor_with_features": {"fullname": "gaitsetpy.eda.statistics.plot_sensor_with_features", "modulename": "gaitsetpy.eda.statistics", "qualname": "plot_sensor_with_features", "kind": "function", "doc": "<p>@brief Plots sliding windows of a sensor's time series data with overlaid statistical features.</p>\n\n<p>This function plots the first <code>num_windows</code> sliding windows within the given <code>start_idx</code> and <code>end_idx</code>\nfor a specified sensor and overlays feature values at their corresponding time indices. \nIt also displays entropy and dominant frequency in a separate plot.</p>\n\n<p>@param[in] sliding_windows List of dictionaries, where each dictionary contains:\n               - 'name': sensor name (str)\n               - 'data': List of time-series windows (each as a Pandas Series)\n@param[in] features List of dictionaries, where each dictionary contains:\n               - 'name': sensor name (str)\n               - 'features': Dictionary of extracted feature lists\n@param[in] start_idx Start index of the time window to be plotted.\n@param[in] end_idx End index of the time window to be plotted.\n@param[in] sensor_name Name of the sensor to be plotted (default: \"shank\").\n@param[in] num_windows Number of sliding windows to plot (default: 10).\n@param[in] save If True, saves the plot to a file instead of displaying it.</p>\n\n<p>@return None</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sliding_windows</span>,</span><span class=\"param\">\t<span class=\"n\">features</span>,</span><span class=\"param\">\t<span class=\"n\">start_idx</span>,</span><span class=\"param\">\t<span class=\"n\">end_idx</span>,</span><span class=\"param\">\t<span class=\"n\">sensor_name</span><span class=\"o\">=</span><span class=\"s1\">&#39;shank&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">num_windows</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">save</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization": {"fullname": "gaitsetpy.eda.visualization", "modulename": "gaitsetpy.eda.visualization", "kind": "module", "doc": "<p>This module contains functions for visualizing the thigh, shank, and trunk acceleration data from the Daphnet dataset.\nMaintainer : @aharshit123456</p>\n\n<p>TODO : </p>\n\n<ul>\n<li>Make the thigh, shank, trunk dataframe parent child extraction functions</li>\n</ul>\n"}, "gaitsetpy.eda.visualization.plot_thigh_data": {"fullname": "gaitsetpy.eda.visualization.plot_thigh_data", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_thigh_data", "kind": "function", "doc": "<p>Plot thigh acceleration data for a specific dataset.\nArgs:\n    daphnetThigh (list): List of DataFrames containing thigh acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_shank_data": {"fullname": "gaitsetpy.eda.visualization.plot_shank_data", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_shank_data", "kind": "function", "doc": "<p>Plot shank acceleration data for a specific dataset.\nArgs:\n    daphnetShank (list): List of DataFrames containing shank acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_trunk_data": {"fullname": "gaitsetpy.eda.visualization.plot_trunk_data", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_trunk_data", "kind": "function", "doc": "<p>Plot trunk acceleration data for a specific dataset.\nArgs:\n    daphnetTrunk (list): List of DataFrames containing trunk acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_all_thigh_data": {"fullname": "gaitsetpy.eda.visualization.plot_all_thigh_data", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_all_thigh_data", "kind": "function", "doc": "<p>Plot thigh acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_all_shank_data": {"fullname": "gaitsetpy.eda.visualization.plot_all_shank_data", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_all_shank_data", "kind": "function", "doc": "<p>Plot shank acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_all_trunk_data": {"fullname": "gaitsetpy.eda.visualization.plot_all_trunk_data", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_all_trunk_data", "kind": "function", "doc": "<p>Plot trunk acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_all_data": {"fullname": "gaitsetpy.eda.visualization.plot_all_data", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_all_data", "kind": "function", "doc": "<p>Plot thigh, shank, and trunk acceleration data for a specific dataset.\nArgs:\n    daphnetThigh (list): List of DataFrames containing thigh acceleration data.\n    daphnetShank (list): List of DataFrames containing shank acceleration data.\n    daphnetTrunk (list): List of DataFrames containing trunk acceleration data.\n    daphnetNames (list): List of dataset names.\n    i (int): Index of the dataset to plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span>, </span><span class=\"param\"><span class=\"n\">i</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_all_datasets": {"fullname": "gaitsetpy.eda.visualization.plot_all_datasets", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_all_datasets", "kind": "function", "doc": "<p>Plot thigh, shank, and trunk acceleration data for all datasets.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">daphnetThigh</span>, </span><span class=\"param\"><span class=\"n\">daphnetShank</span>, </span><span class=\"param\"><span class=\"n\">daphnetTrunk</span>, </span><span class=\"param\"><span class=\"n\">daphnetNames</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_sensor_timeseries": {"fullname": "gaitsetpy.eda.visualization.plot_sensor_timeseries", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_sensor_timeseries", "kind": "function", "doc": "<p>Plot the time series for a given sensor column in a HAR-UP DataFrame.\nArgs:\n    harup_df (pd.DataFrame): DataFrame containing HAR-UP data.\n    sensor_col (str): Name of the sensor column to plot.\n    title (str, optional): Plot title.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_df</span>, </span><span class=\"param\"><span class=\"n\">sensor_col</span>, </span><span class=\"param\"><span class=\"n\">title</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_all_sensors": {"fullname": "gaitsetpy.eda.visualization.plot_all_sensors", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_all_sensors", "kind": "function", "doc": "<p>Plot all (or selected) sensor time series for a HAR-UP DataFrame.\nArgs:\n    harup_df (pd.DataFrame): DataFrame containing HAR-UP data.\n    sensor_cols (list, optional): List of sensor columns to plot. If None, plot all numeric columns except metadata.\n    max_cols (int): Number of subplots per row.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_df</span>, </span><span class=\"param\"><span class=\"n\">sensor_cols</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">max_cols</span><span class=\"o\">=</span><span class=\"mi\">4</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.eda.visualization.plot_activity_distribution": {"fullname": "gaitsetpy.eda.visualization.plot_activity_distribution", "modulename": "gaitsetpy.eda.visualization", "qualname": "plot_activity_distribution", "kind": "function", "doc": "<p>Plot a bar chart of activity label distribution in a HAR-UP DataFrame.\nArgs:\n    harup_df (pd.DataFrame): DataFrame containing HAR-UP data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">harup_df</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features": {"fullname": "gaitsetpy.features", "modulename": "gaitsetpy.features", "kind": "module", "doc": "<p>Features module for gait analysis and feature extraction.</p>\n\n<p>This module provides both the new class-based feature extractors and legacy function-based API.\nAll feature extractors inherit from BaseFeatureExtractor and are registered with the FeatureManager.</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.features.GaitFeatureExtractor": {"fullname": "gaitsetpy.features.GaitFeatureExtractor", "modulename": "gaitsetpy.features", "qualname": "GaitFeatureExtractor", "kind": "class", "doc": "<p>Comprehensive gait feature extractor class.</p>\n\n<p>This class extracts various time-domain, frequency-domain, and statistical features\nfrom gait data sliding windows.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.GaitFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.GaitFeatureExtractor.__init__", "modulename": "gaitsetpy.features", "qualname": "GaitFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.GaitFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.GaitFeatureExtractor.verbose", "modulename": "gaitsetpy.features", "qualname": "GaitFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.GaitFeatureExtractor.config": {"fullname": "gaitsetpy.features.GaitFeatureExtractor.config", "modulename": "gaitsetpy.features", "qualname": "GaitFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.GaitFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.GaitFeatureExtractor.extract_features", "modulename": "gaitsetpy.features", "qualname": "GaitFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract gait features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments including time_domain, frequency_domain, statistical flags</p>\n\n<p>Returns:\n    List of feature dictionaries for each sensor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.GaitFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.GaitFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features", "qualname": "GaitFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of all features that can be extracted.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.GaitFeatureExtractor.print_extraction_summary": {"fullname": "gaitsetpy.features.GaitFeatureExtractor.print_extraction_summary", "modulename": "gaitsetpy.features", "qualname": "GaitFeatureExtractor.print_extraction_summary", "kind": "function", "doc": "<p>Print a detailed summary of extracted features.</p>\n\n<p>Args:\n    features: List of feature dictionaries returned by extract_features</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.LBPFeatureExtractor": {"fullname": "gaitsetpy.features.LBPFeatureExtractor", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor", "kind": "class", "doc": "<p>Local Binary Pattern (LBP) feature extractor for VGRF data.</p>\n\n<p>This extractor converts time-series data into LBP codes and extracts\nhistogram features from the LBP representation.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.LBPFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.LBPFeatureExtractor.__init__", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.LBPFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.LBPFeatureExtractor.verbose", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.LBPFeatureExtractor.config": {"fullname": "gaitsetpy.features.LBPFeatureExtractor.config", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.LBPFeatureExtractor.lbp_1d": {"fullname": "gaitsetpy.features.LBPFeatureExtractor.lbp_1d", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor.lbp_1d", "kind": "function", "doc": "<p>Compute 1D Local Binary Pattern for time-series data.</p>\n\n<p>Args:\n    data: Input time-series data\n    radius: Radius for LBP computation</p>\n\n<p>Returns:\n    LBP code as binary string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>, </span><span class=\"param\"><span class=\"n\">radius</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.LBPFeatureExtractor.lbp_to_histogram": {"fullname": "gaitsetpy.features.LBPFeatureExtractor.lbp_to_histogram", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor.lbp_to_histogram", "kind": "function", "doc": "<p>Convert LBP code to histogram features.</p>\n\n<p>Args:\n    lbp_code: Binary LBP code string\n    n_bins: Number of histogram bins\n    normalize: Whether to normalize histogram</p>\n\n<p>Returns:\n    Histogram features as numpy array</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lbp_code</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">n_bins</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">256</span>,</span><span class=\"param\">\t<span class=\"n\">normalize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.LBPFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.LBPFeatureExtractor.extract_features", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract LBP features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency (unused for LBP)\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.LBPFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.LBPFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features", "qualname": "LBPFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of LBP features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.FourierSeriesFeatureExtractor": {"fullname": "gaitsetpy.features.FourierSeriesFeatureExtractor", "modulename": "gaitsetpy.features", "qualname": "FourierSeriesFeatureExtractor", "kind": "class", "doc": "<p>Fourier Series feature extractor for VGRF data.</p>\n\n<p>This extractor fits Fourier series to time-series data and extracts\ncoefficients and reconstruction features.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.FourierSeriesFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.FourierSeriesFeatureExtractor.__init__", "modulename": "gaitsetpy.features", "qualname": "FourierSeriesFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.FourierSeriesFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.FourierSeriesFeatureExtractor.verbose", "modulename": "gaitsetpy.features", "qualname": "FourierSeriesFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.FourierSeriesFeatureExtractor.config": {"fullname": "gaitsetpy.features.FourierSeriesFeatureExtractor.config", "modulename": "gaitsetpy.features", "qualname": "FourierSeriesFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.FourierSeriesFeatureExtractor.fit_fourier_series": {"fullname": "gaitsetpy.features.FourierSeriesFeatureExtractor.fit_fourier_series", "modulename": "gaitsetpy.features", "qualname": "FourierSeriesFeatureExtractor.fit_fourier_series", "kind": "function", "doc": "<p>Fit Fourier series to signal.</p>\n\n<p>Args:\n    signal: Input signal\n    time_points: Time points\n    period: Period of the Fourier series\n    n_terms: Number of Fourier terms</p>\n\n<p>Returns:\n    Dictionary containing Fourier series parameters</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">signal</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">time_points</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">period</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">3.0</span>,</span><span class=\"param\">\t<span class=\"n\">n_terms</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.FourierSeriesFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.FourierSeriesFeatureExtractor.extract_features", "modulename": "gaitsetpy.features", "qualname": "FourierSeriesFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract Fourier series features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.FourierSeriesFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.FourierSeriesFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features", "qualname": "FourierSeriesFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of Fourier series features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.PhysioNetFeatureExtractor": {"fullname": "gaitsetpy.features.PhysioNetFeatureExtractor", "modulename": "gaitsetpy.features", "qualname": "PhysioNetFeatureExtractor", "kind": "class", "doc": "<p>Combined feature extractor for PhysioNet VGRF data.</p>\n\n<p>This extractor combines LBP and Fourier series features along with\nbasic statistical features specific to VGRF data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.PhysioNetFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.PhysioNetFeatureExtractor.__init__", "modulename": "gaitsetpy.features", "qualname": "PhysioNetFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.PhysioNetFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.PhysioNetFeatureExtractor.verbose", "modulename": "gaitsetpy.features", "qualname": "PhysioNetFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.PhysioNetFeatureExtractor.lbp_extractor": {"fullname": "gaitsetpy.features.PhysioNetFeatureExtractor.lbp_extractor", "modulename": "gaitsetpy.features", "qualname": "PhysioNetFeatureExtractor.lbp_extractor", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.PhysioNetFeatureExtractor.fourier_extractor": {"fullname": "gaitsetpy.features.PhysioNetFeatureExtractor.fourier_extractor", "modulename": "gaitsetpy.features", "qualname": "PhysioNetFeatureExtractor.fourier_extractor", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.PhysioNetFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.PhysioNetFeatureExtractor.extract_features", "modulename": "gaitsetpy.features", "qualname": "PhysioNetFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract combined features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.PhysioNetFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.PhysioNetFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features", "qualname": "PhysioNetFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of all features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.HARUPFeatureExtractor": {"fullname": "gaitsetpy.features.HARUPFeatureExtractor", "modulename": "gaitsetpy.features", "qualname": "HARUPFeatureExtractor", "kind": "class", "doc": "<p>HAR-UP feature extractor class.</p>\n\n<p>This class implements the feature extraction methods used in the HAR-UP project.\nIt extracts both time-domain and frequency-domain features from sensor data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.HARUPFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.HARUPFeatureExtractor.__init__", "modulename": "gaitsetpy.features", "qualname": "HARUPFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the HAR-UP feature extractor.</p>\n\n<p>Args:\n    verbose: Whether to print progress information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "gaitsetpy.features.HARUPFeatureExtractor.config": {"fullname": "gaitsetpy.features.HARUPFeatureExtractor.config", "modulename": "gaitsetpy.features", "qualname": "HARUPFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.HARUPFeatureExtractor.time_domain_features": {"fullname": "gaitsetpy.features.HARUPFeatureExtractor.time_domain_features", "modulename": "gaitsetpy.features", "qualname": "HARUPFeatureExtractor.time_domain_features", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.HARUPFeatureExtractor.freq_domain_features": {"fullname": "gaitsetpy.features.HARUPFeatureExtractor.freq_domain_features", "modulename": "gaitsetpy.features", "qualname": "HARUPFeatureExtractor.freq_domain_features", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.HARUPFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.HARUPFeatureExtractor.extract_features", "modulename": "gaitsetpy.features", "qualname": "HARUPFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.HARUPFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.HARUPFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features", "qualname": "HARUPFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of features extracted by this extractor.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.UrFallMediaFeatureExtractor": {"fullname": "gaitsetpy.features.UrFallMediaFeatureExtractor", "modulename": "gaitsetpy.features", "qualname": "UrFallMediaFeatureExtractor", "kind": "class", "doc": "<p>UrFall image/video feature extractor.</p>\n\n<p>Extracts per-window features from sequences of images or decoded video frames:</p>\n\n<ul>\n<li>mean_intensity</li>\n<li>std_intensity</li>\n<li>motion_mean (if pairwise differences are available)</li>\n<li>motion_std</li>\n</ul>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.UrFallMediaFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.UrFallMediaFeatureExtractor.__init__", "modulename": "gaitsetpy.features", "qualname": "UrFallMediaFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "gaitsetpy.features.UrFallMediaFeatureExtractor.config": {"fullname": "gaitsetpy.features.UrFallMediaFeatureExtractor.config", "modulename": "gaitsetpy.features", "qualname": "UrFallMediaFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.UrFallMediaFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.UrFallMediaFeatureExtractor.extract_features", "modulename": "gaitsetpy.features", "qualname": "UrFallMediaFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.UrFallMediaFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.UrFallMediaFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features", "qualname": "UrFallMediaFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of features extracted by this extractor.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.extract_lbp_features": {"fullname": "gaitsetpy.features.extract_lbp_features", "modulename": "gaitsetpy.features", "qualname": "extract_lbp_features", "kind": "function", "doc": "<p>Legacy function to extract LBP features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.extract_fourier_features": {"fullname": "gaitsetpy.features.extract_fourier_features", "modulename": "gaitsetpy.features", "qualname": "extract_fourier_features", "kind": "function", "doc": "<p>Legacy function to extract Fourier series features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.extract_physionet_features": {"fullname": "gaitsetpy.features.extract_physionet_features", "modulename": "gaitsetpy.features", "qualname": "extract_physionet_features", "kind": "function", "doc": "<p>Legacy function to extract combined PhysioNet features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.extract_harup_features": {"fullname": "gaitsetpy.features.extract_harup_features", "modulename": "gaitsetpy.features", "qualname": "extract_harup_features", "kind": "function", "doc": "<p>Legacy function for extracting HAR-UP features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency (default: 100Hz)\n    time_domain: Whether to extract time domain features\n    freq_domain: Whether to extract frequency domain features\n    verbose: Whether to print progress information</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">time_domain</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">freq_domain</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_mean": {"fullname": "gaitsetpy.features.calculate_mean", "modulename": "gaitsetpy.features", "qualname": "calculate_mean", "kind": "function", "doc": "<p>Calculate the mean of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_standard_deviation": {"fullname": "gaitsetpy.features.calculate_standard_deviation", "modulename": "gaitsetpy.features", "qualname": "calculate_standard_deviation", "kind": "function", "doc": "<p>Calculate the standard deviation of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    std_dev (float): Standard deviation.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_variance": {"fullname": "gaitsetpy.features.calculate_variance", "modulename": "gaitsetpy.features", "qualname": "calculate_variance", "kind": "function", "doc": "<p>Calculate the variance of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    variance (float): Variance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_skewness": {"fullname": "gaitsetpy.features.calculate_skewness", "modulename": "gaitsetpy.features", "qualname": "calculate_skewness", "kind": "function", "doc": "<p>Calculate the skewness of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_kurtosis": {"fullname": "gaitsetpy.features.calculate_kurtosis", "modulename": "gaitsetpy.features", "qualname": "calculate_kurtosis", "kind": "function", "doc": "<p>Calculate the kurtosis of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    kurtosis_value (float): Kurtosis.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_root_mean_square": {"fullname": "gaitsetpy.features.calculate_root_mean_square", "modulename": "gaitsetpy.features", "qualname": "calculate_root_mean_square", "kind": "function", "doc": "<p>Calculate the root mean square of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_range": {"fullname": "gaitsetpy.features.calculate_range", "modulename": "gaitsetpy.features", "qualname": "calculate_range", "kind": "function", "doc": "<p>Calculate the range of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_median": {"fullname": "gaitsetpy.features.calculate_median", "modulename": "gaitsetpy.features", "qualname": "calculate_median", "kind": "function", "doc": "<p>Calculate the median of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_mode": {"fullname": "gaitsetpy.features.calculate_mode", "modulename": "gaitsetpy.features", "qualname": "calculate_mode", "kind": "function", "doc": "<p>Calculate the mode of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_mean_absolute_value": {"fullname": "gaitsetpy.features.calculate_mean_absolute_value", "modulename": "gaitsetpy.features", "qualname": "calculate_mean_absolute_value", "kind": "function", "doc": "<p>Calculate the mean absolute value of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_median_absolute_deviation": {"fullname": "gaitsetpy.features.calculate_median_absolute_deviation", "modulename": "gaitsetpy.features", "qualname": "calculate_median_absolute_deviation", "kind": "function", "doc": "<p>Calculate the median absolute deviation of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_peak_height": {"fullname": "gaitsetpy.features.calculate_peak_height", "modulename": "gaitsetpy.features", "qualname": "calculate_peak_height", "kind": "function", "doc": "<p>Calculate the peak height of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_stride_times": {"fullname": "gaitsetpy.features.calculate_stride_times", "modulename": "gaitsetpy.features", "qualname": "calculate_stride_times", "kind": "function", "doc": "<p>Calculate stride times from a signal using peak detection.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    avg_stride_time (float): Average stride time.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_step_time": {"fullname": "gaitsetpy.features.calculate_step_time", "modulename": "gaitsetpy.features", "qualname": "calculate_step_time", "kind": "function", "doc": "<p>Calculate step times from a signal using peak detection.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    step_times (np.array): Array of step times.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_cadence": {"fullname": "gaitsetpy.features.calculate_cadence", "modulename": "gaitsetpy.features", "qualname": "calculate_cadence", "kind": "function", "doc": "<p>Calculate the cadence (steps per minute) of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_freezing_index": {"fullname": "gaitsetpy.features.calculate_freezing_index", "modulename": "gaitsetpy.features", "qualname": "calculate_freezing_index", "kind": "function", "doc": "<p>Calculate the freezing index of a signal.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    freezing_index (float): Freezing index.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_dominant_frequency": {"fullname": "gaitsetpy.features.calculate_dominant_frequency", "modulename": "gaitsetpy.features", "qualname": "calculate_dominant_frequency", "kind": "function", "doc": "<p>Calculate the dominant frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_peak_frequency": {"fullname": "gaitsetpy.features.calculate_peak_frequency", "modulename": "gaitsetpy.features", "qualname": "calculate_peak_frequency", "kind": "function", "doc": "<p>Calculate the peak frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_power_spectral_entropy": {"fullname": "gaitsetpy.features.calculate_power_spectral_entropy", "modulename": "gaitsetpy.features", "qualname": "calculate_power_spectral_entropy", "kind": "function", "doc": "<p>Calculate the power spectral entropy of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_principal_harmonic_frequency": {"fullname": "gaitsetpy.features.calculate_principal_harmonic_frequency", "modulename": "gaitsetpy.features", "qualname": "calculate_principal_harmonic_frequency", "kind": "function", "doc": "<p>Calculate the principal harmonic frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_entropy": {"fullname": "gaitsetpy.features.calculate_entropy", "modulename": "gaitsetpy.features", "qualname": "calculate_entropy", "kind": "function", "doc": "<p>Calculate the entropy of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    entropy_value (float): Entropy.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_interquartile_range": {"fullname": "gaitsetpy.features.calculate_interquartile_range", "modulename": "gaitsetpy.features", "qualname": "calculate_interquartile_range", "kind": "function", "doc": "<p>Calculate the interquartile range of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_correlation": {"fullname": "gaitsetpy.features.calculate_correlation", "modulename": "gaitsetpy.features", "qualname": "calculate_correlation", "kind": "function", "doc": "<p>Calculate the correlation between two signals.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal1</span>, </span><span class=\"param\"><span class=\"n\">signal2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.calculate_auto_regression_coefficients": {"fullname": "gaitsetpy.features.calculate_auto_regression_coefficients", "modulename": "gaitsetpy.features", "qualname": "calculate_auto_regression_coefficients", "kind": "function", "doc": "<p>Calculate the auto-regression coefficients of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_mean_for_windows": {"fullname": "gaitsetpy.features.get_mean_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_mean_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_standard_deviation_for_windows": {"fullname": "gaitsetpy.features.get_standard_deviation_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_standard_deviation_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_variance_for_windows": {"fullname": "gaitsetpy.features.get_variance_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_variance_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_skewness_for_windows": {"fullname": "gaitsetpy.features.get_skewness_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_skewness_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_kurtosis_for_windows": {"fullname": "gaitsetpy.features.get_kurtosis_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_kurtosis_for_windows", "kind": "function", "doc": "<p>Calculate kurtosis values for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_root_mean_square_for_windows": {"fullname": "gaitsetpy.features.get_root_mean_square_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_root_mean_square_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_range_for_windows": {"fullname": "gaitsetpy.features.get_range_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_range_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_median_for_windows": {"fullname": "gaitsetpy.features.get_median_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_median_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_mode_for_windows": {"fullname": "gaitsetpy.features.get_mode_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_mode_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_mean_absolute_value_for_windows": {"fullname": "gaitsetpy.features.get_mean_absolute_value_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_mean_absolute_value_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_median_absolute_deviation_for_windows": {"fullname": "gaitsetpy.features.get_median_absolute_deviation_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_median_absolute_deviation_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_peak_height_for_windows": {"fullname": "gaitsetpy.features.get_peak_height_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_peak_height_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_stride_times_for_windows": {"fullname": "gaitsetpy.features.get_stride_times_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_stride_times_for_windows", "kind": "function", "doc": "<p>Calculate stride times for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_step_times_for_windows": {"fullname": "gaitsetpy.features.get_step_times_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_step_times_for_windows", "kind": "function", "doc": "<p>Calculate step times for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_cadence_for_windows": {"fullname": "gaitsetpy.features.get_cadence_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_cadence_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_freezing_index_for_windows": {"fullname": "gaitsetpy.features.get_freezing_index_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_freezing_index_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_dominant_frequency_for_windows": {"fullname": "gaitsetpy.features.get_dominant_frequency_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_dominant_frequency_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_peak_frequency_for_windows": {"fullname": "gaitsetpy.features.get_peak_frequency_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_peak_frequency_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_power_spectral_entropy_for_windows": {"fullname": "gaitsetpy.features.get_power_spectral_entropy_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_power_spectral_entropy_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_principal_harmonic_frequency_for_windows": {"fullname": "gaitsetpy.features.get_principal_harmonic_frequency_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_principal_harmonic_frequency_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_entropy_for_windows": {"fullname": "gaitsetpy.features.get_entropy_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_entropy_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_interquartile_range_for_windows": {"fullname": "gaitsetpy.features.get_interquartile_range_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_interquartile_range_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_correlation_for_windows": {"fullname": "gaitsetpy.features.get_correlation_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_correlation_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.get_auto_regression_coefficients_for_windows": {"fullname": "gaitsetpy.features.get_auto_regression_coefficients_for_windows", "modulename": "gaitsetpy.features", "qualname": "get_auto_regression_coefficients_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.extract_gait_features": {"fullname": "gaitsetpy.features.extract_gait_features", "modulename": "gaitsetpy.features", "qualname": "extract_gait_features", "kind": "function", "doc": "<p>Legacy function for extracting gait features.</p>\n\n<p>Args:\n    daphnet_windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    time_domain: Whether to extract time domain features\n    frequency_domain: Whether to extract frequency domain features\n    statistical: Whether to extract statistical features\n    verbose: Whether to show verbose output and progress bars</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">daphnet_windows</span>,</span><span class=\"param\">\t<span class=\"n\">fs</span>,</span><span class=\"param\">\t<span class=\"n\">time_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">frequency_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">statistical</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features": {"fullname": "gaitsetpy.features.gait_features", "modulename": "gaitsetpy.features.gait_features", "kind": "module", "doc": "<p>Gait Feature Extractor Class\nMaintainer: @aharshit123456</p>\n\n<p>This module contains the GaitFeatureExtractor class that inherits from BaseFeatureExtractor\nand provides comprehensive gait feature extraction functionality.</p>\n"}, "gaitsetpy.features.gait_features.logger": {"fullname": "gaitsetpy.features.gait_features.logger", "modulename": "gaitsetpy.features.gait_features", "qualname": "logger", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Logger gaitsetpy.features.gait_features (INFO)&gt;"}, "gaitsetpy.features.gait_features.GaitFeatureExtractor": {"fullname": "gaitsetpy.features.gait_features.GaitFeatureExtractor", "modulename": "gaitsetpy.features.gait_features", "qualname": "GaitFeatureExtractor", "kind": "class", "doc": "<p>Comprehensive gait feature extractor class.</p>\n\n<p>This class extracts various time-domain, frequency-domain, and statistical features\nfrom gait data sliding windows.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.gait_features.GaitFeatureExtractor.__init__", "modulename": "gaitsetpy.features.gait_features", "qualname": "GaitFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.gait_features.GaitFeatureExtractor.verbose", "modulename": "gaitsetpy.features.gait_features", "qualname": "GaitFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.config": {"fullname": "gaitsetpy.features.gait_features.GaitFeatureExtractor.config", "modulename": "gaitsetpy.features.gait_features", "qualname": "GaitFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.gait_features.GaitFeatureExtractor.extract_features", "modulename": "gaitsetpy.features.gait_features", "qualname": "GaitFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract gait features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments including time_domain, frequency_domain, statistical flags</p>\n\n<p>Returns:\n    List of feature dictionaries for each sensor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.gait_features.GaitFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features.gait_features", "qualname": "GaitFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of all features that can be extracted.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.print_extraction_summary": {"fullname": "gaitsetpy.features.gait_features.GaitFeatureExtractor.print_extraction_summary", "modulename": "gaitsetpy.features.gait_features", "qualname": "GaitFeatureExtractor.print_extraction_summary", "kind": "function", "doc": "<p>Print a detailed summary of extracted features.</p>\n\n<p>Args:\n    features: List of feature dictionaries returned by extract_features</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_stride_times_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_stride_times_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_stride_times_for_windows", "kind": "function", "doc": "<p>Calculate stride times for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_zero_crossing_rates_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_zero_crossing_rates_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_zero_crossing_rates_for_windows", "kind": "function", "doc": "<p>Calculate zero-crossing rates for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_freezing_indices_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_freezing_indices_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_freezing_indices_for_windows", "kind": "function", "doc": "<p>Calculate freezing indices for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_standard_deviations_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_standard_deviations_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_standard_deviations_for_windows", "kind": "function", "doc": "<p>Calculate standard deviations for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_entropies_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_entropies_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_entropies_for_windows", "kind": "function", "doc": "<p>Calculate entropies for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_energies_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_energies_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_energies_for_windows", "kind": "function", "doc": "<p>Calculate energies for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_variances_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_variances_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_variances_for_windows", "kind": "function", "doc": "<p>Calculate variances for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_kurtosis_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_kurtosis_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_kurtosis_for_windows", "kind": "function", "doc": "<p>Calculate kurtosis values for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_step_times_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_step_times_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_step_times_for_windows", "kind": "function", "doc": "<p>Calculate step times for all windows in the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_mean_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_mean_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_mean_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_standard_deviation_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_standard_deviation_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_standard_deviation_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_variance_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_variance_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_variance_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_skewness_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_skewness_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_skewness_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_root_mean_square_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_root_mean_square_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_root_mean_square_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_range_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_range_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_range_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_median_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_median_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_median_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_mode_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_mode_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_mode_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_mean_absolute_value_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_mean_absolute_value_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_mean_absolute_value_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_median_absolute_deviation_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_median_absolute_deviation_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_median_absolute_deviation_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_peak_height_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_peak_height_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_peak_height_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_cadence_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_cadence_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_cadence_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_freezing_index_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_freezing_index_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_freezing_index_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_dominant_frequency_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_dominant_frequency_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_dominant_frequency_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_peak_frequency_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_peak_frequency_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_peak_frequency_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_power_spectral_entropy_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_power_spectral_entropy_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_power_spectral_entropy_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_principal_harmonic_frequency_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_principal_harmonic_frequency_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_principal_harmonic_frequency_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_entropy_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_entropy_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_entropy_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_interquartile_range_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_interquartile_range_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_interquartile_range_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_correlation_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_correlation_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_correlation_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.get_auto_regression_coefficients_for_windows": {"fullname": "gaitsetpy.features.gait_features.get_auto_regression_coefficients_for_windows", "modulename": "gaitsetpy.features.gait_features", "qualname": "get_auto_regression_coefficients_for_windows", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.gait_features.extract_gait_features": {"fullname": "gaitsetpy.features.gait_features.extract_gait_features", "modulename": "gaitsetpy.features.gait_features", "qualname": "extract_gait_features", "kind": "function", "doc": "<p>Legacy function for extracting gait features.</p>\n\n<p>Args:\n    daphnet_windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    time_domain: Whether to extract time domain features\n    frequency_domain: Whether to extract frequency domain features\n    statistical: Whether to extract statistical features\n    verbose: Whether to show verbose output and progress bars</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">daphnet_windows</span>,</span><span class=\"param\">\t<span class=\"n\">fs</span>,</span><span class=\"param\">\t<span class=\"n\">time_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">frequency_domain</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">statistical</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.harup_features": {"fullname": "gaitsetpy.features.harup_features", "modulename": "gaitsetpy.features.harup_features", "kind": "module", "doc": "<p>HAR-UP Feature Extractor.\nMaintainer: @aharshit123456</p>\n\n<p>This file contains the HAR-UP feature extractor class that inherits from BaseFeatureExtractor.\nIt implements the feature extraction methods used in the HAR-UP project.</p>\n\n<p>Reference:</p>\n\n<ul>\n<li>Website: <a href=\"https://sites.google.com/up.edu.mx/har-up/\">https://sites.google.com/up.edu.mx/har-up/</a></li>\n<li>GitHub: <a href=\"https://github.com/jpnm561/HAR-UP\">https://github.com/jpnm561/HAR-UP</a></li>\n</ul>\n"}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor": {"fullname": "gaitsetpy.features.harup_features.HARUPFeatureExtractor", "modulename": "gaitsetpy.features.harup_features", "qualname": "HARUPFeatureExtractor", "kind": "class", "doc": "<p>HAR-UP feature extractor class.</p>\n\n<p>This class implements the feature extraction methods used in the HAR-UP project.\nIt extracts both time-domain and frequency-domain features from sensor data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.harup_features.HARUPFeatureExtractor.__init__", "modulename": "gaitsetpy.features.harup_features", "qualname": "HARUPFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the HAR-UP feature extractor.</p>\n\n<p>Args:\n    verbose: Whether to print progress information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.config": {"fullname": "gaitsetpy.features.harup_features.HARUPFeatureExtractor.config", "modulename": "gaitsetpy.features.harup_features", "qualname": "HARUPFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.time_domain_features": {"fullname": "gaitsetpy.features.harup_features.HARUPFeatureExtractor.time_domain_features", "modulename": "gaitsetpy.features.harup_features", "qualname": "HARUPFeatureExtractor.time_domain_features", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.freq_domain_features": {"fullname": "gaitsetpy.features.harup_features.HARUPFeatureExtractor.freq_domain_features", "modulename": "gaitsetpy.features.harup_features", "qualname": "HARUPFeatureExtractor.freq_domain_features", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.harup_features.HARUPFeatureExtractor.extract_features", "modulename": "gaitsetpy.features.harup_features", "qualname": "HARUPFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.harup_features.HARUPFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features.harup_features", "qualname": "HARUPFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of features extracted by this extractor.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.harup_features.extract_harup_features": {"fullname": "gaitsetpy.features.harup_features.extract_harup_features", "modulename": "gaitsetpy.features.harup_features", "qualname": "extract_harup_features", "kind": "function", "doc": "<p>Legacy function for extracting HAR-UP features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency (default: 100Hz)\n    time_domain: Whether to extract time domain features\n    freq_domain: Whether to extract frequency domain features\n    verbose: Whether to print progress information</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">time_domain</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">freq_domain</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features": {"fullname": "gaitsetpy.features.physionet_features", "modulename": "gaitsetpy.features.physionet_features", "kind": "module", "doc": "<p>PhysioNet VGRF Feature Extractor.\nMaintainer: @aharshit123456</p>\n\n<p>This module contains feature extractors specific to the PhysioNet VGRF dataset,\nincluding Local Binary Pattern (LBP) and Fourier series analysis.</p>\n"}, "gaitsetpy.features.physionet_features.logger": {"fullname": "gaitsetpy.features.physionet_features.logger", "modulename": "gaitsetpy.features.physionet_features", "qualname": "logger", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Logger gaitsetpy.features.physionet_features (INFO)&gt;"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor", "kind": "class", "doc": "<p>Local Binary Pattern (LBP) feature extractor for VGRF data.</p>\n\n<p>This extractor converts time-series data into LBP codes and extracts\nhistogram features from the LBP representation.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor.__init__", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor.verbose", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.config": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor.config", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.lbp_1d": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor.lbp_1d", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor.lbp_1d", "kind": "function", "doc": "<p>Compute 1D Local Binary Pattern for time-series data.</p>\n\n<p>Args:\n    data: Input time-series data\n    radius: Radius for LBP computation</p>\n\n<p>Returns:\n    LBP code as binary string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>, </span><span class=\"param\"><span class=\"n\">radius</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.lbp_to_histogram": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor.lbp_to_histogram", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor.lbp_to_histogram", "kind": "function", "doc": "<p>Convert LBP code to histogram features.</p>\n\n<p>Args:\n    lbp_code: Binary LBP code string\n    n_bins: Number of histogram bins\n    normalize: Whether to normalize histogram</p>\n\n<p>Returns:\n    Histogram features as numpy array</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lbp_code</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">n_bins</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">256</span>,</span><span class=\"param\">\t<span class=\"n\">normalize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor.extract_features", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract LBP features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency (unused for LBP)\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.physionet_features.LBPFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features.physionet_features", "qualname": "LBPFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of LBP features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor": {"fullname": "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor", "modulename": "gaitsetpy.features.physionet_features", "qualname": "FourierSeriesFeatureExtractor", "kind": "class", "doc": "<p>Fourier Series feature extractor for VGRF data.</p>\n\n<p>This extractor fits Fourier series to time-series data and extracts\ncoefficients and reconstruction features.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.__init__", "modulename": "gaitsetpy.features.physionet_features", "qualname": "FourierSeriesFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.verbose", "modulename": "gaitsetpy.features.physionet_features", "qualname": "FourierSeriesFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.config": {"fullname": "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.config", "modulename": "gaitsetpy.features.physionet_features", "qualname": "FourierSeriesFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.fit_fourier_series": {"fullname": "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.fit_fourier_series", "modulename": "gaitsetpy.features.physionet_features", "qualname": "FourierSeriesFeatureExtractor.fit_fourier_series", "kind": "function", "doc": "<p>Fit Fourier series to signal.</p>\n\n<p>Args:\n    signal: Input signal\n    time_points: Time points\n    period: Period of the Fourier series\n    n_terms: Number of Fourier terms</p>\n\n<p>Returns:\n    Dictionary containing Fourier series parameters</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">signal</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">time_points</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">period</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">3.0</span>,</span><span class=\"param\">\t<span class=\"n\">n_terms</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.extract_features", "modulename": "gaitsetpy.features.physionet_features", "qualname": "FourierSeriesFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract Fourier series features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features.physionet_features", "qualname": "FourierSeriesFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of Fourier series features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor": {"fullname": "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor", "modulename": "gaitsetpy.features.physionet_features", "qualname": "PhysioNetFeatureExtractor", "kind": "class", "doc": "<p>Combined feature extractor for PhysioNet VGRF data.</p>\n\n<p>This extractor combines LBP and Fourier series features along with\nbasic statistical features specific to VGRF data.</p>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.__init__", "modulename": "gaitsetpy.features.physionet_features", "qualname": "PhysioNetFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.verbose": {"fullname": "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.verbose", "modulename": "gaitsetpy.features.physionet_features", "qualname": "PhysioNetFeatureExtractor.verbose", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.lbp_extractor": {"fullname": "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.lbp_extractor", "modulename": "gaitsetpy.features.physionet_features", "qualname": "PhysioNetFeatureExtractor.lbp_extractor", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.fourier_extractor": {"fullname": "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.fourier_extractor", "modulename": "gaitsetpy.features.physionet_features", "qualname": "PhysioNetFeatureExtractor.fourier_extractor", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.extract_features", "modulename": "gaitsetpy.features.physionet_features", "qualname": "PhysioNetFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract combined features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features.physionet_features", "qualname": "PhysioNetFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of all features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.extract_lbp_features": {"fullname": "gaitsetpy.features.physionet_features.extract_lbp_features", "modulename": "gaitsetpy.features.physionet_features", "qualname": "extract_lbp_features", "kind": "function", "doc": "<p>Legacy function to extract LBP features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.extract_fourier_features": {"fullname": "gaitsetpy.features.physionet_features.extract_fourier_features", "modulename": "gaitsetpy.features.physionet_features", "qualname": "extract_fourier_features", "kind": "function", "doc": "<p>Legacy function to extract Fourier series features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.physionet_features.extract_physionet_features": {"fullname": "gaitsetpy.features.physionet_features.extract_physionet_features", "modulename": "gaitsetpy.features.physionet_features", "qualname": "extract_physionet_features", "kind": "function", "doc": "<p>Legacy function to extract combined PhysioNet features.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.urfall_features": {"fullname": "gaitsetpy.features.urfall_features", "modulename": "gaitsetpy.features.urfall_features", "kind": "module", "doc": "<p>UrFall Image/Video Feature Extractor.\nMaintainer: @aharshit123456</p>\n\n<p>This module provides a lightweight feature extractor for UrFall depth (PNG16), RGB (PNG), and video (MP4) modalities.\nIt extracts simple, fast-to-compute features suitable for sanity checks and baseline models.</p>\n"}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor": {"fullname": "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor", "modulename": "gaitsetpy.features.urfall_features", "qualname": "UrFallMediaFeatureExtractor", "kind": "class", "doc": "<p>UrFall image/video feature extractor.</p>\n\n<p>Extracts per-window features from sequences of images or decoded video frames:</p>\n\n<ul>\n<li>mean_intensity</li>\n<li>std_intensity</li>\n<li>motion_mean (if pairwise differences are available)</li>\n<li>motion_std</li>\n</ul>\n", "bases": "gaitsetpy.core.base_classes.BaseFeatureExtractor"}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.__init__": {"fullname": "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.__init__", "modulename": "gaitsetpy.features.urfall_features", "qualname": "UrFallMediaFeatureExtractor.__init__", "kind": "function", "doc": "<p>Initialize the feature extractor.</p>\n\n<p>Args:\n    name: Name of the feature extractor\n    description: Description of the feature extractor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.config": {"fullname": "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.config", "modulename": "gaitsetpy.features.urfall_features", "qualname": "UrFallMediaFeatureExtractor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.extract_features": {"fullname": "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.extract_features", "modulename": "gaitsetpy.features.urfall_features", "qualname": "UrFallMediaFeatureExtractor.extract_features", "kind": "function", "doc": "<p>Extract features from sliding windows.</p>\n\n<p>Args:\n    windows: List of sliding window dictionaries\n    fs: Sampling frequency\n    **kwargs: Additional arguments for feature extraction</p>\n\n<p>Returns:\n    List of feature dictionaries</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">windows</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.get_feature_names": {"fullname": "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.get_feature_names", "modulename": "gaitsetpy.features.urfall_features", "qualname": "UrFallMediaFeatureExtractor.get_feature_names", "kind": "function", "doc": "<p>Get names of features extracted by this extractor.</p>\n\n<p>Returns:\n    List of feature names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils": {"fullname": "gaitsetpy.features.utils", "modulename": "gaitsetpy.features.utils", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.features.utils.calculate_stride_times": {"fullname": "gaitsetpy.features.utils.calculate_stride_times", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_stride_times", "kind": "function", "doc": "<p>Calculate stride times from a signal using peak detection.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    avg_stride_time (float): Average stride time.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_zero_crossing_rate": {"fullname": "gaitsetpy.features.utils.calculate_zero_crossing_rate", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_zero_crossing_rate", "kind": "function", "doc": "<p>Calculate the zero-crossing rate of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    zcr (float): Zero-crossing rate.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_power": {"fullname": "gaitsetpy.features.utils.calculate_power", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_power", "kind": "function", "doc": "<p>Calculate the power of a signal in a specific frequency band.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\n    band (tuple): Frequency band (low, high).\nReturns:\n    band_power (float): Power in the specified frequency band.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span>, </span><span class=\"param\"><span class=\"n\">band</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_freezing_index": {"fullname": "gaitsetpy.features.utils.calculate_freezing_index", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_freezing_index", "kind": "function", "doc": "<p>Calculate the freezing index of a signal.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    freezing_index (float): Freezing index.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_standard_deviation": {"fullname": "gaitsetpy.features.utils.calculate_standard_deviation", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_standard_deviation", "kind": "function", "doc": "<p>Calculate the standard deviation of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    std_dev (float): Standard deviation.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_entropy": {"fullname": "gaitsetpy.features.utils.calculate_entropy", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_entropy", "kind": "function", "doc": "<p>Calculate the entropy of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    entropy_value (float): Entropy.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_energy": {"fullname": "gaitsetpy.features.utils.calculate_energy", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_energy", "kind": "function", "doc": "<p>Calculate the energy of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    energy (float): Energy.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_variance": {"fullname": "gaitsetpy.features.utils.calculate_variance", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_variance", "kind": "function", "doc": "<p>Calculate the variance of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    variance (float): Variance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_kurtosis": {"fullname": "gaitsetpy.features.utils.calculate_kurtosis", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_kurtosis", "kind": "function", "doc": "<p>Calculate the kurtosis of a signal.\nArgs:\n    signal (np.array): Input signal.\nReturns:\n    kurtosis_value (float): Kurtosis.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_step_time": {"fullname": "gaitsetpy.features.utils.calculate_step_time", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_step_time", "kind": "function", "doc": "<p>Calculate step times from a signal using peak detection.\nArgs:\n    signal (np.array): Input signal.\n    fs (int): Sampling frequency.\nReturns:\n    step_times (np.array): Array of step times.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_mean": {"fullname": "gaitsetpy.features.utils.calculate_mean", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_mean", "kind": "function", "doc": "<p>Calculate the mean of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_max": {"fullname": "gaitsetpy.features.utils.calculate_max", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_max", "kind": "function", "doc": "<p>Calculate the maximum value of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_min": {"fullname": "gaitsetpy.features.utils.calculate_min", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_min", "kind": "function", "doc": "<p>Calculate the minimum value of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_median": {"fullname": "gaitsetpy.features.utils.calculate_median", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_median", "kind": "function", "doc": "<p>Calculate the median of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_skewness": {"fullname": "gaitsetpy.features.utils.calculate_skewness", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_skewness", "kind": "function", "doc": "<p>Calculate the skewness of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_root_mean_square": {"fullname": "gaitsetpy.features.utils.calculate_root_mean_square", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_root_mean_square", "kind": "function", "doc": "<p>Calculate the root mean square of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_range": {"fullname": "gaitsetpy.features.utils.calculate_range", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_range", "kind": "function", "doc": "<p>Calculate the range of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_correlation": {"fullname": "gaitsetpy.features.utils.calculate_correlation", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_correlation", "kind": "function", "doc": "<p>Calculate the correlation between two signals.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal1</span>, </span><span class=\"param\"><span class=\"n\">signal2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_dominant_frequency": {"fullname": "gaitsetpy.features.utils.calculate_dominant_frequency", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_dominant_frequency", "kind": "function", "doc": "<p>Calculate the dominant frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_peak_height": {"fullname": "gaitsetpy.features.utils.calculate_peak_height", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_peak_height", "kind": "function", "doc": "<p>Calculate the peak height of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_interquartile_range": {"fullname": "gaitsetpy.features.utils.calculate_interquartile_range", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_interquartile_range", "kind": "function", "doc": "<p>Calculate the interquartile range of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_mode": {"fullname": "gaitsetpy.features.utils.calculate_mode", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_mode", "kind": "function", "doc": "<p>Calculate the mode of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_cadence": {"fullname": "gaitsetpy.features.utils.calculate_cadence", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_cadence", "kind": "function", "doc": "<p>Calculate the cadence (steps per minute) of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_mean_absolute_value": {"fullname": "gaitsetpy.features.utils.calculate_mean_absolute_value", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_mean_absolute_value", "kind": "function", "doc": "<p>Calculate the mean absolute value of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_median_absolute_deviation": {"fullname": "gaitsetpy.features.utils.calculate_median_absolute_deviation", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_median_absolute_deviation", "kind": "function", "doc": "<p>Calculate the median absolute deviation of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_peak_frequency": {"fullname": "gaitsetpy.features.utils.calculate_peak_frequency", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_peak_frequency", "kind": "function", "doc": "<p>Calculate the peak frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_peak_width": {"fullname": "gaitsetpy.features.utils.calculate_peak_width", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_peak_width", "kind": "function", "doc": "<p>Calculate the peak width of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_power_spectral_entropy": {"fullname": "gaitsetpy.features.utils.calculate_power_spectral_entropy", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_power_spectral_entropy", "kind": "function", "doc": "<p>Calculate the power spectral entropy of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_principal_harmonic_frequency": {"fullname": "gaitsetpy.features.utils.calculate_principal_harmonic_frequency", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_principal_harmonic_frequency", "kind": "function", "doc": "<p>Calculate the principal harmonic frequency of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">fs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.features.utils.calculate_auto_regression_coefficients": {"fullname": "gaitsetpy.features.utils.calculate_auto_regression_coefficients", "modulename": "gaitsetpy.features.utils", "qualname": "calculate_auto_regression_coefficients", "kind": "function", "doc": "<p>Calculate the auto-regression coefficients of the signal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">signal</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.main": {"fullname": "gaitsetpy.main", "modulename": "gaitsetpy.main", "kind": "module", "doc": "<p>TODO : Add noise filters, refactor sliding windows</p>\n"}, "gaitsetpy.preprocessing": {"fullname": "gaitsetpy.preprocessing", "modulename": "gaitsetpy.preprocessing", "kind": "module", "doc": "<p>preprocessing: Preprocessing pipelines for gait data.</p>\n\n<p>This module provides both the new class-based preprocessors and legacy function-based API.\nAll preprocessors inherit from BasePreprocessor and are registered with the PreprocessingManager.</p>\n\n<p>Features:</p>\n\n<ul>\n<li>Clipping and normalization</li>\n<li>Noise removal (moving average, frequency filtering)</li>\n<li>Outlier detection and removal</li>\n<li>Baseline and drift correction</li>\n<li>Artifact removal and trend removal</li>\n<li>DC offset correction</li>\n</ul>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.preprocessing.ClippingPreprocessor": {"fullname": "gaitsetpy.preprocessing.ClippingPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "ClippingPreprocessor", "kind": "class", "doc": "<p>Preprocessor for clipping values to a specified range.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.ClippingPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.ClippingPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "ClippingPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span>)</span>"}, "gaitsetpy.preprocessing.ClippingPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.ClippingPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "ClippingPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.ClippingPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.ClippingPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "ClippingPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for clipping).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.ClippingPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.ClippingPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "ClippingPreprocessor.transform", "kind": "function", "doc": "<p>Clip values in the data to be within the specified range.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Clipped data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.NoiseRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "NoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing noise using moving average filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "NoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">5</span></span>)</span>"}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "NoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "NoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for noise removal).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "NoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a moving average filter to reduce noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Noise-reduced data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.OutlierRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "OutlierRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing outliers using Z-score method.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "OutlierRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">threshold</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">3</span></span>)</span>"}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "OutlierRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.mean_", "modulename": "gaitsetpy.preprocessing", "qualname": "OutlierRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.std_": {"fullname": "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.std_", "modulename": "gaitsetpy.preprocessing", "qualname": "OutlierRemovalPreprocessor.std_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "OutlierRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing mean and standard deviation.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "OutlierRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove outliers beyond the threshold using Z-score method.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Data with outliers removed</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.BaselineRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "BaselineRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing baseline by subtracting the mean.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "BaselineRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.mean_", "modulename": "gaitsetpy.preprocessing", "qualname": "BaselineRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "BaselineRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing the mean.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "BaselineRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove baseline by subtracting the mean.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Baseline-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.DriftRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "DriftRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing low-frequency drift using high-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.DriftRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "DriftRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.01</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.DriftRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "DriftRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.DriftRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "DriftRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for drift removal).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.DriftRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "DriftRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove low-frequency drift using a high-pass filter.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Drift-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "HighFrequencyNoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing high-frequency noise using low-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "HighFrequencyNoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "HighFrequencyNoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "HighFrequencyNoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for filtering).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "HighFrequencyNoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a low-pass filter to remove high-frequency noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Filtered data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "LowFrequencyNoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing low-frequency noise using high-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "LowFrequencyNoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "LowFrequencyNoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "LowFrequencyNoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for filtering).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.LowFrequencyNoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "LowFrequencyNoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a high-pass filter to remove low-frequency noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Filtered data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "ArtifactRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing artifacts by interpolating missing values.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "ArtifactRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">method</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;linear&#39;</span></span>)</span>"}, "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "ArtifactRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "ArtifactRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for interpolation).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.ArtifactRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "ArtifactRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove artifacts by interpolating missing values.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Artifact-free data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.TrendRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.TrendRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "TrendRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing trends using polynomial fitting.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.TrendRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.TrendRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "TrendRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">order</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span>)</span>"}, "gaitsetpy.preprocessing.TrendRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.TrendRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing", "qualname": "TrendRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.TrendRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.TrendRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "TrendRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for detrending).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.TrendRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.TrendRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "TrendRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove trends using polynomial fitting.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Detrended data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing", "qualname": "DCOffsetRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing DC offset by subtracting the mean.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing", "qualname": "DCOffsetRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.mean_", "modulename": "gaitsetpy.preprocessing", "qualname": "DCOffsetRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing", "qualname": "DCOffsetRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing the mean.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.DCOffsetRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing", "qualname": "DCOffsetRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove DC offset by subtracting the mean.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    DC-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.clip_sliding_windows": {"fullname": "gaitsetpy.preprocessing.clip_sliding_windows", "modulename": "gaitsetpy.preprocessing", "qualname": "clip_sliding_windows", "kind": "function", "doc": "<p>Clip values in the sliding windows to be within a specified range.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_noise": {"fullname": "gaitsetpy.preprocessing.remove_noise", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_noise", "kind": "function", "doc": "<p>Apply a moving average filter to reduce noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">5</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_outliers": {"fullname": "gaitsetpy.preprocessing.remove_outliers", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_outliers", "kind": "function", "doc": "<p>Remove outliers beyond a given threshold using the Z-score method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">threshold</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_baseline": {"fullname": "gaitsetpy.preprocessing.remove_baseline", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_baseline", "kind": "function", "doc": "<p>Remove baseline by subtracting the mean.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_drift": {"fullname": "gaitsetpy.preprocessing.remove_drift", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_drift", "kind": "function", "doc": "<p>Remove low-frequency drift using a high-pass filter.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mf\">0.01</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_artifacts": {"fullname": "gaitsetpy.preprocessing.remove_artifacts", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_artifacts", "kind": "function", "doc": "<p>Remove artifacts by interpolating missing values.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;interpolate&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_trend": {"fullname": "gaitsetpy.preprocessing.remove_trend", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_trend", "kind": "function", "doc": "<p>Remove trends using polynomial fitting.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_dc_offset": {"fullname": "gaitsetpy.preprocessing.remove_dc_offset", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_dc_offset", "kind": "function", "doc": "<p>Remove DC offset by subtracting the mean.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_high_frequency_noise": {"fullname": "gaitsetpy.preprocessing.remove_high_frequency_noise", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_high_frequency_noise", "kind": "function", "doc": "<p>Apply a low-pass filter to remove high-frequency noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.remove_low_frequency_noise": {"fullname": "gaitsetpy.preprocessing.remove_low_frequency_noise", "modulename": "gaitsetpy.preprocessing", "qualname": "remove_low_frequency_noise", "kind": "function", "doc": "<p>Apply a high-pass filter to remove low-frequency noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.get_preprocessing_manager": {"fullname": "gaitsetpy.preprocessing.get_preprocessing_manager", "modulename": "gaitsetpy.preprocessing", "qualname": "get_preprocessing_manager", "kind": "function", "doc": "<p>Get the singleton PreprocessingManager instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.get_available_preprocessors": {"fullname": "gaitsetpy.preprocessing.get_available_preprocessors", "modulename": "gaitsetpy.preprocessing", "qualname": "get_available_preprocessors", "kind": "function", "doc": "<p>Get list of available preprocessor names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocess_data": {"fullname": "gaitsetpy.preprocessing.preprocess_data", "modulename": "gaitsetpy.preprocessing", "qualname": "preprocess_data", "kind": "function", "doc": "<p>Preprocess data using the PreprocessingManager.</p>\n\n<p>Args:\n    preprocessor_name: Name of the preprocessor\n    data: Input data to preprocess\n    **kwargs: Additional arguments for preprocessing</p>\n\n<p>Returns:\n    Preprocessed data</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">preprocessor_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.create_preprocessing_pipeline": {"fullname": "gaitsetpy.preprocessing.create_preprocessing_pipeline", "modulename": "gaitsetpy.preprocessing", "qualname": "create_preprocessing_pipeline", "kind": "function", "doc": "<p>Create a preprocessing pipeline with multiple preprocessors.</p>\n\n<p>Args:\n    preprocessor_names: List of preprocessor names to chain\n    **kwargs: Additional arguments for individual preprocessors</p>\n\n<p>Returns:\n    Function that applies all preprocessors in sequence</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">preprocessor_names</span><span class=\"p\">:</span> <span class=\"nb\">list</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline": {"fullname": "gaitsetpy.preprocessing.pipeline", "modulename": "gaitsetpy.preprocessing.pipeline", "kind": "module", "doc": "<p>This file contains functions for preprocessing the data.</p>\n\n<p>Clipping, Noise Removal etc.</p>\n\n<p>We'll have the following functions:\nclip_sliding_windows, remove_noise, remove_outliers, remove_baseline, remove_drift, remove_artifacts, remove_trend, remove_dc_offset, remove_high_frequency_noise, remove_low_frequency_noise</p>\n"}, "gaitsetpy.preprocessing.pipeline.clip_sliding_windows": {"fullname": "gaitsetpy.preprocessing.pipeline.clip_sliding_windows", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "clip_sliding_windows", "kind": "function", "doc": "<p>Clip values in the sliding windows to be within a specified range.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_noise": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_noise", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_noise", "kind": "function", "doc": "<p>Apply a moving average filter to reduce noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">window_size</span><span class=\"o\">=</span><span class=\"mi\">5</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_outliers": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_outliers", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_outliers", "kind": "function", "doc": "<p>Remove outliers beyond a given threshold using the Z-score method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">threshold</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_baseline": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_baseline", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_baseline", "kind": "function", "doc": "<p>Remove baseline by subtracting the mean.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_drift": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_drift", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_drift", "kind": "function", "doc": "<p>Remove low-frequency drift using a high-pass filter.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mf\">0.01</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_artifacts": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_artifacts", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_artifacts", "kind": "function", "doc": "<p>Remove artifacts by interpolating missing values.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;interpolate&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_trend": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_trend", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_trend", "kind": "function", "doc": "<p>Remove trends using polynomial fitting.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_dc_offset": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_dc_offset", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_dc_offset", "kind": "function", "doc": "<p>Remove DC offset by subtracting the mean.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_high_frequency_noise": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_high_frequency_noise", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_high_frequency_noise", "kind": "function", "doc": "<p>Apply a low-pass filter to remove high-frequency noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.pipeline.remove_low_frequency_noise": {"fullname": "gaitsetpy.preprocessing.pipeline.remove_low_frequency_noise", "modulename": "gaitsetpy.preprocessing.pipeline", "qualname": "remove_low_frequency_noise", "kind": "function", "doc": "<p>Apply a high-pass filter to remove low-frequency noise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">cutoff</span><span class=\"o\">=</span><span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors": {"fullname": "gaitsetpy.preprocessing.preprocessors", "modulename": "gaitsetpy.preprocessing.preprocessors", "kind": "module", "doc": "<p>Preprocessor classes for gait data preprocessing.</p>\n\n<p>This module contains individual preprocessor classes that inherit from BasePreprocessor\nand provide specific preprocessing functionality.</p>\n\n<p>Maintainer: @aharshit123456</p>\n"}, "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ClippingPreprocessor", "kind": "class", "doc": "<p>Preprocessor for clipping values to a specified range.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ClippingPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ClippingPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ClippingPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for clipping).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.ClippingPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ClippingPreprocessor.transform", "kind": "function", "doc": "<p>Clip values in the data to be within the specified range.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Clipped data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "NoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing noise using moving average filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "NoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">window_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">5</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "NoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "NoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for noise removal).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.NoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "NoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a moving average filter to reduce noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Noise-reduced data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "OutlierRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing outliers using Z-score method.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "OutlierRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">threshold</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">3</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "OutlierRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.mean_", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "OutlierRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.std_": {"fullname": "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.std_", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "OutlierRemovalPreprocessor.std_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "OutlierRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing mean and standard deviation.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.OutlierRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "OutlierRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove outliers beyond the threshold using Z-score method.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Data with outliers removed</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "BaselineRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing baseline by subtracting the mean.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "BaselineRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.mean_", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "BaselineRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "BaselineRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing the mean.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.BaselineRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "BaselineRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove baseline by subtracting the mean.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Baseline-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DriftRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing low-frequency drift using high-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DriftRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.01</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DriftRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DriftRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for drift removal).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.DriftRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DriftRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove low-frequency drift using a high-pass filter.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Drift-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "HighFrequencyNoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing high-frequency noise using low-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "HighFrequencyNoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "HighFrequencyNoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "HighFrequencyNoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for filtering).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.HighFrequencyNoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "HighFrequencyNoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a low-pass filter to remove high-frequency noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Filtered data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "LowFrequencyNoiseRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing low-frequency noise using high-pass filter.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "LowFrequencyNoiseRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cutoff</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">fs</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "LowFrequencyNoiseRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "LowFrequencyNoiseRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for filtering).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.LowFrequencyNoiseRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "LowFrequencyNoiseRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Apply a high-pass filter to remove low-frequency noise.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Filtered data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ArtifactRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing artifacts by interpolating missing values.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ArtifactRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">method</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;linear&#39;</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ArtifactRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ArtifactRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for interpolation).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.ArtifactRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "ArtifactRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove artifacts by interpolating missing values.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Artifact-free data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "TrendRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing trends using polynomial fitting.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "TrendRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">order</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span>)</span>"}, "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.config": {"fullname": "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.config", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "TrendRemovalPreprocessor.config", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "TrendRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor (no fitting needed for detrending).</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.TrendRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "TrendRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove trends using polynomial fitting.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    Detrended data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor": {"fullname": "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DCOffsetRemovalPreprocessor", "kind": "class", "doc": "<p>Preprocessor for removing DC offset by subtracting the mean.</p>\n", "bases": "gaitsetpy.core.base_classes.BasePreprocessor"}, "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.__init__": {"fullname": "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.__init__", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DCOffsetRemovalPreprocessor.__init__", "kind": "function", "doc": "<p>Initialize the preprocessor.</p>\n\n<p>Args:\n    name: Name of the preprocessor\n    description: Description of the preprocessor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.mean_": {"fullname": "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.mean_", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DCOffsetRemovalPreprocessor.mean_", "kind": "variable", "doc": "<p></p>\n"}, "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.fit": {"fullname": "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.fit", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DCOffsetRemovalPreprocessor.fit", "kind": "function", "doc": "<p>Fit the preprocessor by computing the mean.</p>\n\n<p>Args:\n    data: Input data to fit on\n    **kwargs: Additional arguments</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.transform": {"fullname": "gaitsetpy.preprocessing.preprocessors.DCOffsetRemovalPreprocessor.transform", "modulename": "gaitsetpy.preprocessing.preprocessors", "qualname": "DCOffsetRemovalPreprocessor.transform", "kind": "function", "doc": "<p>Remove DC offset by subtracting the mean.</p>\n\n<p>Args:\n    data: Input data to transform\n    **kwargs: Additional arguments</p>\n\n<p>Returns:\n    DC-corrected data</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "gaitsetpy.preprocessing.utils": {"fullname": "gaitsetpy.preprocessing.utils", "modulename": "gaitsetpy.preprocessing.utils", "kind": "module", "doc": "<p></p>\n"}, "gaitsetpy.utils": {"fullname": "gaitsetpy.utils", "modulename": "gaitsetpy.utils", "kind": "module", "doc": "<p></p>\n"}}, "docInfo": {"gaitsetpy": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 156}, "gaitsetpy.BaseDatasetLoader": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 37}, "gaitsetpy.BaseDatasetLoader.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 52, "bases": 0, "doc": 31}, "gaitsetpy.BaseDatasetLoader.name": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseDatasetLoader.description": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseDatasetLoader.data": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseDatasetLoader.metadata": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseDatasetLoader.max_workers": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseDatasetLoader.load_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 35}, "gaitsetpy.BaseDatasetLoader.create_sliding_windows": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 48}, "gaitsetpy.BaseDatasetLoader.get_supported_formats": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.BaseDatasetLoader.download_files_concurrent": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 97, "bases": 0, "doc": 85}, "gaitsetpy.BaseDatasetLoader.set_max_workers": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.BaseDatasetLoader.get_download_stats": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 20}, "gaitsetpy.BaseDatasetLoader.get_info": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 15}, "gaitsetpy.BaseFeatureExtractor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.BaseFeatureExtractor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.BaseFeatureExtractor.name": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseFeatureExtractor.description": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseFeatureExtractor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseFeatureExtractor.extract_features": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 33}, "gaitsetpy.BaseFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.BaseFeatureExtractor.configure": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.BaseFeatureExtractor.get_info": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.BasePreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 23}, "gaitsetpy.BasePreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 19}, "gaitsetpy.BasePreprocessor.name": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BasePreprocessor.description": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BasePreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BasePreprocessor.fitted": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BasePreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.BasePreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.BasePreprocessor.fit_transform": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.BasePreprocessor.configure": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 12}, "gaitsetpy.BasePreprocessor.get_info": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 15}, "gaitsetpy.BaseEDAAnalyzer": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.BaseEDAAnalyzer.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.BaseEDAAnalyzer.name": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseEDAAnalyzer.description": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseEDAAnalyzer.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseEDAAnalyzer.analyze": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.BaseEDAAnalyzer.visualize": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 21}, "gaitsetpy.BaseEDAAnalyzer.configure": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.BaseEDAAnalyzer.get_info": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.BaseClassificationModel": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.BaseClassificationModel.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.BaseClassificationModel.name": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseClassificationModel.description": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseClassificationModel.model": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseClassificationModel.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseClassificationModel.trained": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaseClassificationModel.train": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.BaseClassificationModel.predict": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 28}, "gaitsetpy.BaseClassificationModel.evaluate": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.BaseClassificationModel.save_model": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.BaseClassificationModel.load_model": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.BaseClassificationModel.configure": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.BaseClassificationModel.get_info": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 16}, "gaitsetpy.DatasetManager": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.DatasetManager.register_dataset": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.DatasetManager.load_dataset": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 40}, "gaitsetpy.FeatureManager": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.FeatureManager.register_extractor": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.FeatureManager.extract_features": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 41}, "gaitsetpy.PreprocessingManager": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 7}, "gaitsetpy.PreprocessingManager.register_preprocessor": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 20}, "gaitsetpy.PreprocessingManager.preprocess_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 33}, "gaitsetpy.EDAManager": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.EDAManager.register_analyzer": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.EDAManager.analyze_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 35}, "gaitsetpy.EDAManager.visualize_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 29}, "gaitsetpy.ClassificationManager": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.ClassificationManager.register_model": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.ClassificationManager.train_model": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 33}, "gaitsetpy.ClassificationManager.predict": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 34}, "gaitsetpy.ClassificationManager.evaluate_model": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 33}, "gaitsetpy.DaphnetLoader": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.DaphnetLoader.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.DaphnetLoader.metadata": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.DaphnetLoader.load_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.DaphnetLoader.create_sliding_windows": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.DaphnetLoader.get_supported_formats": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.DaphnetLoader.get_sensor_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.DaphnetLoader.get_annotation_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "gaitsetpy.MobiFallLoader": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.MobiFallLoader.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.MobiFallLoader.metadata": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.MobiFallLoader.load_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.MobiFallLoader.create_sliding_windows": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.MobiFallLoader.get_supported_formats": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.MobiFallLoader.get_sensor_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.MobiFallLoader.get_activity_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.ArduousLoader": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.ArduousLoader.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.ArduousLoader.metadata": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.ArduousLoader.load_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.ArduousLoader.create_sliding_windows": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.ArduousLoader.get_supported_formats": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.ArduousLoader.get_sensor_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.ArduousLoader.get_activity_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.PhysioNetLoader": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 54}, "gaitsetpy.PhysioNetLoader.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.PhysioNetLoader.metadata": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.PhysioNetLoader.labels": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.PhysioNetLoader.subject_types": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.PhysioNetLoader.load_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 38}, "gaitsetpy.PhysioNetLoader.create_sliding_windows": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 65}, "gaitsetpy.PhysioNetLoader.get_supported_formats": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.PhysioNetLoader.get_sensor_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.PhysioNetLoader.get_subject_info": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.PhysioNetLoader.get_labels": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.PhysioNetLoader.filter_by_subject_type": {"qualname": 5, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 28}, "gaitsetpy.GaitFeatureExtractor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "gaitsetpy.GaitFeatureExtractor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.GaitFeatureExtractor.verbose": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.GaitFeatureExtractor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.GaitFeatureExtractor.extract_features": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 41}, "gaitsetpy.GaitFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 19}, "gaitsetpy.GaitFeatureExtractor.print_extraction_summary": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 22}, "gaitsetpy.LBPFeatureExtractor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 32}, "gaitsetpy.LBPFeatureExtractor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.LBPFeatureExtractor.verbose": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.LBPFeatureExtractor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.LBPFeatureExtractor.lbp_1d": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 33}, "gaitsetpy.LBPFeatureExtractor.lbp_to_histogram": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 37}, "gaitsetpy.LBPFeatureExtractor.extract_features": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 34}, "gaitsetpy.LBPFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 8}, "gaitsetpy.FourierSeriesFeatureExtractor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "gaitsetpy.FourierSeriesFeatureExtractor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.FourierSeriesFeatureExtractor.verbose": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.FourierSeriesFeatureExtractor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.FourierSeriesFeatureExtractor.fit_fourier_series": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 38}, "gaitsetpy.FourierSeriesFeatureExtractor.extract_features": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 32}, "gaitsetpy.FourierSeriesFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 9}, "gaitsetpy.PhysioNetFeatureExtractor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 30}, "gaitsetpy.PhysioNetFeatureExtractor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.PhysioNetFeatureExtractor.verbose": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.PhysioNetFeatureExtractor.lbp_extractor": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.PhysioNetFeatureExtractor.fourier_extractor": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.PhysioNetFeatureExtractor.extract_features": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 31}, "gaitsetpy.PhysioNetFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 8}, "gaitsetpy.ClippingPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.ClippingPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 19}, "gaitsetpy.ClippingPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.ClippingPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.ClippingPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 30}, "gaitsetpy.NoiseRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.NoiseRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 19}, "gaitsetpy.NoiseRemovalPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.NoiseRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 24}, "gaitsetpy.NoiseRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.OutlierRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.OutlierRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.OutlierRemovalPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.OutlierRemovalPreprocessor.mean_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.OutlierRemovalPreprocessor.std_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.OutlierRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 24}, "gaitsetpy.OutlierRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 30}, "gaitsetpy.BaselineRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.BaselineRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 19}, "gaitsetpy.BaselineRemovalPreprocessor.mean_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.BaselineRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 22}, "gaitsetpy.BaselineRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 26}, "gaitsetpy.DriftRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "gaitsetpy.DriftRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 19}, "gaitsetpy.DriftRemovalPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.DriftRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 24}, "gaitsetpy.DriftRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 29}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 19}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.HighFrequencyNoiseRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 29}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 19}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.LowFrequencyNoiseRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 29}, "gaitsetpy.ArtifactRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.ArtifactRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 19}, "gaitsetpy.ArtifactRemovalPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.ArtifactRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.ArtifactRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 26}, "gaitsetpy.TrendRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "gaitsetpy.TrendRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.TrendRemovalPreprocessor.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.TrendRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.TrendRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 24}, "gaitsetpy.DCOffsetRemovalPreprocessor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 12}, "gaitsetpy.DCOffsetRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 19}, "gaitsetpy.DCOffsetRemovalPreprocessor.mean_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.DCOffsetRemovalPreprocessor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 22}, "gaitsetpy.DCOffsetRemovalPreprocessor.transform": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 27}, "gaitsetpy.DaphnetVisualizationAnalyzer": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "gaitsetpy.DaphnetVisualizationAnalyzer.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 22}, "gaitsetpy.DaphnetVisualizationAnalyzer.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.DaphnetVisualizationAnalyzer.analyze": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.DaphnetVisualizationAnalyzer.visualize": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 25}, "gaitsetpy.SensorStatisticsAnalyzer": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 33}, "gaitsetpy.SensorStatisticsAnalyzer.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 22}, "gaitsetpy.SensorStatisticsAnalyzer.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.SensorStatisticsAnalyzer.analyze": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.SensorStatisticsAnalyzer.visualize": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 51, "bases": 0, "doc": 38}, "gaitsetpy.RandomForestModel": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 24}, "gaitsetpy.RandomForestModel.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 22}, "gaitsetpy.RandomForestModel.config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.RandomForestModel.model": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.RandomForestModel.feature_names": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.RandomForestModel.class_names": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.RandomForestModel.train": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 28}, "gaitsetpy.RandomForestModel.predict": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 33}, "gaitsetpy.RandomForestModel.evaluate": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 30}, "gaitsetpy.RandomForestModel.save_model": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 21}, "gaitsetpy.RandomForestModel.load_model": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 21}, "gaitsetpy.RandomForestModel.get_feature_importance": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.RandomForestModel.predict_single": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 27}, "gaitsetpy.get_dataset_manager": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.get_feature_manager": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.get_preprocessing_manager": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.get_eda_manager": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.get_classification_manager": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.get_all_managers": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 15}, "gaitsetpy.get_available_datasets": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 9}, "gaitsetpy.get_available_extractors": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 10}, "gaitsetpy.get_available_preprocessors": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 9}, "gaitsetpy.get_available_analyzers": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 10}, "gaitsetpy.get_available_models": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 10}, "gaitsetpy.get_system_info": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 19}, "gaitsetpy.load_and_analyze_daphnet": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 51}, "gaitsetpy.load_and_analyze_physionet": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 54}, "gaitsetpy.train_gait_classifier": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 38}, "gaitsetpy.load_daphnet_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 29}, "gaitsetpy.create_sliding_windows": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 55}, "gaitsetpy.load_mobifall_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 19}, "gaitsetpy.load_arduous_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 19}, "gaitsetpy.load_physionet_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 28}, "gaitsetpy.create_physionet_windows": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 102, "bases": 0, "doc": 44}, "gaitsetpy.load_harup_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 60}, "gaitsetpy.create_harup_windows": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 62}, "gaitsetpy.extract_harup_features": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 48}, "gaitsetpy.download_dataset": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 6}, "gaitsetpy.extract_dataset": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 6}, "gaitsetpy.sliding_window": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 3}, "gaitsetpy.calculate_mean": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.calculate_standard_deviation": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 24}, "gaitsetpy.calculate_variance": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 21}, "gaitsetpy.calculate_skewness": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.calculate_kurtosis": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.calculate_root_mean_square": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.calculate_range": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.calculate_median": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.calculate_mode": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.calculate_mean_absolute_value": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.calculate_median_absolute_deviation": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.calculate_peak_height": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.calculate_stride_times": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 33}, "gaitsetpy.calculate_step_time": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "gaitsetpy.calculate_cadence": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.calculate_freezing_index": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 29}, "gaitsetpy.calculate_dominant_frequency": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.calculate_peak_frequency": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.calculate_power_spectral_entropy": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "gaitsetpy.calculate_principal_harmonic_frequency": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "gaitsetpy.calculate_entropy": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.calculate_interquartile_range": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.calculate_correlation": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 9}, "gaitsetpy.calculate_auto_regression_coefficients": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 11}, "gaitsetpy.get_mean_for_windows": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.get_standard_deviation_for_windows": {"qualname": 5, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.get_variance_for_windows": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.clip_sliding_windows": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 15}, "gaitsetpy.remove_noise": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 11}, "gaitsetpy.remove_outliers": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 14}, "gaitsetpy.remove_baseline": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.remove_drift": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 12}, "gaitsetpy.remove_artifacts": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 9}, "gaitsetpy.remove_trend": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 8}, "gaitsetpy.remove_dc_offset": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.remove_high_frequency_noise": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 13}, "gaitsetpy.remove_low_frequency_noise": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 13}, "gaitsetpy.plot_thigh_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.plot_shank_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.plot_trunk_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.plot_all_data": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 61}, "gaitsetpy.plot_all_thigh_data": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.plot_all_shank_data": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.plot_all_trunk_data": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.plot_all_datasets": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 13}, "gaitsetpy.plot_sensor_with_features": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 184}, "gaitsetpy.create_random_forest_model": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 40}, "gaitsetpy.preprocess_features": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.evaluate_model": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 17}, "gaitsetpy.classification": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 108}, "gaitsetpy.classification.RandomForestModel": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 24}, "gaitsetpy.classification.RandomForestModel.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 22}, "gaitsetpy.classification.RandomForestModel.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.RandomForestModel.model": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.RandomForestModel.feature_names": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.RandomForestModel.class_names": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.RandomForestModel.train": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 28}, "gaitsetpy.classification.RandomForestModel.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 33}, "gaitsetpy.classification.RandomForestModel.evaluate": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 30}, "gaitsetpy.classification.RandomForestModel.save_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 21}, "gaitsetpy.classification.RandomForestModel.load_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 21}, "gaitsetpy.classification.RandomForestModel.get_feature_importance": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.classification.RandomForestModel.predict_single": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 27}, "gaitsetpy.classification.create_random_forest_model": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 40}, "gaitsetpy.classification.preprocess_features": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.classification.evaluate_model": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 17}, "gaitsetpy.classification.get_classification_manager": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.classification.get_available_models": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 10}, "gaitsetpy.classification.train_model": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 36}, "gaitsetpy.classification.predict": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 33}, "gaitsetpy.classification.evaluate_model_performance": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 36}, "gaitsetpy.classification.create_random_forest": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 40}, "gaitsetpy.classification.train_random_forest": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 31}, "gaitsetpy.classification.models": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.get_classification_model": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 81}, "gaitsetpy.classification.models.bilstm": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMNet": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 179}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 14}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.lstm": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.fc": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMNet.forward": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 67}, "gaitsetpy.classification.models.bilstm.BiLSTMModel": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 22}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.device": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.model": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.epochs": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.batch_size": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.trained": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.feature_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.class_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.train": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.predict": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 28}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.evaluate": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.save_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.bilstm.BiLSTMModel.load_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.cnn": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.SimpleCNN": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 179}, "gaitsetpy.classification.models.cnn.SimpleCNN.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 14}, "gaitsetpy.classification.models.cnn.SimpleCNN.conv1": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.SimpleCNN.relu": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.SimpleCNN.pool": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.SimpleCNN.fc": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.SimpleCNN.forward": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 67}, "gaitsetpy.classification.models.cnn.CNNModel": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "gaitsetpy.classification.models.cnn.CNNModel.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 22}, "gaitsetpy.classification.models.cnn.CNNModel.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.device": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.model": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.epochs": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.batch_size": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.trained": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.feature_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.class_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.cnn.CNNModel.train": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.classification.models.cnn.CNNModel.predict": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 28}, "gaitsetpy.classification.models.cnn.CNNModel.evaluate": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.classification.models.cnn.CNNModel.save_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.cnn.CNNModel.load_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.gnn": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.SimpleGCN": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 179}, "gaitsetpy.classification.models.gnn.SimpleGCN.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 14}, "gaitsetpy.classification.models.gnn.SimpleGCN.fc1": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.SimpleGCN.fc2": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.SimpleGCN.forward": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 67}, "gaitsetpy.classification.models.gnn.GNNModel": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 26}, "gaitsetpy.classification.models.gnn.GNNModel.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 22}, "gaitsetpy.classification.models.gnn.GNNModel.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.GNNModel.device": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.GNNModel.model": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.GNNModel.epochs": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.GNNModel.trained": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.GNNModel.feature_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.GNNModel.class_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.gnn.GNNModel.train": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.classification.models.gnn.GNNModel.predict": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 28}, "gaitsetpy.classification.models.gnn.GNNModel.evaluate": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.classification.models.gnn.GNNModel.save_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.gnn.GNNModel.load_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.lstm": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMNet": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 179}, "gaitsetpy.classification.models.lstm.LSTMNet.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 14}, "gaitsetpy.classification.models.lstm.LSTMNet.lstm": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMNet.fc": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMNet.forward": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 67}, "gaitsetpy.classification.models.lstm.LSTMModel": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 12}, "gaitsetpy.classification.models.lstm.LSTMModel.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 22}, "gaitsetpy.classification.models.lstm.LSTMModel.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.device": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.model": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.epochs": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.batch_size": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.trained": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.feature_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.class_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.lstm.LSTMModel.train": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.classification.models.lstm.LSTMModel.predict": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 28}, "gaitsetpy.classification.models.lstm.LSTMModel.evaluate": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.classification.models.lstm.LSTMModel.save_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.lstm.LSTMModel.load_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.mlp": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.mlp.MLPModel": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 18}, "gaitsetpy.classification.models.mlp.MLPModel.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 22}, "gaitsetpy.classification.models.mlp.MLPModel.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.mlp.MLPModel.model": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.mlp.MLPModel.feature_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.mlp.MLPModel.class_names": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.mlp.MLPModel.train": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.classification.models.mlp.MLPModel.predict": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 28}, "gaitsetpy.classification.models.mlp.MLPModel.evaluate": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.classification.models.mlp.MLPModel.save_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.mlp.MLPModel.load_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.classification.models.random_forest": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 29}, "gaitsetpy.classification.models.random_forest.RandomForestModel": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 24}, "gaitsetpy.classification.models.random_forest.RandomForestModel.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 22}, "gaitsetpy.classification.models.random_forest.RandomForestModel.config": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.random_forest.RandomForestModel.model": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.random_forest.RandomForestModel.feature_names": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.random_forest.RandomForestModel.class_names": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.models.random_forest.RandomForestModel.train": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 28}, "gaitsetpy.classification.models.random_forest.RandomForestModel.predict": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 33}, "gaitsetpy.classification.models.random_forest.RandomForestModel.evaluate": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 30}, "gaitsetpy.classification.models.random_forest.RandomForestModel.save_model": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 21}, "gaitsetpy.classification.models.random_forest.RandomForestModel.load_model": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 21}, "gaitsetpy.classification.models.random_forest.RandomForestModel.get_feature_importance": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.classification.models.random_forest.RandomForestModel.predict_single": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 27}, "gaitsetpy.classification.models.random_forest.create_random_forest_model": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 40}, "gaitsetpy.classification.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.utils.dataset": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.classification.utils.eval": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "gaitsetpy.classification.utils.eval.evaluate_model": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 17}, "gaitsetpy.classification.utils.preprocess": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "gaitsetpy.classification.utils.preprocess.preprocess_features": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.classification.utils.train": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 55}, "gaitsetpy.core.BaseDatasetLoader": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 37}, "gaitsetpy.core.BaseDatasetLoader.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 52, "bases": 0, "doc": 31}, "gaitsetpy.core.BaseDatasetLoader.name": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseDatasetLoader.description": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseDatasetLoader.data": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseDatasetLoader.metadata": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseDatasetLoader.max_workers": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseDatasetLoader.load_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 35}, "gaitsetpy.core.BaseDatasetLoader.create_sliding_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 48}, "gaitsetpy.core.BaseDatasetLoader.get_supported_formats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.core.BaseDatasetLoader.download_files_concurrent": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 97, "bases": 0, "doc": 85}, "gaitsetpy.core.BaseDatasetLoader.set_max_workers": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.core.BaseDatasetLoader.get_download_stats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 20}, "gaitsetpy.core.BaseDatasetLoader.get_info": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 15}, "gaitsetpy.core.BaseFeatureExtractor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.core.BaseFeatureExtractor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.core.BaseFeatureExtractor.name": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseFeatureExtractor.description": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseFeatureExtractor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseFeatureExtractor.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 33}, "gaitsetpy.core.BaseFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.core.BaseFeatureExtractor.configure": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.core.BaseFeatureExtractor.get_info": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.core.BasePreprocessor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 23}, "gaitsetpy.core.BasePreprocessor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 19}, "gaitsetpy.core.BasePreprocessor.name": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BasePreprocessor.description": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BasePreprocessor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BasePreprocessor.fitted": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BasePreprocessor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.core.BasePreprocessor.transform": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.core.BasePreprocessor.fit_transform": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.core.BasePreprocessor.configure": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 12}, "gaitsetpy.core.BasePreprocessor.get_info": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 15}, "gaitsetpy.core.BaseEDAAnalyzer": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.core.BaseEDAAnalyzer.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.core.BaseEDAAnalyzer.name": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseEDAAnalyzer.description": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseEDAAnalyzer.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseEDAAnalyzer.analyze": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.core.BaseEDAAnalyzer.visualize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 21}, "gaitsetpy.core.BaseEDAAnalyzer.configure": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.core.BaseEDAAnalyzer.get_info": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.core.BaseClassificationModel": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.core.BaseClassificationModel.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.core.BaseClassificationModel.name": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseClassificationModel.description": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseClassificationModel.model": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseClassificationModel.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseClassificationModel.trained": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.BaseClassificationModel.train": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.core.BaseClassificationModel.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 28}, "gaitsetpy.core.BaseClassificationModel.evaluate": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.core.BaseClassificationModel.save_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.core.BaseClassificationModel.load_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.core.BaseClassificationModel.configure": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.core.BaseClassificationModel.get_info": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 16}, "gaitsetpy.core.DatasetManager": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.core.DatasetManager.register_dataset": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.DatasetManager.load_dataset": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 40}, "gaitsetpy.core.FeatureManager": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.core.FeatureManager.register_extractor": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.FeatureManager.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 41}, "gaitsetpy.core.PreprocessingManager": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 7}, "gaitsetpy.core.PreprocessingManager.register_preprocessor": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 20}, "gaitsetpy.core.PreprocessingManager.preprocess_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 33}, "gaitsetpy.core.EDAManager": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.core.EDAManager.register_analyzer": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.EDAManager.analyze_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 35}, "gaitsetpy.core.EDAManager.visualize_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 29}, "gaitsetpy.core.ClassificationManager": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 8}, "gaitsetpy.core.ClassificationManager.register_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.ClassificationManager.train_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 33}, "gaitsetpy.core.ClassificationManager.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 34}, "gaitsetpy.core.ClassificationManager.evaluate_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 33}, "gaitsetpy.core.base_classes": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 41}, "gaitsetpy.core.base_classes.BaseDatasetLoader": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 37}, "gaitsetpy.core.base_classes.BaseDatasetLoader.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 52, "bases": 0, "doc": 31}, "gaitsetpy.core.base_classes.BaseDatasetLoader.name": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseDatasetLoader.description": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseDatasetLoader.data": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseDatasetLoader.metadata": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseDatasetLoader.max_workers": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseDatasetLoader.load_data": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 35}, "gaitsetpy.core.base_classes.BaseDatasetLoader.create_sliding_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 48}, "gaitsetpy.core.base_classes.BaseDatasetLoader.get_supported_formats": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.core.base_classes.BaseDatasetLoader.download_files_concurrent": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 97, "bases": 0, "doc": 85}, "gaitsetpy.core.base_classes.BaseDatasetLoader.set_max_workers": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.core.base_classes.BaseDatasetLoader.get_download_stats": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 20}, "gaitsetpy.core.base_classes.BaseDatasetLoader.get_info": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 15}, "gaitsetpy.core.base_classes.BaseFeatureExtractor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.name": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.description": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.extract_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 33}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.configure": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.core.base_classes.BaseFeatureExtractor.get_info": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.core.base_classes.BasePreprocessor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 23}, "gaitsetpy.core.base_classes.BasePreprocessor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 19}, "gaitsetpy.core.base_classes.BasePreprocessor.name": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BasePreprocessor.description": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BasePreprocessor.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BasePreprocessor.fitted": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BasePreprocessor.fit": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.core.base_classes.BasePreprocessor.transform": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.core.base_classes.BasePreprocessor.fit_transform": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.core.base_classes.BasePreprocessor.configure": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 12}, "gaitsetpy.core.base_classes.BasePreprocessor.get_info": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 15}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.name": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.description": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.analyze": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.visualize": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 21}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.configure": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.core.base_classes.BaseEDAAnalyzer.get_info": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.core.base_classes.BaseClassificationModel": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 25}, "gaitsetpy.core.base_classes.BaseClassificationModel.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 22}, "gaitsetpy.core.base_classes.BaseClassificationModel.name": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseClassificationModel.description": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseClassificationModel.model": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseClassificationModel.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseClassificationModel.trained": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.core.base_classes.BaseClassificationModel.train": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 20}, "gaitsetpy.core.base_classes.BaseClassificationModel.predict": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 28}, "gaitsetpy.core.base_classes.BaseClassificationModel.evaluate": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 27}, "gaitsetpy.core.base_classes.BaseClassificationModel.save_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.core.base_classes.BaseClassificationModel.load_model": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.core.base_classes.BaseClassificationModel.configure": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 13}, "gaitsetpy.core.base_classes.BaseClassificationModel.get_info": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 16}, "gaitsetpy.core.managers": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 31}, "gaitsetpy.core.managers.SingletonMeta": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "gaitsetpy.core.managers.BaseManager": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "gaitsetpy.core.managers.BaseManager.register": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 23}, "gaitsetpy.core.managers.BaseManager.unregister": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 16}, "gaitsetpy.core.managers.BaseManager.get_available_components": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.core.managers.BaseManager.get_component_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 28}, "gaitsetpy.core.managers.BaseManager.create_instance": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 46}, "gaitsetpy.core.managers.BaseManager.get_cached_instance": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 44}, "gaitsetpy.core.managers.DatasetManager": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 8}, "gaitsetpy.core.managers.DatasetManager.register_dataset": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.managers.DatasetManager.load_dataset": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 40}, "gaitsetpy.core.managers.FeatureManager": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 8}, "gaitsetpy.core.managers.FeatureManager.register_extractor": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.managers.FeatureManager.extract_features": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 41}, "gaitsetpy.core.managers.PreprocessingManager": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 7}, "gaitsetpy.core.managers.PreprocessingManager.register_preprocessor": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 20}, "gaitsetpy.core.managers.PreprocessingManager.preprocess_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 33}, "gaitsetpy.core.managers.EDAManager": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 8}, "gaitsetpy.core.managers.EDAManager.register_analyzer": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.managers.EDAManager.analyze_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 35}, "gaitsetpy.core.managers.EDAManager.visualize_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 29}, "gaitsetpy.core.managers.ClassificationManager": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 8}, "gaitsetpy.core.managers.ClassificationManager.register_model": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 22}, "gaitsetpy.core.managers.ClassificationManager.train_model": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 33}, "gaitsetpy.core.managers.ClassificationManager.predict": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 34}, "gaitsetpy.core.managers.ClassificationManager.evaluate_model": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 33}, "gaitsetpy.dataset": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 105}, "gaitsetpy.dataset.DaphnetLoader": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.dataset.DaphnetLoader.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.DaphnetLoader.metadata": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.DaphnetLoader.load_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.dataset.DaphnetLoader.create_sliding_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.dataset.DaphnetLoader.get_supported_formats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.DaphnetLoader.get_sensor_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.DaphnetLoader.get_annotation_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "gaitsetpy.dataset.MobiFallLoader": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.dataset.MobiFallLoader.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.MobiFallLoader.metadata": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.MobiFallLoader.load_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.dataset.MobiFallLoader.create_sliding_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.dataset.MobiFallLoader.get_supported_formats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.MobiFallLoader.get_sensor_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.MobiFallLoader.get_activity_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.dataset.ArduousLoader": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.dataset.ArduousLoader.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.ArduousLoader.metadata": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.ArduousLoader.load_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.dataset.ArduousLoader.create_sliding_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.dataset.ArduousLoader.get_supported_formats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.ArduousLoader.get_sensor_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.ArduousLoader.get_activity_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.dataset.PhysioNetLoader": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 54}, "gaitsetpy.dataset.PhysioNetLoader.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.PhysioNetLoader.metadata": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.PhysioNetLoader.labels": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.PhysioNetLoader.subject_types": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.PhysioNetLoader.load_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 38}, "gaitsetpy.dataset.PhysioNetLoader.create_sliding_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 65}, "gaitsetpy.dataset.PhysioNetLoader.get_supported_formats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.PhysioNetLoader.get_sensor_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.PhysioNetLoader.get_subject_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.dataset.PhysioNetLoader.get_labels": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.dataset.PhysioNetLoader.filter_by_subject_type": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 28}, "gaitsetpy.dataset.HARUPLoader": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 30}, "gaitsetpy.dataset.HARUPLoader.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 25}, "gaitsetpy.dataset.HARUPLoader.metadata": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.HARUPLoader.features": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.HARUPLoader.download_harup_data": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 34}, "gaitsetpy.dataset.HARUPLoader.load_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 154, "bases": 0, "doc": 58}, "gaitsetpy.dataset.HARUPLoader.create_sliding_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 71}, "gaitsetpy.dataset.HARUPLoader.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 79, "bases": 0, "doc": 47}, "gaitsetpy.dataset.HARUPLoader.get_supported_formats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 21}, "gaitsetpy.dataset.HARUPLoader.get_sensor_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.HARUPLoader.get_activity_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "gaitsetpy.dataset.UrFallLoader": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 39}, "gaitsetpy.dataset.UrFallLoader.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.UrFallLoader.metadata": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.UrFallLoader.load_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 165, "bases": 0, "doc": 99}, "gaitsetpy.dataset.UrFallLoader.get_file_paths": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 117, "bases": 0, "doc": 61}, "gaitsetpy.dataset.UrFallLoader.create_sliding_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 61}, "gaitsetpy.dataset.UrFallLoader.get_supported_formats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.UrFallLoader.get_sensor_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 17}, "gaitsetpy.dataset.UrFallLoader.get_activity_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "gaitsetpy.dataset.UrFallLoader.get_feature_info": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 18}, "gaitsetpy.dataset.load_daphnet_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 29}, "gaitsetpy.dataset.create_sliding_windows": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 55}, "gaitsetpy.dataset.load_mobifall_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 19}, "gaitsetpy.dataset.load_arduous_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 19}, "gaitsetpy.dataset.load_physionet_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 28}, "gaitsetpy.dataset.create_physionet_windows": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 102, "bases": 0, "doc": 44}, "gaitsetpy.dataset.load_harup_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 60}, "gaitsetpy.dataset.create_harup_windows": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 62}, "gaitsetpy.dataset.extract_harup_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 48}, "gaitsetpy.dataset.load_urfall_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 113, "bases": 0, "doc": 59}, "gaitsetpy.dataset.create_urfall_windows": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 49}, "gaitsetpy.dataset.download_dataset": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 6}, "gaitsetpy.dataset.extract_dataset": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 6}, "gaitsetpy.dataset.sliding_window": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 3}, "gaitsetpy.dataset.get_dataset_manager": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.dataset.get_available_datasets": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 9}, "gaitsetpy.dataset.load_dataset": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 39}, "gaitsetpy.dataset.arduous": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "gaitsetpy.dataset.arduous.ArduousLoader": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.dataset.arduous.ArduousLoader.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.arduous.ArduousLoader.metadata": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.arduous.ArduousLoader.load_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.dataset.arduous.ArduousLoader.create_sliding_windows": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.dataset.arduous.ArduousLoader.get_supported_formats": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.arduous.ArduousLoader.get_sensor_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.arduous.ArduousLoader.get_activity_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.dataset.arduous.load_arduous_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 19}, "gaitsetpy.dataset.daphnet": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 24}, "gaitsetpy.dataset.daphnet.DaphnetLoader": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.dataset.daphnet.DaphnetLoader.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.daphnet.DaphnetLoader.metadata": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.daphnet.DaphnetLoader.load_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.dataset.daphnet.DaphnetLoader.create_sliding_windows": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.dataset.daphnet.DaphnetLoader.get_supported_formats": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.daphnet.DaphnetLoader.get_sensor_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.daphnet.DaphnetLoader.get_annotation_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "gaitsetpy.dataset.daphnet.load_daphnet_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 29}, "gaitsetpy.dataset.daphnet.create_sliding_windows": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 55}, "gaitsetpy.dataset.daphnet.plot_dataset_sample": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.dataset.daphnet.plot_sliding_window": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.dataset.harup": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 65}, "gaitsetpy.dataset.harup.HARUPLoader": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 30}, "gaitsetpy.dataset.harup.HARUPLoader.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 25}, "gaitsetpy.dataset.harup.HARUPLoader.metadata": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.harup.HARUPLoader.features": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.harup.HARUPLoader.download_harup_data": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 34}, "gaitsetpy.dataset.harup.HARUPLoader.load_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 154, "bases": 0, "doc": 58}, "gaitsetpy.dataset.harup.HARUPLoader.create_sliding_windows": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 71}, "gaitsetpy.dataset.harup.HARUPLoader.extract_features": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 79, "bases": 0, "doc": 47}, "gaitsetpy.dataset.harup.HARUPLoader.get_supported_formats": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 21}, "gaitsetpy.dataset.harup.HARUPLoader.get_sensor_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.harup.HARUPLoader.get_activity_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "gaitsetpy.dataset.harup.load_harup_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 60}, "gaitsetpy.dataset.harup.create_harup_windows": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 62}, "gaitsetpy.dataset.harup.extract_harup_features": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 48}, "gaitsetpy.dataset.mobifall": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "gaitsetpy.dataset.mobifall.MobiFallLoader": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 23}, "gaitsetpy.dataset.mobifall.MobiFallLoader.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.mobifall.MobiFallLoader.metadata": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.mobifall.MobiFallLoader.load_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 37}, "gaitsetpy.dataset.mobifall.MobiFallLoader.create_sliding_windows": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 60}, "gaitsetpy.dataset.mobifall.MobiFallLoader.get_supported_formats": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.mobifall.MobiFallLoader.get_sensor_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.mobifall.MobiFallLoader.get_activity_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 17}, "gaitsetpy.dataset.mobifall.load_mobifall_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 19}, "gaitsetpy.dataset.physionet": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 53}, "gaitsetpy.dataset.physionet.PhysioNetLoader": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 54}, "gaitsetpy.dataset.physionet.PhysioNetLoader.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.physionet.PhysioNetLoader.metadata": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.physionet.PhysioNetLoader.labels": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.physionet.PhysioNetLoader.subject_types": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.physionet.PhysioNetLoader.load_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 38}, "gaitsetpy.dataset.physionet.PhysioNetLoader.create_sliding_windows": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 65}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_supported_formats": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_sensor_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 17}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_subject_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 17}, "gaitsetpy.dataset.physionet.PhysioNetLoader.get_labels": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.dataset.physionet.PhysioNetLoader.filter_by_subject_type": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 28}, "gaitsetpy.dataset.physionet.load_physionet_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 28}, "gaitsetpy.dataset.physionet.create_physionet_windows": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 102, "bases": 0, "doc": 44}, "gaitsetpy.dataset.urfall": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 70}, "gaitsetpy.dataset.urfall.UrFallLoader": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 39}, "gaitsetpy.dataset.urfall.UrFallLoader.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 24}, "gaitsetpy.dataset.urfall.UrFallLoader.metadata": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.dataset.urfall.UrFallLoader.load_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 165, "bases": 0, "doc": 99}, "gaitsetpy.dataset.urfall.UrFallLoader.get_file_paths": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 117, "bases": 0, "doc": 61}, "gaitsetpy.dataset.urfall.UrFallLoader.create_sliding_windows": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 61}, "gaitsetpy.dataset.urfall.UrFallLoader.get_supported_formats": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 20}, "gaitsetpy.dataset.urfall.UrFallLoader.get_sensor_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 17}, "gaitsetpy.dataset.urfall.UrFallLoader.get_activity_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "gaitsetpy.dataset.urfall.UrFallLoader.get_feature_info": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 18}, "gaitsetpy.dataset.urfall.load_urfall_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 113, "bases": 0, "doc": 59}, "gaitsetpy.dataset.urfall.create_urfall_windows": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 49}, "gaitsetpy.dataset.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 21}, "gaitsetpy.dataset.utils.download_dataset": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 6}, "gaitsetpy.dataset.utils.download_daphnet_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 103}, "gaitsetpy.dataset.utils.download_mobifall_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 7}, "gaitsetpy.dataset.utils.download_arduous_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 7}, "gaitsetpy.dataset.utils.download_urfall_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 79, "bases": 0, "doc": 100}, "gaitsetpy.dataset.utils.extract_dataset": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 6}, "gaitsetpy.dataset.utils.extract_daphnet_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 7}, "gaitsetpy.dataset.utils.extract_mobifall_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 7}, "gaitsetpy.dataset.utils.extract_arduous_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 7}, "gaitsetpy.dataset.utils.extract_urfall_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 43}, "gaitsetpy.dataset.utils.sliding_window": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 3}, "gaitsetpy.dataset.utils.download_harup_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 65}, "gaitsetpy.dataset.utils.extract_harup_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 14}, "gaitsetpy.eda": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 82}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 22}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.analyze": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.eda.DaphnetVisualizationAnalyzer.visualize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 25}, "gaitsetpy.eda.SensorStatisticsAnalyzer": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 33}, "gaitsetpy.eda.SensorStatisticsAnalyzer.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 22}, "gaitsetpy.eda.SensorStatisticsAnalyzer.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.eda.SensorStatisticsAnalyzer.analyze": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.eda.SensorStatisticsAnalyzer.visualize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 51, "bases": 0, "doc": 38}, "gaitsetpy.eda.plot_thigh_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.eda.plot_shank_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.eda.plot_trunk_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.eda.plot_all_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 61}, "gaitsetpy.eda.plot_all_thigh_data": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.eda.plot_all_shank_data": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.eda.plot_all_trunk_data": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.eda.plot_all_datasets": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 13}, "gaitsetpy.eda.plot_sensor_with_features": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 184}, "gaitsetpy.eda.get_eda_manager": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 8}, "gaitsetpy.eda.get_available_analyzers": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 10}, "gaitsetpy.eda.analyze_data": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 34}, "gaitsetpy.eda.visualize_data": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 28}, "gaitsetpy.eda.plot_daphnet_data": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 49}, "gaitsetpy.eda.analyze_sensor_statistics": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 29}, "gaitsetpy.eda.plot_sensor_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 59}, "gaitsetpy.eda.analyzers": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 35}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 22}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.config": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.analyze": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.eda.analyzers.DaphnetVisualizationAnalyzer.visualize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 25}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 33}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 22}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.config": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.analyze": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 28}, "gaitsetpy.eda.analyzers.SensorStatisticsAnalyzer.visualize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 51, "bases": 0, "doc": 38}, "gaitsetpy.eda.analyzers.harup_basic_stats": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 34}, "gaitsetpy.eda.analyzers.harup_missing_data_report": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 36}, "gaitsetpy.eda.analyzers.harup_activity_stats": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 35}, "gaitsetpy.eda.statistics": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "gaitsetpy.eda.statistics.plot_sensor_with_features": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 184}, "gaitsetpy.eda.visualization": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 43}, "gaitsetpy.eda.visualization.plot_thigh_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.eda.visualization.plot_shank_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.eda.visualization.plot_trunk_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 38}, "gaitsetpy.eda.visualization.plot_all_thigh_data": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.eda.visualization.plot_all_shank_data": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.eda.visualization.plot_all_trunk_data": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.eda.visualization.plot_all_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 61}, "gaitsetpy.eda.visualization.plot_all_datasets": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 13}, "gaitsetpy.eda.visualization.plot_sensor_timeseries": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 45}, "gaitsetpy.eda.visualization.plot_all_sensors": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 54}, "gaitsetpy.eda.visualization.plot_activity_distribution": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 27}, "gaitsetpy.features": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 45}, "gaitsetpy.features.GaitFeatureExtractor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "gaitsetpy.features.GaitFeatureExtractor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.GaitFeatureExtractor.verbose": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.GaitFeatureExtractor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.GaitFeatureExtractor.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 41}, "gaitsetpy.features.GaitFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 19}, "gaitsetpy.features.GaitFeatureExtractor.print_extraction_summary": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 22}, "gaitsetpy.features.LBPFeatureExtractor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 32}, "gaitsetpy.features.LBPFeatureExtractor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.LBPFeatureExtractor.verbose": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.LBPFeatureExtractor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.LBPFeatureExtractor.lbp_1d": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 33}, "gaitsetpy.features.LBPFeatureExtractor.lbp_to_histogram": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 37}, "gaitsetpy.features.LBPFeatureExtractor.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 34}, "gaitsetpy.features.LBPFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 8}, "gaitsetpy.features.FourierSeriesFeatureExtractor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "gaitsetpy.features.FourierSeriesFeatureExtractor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.FourierSeriesFeatureExtractor.verbose": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.FourierSeriesFeatureExtractor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.FourierSeriesFeatureExtractor.fit_fourier_series": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 38}, "gaitsetpy.features.FourierSeriesFeatureExtractor.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 32}, "gaitsetpy.features.FourierSeriesFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 9}, "gaitsetpy.features.PhysioNetFeatureExtractor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 30}, "gaitsetpy.features.PhysioNetFeatureExtractor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.PhysioNetFeatureExtractor.verbose": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.PhysioNetFeatureExtractor.lbp_extractor": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.PhysioNetFeatureExtractor.fourier_extractor": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.PhysioNetFeatureExtractor.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 31}, "gaitsetpy.features.PhysioNetFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 8}, "gaitsetpy.features.HARUPFeatureExtractor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 36}, "gaitsetpy.features.HARUPFeatureExtractor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 18}, "gaitsetpy.features.HARUPFeatureExtractor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.HARUPFeatureExtractor.time_domain_features": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.HARUPFeatureExtractor.freq_domain_features": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.HARUPFeatureExtractor.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 33}, "gaitsetpy.features.HARUPFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.features.UrFallMediaFeatureExtractor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 47}, "gaitsetpy.features.UrFallMediaFeatureExtractor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.UrFallMediaFeatureExtractor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.UrFallMediaFeatureExtractor.extract_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 33}, "gaitsetpy.features.UrFallMediaFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.features.extract_lbp_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 31}, "gaitsetpy.features.extract_fourier_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 32}, "gaitsetpy.features.extract_physionet_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 32}, "gaitsetpy.features.extract_harup_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 106, "bases": 0, "doc": 53}, "gaitsetpy.features.calculate_mean": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.calculate_standard_deviation": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 24}, "gaitsetpy.features.calculate_variance": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 21}, "gaitsetpy.features.calculate_skewness": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.calculate_kurtosis": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.features.calculate_root_mean_square": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.calculate_range": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.calculate_median": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.calculate_mode": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.calculate_mean_absolute_value": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.calculate_median_absolute_deviation": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.calculate_peak_height": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.features.calculate_stride_times": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 33}, "gaitsetpy.features.calculate_step_time": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "gaitsetpy.features.calculate_cadence": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.features.calculate_freezing_index": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 29}, "gaitsetpy.features.calculate_dominant_frequency": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.features.calculate_peak_frequency": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.features.calculate_power_spectral_entropy": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "gaitsetpy.features.calculate_principal_harmonic_frequency": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "gaitsetpy.features.calculate_entropy": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.features.calculate_interquartile_range": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.features.calculate_correlation": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 9}, "gaitsetpy.features.calculate_auto_regression_coefficients": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 11}, "gaitsetpy.features.get_mean_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_standard_deviation_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_variance_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_skewness_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_kurtosis_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 12}, "gaitsetpy.features.get_root_mean_square_for_windows": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_range_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_median_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_mode_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_mean_absolute_value_for_windows": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_median_absolute_deviation_for_windows": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_peak_height_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_stride_times_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.features.get_step_times_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.features.get_cadence_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.get_freezing_index_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.get_dominant_frequency_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.get_peak_frequency_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.get_power_spectral_entropy_for_windows": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.get_principal_harmonic_frequency_for_windows": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.get_entropy_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_interquartile_range_for_windows": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_correlation_for_windows": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.get_auto_regression_coefficients_for_windows": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 3}, "gaitsetpy.features.extract_gait_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 60}, "gaitsetpy.features.gait_features": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 28}, "gaitsetpy.features.gait_features.logger": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.GaitFeatureExtractor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.verbose": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.extract_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 41}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 19}, "gaitsetpy.features.gait_features.GaitFeatureExtractor.print_extraction_summary": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 22}, "gaitsetpy.features.gait_features.get_stride_times_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.features.gait_features.get_zero_crossing_rates_for_windows": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 13}, "gaitsetpy.features.gait_features.get_freezing_indices_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.features.gait_features.get_standard_deviations_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 12}, "gaitsetpy.features.gait_features.get_entropies_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.gait_features.get_energies_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.gait_features.get_variances_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.gait_features.get_kurtosis_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 12}, "gaitsetpy.features.gait_features.get_step_times_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.features.gait_features.get_mean_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_standard_deviation_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_variance_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_skewness_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_root_mean_square_for_windows": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_range_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_median_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_mode_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_mean_absolute_value_for_windows": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_median_absolute_deviation_for_windows": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_peak_height_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_cadence_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_freezing_index_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_dominant_frequency_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_peak_frequency_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_power_spectral_entropy_for_windows": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_principal_harmonic_frequency_for_windows": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_entropy_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_interquartile_range_for_windows": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_correlation_for_windows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.get_auto_regression_coefficients_for_windows": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 3}, "gaitsetpy.features.gait_features.extract_gait_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 60}, "gaitsetpy.features.harup_features": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 62}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 36}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 18}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.time_domain_features": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.freq_domain_features": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.extract_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 33}, "gaitsetpy.features.harup_features.HARUPFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.features.harup_features.extract_harup_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 106, "bases": 0, "doc": 53}, "gaitsetpy.features.physionet_features": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 31}, "gaitsetpy.features.physionet_features.logger": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 32}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.verbose": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.lbp_1d": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 33}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.lbp_to_histogram": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 37}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.extract_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 34}, "gaitsetpy.features.physionet_features.LBPFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 8}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.verbose": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.fit_fourier_series": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 38}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.extract_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 32}, "gaitsetpy.features.physionet_features.FourierSeriesFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 9}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 30}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.verbose": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.lbp_extractor": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.fourier_extractor": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.extract_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 31}, "gaitsetpy.features.physionet_features.PhysioNetFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 8}, "gaitsetpy.features.physionet_features.extract_lbp_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 31}, "gaitsetpy.features.physionet_features.extract_fourier_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 32}, "gaitsetpy.features.physionet_features.extract_physionet_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 32}, "gaitsetpy.features.urfall_features": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 42}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 47}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.config": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.extract_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 33}, "gaitsetpy.features.urfall_features.UrFallMediaFeatureExtractor.get_feature_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 18}, "gaitsetpy.features.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.features.utils.calculate_stride_times": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 33}, "gaitsetpy.features.utils.calculate_zero_crossing_rate": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 25}, "gaitsetpy.features.utils.calculate_power": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 44}, "gaitsetpy.features.utils.calculate_freezing_index": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 29}, "gaitsetpy.features.utils.calculate_standard_deviation": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 24}, "gaitsetpy.features.utils.calculate_entropy": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.features.utils.calculate_energy": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 21}, "gaitsetpy.features.utils.calculate_variance": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 21}, "gaitsetpy.features.utils.calculate_kurtosis": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 22}, "gaitsetpy.features.utils.calculate_step_time": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "gaitsetpy.features.utils.calculate_mean": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.utils.calculate_max": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.features.utils.calculate_min": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.features.utils.calculate_median": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.utils.calculate_skewness": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.utils.calculate_root_mean_square": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.utils.calculate_range": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.utils.calculate_correlation": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 9}, "gaitsetpy.features.utils.calculate_dominant_frequency": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.features.utils.calculate_peak_height": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.features.utils.calculate_interquartile_range": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "gaitsetpy.features.utils.calculate_mode": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "gaitsetpy.features.utils.calculate_cadence": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "gaitsetpy.features.utils.calculate_mean_absolute_value": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.utils.calculate_median_absolute_deviation": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 11}, "gaitsetpy.features.utils.calculate_peak_frequency": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.features.utils.calculate_peak_width": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 10}, "gaitsetpy.features.utils.calculate_power_spectral_entropy": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "gaitsetpy.features.utils.calculate_principal_harmonic_frequency": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "gaitsetpy.features.utils.calculate_auto_regression_coefficients": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 11}, "gaitsetpy.main": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "gaitsetpy.preprocessing": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 86}, "gaitsetpy.preprocessing.ClippingPreprocessor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.preprocessing.ClippingPreprocessor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 19}, "gaitsetpy.preprocessing.ClippingPreprocessor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.preprocessing.ClippingPreprocessor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "gaitsetpy.preprocessing.ClippingPreprocessor.transform": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 30}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 19}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 24}, "gaitsetpy.preprocessing.NoiseRemovalPreprocessor.transform": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 28}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 19}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.mean_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.std_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 24}, "gaitsetpy.preprocessing.OutlierRemovalPreprocessor.transform": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 30}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 11}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 19}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.mean_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 22}, "gaitsetpy.preprocessing.BaselineRemovalPreprocessor.transform": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 26}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 19}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.config": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 24}, "gaitsetpy.preprocessing.DriftRemovalPreprocessor.transform": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 29}, "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "gaitsetpy.preprocessing.HighFrequencyNoiseRemovalPreprocessor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 19}, "gaitsetpy.preprocess