"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const path = require("path");
const assets = require("../lib");
class TestStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // The template must contain at least one resource, so there is this...
        new iam.User(this, 'DummyResource');
        // Check that the same asset added multiple times is
        // uploaded and copied.
        new assets.Asset(this, 'SampleAsset1', {
            path: path.join(__dirname, 'file-asset.txt')
        });
        new assets.Asset(this, 'SampleAsset2', {
            path: path.join(__dirname, 'file-asset.txt')
        });
    }
}
const app = new cdk.App();
new TestStack(app, 'aws-cdk-multi-assets');
app.synth();
//# sourceMappingURL=data:application/json;base64,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