# mypy-boto3-workspaces

[![PyPI - mypy-boto3-workspaces](https://img.shields.io/pypi/v/mypy-boto3-workspaces.svg?color=blue)](https://pypi.org/project/mypy-boto3-workspaces)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workspaces.svg?color=blue)](https://pypi.org/project/mypy-boto3-workspaces)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.WorkSpaces 1.16.19](https://boto3.amazonaws.com/v1/documentation/api/1.16.19/reference/services/workspaces.html#WorkSpaces) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-workspaces](#mypy-boto3-workspaces)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `WorkSpaces` service.

```bash
python -m pip install boto3-stubs[workspaces]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[workspaces]` in your environment: `python -m pip install 'boto3-stubs[workspaces]'`

Both type checking and auto-complete should work for `WorkSpaces` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[workspaces]` in your environment: `python -m pip install 'boto3-stubs[workspaces]'`

Both type checking and auto-complete should work for `WorkSpaces` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[workspaces]` in your environment: `python -m pip install 'boto3-stubs[workspaces]'`
- Run `mypy` as usual

Type checking should work for `WorkSpaces` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[workspaces]` in your environment: `python -m pip install 'boto3-stubs[workspaces]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WorkSpaces` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`WorkSpacesClient` provides annotations for `boto3.client("workspaces")`.

```python
import boto3

from mypy_boto3_workspaces import WorkSpacesClient

client: WorkSpacesClient = boto3.client("workspaces")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkSpacesClient = session.client("workspaces")
```

### Paginators annotations

`mypy_boto3_workspaces.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_workspaces import WorkSpacesClient
from mypy_boto3_workspaces.paginator import (
    DescribeAccountModificationsPaginator,
    DescribeIpGroupsPaginator,
    DescribeWorkspaceBundlesPaginator,
    DescribeWorkspaceDirectoriesPaginator,
    DescribeWorkspaceImagesPaginator,
    DescribeWorkspacesConnectionStatusPaginator,
    DescribeWorkspacesPaginator,
    ListAvailableManagementCidrRangesPaginator,
)

client: WorkSpacesClient = boto3.client("workspaces")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_account_modifications_paginator: DescribeAccountModificationsPaginator = client.get_paginator("describe_account_modifications")
describe_ip_groups_paginator: DescribeIpGroupsPaginator = client.get_paginator("describe_ip_groups")
describe_workspace_bundles_paginator: DescribeWorkspaceBundlesPaginator = client.get_paginator("describe_workspace_bundles")
describe_workspace_directories_paginator: DescribeWorkspaceDirectoriesPaginator = client.get_paginator("describe_workspace_directories")
describe_workspace_images_paginator: DescribeWorkspaceImagesPaginator = client.get_paginator("describe_workspace_images")
describe_workspaces_paginator: DescribeWorkspacesPaginator = client.get_paginator("describe_workspaces")
describe_workspaces_connection_status_paginator: DescribeWorkspacesConnectionStatusPaginator = client.get_paginator("describe_workspaces_connection_status")
list_available_management_cidr_ranges_paginator: ListAvailableManagementCidrRangesPaginator = client.get_paginator("list_available_management_cidr_ranges")
```







### Typed dictionations

`mypy_boto3_workspaces.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_workspaces.type_defs import (
    AccountModificationTypeDef,
    AssociateConnectionAliasResultTypeDef,
    ClientPropertiesResultTypeDef,
    ClientPropertiesTypeDef,
    ComputeTypeTypeDef,
    ConnectionAliasAssociationTypeDef,
    ConnectionAliasPermissionTypeDef,
    ConnectionAliasTypeDef,
    CopyWorkspaceImageResultTypeDef,
    CreateConnectionAliasResultTypeDef,
    CreateIpGroupResultTypeDef,
    CreateWorkspacesResultTypeDef,
    DefaultWorkspaceCreationPropertiesTypeDef,
    DescribeAccountModificationsResultTypeDef,
    DescribeAccountResultTypeDef,
    DescribeClientPropertiesResultTypeDef,
    DescribeConnectionAliasesResultTypeDef,
    DescribeConnectionAliasPermissionsResultTypeDef,
    DescribeIpGroupsResultTypeDef,
    DescribeTagsResultTypeDef,
    DescribeWorkspaceBundlesResultTypeDef,
    DescribeWorkspaceDirectoriesResultTypeDef,
    DescribeWorkspaceImagePermissionsResultTypeDef,
    DescribeWorkspaceImagesResultTypeDef,
    DescribeWorkspacesConnectionStatusResultTypeDef,
    DescribeWorkspaceSnapshotsResultTypeDef,
    DescribeWorkspacesResultTypeDef,
    FailedCreateWorkspaceRequestTypeDef,
    FailedWorkspaceChangeRequestTypeDef,
    ImagePermissionTypeDef,
    ImportWorkspaceImageResultTypeDef,
    IpRuleItemTypeDef,
    ListAvailableManagementCidrRangesResultTypeDef,
    MigrateWorkspaceResultTypeDef,
    ModificationStateTypeDef,
    OperatingSystemTypeDef,
    PaginatorConfigTypeDef,
    RebootRequestTypeDef,
    RebootWorkspacesResultTypeDef,
    RebuildRequestTypeDef,
    RebuildWorkspacesResultTypeDef,
    RootStorageTypeDef,
    SelfservicePermissionsTypeDef,
    SnapshotTypeDef,
    StartRequestTypeDef,
    StartWorkspacesResultTypeDef,
    StopRequestTypeDef,
    StopWorkspacesResultTypeDef,
    TagTypeDef,
    TerminateRequestTypeDef,
    TerminateWorkspacesResultTypeDef,
    UserStorageTypeDef,
    WorkspaceAccessPropertiesTypeDef,
    WorkspaceBundleTypeDef,
    WorkspaceConnectionStatusTypeDef,
    WorkspaceCreationPropertiesTypeDef,
    WorkspaceDirectoryTypeDef,
    WorkspaceImageTypeDef,
    WorkspacePropertiesTypeDef,
    WorkspaceRequestTypeDef,
    WorkspacesIpGroupTypeDef,
    WorkspaceTypeDef,
)

def get_structure() -> AccountModificationTypeDef:
    return {
      ...
    }
```
