# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2025-11-13T18:32:12+00:00

from __future__ import annotations

from datetime import timedelta
from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import AnyUrl, AwareDatetime, BaseModel, EmailStr, Field, RootModel


class ActionTooLongEvent(BaseModel):
    type: Literal['action-too-long'] = Field('action-too-long', title='Type')
    filler: str = Field(
        ...,
        description='A filler that can be played while waiting for the action to complete. If the audio filler exists, this is monochannel, 16-bit PCM WAV audio (at sample rate 16kHz) encoded in base64 encoding.\nOtherwise, this is the text corresponding to the audio filler.',
        title='Filler',
    )
    previously_started_event: Any = Field(
        ...,
        description='The previously started event that is taking too long.',
        title='Previously Started Event',
    )


class AnnotationStateInputNextState(RootModel[List]):
    root: List = Field(..., max_length=2, min_length=2, title='Next State')


class AnnotationStateOutputNextState(RootModel[List]):
    root: List = Field(
        ...,
        description="The state to transition to after the inner thought message is generated. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        max_length=2,
        min_length=2,
        title='Next State',
    )


class AnnotationStateOutput(BaseModel):
    type: Literal['annotation'] = Field(..., title='Type')
    name: str = Field(..., description='The name of this state.', title='Name')
    inner_thought: str = Field(
        ...,
        description='The inner thought to add to the conversation.',
        title='Inner Thought',
    )
    next_state: Union[str, AnnotationStateOutputNextState] = Field(
        ...,
        description="The state to transition to after the inner thought message is generated. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        title='Next State',
    )


class AnnotationStateTransitionLog(BaseModel):
    previous_state: str = Field(
        ...,
        description='Name of the previous state to transition from.',
        title='Previous State',
    )
    previous_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the previous state is in.',
        max_length=2,
        min_length=2,
        title='Previous Service Hierarchical State Machine Version Info',
    )
    next_state: str = Field(
        ..., description='Name of the next state to transition to.', title='Next State'
    )
    next_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the next state is in.',
        max_length=2,
        min_length=2,
        title='Next Service Hierarchical State Machine Version Info',
    )
    type: Literal['annotation'] = Field(
        'annotation',
        description="The type of the state transition log, which is the type of the state we're transitioning from.",
        title='Type',
    )
    inner_thought_message_id: str = Field(
        ...,
        description='The identifier of the inserted inner thought message.',
        title='Inner Thought Message Id',
    )


class BooleanMetricSuccessCriterion(BaseModel):
    type: Literal['boolean'] = Field(..., title='Type')
    expected_value: bool = Field(..., title='Expected Value')


class BooleanMetricValue(BaseModel):
    type: Literal['boolean'] = Field(..., title='Type')


class CategoricalMetricSuccessCriterionOutput(BaseModel):
    type: Literal['categorical'] = Field(..., title='Type')
    expected_values: List[str] = Field(..., title='Expected Values')


class CategoricalMetricValueOutput(BaseModel):
    type: Literal['categorical'] = Field(..., title='Type')
    categories: List[str] = Field(..., title='Categories')


class CheckIfActiveMemoryNeededAgentActionEvent(BaseModel):
    type: Literal['check-if-active-memory-needed-completed'] = Field(
        'check-if-active-memory-needed-completed', title='Type'
    )
    queries: List[str] = Field(..., title='Queries')


class Column(BaseModel):
    name: str = Field(..., description='The name of the column.', title='Name')
    type: str = Field(..., description='The data type of the column.', title='Type')


class ConversationByTimeMetricInputGranularity(Enum):
    hour = 'hour'
    day = 'day'
    week = 'week'
    month = 'month'


class ConversationByTimeMetricInput(BaseModel):
    type: Literal['conversation-by-time'] = Field(..., title='Type')
    starts: AwareDatetime = Field(
        ...,
        description='The start of the interval to compute the count of conversations in.',
        title='Starts',
    )
    ends: AwareDatetime = Field(
        ...,
        description='The end of the interval to compute the count of conversations in.',
        title='Ends',
    )
    granularity: ConversationByTimeMetricInputGranularity = Field(
        ...,
        description='The granularity of time to bucket the conversations in. For instance, if set to `hour`, the count of conversations for each hour will be computed.',
        title='Granularity',
    )


class ConversationByTimeMetricOutputConversationCount(RootModel[List]):
    root: List = Field(..., max_length=2, min_length=2)


class ConversationByTimeMetricOutput(BaseModel):
    type: Literal['conversation-by-time'] = Field('conversation-by-time', title='Type')
    conversation_counts: List[ConversationByTimeMetricOutputConversationCount] = Field(
        ...,
        description='An array of 2-tuples, where the first element is the start of the time range represented by this tuple, and the second element is the number of conversations in the range `[start, start + granularity)`.',
        title='Conversation Counts',
    )


class ConversationCreatedEvent(BaseModel):
    type: Literal['conversation-created'] = Field('conversation-created', title='Type')
    conversation_id: str = Field(
        ...,
        description='The identifier of the newly created conversation.',
        title='Conversation Id',
    )


class DeliveryAttempt(BaseModel):
    delivery_time: AwareDatetime = Field(
        ...,
        description='The time of the delivery attempt in UTC.',
        title='Delivery Time',
    )
    status_code: int = Field(
        ...,
        description='The HTTP status code of the delivery attempt.',
        title='Status Code',
    )


class DynamicBehaviorInvocation(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    conversation_id: str = Field(
        ..., description='The ID of the conversation.', title='Conversation Id'
    )
    service_id: str = Field(
        ...,
        description='The ID of the service that the conversation belongs to.',
        title='Service Id',
    )
    user_id: str = Field(
        ...,
        description='The ID of the user that triggered the dynamic behavior.',
        title='User Id',
    )
    initial_message_id: str = Field(
        ...,
        description='The ID of the initial message that led to the dynamic behavior invocation.',
        title='Initial Message Id',
    )
    agent_message_id: Optional[str] = Field(
        ...,
        description='The ID of the agent message that led to the dynamic behavior invocation.',
        title='Agent Message Id',
    )
    agent_inner_thoughts_ids: List[str] = Field(
        ...,
        description='The IDs of the agent inner thoughts that led to the dynamic behavior invocation.',
        title='Agent Inner Thoughts Ids',
    )
    dynamic_behavior_set_version_info: List = Field(
        ...,
        description='The ID and version number of the dynamic behavior set version that was activated.',
        max_length=2,
        min_length=2,
        title='Dynamic Behavior Set Version Info',
    )
    invoked_at: AwareDatetime = Field(
        ...,
        description='The time when the dynamic behavior was invoked.',
        title='Invoked At',
    )
    external_event_message_ids: Optional[List[str]] = Field(
        [],
        description="The IDs of the external event messages that were considered during the invocation. These do not include the initial message if it's an external event.",
        title='External Event Message Ids',
    )


class EndSessionEvent(BaseModel):
    type: Literal['end-session'] = Field('end-session', title='Type')


class EngageUserDynamicBehaviorOverrideEvent(BaseModel):
    type: Literal['engage-user-dynamic-behavior-override'] = Field(
        'engage-user-dynamic-behavior-override', title='Type'
    )
    overriding: bool = Field(
        ...,
        description="Whether the dynamic behavior set's instructions are overriding the existing instructions of the current state.",
        title='Overriding',
    )


class EngageUserInvocationMetadata(BaseModel):
    type: Literal['engage-user'] = Field('engage-user', title='Type')
    current_state_machine_and_version: List = Field(
        ...,
        description='The ID and version of the state machine that is currently being executed.',
        max_length=2,
        min_length=2,
        title='Current State Machine And Version',
    )
    tool_call_round_index: int = Field(
        ...,
        description='The index of the tool call round.',
        title='Tool Call Round Index',
    )


class EngageUserMessageFragmentGeneratedEvent(BaseModel):
    type: Literal['engage-user-message-fragment-generated'] = Field(
        'engage-user-message-fragment-generated', title='Type'
    )
    index: int = Field(
        ...,
        description='The index of the fragment in the agent response.',
        title='Index',
    )
    fragment: str = Field(
        ...,
        description='The fragment of the agent response that has been generated.',
        title='Fragment',
    )
    is_final: bool = Field(
        ...,
        description='Whether this fragment is the final fragment of the agent response.',
        title='Is Final',
    )


class EqualCondition(BaseModel):
    type: Literal['Equals'] = Field('Equals', title='Type')
    value: Any = Field(
        ...,
        description='The value that the attribute must be equal to. It must be of the same type as the type of this attribute in the permission.',
        title='Value',
    )


class ErrorEvent(BaseModel):
    type: Literal['error'] = Field('error', title='Type')
    http_error_code: int = Field(
        ..., description='The HTTP status code of the error.', title='Http Error Code'
    )
    error_description: str = Field(
        ..., description='A description of the error.', title='Error Description'
    )


class EvaluationSourceType(Enum):
    post_session = 'post-session'
    manual = 'manual'
    simulation = 'simulation'


class ExitConditionOutputNextState(RootModel[List]):
    root: List = Field(
        ...,
        description="The state to transition to if this exit condition is met. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        max_length=2,
        min_length=2,
        title='Next State',
    )


class ExitConditionOutput(BaseModel):
    description: str = Field(
        ..., description='A description of this exit condition.', title='Description'
    )
    next_state: Union[str, ExitConditionOutputNextState] = Field(
        ...,
        description="The state to transition to if this exit condition is met. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        title='Next State',
    )


class ExternalStateName(RootModel[str]):
    root: str = Field(..., pattern='^[A-Za-z0-9_]+\\.[A-Za-z0-9_]+$')


class ExtractActiveMemoriesAgentActionEventQueriesAndResponse(
    ConversationByTimeMetricOutputConversationCount
):
    pass


class ExtractActiveMemoriesAgentActionEvent(BaseModel):
    type: Literal['extract-active-memories-completed'] = Field(
        'extract-active-memories-completed', title='Type'
    )
    queries_and_responses: List[
        ExtractActiveMemoriesAgentActionEventQueriesAndResponse
    ] = Field(..., title='Queries And Responses')


class FailedInvocationResult(BaseModel):
    succeeded: Literal['False'] = Field(..., title='Succeeded')
    exception_message: str = Field(
        ...,
        description='The message of the exception during the tool invocation.',
        title='Exception Message',
    )
    exception_type: str = Field(
        ...,
        description='The type of the exception during the tool invocation.',
        title='Exception Type',
    )
    exception_stack_trace: List[str] = Field(
        ...,
        description='The stack trace of the exception during the tool invocation.',
        title='Exception Stack Trace',
    )
    duration_ms: int = Field(
        ...,
        description='The duration of the tool invocation in milliseconds.',
        title='Duration Ms',
    )


class FailedInvocationStatus(BaseModel):
    succeeded: Literal['False'] = Field(..., title='Succeeded')
    exception_message: str = Field(
        ...,
        description='The exception message if the tool invocation failed.',
        title='Exception Message',
    )
    exception_type: str = Field(
        ...,
        description='The exception type if the tool invocation failed.',
        title='Exception Type',
    )
    exception_stack_trace: List[str] = Field(
        ...,
        description='The exception stack trace if the tool invocation failed.',
        title='Exception Stack Trace',
    )


class Format(Enum):
    text = 'text'
    voice = 'voice'


class FrontendView(Enum):
    client = 'client'
    admin = 'admin'


class GenerateToolParamsDesignatedToolCallParamsGeneratedEvent(BaseModel):
    type: Literal['designated-tool-call-params-generated'] = Field(
        'designated-tool-call-params-generated', title='Type'
    )
    tool_id: str = Field(
        ..., description='The ID of the tool being called.', title='Tool Id'
    )
    tool_version: str = Field(
        ..., description='The version of the tool being called.', title='Tool Version'
    )
    tool_call_params: Dict[str, Any] = Field(
        ..., description='The generated tool call parameters.', title='Tool Call Params'
    )


class GenerateToolParamsDesignatedToolRetrievedEvent(BaseModel):
    type: Literal['designated-tool-retrieved'] = Field(
        'designated-tool-retrieved', title='Type'
    )
    tool_id: str = Field(
        ..., description='The ID of the tool being called.', title='Tool Id'
    )
    tool_version: str = Field(
        ..., description='The version of the tool being called.', title='Tool Version'
    )


class InCondition(BaseModel):
    type: Literal['In'] = Field('In', title='Type')
    values: List = Field(
        ...,
        description='A list of values, one of which the attribute must be equal to. All values must be of the same type as the type of this attribute in the permission.',
        title='Values',
    )


class InitialMessageType(Enum):
    user_message = 'user-message'
    external_event = 'external-event'
    skip = 'skip'


class InteractionCompleteEvent(BaseModel):
    type: Literal['interaction-complete'] = Field('interaction-complete', title='Type')
    message_id: str = Field(
        ...,
        description='The identifier of the agent message in this interaction.',
        title='Message Id',
    )
    interaction_id: str = Field(
        ..., description='The identifier of this interaction.', title='Interaction Id'
    )
    full_message: str = Field(
        ...,
        description="A structure containing either the content of the message if it's text, or the transcript of the message if it's audio.",
        title='Full Message',
    )
    conversation_completed: bool = Field(
        ...,
        description='Whether the conversation is auto-completed after this interaction.',
        title='Conversation Completed',
    )


class JumpbackStateTransitionLog(BaseModel):
    previous_state: str = Field(
        ...,
        description='Name of the previous state to transition from.',
        title='Previous State',
    )
    previous_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the previous state is in.',
        max_length=2,
        min_length=2,
        title='Previous Service Hierarchical State Machine Version Info',
    )
    next_state: str = Field(
        ..., description='Name of the next state to transition to.', title='Next State'
    )
    next_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the next state is in.',
        max_length=2,
        min_length=2,
        title='Next Service Hierarchical State Machine Version Info',
    )
    type: Literal['jumpback'] = Field(
        'jumpback',
        description="The type of the state transition log, which is the type of the state we're transitioning from.",
        title='Type',
    )


class LLMLoadBalancingSetType(Enum):
    o4_mini_2025_04_16 = 'o4-mini-2025-04-16'
    gpt_5_2025_08_07 = 'gpt-5-2025-08-07'
    gpt_5_mini_2025_08_07 = 'gpt-5-mini-2025-08-07'
    gpt_5_nano_2025_08_07 = 'gpt-5-nano-2025-08-07'
    claude_sonnet_4_5_20250929 = 'claude-sonnet-4-5-20250929'


class LLMType(Enum):
    openai_o4_mini_2025_04_16 = 'openai_o4-mini-2025-04-16'
    openai_gpt_5_2025_08_07 = 'openai_gpt-5-2025-08-07'
    openai_gpt_5_mini_2025_08_07 = 'openai_gpt-5-mini-2025-08-07'
    openai_gpt_5_nano_2025_08_07 = 'openai_gpt-5-nano-2025-08-07'
    azure_o4_mini_2025_04_16 = 'azure_o4-mini-2025-04-16'
    azure_gpt_4_1_2025_04_14 = 'azure_gpt-4.1-2025-04-14'
    azure_gpt_4_1_mini_2025_04_14 = 'azure_gpt-4.1-mini-2025-04-14'
    azure_gpt_5_2025_08_07 = 'azure_gpt-5-2025-08-07'
    azure_gpt_5_mini_2025_08_07 = 'azure_gpt-5-mini-2025-08-07'
    azure_gpt_5_nano_2025_08_07 = 'azure_gpt-5-nano-2025-08-07'
    google_claude_sonnet_4_5_20250929 = 'google_claude-sonnet-4-5@20250929'
    aws_claude_sonnet_4_5_20250929 = 'aws_claude-sonnet-4-5-20250929'
    anthropic_claude_sonnet_4_5_20250929 = 'anthropic_claude-sonnet-4-5-20250929'
    google_gemini_2_5_pro = 'google_gemini-2.5-pro'
    google_gemini_2_5_flash = 'google_gemini-2.5-flash'


class MP3UserMessageAudioConfig(BaseModel):
    type: Literal['mp3'] = Field('mp3', title='Type')


class MemoryInstance(BaseModel):
    id: str = Field(..., description='The identifier of the memory.', title='Id')
    timestamp: AwareDatetime = Field(
        ..., description='The time at which this memory was created.', title='Timestamp'
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The time at which this memory was created.',
        title='Created At',
    )
    conversation_id: str = Field(
        ...,
        description='The ID of the conversation from where this memory was created.',
        title='Conversation Id',
    )
    references: List[str] = Field(
        ...,
        description='The identifiers of the messages that this memory references.',
        title='References',
    )
    content: str = Field(..., description='The content of the memory.', title='Content')
    context: str = Field(..., description='The context of the memory.', title='Context')


class MessageType(Enum):
    user_message = 'user-message'
    agent_message = 'agent-message'
    agent_inner_thought = 'agent-inner-thought'
    external_event = 'external-event'


class MetricValueType(Enum):
    boolean = 'boolean'
    numerical = 'numerical'
    categorical = 'categorical'


class NavigateStateMachineActionStateActionSelectedEvent(BaseModel):
    type: Literal['navigate-state-machine-action-state-action-selected'] = Field(
        'navigate-state-machine-action-state-action-selected', title='Type'
    )
    action: str = Field(..., title='Action')


class NavigateStateMachineAnnotationStateAnnotationRetrievedEvent(BaseModel):
    type: Literal['navigate-state-machine-annotation-state-annotation-retrieved'] = (
        Field(
            'navigate-state-machine-annotation-state-annotation-retrieved', title='Type'
        )
    )
    annotation: str = Field(..., title='Annotation')


class NavigateStateMachineDecisionStateDecisionStartedEvent(BaseModel):
    type: Literal['navigate-state-machine-decision-state-decision-started'] = Field(
        'navigate-state-machine-decision-state-decision-started', title='Type'
    )


class NavigateStateMachineDynamicBehaviorOverrideEvent(BaseModel):
    type: Literal['navigate-state-machine-dynamic-behavior-override'] = Field(
        'navigate-state-machine-dynamic-behavior-override', title='Type'
    )
    overriding: bool = Field(
        ...,
        description="Whether the dynamic behavior set's instructions are overriding the existing instructions of the current state.",
        title='Overriding',
    )


class NavigateStateMachineExitConditionSelectedEvent(BaseModel):
    type: Literal['navigate-state-machine-exit-condition-selected'] = Field(
        'navigate-state-machine-exit-condition-selected', title='Type'
    )
    exit_condition: str = Field(
        ...,
        description='The exit condition that the agent has selected.',
        title='Exit Condition',
    )
    next_state_state_machine_version_info: List = Field(
        ...,
        description='The state machine version info of the next state.',
        max_length=2,
        min_length=2,
        title='Next State State Machine Version Info',
    )
    next_state_name: str = Field(
        ..., description='The name of the next state.', title='Next State Name'
    )


class NavigateStateMachineRecallStateActiveMemoryRetrievedEventQueriesAndResponse(
    ConversationByTimeMetricOutputConversationCount
):
    pass


class NavigateStateMachineRecallStateActiveMemoryRetrievedEvent(BaseModel):
    type: Literal['navigate-state-machine-recall-state-active-memory-retrieved'] = (
        Field(
            'navigate-state-machine-recall-state-active-memory-retrieved', title='Type'
        )
    )
    queries_and_responses: List[
        NavigateStateMachineRecallStateActiveMemoryRetrievedEventQueriesAndResponse
    ] = Field(
        ...,
        description='A list of tuples of queries and responses.',
        title='Queries And Responses',
    )


class NavigateStateMachineRecallStateDynamicQueriesGeneratedEvent(BaseModel):
    type: Literal['navigate-state-machine-recall-state-dynamic-queries-generated'] = (
        Field(
            'navigate-state-machine-recall-state-dynamic-queries-generated',
            title='Type',
        )
    )
    dynamic_queries: List[str] = Field(
        ...,
        description='The dynamic queries that the agent has generated.',
        title='Dynamic Queries',
    )
    requested_information: str = Field(
        ...,
        description='The information that the agent needs from the queries.',
        title='Requested Information',
    )


class NavigateStateMachineRecallStateStaticQueriesRetrievedEvent(BaseModel):
    type: Literal['navigate-state-machine-recall-state-static-queries-retrieved'] = (
        Field(
            'navigate-state-machine-recall-state-static-queries-retrieved', title='Type'
        )
    )
    static_queries: List[str] = Field(
        ...,
        description='The static queries that the agent has retrieved.',
        title='Static Queries',
    )


class NavigateStateMachineReflectionStatePromptRetrievedEvent(BaseModel):
    type: Literal['navigate-state-machine-reflection-state-prompt-retrieved'] = Field(
        'navigate-state-machine-reflection-state-prompt-retrieved', title='Type'
    )
    prompt: str = Field(..., title='Prompt')


class NavigateStateMachineReflectionStateReflectionGeneratedEvent(BaseModel):
    type: Literal['navigate-state-machine-reflection-state-reflection-generated'] = (
        Field(
            'navigate-state-machine-reflection-state-reflection-generated', title='Type'
        )
    )
    reflection: str = Field(
        ...,
        description='The reflection that the agent has generated.',
        title='Reflection',
    )


class NavigateStateMachineStateTransitionedEvent(BaseModel):
    type: Literal['navigate-state-machine-state-transitioned'] = Field(
        'navigate-state-machine-state-transitioned', title='Type'
    )
    prev_state: str = Field(..., description='The previous state.', title='Prev State')
    prev_state_state_machine_version_info: List = Field(
        ...,
        description='The state machine version info of the previous state.',
        max_length=2,
        min_length=2,
        title='Prev State State Machine Version Info',
    )
    next_state: str = Field(..., description='The next state.', title='Next State')
    next_state_state_machine_version_info: List = Field(
        ...,
        description='The state machine version info of the next state.',
        max_length=2,
        min_length=2,
        title='Next State State Machine Version Info',
    )


class NavigateStateMachineToolCallStateToolOutputAvailableEvent(BaseModel):
    type: Literal['navigate-state-machine-tool-call-state-tool-output-available'] = (
        Field(
            'navigate-state-machine-tool-call-state-tool-output-available', title='Type'
        )
    )
    tool_id: str = Field(
        ..., description='The ID of the tool being called.', title='Tool Id'
    )
    tool_version: str = Field(
        ..., description='The version of the tool being called.', title='Tool Version'
    )
    tool_output: str = Field(..., description='The tool output.', title='Tool Output')
    duration: float = Field(
        ...,
        description='The duration taken to receive the tool output in seconds.',
        title='Duration',
    )


class NewMessageEventTranscriptAlignmentItem(
    ConversationByTimeMetricOutputConversationCount
):
    pass


class NewMessageEvent(BaseModel):
    type: Literal['new-message'] = Field('new-message', title='Type')
    message: str = Field(
        ...,
        description='Either the raw-text piece or a base-64 encoded string of bytes representing the piece in alternative forms. If it represents audio, the audios are in\nPCM16 format.',
        title='Message',
    )
    transcript_alignment: Optional[List[NewMessageEventTranscriptAlignmentItem]] = (
        Field(
            ...,
            description="Transcript of the ongoing audio message and how they align with the audio, if the message is in audio format. Otherwise, it's `None`. This is an array of tuples, where each tuple contains\na character and an integer indicating the milliseconds since the audio started when the character is spoken.\n\nNote that this field might not be defined for some events that transmit audio bytes -- in that case, the alignment information for that chunk was already\nincluded in the `transcript_alignment` field in the previous event.",
            title='Transcript Alignment',
        )
    )
    stop: bool = Field(
        ...,
        description='Whether this is the last piece of the agent message.',
        title='Stop',
    )
    sequence_number: int = Field(
        ...,
        description='The sequence number of this piece in the agent message.',
        title='Sequence Number',
    )
    message_id: str = Field(
        ..., description='The identifier of this agent message. ', title='Message Id'
    )


class NotEqualCondition(BaseModel):
    type: Literal['NotEquals'] = Field('NotEquals', title='Type')
    value: Any = Field(
        ...,
        description='The value that the attribute must be unequal to. It must be of the same type as the type of this attribute in the permission.',
        title='Value',
    )


class NumericalMetricValue(BaseModel):
    type: Literal['numerical'] = Field(..., title='Type')
    lower_bound: float = Field(..., title='Lower Bound')
    upper_bound: float = Field(..., title='Upper Bound')


class PCMUserMessageAudioConfigSampleWidth(Enum):
    integer_2 = 2
    integer_4 = 4


class PCMUserMessageAudioConfig(BaseModel):
    type: Literal['pcm'] = Field('pcm', title='Type')
    frame_rate: int = Field(..., title='Frame Rate')
    n_channels: Literal[1] = Field(..., title='N Channels')
    sample_width: PCMUserMessageAudioConfigSampleWidth = Field(
        ..., title='Sample Width'
    )


class PerLLMConfig(BaseModel):
    top_p: float = Field(..., description='The preferred `top_p` value.', title='Top P')
    temperature: float = Field(
        ..., description='The preferred temperature value.', title='Temperature'
    )
    top_k: int = Field(
        ...,
        description='The preferred `top_k` value. Note that not all LLMs support this.',
        title='Top K',
    )


class PostAnalysisType(Enum):
    generate_user_models = 'generate-user-models'
    extract_memories = 'extract-memories'
    compute_metrics = 'compute-metrics'


class PostSessionEvaluationSource(BaseModel):
    type: Literal['post-session'] = Field('post-session', title='Type')
    conversation_id: str = Field(..., title='Conversation Id')
    references: List[str] = Field(
        ...,
        description='A list of references to the messages that were used to compute this metric.',
        title='References',
    )


class Prompt(BaseModel):
    prompt: str = Field(..., description='The generated prompt.', title='Prompt')
    facets: List[str] = Field(
        ...,
        description='The facets that the generated prompt is about.',
        title='Facets',
    )


class RecallStateInputQueries(RootModel[List[str]]):
    root: List[str] = Field(..., min_length=1, title='Queries')


class RecallStateInputNextState(AnnotationStateInputNextState):
    pass


class RecallStateOutputNextState(RootModel[List]):
    root: List = Field(
        ...,
        description="The state to transition to after the active memory extraction is performed. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        max_length=2,
        min_length=2,
        title='Next State',
    )


class RecallStateOutput(BaseModel):
    type: Literal['recall'] = Field(..., title='Type')
    name: str = Field(..., description='The name of this state.', title='Name')
    queries: Optional[List[str]] = Field(
        ...,
        description='A list of queries to perform active memory extraction for. If this field is defined, `requested_information` must be `None`.',
        title='Queries',
    )
    requested_information: Optional[str] = Field(
        ...,
        description='A piece of query to run active memory query generation for. Active memory extraction will be performed for the generated queries. If this field is defined, `queries` must be `None`.',
        title='Requested Information',
    )
    next_state: Union[str, RecallStateOutputNextState] = Field(
        ...,
        description="The state to transition to after the active memory extraction is performed. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        title='Next State',
    )


class RecallStateTransitionLog(BaseModel):
    previous_state: str = Field(
        ...,
        description='Name of the previous state to transition from.',
        title='Previous State',
    )
    previous_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the previous state is in.',
        max_length=2,
        min_length=2,
        title='Previous Service Hierarchical State Machine Version Info',
    )
    next_state: str = Field(
        ..., description='Name of the next state to transition to.', title='Next State'
    )
    next_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the next state is in.',
        max_length=2,
        min_length=2,
        title='Next Service Hierarchical State Machine Version Info',
    )
    type: Literal['recall'] = Field(
        'recall',
        description="The type of the state transition log, which is the type of the state we're transitioning from.",
        title='Type',
    )
    performed_queries: List[str] = Field(
        ...,
        description='A list of queries that were actually performed during this state. This does not include queries included in the states that are duplicates of queries performed previously in this conversation.',
        title='Performed Queries',
    )


class ReflectionStateInputNextState(AnnotationStateInputNextState):
    pass


class ReflectionStateOutputNextState(AnnotationStateOutputNextState):
    pass


class ResultPersistence(Enum):
    ephemral = 'ephemral'
    persisted_preferred = 'persisted-preferred'
    persisted = 'persisted'


class SelectDynamicBehaviorCompletedEventSelectedDynamicBehaviorSetVersionInfo(
    RootModel[List]
):
    root: List = Field(
        ...,
        max_length=2,
        min_length=2,
        title='Selected Dynamic Behavior Set Version Info',
    )


class SelectDynamicBehaviorCompletedEventPreviousSelectedDynamicBehaviorSetVersionInfo(
    RootModel[List]
):
    root: List = Field(
        ...,
        max_length=2,
        min_length=2,
        title='Previous Selected Dynamic Behavior Set Version Info',
    )


class SelectDynamicBehaviorCompletedEvent(BaseModel):
    type: Literal['select-dynamic-behavior-completed'] = Field(
        'select-dynamic-behavior-completed', title='Type'
    )
    selected_dynamic_behavior_set_version_info: Optional[
        SelectDynamicBehaviorCompletedEventSelectedDynamicBehaviorSetVersionInfo
    ] = Field(..., title='Selected Dynamic Behavior Set Version Info')
    previous_selected_dynamic_behavior_set_version_info: Optional[
        SelectDynamicBehaviorCompletedEventPreviousSelectedDynamicBehaviorSetVersionInfo
    ] = Field(..., title='Previous Selected Dynamic Behavior Set Version Info')


class SelectDynamicBehaviorRelevanceRetrievalCompletedEvent(BaseModel):
    type: Literal['select-dynamic-behavior-relevance-retrieval-completed'] = Field(
        'select-dynamic-behavior-relevance-retrieval-completed', title='Type'
    )


class SelectDynamicBehaviorVectorGeneratedEvent(BaseModel):
    type: Literal['select-dynamic-behavior-vector-generated'] = Field(
        'select-dynamic-behavior-vector-generated', title='Type'
    )


class SimulationEvaluationSource(BaseModel):
    type: Literal['simulation'] = Field('simulation', title='Type')
    simulation_unit_test_set_run_id: str = Field(
        ..., title='Simulation Unit Test Set Run Id'
    )
    unit_test_id: str = Field(..., title='Unit Test Id')
    run_index: int = Field(..., title='Run Index')
    references: List[str] = Field(
        ...,
        description='A list of messages that were used to compute this metric.',
        title='References',
    )


class SimulationPersonaVersion(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    simulation_persona_id: str = Field(
        ...,
        description='The ID of the simulation persona that this is a version of.',
        title='Simulation Persona Id',
    )
    version: int = Field(
        ...,
        description='The version number of the simulation persona.',
        title='Version',
    )
    background: str = Field(
        ..., description='The background of the simulation persona.', title='Background'
    )
    preferred_language: Optional[str] = Field(
        ...,
        description='The preferred language of the simulation persona in the ISO 639-3 format. If unspecified, the language of the agent is used.',
        title='Preferred Language',
    )
    timezone: Optional[str] = Field(
        ...,
        description='The timezone of the simulation persona in the IANA tz database format. If unspecified, UTC is used.',
        title='Timezone',
    )
    user_models: List[str] = Field(
        ...,
        description='The user models associated with the simulation persona.',
        title='User Models',
    )


class SimulationScenarioVersion(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    simulation_scenario_id: str = Field(
        ...,
        description='The ID of the simulation scenario that this is a version of.',
        title='Simulation Scenario Id',
    )
    version: int = Field(
        ...,
        description='The version number of the simulation scenario.',
        title='Version',
    )
    objective: str = Field(
        ..., description='The objective of the simulation scenario.', title='Objective'
    )
    instructions: str = Field(
        ...,
        description='The instructions for the simulation scenario.',
        title='Instructions',
    )
    initial_message_type: InitialMessageType
    conversation_starts_at: Optional[AwareDatetime] = Field(
        ...,
        description='The time at which the conversation starts. This must be a timestamp in UTC. If not specified, the current server time is used.',
        title='Conversation Starts At',
    )


class StateMachineInstance(BaseModel):
    id: str = Field(..., description='The ID of the state machine.', title='Id')
    name: str = Field(..., description='The name of the state machine.', title='Name')
    deprecated: bool = Field(
        ...,
        description='Whether the state machine has been deprecated.',
        title='Deprecated',
    )
    latest_version: Optional[int] = Field(
        ...,
        description='The latest version of the state machine. If `None`, no version for the state machine exists.',
        title='Latest Version',
    )


class StateOrRefName(RootModel[str]):
    root: str = Field(..., pattern='^[A-Za-z0-9_]+$')


class StateTransitionInvocationMetadata(BaseModel):
    type: Literal['state-transition'] = Field('state-transition', title='Type')
    current_state_machine_and_version: List = Field(
        ...,
        description='The ID and version of the state machine that is currently being executed.',
        max_length=2,
        min_length=2,
        title='Current State Machine And Version',
    )
    state_name: str = Field(
        ...,
        description='The name of the state during which the tool was invoked.',
        title='State Name',
    )
    state_transition_index: int = Field(
        ...,
        description='The index of the state transition during which the tool was invoked. As an example, the first state processing that occurs during this state machine navigation process has index 1.',
        title='State Transition Index',
    )
    tool_call_round_index: int = Field(
        ...,
        description='The index of the tool call round.',
        title='Tool Call Round Index',
    )


class StrippedNonemptyString(RootModel[str]):
    root: str = Field(..., max_length=512, min_length=1, pattern='^[^/]+$')


class StrippedNonemptyStringWS(RootModel[str]):
    root: str = Field(..., min_length=1, pattern='^[\\w\\s]+$')


class SucceededInvocationResult(BaseModel):
    succeeded: Literal[True] = Field(True, title='Succeeded')
    output: str = Field(
        ..., description='The output of the tool invocation.', title='Output'
    )
    duration_ms: int = Field(
        ...,
        description='The duration of the tool invocation in milliseconds.',
        title='Duration Ms',
    )


class SucceededInvocationStatus(BaseModel):
    succeeded: Literal[True] = Field(True, title='Succeeded')
    output: str = Field(
        ..., description='The output produced by the tool invocation.', title='Output'
    )


class ToolCallEndedEvent(BaseModel):
    type: Literal['tool-call-ended'] = Field('tool-call-ended', title='Type')
    tool_round_index: int = Field(
        ...,
        description='Within the current LLM interaction, the round of tool call.',
        title='Tool Round Index',
    )
    tool_id: str = Field(
        ..., description='The ID of the tool being called.', title='Tool Id'
    )
    tool_version: str = Field(
        ..., description='The version of the tool being called.', title='Tool Version'
    )
    result: str = Field(..., description='The result of the tool call.', title='Result')
    duration: float = Field(
        ..., description='The duration of the tool call in seconds.', title='Duration'
    )


class ToolCallLog(BaseModel):
    tool_name: str = Field(
        ..., description='The name of the tool that was called.', title='Tool Name'
    )
    tool_id: str = Field(
        ..., description='The identifier of the tool that was called.', title='Tool Id'
    )
    tool_version: str = Field(
        ...,
        description='The version of the tool that was called.',
        title='Tool Version',
    )
    input: Dict[str, Any] = Field(
        ..., description='The input to the tool call.', title='Input'
    )
    output: str = Field(..., description='The output of the tool call.', title='Output')
    duration: float = Field(
        ..., description='The duration of the tool call in seconds.', title='Duration'
    )
    hidden: Optional[bool] = Field(
        False,
        description="Whether the tool call should be hidden in interaction logs based on the tool call spec's `result_persistence` setting.",
        title='Hidden',
    )


class ToolCallSpecOutput(BaseModel):
    tool_id: str = Field(..., description='The ID of the tool.', title='Tool Id')
    version_constraint: str = Field(
        ...,
        description='A [Python packaging version constraint](https://packaging.python.org/en/latest/specifications/version-specifiers/#id5) of the tool.',
        title='Version Constraint',
    )
    additional_instruction: str = Field(
        ...,
        description="Additional instruction to be supplied to the LLM in addition to the tool's description.",
        title='Additional Instruction',
    )
    audio_fillers: List[str] = Field(
        ...,
        description='A list of audio fillers to play in audio mode if the tool is taking a long time.',
        title='Audio Fillers',
    )
    audio_filler_triggered_after: float = Field(
        ...,
        description='The number of seconds to wait before playing an audio filler.',
        title='Audio Filler Triggered After',
    )
    result_persistence: Optional[ResultPersistence] = Field(
        'persisted', description='The type of result persistence for this tool call.'
    )


class ToolCallStartedEvent(BaseModel):
    type: Literal['tool-call-started'] = Field('tool-call-started', title='Type')
    tool_round_index: int = Field(
        ...,
        description='Within the current LLM interaction, the round of tool call.',
        title='Tool Round Index',
    )
    tool_id: str = Field(
        ..., description='The ID of the tool being called.', title='Tool Id'
    )
    tool_version: str = Field(
        ..., description='The version of the tool being called.', title='Tool Version'
    )
    input_params: Dict[str, Any] = Field(
        ..., description='The input parameters for the tool call.', title='Input Params'
    )


class ToolCallStateInputNextState(AnnotationStateInputNextState):
    pass


class ToolCallStateOutputNextState(AnnotationStateOutputNextState):
    pass


class ToolCallStateOutput(BaseModel):
    type: Literal['tool-call'] = Field(..., title='Type')
    name: str = Field(..., description='The name of this state.', title='Name')
    next_state: Union[str, ToolCallStateOutputNextState] = Field(
        ...,
        description="The state to transition to after the inner thought message is generated. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        title='Next State',
    )
    designated_tool: ToolCallSpecOutput = Field(
        ..., description='The tool that the agent is to call in this state.'
    )
    designated_tool_call_params_generation_audio_fillers: List[str] = Field(
        ...,
        description="A list of audio fillers to play in audio mode if the designated tool call's input generation is taking a long time.",
        title='Designated Tool Call Params Generation Audio Fillers',
    )
    designated_tool_call_params_generation_audio_filler_triggered_after: float = Field(
        ...,
        description='The number of seconds to wait after the designated tool call params generation starts before playing an audio filler.',
        title='Designated Tool Call Params Generation Audio Filler Triggered After',
    )
    designated_tool_call_objective: str = Field(
        ...,
        description='The objective that the agent is to achieve when generating the input to the designated tool. High-level optimization goal defining what "ideal" means for this state. Frames the strategic\nintent and success criteria, not the technical tool description. Focuses on user value and conversation progress.',
        title='Designated Tool Call Objective',
    )
    designated_tool_call_context: str = Field(
        ...,
        description="The context that the agent can use when generating the input to the designated tool. The minimal information gap this tool state closes within the conversation flow. Explains what's missing\nupstream and how this tool execution bridges to downstream states. Should be brief and only included when the tool's purpose isn't self-evident from the topology.",
        title='Designated Tool Call Context',
    )
    designated_tool_call_guidances: List[str] = Field(
        ...,
        description='The guidance that the agent must follow when generating the input to the designated tool. Best practices and proven patterns for constructing quality payloads. Practical tips and heuristics\nto guide decisions. Suggestions, not strict requirements. Leave empty if tool schema and objective are self-explanatory.',
        title='Designated Tool Call Guidances',
    )
    designated_tool_call_validations: List[str] = Field(
        ...,
        description='A list of validations that the agent must ensure are satisfied when generating the input to the designated tool. Strict constraints that MUST be satisfied before payload handoff. Hard requirements\nand invariants verified before execution. Pass/fail checks, not suggestions. Leave empty if only schema compliance is required.',
        title='Designated Tool Call Validations',
    )
    tool_call_specs: List[ToolCallSpecOutput] = Field(
        ...,
        description='A list of tool calls that the agent can make to help generating the input to the designated tool.',
        title='Tool Call Specs',
    )


class ToolCallStateInvocationMetadata(BaseModel):
    type: Literal['tool-call-state'] = Field('tool-call-state', title='Type')
    current_state_machine_and_version: List = Field(
        ...,
        description='The ID and version of the state machine that is currently being executed.',
        max_length=2,
        min_length=2,
        title='Current State Machine And Version',
    )
    state_name: str = Field(
        ...,
        description='The name of the state during which the tool was invoked.',
        title='State Name',
    )


class ToolCallStateTransitionLog(BaseModel):
    previous_state: str = Field(
        ...,
        description='Name of the previous state to transition from.',
        title='Previous State',
    )
    previous_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the previous state is in.',
        max_length=2,
        min_length=2,
        title='Previous Service Hierarchical State Machine Version Info',
    )
    next_state: str = Field(
        ..., description='Name of the next state to transition to.', title='Next State'
    )
    next_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the next state is in.',
        max_length=2,
        min_length=2,
        title='Next Service Hierarchical State Machine Version Info',
    )
    type: Literal['tool-call'] = Field(
        'tool-call',
        description="The type of the state transition log, which is the type of the state we're transitioning from.",
        title='Type',
    )
    tool_call_logs: List[List[ToolCallLog]] = Field(
        ...,
        description='A list of tool call logs that were performed during this state, except for the tool call for the designated tool call.',
        title='Tool Call Logs',
    )
    designated_tool_call_log: ToolCallLog = Field(
        ..., description='The tool call log for the designated tool call in this state.'
    )


class ToolVersionInstanceToolRepo(Enum):
    main = 'main'
    team = 'team'


class TotalARRMetricInput(BaseModel):
    type: Literal['total-arr'] = Field(..., title='Type')


class TotalARRMetricOutput(BaseModel):
    type: Literal['total-arr'] = Field('total-arr', title='Type')
    arr_cents: int = Field(
        ..., description='The computed ARR in cents.', title='Arr Cents'
    )


class TotalActiveUserMetricInput(BaseModel):
    type: Literal['total-active-user'] = Field(..., title='Type')
    conversation_count_threshold: int = Field(
        ...,
        description='The number of conversations an user must have had in the time horizon to be considered active.',
        ge=0,
        title='Conversation Count Threshold',
    )
    starts: AwareDatetime = Field(
        ...,
        description='The start of the interval to compute active users in.',
        title='Starts',
    )
    ends: AwareDatetime = Field(
        ...,
        description='The end of the interval to compute active users in.',
        title='Ends',
    )


class TotalActiveUserMetricOutput(BaseModel):
    type: Literal['total-active-user'] = Field('total-active-user', title='Type')
    active_user_count: int = Field(..., title='Active User Count')


class TotalConversationCountMetricInput(BaseModel):
    type: Literal['total-conversation-count'] = Field(..., title='Type')
    starts: AwareDatetime = Field(
        ...,
        description='The start of the interval to compute the count of conversations in.',
        title='Starts',
    )
    ends: AwareDatetime = Field(
        ...,
        description='The end of the interval to compute the count of conversations in.',
        title='Ends',
    )


class TotalConversationCountMetricOutput(BaseModel):
    type: Literal['total-conversation-count'] = Field(
        'total-conversation-count', title='Type'
    )
    conversation_count: int = Field(..., title='Conversation Count')


class TotalMessageCountMetricInput(BaseModel):
    type: Literal['total-message-count'] = Field(..., title='Type')
    starts: AwareDatetime = Field(
        ...,
        description='The start of the interval to compute the count of messages in.',
        title='Starts',
    )
    ends: AwareDatetime = Field(
        ...,
        description='The end of the interval to compute the count of messages in.',
        title='Ends',
    )


class TotalMessageCountMetricOutput(BaseModel):
    type: Literal['total-message-count'] = Field('total-message-count', title='Type')
    message_count: int = Field(..., title='Message Count')


class UnitTestRunSpecScenarioVersionInfo(RootModel[List]):
    root: List = Field(
        ...,
        description='The version of the scenario that the unit test runs on. This field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTest` permission.',
        max_length=2,
        min_length=2,
        title='Scenario Version Info',
    )


class UnitTestRunSpecPersonaVersionInfo(RootModel[List]):
    root: List = Field(
        ...,
        description='The version of the persona that the unit test runs on. This field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTest` permission.',
        max_length=2,
        min_length=2,
        title='Persona Version Info',
    )


class UpdateRequest(BaseModel):
    name: str = Field(
        ...,
        description='The name of the environment variable to update.',
        min_length=1,
        pattern='[A-Z_]+',
    )
    value: str = Field(
        ...,
        description='The value of the environment variable to update.',
        title='Value',
    )


class UserMessageAvailableEvent(BaseModel):
    type: Literal['user-message-available'] = Field(
        'user-message-available', title='Type'
    )
    message_id: str = Field(
        ..., description='The identifier of the user message.', title='Message Id'
    )
    user_message: str = Field(
        ..., description='The text of the user message.', title='User Message'
    )


class Verb(Enum):
    field__ = '=='
    field___1 = '!='
    field___2 = '<='
    field_ = '<'
    field___3 = '>='
    field__1 = '>'


class VersionComponent(RootModel[Union[int, str]]):
    root: Union[int, str]


class WebhookDeliveryStatus(Enum):
    success = 'success'
    failed = 'failed'


class WebhookDestination(BaseModel):
    id: str = Field(..., title='Id')
    url: str = Field(
        ..., description='The URL to which the webhook events are sent.', title='Url'
    )
    secret_generated_at: AwareDatetime = Field(
        ...,
        description='The UTC time at which the webhook secret was generated.',
        title='Secret Generated At',
    )
    retry_attempts: int = Field(
        ...,
        description='The number of attempts to retry sending the webhook event in case of failure.',
        title='Retry Attempts',
    )
    accepted_types: List[str] = Field(
        ..., description='A list of webhook types to receive.', title='Accepted Types'
    )


class WorkingMemory(BaseModel):
    content: str = Field(..., description='The content of the memory.', title='Content')
    context: str = Field(..., description='The context of the memory.', title='Context')


class FieldNotSet(BaseModel):
    pass


class AmigoLibAgentMetricMetricAgentMetricEvaluationResult(BaseModel):
    metric_id: str = Field(
        ...,
        description='The ID of the metric for which this value was computed.',
        title='Metric Id',
    )
    name: str = Field(..., description='The name of the metric.', title='Name')
    value: Optional[Union[float, bool, str]] = Field(
        ..., description='The value of the metric.', title='Value'
    )
    references: List[str] = Field(
        ...,
        description='A list of references to the messages that were used to compute this metric.',
        title='References',
    )
    justification: str = Field(
        ..., description='A justification for the metric value.', title='Justification'
    )


class AmigoLibLlmLlmBaseLLMConfig(BaseModel):
    llm_name: str = Field(
        ..., description='The name of the LLM to use.', title='Llm Name'
    )
    top_p: float = Field(..., description='The preferred `top_p` value.', title='Top P')
    temperature: float = Field(
        ..., description='The preferred temperature value.', title='Temperature'
    )
    top_k: int = Field(
        ...,
        description='The preferred `top_k` value. Note that not all LLMs support this.',
        title='Top K',
    )


class AmigoLibLlmLlmBaseLLMLoadBalancingSetConfig(BaseModel):
    llm_load_balancing_set_name: str = Field(
        ...,
        description='The name of the LLM load balancing set.',
        title='Llm Load Balancing Set Name',
    )
    configs: Dict[str, PerLLMConfig] = Field(
        ...,
        description='A map of canonical names of LLMs in this load balancing set to the LLM config to use. If an LLM in the load balancing set\ndoes not have a config, its default config would be used.',
        title='Configs',
    )


class AmigoLibMongoCollectionsAgentAgentIdentityRelationshipToDeveloper(BaseModel):
    ownership: str = Field(
        ...,
        description="The agent's belief of which entity owns it.",
        title='Ownership',
    )
    type: str = Field(
        ..., description='The entity that the agent regards itself as.', title='Type'
    )
    conversation_visibility: str = Field(
        ...,
        description='Whether the agent believes that its owner can see its conversations with clients.',
        title='Conversation Visibility',
    )
    thought_visibility: str = Field(
        ...,
        description='Whether the agent believes that its owner can see its inner thoughts when engaging in conversations with its clients.',
        title='Thought Visibility',
    )


class AmigoLibMongoCollectionsAgentAgentVoiceConfig(BaseModel):
    voice_id: str = Field(
        ..., description='The Elevenlabs voice ID for this agent.', title='Voice Id'
    )
    stability: float = Field(
        ...,
        description='How stable the voice is and the randomness between each generation. The higher the more stable the voice is.',
        title='Stability',
    )
    similarity_boost: float = Field(
        ...,
        description='How closely the AI should adhere to the original voice when attempting to replicate it. The higher the more similar the generated audio is to the\noriginal voice.',
        title='Similarity Boost',
    )
    style: float = Field(
        ...,
        description='How much to exaggerate the original voice styles of the speaker. The higher the more exaggeration there is.',
        title='Style',
    )


class AmigoLibMongoCollectionsApiKeyAPIKeyUserInfo(BaseModel):
    user_id: str = Field(
        ..., description='The user ID of the creator of this key.', title='User Id'
    )
    org_id: str = Field(
        ...,
        description='The organization ID of the creator of this key.',
        title='Org Id',
    )


class AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo(BaseModel):
    org_id: str = Field(..., title='Org Id')
    user_id: str = Field(..., title='User Id')


class AmigoLibMongoCollectionsDynamicBehaviorSetVersionAction(BaseModel):
    type: Literal['inject-instruction'] = Field(..., title='Type')
    instruction: str = Field(..., title='Instruction')
    overrides_instructions: bool = Field(
        ...,
        description='During injection, whether the original instruction of the state is overriden with this instruction.',
        title='Overrides Instructions',
    )


AmigoLibMongoCollectionsMetricMetricUserInfo = (
    AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
)


AmigoLibMongoCollectionsMetricEvaluationResultMetricEvaluationResultManualEvaluationSourceUserInfo = (
    AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
)


class AmigoLibMongoCollectionsRoleRolePermissionGrantAction(Enum):
    allow = 'Allow'
    deny = 'Deny'


class AmigoLibMongoCollectionsServiceServiceVersionSet(BaseModel):
    agent_version_number: Optional[int] = Field(
        ...,
        description='The version number of the agent to be used. If None, the latest agent version will be used.',
        title='Agent Version Number',
    )
    service_hierarchical_state_machine_version_number: Optional[int] = Field(
        ...,
        description='The version number of the state machine to be used. If None, the latest state machine version will be used.',
        title='Service Hierarchical State Machine Version Number',
    )
    llm_model_preferences: Dict[
        str,
        Union[AmigoLibLlmLlmBaseLLMConfig, AmigoLibLlmLlmBaseLLMLoadBalancingSetConfig],
    ] = Field(
        ...,
        description='A map of `LLMInteraction` name to the preferred LLM config that can be used for that interaction.\nIf an `LLMInteraction` is not in this map, the default model config will be used (defined in each `LLMInteraction` instance).',
        title='Llm Model Preferences',
    )


AmigoLibMongoCollectionsSimulationPersonaSimulationPersonaUserInfo = (
    AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
)


AmigoLibMongoCollectionsSimulationScenarioSimulationScenarioUserInfo = (
    AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
)


class AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag(BaseModel):
    key: str = Field(..., title='Key')
    value: Optional[str] = Field(..., title='Value')


AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestUserInfo = (
    AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
)


class AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUnitTestRunDescriptor(
    BaseModel
):
    unit_test_id: str = Field(..., title='Unit Test Id')
    run_count: int = Field(..., title='Run Count')


AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUserInfo = (
    AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
)


class AmigoLibMongoCollectionsSimulationUnitTestSetRunSimulationUnitTestSetRunUnitTestRunResultMetricEvaluationResultResult(
    ConversationByTimeMetricOutputConversationCount
):
    pass


class AmigoLibMongoCollectionsSimulationUnitTestSetRunSimulationUnitTestSetRunUnitTestRunResultMetricEvaluationResult(
    BaseModel
):
    metric_id: str = Field(..., title='Metric Id')
    results: List[
        AmigoLibMongoCollectionsSimulationUnitTestSetRunSimulationUnitTestSetRunUnitTestRunResultMetricEvaluationResultResult
    ] = Field(
        ...,
        description='A list of tuples detailing the result of the evaluation of this metric. The first element of the tuple is the ID of the `MetricEvaluationResult` document, and the second element\nis whether the metric result has passed the evaluation.',
        title='Results',
    )


AmigoLibMongoCollectionsSimulationUnitTestSetRunSimulationUnitTestSetRunUserInfo = (
    AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
)


class AmigoLibMongoCollectionsToolVersionToolVersionUserInfo(BaseModel):
    user_id: str = Field(..., description='The ID of the user.', title='User Id')
    user_org_id: str = Field(
        ..., description="The ID of the user's organization.", title='User Org Id'
    )


class AmigoLibMongoCollectionsToolVersionToolVersionVersion(BaseModel):
    major: int = Field(..., title='Major')
    minor: int = Field(..., title='Minor')
    patch: int = Field(..., title='Patch')


class AmigoLibMongoCollectionsUserUserPreferences(BaseModel):
    enable_response_recommendation: Optional[bool] = Field(
        False,
        description="Whether to automatically recommend responses to the user if the user hasn't replied to the coach for a while.",
        title='Enable Response Recommendation',
    )
    preferred_language: Optional[str] = Field(
        None,
        description="The preferred language to use for the user. This field must be in the ISO 639-3 format. The agent will attempt to converse\nwith the user in this language. If not set, the agent's default spoken language is used.",
        title='Preferred Language',
    )
    conversations_visible_to_admins: Optional[bool] = Field(
        True,
        description="Whether the user's conversations are visible to the admins.",
        title='Conversations Visible To Admins',
    )
    user_model_visible_to_admins: Optional[bool] = Field(
        True,
        description="Whether the user's user model is visible to the admins.",
        title='User Model Visible To Admins',
    )
    timezone: Optional[str] = Field(
        None,
        description="The user's timezone in the IANA tz database format for all users in this organization. If not specified, UTC is used.",
        title='Timezone',
    )


class AmigoLibMongoCollectionsUserUserUserModelUserDimension(BaseModel):
    description: str = Field(..., title='Description')
    tags: List[str] = Field(..., title='Tags')


class AmigoLibPydanticBaseModelStrippedNonemptyString1(RootModel[str]):
    root: str = Field(..., min_length=1)


class AmigoLibPydanticBaseModelStrippedNonemptyString3(RootModel[str]):
    root: str = Field(..., max_length=3, min_length=1)


class AdminSubmitSqlQueryRequest(BaseModel):
    sql_query: str = Field(..., description='The SQL query to execute.', min_length=1)
    async_query: Literal[False] = Field(
        ...,
        description='Whether the query is asynchronous. If true, a signed URL will be returned to download the results once the query is complete. If false, the results will be returned in the response, but at most\n1000 rows will be returned, and the query is subject to a 30 second execution timeout.',
        title='Async Query',
    )


class AdminSubmitSqlQueryResponse(BaseModel):
    execution_time_ms: int = Field(
        ...,
        description='The time taken to execute the query in milliseconds.',
        title='Execution Time Ms',
    )
    result: List[List] = Field(
        ...,
        description='The result of the query as a list of rows, where each row is a list of column values.',
        title='Result',
    )
    truncated: bool = Field(
        ...,
        description='Whether the result was truncated due to the row limit.',
        title='Truncated',
    )
    columns: List[Column] = Field(
        ..., description='Description of the columns in the result.', title='Columns'
    )


class ConversationCreateConversationRequestInitialMessageType(Enum):
    user_message = 'user-message'
    external_event = 'external-event'


class ConversationCreateConversationRequest(BaseModel):
    service_id: str = Field(
        ...,
        description='The identifier of the service to create a conversation in.',
        pattern='^[a-f0-9]{24}$',
        title='Service Id',
    )
    service_version_set_name: Optional[str] = Field(
        'release',
        description='The version set of the service to use. If not provided, the `release` version set is used.',
        title='Service Version Set Name',
    )
    initial_message: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None,
        description='The initial user or agent inner thought message to send to the service. If not provided, the conversation will start with an agent message.',
    )
    initial_message_type: Optional[
        ConversationCreateConversationRequestInitialMessageType
    ] = Field(
        None,
        description='The type of the `initial_message`. Can only be specified if `initial_message` is provided.',
        title='Initial Message Type',
    )


class ConversationGenerateConversationStarterRequest(BaseModel):
    service_id: str = Field(
        ...,
        description='The identifier of the service to create a conversation starter for.',
        pattern='^[a-f0-9]{24}$',
        title='Service Id',
    )
    service_version_set_name: Optional[str] = Field(
        'release',
        description='The version set of the service to use. If not provided, the `release` version set is used.',
        title='Service Version Set Name',
    )
    facets: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ...,
        description='The facets that the generated conversation starter should be about. Each generated starter is related to some of these facets.',
        title='Facets',
    )
    min_count: int = Field(
        ...,
        description='The minimum (inclusive) number of conversation starters to generate.',
        gt=0,
        le=10,
        title='Min Count',
    )
    max_count: int = Field(
        ...,
        description='The maximum (inclusive) number of conversation starters to generate.',
        gt=0,
        le=10,
        title='Max Count',
    )
    generation_instructions: str = Field(
        ...,
        description='The instruction for the conversation starter generation.',
        min_length=1,
    )


class ConversationGenerateConversationStarterResponse(BaseModel):
    prompts: List[Prompt] = Field(
        ..., description='The generated prompts.', title='Prompts'
    )


class ConversationGetInteractionInsightsResponseTriggeredDynamicBehaviorSetVersionInfo(
    RootModel[List]
):
    root: List = Field(
        ...,
        description='The ID and version number of the dynamic behavior set that was activated during this interaction.',
        max_length=2,
        min_length=2,
        title='Triggered Dynamic Behavior Set Version Info',
    )


class ConversationRecommendResponsesForInteractionRequest(BaseModel):
    context: Optional[str] = Field(
        '\nPERSONA:\nName: User\nBackground: A typical person seeking this service.\n---\nSCENARIO:\nName: Complete Service\nObjective: Successfully complete the service interaction.\nInstructions: Engage naturally with the agent to achieve the service objective.\n',
        description='The context under which the recommended responses should be generated.',
        min_length=1,
    )


class ConversationRecommendResponsesForInteractionResponse(BaseModel):
    recommended_responses: List[str] = Field(
        ...,
        description='The recommended responses to the user.',
        title='Recommended Responses',
    )


class DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService(RootModel[str]):
    root: str = Field(..., pattern='^[a-f0-9]{24}$')


class DynamicBehaviorSetCreateDynamicBehaviorSetRequestInitialVersionInjectInstructionAction(
    BaseModel
):
    type: Literal['inject-instruction'] = Field(..., title='Type')
    instruction: str = Field(..., min_length=1)
    overrides_instructions: bool = Field(
        ...,
        description='During injection, whether the original instruction of the state is overriden with this instruction.',
        title='Overrides Instructions',
    )


class DynamicBehaviorSetCreateDynamicBehaviorSetResponse(BaseModel):
    dynamic_behavior_set_id: str = Field(
        ...,
        description='The ID of the newly created dynamic behavior set.',
        title='Dynamic Behavior Set Id',
    )


class DynamicBehaviorSetCreateDynamicBehaviorSetVersionRequestInjectInstructionAction(
    BaseModel
):
    type: Literal['inject-instruction'] = Field(..., title='Type')
    instruction: str = Field(..., min_length=1)
    overrides_instructions: bool = Field(..., title='Overrides Instructions')


class DynamicBehaviorSetCreateDynamicBehaviorSetVersionResponse(BaseModel):
    new_version_number: int = Field(
        ...,
        description='The version number of the new version.',
        title='New Version Number',
    )


class DynamicBehaviorSetGetDynamicBehaviorInvocationsResponse(BaseModel):
    dynamic_behavior_invocations: List[DynamicBehaviorInvocation] = Field(
        ...,
        description='The retrieved dynamic behavior invocations.',
        title='Dynamic Behavior Invocations',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more dynamic behavior invocations to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of dynamic behavior invocations. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class DynamicBehaviorSetGetDynamicBehaviorSetsResponseDynamicBehaviorSetInstance(
    BaseModel
):
    id: str = Field(..., title='Id')
    name: str = Field(..., title='Name')
    is_active: bool = Field(..., title='Is Active')
    applied_to_services: List[str] = Field(..., title='Applied To Services')
    tags: Dict[str, Optional[str]] = Field(..., title='Tags')
    created_at: AwareDatetime = Field(..., title='Created At')
    creator: AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
    updated_at: AwareDatetime = Field(..., title='Updated At')
    updated_by: AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo


class DynamicBehaviorSetGetDynamicBehaviorSetsResponseFilterValues(BaseModel):
    applied_to_services_ids: List[str] = Field(
        ...,
        description='A set of service IDs that have dynamic behavior sets applied to the service.',
        title='Applied To Services Ids',
    )
    creators: List[
        AmigoLibMongoCollectionsDynamicBehaviorSetDynamicBehaviorSetUserInfo
    ] = Field(
        ...,
        description='A set of creator infos that created the dynamic behavior sets under the current filters.',
        title='Creators',
    )
    tags: List[str] = Field(
        ...,
        description='A set of tag keys that exist in the dynamic behavior sets under the current filters.',
        title='Tags',
    )


class DynamicBehaviorSetSearchDynamicBehaviorSetsResponse(BaseModel):
    dynamic_behavior_sets: List[
        DynamicBehaviorSetGetDynamicBehaviorSetsResponseDynamicBehaviorSetInstance
    ] = Field(
        ...,
        description='The retrieved dynamic behavior sets.',
        title='Dynamic Behavior Sets',
    )


class DynamicBehaviorSetUpdateDynamicBehaviorSetRequestAppliedToService(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class DynamicBehaviorSetUpdateDynamicBehaviorSetRequest(BaseModel):
    name: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description='The name of the dynamic behavior set.'
    )
    tags: Optional[Dict[str, Optional[StrippedNonemptyStringWS]]] = Field(
        None,
        description='The tags of the dynamic behavior set. Both the key and the value can only contain alphanumeric characters, underscores, or spaces.',
        title='Tags',
    )
    applied_to_services: Optional[
        List[DynamicBehaviorSetUpdateDynamicBehaviorSetRequestAppliedToService]
    ] = Field(
        None,
        description='The services that the dynamic behavior set should be applied to.',
        title='Applied To Services',
    )
    is_active: Optional[bool] = Field(
        None,
        description='Whether the dynamic behavior set is active.',
        title='Is Active',
    )


class MetricCreateMetricRequestAppliedToService(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class MetricCreateMetricResponse(BaseModel):
    id: str = Field(..., description='The ID of the created metric.', title='Id')


class MetricEvaluateMetricsRequestMetricId(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class MetricEvaluateMetricsRequestEvaluateToInteractionId(RootModel[str]):
    root: str = Field(
        ...,
        description='If specified, only messages up to (and including) this interaction will be evaluated.',
        pattern='^[a-f0-9]{24}$',
        title='Evaluate To Interaction Id',
    )


class MetricEvaluateMetricsRequest(BaseModel):
    metric_ids: List[MetricEvaluateMetricsRequestMetricId] = Field(
        ...,
        description='The IDs of the metrics to evaluate.',
        max_length=10,
        min_length=1,
        title='Metric Ids',
    )
    conversation_id: str = Field(
        ...,
        description='The ID of the conversation to evaluate the metrics for.',
        pattern='^[a-f0-9]{24}$',
        title='Conversation Id',
    )
    evaluate_to_interaction_id: Optional[
        MetricEvaluateMetricsRequestEvaluateToInteractionId
    ] = Field(
        None,
        description='If specified, only messages up to (and including) this interaction will be evaluated.',
        title='Evaluate To Interaction Id',
    )


class MetricEvaluateMetricsResponse(BaseModel):
    metrics: List[AmigoLibAgentMetricMetricAgentMetricEvaluationResult] = Field(
        ...,
        description='A list of the evaluated metrics, in the same order that the `metrics` field in the request is presented.',
        title='Metrics',
    )


class MetricGetMetricEvaluationResultsResponseFilterValues(BaseModel):
    metric_ids: List[str] = Field(
        ...,
        description='The IDs of the metrics that the metric evaluation results are for.',
        title='Metric Ids',
    )


class MetricGetMetricsResponseFilterValues(BaseModel):
    applied_to_services_ids: List[str] = Field(
        ...,
        description='A set of service IDs that have metrics applied to the service.',
        title='Applied To Services Ids',
    )
    creators: List[AmigoLibMongoCollectionsMetricMetricUserInfo] = Field(
        ...,
        description='A set of creator infos that created the metrics under the current filters.',
        title='Creators',
    )
    tags: List[str] = Field(
        ...,
        description='A set of tag keys that exist in the metrics under the current filters.',
        title='Tags',
    )
    types: List[str] = Field(
        ...,
        description='A set of metric types that exist in the metrics under the current filters.',
        title='Types',
    )


class MetricUpdateMetricRequestAppliedToService(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class MetricUpdateMetricRequest(BaseModel):
    description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description='The description of the metric. Only updated if set.'
    )
    applied_to_services: Optional[List[MetricUpdateMetricRequestAppliedToService]] = (
        Field(
            None,
            description='The services that the metric is applied to. Only updated if set.',
            title='Applied To Services',
        )
    )
    additional_notes: Optional[
        Union[AmigoLibPydanticBaseModelStrippedNonemptyString1, FieldNotSet]
    ] = Field(
        {},
        description='Additional notes about the metric. Only updated if set.',
        title='Additional Notes',
    )
    tags: Optional[Dict[str, Optional[StrippedNonemptyStringWS]]] = Field(
        None, description='The tags of the metric. Only updated if set.', title='Tags'
    )


class OrganizationCreateAgentRequest(BaseModel):
    agent_name: str = Field(
        ..., description='The name of the new agent.', max_length=256, min_length=1
    )


class OrganizationCreateAgentResponse(BaseModel):
    id: str = Field(..., description='The ID of the newly created agent.', title='Id')


class OrganizationCreateAgentVersionRequestIdentityDefaultSpokenLanguage(Enum):
    aaa = 'aaa'
    aab = 'aab'
    aac = 'aac'
    aad = 'aad'
    aae = 'aae'
    aaf = 'aaf'
    aag = 'aag'
    aah = 'aah'
    aai = 'aai'
    aak = 'aak'
    aal = 'aal'
    aan = 'aan'
    aao = 'aao'
    aap = 'aap'
    aaq = 'aaq'
    aar = 'aar'
    aas = 'aas'
    aat = 'aat'
    aau = 'aau'
    aaw = 'aaw'
    aax = 'aax'
    aaz = 'aaz'
    aba = 'aba'
    abb = 'abb'
    abc = 'abc'
    abd = 'abd'
    abe = 'abe'
    abf = 'abf'
    abg = 'abg'
    abh = 'abh'
    abi = 'abi'
    abj = 'abj'
    abk = 'abk'
    abl = 'abl'
    abm = 'abm'
    abn = 'abn'
    abo = 'abo'
    abp = 'abp'
    abq = 'abq'
    abr = 'abr'
    abs = 'abs'
    abt = 'abt'
    abu = 'abu'
    abv = 'abv'
    abw = 'abw'
    abx = 'abx'
    aby = 'aby'
    abz = 'abz'
    aca = 'aca'
    acb = 'acb'
    acd = 'acd'
    ace = 'ace'
    acf = 'acf'
    ach = 'ach'
    aci = 'aci'
    ack = 'ack'
    acl = 'acl'
    acm = 'acm'
    acn = 'acn'
    acp = 'acp'
    acq = 'acq'
    acr = 'acr'
    acs = 'acs'
    act = 'act'
    acu = 'acu'
    acv = 'acv'
    acw = 'acw'
    acx = 'acx'
    acy = 'acy'
    acz = 'acz'
    ada = 'ada'
    adb = 'adb'
    add = 'add'
    ade = 'ade'
    adf = 'adf'
    adg = 'adg'
    adh = 'adh'
    adi = 'adi'
    adj = 'adj'
    adl = 'adl'
    adn = 'adn'
    ado = 'ado'
    adq = 'adq'
    adr = 'adr'
    ads = 'ads'
    adt = 'adt'
    adu = 'adu'
    adw = 'adw'
    adx = 'adx'
    ady = 'ady'
    adz = 'adz'
    aea = 'aea'
    aeb = 'aeb'
    aec = 'aec'
    aed = 'aed'
    aee = 'aee'
    aek = 'aek'
    ael = 'ael'
    aem = 'aem'
    aen = 'aen'
    aeq = 'aeq'
    aer = 'aer'
    aes = 'aes'
    aeu = 'aeu'
    aew = 'aew'
    aey = 'aey'
    aez = 'aez'
    afb = 'afb'
    afd = 'afd'
    afe = 'afe'
    afg = 'afg'
    afh = 'afh'
    afi = 'afi'
    afk = 'afk'
    afn = 'afn'
    afo = 'afo'
    afp = 'afp'
    afr = 'afr'
    afs = 'afs'
    aft = 'aft'
    afu = 'afu'
    afz = 'afz'
    aga = 'aga'
    agb = 'agb'
    agc = 'agc'
    agd = 'agd'
    age = 'age'
    agf = 'agf'
    agg = 'agg'
    agh = 'agh'
    agi = 'agi'
    agj = 'agj'
    agk = 'agk'
    agl = 'agl'
    agm = 'agm'
    agn = 'agn'
    ago = 'ago'
    agq = 'agq'
    agr = 'agr'
    ags = 'ags'
    agt = 'agt'
    agu = 'agu'
    agv = 'agv'
    agw = 'agw'
    agx = 'agx'
    agy = 'agy'
    agz = 'agz'
    aha = 'aha'
    ahb = 'ahb'
    ahg = 'ahg'
    ahh = 'ahh'
    ahi = 'ahi'
    ahk = 'ahk'
    ahl = 'ahl'
    ahm = 'ahm'
    ahn = 'ahn'
    aho = 'aho'
    ahp = 'ahp'
    ahr = 'ahr'
    ahs = 'ahs'
    aht = 'aht'
    aia = 'aia'
    aib = 'aib'
    aic = 'aic'
    aid = 'aid'
    aie = 'aie'
    aif = 'aif'
    aig = 'aig'
    aih = 'aih'
    aii = 'aii'
    aij = 'aij'
    aik = 'aik'
    ail = 'ail'
    aim = 'aim'
    ain = 'ain'
    aio = 'aio'
    aip = 'aip'
    aiq = 'aiq'
    air = 'air'
    ait = 'ait'
    aiw = 'aiw'
    aix = 'aix'
    aiy = 'aiy'
    aja = 'aja'
    ajg = 'ajg'
    aji = 'aji'
    ajn = 'ajn'
    ajp = 'ajp'
    ajs = 'ajs'
    aju = 'aju'
    ajw = 'ajw'
    ajz = 'ajz'
    aka = 'aka'
    akb = 'akb'
    akc = 'akc'
    akd = 'akd'
    ake = 'ake'
    akf = 'akf'
    akg = 'akg'
    akh = 'akh'
    aki = 'aki'
    akj = 'akj'
    akk = 'akk'
    akl = 'akl'
    akm = 'akm'
    ako = 'ako'
    akp = 'akp'
    akq = 'akq'
    akr = 'akr'
    aks = 'aks'
    akt = 'akt'
    aku = 'aku'
    akv = 'akv'
    akw = 'akw'
    akx = 'akx'
    aky = 'aky'
    akz = 'akz'
    ala = 'ala'
    alc = 'alc'
    ald = 'ald'
    ale = 'ale'
    alf = 'alf'
    alh = 'alh'
    ali = 'ali'
    alj = 'alj'
    alk = 'alk'
    all = 'all'
    alm = 'alm'
    aln = 'aln'
    alo = 'alo'
    alp = 'alp'
    alq = 'alq'
    alr = 'alr'
    als = 'als'
    alt = 'alt'
    alu = 'alu'
    alw = 'alw'
    alx = 'alx'
    aly = 'aly'
    alz = 'alz'
    ama = 'ama'
    amb = 'amb'
    amc = 'amc'
    ame = 'ame'
    amf = 'amf'
    amg = 'amg'
    amh = 'amh'
    ami = 'ami'
    amj = 'amj'
    amk = 'amk'
    aml = 'aml'
    amm = 'amm'
    amn = 'amn'
    amo = 'amo'
    amp = 'amp'
    amq = 'amq'
    amr = 'amr'
    ams = 'ams'
    amt = 'amt'
    amu = 'amu'
    amv = 'amv'
    amw = 'amw'
    amx = 'amx'
    amy = 'amy'
    amz = 'amz'
    ana = 'ana'
    anb = 'anb'
    anc = 'anc'
    and_ = 'and'
    ane = 'ane'
    anf = 'anf'
    ang = 'ang'
    anh = 'anh'
    ani = 'ani'
    anj = 'anj'
    ank = 'ank'
    anl = 'anl'
    anm = 'anm'
    ann = 'ann'
    ano = 'ano'
    anp = 'anp'
    anq = 'anq'
    anr = 'anr'
    ans = 'ans'
    ant = 'ant'
    anu = 'anu'
    anv = 'anv'
    anw = 'anw'
    anx = 'anx'
    any = 'any'
    anz = 'anz'
    aoa = 'aoa'
    aob = 'aob'
    aoc = 'aoc'
    aod = 'aod'
    aoe = 'aoe'
    aof = 'aof'
    aog = 'aog'
    aoi = 'aoi'
    aoj = 'aoj'
    aok = 'aok'
    aol = 'aol'
    aom = 'aom'
    aon = 'aon'
    aor = 'aor'
    aos = 'aos'
    aot = 'aot'
    aou = 'aou'
    aox = 'aox'
    aoz = 'aoz'
    apb = 'apb'
    apc = 'apc'
    apd = 'apd'
    ape = 'ape'
    apf = 'apf'
    apg = 'apg'
    aph = 'aph'
    api = 'api'
    apj = 'apj'
    apk = 'apk'
    apl = 'apl'
    apm = 'apm'
    apn = 'apn'
    apo = 'apo'
    app = 'app'
    apq = 'apq'
    apr = 'apr'
    aps = 'aps'
    apt = 'apt'
    apu = 'apu'
    apv = 'apv'
    apw = 'apw'
    apx = 'apx'
    apy = 'apy'
    apz = 'apz'
    aqc = 'aqc'
    aqd = 'aqd'
    aqg = 'aqg'
    aqk = 'aqk'
    aqm = 'aqm'
    aqn = 'aqn'
    aqp = 'aqp'
    aqr = 'aqr'
    aqt = 'aqt'
    aqz = 'aqz'
    ara = 'ara'
    arb = 'arb'
    arc = 'arc'
    ard = 'ard'
    are = 'are'
    arg = 'arg'
    arh = 'arh'
    ari = 'ari'
    arj = 'arj'
    ark = 'ark'
    arl = 'arl'
    arn = 'arn'
    aro = 'aro'
    arp = 'arp'
    arq = 'arq'
    arr = 'arr'
    ars = 'ars'
    aru = 'aru'
    arv = 'arv'
    arw = 'arw'
    arx = 'arx'
    ary = 'ary'
    arz = 'arz'
    asa = 'asa'
    asb = 'asb'
    asc = 'asc'
    ase = 'ase'
    asf = 'asf'
    asg = 'asg'
    ash = 'ash'
    asi = 'asi'
    asj = 'asj'
    ask = 'ask'
    asl = 'asl'
    asm = 'asm'
    asn = 'asn'
    aso = 'aso'
    asp = 'asp'
    asq = 'asq'
    asr = 'asr'
    ass = 'ass'
    ast = 'ast'
    asu = 'asu'
    asv = 'asv'
    asw = 'asw'
    asx = 'asx'
    asy = 'asy'
    asz = 'asz'
    ata = 'ata'
    atb = 'atb'
    atc = 'atc'
    atd = 'atd'
    ate = 'ate'
    atg = 'atg'
    ati = 'ati'
    atj = 'atj'
    atk = 'atk'
    atl = 'atl'
    atm = 'atm'
    atn = 'atn'
    ato = 'ato'
    atp = 'atp'
    atq = 'atq'
    atr = 'atr'
    ats = 'ats'
    att = 'att'
    atu = 'atu'
    atv = 'atv'
    atw = 'atw'
    atx = 'atx'
    aty = 'aty'
    atz = 'atz'
    aua = 'aua'
    aub = 'aub'
    auc = 'auc'
    aud = 'aud'
    aug = 'aug'
    auh = 'auh'
    aui = 'aui'
    auj = 'auj'
    auk = 'auk'
    aul = 'aul'
    aum = 'aum'
    aun = 'aun'
    auo = 'auo'
    aup = 'aup'
    auq = 'auq'
    aur = 'aur'
    aut = 'aut'
    auu = 'auu'
    auw = 'auw'
    aux = 'aux'
    auy = 'auy'
    auz = 'auz'
    ava = 'ava'
    avb = 'avb'
    avd = 'avd'
    ave = 'ave'
    avi = 'avi'
    avk = 'avk'
    avl = 'avl'
    avm = 'avm'
    avn = 'avn'
    avo = 'avo'
    avs = 'avs'
    avt = 'avt'
    avu = 'avu'
    avv = 'avv'
    awa = 'awa'
    awb = 'awb'
    awc = 'awc'
    awe = 'awe'
    awg = 'awg'
    awh = 'awh'
    awi = 'awi'
    awk = 'awk'
    awm = 'awm'
    awn = 'awn'
    awo = 'awo'
    awr = 'awr'
    aws = 'aws'
    awt = 'awt'
    awu = 'awu'
    awv = 'awv'
    aww = 'aww'
    awx = 'awx'
    awy = 'awy'
    axb = 'axb'
    axe = 'axe'
    axg = 'axg'
    axk = 'axk'
    axl = 'axl'
    axm = 'axm'
    axx = 'axx'
    aya = 'aya'
    ayb = 'ayb'
    ayc = 'ayc'
    ayd = 'ayd'
    aye = 'aye'
    ayg = 'ayg'
    ayh = 'ayh'
    ayi = 'ayi'
    ayk = 'ayk'
    ayl = 'ayl'
    aym = 'aym'
    ayn = 'ayn'
    ayo = 'ayo'
    ayp = 'ayp'
    ayq = 'ayq'
    ayr = 'ayr'
    ays = 'ays'
    ayt = 'ayt'
    ayu = 'ayu'
    ayz = 'ayz'
    aza = 'aza'
    azb = 'azb'
    azd = 'azd'
    aze = 'aze'
    azg = 'azg'
    azj = 'azj'
    azm = 'azm'
    azn = 'azn'
    azo = 'azo'
    azt = 'azt'
    azz = 'azz'
    baa = 'baa'
    bab = 'bab'
    bac = 'bac'
    bae = 'bae'
    baf = 'baf'
    bag = 'bag'
    bah = 'bah'
    baj = 'baj'
    bak = 'bak'
    bal = 'bal'
    bam = 'bam'
    ban = 'ban'
    bao = 'bao'
    bap = 'bap'
    bar = 'bar'
    bas = 'bas'
    bau = 'bau'
    bav = 'bav'
    baw = 'baw'
    bax = 'bax'
    bay = 'bay'
    bba = 'bba'
    bbb = 'bbb'
    bbc = 'bbc'
    bbd = 'bbd'
    bbe = 'bbe'
    bbf = 'bbf'
    bbg = 'bbg'
    bbh = 'bbh'
    bbi = 'bbi'
    bbj = 'bbj'
    bbk = 'bbk'
    bbl = 'bbl'
    bbm = 'bbm'
    bbn = 'bbn'
    bbo = 'bbo'
    bbp = 'bbp'
    bbq = 'bbq'
    bbr = 'bbr'
    bbs = 'bbs'
    bbt = 'bbt'
    bbu = 'bbu'
    bbv = 'bbv'
    bbw = 'bbw'
    bbx = 'bbx'
    bby = 'bby'
    bca = 'bca'
    bcb = 'bcb'
    bcc = 'bcc'
    bcd = 'bcd'
    bce = 'bce'
    bcf = 'bcf'
    bcg = 'bcg'
    bch = 'bch'
    bci = 'bci'
    bcj = 'bcj'
    bck = 'bck'
    bcl = 'bcl'
    bcm = 'bcm'
    bcn = 'bcn'
    bco = 'bco'
    bcp = 'bcp'
    bcq = 'bcq'
    bcr = 'bcr'
    bcs = 'bcs'
    bct = 'bct'
    bcu = 'bcu'
    bcv = 'bcv'
    bcw = 'bcw'
    bcy = 'bcy'
    bcz = 'bcz'
    bda = 'bda'
    bdb = 'bdb'
    bdc = 'bdc'
    bdd = 'bdd'
    bde = 'bde'
    bdf = 'bdf'
    bdg = 'bdg'
    bdh = 'bdh'
    bdi = 'bdi'
    bdj = 'bdj'
    bdk = 'bdk'
    bdl = 'bdl'
    bdm = 'bdm'
    bdn = 'bdn'
    bdo = 'bdo'
    bdp = 'bdp'
    bdq = 'bdq'
    bdr = 'bdr'
    bds = 'bds'
    bdt = 'bdt'
    bdu = 'bdu'
    bdv = 'bdv'
    bdw = 'bdw'
    bdx = 'bdx'
    bdy = 'bdy'
    bdz = 'bdz'
    bea = 'bea'
    beb = 'beb'
    bec = 'bec'
    bed = 'bed'
    bee = 'bee'
    bef = 'bef'
    beg = 'beg'
    beh = 'beh'
    bei = 'bei'
    bej = 'bej'
    bek = 'bek'
    bel = 'bel'
    bem = 'bem'
    ben = 'ben'
    beo = 'beo'
    bep = 'bep'
    beq = 'beq'
    bes = 'bes'
    bet = 'bet'
    beu = 'beu'
    bev = 'bev'
    bew = 'bew'
    bex = 'bex'
    bey = 'bey'
    bez = 'bez'
    bfa = 'bfa'
    bfb = 'bfb'
    bfc = 'bfc'
    bfd = 'bfd'
    bfe = 'bfe'
    bff = 'bff'
    bfg = 'bfg'
    bfh = 'bfh'
    bfi = 'bfi'
    bfj = 'bfj'
    bfk = 'bfk'
    bfl = 'bfl'
    bfm = 'bfm'
    bfn = 'bfn'
    bfo = 'bfo'
    bfp = 'bfp'
    bfq = 'bfq'
    bfr = 'bfr'
    bfs = 'bfs'
    bft = 'bft'
    bfu = 'bfu'
    bfw = 'bfw'
    bfx = 'bfx'
    bfy = 'bfy'
    bfz = 'bfz'
    bga = 'bga'
    bgb = 'bgb'
    bgc = 'bgc'
    bgd = 'bgd'
    bge = 'bge'
    bgf = 'bgf'
    bgg = 'bgg'
    bgi = 'bgi'
    bgj = 'bgj'
    bgk = 'bgk'
    bgl = 'bgl'
    bgn = 'bgn'
    bgo = 'bgo'
    bgp = 'bgp'
    bgq = 'bgq'
    bgr = 'bgr'
    bgs = 'bgs'
    bgt = 'bgt'
    bgu = 'bgu'
    bgv = 'bgv'
    bgw = 'bgw'
    bgx = 'bgx'
    bgy = 'bgy'
    bgz = 'bgz'
    bha = 'bha'
    bhb = 'bhb'
    bhc = 'bhc'
    bhd = 'bhd'
    bhe = 'bhe'
    bhf = 'bhf'
    bhg = 'bhg'
    bhh = 'bhh'
    bhi = 'bhi'
    bhj = 'bhj'
    bhl = 'bhl'
    bhm = 'bhm'
    bhn = 'bhn'
    bho = 'bho'
    bhp = 'bhp'
    bhq = 'bhq'
    bhr = 'bhr'
    bhs = 'bhs'
    bht = 'bht'
    bhu = 'bhu'
    bhv = 'bhv'
    bhw = 'bhw'
    bhx = 'bhx'
    bhy = 'bhy'
    bhz = 'bhz'
    bia = 'bia'
    bib = 'bib'
    bid = 'bid'
    bie = 'bie'
    bif = 'bif'
    big = 'big'
    bik = 'bik'
    bil = 'bil'
    bim = 'bim'
    bin = 'bin'
    bio = 'bio'
    bip = 'bip'
    biq = 'biq'
    bir = 'bir'
    bis = 'bis'
    bit = 'bit'
    biu = 'biu'
    biv = 'biv'
    biw = 'biw'
    bix = 'bix'
    biy = 'biy'
    biz = 'biz'
    bja = 'bja'
    bjb = 'bjb'
    bjc = 'bjc'
    bje = 'bje'
    bjf = 'bjf'
    bjg = 'bjg'
    bjh = 'bjh'
    bji = 'bji'
    bjj = 'bjj'
    bjk = 'bjk'
    bjl = 'bjl'
    bjm = 'bjm'
    bjn = 'bjn'
    bjo = 'bjo'
    bjp = 'bjp'
    bjr = 'bjr'
    bjs = 'bjs'
    bjt = 'bjt'
    bju = 'bju'
    bjv = 'bjv'
    bjw = 'bjw'
    bjx = 'bjx'
    bjy = 'bjy'
    bjz = 'bjz'
    bka = 'bka'
    bkc = 'bkc'
    bkd = 'bkd'
    bkf = 'bkf'
    bkg = 'bkg'
    bkh = 'bkh'
    bki = 'bki'
    bkj = 'bkj'
    bkk = 'bkk'
    bkl = 'bkl'
    bkm = 'bkm'
    bkn = 'bkn'
    bko = 'bko'
    bkp = 'bkp'
    bkq = 'bkq'
    bkr = 'bkr'
    bks = 'bks'
    bkt = 'bkt'
    bku = 'bku'
    bkv = 'bkv'
    bkw = 'bkw'
    bkx = 'bkx'
    bky = 'bky'
    bkz = 'bkz'
    bla = 'bla'
    blb = 'blb'
    blc = 'blc'
    bld = 'bld'
    ble = 'ble'
    blf = 'blf'
    blh = 'blh'
    bli = 'bli'
    blj = 'blj'
    blk = 'blk'
    bll = 'bll'
    blm = 'blm'
    bln = 'bln'
    blo = 'blo'
    blp = 'blp'
    blq = 'blq'
    blr = 'blr'
    bls = 'bls'
    blt = 'blt'
    blv = 'blv'
    blw = 'blw'
    blx = 'blx'
    bly = 'bly'
    blz = 'blz'
    bma = 'bma'
    bmb = 'bmb'
    bmc = 'bmc'
    bmd = 'bmd'
    bme = 'bme'
    bmf = 'bmf'
    bmg = 'bmg'
    bmh = 'bmh'
    bmi = 'bmi'
    bmj = 'bmj'
    bmk = 'bmk'
    bml = 'bml'
    bmm = 'bmm'
    bmn = 'bmn'
    bmo = 'bmo'
    bmp = 'bmp'
    bmq = 'bmq'
    bmr = 'bmr'
    bms = 'bms'
    bmt = 'bmt'
    bmu = 'bmu'
    bmv = 'bmv'
    bmw = 'bmw'
    bmx = 'bmx'
    bmz = 'bmz'
    bna = 'bna'
    bnb = 'bnb'
    bnc = 'bnc'
    bnd = 'bnd'
    bne = 'bne'
    bnf = 'bnf'
    bng = 'bng'
    bni = 'bni'
    bnj = 'bnj'
    bnk = 'bnk'
    bnl = 'bnl'
    bnm = 'bnm'
    bnn = 'bnn'
    bno = 'bno'
    bnp = 'bnp'
    bnq = 'bnq'
    bnr = 'bnr'
    bns = 'bns'
    bnu = 'bnu'
    bnv = 'bnv'
    bnw = 'bnw'
    bnx = 'bnx'
    bny = 'bny'
    bnz = 'bnz'
    boa = 'boa'
    bob = 'bob'
    bod = 'bod'
    boe = 'boe'
    bof = 'bof'
    bog = 'bog'
    boh = 'boh'
    boi = 'boi'
    boj = 'boj'
    bok = 'bok'
    bol = 'bol'
    bom = 'bom'
    bon = 'bon'
    boo = 'boo'
    bop = 'bop'
    boq = 'boq'
    bor = 'bor'
    bos = 'bos'
    bot = 'bot'
    bou = 'bou'
    bov = 'bov'
    bow = 'bow'
    box = 'box'
    boy = 'boy'
    boz = 'boz'
    bpa = 'bpa'
    bpc = 'bpc'
    bpd = 'bpd'
    bpe = 'bpe'
    bpg = 'bpg'
    bph = 'bph'
    bpi = 'bpi'
    bpj = 'bpj'
    bpk = 'bpk'
    bpl = 'bpl'
    bpm = 'bpm'
    bpn = 'bpn'
    bpo = 'bpo'
    bpp = 'bpp'
    bpq = 'bpq'
    bpr = 'bpr'
    bps = 'bps'
    bpt = 'bpt'
    bpu = 'bpu'
    bpv = 'bpv'
    bpw = 'bpw'
    bpx = 'bpx'
    bpy = 'bpy'
    bpz = 'bpz'
    bqa = 'bqa'
    bqb = 'bqb'
    bqc = 'bqc'
    bqd = 'bqd'
    bqf = 'bqf'
    bqg = 'bqg'
    bqh = 'bqh'
    bqi = 'bqi'
    bqj = 'bqj'
    bqk = 'bqk'
    bql = 'bql'
    bqm = 'bqm'
    bqn = 'bqn'
    bqo = 'bqo'
    bqp = 'bqp'
    bqq = 'bqq'
    bqr = 'bqr'
    bqs = 'bqs'
    bqt = 'bqt'
    bqu = 'bqu'
    bqv = 'bqv'
    bqw = 'bqw'
    bqx = 'bqx'
    bqy = 'bqy'
    bqz = 'bqz'
    bra = 'bra'
    brb = 'brb'
    brc = 'brc'
    brd = 'brd'
    bre = 'bre'
    brf = 'brf'
    brg = 'brg'
    brh = 'brh'
    bri = 'bri'
    brj = 'brj'
    brk = 'brk'
    brl = 'brl'
    brm = 'brm'
    brn = 'brn'
    bro = 'bro'
    brp = 'brp'
    brq = 'brq'
    brr = 'brr'
    brs = 'brs'
    brt = 'brt'
    bru = 'bru'
    brv = 'brv'
    brw = 'brw'
    brx = 'brx'
    bry = 'bry'
    brz = 'brz'
    bsa = 'bsa'
    bsb = 'bsb'
    bsc = 'bsc'
    bse = 'bse'
    bsf = 'bsf'
    bsg = 'bsg'
    bsh = 'bsh'
    bsi = 'bsi'
    bsj = 'bsj'
    bsk = 'bsk'
    bsl = 'bsl'
    bsm = 'bsm'
    bsn = 'bsn'
    bso = 'bso'
    bsp = 'bsp'
    bsq = 'bsq'
    bsr = 'bsr'
    bss = 'bss'
    bst = 'bst'
    bsu = 'bsu'
    bsv = 'bsv'
    bsw = 'bsw'
    bsx = 'bsx'
    bsy = 'bsy'
    bta = 'bta'
    btc = 'btc'
    btd = 'btd'
    bte = 'bte'
    btf = 'btf'
    btg = 'btg'
    bth = 'bth'
    bti = 'bti'
    btj = 'btj'
    btm = 'btm'
    btn = 'btn'
    bto = 'bto'
    btp = 'btp'
    btq = 'btq'
    btr = 'btr'
    bts = 'bts'
    btt = 'btt'
    btu = 'btu'
    btv = 'btv'
    btw = 'btw'
    btx = 'btx'
    bty = 'bty'
    btz = 'btz'
    bua = 'bua'
    bub = 'bub'
    buc = 'buc'
    bud = 'bud'
    bue = 'bue'
    buf = 'buf'
    bug = 'bug'
    buh = 'buh'
    bui = 'bui'
    buj = 'buj'
    buk = 'buk'
    bul = 'bul'
    bum = 'bum'
    bun = 'bun'
    buo = 'buo'
    bup = 'bup'
    buq = 'buq'
    bus = 'bus'
    but = 'but'
    buu = 'buu'
    buv = 'buv'
    buw = 'buw'
    bux = 'bux'
    buy = 'buy'
    buz = 'buz'
    bva = 'bva'
    bvb = 'bvb'
    bvc = 'bvc'
    bvd = 'bvd'
    bve = 'bve'
    bvf = 'bvf'
    bvg = 'bvg'
    bvh = 'bvh'
    bvi = 'bvi'
    bvj = 'bvj'
    bvk = 'bvk'
    bvl = 'bvl'
    bvm = 'bvm'
    bvn = 'bvn'
    bvo = 'bvo'
    bvp = 'bvp'
    bvq = 'bvq'
    bvr = 'bvr'
    bvt = 'bvt'
    bvu = 'bvu'
    bvv = 'bvv'
    bvw = 'bvw'
    bvx = 'bvx'
    bvy = 'bvy'
    bvz = 'bvz'
    bwa = 'bwa'
    bwb = 'bwb'
    bwc = 'bwc'
    bwd = 'bwd'
    bwe = 'bwe'
    bwf = 'bwf'
    bwg = 'bwg'
    bwh = 'bwh'
    bwi = 'bwi'
    bwj = 'bwj'
    bwk = 'bwk'
    bwl = 'bwl'
    bwm = 'bwm'
    bwn = 'bwn'
    bwo = 'bwo'
    bwp = 'bwp'
    bwq = 'bwq'
    bwr = 'bwr'
    bws = 'bws'
    bwt = 'bwt'
    bwu = 'bwu'
    bww = 'bww'
    bwx = 'bwx'
    bwy = 'bwy'
    bwz = 'bwz'
    bxa = 'bxa'
    bxb = 'bxb'
    bxc = 'bxc'
    bxd = 'bxd'
    bxe = 'bxe'
    bxf = 'bxf'
    bxg = 'bxg'
    bxh = 'bxh'
    bxi = 'bxi'
    bxj = 'bxj'
    bxk = 'bxk'
    bxl = 'bxl'
    bxm = 'bxm'
    bxn = 'bxn'
    bxo = 'bxo'
    bxp = 'bxp'
    bxq = 'bxq'
    bxr = 'bxr'
    bxs = 'bxs'
    bxu = 'bxu'
    bxv = 'bxv'
    bxw = 'bxw'
    bxz = 'bxz'
    bya = 'bya'
    byb = 'byb'
    byc = 'byc'
    byd = 'byd'
    bye = 'bye'
    byf = 'byf'
    byg = 'byg'
    byh = 'byh'
    byi = 'byi'
    byj = 'byj'
    byk = 'byk'
    byl = 'byl'
    bym = 'bym'
    byn = 'byn'
    byo = 'byo'
    byp = 'byp'
    byq = 'byq'
    byr = 'byr'
    bys = 'bys'
    byt = 'byt'
    byv = 'byv'
    byw = 'byw'
    byx = 'byx'
    byz = 'byz'
    bza = 'bza'
    bzb = 'bzb'
    bzc = 'bzc'
    bzd = 'bzd'
    bze = 'bze'
    bzf = 'bzf'
    bzg = 'bzg'
    bzh = 'bzh'
    bzi = 'bzi'
    bzj = 'bzj'
    bzk = 'bzk'
    bzl = 'bzl'
    bzm = 'bzm'
    bzn = 'bzn'
    bzo = 'bzo'
    bzp = 'bzp'
    bzq = 'bzq'
    bzr = 'bzr'
    bzs = 'bzs'
    bzt = 'bzt'
    bzu = 'bzu'
    bzv = 'bzv'
    bzw = 'bzw'
    bzx = 'bzx'
    bzy = 'bzy'
    bzz = 'bzz'
    caa = 'caa'
    cab = 'cab'
    cac = 'cac'
    cad = 'cad'
    cae = 'cae'
    caf = 'caf'
    cag = 'cag'
    cah = 'cah'
    caj = 'caj'
    cak = 'cak'
    cal = 'cal'
    cam = 'cam'
    can = 'can'
    cao = 'cao'
    cap = 'cap'
    caq = 'caq'
    car = 'car'
    cas = 'cas'
    cat = 'cat'
    cav = 'cav'
    caw = 'caw'
    cax = 'cax'
    cay = 'cay'
    caz = 'caz'
    cbb = 'cbb'
    cbc = 'cbc'
    cbd = 'cbd'
    cbg = 'cbg'
    cbi = 'cbi'
    cbj = 'cbj'
    cbk = 'cbk'
    cbl = 'cbl'
    cbn = 'cbn'
    cbo = 'cbo'
    cbq = 'cbq'
    cbr = 'cbr'
    cbs = 'cbs'
    cbt = 'cbt'
    cbu = 'cbu'
    cbv = 'cbv'
    cbw = 'cbw'
    cby = 'cby'
    ccc = 'ccc'
    ccd = 'ccd'
    cce = 'cce'
    ccg = 'ccg'
    cch = 'cch'
    ccj = 'ccj'
    ccl = 'ccl'
    ccm = 'ccm'
    cco = 'cco'
    ccp = 'ccp'
    ccr = 'ccr'
    cda = 'cda'
    cde = 'cde'
    cdf = 'cdf'
    cdh = 'cdh'
    cdi = 'cdi'
    cdj = 'cdj'
    cdm = 'cdm'
    cdn = 'cdn'
    cdo = 'cdo'
    cdr = 'cdr'
    cds = 'cds'
    cdy = 'cdy'
    cdz = 'cdz'
    cea = 'cea'
    ceb = 'ceb'
    ceg = 'ceg'
    cek = 'cek'
    cen = 'cen'
    ces = 'ces'
    cet = 'cet'
    cey = 'cey'
    cfa = 'cfa'
    cfd = 'cfd'
    cfg = 'cfg'
    cfm = 'cfm'
    cga = 'cga'
    cgc = 'cgc'
    cgg = 'cgg'
    cgk = 'cgk'
    cha = 'cha'
    chb = 'chb'
    chc = 'chc'
    chd = 'chd'
    che = 'che'
    chf = 'chf'
    chg = 'chg'
    chh = 'chh'
    chj = 'chj'
    chk = 'chk'
    chl = 'chl'
    chm = 'chm'
    chn = 'chn'
    cho = 'cho'
    chp = 'chp'
    chq = 'chq'
    chr = 'chr'
    cht = 'cht'
    chu = 'chu'
    chv = 'chv'
    chw = 'chw'
    chx = 'chx'
    chy = 'chy'
    chz = 'chz'
    cia = 'cia'
    cib = 'cib'
    cic = 'cic'
    cid = 'cid'
    cie = 'cie'
    cih = 'cih'
    cik = 'cik'
    cim = 'cim'
    cin = 'cin'
    cip = 'cip'
    cir = 'cir'
    ciw = 'ciw'
    ciy = 'ciy'
    cja = 'cja'
    cje = 'cje'
    cjh = 'cjh'
    cji = 'cji'
    cjk = 'cjk'
    cjm = 'cjm'
    cjn = 'cjn'
    cjo = 'cjo'
    cjp = 'cjp'
    cjs = 'cjs'
    cjv = 'cjv'
    cjy = 'cjy'
    ckb = 'ckb'
    ckh = 'ckh'
    ckl = 'ckl'
    ckm = 'ckm'
    ckn = 'ckn'
    cko = 'cko'
    ckq = 'ckq'
    ckr = 'ckr'
    cks = 'cks'
    ckt = 'ckt'
    cku = 'cku'
    ckv = 'ckv'
    ckx = 'ckx'
    cky = 'cky'
    ckz = 'ckz'
    cla = 'cla'
    clc = 'clc'
    cld = 'cld'
    cle = 'cle'
    clh = 'clh'
    cli = 'cli'
    clj = 'clj'
    clk = 'clk'
    cll = 'cll'
    clm = 'clm'
    clo = 'clo'
    clt = 'clt'
    clu = 'clu'
    clw = 'clw'
    cly = 'cly'
    cma = 'cma'
    cme = 'cme'
    cmg = 'cmg'
    cmi = 'cmi'
    cml = 'cml'
    cmm = 'cmm'
    cmn = 'cmn'
    cmo = 'cmo'
    cmr = 'cmr'
    cms = 'cms'
    cmt = 'cmt'
    cna = 'cna'
    cnb = 'cnb'
    cnc = 'cnc'
    cng = 'cng'
    cnh = 'cnh'
    cni = 'cni'
    cnk = 'cnk'
    cnl = 'cnl'
    cno = 'cno'
    cnp = 'cnp'
    cnq = 'cnq'
    cnr = 'cnr'
    cns = 'cns'
    cnt = 'cnt'
    cnu = 'cnu'
    cnw = 'cnw'
    cnx = 'cnx'
    coa = 'coa'
    cob = 'cob'
    coc = 'coc'
    cod = 'cod'
    coe = 'coe'
    cof = 'cof'
    cog = 'cog'
    coh = 'coh'
    coj = 'coj'
    cok = 'cok'
    col = 'col'
    com = 'com'
    con = 'con'
    coo = 'coo'
    cop = 'cop'
    coq = 'coq'
    cor = 'cor'
    cos = 'cos'
    cot = 'cot'
    cou = 'cou'
    cov = 'cov'
    cow = 'cow'
    cox = 'cox'
    coz = 'coz'
    cpa = 'cpa'
    cpb = 'cpb'
    cpc = 'cpc'
    cpg = 'cpg'
    cpi = 'cpi'
    cpn = 'cpn'
    cpo = 'cpo'
    cps = 'cps'
    cpu = 'cpu'
    cpx = 'cpx'
    cpy = 'cpy'
    cqd = 'cqd'
    cra = 'cra'
    crb = 'crb'
    crc = 'crc'
    crd = 'crd'
    cre = 'cre'
    crf = 'crf'
    crg = 'crg'
    crh = 'crh'
    cri = 'cri'
    crj = 'crj'
    crk = 'crk'
    crl = 'crl'
    crm = 'crm'
    crn = 'crn'
    cro = 'cro'
    crq = 'crq'
    crr = 'crr'
    crs = 'crs'
    crt = 'crt'
    crv = 'crv'
    crw = 'crw'
    crx = 'crx'
    cry = 'cry'
    crz = 'crz'
    csa = 'csa'
    csb = 'csb'
    csc = 'csc'
    csd = 'csd'
    cse = 'cse'
    csf = 'csf'
    csg = 'csg'
    csh = 'csh'
    csi = 'csi'
    csj = 'csj'
    csk = 'csk'
    csl = 'csl'
    csm = 'csm'
    csn = 'csn'
    cso = 'cso'
    csp = 'csp'
    csq = 'csq'
    csr = 'csr'
    css = 'css'
    cst = 'cst'
    csv = 'csv'
    csw = 'csw'
    csx = 'csx'
    csy = 'csy'
    csz = 'csz'
    cta = 'cta'
    ctc = 'ctc'
    ctd = 'ctd'
    cte = 'cte'
    ctg = 'ctg'
    cth = 'cth'
    ctl = 'ctl'
    ctm = 'ctm'
    ctn = 'ctn'
    cto = 'cto'
    ctp = 'ctp'
    cts = 'cts'
    ctt = 'ctt'
    ctu = 'ctu'
    cty = 'cty'
    ctz = 'ctz'
    cua = 'cua'
    cub = 'cub'
    cuc = 'cuc'
    cuh = 'cuh'
    cui = 'cui'
    cuj = 'cuj'
    cuk = 'cuk'
    cul = 'cul'
    cuo = 'cuo'
    cup = 'cup'
    cuq = 'cuq'
    cur = 'cur'
    cut = 'cut'
    cuu = 'cuu'
    cuv = 'cuv'
    cuw = 'cuw'
    cux = 'cux'
    cuy = 'cuy'
    cvg = 'cvg'
    cvn = 'cvn'
    cwa = 'cwa'
    cwb = 'cwb'
    cwd = 'cwd'
    cwe = 'cwe'
    cwg = 'cwg'
    cwt = 'cwt'
    cya = 'cya'
    cyb = 'cyb'
    cym = 'cym'
    cyo = 'cyo'
    czh = 'czh'
    czk = 'czk'
    czn = 'czn'
    czo = 'czo'
    czt = 'czt'
    daa = 'daa'
    dac = 'dac'
    dad = 'dad'
    dae = 'dae'
    dag = 'dag'
    dah = 'dah'
    dai = 'dai'
    daj = 'daj'
    dak = 'dak'
    dal = 'dal'
    dam = 'dam'
    dan = 'dan'
    dao = 'dao'
    daq = 'daq'
    dar = 'dar'
    das = 'das'
    dau = 'dau'
    dav = 'dav'
    daw = 'daw'
    dax = 'dax'
    daz = 'daz'
    dba = 'dba'
    dbb = 'dbb'
    dbd = 'dbd'
    dbe = 'dbe'
    dbf = 'dbf'
    dbg = 'dbg'
    dbi = 'dbi'
    dbj = 'dbj'
    dbl = 'dbl'
    dbm = 'dbm'
    dbn = 'dbn'
    dbo = 'dbo'
    dbp = 'dbp'
    dbq = 'dbq'
    dbr = 'dbr'
    dbt = 'dbt'
    dbu = 'dbu'
    dbv = 'dbv'
    dbw = 'dbw'
    dby = 'dby'
    dcc = 'dcc'
    dcr = 'dcr'
    dda = 'dda'
    ddd = 'ddd'
    dde = 'dde'
    ddg = 'ddg'
    ddi = 'ddi'
    ddj = 'ddj'
    ddn = 'ddn'
    ddo = 'ddo'
    ddr = 'ddr'
    dds = 'dds'
    ddw = 'ddw'
    dec = 'dec'
    ded = 'ded'
    dee = 'dee'
    def_ = 'def'
    deg = 'deg'
    deh = 'deh'
    dei = 'dei'
    dek = 'dek'
    del_ = 'del'
    dem = 'dem'
    den = 'den'
    dep = 'dep'
    deq = 'deq'
    der = 'der'
    des = 'des'
    deu = 'deu'
    dev = 'dev'
    dez = 'dez'
    dga = 'dga'
    dgb = 'dgb'
    dgc = 'dgc'
    dgd = 'dgd'
    dge = 'dge'
    dgg = 'dgg'
    dgh = 'dgh'
    dgi = 'dgi'
    dgk = 'dgk'
    dgl = 'dgl'
    dgn = 'dgn'
    dgo = 'dgo'
    dgr = 'dgr'
    dgs = 'dgs'
    dgt = 'dgt'
    dgw = 'dgw'
    dgx = 'dgx'
    dgz = 'dgz'
    dhd = 'dhd'
    dhg = 'dhg'
    dhi = 'dhi'
    dhl = 'dhl'
    dhm = 'dhm'
    dhn = 'dhn'
    dho = 'dho'
    dhr = 'dhr'
    dhs = 'dhs'
    dhu = 'dhu'
    dhv = 'dhv'
    dhw = 'dhw'
    dhx = 'dhx'
    dia = 'dia'
    dib = 'dib'
    dic = 'dic'
    did = 'did'
    dif = 'dif'
    dig = 'dig'
    dih = 'dih'
    dii = 'dii'
    dij = 'dij'
    dik = 'dik'
    dil = 'dil'
    dim = 'dim'
    din = 'din'
    dio = 'dio'
    dip = 'dip'
    diq = 'diq'
    dir = 'dir'
    dis = 'dis'
    diu = 'diu'
    div = 'div'
    diw = 'diw'
    dix = 'dix'
    diy = 'diy'
    diz = 'diz'
    dja = 'dja'
    djb = 'djb'
    djc = 'djc'
    djd = 'djd'
    dje = 'dje'
    djf = 'djf'
    dji = 'dji'
    djj = 'djj'
    djk = 'djk'
    djm = 'djm'
    djn = 'djn'
    djo = 'djo'
    djr = 'djr'
    dju = 'dju'
    djw = 'djw'
    dka = 'dka'
    dkg = 'dkg'
    dkk = 'dkk'
    dkr = 'dkr'
    dks = 'dks'
    dkx = 'dkx'
    dlg = 'dlg'
    dlk = 'dlk'
    dlm = 'dlm'
    dln = 'dln'
    dma = 'dma'
    dmb = 'dmb'
    dmc = 'dmc'
    dmd = 'dmd'
    dme = 'dme'
    dmf = 'dmf'
    dmg = 'dmg'
    dmk = 'dmk'
    dml = 'dml'
    dmm = 'dmm'
    dmo = 'dmo'
    dmr = 'dmr'
    dms = 'dms'
    dmu = 'dmu'
    dmv = 'dmv'
    dmw = 'dmw'
    dmx = 'dmx'
    dmy = 'dmy'
    dna = 'dna'
    dnd = 'dnd'
    dne = 'dne'
    dng = 'dng'
    dni = 'dni'
    dnj = 'dnj'
    dnk = 'dnk'
    dnn = 'dnn'
    dno = 'dno'
    dnr = 'dnr'
    dnt = 'dnt'
    dnu = 'dnu'
    dnv = 'dnv'
    dnw = 'dnw'
    dny = 'dny'
    doa = 'doa'
    dob = 'dob'
    doc = 'doc'
    doe = 'doe'
    dof = 'dof'
    doh = 'doh'
    doi = 'doi'
    dok = 'dok'
    dol = 'dol'
    don = 'don'
    doo = 'doo'
    dop = 'dop'
    doq = 'doq'
    dor = 'dor'
    dos = 'dos'
    dot = 'dot'
    dov = 'dov'
    dow = 'dow'
    dox = 'dox'
    doy = 'doy'
    doz = 'doz'
    dpp = 'dpp'
    drb = 'drb'
    drc = 'drc'
    drd = 'drd'
    dre = 'dre'
    drg = 'drg'
    dri = 'dri'
    drl = 'drl'
    drn = 'drn'
    dro = 'dro'
    drq = 'drq'
    drs = 'drs'
    drt = 'drt'
    dru = 'dru'
    dry = 'dry'
    dsb = 'dsb'
    dse = 'dse'
    dsh = 'dsh'
    dsi = 'dsi'
    dsl = 'dsl'
    dsn = 'dsn'
    dso = 'dso'
    dsq = 'dsq'
    dsz = 'dsz'
    dta = 'dta'
    dtb = 'dtb'
    dtd = 'dtd'
    dth = 'dth'
    dti = 'dti'
    dtk = 'dtk'
    dtm = 'dtm'
    dtn = 'dtn'
    dto = 'dto'
    dtp = 'dtp'
    dtr = 'dtr'
    dts = 'dts'
    dtt = 'dtt'
    dtu = 'dtu'
    dty = 'dty'
    dua = 'dua'
    dub = 'dub'
    duc = 'duc'
    due = 'due'
    duf = 'duf'
    dug = 'dug'
    duh = 'duh'
    dui = 'dui'
    duk = 'duk'
    dul = 'dul'
    dum = 'dum'
    dun = 'dun'
    duo = 'duo'
    dup = 'dup'
    duq = 'duq'
    dur = 'dur'
    dus = 'dus'
    duu = 'duu'
    duv = 'duv'
    duw = 'duw'
    dux = 'dux'
    duy = 'duy'
    duz = 'duz'
    dva = 'dva'
    dwa = 'dwa'
    dwk = 'dwk'
    dwr = 'dwr'
    dws = 'dws'
    dwu = 'dwu'
    dww = 'dww'
    dwy = 'dwy'
    dwz = 'dwz'
    dya = 'dya'
    dyb = 'dyb'
    dyd = 'dyd'
    dyg = 'dyg'
    dyi = 'dyi'
    dym = 'dym'
    dyn = 'dyn'
    dyo = 'dyo'
    dyu = 'dyu'
    dyy = 'dyy'
    dza = 'dza'
    dze = 'dze'
    dzg = 'dzg'
    dzl = 'dzl'
    dzn = 'dzn'
    dzo = 'dzo'
    eaa = 'eaa'
    ebc = 'ebc'
    ebg = 'ebg'
    ebk = 'ebk'
    ebo = 'ebo'
    ebr = 'ebr'
    ebu = 'ebu'
    ecr = 'ecr'
    ecs = 'ecs'
    ecy = 'ecy'
    eee = 'eee'
    efa = 'efa'
    efe = 'efe'
    efi = 'efi'
    ega = 'ega'
    egl = 'egl'
    egm = 'egm'
    ego = 'ego'
    egy = 'egy'
    ehs = 'ehs'
    ehu = 'ehu'
    eip = 'eip'
    eit = 'eit'
    eiv = 'eiv'
    eja = 'eja'
    eka = 'eka'
    eke = 'eke'
    ekg = 'ekg'
    eki = 'eki'
    ekk = 'ekk'
    ekl = 'ekl'
    ekm = 'ekm'
    eko = 'eko'
    ekp = 'ekp'
    ekr = 'ekr'
    eky = 'eky'
    ele = 'ele'
    elh = 'elh'
    eli = 'eli'
    elk = 'elk'
    ell = 'ell'
    elm = 'elm'
    elo = 'elo'
    elu = 'elu'
    elx = 'elx'
    ema = 'ema'
    emb = 'emb'
    eme = 'eme'
    emg = 'emg'
    emi = 'emi'
    emk = 'emk'
    emm = 'emm'
    emn = 'emn'
    emp = 'emp'
    emq = 'emq'
    ems = 'ems'
    emu = 'emu'
    emw = 'emw'
    emx = 'emx'
    emy = 'emy'
    emz = 'emz'
    ena = 'ena'
    enb = 'enb'
    enc = 'enc'
    end = 'end'
    enf = 'enf'
    eng = 'eng'
    enh = 'enh'
    enl = 'enl'
    enm = 'enm'
    enn = 'enn'
    eno = 'eno'
    enq = 'enq'
    enr = 'enr'
    enu = 'enu'
    env = 'env'
    enw = 'enw'
    enx = 'enx'
    eot = 'eot'
    epi = 'epi'
    epo = 'epo'
    era = 'era'
    erg = 'erg'
    erh = 'erh'
    eri = 'eri'
    erk = 'erk'
    ero = 'ero'
    err = 'err'
    ers = 'ers'
    ert = 'ert'
    erw = 'erw'
    ese = 'ese'
    esg = 'esg'
    esh = 'esh'
    esi = 'esi'
    esk = 'esk'
    esl = 'esl'
    esm = 'esm'
    esn = 'esn'
    eso = 'eso'
    esq = 'esq'
    ess = 'ess'
    est = 'est'
    esu = 'esu'
    esy = 'esy'
    etb = 'etb'
    etc = 'etc'
    eth = 'eth'
    etn = 'etn'
    eto = 'eto'
    etr = 'etr'
    ets = 'ets'
    ett = 'ett'
    etu = 'etu'
    etx = 'etx'
    etz = 'etz'
    eus = 'eus'
    eve = 'eve'
    evh = 'evh'
    evn = 'evn'
    ewe = 'ewe'
    ewo = 'ewo'
    ext = 'ext'
    eya = 'eya'
    eyo = 'eyo'
    eza = 'eza'
    eze = 'eze'
    faa = 'faa'
    fab = 'fab'
    fad = 'fad'
    faf = 'faf'
    fag = 'fag'
    fah = 'fah'
    fai = 'fai'
    faj = 'faj'
    fak = 'fak'
    fal = 'fal'
    fam = 'fam'
    fan = 'fan'
    fao = 'fao'
    fap = 'fap'
    far = 'far'
    fas = 'fas'
    fat = 'fat'
    fau = 'fau'
    fax = 'fax'
    fay = 'fay'
    faz = 'faz'
    fbl = 'fbl'
    fcs = 'fcs'
    fer = 'fer'
    ffi = 'ffi'
    ffm = 'ffm'
    fgr = 'fgr'
    fia = 'fia'
    fie = 'fie'
    fif = 'fif'
    fij = 'fij'
    fil = 'fil'
    fin = 'fin'
    fip = 'fip'
    fir = 'fir'
    fit = 'fit'
    fiw = 'fiw'
    fkk = 'fkk'
    fkv = 'fkv'
    fla = 'fla'
    flh = 'flh'
    fli = 'fli'
    fll = 'fll'
    fln = 'fln'
    flr = 'flr'
    fly = 'fly'
    fmp = 'fmp'
    fmu = 'fmu'
    fnb = 'fnb'
    fng = 'fng'
    fni = 'fni'
    fod = 'fod'
    foi = 'foi'
    fom = 'fom'
    fon = 'fon'
    for_ = 'for'
    fos = 'fos'
    fpe = 'fpe'
    fqs = 'fqs'
    fra = 'fra'
    frc = 'frc'
    frd = 'frd'
    frk = 'frk'
    frm = 'frm'
    fro = 'fro'
    frp = 'frp'
    frq = 'frq'
    frr = 'frr'
    frs = 'frs'
    frt = 'frt'
    fry = 'fry'
    fse = 'fse'
    fsl = 'fsl'
    fss = 'fss'
    fub = 'fub'
    fuc = 'fuc'
    fud = 'fud'
    fue = 'fue'
    fuf = 'fuf'
    fuh = 'fuh'
    fui = 'fui'
    fuj = 'fuj'
    ful = 'ful'
    fum = 'fum'
    fun = 'fun'
    fuq = 'fuq'
    fur = 'fur'
    fut = 'fut'
    fuu = 'fuu'
    fuv = 'fuv'
    fuy = 'fuy'
    fvr = 'fvr'
    fwa = 'fwa'
    fwe = 'fwe'
    gaa = 'gaa'
    gab = 'gab'
    gac = 'gac'
    gad = 'gad'
    gae = 'gae'
    gaf = 'gaf'
    gag = 'gag'
    gah = 'gah'
    gai = 'gai'
    gaj = 'gaj'
    gak = 'gak'
    gal = 'gal'
    gam = 'gam'
    gan = 'gan'
    gao = 'gao'
    gap = 'gap'
    gaq = 'gaq'
    gar = 'gar'
    gas = 'gas'
    gat = 'gat'
    gau = 'gau'
    gaw = 'gaw'
    gax = 'gax'
    gay = 'gay'
    gaz = 'gaz'
    gba = 'gba'
    gbb = 'gbb'
    gbd = 'gbd'
    gbe = 'gbe'
    gbf = 'gbf'
    gbg = 'gbg'
    gbh = 'gbh'
    gbi = 'gbi'
    gbj = 'gbj'
    gbk = 'gbk'
    gbl = 'gbl'
    gbm = 'gbm'
    gbn = 'gbn'
    gbo = 'gbo'
    gbp = 'gbp'
    gbq = 'gbq'
    gbr = 'gbr'
    gbs = 'gbs'
    gbu = 'gbu'
    gbv = 'gbv'
    gbw = 'gbw'
    gbx = 'gbx'
    gby = 'gby'
    gbz = 'gbz'
    gcc = 'gcc'
    gcd = 'gcd'
    gce = 'gce'
    gcf = 'gcf'
    gcl = 'gcl'
    gcn = 'gcn'
    gcr = 'gcr'
    gct = 'gct'
    gda = 'gda'
    gdb = 'gdb'
    gdc = 'gdc'
    gdd = 'gdd'
    gde = 'gde'
    gdf = 'gdf'
    gdg = 'gdg'
    gdh = 'gdh'
    gdi = 'gdi'
    gdj = 'gdj'
    gdk = 'gdk'
    gdl = 'gdl'
    gdm = 'gdm'
    gdn = 'gdn'
    gdo = 'gdo'
    gdq = 'gdq'
    gdr = 'gdr'
    gds = 'gds'
    gdt = 'gdt'
    gdu = 'gdu'
    gdx = 'gdx'
    gea = 'gea'
    geb = 'geb'
    gec = 'gec'
    ged = 'ged'
    gef = 'gef'
    geg = 'geg'
    geh = 'geh'
    gei = 'gei'
    gej = 'gej'
    gek = 'gek'
    gel = 'gel'
    geq = 'geq'
    ges = 'ges'
    gev = 'gev'
    gew = 'gew'
    gex = 'gex'
    gey = 'gey'
    gez = 'gez'
    gfk = 'gfk'
    gft = 'gft'
    gga = 'gga'
    ggb = 'ggb'
    ggd = 'ggd'
    gge = 'gge'
    ggg = 'ggg'
    ggk = 'ggk'
    ggl = 'ggl'
    ggt = 'ggt'
    ggu = 'ggu'
    ggw = 'ggw'
    gha = 'gha'
    ghc = 'ghc'
    ghe = 'ghe'
    ghh = 'ghh'
    ghk = 'ghk'
    ghl = 'ghl'
    ghn = 'ghn'
    gho = 'gho'
    ghr = 'ghr'
    ghs = 'ghs'
    ght = 'ght'
    gia = 'gia'
    gib = 'gib'
    gic = 'gic'
    gid = 'gid'
    gie = 'gie'
    gig = 'gig'
    gih = 'gih'
    gii = 'gii'
    gil = 'gil'
    gim = 'gim'
    gin = 'gin'
    gip = 'gip'
    giq = 'giq'
    gir = 'gir'
    gis = 'gis'
    git = 'git'
    giu = 'giu'
    giw = 'giw'
    gix = 'gix'
    giy = 'giy'
    giz = 'giz'
    gjk = 'gjk'
    gjm = 'gjm'
    gjn = 'gjn'
    gjr = 'gjr'
    gju = 'gju'
    gka = 'gka'
    gkd = 'gkd'
    gke = 'gke'
    gkn = 'gkn'
    gko = 'gko'
    gkp = 'gkp'
    gku = 'gku'
    gla = 'gla'
    glb = 'glb'
    glc = 'glc'
    gld = 'gld'
    gle = 'gle'
    glg = 'glg'
    glh = 'glh'
    glj = 'glj'
    glk = 'glk'
    gll = 'gll'
    glo = 'glo'
    glr = 'glr'
    glu = 'glu'
    glv = 'glv'
    glw = 'glw'
    gly = 'gly'
    gma = 'gma'
    gmb = 'gmb'
    gmd = 'gmd'
    gmg = 'gmg'
    gmh = 'gmh'
    gml = 'gml'
    gmm = 'gmm'
    gmn = 'gmn'
    gmr = 'gmr'
    gmu = 'gmu'
    gmv = 'gmv'
    gmx = 'gmx'
    gmy = 'gmy'
    gmz = 'gmz'
    gna = 'gna'
    gnb = 'gnb'
    gnc = 'gnc'
    gnd = 'gnd'
    gne = 'gne'
    gng = 'gng'
    gnh = 'gnh'
    gni = 'gni'
    gnj = 'gnj'
    gnk = 'gnk'
    gnl = 'gnl'
    gnm = 'gnm'
    gnn = 'gnn'
    gno = 'gno'
    gnq = 'gnq'
    gnr = 'gnr'
    gnt = 'gnt'
    gnu = 'gnu'
    gnw = 'gnw'
    gnz = 'gnz'
    goa = 'goa'
    gob = 'gob'
    goc = 'goc'
    god = 'god'
    goe = 'goe'
    gof = 'gof'
    gog = 'gog'
    goh = 'goh'
    goi = 'goi'
    goj = 'goj'
    gok = 'gok'
    gol = 'gol'
    gom = 'gom'
    gon = 'gon'
    goo = 'goo'
    gop = 'gop'
    goq = 'goq'
    gor = 'gor'
    gos = 'gos'
    got = 'got'
    gou = 'gou'
    gov = 'gov'
    gow = 'gow'
    gox = 'gox'
    goy = 'goy'
    goz = 'goz'
    gpa = 'gpa'
    gpe = 'gpe'
    gpn = 'gpn'
    gqa = 'gqa'
    gqi = 'gqi'
    gqn = 'gqn'
    gqr = 'gqr'
    gqu = 'gqu'
    gra = 'gra'
    grb = 'grb'
    grc = 'grc'
    grd = 'grd'
    grg = 'grg'
    grh = 'grh'
    gri = 'gri'
    grj = 'grj'
    grm = 'grm'
    grn = 'grn'
    gro = 'gro'
    grq = 'grq'
    grr = 'grr'
    grs = 'grs'
    grt = 'grt'
    gru = 'gru'
    grv = 'grv'
    grw = 'grw'
    grx = 'grx'
    gry = 'gry'
    grz = 'grz'
    gse = 'gse'
    gsg = 'gsg'
    gsl = 'gsl'
    gsm = 'gsm'
    gsn = 'gsn'
    gso = 'gso'
    gsp = 'gsp'
    gss = 'gss'
    gsw = 'gsw'
    gta = 'gta'
    gtu = 'gtu'
    gua = 'gua'
    gub = 'gub'
    guc = 'guc'
    gud = 'gud'
    gue = 'gue'
    guf = 'guf'
    gug = 'gug'
    guh = 'guh'
    gui = 'gui'
    guj = 'guj'
    guk = 'guk'
    gul = 'gul'
    gum = 'gum'
    gun = 'gun'
    guo = 'guo'
    gup = 'gup'
    guq = 'guq'
    gur = 'gur'
    gus = 'gus'
    gut = 'gut'
    guu = 'guu'
    guw = 'guw'
    gux = 'gux'
    guz = 'guz'
    gva = 'gva'
    gvc = 'gvc'
    gve = 'gve'
    gvf = 'gvf'
    gvj = 'gvj'
    gvl = 'gvl'
    gvm = 'gvm'
    gvn = 'gvn'
    gvo = 'gvo'
    gvp = 'gvp'
    gvr = 'gvr'
    gvs = 'gvs'
    gvy = 'gvy'
    gwa = 'gwa'
    gwb = 'gwb'
    gwc = 'gwc'
    gwd = 'gwd'
    gwe = 'gwe'
    gwf = 'gwf'
    gwg = 'gwg'
    gwi = 'gwi'
    gwj = 'gwj'
    gwm = 'gwm'
    gwn = 'gwn'
    gwr = 'gwr'
    gwt = 'gwt'
    gwu = 'gwu'
    gww = 'gww'
    gwx = 'gwx'
    gxx = 'gxx'
    gya = 'gya'
    gyb = 'gyb'
    gyd = 'gyd'
    gye = 'gye'
    gyf = 'gyf'
    gyg = 'gyg'
    gyi = 'gyi'
    gyl = 'gyl'
    gym = 'gym'
    gyn = 'gyn'
    gyo = 'gyo'
    gyr = 'gyr'
    gyy = 'gyy'
    gyz = 'gyz'
    gza = 'gza'
    gzi = 'gzi'
    gzn = 'gzn'
    haa = 'haa'
    hab = 'hab'
    hac = 'hac'
    had = 'had'
    hae = 'hae'
    haf = 'haf'
    hag = 'hag'
    hah = 'hah'
    hai = 'hai'
    haj = 'haj'
    hak = 'hak'
    hal = 'hal'
    ham = 'ham'
    han = 'han'
    hao = 'hao'
    hap = 'hap'
    haq = 'haq'
    har = 'har'
    has = 'has'
    hat = 'hat'
    hau = 'hau'
    hav = 'hav'
    haw = 'haw'
    hax = 'hax'
    hay = 'hay'
    haz = 'haz'
    hba = 'hba'
    hbb = 'hbb'
    hbn = 'hbn'
    hbo = 'hbo'
    hbs = 'hbs'
    hbu = 'hbu'
    hca = 'hca'
    hch = 'hch'
    hdn = 'hdn'
    hds = 'hds'
    hdy = 'hdy'
    hea = 'hea'
    heb = 'heb'
    hed = 'hed'
    heg = 'heg'
    heh = 'heh'
    hei = 'hei'
    hem = 'hem'
    her = 'her'
    hgm = 'hgm'
    hgw = 'hgw'
    hhi = 'hhi'
    hhr = 'hhr'
    hhy = 'hhy'
    hia = 'hia'
    hib = 'hib'
    hid = 'hid'
    hif = 'hif'
    hig = 'hig'
    hih = 'hih'
    hii = 'hii'
    hij = 'hij'
    hik = 'hik'
    hil = 'hil'
    hin = 'hin'
    hio = 'hio'
    hir = 'hir'
    hit = 'hit'
    hiw = 'hiw'
    hix = 'hix'
    hji = 'hji'
    hka = 'hka'
    hke = 'hke'
    hkh = 'hkh'
    hkk = 'hkk'
    hkn = 'hkn'
    hks = 'hks'
    hla = 'hla'
    hlb = 'hlb'
    hld = 'hld'
    hle = 'hle'
    hlt = 'hlt'
    hlu = 'hlu'
    hma = 'hma'
    hmb = 'hmb'
    hmc = 'hmc'
    hmd = 'hmd'
    hme = 'hme'
    hmf = 'hmf'
    hmg = 'hmg'
    hmh = 'hmh'
    hmi = 'hmi'
    hmj = 'hmj'
    hmk = 'hmk'
    hml = 'hml'
    hmm = 'hmm'
    hmn = 'hmn'
    hmo = 'hmo'
    hmp = 'hmp'
    hmq = 'hmq'
    hmr = 'hmr'
    hms = 'hms'
    hmt = 'hmt'
    hmu = 'hmu'
    hmv = 'hmv'
    hmw = 'hmw'
    hmy = 'hmy'
    hmz = 'hmz'
    hna = 'hna'
    hnd = 'hnd'
    hne = 'hne'
    hng = 'hng'
    hnh = 'hnh'
    hni = 'hni'
    hnj = 'hnj'
    hnn = 'hnn'
    hno = 'hno'
    hns = 'hns'
    hnu = 'hnu'
    hoa = 'hoa'
    hob = 'hob'
    hoc = 'hoc'
    hod = 'hod'
    hoe = 'hoe'
    hoh = 'hoh'
    hoi = 'hoi'
    hoj = 'hoj'
    hol = 'hol'
    hom = 'hom'
    hoo = 'hoo'
    hop = 'hop'
    hor = 'hor'
    hos = 'hos'
    hot = 'hot'
    hov = 'hov'
    how = 'how'
    hoy = 'hoy'
    hoz = 'hoz'
    hpo = 'hpo'
    hps = 'hps'
    hra = 'hra'
    hrc = 'hrc'
    hre = 'hre'
    hrk = 'hrk'
    hrm = 'hrm'
    hro = 'hro'
    hrp = 'hrp'
    hrt = 'hrt'
    hru = 'hru'
    hrv = 'hrv'
    hrw = 'hrw'
    hrx = 'hrx'
    hrz = 'hrz'
    hsb = 'hsb'
    hsh = 'hsh'
    hsl = 'hsl'
    hsn = 'hsn'
    hss = 'hss'
    hti = 'hti'
    hto = 'hto'
    hts = 'hts'
    htu = 'htu'
    htx = 'htx'
    hub = 'hub'
    huc = 'huc'
    hud = 'hud'
    hue = 'hue'
    huf = 'huf'
    hug = 'hug'
    huh = 'huh'
    hui = 'hui'
    huj = 'huj'
    huk = 'huk'
    hul = 'hul'
    hum = 'hum'
    hun = 'hun'
    huo = 'huo'
    hup = 'hup'
    huq = 'huq'
    hur = 'hur'
    hus = 'hus'
    hut = 'hut'
    huu = 'huu'
    huv = 'huv'
    huw = 'huw'
    hux = 'hux'
    huy = 'huy'
    huz = 'huz'
    hvc = 'hvc'
    hve = 'hve'
    hvk = 'hvk'
    hvn = 'hvn'
    hvv = 'hvv'
    hwa = 'hwa'
    hwc = 'hwc'
    hwo = 'hwo'
    hya = 'hya'
    hye = 'hye'
    hyw = 'hyw'
    iai = 'iai'
    ian = 'ian'
    iar = 'iar'
    iba = 'iba'
    ibb = 'ibb'
    ibd = 'ibd'
    ibe = 'ibe'
    ibg = 'ibg'
    ibh = 'ibh'
    ibl = 'ibl'
    ibm = 'ibm'
    ibn = 'ibn'
    ibo = 'ibo'
    ibr = 'ibr'
    ibu = 'ibu'
    iby = 'iby'
    ica = 'ica'
    ich = 'ich'
    icl = 'icl'
    icr = 'icr'
    ida = 'ida'
    idb = 'idb'
    idc = 'idc'
    idd = 'idd'
    ide = 'ide'
    idi = 'idi'
    ido = 'ido'
    idr = 'idr'
    ids = 'ids'
    idt = 'idt'
    idu = 'idu'
    ifa = 'ifa'
    ifb = 'ifb'
    ife = 'ife'
    iff = 'iff'
    ifk = 'ifk'
    ifm = 'ifm'
    ifu = 'ifu'
    ify = 'ify'
    igb = 'igb'
    ige = 'ige'
    igg = 'igg'
    igl = 'igl'
    igm = 'igm'
    ign = 'ign'
    igo = 'igo'
    igs = 'igs'
    igw = 'igw'
    ihb = 'ihb'
    ihi = 'ihi'
    ihp = 'ihp'
    ihw = 'ihw'
    iii = 'iii'
    iin = 'iin'
    ijc = 'ijc'
    ije = 'ije'
    ijj = 'ijj'
    ijn = 'ijn'
    ijs = 'ijs'
    ike = 'ike'
    iki = 'iki'
    ikk = 'ikk'
    ikl = 'ikl'
    iko = 'iko'
    ikp = 'ikp'
    ikr = 'ikr'
    iks = 'iks'
    ikt = 'ikt'
    iku = 'iku'
    ikv = 'ikv'
    ikw = 'ikw'
    ikx = 'ikx'
    ikz = 'ikz'
    ila = 'ila'
    ilb = 'ilb'
    ile = 'ile'
    ilg = 'ilg'
    ili = 'ili'
    ilk = 'ilk'
    ilm = 'ilm'
    ilo = 'ilo'
    ilp = 'ilp'
    ils = 'ils'
    ilu = 'ilu'
    ilv = 'ilv'
    ima = 'ima'
    imi = 'imi'
    iml = 'iml'
    imn = 'imn'
    imo = 'imo'
    imr = 'imr'
    ims = 'ims'
    imt = 'imt'
    imy = 'imy'
    ina = 'ina'
    inb = 'inb'
    ind = 'ind'
    ing = 'ing'
    inh = 'inh'
    inj = 'inj'
    inl = 'inl'
    inm = 'inm'
    inn = 'inn'
    ino = 'ino'
    inp = 'inp'
    ins = 'ins'
    int = 'int'
    inz = 'inz'
    ior = 'ior'
    iou = 'iou'
    iow = 'iow'
    ipi = 'ipi'
    ipk = 'ipk'
    ipo = 'ipo'
    iqu = 'iqu'
    iqw = 'iqw'
    ire = 'ire'
    irh = 'irh'
    iri = 'iri'
    irk = 'irk'
    irn = 'irn'
    irr = 'irr'
    iru = 'iru'
    irx = 'irx'
    iry = 'iry'
    isa = 'isa'
    isc = 'isc'
    isd = 'isd'
    ise = 'ise'
    isg = 'isg'
    ish = 'ish'
    isi = 'isi'
    isk = 'isk'
    isl = 'isl'
    ism = 'ism'
    isn = 'isn'
    iso = 'iso'
    isr = 'isr'
    ist = 'ist'
    isu = 'isu'
    ita = 'ita'
    itb = 'itb'
    itd = 'itd'
    ite = 'ite'
    iti = 'iti'
    itk = 'itk'
    itl = 'itl'
    itm = 'itm'
    ito = 'ito'
    itr = 'itr'
    its = 'its'
    itt = 'itt'
    itv = 'itv'
    itw = 'itw'
    itx = 'itx'
    ity = 'ity'
    itz = 'itz'
    ium = 'ium'
    ivb = 'ivb'
    ivv = 'ivv'
    iwk = 'iwk'
    iwm = 'iwm'
    iwo = 'iwo'
    iws = 'iws'
    ixc = 'ixc'
    ixl = 'ixl'
    iya = 'iya'
    iyo = 'iyo'
    iyx = 'iyx'
    izh = 'izh'
    izr = 'izr'
    izz = 'izz'
    jaa = 'jaa'
    jab = 'jab'
    jac = 'jac'
    jad = 'jad'
    jae = 'jae'
    jaf = 'jaf'
    jah = 'jah'
    jaj = 'jaj'
    jak = 'jak'
    jal = 'jal'
    jam = 'jam'
    jan = 'jan'
    jao = 'jao'
    jaq = 'jaq'
    jas = 'jas'
    jat = 'jat'
    jau = 'jau'
    jav = 'jav'
    jax = 'jax'
    jay = 'jay'
    jaz = 'jaz'
    jbe = 'jbe'
    jbi = 'jbi'
    jbj = 'jbj'
    jbk = 'jbk'
    jbm = 'jbm'
    jbn = 'jbn'
    jbo = 'jbo'
    jbr = 'jbr'
    jbt = 'jbt'
    jbu = 'jbu'
    jbw = 'jbw'
    jcs = 'jcs'
    jct = 'jct'
    jda = 'jda'
    jdg = 'jdg'
    jdt = 'jdt'
    jeb = 'jeb'
    jee = 'jee'
    jeh = 'jeh'
    jei = 'jei'
    jek = 'jek'
    jel = 'jel'
    jen = 'jen'
    jer = 'jer'
    jet = 'jet'
    jeu = 'jeu'
    jgb = 'jgb'
    jge = 'jge'
    jgk = 'jgk'
    jgo = 'jgo'
    jhi = 'jhi'
    jhs = 'jhs'
    jia = 'jia'
    jib = 'jib'
    jic = 'jic'
    jid = 'jid'
    jie = 'jie'
    jig = 'jig'
    jih = 'jih'
    jii = 'jii'
    jil = 'jil'
    jim = 'jim'
    jio = 'jio'
    jiq = 'jiq'
    jit = 'jit'
    jiu = 'jiu'
    jiv = 'jiv'
    jiy = 'jiy'
    jje = 'jje'
    jjr = 'jjr'
    jka = 'jka'
    jkm = 'jkm'
    jko = 'jko'
    jkp = 'jkp'
    jkr = 'jkr'
    jks = 'jks'
    jku = 'jku'
    jle = 'jle'
    jls = 'jls'
    jma = 'jma'
    jmb = 'jmb'
    jmc = 'jmc'
    jmd = 'jmd'
    jmi = 'jmi'
    jml = 'jml'
    jmn = 'jmn'
    jmr = 'jmr'
    jms = 'jms'
    jmw = 'jmw'
    jmx = 'jmx'
    jna = 'jna'
    jnd = 'jnd'
    jng = 'jng'
    jni = 'jni'
    jnj = 'jnj'
    jnl = 'jnl'
    jns = 'jns'
    job = 'job'
    jod = 'jod'
    jog = 'jog'
    jor = 'jor'
    jos = 'jos'
    jow = 'jow'
    jpa = 'jpa'
    jpn = 'jpn'
    jpr = 'jpr'
    jqr = 'jqr'
    jra = 'jra'
    jrb = 'jrb'
    jrr = 'jrr'
    jrt = 'jrt'
    jru = 'jru'
    jsl = 'jsl'
    jua = 'jua'
    jub = 'jub'
    juc = 'juc'
    jud = 'jud'
    juh = 'juh'
    jui = 'jui'
    juk = 'juk'
    jul = 'jul'
    jum = 'jum'
    jun = 'jun'
    juo = 'juo'
    jup = 'jup'
    jur = 'jur'
    jus = 'jus'
    jut = 'jut'
    juu = 'juu'
    juw = 'juw'
    juy = 'juy'
    jvd = 'jvd'
    jvn = 'jvn'
    jwi = 'jwi'
    jya = 'jya'
    jye = 'jye'
    jyy = 'jyy'
    kaa = 'kaa'
    kab = 'kab'
    kac = 'kac'
    kad = 'kad'
    kae = 'kae'
    kaf = 'kaf'
    kag = 'kag'
    kah = 'kah'
    kai = 'kai'
    kaj = 'kaj'
    kak = 'kak'
    kal = 'kal'
    kam = 'kam'
    kan = 'kan'
    kao = 'kao'
    kap = 'kap'
    kaq = 'kaq'
    kas = 'kas'
    kat = 'kat'
    kau = 'kau'
    kav = 'kav'
    kaw = 'kaw'
    kax = 'kax'
    kay = 'kay'
    kaz = 'kaz'
    kba = 'kba'
    kbb = 'kbb'
    kbc = 'kbc'
    kbd = 'kbd'
    kbe = 'kbe'
    kbg = 'kbg'
    kbh = 'kbh'
    kbi = 'kbi'
    kbj = 'kbj'
    kbk = 'kbk'
    kbl = 'kbl'
    kbm = 'kbm'
    kbn = 'kbn'
    kbo = 'kbo'
    kbp = 'kbp'
    kbq = 'kbq'
    kbr = 'kbr'
    kbs = 'kbs'
    kbt = 'kbt'
    kbu = 'kbu'
    kbv = 'kbv'
    kbw = 'kbw'
    kbx = 'kbx'
    kby = 'kby'
    kbz = 'kbz'
    kca = 'kca'
    kcb = 'kcb'
    kcc = 'kcc'
    kcd = 'kcd'
    kce = 'kce'
    kcf = 'kcf'
    kcg = 'kcg'
    kch = 'kch'
    kci = 'kci'
    kcj = 'kcj'
    kck = 'kck'
    kcl = 'kcl'
    kcm = 'kcm'
    kcn = 'kcn'
    kco = 'kco'
    kcp = 'kcp'
    kcq = 'kcq'
    kcr = 'kcr'
    kcs = 'kcs'
    kct = 'kct'
    kcu = 'kcu'
    kcv = 'kcv'
    kcw = 'kcw'
    kcx = 'kcx'
    kcy = 'kcy'
    kcz = 'kcz'
    kda = 'kda'
    kdc = 'kdc'
    kdd = 'kdd'
    kde = 'kde'
    kdf = 'kdf'
    kdg = 'kdg'
    kdh = 'kdh'
    kdi = 'kdi'
    kdj = 'kdj'
    kdk = 'kdk'
    kdl = 'kdl'
    kdm = 'kdm'
    kdn = 'kdn'
    kdp = 'kdp'
    kdq = 'kdq'
    kdr = 'kdr'
    kdt = 'kdt'
    kdu = 'kdu'
    kdw = 'kdw'
    kdx = 'kdx'
    kdy = 'kdy'
    kdz = 'kdz'
    kea = 'kea'
    keb = 'keb'
    kec = 'kec'
    ked = 'ked'
    kee = 'kee'
    kef = 'kef'
    keg = 'keg'
    keh = 'keh'
    kei = 'kei'
    kej = 'kej'
    kek = 'kek'
    kel = 'kel'
    kem = 'kem'
    ken = 'ken'
    keo = 'keo'
    kep = 'kep'
    keq = 'keq'
    ker = 'ker'
    kes = 'kes'
    ket = 'ket'
    keu = 'keu'
    kev = 'kev'
    kew = 'kew'
    kex = 'kex'
    key = 'key'
    kez = 'kez'
    kfa = 'kfa'
    kfb = 'kfb'
    kfc = 'kfc'
    kfd = 'kfd'
    kfe = 'kfe'
    kff = 'kff'
    kfg = 'kfg'
    kfh = 'kfh'
    kfi = 'kfi'
    kfj = 'kfj'
    kfk = 'kfk'
    kfl = 'kfl'
    kfm = 'kfm'
    kfn = 'kfn'
    kfo = 'kfo'
    kfp = 'kfp'
    kfq = 'kfq'
    kfr = 'kfr'
    kfs = 'kfs'
    kft = 'kft'
    kfu = 'kfu'
    kfv = 'kfv'
    kfw = 'kfw'
    kfx = 'kfx'
    kfy = 'kfy'
    kfz = 'kfz'
    kga = 'kga'
    kgb = 'kgb'
    kge = 'kge'
    kgf = 'kgf'
    kgg = 'kgg'
    kgi = 'kgi'
    kgj = 'kgj'
    kgk = 'kgk'
    kgl = 'kgl'
    kgm = 'kgm'
    kgn = 'kgn'
    kgo = 'kgo'
    kgp = 'kgp'
    kgq = 'kgq'
    kgr = 'kgr'
    kgs = 'kgs'
    kgt = 'kgt'
    kgu = 'kgu'
    kgv = 'kgv'
    kgw = 'kgw'
    kgx = 'kgx'
    kgy = 'kgy'
    kha = 'kha'
    khb = 'khb'
    khc = 'khc'
    khd = 'khd'
    khe = 'khe'
    khf = 'khf'
    khg = 'khg'
    khh = 'khh'
    khj = 'khj'
    khk = 'khk'
    khl = 'khl'
    khm = 'khm'
    khn = 'khn'
    kho = 'kho'
    khp = 'khp'
    khq = 'khq'
    khr = 'khr'
    khs = 'khs'
    kht = 'kht'
    khu = 'khu'
    khv = 'khv'
    khw = 'khw'
    khx = 'khx'
    khy = 'khy'
    khz = 'khz'
    kia = 'kia'
    kib = 'kib'
    kic = 'kic'
    kid = 'kid'
    kie = 'kie'
    kif = 'kif'
    kig = 'kig'
    kih = 'kih'
    kii = 'kii'
    kij = 'kij'
    kik = 'kik'
    kil = 'kil'
    kim = 'kim'
    kin = 'kin'
    kio = 'kio'
    kip = 'kip'
    kiq = 'kiq'
    kir = 'kir'
    kis = 'kis'
    kit = 'kit'
    kiu = 'kiu'
    kiv = 'kiv'
    kiw = 'kiw'
    kix = 'kix'
    kiy = 'kiy'
    kiz = 'kiz'
    kja = 'kja'
    kjb = 'kjb'
    kjc = 'kjc'
    kjd = 'kjd'
    kje = 'kje'
    kjg = 'kjg'
    kjh = 'kjh'
    kji = 'kji'
    kjj = 'kjj'
    kjk = 'kjk'
    kjl = 'kjl'
    kjm = 'kjm'
    kjn = 'kjn'
    kjo = 'kjo'
    kjp = 'kjp'
    kjq = 'kjq'
    kjr = 'kjr'
    kjs = 'kjs'
    kjt = 'kjt'
    kju = 'kju'
    kjv = 'kjv'
    kjx = 'kjx'
    kjy = 'kjy'
    kjz = 'kjz'
    kka = 'kka'
    kkb = 'kkb'
    kkc = 'kkc'
    kkd = 'kkd'
    kke = 'kke'
    kkf = 'kkf'
    kkg = 'kkg'
    kkh = 'kkh'
    kki = 'kki'
    kkj = 'kkj'
    kkk = 'kkk'
    kkl = 'kkl'
    kkm = 'kkm'
    kkn = 'kkn'
    kko = 'kko'
    kkp = 'kkp'
    kkq = 'kkq'
    kkr = 'kkr'
    kks = 'kks'
    kkt = 'kkt'
    kku = 'kku'
    kkv = 'kkv'
    kkw = 'kkw'
    kkx = 'kkx'
    kky = 'kky'
    kkz = 'kkz'
    kla = 'kla'
    klb = 'klb'
    klc = 'klc'
    kld = 'kld'
    kle = 'kle'
    klf = 'klf'
    klg = 'klg'
    klh = 'klh'
    kli = 'kli'
    klj = 'klj'
    klk = 'klk'
    kll = 'kll'
    klm = 'klm'
    kln = 'kln'
    klo = 'klo'
    klp = 'klp'
    klq = 'klq'
    klr = 'klr'
    kls = 'kls'
    klt = 'klt'
    klu = 'klu'
    klv = 'klv'
    klw = 'klw'
    klx = 'klx'
    kly = 'kly'
    klz = 'klz'
    kma = 'kma'
    kmb = 'kmb'
    kmc = 'kmc'
    kmd = 'kmd'
    kme = 'kme'
    kmf = 'kmf'
    kmg = 'kmg'
    kmh = 'kmh'
    kmi = 'kmi'
    kmj = 'kmj'
    kmk = 'kmk'
    kml = 'kml'
    kmm = 'kmm'
    kmn = 'kmn'
    kmo = 'kmo'
    kmp = 'kmp'
    kmq = 'kmq'
    kmr = 'kmr'
    kms = 'kms'
    kmt = 'kmt'
    kmu = 'kmu'
    kmv = 'kmv'
    kmw = 'kmw'
    kmx = 'kmx'
    kmy = 'kmy'
    kmz = 'kmz'
    kna = 'kna'
    knb = 'knb'
    knc = 'knc'
    knd = 'knd'
    kne = 'kne'
    knf = 'knf'
    kng = 'kng'
    kni = 'kni'
    knj = 'knj'
    knk = 'knk'
    knl = 'knl'
    knm = 'knm'
    knn = 'knn'
    kno = 'kno'
    knp = 'knp'
    knq = 'knq'
    knr = 'knr'
    kns = 'kns'
    knt = 'knt'
    knu = 'knu'
    knv = 'knv'
    knw = 'knw'
    knx = 'knx'
    kny = 'kny'
    knz = 'knz'
    koa = 'koa'
    koc = 'koc'
    kod = 'kod'
    koe = 'koe'
    kof = 'kof'
    kog = 'kog'
    koh = 'koh'
    koi = 'koi'
    kok = 'kok'
    kol = 'kol'
    kom = 'kom'
    kon = 'kon'
    koo = 'koo'
    kop = 'kop'
    koq = 'koq'
    kor = 'kor'
    kos = 'kos'
    kot = 'kot'
    kou = 'kou'
    kov = 'kov'
    kow = 'kow'
    koy = 'koy'
    koz = 'koz'
    kpa = 'kpa'
    kpb = 'kpb'
    kpc = 'kpc'
    kpd = 'kpd'
    kpe = 'kpe'
    kpf = 'kpf'
    kpg = 'kpg'
    kph = 'kph'
    kpi = 'kpi'
    kpj = 'kpj'
    kpk = 'kpk'
    kpl = 'kpl'
    kpm = 'kpm'
    kpn = 'kpn'
    kpo = 'kpo'
    kpq = 'kpq'
    kpr = 'kpr'
    kps = 'kps'
    kpt = 'kpt'
    kpu = 'kpu'
    kpv = 'kpv'
    kpw = 'kpw'
    kpx = 'kpx'
    kpy = 'kpy'
    kpz = 'kpz'
    kqa = 'kqa'
    kqb = 'kqb'
    kqc = 'kqc'
    kqd = 'kqd'
    kqe = 'kqe'
    kqf = 'kqf'
    kqg = 'kqg'
    kqh = 'kqh'
    kqi = 'kqi'
    kqj = 'kqj'
    kqk = 'kqk'
    kql = 'kql'
    kqm = 'kqm'
    kqn = 'kqn'
    kqo = 'kqo'
    kqp = 'kqp'
    kqq = 'kqq'
    kqr = 'kqr'
    kqs = 'kqs'
    kqt = 'kqt'
    kqu = 'kqu'
    kqv = 'kqv'
    kqw = 'kqw'
    kqx = 'kqx'
    kqy = 'kqy'
    kqz = 'kqz'
    kra = 'kra'
    krb = 'krb'
    krc = 'krc'
    krd = 'krd'
    kre = 'kre'
    krf = 'krf'
    krh = 'krh'
    kri = 'kri'
    krj = 'krj'
    krk = 'krk'
    krl = 'krl'
    krn = 'krn'
    krp = 'krp'
    krr = 'krr'
    krs = 'krs'
    krt = 'krt'
    kru = 'kru'
    krv = 'krv'
    krw = 'krw'
    krx = 'krx'
    kry = 'kry'
    krz = 'krz'
    ksa = 'ksa'
    ksb = 'ksb'
    ksc = 'ksc'
    ksd = 'ksd'
    kse = 'kse'
    ksf = 'ksf'
    ksg = 'ksg'
    ksh = 'ksh'
    ksi = 'ksi'
    ksj = 'ksj'
    ksk = 'ksk'
    ksl = 'ksl'
    ksm = 'ksm'
    ksn = 'ksn'
    kso = 'kso'
    ksp = 'ksp'
    ksq = 'ksq'
    ksr = 'ksr'
    kss = 'kss'
    kst = 'kst'
    ksu = 'ksu'
    ksv = 'ksv'
    ksw = 'ksw'
    ksx = 'ksx'
    ksy = 'ksy'
    ksz = 'ksz'
    kta = 'kta'
    ktb = 'ktb'
    ktc = 'ktc'
    ktd = 'ktd'
    kte = 'kte'
    ktf = 'ktf'
    ktg = 'ktg'
    kth = 'kth'
    kti = 'kti'
    ktj = 'ktj'
    ktk = 'ktk'
    ktl = 'ktl'
    ktm = 'ktm'
    ktn = 'ktn'
    kto = 'kto'
    ktp = 'ktp'
    ktq = 'ktq'
    kts = 'kts'
    ktt = 'ktt'
    ktu = 'ktu'
    ktv = 'ktv'
    ktw = 'ktw'
    ktx = 'ktx'
    kty = 'kty'
    ktz = 'ktz'
    kua = 'kua'
    kub = 'kub'
    kuc = 'kuc'
    kud = 'kud'
    kue = 'kue'
    kuf = 'kuf'
    kug = 'kug'
    kuh = 'kuh'
    kui = 'kui'
    kuj = 'kuj'
    kuk = 'kuk'
    kul = 'kul'
    kum = 'kum'
    kun = 'kun'
    kuo = 'kuo'
    kup = 'kup'
    kuq = 'kuq'
    kur = 'kur'
    kus = 'kus'
    kut = 'kut'
    kuu = 'kuu'
    kuv = 'kuv'
    kuw = 'kuw'
    kux = 'kux'
    kuy = 'kuy'
    kuz = 'kuz'
    kva = 'kva'
    kvb = 'kvb'
    kvc = 'kvc'
    kvd = 'kvd'
    kve = 'kve'
    kvf = 'kvf'
    kvg = 'kvg'
    kvh = 'kvh'
    kvi = 'kvi'
    kvj = 'kvj'
    kvk = 'kvk'
    kvl = 'kvl'
    kvm = 'kvm'
    kvn = 'kvn'
    kvo = 'kvo'
    kvp = 'kvp'
    kvq = 'kvq'
    kvr = 'kvr'
    kvt = 'kvt'
    kvu = 'kvu'
    kvv = 'kvv'
    kvw = 'kvw'
    kvx = 'kvx'
    kvy = 'kvy'
    kvz = 'kvz'
    kwa = 'kwa'
    kwb = 'kwb'
    kwc = 'kwc'
    kwd = 'kwd'
    kwe = 'kwe'
    kwf = 'kwf'
    kwg = 'kwg'
    kwh = 'kwh'
    kwi = 'kwi'
    kwj = 'kwj'
    kwk = 'kwk'
    kwl = 'kwl'
    kwm = 'kwm'
    kwn = 'kwn'
    kwo = 'kwo'
    kwp = 'kwp'
    kwr = 'kwr'
    kws = 'kws'
    kwt = 'kwt'
    kwu = 'kwu'
    kwv = 'kwv'
    kww = 'kww'
    kwx = 'kwx'
    kwy = 'kwy'
    kwz = 'kwz'
    kxa = 'kxa'
    kxb = 'kxb'
    kxc = 'kxc'
    kxd = 'kxd'
    kxf = 'kxf'
    kxh = 'kxh'
    kxi = 'kxi'
    kxj = 'kxj'
    kxk = 'kxk'
    kxm = 'kxm'
    kxn = 'kxn'
    kxo = 'kxo'
    kxp = 'kxp'
    kxq = 'kxq'
    kxr = 'kxr'
    kxs = 'kxs'
    kxt = 'kxt'
    kxv = 'kxv'
    kxw = 'kxw'
    kxx = 'kxx'
    kxy = 'kxy'
    kxz = 'kxz'
    kya = 'kya'
    kyb = 'kyb'
    kyc = 'kyc'
    kyd = 'kyd'
    kye = 'kye'
    kyf = 'kyf'
    kyg = 'kyg'
    kyh = 'kyh'
    kyi = 'kyi'
    kyj = 'kyj'
    kyk = 'kyk'
    kyl = 'kyl'
    kym = 'kym'
    kyn = 'kyn'
    kyo = 'kyo'
    kyp = 'kyp'
    kyq = 'kyq'
    kyr = 'kyr'
    kys = 'kys'
    kyt = 'kyt'
    kyu = 'kyu'
    kyv = 'kyv'
    kyw = 'kyw'
    kyx = 'kyx'
    kyy = 'kyy'
    kyz = 'kyz'
    kza = 'kza'
    kzb = 'kzb'
    kzc = 'kzc'
    kzd = 'kzd'
    kze = 'kze'
    kzf = 'kzf'
    kzg = 'kzg'
    kzi = 'kzi'
    kzk = 'kzk'
    kzl = 'kzl'
    kzm = 'kzm'
    kzn = 'kzn'
    kzo = 'kzo'
    kzp = 'kzp'
    kzq = 'kzq'
    kzr = 'kzr'
    kzs = 'kzs'
    kzu = 'kzu'
    kzv = 'kzv'
    kzw = 'kzw'
    kzx = 'kzx'
    kzy = 'kzy'
    kzz = 'kzz'
    laa = 'laa'
    lab = 'lab'
    lac = 'lac'
    lad = 'lad'
    lae = 'lae'
    laf = 'laf'
    lag = 'lag'
    lah = 'lah'
    lai = 'lai'
    laj = 'laj'
    lal = 'lal'
    lam = 'lam'
    lan = 'lan'
    lao = 'lao'
    lap = 'lap'
    laq = 'laq'
    lar = 'lar'
    las = 'las'
    lat = 'lat'
    lau = 'lau'
    lav = 'lav'
    law = 'law'
    lax = 'lax'
    lay = 'lay'
    laz = 'laz'
    lbb = 'lbb'
    lbc = 'lbc'
    lbe = 'lbe'
    lbf = 'lbf'
    lbg = 'lbg'
    lbi = 'lbi'
    lbj = 'lbj'
    lbk = 'lbk'
    lbl = 'lbl'
    lbm = 'lbm'
    lbn = 'lbn'
    lbo = 'lbo'
    lbq = 'lbq'
    lbr = 'lbr'
    lbs = 'lbs'
    lbt = 'lbt'
    lbu = 'lbu'
    lbv = 'lbv'
    lbw = 'lbw'
    lbx = 'lbx'
    lby = 'lby'
    lbz = 'lbz'
    lcc = 'lcc'
    lcd = 'lcd'
    lce = 'lce'
    lcf = 'lcf'
    lch = 'lch'
    lcl = 'lcl'
    lcm = 'lcm'
    lcp = 'lcp'
    lcq = 'lcq'
    lcs = 'lcs'
    lda = 'lda'
    ldb = 'ldb'
    ldd = 'ldd'
    ldg = 'ldg'
    ldh = 'ldh'
    ldi = 'ldi'
    ldj = 'ldj'
    ldk = 'ldk'
    ldl = 'ldl'
    ldm = 'ldm'
    ldn = 'ldn'
    ldo = 'ldo'
    ldp = 'ldp'
    ldq = 'ldq'
    lea = 'lea'
    leb = 'leb'
    lec = 'lec'
    led = 'led'
    lee = 'lee'
    lef = 'lef'
    leh = 'leh'
    lei = 'lei'
    lej = 'lej'
    lek = 'lek'
    lel = 'lel'
    lem = 'lem'
    len = 'len'
    leo = 'leo'
    lep = 'lep'
    leq = 'leq'
    ler = 'ler'
    les = 'les'
    let = 'let'
    leu = 'leu'
    lev = 'lev'
    lew = 'lew'
    lex = 'lex'
    ley = 'ley'
    lez = 'lez'
    lfa = 'lfa'
    lfn = 'lfn'
    lga = 'lga'
    lgb = 'lgb'
    lgg = 'lgg'
    lgh = 'lgh'
    lgi = 'lgi'
    lgk = 'lgk'
    lgl = 'lgl'
    lgm = 'lgm'
    lgn = 'lgn'
    lgo = 'lgo'
    lgq = 'lgq'
    lgr = 'lgr'
    lgt = 'lgt'
    lgu = 'lgu'
    lgz = 'lgz'
    lha = 'lha'
    lhh = 'lhh'
    lhi = 'lhi'
    lhl = 'lhl'
    lhm = 'lhm'
    lhn = 'lhn'
    lhp = 'lhp'
    lhs = 'lhs'
    lht = 'lht'
    lhu = 'lhu'
    lia = 'lia'
    lib = 'lib'
    lic = 'lic'
    lid = 'lid'
    lie = 'lie'
    lif = 'lif'
    lig = 'lig'
    lih = 'lih'
    lij = 'lij'
    lik = 'lik'
    lil = 'lil'
    lim = 'lim'
    lin = 'lin'
    lio = 'lio'
    lip = 'lip'
    liq = 'liq'
    lir = 'lir'
    lis = 'lis'
    lit = 'lit'
    liu = 'liu'
    liv = 'liv'
    liw = 'liw'
    lix = 'lix'
    liy = 'liy'
    liz = 'liz'
    lja = 'lja'
    lje = 'lje'
    lji = 'lji'
    ljl = 'ljl'
    ljp = 'ljp'
    ljw = 'ljw'
    ljx = 'ljx'
    lka = 'lka'
    lkb = 'lkb'
    lkc = 'lkc'
    lkd = 'lkd'
    lke = 'lke'
    lkh = 'lkh'
    lki = 'lki'
    lkj = 'lkj'
    lkl = 'lkl'
    lkm = 'lkm'
    lkn = 'lkn'
    lko = 'lko'
    lkr = 'lkr'
    lks = 'lks'
    lkt = 'lkt'
    lku = 'lku'
    lky = 'lky'
    lla = 'lla'
    llb = 'llb'
    llc = 'llc'
    lld = 'lld'
    lle = 'lle'
    llf = 'llf'
    llg = 'llg'
    llh = 'llh'
    lli = 'lli'
    llj = 'llj'
    llk = 'llk'
    lll = 'lll'
    llm = 'llm'
    lln = 'lln'
    llp = 'llp'
    llq = 'llq'
    lls = 'lls'
    llu = 'llu'
    llx = 'llx'
    lma = 'lma'
    lmb = 'lmb'
    lmc = 'lmc'
    lmd = 'lmd'
    lme = 'lme'
    lmf = 'lmf'
    lmg = 'lmg'
    lmh = 'lmh'
    lmi = 'lmi'
    lmj = 'lmj'
    lmk = 'lmk'
    lml = 'lml'
    lmn = 'lmn'
    lmo = 'lmo'
    lmp = 'lmp'
    lmq = 'lmq'
    lmr = 'lmr'
    lmu = 'lmu'
    lmv = 'lmv'
    lmw = 'lmw'
    lmx = 'lmx'
    lmy = 'lmy'
    lna = 'lna'
    lnb = 'lnb'
    lnd = 'lnd'
    lng = 'lng'
    lnh = 'lnh'
    lni = 'lni'
    lnj = 'lnj'
    lnl = 'lnl'
    lnm = 'lnm'
    lnn = 'lnn'
    lns = 'lns'
    lnu = 'lnu'
    lnw = 'lnw'
    lnz = 'lnz'
    loa = 'loa'
    lob = 'lob'
    loc = 'loc'
    loe = 'loe'
    lof = 'lof'
    log = 'log'
    loh = 'loh'
    loi = 'loi'
    loj = 'loj'
    lok = 'lok'
    lol = 'lol'
    lom = 'lom'
    lon = 'lon'
    loo = 'loo'
    lop = 'lop'
    loq = 'loq'
    lor = 'lor'
    los = 'los'
    lot = 'lot'
    lou = 'lou'
    lov = 'lov'
    low = 'low'
    lox = 'lox'
    loy = 'loy'
    loz = 'loz'
    lpa = 'lpa'
    lpe = 'lpe'
    lpn = 'lpn'
    lpo = 'lpo'
    lpx = 'lpx'
    lqr = 'lqr'
    lra = 'lra'
    lrc = 'lrc'
    lre = 'lre'
    lrg = 'lrg'
    lri = 'lri'
    lrk = 'lrk'
    lrl = 'lrl'
    lrm = 'lrm'
    lrn = 'lrn'
    lro = 'lro'
    lrr = 'lrr'
    lrt = 'lrt'
    lrv = 'lrv'
    lrz = 'lrz'
    lsa = 'lsa'
    lsb = 'lsb'
    lsc = 'lsc'
    lsd = 'lsd'
    lse = 'lse'
    lsh = 'lsh'
    lsi = 'lsi'
    lsl = 'lsl'
    lsm = 'lsm'
    lsn = 'lsn'
    lso = 'lso'
    lsp = 'lsp'
    lsr = 'lsr'
    lss = 'lss'
    lst = 'lst'
    lsv = 'lsv'
    lsw = 'lsw'
    lsy = 'lsy'
    ltc = 'ltc'
    ltg = 'ltg'
    lth = 'lth'
    lti = 'lti'
    ltn = 'ltn'
    lto = 'lto'
    lts = 'lts'
    ltu = 'ltu'
    ltz = 'ltz'
    lua = 'lua'
    lub = 'lub'
    luc = 'luc'
    lud = 'lud'
    lue = 'lue'
    luf = 'luf'
    lug = 'lug'
    lui = 'lui'
    luj = 'luj'
    luk = 'luk'
    lul = 'lul'
    lum = 'lum'
    lun = 'lun'
    luo = 'luo'
    lup = 'lup'
    luq = 'luq'
    lur = 'lur'
    lus = 'lus'
    lut = 'lut'
    luu = 'luu'
    luv = 'luv'
    luw = 'luw'
    luy = 'luy'
    luz = 'luz'
    lva = 'lva'
    lvi = 'lvi'
    lvk = 'lvk'
    lvs = 'lvs'
    lvu = 'lvu'
    lwa = 'lwa'
    lwe = 'lwe'
    lwg = 'lwg'
    lwh = 'lwh'
    lwl = 'lwl'
    lwm = 'lwm'
    lwo = 'lwo'
    lws = 'lws'
    lwt = 'lwt'
    lwu = 'lwu'
    lww = 'lww'
    lxm = 'lxm'
    lya = 'lya'
    lyg = 'lyg'
    lyn = 'lyn'
    lzh = 'lzh'
    lzl = 'lzl'
    lzn = 'lzn'
    lzz = 'lzz'
    maa = 'maa'
    mab = 'mab'
    mad = 'mad'
    mae = 'mae'
    maf = 'maf'
    mag = 'mag'
    mah = 'mah'
    mai = 'mai'
    maj = 'maj'
    mak = 'mak'
    mal = 'mal'
    mam = 'mam'
    man = 'man'
    maq = 'maq'
    mar = 'mar'
    mas = 'mas'
    mat = 'mat'
    mau = 'mau'
    mav = 'mav'
    maw = 'maw'
    max = 'max'
    maz = 'maz'
    mba = 'mba'
    mbb = 'mbb'
    mbc = 'mbc'
    mbd = 'mbd'
    mbe = 'mbe'
    mbf = 'mbf'
    mbh = 'mbh'
    mbi = 'mbi'
    mbj = 'mbj'
    mbk = 'mbk'
    mbl = 'mbl'
    mbm = 'mbm'
    mbn = 'mbn'
    mbo = 'mbo'
    mbp = 'mbp'
    mbq = 'mbq'
    mbr = 'mbr'
    mbs = 'mbs'
    mbt = 'mbt'
    mbu = 'mbu'
    mbv = 'mbv'
    mbw = 'mbw'
    mbx = 'mbx'
    mby = 'mby'
    mbz = 'mbz'
    mca = 'mca'
    mcb = 'mcb'
    mcc = 'mcc'
    mcd = 'mcd'
    mce = 'mce'
    mcf = 'mcf'
    mcg = 'mcg'
    mch = 'mch'
    mci = 'mci'
    mcj = 'mcj'
    mck = 'mck'
    mcl = 'mcl'
    mcm = 'mcm'
    mcn = 'mcn'
    mco = 'mco'
    mcp = 'mcp'
    mcq = 'mcq'
    mcr = 'mcr'
    mcs = 'mcs'
    mct = 'mct'
    mcu = 'mcu'
    mcv = 'mcv'
    mcw = 'mcw'
    mcx = 'mcx'
    mcy = 'mcy'
    mcz = 'mcz'
    mda = 'mda'
    mdb = 'mdb'
    mdc = 'mdc'
    mdd = 'mdd'
    mde = 'mde'
    mdf = 'mdf'
    mdg = 'mdg'
    mdh = 'mdh'
    mdi = 'mdi'
    mdj = 'mdj'
    mdk = 'mdk'
    mdl = 'mdl'
    mdm = 'mdm'
    mdn = 'mdn'
    mdp = 'mdp'
    mdq = 'mdq'
    mdr = 'mdr'
    mds = 'mds'
    mdt = 'mdt'
    mdu = 'mdu'
    mdv = 'mdv'
    mdw = 'mdw'
    mdx = 'mdx'
    mdy = 'mdy'
    mdz = 'mdz'
    mea = 'mea'
    meb = 'meb'
    mec = 'mec'
    med = 'med'
    mee = 'mee'
    mef = 'mef'
    meh = 'meh'
    mei = 'mei'
    mej = 'mej'
    mek = 'mek'
    mel = 'mel'
    mem = 'mem'
    men = 'men'
    meo = 'meo'
    mep = 'mep'
    meq = 'meq'
    mer = 'mer'
    mes = 'mes'
    met = 'met'
    meu = 'meu'
    mev = 'mev'
    mew = 'mew'
    mey = 'mey'
    mez = 'mez'
    mfa = 'mfa'
    mfb = 'mfb'
    mfc = 'mfc'
    mfd = 'mfd'
    mfe = 'mfe'
    mff = 'mff'
    mfg = 'mfg'
    mfh = 'mfh'
    mfi = 'mfi'
    mfj = 'mfj'
    mfk = 'mfk'
    mfl = 'mfl'
    mfm = 'mfm'
    mfn = 'mfn'
    mfo = 'mfo'
    mfp = 'mfp'
    mfq = 'mfq'
    mfr = 'mfr'
    mfs = 'mfs'
    mft = 'mft'
    mfu = 'mfu'
    mfv = 'mfv'
    mfw = 'mfw'
    mfx = 'mfx'
    mfy = 'mfy'
    mfz = 'mfz'
    mga = 'mga'
    mgb = 'mgb'
    mgc = 'mgc'
    mgd = 'mgd'
    mge = 'mge'
    mgf = 'mgf'
    mgg = 'mgg'
    mgh = 'mgh'
    mgi = 'mgi'
    mgj = 'mgj'
    mgk = 'mgk'
    mgl = 'mgl'
    mgm = 'mgm'
    mgn = 'mgn'
    mgo = 'mgo'
    mgp = 'mgp'
    mgq = 'mgq'
    mgr = 'mgr'
    mgs = 'mgs'
    mgt = 'mgt'
    mgu = 'mgu'
    mgv = 'mgv'
    mgw = 'mgw'
    mgy = 'mgy'
    mgz = 'mgz'
    mha = 'mha'
    mhb = 'mhb'
    mhc = 'mhc'
    mhd = 'mhd'
    mhe = 'mhe'
    mhf = 'mhf'
    mhg = 'mhg'
    mhi = 'mhi'
    mhj = 'mhj'
    mhk = 'mhk'
    mhl = 'mhl'
    mhm = 'mhm'
    mhn = 'mhn'
    mho = 'mho'
    mhp = 'mhp'
    mhq = 'mhq'
    mhr = 'mhr'
    mhs = 'mhs'
    mht = 'mht'
    mhu = 'mhu'
    mhw = 'mhw'
    mhx = 'mhx'
    mhy = 'mhy'
    mhz = 'mhz'
    mia = 'mia'
    mib = 'mib'
    mic = 'mic'
    mid = 'mid'
    mie = 'mie'
    mif = 'mif'
    mig = 'mig'
    mih = 'mih'
    mii = 'mii'
    mij = 'mij'
    mik = 'mik'
    mil = 'mil'
    mim = 'mim'
    min = 'min'
    mio = 'mio'
    mip = 'mip'
    miq = 'miq'
    mir = 'mir'
    mis = 'mis'
    mit = 'mit'
    miu = 'miu'
    miw = 'miw'
    mix = 'mix'
    miy = 'miy'
    miz = 'miz'
    mjb = 'mjb'
    mjc = 'mjc'
    mjd = 'mjd'
    mje = 'mje'
    mjg = 'mjg'
    mjh = 'mjh'
    mji = 'mji'
    mjj = 'mjj'
    mjk = 'mjk'
    mjl = 'mjl'
    mjm = 'mjm'
    mjn = 'mjn'
    mjo = 'mjo'
    mjp = 'mjp'
    mjq = 'mjq'
    mjr = 'mjr'
    mjs = 'mjs'
    mjt = 'mjt'
    mju = 'mju'
    mjv = 'mjv'
    mjw = 'mjw'
    mjx = 'mjx'
    mjy = 'mjy'
    mjz = 'mjz'
    mka = 'mka'
    mkb = 'mkb'
    mkc = 'mkc'
    mkd = 'mkd'
    mke = 'mke'
    mkf = 'mkf'
    mkg = 'mkg'
    mki = 'mki'
    mkj = 'mkj'
    mkk = 'mkk'
    mkl = 'mkl'
    mkm = 'mkm'
    mkn = 'mkn'
    mko = 'mko'
    mkp = 'mkp'
    mkq = 'mkq'
    mkr = 'mkr'
    mks = 'mks'
    mkt = 'mkt'
    mku = 'mku'
    mkv = 'mkv'
    mkw = 'mkw'
    mkx = 'mkx'
    mky = 'mky'
    mkz = 'mkz'
    mla = 'mla'
    mlb = 'mlb'
    mlc = 'mlc'
    mle = 'mle'
    mlf = 'mlf'
    mlg = 'mlg'
    mlh = 'mlh'
    mli = 'mli'
    mlj = 'mlj'
    mlk = 'mlk'
    mll = 'mll'
    mlm = 'mlm'
    mln = 'mln'
    mlo = 'mlo'
    mlp = 'mlp'
    mlq = 'mlq'
    mlr = 'mlr'
    mls = 'mls'
    mlt = 'mlt'
    mlu = 'mlu'
    mlv = 'mlv'
    mlw = 'mlw'
    mlx = 'mlx'
    mlz = 'mlz'
    mma = 'mma'
    mmb = 'mmb'
    mmc = 'mmc'
    mmd = 'mmd'
    mme = 'mme'
    mmf = 'mmf'
    mmg = 'mmg'
    mmh = 'mmh'
    mmi = 'mmi'
    mmj = 'mmj'
    mmk = 'mmk'
    mml = 'mml'
    mmm = 'mmm'
    mmn = 'mmn'
    mmo = 'mmo'
    mmp = 'mmp'
    mmq = 'mmq'
    mmr = 'mmr'
    mmt = 'mmt'
    mmu = 'mmu'
    mmv = 'mmv'
    mmw = 'mmw'
    mmx = 'mmx'
    mmy = 'mmy'
    mmz = 'mmz'
    mna = 'mna'
    mnb = 'mnb'
    mnc = 'mnc'
    mnd = 'mnd'
    mne = 'mne'
    mnf = 'mnf'
    mng = 'mng'
    mnh = 'mnh'
    mni = 'mni'
    mnj = 'mnj'
    mnk = 'mnk'
    mnl = 'mnl'
    mnm = 'mnm'
    mnn = 'mnn'
    mnp = 'mnp'
    mnq = 'mnq'
    mnr = 'mnr'
    mns = 'mns'
    mnu = 'mnu'
    mnv = 'mnv'
    mnw = 'mnw'
    mnx = 'mnx'
    mny = 'mny'
    mnz = 'mnz'
    moa = 'moa'
    moc = 'moc'
    mod = 'mod'
    moe = 'moe'
    mog = 'mog'
    moh = 'moh'
    moi = 'moi'
    moj = 'moj'
    mok = 'mok'
    mom = 'mom'
    mon = 'mon'
    moo = 'moo'
    mop = 'mop'
    moq = 'moq'
    mor = 'mor'
    mos = 'mos'
    mot = 'mot'
    mou = 'mou'
    mov = 'mov'
    mow = 'mow'
    mox = 'mox'
    moy = 'moy'
    moz = 'moz'
    mpa = 'mpa'
    mpb = 'mpb'
    mpc = 'mpc'
    mpd = 'mpd'
    mpe = 'mpe'
    mpg = 'mpg'
    mph = 'mph'
    mpi = 'mpi'
    mpj = 'mpj'
    mpk = 'mpk'
    mpl = 'mpl'
    mpm = 'mpm'
    mpn = 'mpn'
    mpo = 'mpo'
    mpp = 'mpp'
    mpq = 'mpq'
    mpr = 'mpr'
    mps = 'mps'
    mpt = 'mpt'
    mpu = 'mpu'
    mpv = 'mpv'
    mpw = 'mpw'
    mpx = 'mpx'
    mpy = 'mpy'
    mpz = 'mpz'
    mqa = 'mqa'
    mqb = 'mqb'
    mqc = 'mqc'
    mqe = 'mqe'
    mqf = 'mqf'
    mqg = 'mqg'
    mqh = 'mqh'
    mqi = 'mqi'
    mqj = 'mqj'
    mqk = 'mqk'
    mql = 'mql'
    mqm = 'mqm'
    mqn = 'mqn'
    mqo = 'mqo'
    mqp = 'mqp'
    mqq = 'mqq'
    mqr = 'mqr'
    mqs = 'mqs'
    mqt = 'mqt'
    mqu = 'mqu'
    mqv = 'mqv'
    mqw = 'mqw'
    mqx = 'mqx'
    mqy = 'mqy'
    mqz = 'mqz'
    mra = 'mra'
    mrb = 'mrb'
    mrc = 'mrc'
    mrd = 'mrd'
    mre = 'mre'
    mrf = 'mrf'
    mrg = 'mrg'
    mrh = 'mrh'
    mri = 'mri'
    mrj = 'mrj'
    mrk = 'mrk'
    mrl = 'mrl'
    mrm = 'mrm'
    mrn = 'mrn'
    mro_ = 'mro'
    mrp = 'mrp'
    mrq = 'mrq'
    mrr = 'mrr'
    mrs = 'mrs'
    mrt = 'mrt'
    mru = 'mru'
    mrv = 'mrv'
    mrw = 'mrw'
    mrx = 'mrx'
    mry = 'mry'
    mrz = 'mrz'
    msa = 'msa'
    msb = 'msb'
    msc = 'msc'
    msd = 'msd'
    mse = 'mse'
    msf = 'msf'
    msg = 'msg'
    msh = 'msh'
    msi = 'msi'
    msj = 'msj'
    msk = 'msk'
    msl = 'msl'
    msm = 'msm'
    msn = 'msn'
    mso = 'mso'
    msp = 'msp'
    msq = 'msq'
    msr = 'msr'
    mss = 'mss'
    msu = 'msu'
    msv = 'msv'
    msw = 'msw'
    msx = 'msx'
    msy = 'msy'
    msz = 'msz'
    mta = 'mta'
    mtb = 'mtb'
    mtc = 'mtc'
    mtd = 'mtd'
    mte = 'mte'
    mtf = 'mtf'
    mtg = 'mtg'
    mth = 'mth'
    mti = 'mti'
    mtj = 'mtj'
    mtk = 'mtk'
    mtl = 'mtl'
    mtm = 'mtm'
    mtn = 'mtn'
    mto = 'mto'
    mtp = 'mtp'
    mtq = 'mtq'
    mtr = 'mtr'
    mts = 'mts'
    mtt = 'mtt'
    mtu = 'mtu'
    mtv = 'mtv'
    mtw = 'mtw'
    mtx = 'mtx'
    mty = 'mty'
    mua = 'mua'
    mub = 'mub'
    muc = 'muc'
    mud = 'mud'
    mue = 'mue'
    mug = 'mug'
    muh = 'muh'
    mui = 'mui'
    muj = 'muj'
    muk = 'muk'
    mul = 'mul'
    mum = 'mum'
    muo = 'muo'
    mup = 'mup'
    muq = 'muq'
    mur = 'mur'
    mus = 'mus'
    mut = 'mut'
    muu = 'muu'
    muv = 'muv'
    mux = 'mux'
    muy = 'muy'
    muz = 'muz'
    mva = 'mva'
    mvb = 'mvb'
    mvd = 'mvd'
    mve = 'mve'
    mvf = 'mvf'
    mvg = 'mvg'
    mvh = 'mvh'
    mvi = 'mvi'
    mvk = 'mvk'
    mvl = 'mvl'
    mvn = 'mvn'
    mvo = 'mvo'
    mvp = 'mvp'
    mvq = 'mvq'
    mvr = 'mvr'
    mvs = 'mvs'
    mvt = 'mvt'
    mvu = 'mvu'
    mvv = 'mvv'
    mvw = 'mvw'
    mvx = 'mvx'
    mvy = 'mvy'
    mvz = 'mvz'
    mwa = 'mwa'
    mwb = 'mwb'
    mwc = 'mwc'
    mwe = 'mwe'
    mwf = 'mwf'
    mwg = 'mwg'
    mwh = 'mwh'
    mwi = 'mwi'
    mwk = 'mwk'
    mwl = 'mwl'
    mwm = 'mwm'
    mwn = 'mwn'
    mwo = 'mwo'
    mwp = 'mwp'
    mwq = 'mwq'
    mwr = 'mwr'
    mws = 'mws'
    mwt = 'mwt'
    mwu = 'mwu'
    mwv = 'mwv'
    mww = 'mww'
    mwz = 'mwz'
    mxa = 'mxa'
    mxb = 'mxb'
    mxc = 'mxc'
    mxd = 'mxd'
    mxe = 'mxe'
    mxf = 'mxf'
    mxg = 'mxg'
    mxh = 'mxh'
    mxi = 'mxi'
    mxj = 'mxj'
    mxk = 'mxk'
    mxl = 'mxl'
    mxm = 'mxm'
    mxn = 'mxn'
    mxo = 'mxo'
    mxp = 'mxp'
    mxq = 'mxq'
    mxr = 'mxr'
    mxs = 'mxs'
    mxt = 'mxt'
    mxu = 'mxu'
    mxv = 'mxv'
    mxw = 'mxw'
    mxx = 'mxx'
    mxy = 'mxy'
    mxz = 'mxz'
    mya = 'mya'
    myb = 'myb'
    myc = 'myc'
    mye = 'mye'
    myf = 'myf'
    myg = 'myg'
    myh = 'myh'
    myj = 'myj'
    myk = 'myk'
    myl = 'myl'
    mym = 'mym'
    myo = 'myo'
    myp = 'myp'
    myr = 'myr'
    mys = 'mys'
    myu = 'myu'
    myv = 'myv'
    myw = 'myw'
    myx = 'myx'
    myy = 'myy'
    myz = 'myz'
    mza = 'mza'
    mzb = 'mzb'
    mzc = 'mzc'
    mzd = 'mzd'
    mze = 'mze'
    mzg = 'mzg'
    mzh = 'mzh'
    mzi = 'mzi'
    mzj = 'mzj'
    mzk = 'mzk'
    mzl = 'mzl'
    mzm = 'mzm'
    mzn = 'mzn'
    mzo = 'mzo'
    mzp = 'mzp'
    mzq = 'mzq'
    mzr = 'mzr'
    mzs = 'mzs'
    mzt = 'mzt'
    mzu = 'mzu'
    mzv = 'mzv'
    mzw = 'mzw'
    mzx = 'mzx'
    mzy = 'mzy'
    mzz = 'mzz'
    naa = 'naa'
    nab = 'nab'
    nac = 'nac'
    nae = 'nae'
    naf = 'naf'
    nag = 'nag'
    naj = 'naj'
    nak = 'nak'
    nal = 'nal'
    nam = 'nam'
    nan = 'nan'
    nao = 'nao'
    nap = 'nap'
    naq = 'naq'
    nar = 'nar'
    nas = 'nas'
    nat = 'nat'
    nau = 'nau'
    nav = 'nav'
    naw = 'naw'
    nax = 'nax'
    nay = 'nay'
    naz = 'naz'
    nba = 'nba'
    nbb = 'nbb'
    nbc = 'nbc'
    nbd = 'nbd'
    nbe = 'nbe'
    nbg = 'nbg'
    nbh = 'nbh'
    nbi = 'nbi'
    nbj = 'nbj'
    nbk = 'nbk'
    nbl = 'nbl'
    nbm = 'nbm'
    nbn = 'nbn'
    nbo = 'nbo'
    nbp = 'nbp'
    nbq = 'nbq'
    nbr = 'nbr'
    nbs = 'nbs'
    nbt = 'nbt'
    nbu = 'nbu'
    nbv = 'nbv'
    nbw = 'nbw'
    nby = 'nby'
    nca = 'nca'
    ncb = 'ncb'
    ncc = 'ncc'
    ncd = 'ncd'
    nce = 'nce'
    ncf = 'ncf'
    ncg = 'ncg'
    nch = 'nch'
    nci = 'nci'
    ncj = 'ncj'
    nck = 'nck'
    ncl = 'ncl'
    ncm = 'ncm'
    ncn = 'ncn'
    nco = 'nco'
    ncq = 'ncq'
    ncr = 'ncr'
    ncs = 'ncs'
    nct = 'nct'
    ncu = 'ncu'
    ncx = 'ncx'
    ncz = 'ncz'
    nda = 'nda'
    ndb = 'ndb'
    ndc = 'ndc'
    ndd = 'ndd'
    nde = 'nde'
    ndf = 'ndf'
    ndg = 'ndg'
    ndh = 'ndh'
    ndi = 'ndi'
    ndj = 'ndj'
    ndk = 'ndk'
    ndl = 'ndl'
    ndm = 'ndm'
    ndn = 'ndn'
    ndo = 'ndo'
    ndp = 'ndp'
    ndq = 'ndq'
    ndr = 'ndr'
    nds = 'nds'
    ndt = 'ndt'
    ndu = 'ndu'
    ndv = 'ndv'
    ndw = 'ndw'
    ndx = 'ndx'
    ndy = 'ndy'
    ndz = 'ndz'
    nea = 'nea'
    neb = 'neb'
    nec = 'nec'
    ned = 'ned'
    nee = 'nee'
    nef = 'nef'
    neg = 'neg'
    neh = 'neh'
    nei = 'nei'
    nej = 'nej'
    nek = 'nek'
    nem = 'nem'
    nen = 'nen'
    neo = 'neo'
    nep = 'nep'
    neq = 'neq'
    ner = 'ner'
    nes = 'nes'
    net = 'net'
    neu = 'neu'
    nev = 'nev'
    new = 'new'
    nex = 'nex'
    ney = 'ney'
    nez = 'nez'
    nfa = 'nfa'
    nfd = 'nfd'
    nfl = 'nfl'
    nfr = 'nfr'
    nfu = 'nfu'
    nga = 'nga'
    ngb = 'ngb'
    ngc = 'ngc'
    ngd = 'ngd'
    nge = 'nge'
    ngg = 'ngg'
    ngh = 'ngh'
    ngi = 'ngi'
    ngj = 'ngj'
    ngk = 'ngk'
    ngl = 'ngl'
    ngm = 'ngm'
    ngn = 'ngn'
    ngp = 'ngp'
    ngq = 'ngq'
    ngr = 'ngr'
    ngs = 'ngs'
    ngt = 'ngt'
    ngu = 'ngu'
    ngv = 'ngv'
    ngw = 'ngw'
    ngx = 'ngx'
    ngy = 'ngy'
    ngz = 'ngz'
    nha = 'nha'
    nhb = 'nhb'
    nhc = 'nhc'
    nhd = 'nhd'
    nhe = 'nhe'
    nhf = 'nhf'
    nhg = 'nhg'
    nhh = 'nhh'
    nhi = 'nhi'
    nhk = 'nhk'
    nhm = 'nhm'
    nhn = 'nhn'
    nho = 'nho'
    nhp = 'nhp'
    nhq = 'nhq'
    nhr = 'nhr'
    nht = 'nht'
    nhu = 'nhu'
    nhv = 'nhv'
    nhw = 'nhw'
    nhx = 'nhx'
    nhy = 'nhy'
    nhz = 'nhz'
    nia = 'nia'
    nib = 'nib'
    nid = 'nid'
    nie = 'nie'
    nif = 'nif'
    nig = 'nig'
    nih = 'nih'
    nii = 'nii'
    nij = 'nij'
    nik = 'nik'
    nil = 'nil'
    nim = 'nim'
    nin = 'nin'
    nio = 'nio'
    niq = 'niq'
    nir = 'nir'
    nis = 'nis'
    nit = 'nit'
    niu = 'niu'
    niv = 'niv'
    niw = 'niw'
    nix = 'nix'
    niy = 'niy'
    niz = 'niz'
    nja = 'nja'
    njb = 'njb'
    njd = 'njd'
    njh = 'njh'
    nji = 'nji'
    njj = 'njj'
    njl = 'njl'
    njm = 'njm'
    njn = 'njn'
    njo = 'njo'
    njr = 'njr'
    njs = 'njs'
    njt = 'njt'
    nju = 'nju'
    njx = 'njx'
    njy = 'njy'
    njz = 'njz'
    nka = 'nka'
    nkb = 'nkb'
    nkc = 'nkc'
    nkd = 'nkd'
    nke = 'nke'
    nkf = 'nkf'
    nkg = 'nkg'
    nkh = 'nkh'
    nki = 'nki'
    nkj = 'nkj'
    nkk = 'nkk'
    nkm = 'nkm'
    nkn = 'nkn'
    nko = 'nko'
    nkp = 'nkp'
    nkq = 'nkq'
    nkr = 'nkr'
    nks = 'nks'
    nkt = 'nkt'
    nku = 'nku'
    nkv = 'nkv'
    nkw = 'nkw'
    nkx = 'nkx'
    nkz = 'nkz'
    nla = 'nla'
    nlc = 'nlc'
    nld = 'nld'
    nle = 'nle'
    nlg = 'nlg'
    nli = 'nli'
    nlj = 'nlj'
    nlk = 'nlk'
    nll = 'nll'
    nlm = 'nlm'
    nlo = 'nlo'
    nlq = 'nlq'
    nlu = 'nlu'
    nlv = 'nlv'
    nlw = 'nlw'
    nlx = 'nlx'
    nly = 'nly'
    nlz = 'nlz'
    nma = 'nma'
    nmb = 'nmb'
    nmc = 'nmc'
    nmd = 'nmd'
    nme = 'nme'
    nmf = 'nmf'
    nmg = 'nmg'
    nmh = 'nmh'
    nmi = 'nmi'
    nmj = 'nmj'
    nmk = 'nmk'
    nml = 'nml'
    nmm = 'nmm'
    nmn = 'nmn'
    nmo = 'nmo'
    nmp = 'nmp'
    nmq = 'nmq'
    nmr = 'nmr'
    nms = 'nms'
    nmt = 'nmt'
    nmu = 'nmu'
    nmv = 'nmv'
    nmw = 'nmw'
    nmx = 'nmx'
    nmy = 'nmy'
    nmz = 'nmz'
    nna = 'nna'
    nnb = 'nnb'
    nnc = 'nnc'
    nnd = 'nnd'
    nne = 'nne'
    nnf = 'nnf'
    nng = 'nng'
    nnh = 'nnh'
    nni = 'nni'
    nnj = 'nnj'
    nnk = 'nnk'
    nnl = 'nnl'
    nnm = 'nnm'
    nnn = 'nnn'
    nno = 'nno'
    nnp = 'nnp'
    nnq = 'nnq'
    nnr = 'nnr'
    nnt = 'nnt'
    nnu = 'nnu'
    nnv = 'nnv'
    nnw = 'nnw'
    nny = 'nny'
    nnz = 'nnz'
    noa = 'noa'
    nob = 'nob'
    noc = 'noc'
    nod = 'nod'
    noe = 'noe'
    nof = 'nof'
    nog = 'nog'
    noh = 'noh'
    noi = 'noi'
    noj = 'noj'
    nok = 'nok'
    nol = 'nol'
    nom = 'nom'
    non = 'non'
    nop = 'nop'
    noq = 'noq'
    nor = 'nor'
    nos = 'nos'
    not_ = 'not'
    nou = 'nou'
    nov = 'nov'
    now = 'now'
    noy = 'noy'
    noz = 'noz'
    npa = 'npa'
    npb = 'npb'
    npg = 'npg'
    nph = 'nph'
    npi = 'npi'
    npl = 'npl'
    npn = 'npn'
    npo = 'npo'
    nps = 'nps'
    npu = 'npu'
    npx = 'npx'
    npy = 'npy'
    nqg = 'nqg'
    nqk = 'nqk'
    nql = 'nql'
    nqm = 'nqm'
    nqn = 'nqn'
    nqo = 'nqo'
    nqq = 'nqq'
    nqt = 'nqt'
    nqy = 'nqy'
    nra = 'nra'
    nrb = 'nrb'
    nrc = 'nrc'
    nre = 'nre'
    nrf = 'nrf'
    nrg = 'nrg'
    nri = 'nri'
    nrk = 'nrk'
    nrl = 'nrl'
    nrm = 'nrm'
    nrn = 'nrn'
    nrp = 'nrp'
    nrr = 'nrr'
    nrt = 'nrt'
    nru = 'nru'
    nrx = 'nrx'
    nrz = 'nrz'
    nsa = 'nsa'
    nsb = 'nsb'
    nsc = 'nsc'
    nsd = 'nsd'
    nse = 'nse'
    nsf = 'nsf'
    nsg = 'nsg'
    nsh = 'nsh'
    nsi = 'nsi'
    nsk = 'nsk'
    nsl = 'nsl'
    nsm = 'nsm'
    nsn = 'nsn'
    nso = 'nso'
    nsp = 'nsp'
    nsq = 'nsq'
    nsr = 'nsr'
    nss = 'nss'
    nst = 'nst'
    nsu = 'nsu'
    nsv = 'nsv'
    nsw = 'nsw'
    nsx = 'nsx'
    nsy = 'nsy'
    nsz = 'nsz'
    ntd = 'ntd'
    nte = 'nte'
    ntg = 'ntg'
    nti = 'nti'
    ntj = 'ntj'
    ntk = 'ntk'
    ntm = 'ntm'
    nto = 'nto'
    ntp = 'ntp'
    ntr = 'ntr'
    ntu = 'ntu'
    ntw = 'ntw'
    ntx = 'ntx'
    nty = 'nty'
    ntz = 'ntz'
    nua = 'nua'
    nuc = 'nuc'
    nud = 'nud'
    nue = 'nue'
    nuf = 'nuf'
    nug = 'nug'
    nuh = 'nuh'
    nui = 'nui'
    nuj = 'nuj'
    nuk = 'nuk'
    nul = 'nul'
    num = 'num'
    nun = 'nun'
    nuo = 'nuo'
    nup = 'nup'
    nuq = 'nuq'
    nur = 'nur'
    nus = 'nus'
    nut = 'nut'
    nuu = 'nuu'
    nuv = 'nuv'
    nuw = 'nuw'
    nux = 'nux'
    nuy = 'nuy'
    nuz = 'nuz'
    nvh = 'nvh'
    nvm = 'nvm'
    nvo = 'nvo'
    nwa = 'nwa'
    nwb = 'nwb'
    nwc = 'nwc'
    nwe = 'nwe'
    nwg = 'nwg'
    nwi = 'nwi'
    nwm = 'nwm'
    nwo = 'nwo'
    nwr = 'nwr'
    nww = 'nww'
    nwx = 'nwx'
    nwy = 'nwy'
    nxa = 'nxa'
    nxd = 'nxd'
    nxe = 'nxe'
    nxg = 'nxg'
    nxi = 'nxi'
    nxk = 'nxk'
    nxl = 'nxl'
    nxm = 'nxm'
    nxn = 'nxn'
    nxo = 'nxo'
    nxq = 'nxq'
    nxr = 'nxr'
    nxx = 'nxx'
    nya = 'nya'
    nyb = 'nyb'
    nyc = 'nyc'
    nyd = 'nyd'
    nye = 'nye'
    nyf = 'nyf'
    nyg = 'nyg'
    nyh = 'nyh'
    nyi = 'nyi'
    nyj = 'nyj'
    nyk = 'nyk'
    nyl = 'nyl'
    nym = 'nym'
    nyn = 'nyn'
    nyo = 'nyo'
    nyp = 'nyp'
    nyq = 'nyq'
    nyr = 'nyr'
    nys = 'nys'
    nyt = 'nyt'
    nyu = 'nyu'
    nyv = 'nyv'
    nyw = 'nyw'
    nyx = 'nyx'
    nyy = 'nyy'
    nza = 'nza'
    nzb = 'nzb'
    nzd = 'nzd'
    nzi = 'nzi'
    nzk = 'nzk'
    nzm = 'nzm'
    nzs = 'nzs'
    nzu = 'nzu'
    nzy = 'nzy'
    nzz = 'nzz'
    oaa = 'oaa'
    oac = 'oac'
    oar = 'oar'
    oav = 'oav'
    obi = 'obi'
    obk = 'obk'
    obl = 'obl'
    obm = 'obm'
    obo = 'obo'
    obr = 'obr'
    obt = 'obt'
    obu = 'obu'
    oca = 'oca'
    och = 'och'
    oci = 'oci'
    ocm = 'ocm'
    oco = 'oco'
    ocu = 'ocu'
    oda = 'oda'
    odk = 'odk'
    odt = 'odt'
    odu = 'odu'
    ofo = 'ofo'
    ofs = 'ofs'
    ofu = 'ofu'
    ogb = 'ogb'
    ogc = 'ogc'
    oge = 'oge'
    ogg = 'ogg'
    ogo = 'ogo'
    ogu = 'ogu'
    oht = 'oht'
    ohu = 'ohu'
    oia = 'oia'
    oie = 'oie'
    oin = 'oin'
    ojb = 'ojb'
    ojc = 'ojc'
    ojg = 'ojg'
    oji = 'oji'
    ojp = 'ojp'
    ojs = 'ojs'
    ojv = 'ojv'
    ojw = 'ojw'
    oka = 'oka'
    okb = 'okb'
    okc = 'okc'
    okd = 'okd'
    oke = 'oke'
    okg = 'okg'
    okh = 'okh'
    oki = 'oki'
    okj = 'okj'
    okk = 'okk'
    okl = 'okl'
    okm = 'okm'
    okn = 'okn'
    oko = 'oko'
    okr = 'okr'
    oks = 'oks'
    oku = 'oku'
    okv = 'okv'
    okx = 'okx'
    okz = 'okz'
    ola = 'ola'
    old = 'old'
    ole = 'ole'
    olk = 'olk'
    olm = 'olm'
    olo = 'olo'
    olr = 'olr'
    olt = 'olt'
    olu = 'olu'
    oma = 'oma'
    omb = 'omb'
    omc = 'omc'
    omg = 'omg'
    omi = 'omi'
    omk = 'omk'
    oml = 'oml'
    omn = 'omn'
    omo = 'omo'
    omp = 'omp'
    omr = 'omr'
    omt = 'omt'
    omu = 'omu'
    omw = 'omw'
    omx = 'omx'
    omy = 'omy'
    ona = 'ona'
    onb = 'onb'
    one = 'one'
    ong = 'ong'
    oni = 'oni'
    onj = 'onj'
    onk = 'onk'
    onn = 'onn'
    ono = 'ono'
    onp = 'onp'
    onr = 'onr'
    ons = 'ons'
    ont = 'ont'
    onu = 'onu'
    onw = 'onw'
    onx = 'onx'
    ood = 'ood'
    oog = 'oog'
    oon = 'oon'
    oor = 'oor'
    oos = 'oos'
    opa = 'opa'
    opk = 'opk'
    opm = 'opm'
    opo = 'opo'
    opt = 'opt'
    opy = 'opy'
    ora = 'ora'
    orc = 'orc'
    ore = 'ore'
    org = 'org'
    orh = 'orh'
    ori = 'ori'
    orm = 'orm'
    orn = 'orn'
    oro = 'oro'
    orr = 'orr'
    ors = 'ors'
    ort = 'ort'
    oru = 'oru'
    orv = 'orv'
    orw = 'orw'
    orx = 'orx'
    ory = 'ory'
    orz = 'orz'
    osa = 'osa'
    osc = 'osc'
    osi = 'osi'
    osn = 'osn'
    oso = 'oso'
    osp = 'osp'
    oss = 'oss'
    ost = 'ost'
    osu = 'osu'
    osx = 'osx'
    ota = 'ota'
    otb = 'otb'
    otd = 'otd'
    ote = 'ote'
    oti = 'oti'
    otk = 'otk'
    otl = 'otl'
    otm = 'otm'
    otn = 'otn'
    otq = 'otq'
    otr = 'otr'
    ots = 'ots'
    ott = 'ott'
    otu = 'otu'
    otw = 'otw'
    otx = 'otx'
    oty = 'oty'
    otz = 'otz'
    oua = 'oua'
    oub = 'oub'
    oue = 'oue'
    oui = 'oui'
    oum = 'oum'
    ovd = 'ovd'
    owi = 'owi'
    owl = 'owl'
    oyb = 'oyb'
    oyd = 'oyd'
    oym = 'oym'
    oyy = 'oyy'
    ozm = 'ozm'
    pab = 'pab'
    pac = 'pac'
    pad = 'pad'
    pae = 'pae'
    paf = 'paf'
    pag = 'pag'
    pah = 'pah'
    pai = 'pai'
    pak = 'pak'
    pal = 'pal'
    pam = 'pam'
    pan = 'pan'
    pao = 'pao'
    pap = 'pap'
    paq = 'paq'
    par = 'par'
    pas = 'pas'
    pau = 'pau'
    pav = 'pav'
    paw = 'paw'
    pax = 'pax'
    pay = 'pay'
    paz = 'paz'
    pbb = 'pbb'
    pbc = 'pbc'
    pbe = 'pbe'
    pbf = 'pbf'
    pbg = 'pbg'
    pbh = 'pbh'
    pbi = 'pbi'
    pbl = 'pbl'
    pbm = 'pbm'
    pbn = 'pbn'
    pbo = 'pbo'
    pbp = 'pbp'
    pbr = 'pbr'
    pbs = 'pbs'
    pbt = 'pbt'
    pbu = 'pbu'
    pbv = 'pbv'
    pby = 'pby'
    pca = 'pca'
    pcb = 'pcb'
    pcc = 'pcc'
    pcd = 'pcd'
    pce = 'pce'
    pcf = 'pcf'
    pcg = 'pcg'
    pch = 'pch'
    pci = 'pci'
    pcj = 'pcj'
    pck = 'pck'
    pcl = 'pcl'
    pcm = 'pcm'
    pcn = 'pcn'
    pcp = 'pcp'
    pcw = 'pcw'
    pda = 'pda'
    pdc = 'pdc'
    pdi = 'pdi'
    pdn = 'pdn'
    pdo = 'pdo'
    pdt = 'pdt'
    pdu = 'pdu'
    pea = 'pea'
    peb = 'peb'
    ped = 'ped'
    pee = 'pee'
    pef = 'pef'
    peg = 'peg'
    peh = 'peh'
    pei = 'pei'
    pej = 'pej'
    pek = 'pek'
    pel = 'pel'
    pem = 'pem'
    peo = 'peo'
    pep = 'pep'
    peq = 'peq'
    pes = 'pes'
    pev = 'pev'
    pex = 'pex'
    pey = 'pey'
    pez = 'pez'
    pfa = 'pfa'
    pfe = 'pfe'
    pfl = 'pfl'
    pga = 'pga'
    pgd = 'pgd'
    pgg = 'pgg'
    pgi = 'pgi'
    pgk = 'pgk'
    pgl = 'pgl'
    pgn = 'pgn'
    pgs = 'pgs'
    pgu = 'pgu'
    pgz = 'pgz'
    pha = 'pha'
    phd = 'phd'
    phg = 'phg'
    phh = 'phh'
    phj = 'phj'
    phk = 'phk'
    phl = 'phl'
    phm = 'phm'
    phn = 'phn'
    pho = 'pho'
    phq = 'phq'
    phr = 'phr'
    pht = 'pht'
    phu = 'phu'
    phv = 'phv'
    phw = 'phw'
    pia = 'pia'
    pib = 'pib'
    pic = 'pic'
    pid = 'pid'
    pie = 'pie'
    pif = 'pif'
    pig = 'pig'
    pih = 'pih'
    pij = 'pij'
    pil = 'pil'
    pim = 'pim'
    pin = 'pin'
    pio = 'pio'
    pip = 'pip'
    pir = 'pir'
    pis = 'pis'
    pit = 'pit'
    piu = 'piu'
    piv = 'piv'
    piw = 'piw'
    pix = 'pix'
    piy = 'piy'
    piz = 'piz'
    pjt = 'pjt'
    pka = 'pka'
    pkb = 'pkb'
    pkc = 'pkc'
    pkg = 'pkg'
    pkh = 'pkh'
    pkn = 'pkn'
    pko = 'pko'
    pkp = 'pkp'
    pkr = 'pkr'
    pks = 'pks'
    pkt = 'pkt'
    pku = 'pku'
    pla = 'pla'
    plb = 'plb'
    plc = 'plc'
    pld = 'pld'
    ple = 'ple'
    plg = 'plg'
    plh = 'plh'
    pli = 'pli'
    plj = 'plj'
    plk = 'plk'
    pll = 'pll'
    pln = 'pln'
    plo = 'plo'
    plq = 'plq'
    plr = 'plr'
    pls = 'pls'
    plt = 'plt'
    plu = 'plu'
    plv = 'plv'
    plw = 'plw'
    ply = 'ply'
    plz = 'plz'
    pma = 'pma'
    pmb = 'pmb'
    pmd = 'pmd'
    pme = 'pme'
    pmf = 'pmf'
    pmh = 'pmh'
    pmi = 'pmi'
    pmj = 'pmj'
    pmk = 'pmk'
    pml = 'pml'
    pmm = 'pmm'
    pmn = 'pmn'
    pmo = 'pmo'
    pmq = 'pmq'
    pmr = 'pmr'
    pms = 'pms'
    pmt = 'pmt'
    pmw = 'pmw'
    pmx = 'pmx'
    pmy = 'pmy'
    pmz = 'pmz'
    pna = 'pna'
    pnb = 'pnb'
    pnc = 'pnc'
    pnd = 'pnd'
    pne = 'pne'
    png = 'png'
    pnh = 'pnh'
    pni = 'pni'
    pnj = 'pnj'
    pnk = 'pnk'
    pnl = 'pnl'
    pnm = 'pnm'
    pnn = 'pnn'
    pno = 'pno'
    pnp = 'pnp'
    pnq = 'pnq'
    pnr = 'pnr'
    pns = 'pns'
    pnt = 'pnt'
    pnu = 'pnu'
    pnv = 'pnv'
    pnw = 'pnw'
    pnx = 'pnx'
    pny = 'pny'
    pnz = 'pnz'
    poc = 'poc'
    poe = 'poe'
    pof = 'pof'
    pog = 'pog'
    poh = 'poh'
    poi = 'poi'
    pok = 'pok'
    pol = 'pol'
    pom = 'pom'
    pon = 'pon'
    poo = 'poo'
    pop = 'pop'
    poq = 'poq'
    por = 'por'
    pos = 'pos'
    pot = 'pot'
    pov = 'pov'
    pow = 'pow'
    pox = 'pox'
    poy = 'poy'
    ppe = 'ppe'
    ppi = 'ppi'
    ppk = 'ppk'
    ppl = 'ppl'
    ppm = 'ppm'
    ppn = 'ppn'
    ppo = 'ppo'
    ppp = 'ppp'
    ppq = 'ppq'
    pps = 'pps'
    ppt = 'ppt'
    ppu = 'ppu'
    pqa = 'pqa'
    pqm = 'pqm'
    prc = 'prc'
    prd = 'prd'
    pre = 'pre'
    prf = 'prf'
    prg = 'prg'
    prh = 'prh'
    pri = 'pri'
    prk = 'prk'
    prl = 'prl'
    prm = 'prm'
    prn = 'prn'
    pro = 'pro'
    prp = 'prp'
    prq = 'prq'
    prr = 'prr'
    prs = 'prs'
    prt = 'prt'
    pru = 'pru'
    prw = 'prw'
    prx = 'prx'
    prz = 'prz'
    psa = 'psa'
    psc = 'psc'
    psd = 'psd'
    pse = 'pse'
    psg = 'psg'
    psh = 'psh'
    psi = 'psi'
    psl = 'psl'
    psm = 'psm'
    psn = 'psn'
    pso = 'pso'
    psp = 'psp'
    psq = 'psq'
    psr = 'psr'
    pss = 'pss'
    pst = 'pst'
    psu = 'psu'
    psw = 'psw'
    psy = 'psy'
    pta = 'pta'
    pth = 'pth'
    pti = 'pti'
    ptn = 'ptn'
    pto = 'pto'
    ptp = 'ptp'
    ptq = 'ptq'
    ptr = 'ptr'
    ptt = 'ptt'
    ptu = 'ptu'
    ptv = 'ptv'
    ptw = 'ptw'
    pty = 'pty'
    pua = 'pua'
    pub = 'pub'
    puc = 'puc'
    pud = 'pud'
    pue = 'pue'
    puf = 'puf'
    pug = 'pug'
    pui = 'pui'
    puj = 'puj'
    pum = 'pum'
    puo = 'puo'
    pup = 'pup'
    puq = 'puq'
    pur = 'pur'
    pus = 'pus'
    put = 'put'
    puu = 'puu'
    puw = 'puw'
    pux = 'pux'
    puy = 'puy'
    pwa = 'pwa'
    pwb = 'pwb'
    pwg = 'pwg'
    pwi = 'pwi'
    pwm = 'pwm'
    pwn = 'pwn'
    pwo = 'pwo'
    pwr = 'pwr'
    pww = 'pww'
    pxm = 'pxm'
    pye = 'pye'
    pym = 'pym'
    pyn = 'pyn'
    pys = 'pys'
    pyu = 'pyu'
    pyx = 'pyx'
    pyy = 'pyy'
    pzh = 'pzh'
    pzn = 'pzn'
    qua = 'qua'
    qub = 'qub'
    quc = 'quc'
    qud = 'qud'
    que = 'que'
    quf = 'quf'
    qug = 'qug'
    quh = 'quh'
    qui = 'qui'
    quk = 'quk'
    qul = 'qul'
    qum = 'qum'
    qun = 'qun'
    qup = 'qup'
    quq = 'quq'
    qur = 'qur'
    qus = 'qus'
    quv = 'quv'
    quw = 'quw'
    qux = 'qux'
    quy = 'quy'
    quz = 'quz'
    qva = 'qva'
    qvc = 'qvc'
    qve = 'qve'
    qvh = 'qvh'
    qvi = 'qvi'
    qvj = 'qvj'
    qvl = 'qvl'
    qvm = 'qvm'
    qvn = 'qvn'
    qvo = 'qvo'
    qvp = 'qvp'
    qvs = 'qvs'
    qvw = 'qvw'
    qvy = 'qvy'
    qvz = 'qvz'
    qwa = 'qwa'
    qwc = 'qwc'
    qwh = 'qwh'
    qwm = 'qwm'
    qws = 'qws'
    qwt = 'qwt'
    qxa = 'qxa'
    qxc = 'qxc'
    qxh = 'qxh'
    qxl = 'qxl'
    qxn = 'qxn'
    qxo = 'qxo'
    qxp = 'qxp'
    qxq = 'qxq'
    qxr = 'qxr'
    qxs = 'qxs'
    qxt = 'qxt'
    qxu = 'qxu'
    qxw = 'qxw'
    qya = 'qya'
    qyp = 'qyp'
    raa = 'raa'
    rab = 'rab'
    rac = 'rac'
    rad = 'rad'
    raf = 'raf'
    rag = 'rag'
    rah = 'rah'
    rai = 'rai'
    raj = 'raj'
    rak = 'rak'
    ral = 'ral'
    ram = 'ram'
    ran = 'ran'
    rao = 'rao'
    rap = 'rap'
    raq = 'raq'
    rar = 'rar'
    ras = 'ras'
    rat = 'rat'
    rau = 'rau'
    rav = 'rav'
    raw = 'raw'
    rax = 'rax'
    ray = 'ray'
    raz = 'raz'
    rbb = 'rbb'
    rbk = 'rbk'
    rbl = 'rbl'
    rbp = 'rbp'
    rcf = 'rcf'
    rdb = 'rdb'
    rea = 'rea'
    reb = 'reb'
    ree = 'ree'
    reg = 'reg'
    rei = 'rei'
    rej = 'rej'
    rel = 'rel'
    rem = 'rem'
    ren = 'ren'
    rer = 'rer'
    res = 'res'
    ret = 'ret'
    rey = 'rey'
    rga = 'rga'
    rge = 'rge'
    rgk = 'rgk'
    rgn = 'rgn'
    rgr = 'rgr'
    rgs = 'rgs'
    rgu = 'rgu'
    rhg = 'rhg'
    rhp = 'rhp'
    ria = 'ria'
    rib = 'rib'
    rif = 'rif'
    ril = 'ril'
    rim = 'rim'
    rin = 'rin'
    rir = 'rir'
    rit = 'rit'
    riu = 'riu'
    rjg = 'rjg'
    rji = 'rji'
    rjs = 'rjs'
    rka = 'rka'
    rkb = 'rkb'
    rkh = 'rkh'
    rki = 'rki'
    rkm = 'rkm'
    rkt = 'rkt'
    rkw = 'rkw'
    rma = 'rma'
    rmb = 'rmb'
    rmc = 'rmc'
    rmd = 'rmd'
    rme = 'rme'
    rmf = 'rmf'
    rmg = 'rmg'
    rmh = 'rmh'
    rmi = 'rmi'
    rmk = 'rmk'
    rml = 'rml'
    rmm = 'rmm'
    rmn = 'rmn'
    rmo = 'rmo'
    rmp = 'rmp'
    rmq = 'rmq'
    rms = 'rms'
    rmt = 'rmt'
    rmu = 'rmu'
    rmv = 'rmv'
    rmw = 'rmw'
    rmx = 'rmx'
    rmy = 'rmy'
    rmz = 'rmz'
    rnb = 'rnb'
    rnd = 'rnd'
    rng = 'rng'
    rnl = 'rnl'
    rnn = 'rnn'
    rnp = 'rnp'
    rnr = 'rnr'
    rnw = 'rnw'
    rob = 'rob'
    roc = 'roc'
    rod = 'rod'
    roe = 'roe'
    rof = 'rof'
    rog = 'rog'
    roh = 'roh'
    rol = 'rol'
    rom = 'rom'
    ron = 'ron'
    roo = 'roo'
    rop = 'rop'
    ror = 'ror'
    rou = 'rou'
    row = 'row'
    rpn = 'rpn'
    rpt = 'rpt'
    rri = 'rri'
    rro = 'rro'
    rrt = 'rrt'
    rsb = 'rsb'
    rsk = 'rsk'
    rsl = 'rsl'
    rsm = 'rsm'
    rsn = 'rsn'
    rtc = 'rtc'
    rth = 'rth'
    rtm = 'rtm'
    rts = 'rts'
    rtw = 'rtw'
    rub = 'rub'
    ruc = 'ruc'
    rue = 'rue'
    ruf = 'ruf'
    rug = 'rug'
    ruh = 'ruh'
    rui = 'rui'
    ruk = 'ruk'
    run = 'run'
    ruo = 'ruo'
    rup = 'rup'
    ruq = 'ruq'
    rus = 'rus'
    rut = 'rut'
    ruu = 'ruu'
    ruy = 'ruy'
    ruz = 'ruz'
    rwa = 'rwa'
    rwk = 'rwk'
    rwl = 'rwl'
    rwm = 'rwm'
    rwo = 'rwo'
    rwr = 'rwr'
    rxd = 'rxd'
    rxw = 'rxw'
    ryn = 'ryn'
    rys = 'rys'
    ryu = 'ryu'
    rzh = 'rzh'
    saa = 'saa'
    sab = 'sab'
    sac = 'sac'
    sad = 'sad'
    sae = 'sae'
    saf = 'saf'
    sag = 'sag'
    sah = 'sah'
    saj = 'saj'
    sak = 'sak'
    sam = 'sam'
    san = 'san'
    sao = 'sao'
    saq = 'saq'
    sar = 'sar'
    sas = 'sas'
    sat = 'sat'
    sau = 'sau'
    sav = 'sav'
    saw = 'saw'
    sax = 'sax'
    say = 'say'
    saz = 'saz'
    sba = 'sba'
    sbb = 'sbb'
    sbc = 'sbc'
    sbd = 'sbd'
    sbe = 'sbe'
    sbf = 'sbf'
    sbg = 'sbg'
    sbh = 'sbh'
    sbi = 'sbi'
    sbj = 'sbj'
    sbk = 'sbk'
    sbl = 'sbl'
    sbm = 'sbm'
    sbn = 'sbn'
    sbo = 'sbo'
    sbp = 'sbp'
    sbq = 'sbq'
    sbr = 'sbr'
    sbs = 'sbs'
    sbt = 'sbt'
    sbu = 'sbu'
    sbv = 'sbv'
    sbw = 'sbw'
    sbx = 'sbx'
    sby = 'sby'
    sbz = 'sbz'
    scb = 'scb'
    sce = 'sce'
    scf = 'scf'
    scg = 'scg'
    sch = 'sch'
    sci = 'sci'
    sck = 'sck'
    scl = 'scl'
    scn = 'scn'
    sco = 'sco'
    scp = 'scp'
    scq = 'scq'
    scs = 'scs'
    sct = 'sct'
    scu = 'scu'
    scv = 'scv'
    scw = 'scw'
    scx = 'scx'
    sda = 'sda'
    sdb = 'sdb'
    sdc = 'sdc'
    sde = 'sde'
    sdf = 'sdf'
    sdg = 'sdg'
    sdh = 'sdh'
    sdj = 'sdj'
    sdk = 'sdk'
    sdl = 'sdl'
    sdn = 'sdn'
    sdo = 'sdo'
    sdp = 'sdp'
    sdq = 'sdq'
    sdr = 'sdr'
    sds = 'sds'
    sdt = 'sdt'
    sdu = 'sdu'
    sdx = 'sdx'
    sdz = 'sdz'
    sea = 'sea'
    seb = 'seb'
    sec = 'sec'
    sed = 'sed'
    see = 'see'
    sef = 'sef'
    seg = 'seg'
    seh = 'seh'
    sei = 'sei'
    sej = 'sej'
    sek = 'sek'
    sel = 'sel'
    sen = 'sen'
    seo = 'seo'
    sep = 'sep'
    seq = 'seq'
    ser = 'ser'
    ses = 'ses'
    set = 'set'
    seu = 'seu'
    sev = 'sev'
    sew = 'sew'
    sey = 'sey'
    sez = 'sez'
    sfb = 'sfb'
    sfe = 'sfe'
    sfm = 'sfm'
    sfs = 'sfs'
    sfw = 'sfw'
    sga = 'sga'
    sgb = 'sgb'
    sgc = 'sgc'
    sgd = 'sgd'
    sge = 'sge'
    sgg = 'sgg'
    sgh = 'sgh'
    sgi = 'sgi'
    sgj = 'sgj'
    sgk = 'sgk'
    sgm = 'sgm'
    sgp = 'sgp'
    sgr = 'sgr'
    sgs = 'sgs'
    sgt = 'sgt'
    sgu = 'sgu'
    sgw = 'sgw'
    sgx = 'sgx'
    sgy = 'sgy'
    sgz = 'sgz'
    sha = 'sha'
    shb = 'shb'
    shc = 'shc'
    shd = 'shd'
    she = 'she'
    shg = 'shg'
    shh = 'shh'
    shi = 'shi'
    shj = 'shj'
    shk = 'shk'
    shl = 'shl'
    shm = 'shm'
    shn = 'shn'
    sho = 'sho'
    shp = 'shp'
    shq = 'shq'
    shr = 'shr'
    shs = 'shs'
    sht = 'sht'
    shu = 'shu'
    shv = 'shv'
    shw = 'shw'
    shx = 'shx'
    shy = 'shy'
    shz = 'shz'
    sia = 'sia'
    sib = 'sib'
    sid = 'sid'
    sie = 'sie'
    sif = 'sif'
    sig = 'sig'
    sih = 'sih'
    sii = 'sii'
    sij = 'sij'
    sik = 'sik'
    sil = 'sil'
    sim = 'sim'
    sin = 'sin'
    sip = 'sip'
    siq = 'siq'
    sir = 'sir'
    sis = 'sis'
    siu = 'siu'
    siv = 'siv'
    siw = 'siw'
    six = 'six'
    siy = 'siy'
    siz = 'siz'
    sja = 'sja'
    sjb = 'sjb'
    sjd = 'sjd'
    sje = 'sje'
    sjg = 'sjg'
    sjk = 'sjk'
    sjl = 'sjl'
    sjm = 'sjm'
    sjn = 'sjn'
    sjo = 'sjo'
    sjp = 'sjp'
    sjr = 'sjr'
    sjs = 'sjs'
    sjt = 'sjt'
    sju = 'sju'
    sjw = 'sjw'
    ska = 'ska'
    skb = 'skb'
    skc = 'skc'
    skd = 'skd'
    ske = 'ske'
    skf = 'skf'
    skg = 'skg'
    skh = 'skh'
    ski = 'ski'
    skj = 'skj'
    skm = 'skm'
    skn = 'skn'
    sko = 'sko'
    skp = 'skp'
    skq = 'skq'
    skr = 'skr'
    sks = 'sks'
    skt = 'skt'
    sku = 'sku'
    skv = 'skv'
    skw = 'skw'
    skx = 'skx'
    sky = 'sky'
    skz = 'skz'
    slc = 'slc'
    sld = 'sld'
    sle = 'sle'
    slf = 'slf'
    slg = 'slg'
    slh = 'slh'
    sli = 'sli'
    slj = 'slj'
    slk = 'slk'
    sll = 'sll'
    slm = 'slm'
    sln = 'sln'
    slp = 'slp'
    slq = 'slq'
    slr = 'slr'
    sls = 'sls'
    slt = 'slt'
    slu = 'slu'
    slv = 'slv'
    slw = 'slw'
    slx = 'slx'
    sly = 'sly'
    slz = 'slz'
    sma = 'sma'
    smb = 'smb'
    smc = 'smc'
    sme = 'sme'
    smf = 'smf'
    smg = 'smg'
    smh = 'smh'
    smj = 'smj'
    smk = 'smk'
    sml = 'sml'
    smm = 'smm'
    smn = 'smn'
    smo = 'smo'
    smp = 'smp'
    smq = 'smq'
    smr = 'smr'
    sms = 'sms'
    smt = 'smt'
    smu = 'smu'
    smv = 'smv'
    smw = 'smw'
    smx = 'smx'
    smy = 'smy'
    smz = 'smz'
    sna = 'sna'
    snc = 'snc'
    snd = 'snd'
    sne = 'sne'
    snf = 'snf'
    sng = 'sng'
    sni = 'sni'
    snj = 'snj'
    snk = 'snk'
    snl = 'snl'
    snm = 'snm'
    snn = 'snn'
    sno = 'sno'
    snp = 'snp'
    snq = 'snq'
    snr = 'snr'
    sns = 'sns'
    snu = 'snu'
    snv = 'snv'
    snw = 'snw'
    snx = 'snx'
    sny = 'sny'
    snz = 'snz'
    soa = 'soa'
    sob = 'sob'
    soc = 'soc'
    sod = 'sod'
    soe = 'soe'
    sog = 'sog'
    soh = 'soh'
    soi = 'soi'
    soj = 'soj'
    sok = 'sok'
    sol = 'sol'
    som = 'som'
    soo = 'soo'
    sop = 'sop'
    soq = 'soq'
    sor = 'sor'
    sos = 'sos'
    sot = 'sot'
    sou = 'sou'
    sov = 'sov'
    sow = 'sow'
    sox = 'sox'
    soy = 'soy'
    soz = 'soz'
    spa = 'spa'
    spb = 'spb'
    spc = 'spc'
    spd = 'spd'
    spe = 'spe'
    spg = 'spg'
    spi = 'spi'
    spk = 'spk'
    spl = 'spl'
    spm = 'spm'
    spn = 'spn'
    spo = 'spo'
    spp = 'spp'
    spq = 'spq'
    spr = 'spr'
    sps = 'sps'
    spt = 'spt'
    spu = 'spu'
    spv = 'spv'
    spx = 'spx'
    spy = 'spy'
    sqa = 'sqa'
    sqh = 'sqh'
    sqi = 'sqi'
    sqk = 'sqk'
    sqm = 'sqm'
    sqn = 'sqn'
    sqo = 'sqo'
    sqq = 'sqq'
    sqr = 'sqr'
    sqs = 'sqs'
    sqt = 'sqt'
    squ = 'squ'
    sqx = 'sqx'
    sra = 'sra'
    srb = 'srb'
    src = 'src'
    srd = 'srd'
    sre = 'sre'
    srf = 'srf'
    srg = 'srg'
    srh = 'srh'
    sri = 'sri'
    srk = 'srk'
    srl = 'srl'
    srm = 'srm'
    srn = 'srn'
    sro = 'sro'
    srp = 'srp'
    srq = 'srq'
    srr = 'srr'
    srs = 'srs'
    srt = 'srt'
    sru = 'sru'
    srv = 'srv'
    srw = 'srw'
    srx = 'srx'
    sry = 'sry'
    srz = 'srz'
    ssb = 'ssb'
    ssc = 'ssc'
    ssd = 'ssd'
    sse = 'sse'
    ssf = 'ssf'
    ssg = 'ssg'
    ssh = 'ssh'
    ssi = 'ssi'
    ssj = 'ssj'
    ssk = 'ssk'
    ssl = 'ssl'
    ssm = 'ssm'
    ssn = 'ssn'
    sso = 'sso'
    ssp = 'ssp'
    ssq = 'ssq'
    ssr = 'ssr'
    sss = 'sss'
    sst = 'sst'
    ssu = 'ssu'
    ssv = 'ssv'
    ssw = 'ssw'
    ssx = 'ssx'
    ssy = 'ssy'
    ssz = 'ssz'
    sta = 'sta'
    stb = 'stb'
    std = 'std'
    ste = 'ste'
    stf = 'stf'
    stg = 'stg'
    sth = 'sth'
    sti = 'sti'
    stj = 'stj'
    stk = 'stk'
    stl = 'stl'
    stm = 'stm'
    stn = 'stn'
    sto = 'sto'
    stp = 'stp'
    stq = 'stq'
    str = 'str'
    sts = 'sts'
    stt = 'stt'
    stu = 'stu'
    stv = 'stv'
    stw = 'stw'
    sty = 'sty'
    sua = 'sua'
    sub = 'sub'
    suc = 'suc'
    sue = 'sue'
    sug = 'sug'
    sui = 'sui'
    suj = 'suj'
    suk = 'suk'
    sun = 'sun'
    suo = 'suo'
    suq = 'suq'
    sur = 'sur'
    sus = 'sus'
    sut = 'sut'
    suv = 'suv'
    suw = 'suw'
    sux = 'sux'
    suy = 'suy'
    suz = 'suz'
    sva = 'sva'
    svb = 'svb'
    svc = 'svc'
    sve = 'sve'
    svk = 'svk'
    svm = 'svm'
    svs = 'svs'
    svx = 'svx'
    swa = 'swa'
    swb = 'swb'
    swc = 'swc'
    swe = 'swe'
    swf = 'swf'
    swg = 'swg'
    swh = 'swh'
    swi = 'swi'
    swj = 'swj'
    swk = 'swk'
    swl = 'swl'
    swm = 'swm'
    swn = 'swn'
    swo = 'swo'
    swp = 'swp'
    swq = 'swq'
    swr = 'swr'
    sws = 'sws'
    swt = 'swt'
    swu = 'swu'
    swv = 'swv'
    sww = 'sww'
    swx = 'swx'
    swy = 'swy'
    sxb = 'sxb'
    sxc = 'sxc'
    sxe = 'sxe'
    sxg = 'sxg'
    sxk = 'sxk'
    sxl = 'sxl'
    sxm = 'sxm'
    sxn = 'sxn'
    sxo = 'sxo'
    sxr = 'sxr'
    sxs = 'sxs'
    sxu = 'sxu'
    sxw = 'sxw'
    sya = 'sya'
    syb = 'syb'
    syc = 'syc'
    syi = 'syi'
    syk = 'syk'
    syl = 'syl'
    sym = 'sym'
    syn = 'syn'
    syo = 'syo'
    syr = 'syr'
    sys = 'sys'
    syw = 'syw'
    syx = 'syx'
    syy = 'syy'
    sza = 'sza'
    szb = 'szb'
    szc = 'szc'
    szd = 'szd'
    sze = 'sze'
    szg = 'szg'
    szl = 'szl'
    szn = 'szn'
    szp = 'szp'
    szs = 'szs'
    szv = 'szv'
    szw = 'szw'
    szy = 'szy'
    taa = 'taa'
    tab = 'tab'
    tac = 'tac'
    tad = 'tad'
    tae = 'tae'
    taf = 'taf'
    tag = 'tag'
    tah = 'tah'
    taj = 'taj'
    tak = 'tak'
    tal = 'tal'
    tam = 'tam'
    tan = 'tan'
    tao = 'tao'
    tap = 'tap'
    taq = 'taq'
    tar = 'tar'
    tas = 'tas'
    tat = 'tat'
    tau = 'tau'
    tav = 'tav'
    taw = 'taw'
    tax = 'tax'
    tay = 'tay'
    taz = 'taz'
    tba = 'tba'
    tbc = 'tbc'
    tbd = 'tbd'
    tbe = 'tbe'
    tbf = 'tbf'
    tbg = 'tbg'
    tbh = 'tbh'
    tbi = 'tbi'
    tbj = 'tbj'
    tbk = 'tbk'
    tbl = 'tbl'
    tbm = 'tbm'
    tbn = 'tbn'
    tbo = 'tbo'
    tbp = 'tbp'
    tbr = 'tbr'
    tbs = 'tbs'
    tbt = 'tbt'
    tbu = 'tbu'
    tbv = 'tbv'
    tbw = 'tbw'
    tbx = 'tbx'
    tby = 'tby'
    tbz = 'tbz'
    tca = 'tca'
    tcb = 'tcb'
    tcc = 'tcc'
    tcd = 'tcd'
    tce = 'tce'
    tcf = 'tcf'
    tcg = 'tcg'
    tch = 'tch'
    tci = 'tci'
    tck = 'tck'
    tcl = 'tcl'
    tcm = 'tcm'
    tcn = 'tcn'
    tco = 'tco'
    tcp = 'tcp'
    tcq = 'tcq'
    tcs = 'tcs'
    tct = 'tct'
    tcu = 'tcu'
    tcw = 'tcw'
    tcx = 'tcx'
    tcy = 'tcy'
    tcz = 'tcz'
    tda = 'tda'
    tdb = 'tdb'
    tdc = 'tdc'
    tdd = 'tdd'
    tde = 'tde'
    tdf = 'tdf'
    tdg = 'tdg'
    tdh = 'tdh'
    tdi = 'tdi'
    tdj = 'tdj'
    tdk = 'tdk'
    tdl = 'tdl'
    tdm = 'tdm'
    tdn = 'tdn'
    tdo = 'tdo'
    tdq = 'tdq'
    tdr = 'tdr'
    tds = 'tds'
    tdt = 'tdt'
    tdv = 'tdv'
    tdx = 'tdx'
    tdy = 'tdy'
    tea = 'tea'
    teb = 'teb'
    tec = 'tec'
    ted = 'ted'
    tee = 'tee'
    tef = 'tef'
    teg = 'teg'
    teh = 'teh'
    tei = 'tei'
    tek = 'tek'
    tel = 'tel'
    tem = 'tem'
    ten = 'ten'
    teo = 'teo'
    tep = 'tep'
    teq = 'teq'
    ter = 'ter'
    tes = 'tes'
    tet = 'tet'
    teu = 'teu'
    tev = 'tev'
    tew = 'tew'
    tex = 'tex'
    tey = 'tey'
    tez = 'tez'
    tfi = 'tfi'
    tfn = 'tfn'
    tfo = 'tfo'
    tfr = 'tfr'
    tft = 'tft'
    tga = 'tga'
    tgb = 'tgb'
    tgc = 'tgc'
    tgd = 'tgd'
    tge = 'tge'
    tgf = 'tgf'
    tgh = 'tgh'
    tgi = 'tgi'
    tgj = 'tgj'
    tgk = 'tgk'
    tgl = 'tgl'
    tgn = 'tgn'
    tgo = 'tgo'
    tgp = 'tgp'
    tgq = 'tgq'
    tgr = 'tgr'
    tgs = 'tgs'
    tgt = 'tgt'
    tgu = 'tgu'
    tgv = 'tgv'
    tgw = 'tgw'
    tgx = 'tgx'
    tgy = 'tgy'
    tgz = 'tgz'
    tha = 'tha'
    thd = 'thd'
    the = 'the'
    thf = 'thf'
    thh = 'thh'
    thi = 'thi'
    thk = 'thk'
    thl = 'thl'
    thm = 'thm'
    thn = 'thn'
    thp = 'thp'
    thq = 'thq'
    thr = 'thr'
    ths = 'ths'
    tht = 'tht'
    thu = 'thu'
    thv = 'thv'
    thy = 'thy'
    thz = 'thz'
    tia = 'tia'
    tic = 'tic'
    tif = 'tif'
    tig = 'tig'
    tih = 'tih'
    tii = 'tii'
    tij = 'tij'
    tik = 'tik'
    til = 'til'
    tim = 'tim'
    tin = 'tin'
    tio = 'tio'
    tip = 'tip'
    tiq = 'tiq'
    tir = 'tir'
    tis = 'tis'
    tit = 'tit'
    tiu = 'tiu'
    tiv = 'tiv'
    tiw = 'tiw'
    tix = 'tix'
    tiy = 'tiy'
    tiz = 'tiz'
    tja = 'tja'
    tjg = 'tjg'
    tji = 'tji'
    tjj = 'tjj'
    tjl = 'tjl'
    tjm = 'tjm'
    tjn = 'tjn'
    tjo = 'tjo'
    tjp = 'tjp'
    tjs = 'tjs'
    tju = 'tju'
    tjw = 'tjw'
    tka = 'tka'
    tkb = 'tkb'
    tkd = 'tkd'
    tke = 'tke'
    tkf = 'tkf'
    tkg = 'tkg'
    tkl = 'tkl'
    tkm = 'tkm'
    tkn = 'tkn'
    tkp = 'tkp'
    tkq = 'tkq'
    tkr = 'tkr'
    tks = 'tks'
    tkt = 'tkt'
    tku = 'tku'
    tkv = 'tkv'
    tkw = 'tkw'
    tkx = 'tkx'
    tkz = 'tkz'
    tla = 'tla'
    tlb = 'tlb'
    tlc = 'tlc'
    tld = 'tld'
    tlf = 'tlf'
    tlg = 'tlg'
    tlh = 'tlh'
    tli = 'tli'
    tlj = 'tlj'
    tlk = 'tlk'
    tll = 'tll'
    tlm = 'tlm'
    tln = 'tln'
    tlo = 'tlo'
    tlp = 'tlp'
    tlq = 'tlq'
    tlr = 'tlr'
    tls = 'tls'
    tlt = 'tlt'
    tlu = 'tlu'
    tlv = 'tlv'
    tlx = 'tlx'
    tly = 'tly'
    tma = 'tma'
    tmb = 'tmb'
    tmc = 'tmc'
    tmd = 'tmd'
    tme = 'tme'
    tmf = 'tmf'
    tmg = 'tmg'
    tmh = 'tmh'
    tmi = 'tmi'
    tmj = 'tmj'
    tmk = 'tmk'
    tml = 'tml'
    tmm = 'tmm'
    tmn = 'tmn'
    tmo = 'tmo'
    tmq = 'tmq'
    tmr = 'tmr'
    tms = 'tms'
    tmt = 'tmt'
    tmu = 'tmu'
    tmv = 'tmv'
    tmw = 'tmw'
    tmy = 'tmy'
    tmz = 'tmz'
    tna = 'tna'
    tnb = 'tnb'
    tnc = 'tnc'
    tnd = 'tnd'
    tng = 'tng'
    tnh = 'tnh'
    tni = 'tni'
    tnk = 'tnk'
    tnl = 'tnl'
    tnm = 'tnm'
    tnn = 'tnn'
    tno = 'tno'
    tnp = 'tnp'
    tnq = 'tnq'
    tnr = 'tnr'
    tns = 'tns'
    tnt = 'tnt'
    tnu = 'tnu'
    tnv = 'tnv'
    tnw = 'tnw'
    tnx = 'tnx'
    tny = 'tny'
    tnz = 'tnz'
    tob = 'tob'
    toc = 'toc'
    tod = 'tod'
    tof = 'tof'
    tog = 'tog'
    toh = 'toh'
    toi = 'toi'
    toj = 'toj'
    tok = 'tok'
    tol = 'tol'
    tom = 'tom'
    ton = 'ton'
    too = 'too'
    top = 'top'
    toq = 'toq'
    tor = 'tor'
    tos = 'tos'
    tou = 'tou'
    tov = 'tov'
    tow = 'tow'
    tox = 'tox'
    toy = 'toy'
    toz = 'toz'
    tpa = 'tpa'
    tpc = 'tpc'
    tpe = 'tpe'
    tpf = 'tpf'
    tpg = 'tpg'
    tpi = 'tpi'
    tpj = 'tpj'
    tpk = 'tpk'
    tpl = 'tpl'
    tpm = 'tpm'
    tpn = 'tpn'
    tpo = 'tpo'
    tpp = 'tpp'
    tpq = 'tpq'
    tpr = 'tpr'
    tpt = 'tpt'
    tpu = 'tpu'
    tpv = 'tpv'
    tpw = 'tpw'
    tpx = 'tpx'
    tpy = 'tpy'
    tpz = 'tpz'
    tqb = 'tqb'
    tql = 'tql'
    tqm = 'tqm'
    tqn = 'tqn'
    tqo = 'tqo'
    tqp = 'tqp'
    tqq = 'tqq'
    tqr = 'tqr'
    tqt = 'tqt'
    tqu = 'tqu'
    tqw = 'tqw'
    tra = 'tra'
    trb = 'trb'
    trc = 'trc'
    trd = 'trd'
    tre = 'tre'
    trf = 'trf'
    trg = 'trg'
    trh = 'trh'
    tri = 'tri'
    trj = 'trj'
    trl = 'trl'
    trm = 'trm'
    trn = 'trn'
    tro = 'tro'
    trp = 'trp'
    trq = 'trq'
    trr = 'trr'
    trs = 'trs'
    trt = 'trt'
    tru = 'tru'
    trv = 'trv'
    trw = 'trw'
    trx = 'trx'
    try_ = 'try'
    trz = 'trz'
    tsa = 'tsa'
    tsb = 'tsb'
    tsc = 'tsc'
    tsd = 'tsd'
    tse = 'tse'
    tsg = 'tsg'
    tsh = 'tsh'
    tsi = 'tsi'
    tsj = 'tsj'
    tsk = 'tsk'
    tsl = 'tsl'
    tsm = 'tsm'
    tsn = 'tsn'
    tso = 'tso'
    tsp = 'tsp'
    tsq = 'tsq'
    tsr = 'tsr'
    tss = 'tss'
    tst = 'tst'
    tsu = 'tsu'
    tsv = 'tsv'
    tsw = 'tsw'
    tsx = 'tsx'
    tsy = 'tsy'
    tsz = 'tsz'
    tta = 'tta'
    ttb = 'ttb'
    ttc = 'ttc'
    ttd = 'ttd'
    tte = 'tte'
    ttf = 'ttf'
    ttg = 'ttg'
    tth = 'tth'
    tti = 'tti'
    ttj = 'ttj'
    ttk = 'ttk'
    ttl = 'ttl'
    ttm = 'ttm'
    ttn = 'ttn'
    tto = 'tto'
    ttp = 'ttp'
    ttq = 'ttq'
    ttr = 'ttr'
    tts = 'tts'
    ttt = 'ttt'
    ttu = 'ttu'
    ttv = 'ttv'
    ttw = 'ttw'
    tty = 'tty'
    ttz = 'ttz'
    tua = 'tua'
    tub = 'tub'
    tuc = 'tuc'
    tud = 'tud'
    tue = 'tue'
    tuf = 'tuf'
    tug = 'tug'
    tuh = 'tuh'
    tui = 'tui'
    tuj = 'tuj'
    tuk = 'tuk'
    tul = 'tul'
    tum = 'tum'
    tun = 'tun'
    tuo = 'tuo'
    tuq = 'tuq'
    tur = 'tur'
    tus = 'tus'
    tuu = 'tuu'
    tuv = 'tuv'
    tux = 'tux'
    tuy = 'tuy'
    tuz = 'tuz'
    tva = 'tva'
    tvd = 'tvd'
    tve = 'tve'
    tvk = 'tvk'
    tvl = 'tvl'
    tvm = 'tvm'
    tvn = 'tvn'
    tvo = 'tvo'
    tvs = 'tvs'
    tvt = 'tvt'
    tvu = 'tvu'
    tvw = 'tvw'
    tvx = 'tvx'
    tvy = 'tvy'
    twa = 'twa'
    twb = 'twb'
    twc = 'twc'
    twd = 'twd'
    twe = 'twe'
    twf = 'twf'
    twg = 'twg'
    twh = 'twh'
    twi = 'twi'
    twl = 'twl'
    twm = 'twm'
    twn = 'twn'
    two = 'two'
    twp = 'twp'
    twq = 'twq'
    twr = 'twr'
    twt = 'twt'
    twu = 'twu'
    tww = 'tww'
    twx = 'twx'
    twy = 'twy'
    txa = 'txa'
    txb = 'txb'
    txc = 'txc'
    txe = 'txe'
    txg = 'txg'
    txh = 'txh'
    txi = 'txi'
    txj = 'txj'
    txm = 'txm'
    txn = 'txn'
    txo = 'txo'
    txq = 'txq'
    txr = 'txr'
    txs = 'txs'
    txt = 'txt'
    txu = 'txu'
    txx = 'txx'
    txy = 'txy'
    tya = 'tya'
    tye = 'tye'
    tyh = 'tyh'
    tyi = 'tyi'
    tyj = 'tyj'
    tyl = 'tyl'
    tyn = 'tyn'
    typ = 'typ'
    tyr = 'tyr'
    tys = 'tys'
    tyt = 'tyt'
    tyu = 'tyu'
    tyv = 'tyv'
    tyx = 'tyx'
    tyy = 'tyy'
    tyz = 'tyz'
    tza = 'tza'
    tzh = 'tzh'
    tzj = 'tzj'
    tzl = 'tzl'
    tzm = 'tzm'
    tzn = 'tzn'
    tzo = 'tzo'
    tzx = 'tzx'
    uam = 'uam'
    uan = 'uan'
    uar = 'uar'
    uba = 'uba'
    ubi = 'ubi'
    ubl = 'ubl'
    ubr = 'ubr'
    ubu = 'ubu'
    uby = 'uby'
    uda = 'uda'
    ude = 'ude'
    udg = 'udg'
    udi = 'udi'
    udj = 'udj'
    udl = 'udl'
    udm = 'udm'
    udu = 'udu'
    ues = 'ues'
    ufi = 'ufi'
    uga = 'uga'
    ugb = 'ugb'
    uge = 'uge'
    ugh = 'ugh'
    ugn = 'ugn'
    ugo = 'ugo'
    ugy = 'ugy'
    uha = 'uha'
    uhn = 'uhn'
    uig = 'uig'
    uis = 'uis'
    uiv = 'uiv'
    uji = 'uji'
    uka = 'uka'
    ukg = 'ukg'
    ukh = 'ukh'
    uki = 'uki'
    ukk = 'ukk'
    ukl = 'ukl'
    ukp = 'ukp'
    ukq = 'ukq'
    ukr = 'ukr'
    uks = 'uks'
    uku = 'uku'
    ukv = 'ukv'
    ukw = 'ukw'
    uky = 'uky'
    ula = 'ula'
    ulb = 'ulb'
    ulc = 'ulc'
    ule = 'ule'
    ulf = 'ulf'
    uli = 'uli'
    ulk = 'ulk'
    ull = 'ull'
    ulm = 'ulm'
    uln = 'uln'
    ulu = 'ulu'
    ulw = 'ulw'
    uma = 'uma'
    umb = 'umb'
    umc = 'umc'
    umd = 'umd'
    umg = 'umg'
    umi = 'umi'
    umm = 'umm'
    umn = 'umn'
    umo = 'umo'
    ump = 'ump'
    umr = 'umr'
    ums = 'ums'
    umu = 'umu'
    una = 'una'
    und = 'und'
    une = 'une'
    ung = 'ung'
    uni = 'uni'
    unk = 'unk'
    unm = 'unm'
    unn = 'unn'
    unr = 'unr'
    unu = 'unu'
    unx = 'unx'
    unz = 'unz'
    uon = 'uon'
    upi = 'upi'
    upv = 'upv'
    ura = 'ura'
    urb = 'urb'
    urc = 'urc'
    urd = 'urd'
    ure = 'ure'
    urf = 'urf'
    urg = 'urg'
    urh = 'urh'
    uri = 'uri'
    urk = 'urk'
    url = 'url'
    urm = 'urm'
    urn = 'urn'
    uro = 'uro'
    urp = 'urp'
    urr = 'urr'
    urt = 'urt'
    uru = 'uru'
    urv = 'urv'
    urw = 'urw'
    urx = 'urx'
    ury = 'ury'
    urz = 'urz'
    usa = 'usa'
    ush = 'ush'
    usi = 'usi'
    usk = 'usk'
    usp = 'usp'
    uss = 'uss'
    usu = 'usu'
    uta = 'uta'
    ute = 'ute'
    uth = 'uth'
    utp = 'utp'
    utr = 'utr'
    utu = 'utu'
    uum = 'uum'
    uur = 'uur'
    uuu = 'uuu'
    uve = 'uve'
    uvh = 'uvh'
    uvl = 'uvl'
    uwa = 'uwa'
    uya = 'uya'
    uzb = 'uzb'
    uzn = 'uzn'
    uzs = 'uzs'
    vaa = 'vaa'
    vae = 'vae'
    vaf = 'vaf'
    vag = 'vag'
    vah = 'vah'
    vai = 'vai'
    vaj = 'vaj'
    val = 'val'
    vam = 'vam'
    van = 'van'
    vao = 'vao'
    vap = 'vap'
    var = 'var'
    vas = 'vas'
    vau = 'vau'
    vav = 'vav'
    vay = 'vay'
    vbb = 'vbb'
    vbk = 'vbk'
    vec = 'vec'
    ved = 'ved'
    vel = 'vel'
    vem = 'vem'
    ven = 'ven'
    veo = 'veo'
    vep = 'vep'
    ver = 'ver'
    vgr = 'vgr'
    vgt = 'vgt'
    vic = 'vic'
    vid = 'vid'
    vie = 'vie'
    vif = 'vif'
    vig = 'vig'
    vil = 'vil'
    vin = 'vin'
    vis = 'vis'
    vit = 'vit'
    viv = 'viv'
    vka = 'vka'
    vkj = 'vkj'
    vkk = 'vkk'
    vkl = 'vkl'
    vkm = 'vkm'
    vkn = 'vkn'
    vko = 'vko'
    vkp = 'vkp'
    vkt = 'vkt'
    vku = 'vku'
    vkz = 'vkz'
    vlp = 'vlp'
    vls = 'vls'
    vma = 'vma'
    vmb = 'vmb'
    vmc = 'vmc'
    vmd = 'vmd'
    vme = 'vme'
    vmf = 'vmf'
    vmg = 'vmg'
    vmh = 'vmh'
    vmi = 'vmi'
    vmj = 'vmj'
    vmk = 'vmk'
    vml = 'vml'
    vmm = 'vmm'
    vmp = 'vmp'
    vmq = 'vmq'
    vmr = 'vmr'
    vms = 'vms'
    vmu = 'vmu'
    vmv = 'vmv'
    vmw = 'vmw'
    vmx = 'vmx'
    vmy = 'vmy'
    vmz = 'vmz'
    vnk = 'vnk'
    vnm = 'vnm'
    vnp = 'vnp'
    vol = 'vol'
    vor = 'vor'
    vot = 'vot'
    vra = 'vra'
    vro = 'vro'
    vrs = 'vrs'
    vrt = 'vrt'
    vsi = 'vsi'
    vsl = 'vsl'
    vsv = 'vsv'
    vto = 'vto'
    vum = 'vum'
    vun = 'vun'
    vut = 'vut'
    vwa = 'vwa'
    waa = 'waa'
    wab = 'wab'
    wac = 'wac'
    wad = 'wad'
    wae = 'wae'
    waf = 'waf'
    wag = 'wag'
    wah = 'wah'
    wai = 'wai'
    waj = 'waj'
    wal = 'wal'
    wam = 'wam'
    wan = 'wan'
    wao = 'wao'
    wap = 'wap'
    waq = 'waq'
    war = 'war'
    was = 'was'
    wat = 'wat'
    wau = 'wau'
    wav = 'wav'
    waw = 'waw'
    wax = 'wax'
    way = 'way'
    waz = 'waz'
    wba = 'wba'
    wbb = 'wbb'
    wbe = 'wbe'
    wbf = 'wbf'
    wbh = 'wbh'
    wbi = 'wbi'
    wbj = 'wbj'
    wbk = 'wbk'
    wbl = 'wbl'
    wbm = 'wbm'
    wbp = 'wbp'
    wbq = 'wbq'
    wbr = 'wbr'
    wbs = 'wbs'
    wbt = 'wbt'
    wbv = 'wbv'
    wbw = 'wbw'
    wca = 'wca'
    wci = 'wci'
    wdd = 'wdd'
    wdg = 'wdg'
    wdj = 'wdj'
    wdk = 'wdk'
    wdt = 'wdt'
    wdu = 'wdu'
    wdy = 'wdy'
    wea = 'wea'
    wec = 'wec'
    wed = 'wed'
    weg = 'weg'
    weh = 'weh'
    wei = 'wei'
    wem = 'wem'
    weo = 'weo'
    wep = 'wep'
    wer = 'wer'
    wes = 'wes'
    wet = 'wet'
    weu = 'weu'
    wew = 'wew'
    wfg = 'wfg'
    wga = 'wga'
    wgb = 'wgb'
    wgg = 'wgg'
    wgi = 'wgi'
    wgo = 'wgo'
    wgu = 'wgu'
    wgy = 'wgy'
    wha = 'wha'
    whg = 'whg'
    whk = 'whk'
    whu = 'whu'
    wib = 'wib'
    wic = 'wic'
    wie = 'wie'
    wif = 'wif'
    wig = 'wig'
    wih = 'wih'
    wii = 'wii'
    wij = 'wij'
    wik = 'wik'
    wil = 'wil'
    wim = 'wim'
    win = 'win'
    wir = 'wir'
    wiu = 'wiu'
    wiv = 'wiv'
    wiy = 'wiy'
    wja = 'wja'
    wji = 'wji'
    wka = 'wka'
    wkb = 'wkb'
    wkd = 'wkd'
    wkl = 'wkl'
    wkr = 'wkr'
    wku = 'wku'
    wkw = 'wkw'
    wky = 'wky'
    wla = 'wla'
    wlc = 'wlc'
    wle = 'wle'
    wlg = 'wlg'
    wlh = 'wlh'
    wli = 'wli'
    wlk = 'wlk'
    wll = 'wll'
    wlm = 'wlm'
    wln = 'wln'
    wlo = 'wlo'
    wlr = 'wlr'
    wls = 'wls'
    wlu = 'wlu'
    wlv = 'wlv'
    wlw = 'wlw'
    wlx = 'wlx'
    wly = 'wly'
    wma = 'wma'
    wmb = 'wmb'
    wmc = 'wmc'
    wmd = 'wmd'
    wme = 'wme'
    wmg = 'wmg'
    wmh = 'wmh'
    wmi = 'wmi'
    wmm = 'wmm'
    wmn = 'wmn'
    wmo = 'wmo'
    wms = 'wms'
    wmt = 'wmt'
    wmw = 'wmw'
    wmx = 'wmx'
    wnb = 'wnb'
    wnc = 'wnc'
    wnd = 'wnd'
    wne = 'wne'
    wng = 'wng'
    wni = 'wni'
    wnk = 'wnk'
    wnm = 'wnm'
    wnn = 'wnn'
    wno = 'wno'
    wnp = 'wnp'
    wnu = 'wnu'
    wnw = 'wnw'
    wny = 'wny'
    woa = 'woa'
    wob = 'wob'
    woc = 'woc'
    wod = 'wod'
    woe = 'woe'
    wof = 'wof'
    wog = 'wog'
    woi = 'woi'
    wok = 'wok'
    wol = 'wol'
    wom = 'wom'
    won = 'won'
    woo = 'woo'
    wor = 'wor'
    wos = 'wos'
    wow = 'wow'
    woy = 'woy'
    wpc = 'wpc'
    wrb = 'wrb'
    wrg = 'wrg'
    wrh = 'wrh'
    wri = 'wri'
    wrk = 'wrk'
    wrl = 'wrl'
    wrm = 'wrm'
    wrn = 'wrn'
    wro = 'wro'
    wrp = 'wrp'
    wrr = 'wrr'
    wrs = 'wrs'
    wru = 'wru'
    wrv = 'wrv'
    wrw = 'wrw'
    wrx = 'wrx'
    wry = 'wry'
    wrz = 'wrz'
    wsa = 'wsa'
    wsg = 'wsg'
    wsi = 'wsi'
    wsk = 'wsk'
    wsr = 'wsr'
    wss = 'wss'
    wsu = 'wsu'
    wsv = 'wsv'
    wtf = 'wtf'
    wth = 'wth'
    wti = 'wti'
    wtk = 'wtk'
    wtm = 'wtm'
    wtw = 'wtw'
    wua = 'wua'
    wub = 'wub'
    wud = 'wud'
    wuh = 'wuh'
    wul = 'wul'
    wum = 'wum'
    wun = 'wun'
    wur = 'wur'
    wut = 'wut'
    wuu = 'wuu'
    wuv = 'wuv'
    wux = 'wux'
    wuy = 'wuy'
    wwa = 'wwa'
    wwb = 'wwb'
    wwo = 'wwo'
    wwr = 'wwr'
    www = 'www'
    wxa = 'wxa'
    wxw = 'wxw'
    wyb = 'wyb'
    wyi = 'wyi'
    wym = 'wym'
    wyn = 'wyn'
    wyr = 'wyr'
    wyy = 'wyy'
    xaa = 'xaa'
    xab = 'xab'
    xac = 'xac'
    xad = 'xad'
    xae = 'xae'
    xag = 'xag'
    xai = 'xai'
    xaj = 'xaj'
    xak = 'xak'
    xal = 'xal'
    xam = 'xam'
    xan = 'xan'
    xao = 'xao'
    xap = 'xap'
    xaq = 'xaq'
    xar = 'xar'
    xas = 'xas'
    xat = 'xat'
    xau = 'xau'
    xav = 'xav'
    xaw = 'xaw'
    xay = 'xay'
    xbb = 'xbb'
    xbc = 'xbc'
    xbd = 'xbd'
    xbe = 'xbe'
    xbg = 'xbg'
    xbi = 'xbi'
    xbj = 'xbj'
    xbm = 'xbm'
    xbn = 'xbn'
    xbo = 'xbo'
    xbp = 'xbp'
    xbr = 'xbr'
    xbw = 'xbw'
    xby = 'xby'
    xcb = 'xcb'
    xcc = 'xcc'
    xce = 'xce'
    xcg = 'xcg'
    xch = 'xch'
    xcl = 'xcl'
    xcm = 'xcm'
    xcn = 'xcn'
    xco = 'xco'
    xcr = 'xcr'
    xct = 'xct'
    xcu = 'xcu'
    xcv = 'xcv'
    xcw = 'xcw'
    xcy = 'xcy'
    xda = 'xda'
    xdc = 'xdc'
    xdk = 'xdk'
    xdm = 'xdm'
    xdo = 'xdo'
    xdq = 'xdq'
    xdy = 'xdy'
    xeb = 'xeb'
    xed = 'xed'
    xeg = 'xeg'
    xel = 'xel'
    xem = 'xem'
    xep = 'xep'
    xer = 'xer'
    xes = 'xes'
    xet = 'xet'
    xeu = 'xeu'
    xfa = 'xfa'
    xga = 'xga'
    xgb = 'xgb'
    xgd = 'xgd'
    xgf = 'xgf'
    xgg = 'xgg'
    xgi = 'xgi'
    xgl = 'xgl'
    xgm = 'xgm'
    xgr = 'xgr'
    xgu = 'xgu'
    xgw = 'xgw'
    xha = 'xha'
    xhc = 'xhc'
    xhd = 'xhd'
    xhe = 'xhe'
    xhm = 'xhm'
    xho = 'xho'
    xhr = 'xhr'
    xht = 'xht'
    xhu = 'xhu'
    xhv = 'xhv'
    xib = 'xib'
    xii = 'xii'
    xil = 'xil'
    xin = 'xin'
    xir = 'xir'
    xis = 'xis'
    xiv = 'xiv'
    xiy = 'xiy'
    xjb = 'xjb'
    xjt = 'xjt'
    xka = 'xka'
    xkb = 'xkb'
    xkc = 'xkc'
    xkd = 'xkd'
    xke = 'xke'
    xkf = 'xkf'
    xkg = 'xkg'
    xki = 'xki'
    xkj = 'xkj'
    xkk = 'xkk'
    xkl = 'xkl'
    xkn = 'xkn'
    xko = 'xko'
    xkp = 'xkp'
    xkq = 'xkq'
    xkr = 'xkr'
    xks = 'xks'
    xkt = 'xkt'
    xku = 'xku'
    xkv = 'xkv'
    xkw = 'xkw'
    xkx = 'xkx'
    xky = 'xky'
    xkz = 'xkz'
    xla = 'xla'
    xlb = 'xlb'
    xlc = 'xlc'
    xld = 'xld'
    xle = 'xle'
    xlg = 'xlg'
    xli = 'xli'
    xln = 'xln'
    xlo = 'xlo'
    xlp = 'xlp'
    xls = 'xls'
    xlu = 'xlu'
    xly = 'xly'
    xma = 'xma'
    xmb = 'xmb'
    xmc = 'xmc'
    xmd = 'xmd'
    xme = 'xme'
    xmf = 'xmf'
    xmg = 'xmg'
    xmh = 'xmh'
    xmj = 'xmj'
    xmk = 'xmk'
    xml = 'xml'
    xmm = 'xmm'
    xmn = 'xmn'
    xmo = 'xmo'
    xmp = 'xmp'
    xmq = 'xmq'
    xmr = 'xmr'
    xms = 'xms'
    xmt = 'xmt'
    xmu = 'xmu'
    xmv = 'xmv'
    xmw = 'xmw'
    xmx = 'xmx'
    xmy = 'xmy'
    xmz = 'xmz'
    xna = 'xna'
    xnb = 'xnb'
    xng = 'xng'
    xnh = 'xnh'
    xni = 'xni'
    xnj = 'xnj'
    xnk = 'xnk'
    xnm = 'xnm'
    xnn = 'xnn'
    xno = 'xno'
    xnq = 'xnq'
    xnr = 'xnr'
    xns = 'xns'
    xnt = 'xnt'
    xnu = 'xnu'
    xny = 'xny'
    xnz = 'xnz'
    xoc = 'xoc'
    xod = 'xod'
    xog = 'xog'
    xoi = 'xoi'
    xok = 'xok'
    xom = 'xom'
    xon = 'xon'
    xoo = 'xoo'
    xop = 'xop'
    xor = 'xor'
    xow = 'xow'
    xpa = 'xpa'
    xpb = 'xpb'
    xpc = 'xpc'
    xpd = 'xpd'
    xpe = 'xpe'
    xpf = 'xpf'
    xpg = 'xpg'
    xph = 'xph'
    xpi = 'xpi'
    xpj = 'xpj'
    xpk = 'xpk'
    xpl = 'xpl'
    xpm = 'xpm'
    xpn = 'xpn'
    xpo = 'xpo'
    xpp = 'xpp'
    xpq = 'xpq'
    xpr = 'xpr'
    xps = 'xps'
    xpt = 'xpt'
    xpu = 'xpu'
    xpv = 'xpv'
    xpw = 'xpw'
    xpx = 'xpx'
    xpy = 'xpy'
    xpz = 'xpz'
    xqa = 'xqa'
    xqt = 'xqt'
    xra = 'xra'
    xrb = 'xrb'
    xrd = 'xrd'
    xre = 'xre'
    xrg = 'xrg'
    xri = 'xri'
    xrm = 'xrm'
    xrn = 'xrn'
    xrr = 'xrr'
    xrt = 'xrt'
    xru = 'xru'
    xrw = 'xrw'
    xsa = 'xsa'
    xsb = 'xsb'
    xsc = 'xsc'
    xsd = 'xsd'
    xse = 'xse'
    xsh = 'xsh'
    xsi = 'xsi'
    xsj = 'xsj'
    xsl = 'xsl'
    xsm = 'xsm'
    xsn = 'xsn'
    xso = 'xso'
    xsp = 'xsp'
    xsq = 'xsq'
    xsr = 'xsr'
    xss = 'xss'
    xsu = 'xsu'
    xsv = 'xsv'
    xsy = 'xsy'
    xta = 'xta'
    xtb = 'xtb'
    xtc = 'xtc'
    xtd = 'xtd'
    xte = 'xte'
    xtg = 'xtg'
    xth = 'xth'
    xti = 'xti'
    xtj = 'xtj'
    xtl = 'xtl'
    xtm = 'xtm'
    xtn = 'xtn'
    xto = 'xto'
    xtp = 'xtp'
    xtq = 'xtq'
    xtr = 'xtr'
    xts = 'xts'
    xtt = 'xtt'
    xtu = 'xtu'
    xtv = 'xtv'
    xtw = 'xtw'
    xty = 'xty'
    xua = 'xua'
    xub = 'xub'
    xud = 'xud'
    xug = 'xug'
    xuj = 'xuj'
    xul = 'xul'
    xum = 'xum'
    xun = 'xun'
    xuo = 'xuo'
    xup = 'xup'
    xur = 'xur'
    xut = 'xut'
    xuu = 'xuu'
    xve = 'xve'
    xvi = 'xvi'
    xvn = 'xvn'
    xvo = 'xvo'
    xvs = 'xvs'
    xwa = 'xwa'
    xwc = 'xwc'
    xwd = 'xwd'
    xwe = 'xwe'
    xwg = 'xwg'
    xwj = 'xwj'
    xwk = 'xwk'
    xwl = 'xwl'
    xwo = 'xwo'
    xwr = 'xwr'
    xwt = 'xwt'
    xww = 'xww'
    xxb = 'xxb'
    xxk = 'xxk'
    xxm = 'xxm'
    xxr = 'xxr'
    xxt = 'xxt'
    xya = 'xya'
    xyb = 'xyb'
    xyj = 'xyj'
    xyk = 'xyk'
    xyl = 'xyl'
    xyt = 'xyt'
    xyy = 'xyy'
    xzh = 'xzh'
    xzm = 'xzm'
    xzp = 'xzp'
    yaa = 'yaa'
    yab = 'yab'
    yac = 'yac'
    yad = 'yad'
    yae = 'yae'
    yaf = 'yaf'
    yag = 'yag'
    yah = 'yah'
    yai = 'yai'
    yaj = 'yaj'
    yak = 'yak'
    yal = 'yal'
    yam = 'yam'
    yan = 'yan'
    yao = 'yao'
    yap = 'yap'
    yaq = 'yaq'
    yar = 'yar'
    yas = 'yas'
    yat = 'yat'
    yau = 'yau'
    yav = 'yav'
    yaw = 'yaw'
    yax = 'yax'
    yay = 'yay'
    yaz = 'yaz'
    yba = 'yba'
    ybb = 'ybb'
    ybe = 'ybe'
    ybh = 'ybh'
    ybi = 'ybi'
    ybj = 'ybj'
    ybk = 'ybk'
    ybl = 'ybl'
    ybm = 'ybm'
    ybn = 'ybn'
    ybo = 'ybo'
    ybx = 'ybx'
    yby = 'yby'
    ych = 'ych'
    ycl = 'ycl'
    ycn = 'ycn'
    ycp = 'ycp'
    yda = 'yda'
    ydd = 'ydd'
    yde = 'yde'
    ydg = 'ydg'
    ydk = 'ydk'
    yea = 'yea'
    yec = 'yec'
    yee = 'yee'
    yei = 'yei'
    yej = 'yej'
    yel = 'yel'
    yer = 'yer'
    yes = 'yes'
    yet = 'yet'
    yeu = 'yeu'
    yev = 'yev'
    yey = 'yey'
    yga = 'yga'
    ygi = 'ygi'
    ygl = 'ygl'
    ygm = 'ygm'
    ygp = 'ygp'
    ygr = 'ygr'
    ygs = 'ygs'
    ygu = 'ygu'
    ygw = 'ygw'
    yha = 'yha'
    yhd = 'yhd'
    yhl = 'yhl'
    yhs = 'yhs'
    yia = 'yia'
    yid = 'yid'
    yif = 'yif'
    yig = 'yig'
    yih = 'yih'
    yii = 'yii'
    yij = 'yij'
    yik = 'yik'
    yil = 'yil'
    yim = 'yim'
    yin = 'yin'
    yip = 'yip'
    yiq = 'yiq'
    yir = 'yir'
    yis = 'yis'
    yit = 'yit'
    yiu = 'yiu'
    yiv = 'yiv'
    yix = 'yix'
    yiz = 'yiz'
    yka = 'yka'
    ykg = 'ykg'
    yki = 'yki'
    ykk = 'ykk'
    ykl = 'ykl'
    ykm = 'ykm'
    ykn = 'ykn'
    yko = 'yko'
    ykr = 'ykr'
    ykt = 'ykt'
    yku = 'yku'
    yky = 'yky'
    yla = 'yla'
    ylb = 'ylb'
    yle = 'yle'
    ylg = 'ylg'
    yli = 'yli'
    yll = 'yll'
    ylm = 'ylm'
    yln = 'yln'
    ylo = 'ylo'
    ylr = 'ylr'
    ylu = 'ylu'
    yly = 'yly'
    ymb = 'ymb'
    ymc = 'ymc'
    ymd = 'ymd'
    yme = 'yme'
    ymg = 'ymg'
    ymh = 'ymh'
    ymi = 'ymi'
    ymk = 'ymk'
    yml = 'yml'
    ymm = 'ymm'
    ymn = 'ymn'
    ymo = 'ymo'
    ymp = 'ymp'
    ymq = 'ymq'
    ymr = 'ymr'
    yms = 'yms'
    ymx = 'ymx'
    ymz = 'ymz'
    yna = 'yna'
    ynd = 'ynd'
    yne = 'yne'
    yng = 'yng'
    ynk = 'ynk'
    ynl = 'ynl'
    ynn = 'ynn'
    yno = 'yno'
    ynq = 'ynq'
    yns = 'yns'
    ynu = 'ynu'
    yob = 'yob'
    yog = 'yog'
    yoi = 'yoi'
    yok = 'yok'
    yol = 'yol'
    yom = 'yom'
    yon = 'yon'
    yor = 'yor'
    yot = 'yot'
    yox = 'yox'
    yoy = 'yoy'
    ypa = 'ypa'
    ypb = 'ypb'
    ypg = 'ypg'
    yph = 'yph'
    ypm = 'ypm'
    ypn = 'ypn'
    ypo = 'ypo'
    ypp = 'ypp'
    ypz = 'ypz'
    yra = 'yra'
    yrb = 'yrb'
    yre = 'yre'
    yrk = 'yrk'
    yrl = 'yrl'
    yrm = 'yrm'
    yrn = 'yrn'
    yro = 'yro'
    yrs = 'yrs'
    yrw = 'yrw'
    yry = 'yry'
    ysc = 'ysc'
    ysd = 'ysd'
    ysg = 'ysg'
    ysl = 'ysl'
    ysm = 'ysm'
    ysn = 'ysn'
    yso = 'yso'
    ysp = 'ysp'
    ysr = 'ysr'
    yss = 'yss'
    ysy = 'ysy'
    yta = 'yta'
    ytl = 'ytl'
    ytp = 'ytp'
    ytw = 'ytw'
    yty = 'yty'
    yua = 'yua'
    yub = 'yub'
    yuc = 'yuc'
    yud = 'yud'
    yue = 'yue'
    yuf = 'yuf'
    yug = 'yug'
    yui = 'yui'
    yuj = 'yuj'
    yuk = 'yuk'
    yul = 'yul'
    yum = 'yum'
    yun = 'yun'
    yup = 'yup'
    yuq = 'yuq'
    yur = 'yur'
    yut = 'yut'
    yuw = 'yuw'
    yux = 'yux'
    yuy = 'yuy'
    yuz = 'yuz'
    yva = 'yva'
    yvt = 'yvt'
    ywa = 'ywa'
    ywg = 'ywg'
    ywl = 'ywl'
    ywn = 'ywn'
    ywq = 'ywq'
    ywr = 'ywr'
    ywt = 'ywt'
    ywu = 'ywu'
    yww = 'yww'
    yxa = 'yxa'
    yxg = 'yxg'
    yxl = 'yxl'
    yxm = 'yxm'
    yxu = 'yxu'
    yxy = 'yxy'
    yyr = 'yyr'
    yyu = 'yyu'
    yyz = 'yyz'
    yzg = 'yzg'
    yzk = 'yzk'
    zaa = 'zaa'
    zab = 'zab'
    zac = 'zac'
    zad = 'zad'
    zae = 'zae'
    zaf = 'zaf'
    zag = 'zag'
    zah = 'zah'
    zai = 'zai'
    zaj = 'zaj'
    zak = 'zak'
    zal = 'zal'
    zam = 'zam'
    zao = 'zao'
    zap = 'zap'
    zaq = 'zaq'
    zar = 'zar'
    zas = 'zas'
    zat = 'zat'
    zau = 'zau'
    zav = 'zav'
    zaw = 'zaw'
    zax = 'zax'
    zay = 'zay'
    zaz = 'zaz'
    zba = 'zba'
    zbc = 'zbc'
    zbe = 'zbe'
    zbl = 'zbl'
    zbt = 'zbt'
    zbu = 'zbu'
    zbw = 'zbw'
    zca = 'zca'
    zcd = 'zcd'
    zch = 'zch'
    zdj = 'zdj'
    zea = 'zea'
    zeg = 'zeg'
    zeh = 'zeh'
    zen = 'zen'
    zga = 'zga'
    zgb = 'zgb'
    zgh = 'zgh'
    zgm = 'zgm'
    zgn = 'zgn'
    zgr = 'zgr'
    zha = 'zha'
    zhb = 'zhb'
    zhd = 'zhd'
    zhi = 'zhi'
    zhn = 'zhn'
    zho = 'zho'
    zhw = 'zhw'
    zia = 'zia'
    zib = 'zib'
    zik = 'zik'
    zil = 'zil'
    zim = 'zim'
    zin = 'zin'
    ziw = 'ziw'
    ziz = 'ziz'
    zka = 'zka'
    zkb = 'zkb'
    zkd = 'zkd'
    zkg = 'zkg'
    zkh = 'zkh'
    zkk = 'zkk'
    zkn = 'zkn'
    zko = 'zko'
    zkp = 'zkp'
    zkr = 'zkr'
    zkt = 'zkt'
    zku = 'zku'
    zkv = 'zkv'
    zkz = 'zkz'
    zla = 'zla'
    zlj = 'zlj'
    zlm = 'zlm'
    zln = 'zln'
    zlq = 'zlq'
    zma = 'zma'
    zmb = 'zmb'
    zmc = 'zmc'
    zmd = 'zmd'
    zme = 'zme'
    zmf = 'zmf'
    zmg = 'zmg'
    zmh = 'zmh'
    zmi = 'zmi'
    zmj = 'zmj'
    zmk = 'zmk'
    zml = 'zml'
    zmm = 'zmm'
    zmn = 'zmn'
    zmo = 'zmo'
    zmp = 'zmp'
    zmq = 'zmq'
    zmr = 'zmr'
    zms = 'zms'
    zmt = 'zmt'
    zmu = 'zmu'
    zmv = 'zmv'
    zmw = 'zmw'
    zmx = 'zmx'
    zmy = 'zmy'
    zmz = 'zmz'
    zna = 'zna'
    zne = 'zne'
    zng = 'zng'
    znk = 'znk'
    zns = 'zns'
    zoc = 'zoc'
    zoh = 'zoh'
    zom = 'zom'
    zoo = 'zoo'
    zoq = 'zoq'
    zor = 'zor'
    zos = 'zos'
    zpa = 'zpa'
    zpb = 'zpb'
    zpc = 'zpc'
    zpd = 'zpd'
    zpe = 'zpe'
    zpf = 'zpf'
    zpg = 'zpg'
    zph = 'zph'
    zpi = 'zpi'
    zpj = 'zpj'
    zpk = 'zpk'
    zpl = 'zpl'
    zpm = 'zpm'
    zpn = 'zpn'
    zpo = 'zpo'
    zpp = 'zpp'
    zpq = 'zpq'
    zpr = 'zpr'
    zps = 'zps'
    zpt = 'zpt'
    zpu = 'zpu'
    zpv = 'zpv'
    zpw = 'zpw'
    zpx = 'zpx'
    zpy = 'zpy'
    zpz = 'zpz'
    zqe = 'zqe'
    zra = 'zra'
    zrg = 'zrg'
    zrn = 'zrn'
    zro = 'zro'
    zrp = 'zrp'
    zrs = 'zrs'
    zsa = 'zsa'
    zsk = 'zsk'
    zsl = 'zsl'
    zsm = 'zsm'
    zsr = 'zsr'
    zsu = 'zsu'
    zte = 'zte'
    ztg = 'ztg'
    ztl = 'ztl'
    ztm = 'ztm'
    ztn = 'ztn'
    ztp = 'ztp'
    ztq = 'ztq'
    zts = 'zts'
    ztt = 'ztt'
    ztu = 'ztu'
    ztx = 'ztx'
    zty = 'zty'
    zua = 'zua'
    zuh = 'zuh'
    zul = 'zul'
    zum = 'zum'
    zun = 'zun'
    zuy = 'zuy'
    zwa = 'zwa'
    zxx = 'zxx'
    zyb = 'zyb'
    zyg = 'zyg'
    zyj = 'zyj'
    zyn = 'zyn'
    zyp = 'zyp'
    zza = 'zza'
    zzj = 'zzj'


class OrganizationCreateAgentVersionRequestIdentityRelationshipToDeveloper(BaseModel):
    ownership: str = Field(..., min_length=1)
    type: str = Field(..., min_length=1)
    conversation_visibility: str = Field(..., min_length=1)
    thought_visibility: str = Field(..., min_length=1)


class OrganizationCreateAgentVersionRequestVoiceConfig(BaseModel):
    voice_id: str = Field(
        ..., description='The Elevenlabs voice ID for this agent.', title='Voice Id'
    )
    stability: float = Field(..., ge=0.0, le=1.0, title='Stability')
    similarity_boost: float = Field(..., ge=0.0, le=1.0, title='Similarity Boost')
    style: float = Field(..., ge=0.0, le=1.0, title='Style')


class OrganizationCreateAgentVersionResponse(BaseModel):
    id: str = Field(..., description='The ID of the new agent version.', title='Id')
    version: int = Field(
        ...,
        description='Numerical version ID that describes how many iterations of this agent occurred before this version. Note that this is for reference only.\nAny identification of an agent version in Amigo APIs use the `id` field.\n\nFor initial version of an agent, this field will be 1.',
        title='Version',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The time at which this version was created.',
        title='Created At',
    )


class OrganizationCreateApiKeyRequest(BaseModel):
    duration: timedelta = Field(
        ...,
        description='The valid duration of the API key. Should be supplied in the [ISO8601 format](https://en.wikipedia.org/wiki/ISO_8601#Durations). Must be between 1 to 90 days.',
        title='Duration',
    )
    role_name: Optional[str] = Field(
        'DefaultAdministratorRole',
        description='The name of the role associated with the key. When using this API key to authenticate, it can only authenticate for users with roles that are less permissive\nthan this role.',
        title='Role Name',
    )


class OrganizationCreateApiKeyResponse(BaseModel):
    api_key_id: str = Field(
        ...,
        description='An identifier for this API key. You must present this along with the API key to authenticate.',
        title='Api Key Id',
    )
    api_key: str = Field(
        ...,
        description='The API key. This is only visible once and is not retrievable later. Please store safely.',
        title='Api Key',
    )
    expires_at: AwareDatetime = Field(
        ..., description='Expiration time of the API key in UTC.', title='Expires At'
    )


class OrganizationCreateOrganizationRequestPreferencesTimezone(Enum):
    africa_abidjan = 'Africa/Abidjan'
    africa_accra = 'Africa/Accra'
    africa_addis_ababa = 'Africa/Addis_Ababa'
    africa_algiers = 'Africa/Algiers'
    africa_asmara = 'Africa/Asmara'
    africa_asmera = 'Africa/Asmera'
    africa_bamako = 'Africa/Bamako'
    africa_bangui = 'Africa/Bangui'
    africa_banjul = 'Africa/Banjul'
    africa_bissau = 'Africa/Bissau'
    africa_blantyre = 'Africa/Blantyre'
    africa_brazzaville = 'Africa/Brazzaville'
    africa_bujumbura = 'Africa/Bujumbura'
    africa_cairo = 'Africa/Cairo'
    africa_casablanca = 'Africa/Casablanca'
    africa_ceuta = 'Africa/Ceuta'
    africa_conakry = 'Africa/Conakry'
    africa_dakar = 'Africa/Dakar'
    africa_dar_es_salaam = 'Africa/Dar_es_Salaam'
    africa_djibouti = 'Africa/Djibouti'
    africa_douala = 'Africa/Douala'
    africa_el_aaiun = 'Africa/El_Aaiun'
    africa_freetown = 'Africa/Freetown'
    africa_gaborone = 'Africa/Gaborone'
    africa_harare = 'Africa/Harare'
    africa_johannesburg = 'Africa/Johannesburg'
    africa_juba = 'Africa/Juba'
    africa_kampala = 'Africa/Kampala'
    africa_khartoum = 'Africa/Khartoum'
    africa_kigali = 'Africa/Kigali'
    africa_kinshasa = 'Africa/Kinshasa'
    africa_lagos = 'Africa/Lagos'
    africa_libreville = 'Africa/Libreville'
    africa_lome = 'Africa/Lome'
    africa_luanda = 'Africa/Luanda'
    africa_lubumbashi = 'Africa/Lubumbashi'
    africa_lusaka = 'Africa/Lusaka'
    africa_malabo = 'Africa/Malabo'
    africa_maputo = 'Africa/Maputo'
    africa_maseru = 'Africa/Maseru'
    africa_mbabane = 'Africa/Mbabane'
    africa_mogadishu = 'Africa/Mogadishu'
    africa_monrovia = 'Africa/Monrovia'
    africa_nairobi = 'Africa/Nairobi'
    africa_ndjamena = 'Africa/Ndjamena'
    africa_niamey = 'Africa/Niamey'
    africa_nouakchott = 'Africa/Nouakchott'
    africa_ouagadougou = 'Africa/Ouagadougou'
    africa_porto_novo = 'Africa/Porto-Novo'
    africa_sao_tome = 'Africa/Sao_Tome'
    africa_timbuktu = 'Africa/Timbuktu'
    africa_tripoli = 'Africa/Tripoli'
    africa_tunis = 'Africa/Tunis'
    africa_windhoek = 'Africa/Windhoek'
    america_adak = 'America/Adak'
    america_anchorage = 'America/Anchorage'
    america_anguilla = 'America/Anguilla'
    america_antigua = 'America/Antigua'
    america_araguaina = 'America/Araguaina'
    america_argentina_buenos_aires = 'America/Argentina/Buenos_Aires'
    america_argentina_catamarca = 'America/Argentina/Catamarca'
    america_argentina_comod_rivadavia = 'America/Argentina/ComodRivadavia'
    america_argentina_cordoba = 'America/Argentina/Cordoba'
    america_argentina_jujuy = 'America/Argentina/Jujuy'
    america_argentina_la_rioja = 'America/Argentina/La_Rioja'
    america_argentina_mendoza = 'America/Argentina/Mendoza'
    america_argentina_rio_gallegos = 'America/Argentina/Rio_Gallegos'
    america_argentina_salta = 'America/Argentina/Salta'
    america_argentina_san_juan = 'America/Argentina/San_Juan'
    america_argentina_san_luis = 'America/Argentina/San_Luis'
    america_argentina_tucuman = 'America/Argentina/Tucuman'
    america_argentina_ushuaia = 'America/Argentina/Ushuaia'
    america_aruba = 'America/Aruba'
    america_asuncion = 'America/Asuncion'
    america_atikokan = 'America/Atikokan'
    america_atka = 'America/Atka'
    america_bahia = 'America/Bahia'
    america_bahia_banderas = 'America/Bahia_Banderas'
    america_barbados = 'America/Barbados'
    america_belem = 'America/Belem'
    america_belize = 'America/Belize'
    america_blanc_sablon = 'America/Blanc-Sablon'
    america_boa_vista = 'America/Boa_Vista'
    america_bogota = 'America/Bogota'
    america_boise = 'America/Boise'
    america_buenos_aires = 'America/Buenos_Aires'
    america_cambridge_bay = 'America/Cambridge_Bay'
    america_campo_grande = 'America/Campo_Grande'
    america_cancun = 'America/Cancun'
    america_caracas = 'America/Caracas'
    america_catamarca = 'America/Catamarca'
    america_cayenne = 'America/Cayenne'
    america_cayman = 'America/Cayman'
    america_chicago = 'America/Chicago'
    america_chihuahua = 'America/Chihuahua'
    america_ciudad_juarez = 'America/Ciudad_Juarez'
    america_coral_harbour = 'America/Coral_Harbour'
    america_cordoba = 'America/Cordoba'
    america_costa_rica = 'America/Costa_Rica'
    america_coyhaique = 'America/Coyhaique'
    america_creston = 'America/Creston'
    america_cuiaba = 'America/Cuiaba'
    america_curacao = 'America/Curacao'
    america_danmarkshavn = 'America/Danmarkshavn'
    america_dawson = 'America/Dawson'
    america_dawson_creek = 'America/Dawson_Creek'
    america_denver = 'America/Denver'
    america_detroit = 'America/Detroit'
    america_dominica = 'America/Dominica'
    america_edmonton = 'America/Edmonton'
    america_eirunepe = 'America/Eirunepe'
    america_el_salvador = 'America/El_Salvador'
    america_ensenada = 'America/Ensenada'
    america_fort_nelson = 'America/Fort_Nelson'
    america_fort_wayne = 'America/Fort_Wayne'
    america_fortaleza = 'America/Fortaleza'
    america_glace_bay = 'America/Glace_Bay'
    america_godthab = 'America/Godthab'
    america_goose_bay = 'America/Goose_Bay'
    america_grand_turk = 'America/Grand_Turk'
    america_grenada = 'America/Grenada'
    america_guadeloupe = 'America/Guadeloupe'
    america_guatemala = 'America/Guatemala'
    america_guayaquil = 'America/Guayaquil'
    america_guyana = 'America/Guyana'
    america_halifax = 'America/Halifax'
    america_havana = 'America/Havana'
    america_hermosillo = 'America/Hermosillo'
    america_indiana_indianapolis = 'America/Indiana/Indianapolis'
    america_indiana_knox = 'America/Indiana/Knox'
    america_indiana_marengo = 'America/Indiana/Marengo'
    america_indiana_petersburg = 'America/Indiana/Petersburg'
    america_indiana_tell_city = 'America/Indiana/Tell_City'
    america_indiana_vevay = 'America/Indiana/Vevay'
    america_indiana_vincennes = 'America/Indiana/Vincennes'
    america_indiana_winamac = 'America/Indiana/Winamac'
    america_indianapolis = 'America/Indianapolis'
    america_inuvik = 'America/Inuvik'
    america_iqaluit = 'America/Iqaluit'
    america_jamaica = 'America/Jamaica'
    america_jujuy = 'America/Jujuy'
    america_juneau = 'America/Juneau'
    america_kentucky_louisville = 'America/Kentucky/Louisville'
    america_kentucky_monticello = 'America/Kentucky/Monticello'
    america_knox_in = 'America/Knox_IN'
    america_kralendijk = 'America/Kralendijk'
    america_la_paz = 'America/La_Paz'
    america_lima = 'America/Lima'
    america_los_angeles = 'America/Los_Angeles'
    america_louisville = 'America/Louisville'
    america_lower_princes = 'America/Lower_Princes'
    america_maceio = 'America/Maceio'
    america_managua = 'America/Managua'
    america_manaus = 'America/Manaus'
    america_marigot = 'America/Marigot'
    america_martinique = 'America/Martinique'
    america_matamoros = 'America/Matamoros'
    america_mazatlan = 'America/Mazatlan'
    america_mendoza = 'America/Mendoza'
    america_menominee = 'America/Menominee'
    america_merida = 'America/Merida'
    america_metlakatla = 'America/Metlakatla'
    america_mexico_city = 'America/Mexico_City'
    america_miquelon = 'America/Miquelon'
    america_moncton = 'America/Moncton'
    america_monterrey = 'America/Monterrey'
    america_montevideo = 'America/Montevideo'
    america_montreal = 'America/Montreal'
    america_montserrat = 'America/Montserrat'
    america_nassau = 'America/Nassau'
    america_new_york = 'America/New_York'
    america_nipigon = 'America/Nipigon'
    america_nome = 'America/Nome'
    america_noronha = 'America/Noronha'
    america_north_dakota_beulah = 'America/North_Dakota/Beulah'
    america_north_dakota_center = 'America/North_Dakota/Center'
    america_north_dakota_new_salem = 'America/North_Dakota/New_Salem'
    america_nuuk = 'America/Nuuk'
    america_ojinaga = 'America/Ojinaga'
    america_panama = 'America/Panama'
    america_pangnirtung = 'America/Pangnirtung'
    america_paramaribo = 'America/Paramaribo'
    america_phoenix = 'America/Phoenix'
    america_port_au_prince = 'America/Port-au-Prince'
    america_port_of_spain = 'America/Port_of_Spain'
    america_porto_acre = 'America/Porto_Acre'
    america_porto_velho = 'America/Porto_Velho'
    america_puerto_rico = 'America/Puerto_Rico'
    america_punta_arenas = 'America/Punta_Arenas'
    america_rainy_river = 'America/Rainy_River'
    america_rankin_inlet = 'America/Rankin_Inlet'
    america_recife = 'America/Recife'
    america_regina = 'America/Regina'
    america_resolute = 'America/Resolute'
    america_rio_branco = 'America/Rio_Branco'
    america_rosario = 'America/Rosario'
    america_santa_isabel = 'America/Santa_Isabel'
    america_santarem = 'America/Santarem'
    america_santiago = 'America/Santiago'
    america_santo_domingo = 'America/Santo_Domingo'
    america_sao_paulo = 'America/Sao_Paulo'
    america_scoresbysund = 'America/Scoresbysund'
    america_shiprock = 'America/Shiprock'
    america_sitka = 'America/Sitka'
    america_st_barthelemy = 'America/St_Barthelemy'
    america_st_johns = 'America/St_Johns'
    america_st_kitts = 'America/St_Kitts'
    america_st_lucia = 'America/St_Lucia'
    america_st_thomas = 'America/St_Thomas'
    america_st_vincent = 'America/St_Vincent'
    america_swift_current = 'America/Swift_Current'
    america_tegucigalpa = 'America/Tegucigalpa'
    america_thule = 'America/Thule'
    america_thunder_bay = 'America/Thunder_Bay'
    america_tijuana = 'America/Tijuana'
    america_toronto = 'America/Toronto'
    america_tortola = 'America/Tortola'
    america_vancouver = 'America/Vancouver'
    america_virgin = 'America/Virgin'
    america_whitehorse = 'America/Whitehorse'
    america_winnipeg = 'America/Winnipeg'
    america_yakutat = 'America/Yakutat'
    america_yellowknife = 'America/Yellowknife'
    antarctica_casey = 'Antarctica/Casey'
    antarctica_davis = 'Antarctica/Davis'
    antarctica_dumont_d_urville = 'Antarctica/DumontDUrville'
    antarctica_macquarie = 'Antarctica/Macquarie'
    antarctica_mawson = 'Antarctica/Mawson'
    antarctica_mc_murdo = 'Antarctica/McMurdo'
    antarctica_palmer = 'Antarctica/Palmer'
    antarctica_rothera = 'Antarctica/Rothera'
    antarctica_south_pole = 'Antarctica/South_Pole'
    antarctica_syowa = 'Antarctica/Syowa'
    antarctica_troll = 'Antarctica/Troll'
    antarctica_vostok = 'Antarctica/Vostok'
    arctic_longyearbyen = 'Arctic/Longyearbyen'
    asia_aden = 'Asia/Aden'
    asia_almaty = 'Asia/Almaty'
    asia_amman = 'Asia/Amman'
    asia_anadyr = 'Asia/Anadyr'
    asia_aqtau = 'Asia/Aqtau'
    asia_aqtobe = 'Asia/Aqtobe'
    asia_ashgabat = 'Asia/Ashgabat'
    asia_ashkhabad = 'Asia/Ashkhabad'
    asia_atyrau = 'Asia/Atyrau'
    asia_baghdad = 'Asia/Baghdad'
    asia_bahrain = 'Asia/Bahrain'
    asia_baku = 'Asia/Baku'
    asia_bangkok = 'Asia/Bangkok'
    asia_barnaul = 'Asia/Barnaul'
    asia_beirut = 'Asia/Beirut'
    asia_bishkek = 'Asia/Bishkek'
    asia_brunei = 'Asia/Brunei'
    asia_calcutta = 'Asia/Calcutta'
    asia_chita = 'Asia/Chita'
    asia_choibalsan = 'Asia/Choibalsan'
    asia_chongqing = 'Asia/Chongqing'
    asia_chungking = 'Asia/Chungking'
    asia_colombo = 'Asia/Colombo'
    asia_dacca = 'Asia/Dacca'
    asia_damascus = 'Asia/Damascus'
    asia_dhaka = 'Asia/Dhaka'
    asia_dili = 'Asia/Dili'
    asia_dubai = 'Asia/Dubai'
    asia_dushanbe = 'Asia/Dushanbe'
    asia_famagusta = 'Asia/Famagusta'
    asia_gaza = 'Asia/Gaza'
    asia_harbin = 'Asia/Harbin'
    asia_hebron = 'Asia/Hebron'
    asia_ho_chi_minh = 'Asia/Ho_Chi_Minh'
    asia_hong_kong = 'Asia/Hong_Kong'
    asia_hovd = 'Asia/Hovd'
    asia_irkutsk = 'Asia/Irkutsk'
    asia_istanbul = 'Asia/Istanbul'
    asia_jakarta = 'Asia/Jakarta'
    asia_jayapura = 'Asia/Jayapura'
    asia_jerusalem = 'Asia/Jerusalem'
    asia_kabul = 'Asia/Kabul'
    asia_kamchatka = 'Asia/Kamchatka'
    asia_karachi = 'Asia/Karachi'
    asia_kashgar = 'Asia/Kashgar'
    asia_kathmandu = 'Asia/Kathmandu'
    asia_katmandu = 'Asia/Katmandu'
    asia_khandyga = 'Asia/Khandyga'
    asia_kolkata = 'Asia/Kolkata'
    asia_krasnoyarsk = 'Asia/Krasnoyarsk'
    asia_kuala_lumpur = 'Asia/Kuala_Lumpur'
    asia_kuching = 'Asia/Kuching'
    asia_kuwait = 'Asia/Kuwait'
    asia_macao = 'Asia/Macao'
    asia_macau = 'Asia/Macau'
    asia_magadan = 'Asia/Magadan'
    asia_makassar = 'Asia/Makassar'
    asia_manila = 'Asia/Manila'
    asia_muscat = 'Asia/Muscat'
    asia_nicosia = 'Asia/Nicosia'
    asia_novokuznetsk = 'Asia/Novokuznetsk'
    asia_novosibirsk = 'Asia/Novosibirsk'
    asia_omsk = 'Asia/Omsk'
    asia_oral = 'Asia/Oral'
    asia_phnom_penh = 'Asia/Phnom_Penh'
    asia_pontianak = 'Asia/Pontianak'
    asia_pyongyang = 'Asia/Pyongyang'
    asia_qatar = 'Asia/Qatar'
    asia_qostanay = 'Asia/Qostanay'
    asia_qyzylorda = 'Asia/Qyzylorda'
    asia_rangoon = 'Asia/Rangoon'
    asia_riyadh = 'Asia/Riyadh'
    asia_saigon = 'Asia/Saigon'
    asia_sakhalin = 'Asia/Sakhalin'
    asia_samarkand = 'Asia/Samarkand'
    asia_seoul = 'Asia/Seoul'
    asia_shanghai = 'Asia/Shanghai'
    asia_singapore = 'Asia/Singapore'
    asia_srednekolymsk = 'Asia/Srednekolymsk'
    asia_taipei = 'Asia/Taipei'
    asia_tashkent = 'Asia/Tashkent'
    asia_tbilisi = 'Asia/Tbilisi'
    asia_tehran = 'Asia/Tehran'
    asia_tel_aviv = 'Asia/Tel_Aviv'
    asia_thimbu = 'Asia/Thimbu'
    asia_thimphu = 'Asia/Thimphu'
    asia_tokyo = 'Asia/Tokyo'
    asia_tomsk = 'Asia/Tomsk'
    asia_ujung_pandang = 'Asia/Ujung_Pandang'
    asia_ulaanbaatar = 'Asia/Ulaanbaatar'
    asia_ulan_bator = 'Asia/Ulan_Bator'
    asia_urumqi = 'Asia/Urumqi'
    asia_ust_nera = 'Asia/Ust-Nera'
    asia_vientiane = 'Asia/Vientiane'
    asia_vladivostok = 'Asia/Vladivostok'
    asia_yakutsk = 'Asia/Yakutsk'
    asia_yangon = 'Asia/Yangon'
    asia_yekaterinburg = 'Asia/Yekaterinburg'
    asia_yerevan = 'Asia/Yerevan'
    atlantic_azores = 'Atlantic/Azores'
    atlantic_bermuda = 'Atlantic/Bermuda'
    atlantic_canary = 'Atlantic/Canary'
    atlantic_cape_verde = 'Atlantic/Cape_Verde'
    atlantic_faeroe = 'Atlantic/Faeroe'
    atlantic_faroe = 'Atlantic/Faroe'
    atlantic_jan_mayen = 'Atlantic/Jan_Mayen'
    atlantic_madeira = 'Atlantic/Madeira'
    atlantic_reykjavik = 'Atlantic/Reykjavik'
    atlantic_south_georgia = 'Atlantic/South_Georgia'
    atlantic_st_helena = 'Atlantic/St_Helena'
    atlantic_stanley = 'Atlantic/Stanley'
    australia_act = 'Australia/ACT'
    australia_adelaide = 'Australia/Adelaide'
    australia_brisbane = 'Australia/Brisbane'
    australia_broken_hill = 'Australia/Broken_Hill'
    australia_canberra = 'Australia/Canberra'
    australia_currie = 'Australia/Currie'
    australia_darwin = 'Australia/Darwin'
    australia_eucla = 'Australia/Eucla'
    australia_hobart = 'Australia/Hobart'
    australia_lhi = 'Australia/LHI'
    australia_lindeman = 'Australia/Lindeman'
    australia_lord_howe = 'Australia/Lord_Howe'
    australia_melbourne = 'Australia/Melbourne'
    australia_nsw = 'Australia/NSW'
    australia_north = 'Australia/North'
    australia_perth = 'Australia/Perth'
    australia_queensland = 'Australia/Queensland'
    australia_south = 'Australia/South'
    australia_sydney = 'Australia/Sydney'
    australia_tasmania = 'Australia/Tasmania'
    australia_victoria = 'Australia/Victoria'
    australia_west = 'Australia/West'
    australia_yancowinna = 'Australia/Yancowinna'
    brazil_acre = 'Brazil/Acre'
    brazil_de_noronha = 'Brazil/DeNoronha'
    brazil_east = 'Brazil/East'
    brazil_west = 'Brazil/West'
    cet = 'CET'
    cst6_cdt = 'CST6CDT'
    canada_atlantic = 'Canada/Atlantic'
    canada_central = 'Canada/Central'
    canada_eastern = 'Canada/Eastern'
    canada_mountain = 'Canada/Mountain'
    canada_newfoundland = 'Canada/Newfoundland'
    canada_pacific = 'Canada/Pacific'
    canada_saskatchewan = 'Canada/Saskatchewan'
    canada_yukon = 'Canada/Yukon'
    chile_continental = 'Chile/Continental'
    chile_easter_island = 'Chile/EasterIsland'
    cuba = 'Cuba'
    eet = 'EET'
    est = 'EST'
    est5_edt = 'EST5EDT'
    egypt = 'Egypt'
    eire = 'Eire'
    etc_gmt = 'Etc/GMT'
    etc_gmt_0 = 'Etc/GMT+0'
    etc_gmt_1 = 'Etc/GMT+1'
    etc_gmt_10 = 'Etc/GMT+10'
    etc_gmt_11 = 'Etc/GMT+11'
    etc_gmt_12 = 'Etc/GMT+12'
    etc_gmt_2 = 'Etc/GMT+2'
    etc_gmt_3 = 'Etc/GMT+3'
    etc_gmt_4 = 'Etc/GMT+4'
    etc_gmt_5 = 'Etc/GMT+5'
    etc_gmt_6 = 'Etc/GMT+6'
    etc_gmt_7 = 'Etc/GMT+7'
    etc_gmt_8 = 'Etc/GMT+8'
    etc_gmt_9 = 'Etc/GMT+9'
    etc_gmt_0_1 = 'Etc/GMT-0'
    etc_gmt_1_1 = 'Etc/GMT-1'
    etc_gmt_10_1 = 'Etc/GMT-10'
    etc_gmt_11_1 = 'Etc/GMT-11'
    etc_gmt_12_1 = 'Etc/GMT-12'
    etc_gmt_13 = 'Etc/GMT-13'
    etc_gmt_14 = 'Etc/GMT-14'
    etc_gmt_2_1 = 'Etc/GMT-2'
    etc_gmt_3_1 = 'Etc/GMT-3'
    etc_gmt_4_1 = 'Etc/GMT-4'
    etc_gmt_5_1 = 'Etc/GMT-5'
    etc_gmt_6_1 = 'Etc/GMT-6'
    etc_gmt_7_1 = 'Etc/GMT-7'
    etc_gmt_8_1 = 'Etc/GMT-8'
    etc_gmt_9_1 = 'Etc/GMT-9'
    etc_gmt0 = 'Etc/GMT0'
    etc_greenwich = 'Etc/Greenwich'
    etc_uct = 'Etc/UCT'
    etc_utc = 'Etc/UTC'
    etc_universal = 'Etc/Universal'
    etc_zulu = 'Etc/Zulu'
    europe_amsterdam = 'Europe/Amsterdam'
    europe_andorra = 'Europe/Andorra'
    europe_astrakhan = 'Europe/Astrakhan'
    europe_athens = 'Europe/Athens'
    europe_belfast = 'Europe/Belfast'
    europe_belgrade = 'Europe/Belgrade'
    europe_berlin = 'Europe/Berlin'
    europe_bratislava = 'Europe/Bratislava'
    europe_brussels = 'Europe/Brussels'
    europe_bucharest = 'Europe/Bucharest'
    europe_budapest = 'Europe/Budapest'
    europe_busingen = 'Europe/Busingen'
    europe_chisinau = 'Europe/Chisinau'
    europe_copenhagen = 'Europe/Copenhagen'
    europe_dublin = 'Europe/Dublin'
    europe_gibraltar = 'Europe/Gibraltar'
    europe_guernsey = 'Europe/Guernsey'
    europe_helsinki = 'Europe/Helsinki'
    europe_isle_of_man = 'Europe/Isle_of_Man'
    europe_istanbul = 'Europe/Istanbul'
    europe_jersey = 'Europe/Jersey'
    europe_kaliningrad = 'Europe/Kaliningrad'
    europe_kiev = 'Europe/Kiev'
    europe_kirov = 'Europe/Kirov'
    europe_kyiv = 'Europe/Kyiv'
    europe_lisbon = 'Europe/Lisbon'
    europe_ljubljana = 'Europe/Ljubljana'
    europe_london = 'Europe/London'
    europe_luxembourg = 'Europe/Luxembourg'
    europe_madrid = 'Europe/Madrid'
    europe_malta = 'Europe/Malta'
    europe_mariehamn = 'Europe/Mariehamn'
    europe_minsk = 'Europe/Minsk'
    europe_monaco = 'Europe/Monaco'
    europe_moscow = 'Europe/Moscow'
    europe_nicosia = 'Europe/Nicosia'
    europe_oslo = 'Europe/Oslo'
    europe_paris = 'Europe/Paris'
    europe_podgorica = 'Europe/Podgorica'
    europe_prague = 'Europe/Prague'
    europe_riga = 'Europe/Riga'
    europe_rome = 'Europe/Rome'
    europe_samara = 'Europe/Samara'
    europe_san_marino = 'Europe/San_Marino'
    europe_sarajevo = 'Europe/Sarajevo'
    europe_saratov = 'Europe/Saratov'
    europe_simferopol = 'Europe/Simferopol'
    europe_skopje = 'Europe/Skopje'
    europe_sofia = 'Europe/Sofia'
    europe_stockholm = 'Europe/Stockholm'
    europe_tallinn = 'Europe/Tallinn'
    europe_tirane = 'Europe/Tirane'
    europe_tiraspol = 'Europe/Tiraspol'
    europe_ulyanovsk = 'Europe/Ulyanovsk'
    europe_uzhgorod = 'Europe/Uzhgorod'
    europe_vaduz = 'Europe/Vaduz'
    europe_vatican = 'Europe/Vatican'
    europe_vienna = 'Europe/Vienna'
    europe_vilnius = 'Europe/Vilnius'
    europe_volgograd = 'Europe/Volgograd'
    europe_warsaw = 'Europe/Warsaw'
    europe_zagreb = 'Europe/Zagreb'
    europe_zaporozhye = 'Europe/Zaporozhye'
    europe_zurich = 'Europe/Zurich'
    factory = 'Factory'
    gb = 'GB'
    gb_eire = 'GB-Eire'
    gmt = 'GMT'
    gmt_0 = 'GMT+0'
    gmt_0_1 = 'GMT-0'
    gmt0 = 'GMT0'
    greenwich = 'Greenwich'
    hst = 'HST'
    hongkong = 'Hongkong'
    iceland = 'Iceland'
    indian_antananarivo = 'Indian/Antananarivo'
    indian_chagos = 'Indian/Chagos'
    indian_christmas = 'Indian/Christmas'
    indian_cocos = 'Indian/Cocos'
    indian_comoro = 'Indian/Comoro'
    indian_kerguelen = 'Indian/Kerguelen'
    indian_mahe = 'Indian/Mahe'
    indian_maldives = 'Indian/Maldives'
    indian_mauritius = 'Indian/Mauritius'
    indian_mayotte = 'Indian/Mayotte'
    indian_reunion = 'Indian/Reunion'
    iran = 'Iran'
    israel = 'Israel'
    jamaica = 'Jamaica'
    japan = 'Japan'
    kwajalein = 'Kwajalein'
    libya = 'Libya'
    met = 'MET'
    mst = 'MST'
    mst7_mdt = 'MST7MDT'
    mexico_baja_norte = 'Mexico/BajaNorte'
    mexico_baja_sur = 'Mexico/BajaSur'
    mexico_general = 'Mexico/General'
    nz = 'NZ'
    nz_chat = 'NZ-CHAT'
    navajo = 'Navajo'
    prc = 'PRC'
    pst8_pdt = 'PST8PDT'
    pacific_apia = 'Pacific/Apia'
    pacific_auckland = 'Pacific/Auckland'
    pacific_bougainville = 'Pacific/Bougainville'
    pacific_chatham = 'Pacific/Chatham'
    pacific_chuuk = 'Pacific/Chuuk'
    pacific_easter = 'Pacific/Easter'
    pacific_efate = 'Pacific/Efate'
    pacific_enderbury = 'Pacific/Enderbury'
    pacific_fakaofo = 'Pacific/Fakaofo'
    pacific_fiji = 'Pacific/Fiji'
    pacific_funafuti = 'Pacific/Funafuti'
    pacific_galapagos = 'Pacific/Galapagos'
    pacific_gambier = 'Pacific/Gambier'
    pacific_guadalcanal = 'Pacific/Guadalcanal'
    pacific_guam = 'Pacific/Guam'
    pacific_honolulu = 'Pacific/Honolulu'
    pacific_johnston = 'Pacific/Johnston'
    pacific_kanton = 'Pacific/Kanton'
    pacific_kiritimati = 'Pacific/Kiritimati'
    pacific_kosrae = 'Pacific/Kosrae'
    pacific_kwajalein = 'Pacific/Kwajalein'
    pacific_majuro = 'Pacific/Majuro'
    pacific_marquesas = 'Pacific/Marquesas'
    pacific_midway = 'Pacific/Midway'
    pacific_nauru = 'Pacific/Nauru'
    pacific_niue = 'Pacific/Niue'
    pacific_norfolk = 'Pacific/Norfolk'
    pacific_noumea = 'Pacific/Noumea'
    pacific_pago_pago = 'Pacific/Pago_Pago'
    pacific_palau = 'Pacific/Palau'
    pacific_pitcairn = 'Pacific/Pitcairn'
    pacific_pohnpei = 'Pacific/Pohnpei'
    pacific_ponape = 'Pacific/Ponape'
    pacific_port_moresby = 'Pacific/Port_Moresby'
    pacific_rarotonga = 'Pacific/Rarotonga'
    pacific_saipan = 'Pacific/Saipan'
    pacific_samoa = 'Pacific/Samoa'
    pacific_tahiti = 'Pacific/Tahiti'
    pacific_tarawa = 'Pacific/Tarawa'
    pacific_tongatapu = 'Pacific/Tongatapu'
    pacific_truk = 'Pacific/Truk'
    pacific_wake = 'Pacific/Wake'
    pacific_wallis = 'Pacific/Wallis'
    pacific_yap = 'Pacific/Yap'
    poland = 'Poland'
    portugal = 'Portugal'
    roc = 'ROC'
    rok = 'ROK'
    singapore = 'Singapore'
    turkey = 'Turkey'
    uct = 'UCT'
    us_alaska = 'US/Alaska'
    us_aleutian = 'US/Aleutian'
    us_arizona = 'US/Arizona'
    us_central = 'US/Central'
    us_east_indiana = 'US/East-Indiana'
    us_eastern = 'US/Eastern'
    us_hawaii = 'US/Hawaii'
    us_indiana_starke = 'US/Indiana-Starke'
    us_michigan = 'US/Michigan'
    us_mountain = 'US/Mountain'
    us_pacific = 'US/Pacific'
    us_samoa = 'US/Samoa'
    utc = 'UTC'
    universal = 'Universal'
    w_su = 'W-SU'
    wet = 'WET'
    zulu = 'Zulu'
    localtime = 'localtime'


class OrganizationCreateOrganizationRequestPreferences(BaseModel):
    enable_response_recommendation: Optional[bool] = Field(
        False,
        description="Whether to automatically recommend responses to the user if the user hasn't replied to the coach for a while.",
        title='Enable Response Recommendation',
    )
    preferred_language: Optional[
        OrganizationCreateAgentVersionRequestIdentityDefaultSpokenLanguage
    ] = Field(None, title='Preferred Language')
    conversations_visible_to_admins: Optional[bool] = Field(
        True,
        description="Whether the user's conversations are visible to the admins.",
        title='Conversations Visible To Admins',
    )
    user_model_visible_to_admins: Optional[bool] = Field(
        True,
        description="Whether the user's user model is visible to the admins.",
        title='User Model Visible To Admins',
    )
    timezone: Optional[OrganizationCreateOrganizationRequestPreferencesTimezone] = (
        Field(None, title='Timezone')
    )


class OrganizationCreateOrganizationRequestUserDimension(BaseModel):
    description: str = Field(..., min_length=1)
    tags: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ..., title='Tags'
    )


class OrganizationCreateOrganizationResponse(BaseModel):
    org_id: str = Field(
        ...,
        description='ID of the newly created organization. This is used to identify the organization that a resource belongs to in all Amigo endpoints.',
        title='Org Id',
    )


class OrganizationCreateServiceHierarchicalStateMachineRequest(BaseModel):
    state_machine_name: str = Field(
        ...,
        description='The name of the new state machine.',
        max_length=256,
        min_length=1,
    )


class OrganizationCreateServiceHierarchicalStateMachineResponse(BaseModel):
    id: str = Field(
        ..., description='The ID of the newly created state machine.', title='Id'
    )


class OrganizationCreateServiceHierarchicalStateMachineVersionRequestActionStateExitConditionNextState(
    AnnotationStateInputNextState
):
    pass


class OrganizationCreateServiceHierarchicalStateMachineVersionRequestActionStateExitCondition(
    BaseModel
):
    description: str = Field(..., min_length=1)
    next_state: Union[
        StateOrRefName,
        OrganizationCreateServiceHierarchicalStateMachineVersionRequestActionStateExitConditionNextState,
    ] = Field(..., title='Next State')


class OrganizationCreateServiceHierarchicalStateMachineVersionResponse(BaseModel):
    id: str = Field(
        ...,
        description='The ID of the new service hierarchical state machine version.',
        title='Id',
    )
    version: int = Field(
        ...,
        description='Numerical version ID that describes how many iterations of this service hierarchical state machine occurred before this version. Note that this is for reference only.\nAny identification of a service hierarchical state machine version in Amigo APIs use the `id` field.\n\nFor the initial version of a service hierarchical state machine, this field will be 1.',
        title='Version',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The time at which this version was created.',
        title='Created At',
    )


class OrganizationDeleteApiKeyResponse(BaseModel):
    deleted_key_id: str = Field(
        ...,
        description='ID of the successfully deleted API key.',
        title='Deleted Key Id',
    )


class OrganizationGetAgentsResponseAgentInstance(BaseModel):
    id: str = Field(..., description='The ID of the agent.', title='Id')
    name: str = Field(..., description='The name of the agent.', title='Name')
    deprecated: bool = Field(
        ..., description='Whether the agent has been deprecated.', title='Deprecated'
    )
    latest_version: Optional[int] = Field(
        ...,
        description='The latest version of the agent. If `None`, no version for the agent exists.',
        title='Latest Version',
    )


class OrganizationGetOrganizationResponse(BaseModel):
    org_id: str = Field(
        ..., description='Unique identifier of the organization.', title='Org Id'
    )
    org_name: str = Field(
        ..., description='A human friendly name of the organization.', title='Org Name'
    )
    title: str = Field(
        ...,
        description='An advertising tagline for the services offered by this organization.',
        title='Title',
    )
    main_description: str = Field(
        ...,
        description='A description of the services offered by this organization that is displayed on the login page for the Amigo frontend for this organization.',
        title='Main Description',
    )
    sub_description: str = Field(
        ...,
        description='Additional descriptions of the services offered by this organization that is displayed below `main_description` in a smaller font.',
        title='Sub Description',
    )
    onboarding_instructions: List[str] = Field(
        ...,
        description="A list of markdown text that's displayed during the onboarding flow of this organization. Each entry corresponds to a page in the onboarding flow.",
        title='Onboarding Instructions',
    )
    default_user_preferences: Optional[AmigoLibMongoCollectionsUserUserPreferences] = (
        Field(
            ...,
            description='Default user preferences for new users in this organization. This field is only populated if this endpoint is called with user authentication credentials,\nand the authenticated user has the `Organization:GetOrganizationDetails` permission.',
        )
    )


class OrganizationGetServiceHierarchicalStateMachinesResponse(BaseModel):
    service_hierarchical_state_machines: List[StateMachineInstance] = Field(
        ...,
        description='The state machines for this organization.',
        title='Service Hierarchical State Machines',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more state machines to fetch.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of state machines. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class OrganizationGetUserDimensionsResponse(BaseModel):
    user_dimensions: List[AmigoLibMongoCollectionsUserUserUserModelUserDimension] = (
        Field(
            ...,
            description='The list of user dimensions for the organization.',
            title='User Dimensions',
        )
    )


class OrganizationModifyOrganizationRequestUserDimensions(
    RootModel[List[OrganizationCreateOrganizationRequestUserDimension]]
):
    root: List[OrganizationCreateOrganizationRequestUserDimension] = Field(
        ...,
        description='User dimensions for the organization. If not set or `null`, this field is not updated.',
        min_length=1,
        title='User Dimensions',
    )


OrganizationModifyOrganizationRequestPreferences = (
    OrganizationCreateOrganizationRequestPreferences
)


class RoleAssignRoleRequest(BaseModel):
    user_id: str = Field(
        ...,
        description='The identifier of the user to assign the role to.',
        title='User Id',
    )


class RoleAssignRoleResponse(BaseModel):
    role_id: str = Field(
        ...,
        description='The identifier of the role assigned to the user.',
        title='Role Id',
    )


class RoleCreateRoleRequestInheritedFrom(RootModel[str]):
    root: str = Field(
        ...,
        description='The ID of the role that this role inherits from.',
        pattern='^[a-f0-9]{24}$',
        title='Inherited From',
    )


class RoleCreateRoleResponse(BaseModel):
    role_id: str = Field(
        ..., description='The ID of the newly created role.', title='Role Id'
    )


class RoleModifyRoleRequestInheritedFrom(RootModel[str]):
    root: str = Field(
        ...,
        description='The ID of the role that this role inherits from. Only updated if specified. This field is an immutable field.',
        pattern='^[a-f0-9]{24}$',
        title='Inherited From',
    )


class RoleModifyRoleResponse(BaseModel):
    role_id: str = Field(
        ..., description='The identifier of the updated role.', title='Role Id'
    )


class ServiceCreateServiceRequestVersionSetLLMLoadBalancingSetConfig(BaseModel):
    llm_load_balancing_set_name: LLMLoadBalancingSetType
    configs: Dict[str, PerLLMConfig] = Field(..., title='Configs')


class ServiceCreateServiceResponse(BaseModel):
    id: str = Field(..., description='The ID of the newly created service.', title='Id')


class ServiceGetServicesResponseFilterValues(BaseModel):
    tags: List[str] = Field(
        ..., description='A list of tags of the services.', title='Tags'
    )


class ServiceUpdateServiceRequestAgentId(RootModel[str]):
    root: str = Field(
        ...,
        description='The ID of the agent that this service uses. Only updated if not-null.',
        pattern='^[a-f0-9]{24}$',
        title='Agent Id',
    )


class ServiceUpdateServiceRequestServiceHierarchicalStateMachineId(RootModel[str]):
    root: str = Field(
        ...,
        description='The ID of the service hierarchical state machine that this service uses. Only updated if not-null.',
        pattern='^[a-f0-9]{24}$',
        title='Service Hierarchical State Machine Id',
    )


class ServiceUpdateServiceRequest(BaseModel):
    name: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description='The name of the service. Only updated if not-null.'
    )
    description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description='A description of this `Service`. Only updates if not-null.'
    )
    is_active: Optional[bool] = Field(
        None,
        description='The activeness of the service. Only updated if not-null.\n\nIf set to `True` and the service is currently inactive, no other service with the same name can be active.\n\nIf set to `False` and the service is currently active, it is deactivated. This will error if the service is used in a simulation unit test.',
        title='Is Active',
    )
    agent_id: Optional[ServiceUpdateServiceRequestAgentId] = Field(
        None,
        description='The ID of the agent that this service uses. Only updated if not-null.',
        title='Agent Id',
    )
    service_hierarchical_state_machine_id: Optional[
        ServiceUpdateServiceRequestServiceHierarchicalStateMachineId
    ] = Field(
        None,
        description='The ID of the service hierarchical state machine that this service uses. Only updated if not-null.',
        title='Service Hierarchical State Machine Id',
    )
    tags: Optional[Dict[str, Optional[StrippedNonemptyStringWS]]] = Field(
        None,
        description='The tags of this service. Only updated if not-null.',
        title='Tags',
    )


class ServiceUpsertServiceVersionSetRequestVersionSetLLMConfig(BaseModel):
    llm_name: LLMType
    top_p: float = Field(..., description='The preferred `top_p` value.', title='Top P')
    temperature: float = Field(
        ..., description='The preferred temperature value.', title='Temperature'
    )
    top_k: int = Field(
        ...,
        description='The preferred `top_k` value. Note that not all LLMs support this.',
        title='Top K',
    )


class SimulationCreateSimulationPersonaRequestInitialVersion(BaseModel):
    background: str = Field(
        ..., description='The background of the simulation persona.', min_length=1
    )
    preferred_language: Optional[
        Union[
            OrganizationCreateAgentVersionRequestIdentityDefaultSpokenLanguage,
            FieldNotSet,
        ]
    ] = Field(
        {},
        description='The preferred language of the simulation persona in the ISO 639-3 format. If unspecified, the preferred language of the organization is used. If that is unspecified, the language of the agent is used.',
        title='Preferred Language',
    )
    timezone: Optional[
        Union[OrganizationCreateOrganizationRequestPreferencesTimezone, FieldNotSet]
    ] = Field(
        {},
        description="The timezone of the simulation persona in the IANA tz database format. If unspecified, the organization's default timezone is used. If the organization's default timezone is not specified, UTC is used.",
        title='Timezone',
    )
    user_models: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ...,
        description='A list of strings representing the user models associated with the simulation persona.',
        title='User Models',
    )


class SimulationCreateSimulationPersonaResponse(BaseModel):
    simulation_persona_id: str = Field(
        ...,
        description='The ID of the simulation persona that was created.',
        title='Simulation Persona Id',
    )


class SimulationCreateSimulationPersonaVersionRequest(BaseModel):
    background: str = Field(
        ..., description='The background of the simulation persona.', min_length=1
    )
    preferred_language: Optional[
        Union[
            OrganizationCreateAgentVersionRequestIdentityDefaultSpokenLanguage,
            FieldNotSet,
        ]
    ] = Field(
        {},
        description='The preferred language of the simulation persona in the ISO 639-3 format. If unspecified, the preferred language of the organization is used. If that is unspecified too, the language of the agent is used.',
        title='Preferred Language',
    )
    timezone: Optional[
        Union[OrganizationCreateOrganizationRequestPreferencesTimezone, FieldNotSet]
    ] = Field(
        {},
        description="The timezone of the simulation persona in the IANA tz database format. If unspecified, the organization's default timezone is used. If the organization's default timezone is not specified, UTC is used.",
        title='Timezone',
    )
    user_models: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ...,
        description='A list of strings representing the user models associated with the simulation persona.',
        title='User Models',
    )


class SimulationCreateSimulationPersonaVersionResponse(BaseModel):
    version: int = Field(
        ...,
        description='The version number of the created simulation persona version.',
        title='Version',
    )


class SimulationCreateSimulationScenarioRequestInitialVersion(BaseModel):
    objective: str = Field(
        ..., description='The objective of the simulation scenario.', min_length=1
    )
    instructions: str = Field(
        ..., description='The instructions of the simulation scenario.', min_length=1
    )
    initial_message_type: InitialMessageType = Field(
        ..., description='The initial message type for the simulation scenario version.'
    )
    conversation_starts_at: Optional[AwareDatetime] = Field(
        ...,
        description='The time at which the conversation starts. This must be a timestamp in UTC. If not specified, the current server time is used.',
        title='Conversation Starts At',
    )


class SimulationCreateSimulationScenarioResponse(BaseModel):
    simulation_scenario_id: str = Field(
        ...,
        description='The ID of the created simulation scenario.',
        title='Simulation Scenario Id',
    )


SimulationCreateSimulationScenarioVersionRequest = (
    SimulationCreateSimulationScenarioRequestInitialVersion
)


class SimulationCreateSimulationScenarioVersionResponse(BaseModel):
    version: int = Field(
        ...,
        description='The version number of the created simulation scenario version.',
        title='Version',
    )


class SimulationCreateSimulationUnitTestResponse(BaseModel):
    simulation_unit_test_id: str = Field(
        ...,
        description='The ID of the created simulation unit test.',
        title='Simulation Unit Test Id',
    )


class SimulationCreateSimulationUnitTestSetResponse(BaseModel):
    simulation_unit_test_set_id: str = Field(
        ...,
        description='The ID of the simulation unit test set that was created.',
        title='Simulation Unit Test Set Id',
    )


class SimulationCreateSimulationUnitTestSetRunRequest(BaseModel):
    simulation_unit_test_set_id: str = Field(
        ...,
        description='The ID of the simulation unit test set to run.',
        pattern='^[a-f0-9]{24}$',
        title='Simulation Unit Test Set Id',
    )


class SimulationCreateSimulationUnitTestSetRunResponse(BaseModel):
    simulation_unit_test_set_run_id: str = Field(
        ...,
        description='The ID of the created simulation unit test set run.',
        title='Simulation Unit Test Set Run Id',
    )


class SimulationGetSimulationPersonaVersionsResponse(BaseModel):
    simulation_persona_versions: List[SimulationPersonaVersion] = Field(
        ...,
        description='The simulation persona versions of the simulation persona.',
        title='Simulation Persona Versions',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more simulation persona versions to fetch.',
        title='Has More',
    )
    continuation_token: Any = Field(
        ...,
        description='A token to supply to the next request to retreive the next page of simulation persona versions.',
        title='Continuation Token',
    )


class SimulationGetSimulationPersonasResponseFilterValues(BaseModel):
    creators: List[
        AmigoLibMongoCollectionsSimulationPersonaSimulationPersonaUserInfo
    ] = Field(
        ...,
        description='The list of users who created the simulation personas.',
        title='Creators',
    )
    tags: List[str] = Field(
        ..., description='The list of tags of the simulation personas.', title='Tags'
    )
    roles: List[str] = Field(
        ..., description='The list of roles of the simulation personas.', title='Roles'
    )


class SimulationGetSimulationScenarioVersionsResponse(BaseModel):
    simulation_scenario_versions: List[SimulationScenarioVersion] = Field(
        ...,
        description='The list of simulation scenario versions.',
        title='Simulation Scenario Versions',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more simulation scenario versions to fetch.',
        title='Has More',
    )
    continuation_token: Any = Field(
        ...,
        description='A token to supply to the next request to retreive the next page of simulation scenario versions.',
        title='Continuation Token',
    )


class SimulationGetSimulationScenariosResponseFilterValues(BaseModel):
    creators: List[
        AmigoLibMongoCollectionsSimulationScenarioSimulationScenarioUserInfo
    ] = Field(
        ...,
        description='The list of users who created the simulation scenarios.',
        title='Creators',
    )
    tags: List[str] = Field(
        ..., description='The list of tags of the simulation scenarios.', title='Tags'
    )


class SimulationGetSimulationScenariosResponseSimulationScenarioInstance(BaseModel):
    id: str = Field(..., description='The ID of the simulation scenario.', title='Id')
    name: str = Field(
        ..., description='The name of the simulation scenario.', title='Name'
    )
    tags: Dict[str, Optional[str]] = Field(
        ..., description='The tags of the simulation scenario.', title='Tags'
    )
    is_deleted: bool = Field(
        ...,
        description='Whether the simulation scenario is deleted.',
        title='Is Deleted',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The timestamp when the simulation scenario was created.',
        title='Created At',
    )
    creator: AmigoLibMongoCollectionsSimulationScenarioSimulationScenarioUserInfo = (
        Field(..., description='The user who created the simulation scenario.')
    )
    updated_at: AwareDatetime = Field(
        ...,
        description='The timestamp when the simulation scenario was last updated.',
        title='Updated At',
    )
    updated_by: AmigoLibMongoCollectionsSimulationScenarioSimulationScenarioUserInfo = (
        Field(..., description='The user who last updated the simulation scenario.')
    )


class SimulationGetSimulationUnitTestSetRunArtifactsResponse(BaseModel):
    presigned_url: str = Field(
        ...,
        description='An URL where the artifacts can be downloaded from.',
        title='Presigned Url',
    )
    url_expires_at: AwareDatetime = Field(
        ...,
        description='The time in UTC when the presigned URL expires.',
        title='Url Expires At',
    )


class SimulationGetSimulationUnitTestSetRunsResponseFilterValues(BaseModel):
    creators: List[
        AmigoLibMongoCollectionsSimulationUnitTestSetRunSimulationUnitTestSetRunUserInfo
    ] = Field(
        ...,
        description='A set of creator infos that created the simulation unit test set runs under the current filters.',
        title='Creators',
    )
    simulation_unit_test_set_ids: List[str] = Field(
        ...,
        description='A set of simulation unit test set IDs that the simulation unit test set runs belong to.',
        title='Simulation Unit Test Set Ids',
    )
    tags: List[str] = Field(
        ...,
        description='A set of tag keys that exist in the simulation unit test set runs under the current filters.',
        title='Tags',
    )


class SimulationGetSimulationUnitTestSetsResponseFilterValues(BaseModel):
    creators: List[
        AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUserInfo
    ] = Field(
        ...,
        description='A set of creator infos that created the simulation unit test sets under the current filters.',
        title='Creators',
    )
    unit_test_ids: List[str] = Field(
        ...,
        description='A set of unit test IDs that are used in the simulation unit test sets under the current filters.',
        title='Unit Test Ids',
    )
    tags: List[str] = Field(
        ...,
        description='A set of tag keys that exist in the simulation unit test sets under the current filters.',
        title='Tags',
    )


class SimulationGetSimulationUnitTestsResponseFilterValues(BaseModel):
    creators: List[
        AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestUserInfo
    ] = Field(
        ...,
        description='A set of creator infos that created the simulation unit tests under the current filters.',
        title='Creators',
    )
    tags: List[str] = Field(
        ...,
        description='A set of tag keys that exist in the simulation unit tests under the current filters.',
        title='Tags',
    )
    service_ids: List[str] = Field(
        ...,
        description='A set of service IDs that the simulation unit tests run on.',
        title='Service Ids',
    )
    persona_ids: List[str] = Field(
        ...,
        description='A set of persona IDs that the simulation unit tests use.',
        title='Persona Ids',
    )
    scenario_ids: List[str] = Field(
        ...,
        description='A set of scenario IDs that the simulation unit tests use.',
        title='Scenario Ids',
    )
    metric_ids: List[str] = Field(
        ...,
        description='A set of metric IDs that the simulation unit tests use.',
        title='Metric Ids',
    )


class SimulationSearchSimulationPersonasResponseSimulationPersonaInstance(BaseModel):
    id: str = Field(..., description='The ID of the simulation persona.', title='Id')
    name: str = Field(
        ..., description='The name of the simulation persona.', title='Name'
    )
    role: str = Field(
        ..., description='The role of the simulation persona.', title='Role'
    )
    tags: Dict[str, Optional[str]] = Field(
        ..., description='The tags of the simulation persona.', title='Tags'
    )
    is_deleted: bool = Field(
        ...,
        description='Whether the simulation persona is deleted.',
        title='Is Deleted',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The timestamp when the simulation persona was created.',
        title='Created At',
    )
    creator: AmigoLibMongoCollectionsSimulationPersonaSimulationPersonaUserInfo = Field(
        ..., description='The user who created the simulation persona.'
    )
    updated_at: AwareDatetime = Field(
        ...,
        description='The timestamp when the simulation persona was last updated.',
        title='Updated At',
    )
    updated_by: AmigoLibMongoCollectionsSimulationPersonaSimulationPersonaUserInfo = (
        Field(..., description='The user who last updated the simulation persona.')
    )


class SimulationSearchSimulationScenariosResponse(BaseModel):
    simulation_scenarios: List[
        SimulationGetSimulationScenariosResponseSimulationScenarioInstance
    ] = Field(
        ...,
        description='The list of simulation scenarios.',
        title='Simulation Scenarios',
    )


class SimulationUpdateSimulationPersonaRequest(BaseModel):
    tags: Optional[Dict[str, Optional[StrippedNonemptyStringWS]]] = Field(
        None,
        description='The tags of the simulation persona. Both the key and the value can only contain alphanumeric characters, underscores, or spaces.',
        title='Tags',
    )


SimulationUpdateSimulationScenarioRequest = SimulationUpdateSimulationPersonaRequest


class SimulationUpdateSimulationUnitTestRequestServiceId(RootModel[str]):
    root: str = Field(
        ...,
        description='The service that the unit test runs on.',
        pattern='^[a-f0-9]{24}$',
        title='Service Id',
    )


class SimulationUpdateSimulationUnitTestRequestPersonaId(RootModel[str]):
    root: str = Field(
        ...,
        description='The persona that unit test uses.',
        pattern='^[a-f0-9]{24}$',
        title='Persona Id',
    )


class SimulationUpdateSimulationUnitTestRequestScenarioId(RootModel[str]):
    root: str = Field(
        ...,
        description='The scenario that the unit test uses.',
        pattern='^[a-f0-9]{24}$',
        title='Scenario Id',
    )


class SimulationUpdateSimulationUnitTestRequestMaxInteractions(RootModel[int]):
    root: int = Field(
        ...,
        description='The max number of interactions after which the unit test fails.',
        gt=0,
        le=100,
        title='Max Interactions',
    )


class SimulationUpdateSimulationUnitTestRequestRunCount(RootModel[int]):
    root: int = Field(
        ...,
        description='Each time this unit test is run, the number of sessions to simulate.',
        gt=0,
        title='Run Count',
    )


class SimulationUpdateSimulationUnitTestSetRequestUnitTestRunDescriptor(BaseModel):
    unit_test_id: str = Field(..., pattern='^[a-f0-9]{24}$', title='Unit Test Id')
    run_count: int = Field(
        ...,
        description='The number of times to run the unit test.',
        gt=0,
        title='Run Count',
    )


class ToolCreateToolRequest(BaseModel):
    name: str = Field(
        ...,
        description='The name of the tool. It must be unique among all non-deprecated tools in the organization.',
        min_length=1,
        pattern='^[a-z0-9_]+$',
    )
    description: str = Field(
        ..., description='A description of the tool.', min_length=1
    )
    tags: Dict[str, Optional[StrippedNonemptyStringWS]] = Field(
        ..., description='The tags of this tool.', title='Tags'
    )


class ToolCreateToolResponse(BaseModel):
    id: str = Field(..., description='The ID of the tool.', title='Id')


class ToolGetToolVersionsResponseFilterValues(BaseModel):
    creators: List[AmigoLibMongoCollectionsToolVersionToolVersionUserInfo] = Field(
        ...,
        description='The list of users who created the simulation personas.',
        title='Creators',
    )


class ToolGetToolsResponseFilterValues(BaseModel):
    tags: List[str] = Field(
        ..., description='A list of tags of the tools.', title='Tags'
    )


class ToolInvokeToolVersionRequestInputInvocationMode(Enum):
    regular = 'regular'
    conversation_simulation = 'conversation-simulation'


class ToolInvokeToolVersionRequestInput(BaseModel):
    input_parameters: Dict[str, Any] = Field(
        ...,
        description='The input parameters for the tool invocation.',
        title='Input Parameters',
    )
    invocation_mode: ToolInvokeToolVersionRequestInputInvocationMode = Field(
        ..., description='The mode of invocation.', title='Invocation Mode'
    )


class ToolModifyToolRequest(BaseModel):
    description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description='A description of this tool. Only updates if not-null.'
    )
    tags: Optional[Dict[str, Optional[StrippedNonemptyStringWS]]] = Field(
        None,
        description='The tags of this tool. Only updates if not-null.',
        title='Tags',
    )


class ToolPublishToolVersionRequestBumpType(Enum):
    major = 'major'
    minor = 'minor'
    patch = 'patch'


class ToolPublishToolVersionRequest(BaseModel):
    repo: ToolVersionInstanceToolRepo = Field(
        ...,
        description="The repo to publish the tool version from. If `team`, then it's published from the repo of the organization's Azure DevOps team. If `main`, then it's published\nfrom the `tools-main` repo.",
        title='Repo',
    )
    project_path: str = Field(
        ...,
        description='The directory in the tools repo that contains the `pyproject.toml` file corresponding to the tool version to publish.',
        pattern='^[-\\w\\d_/]+$',
        title='Project Path',
    )
    bump_type: ToolPublishToolVersionRequestBumpType = Field(
        ...,
        description='The type of bump to apply to the version. For initial version of the tool, use `major`.',
        title='Bump Type',
    )


class ToolPublishToolVersionResponse(BaseModel):
    new_version: str = Field(
        ..., description='The new version of the tool.', title='New Version'
    )


class ToolTestToolRequest(BaseModel):
    inputs: List[ToolInvokeToolVersionRequestInput] = Field(
        ...,
        description='The list of inputs for the tool invocation.',
        max_length=10,
        min_length=1,
        title='Inputs',
    )
    commit_branch: str = Field(
        ...,
        description='The branch in the tools repo whose tip will be tested.',
        title='Commit Branch',
    )
    project_path: str = Field(
        ...,
        description='The directory in the tools repo that contains the `pyproject.toml` file corresponding to the tool version to publish.',
        pattern='^[-\\w\\d_/]+$',
        title='Project Path',
    )
    required_envvars: Dict[str, str] = Field(
        ...,
        description='The environment variables required for the tool to run.',
        title='Required Envvars',
    )
    required_secret_envvars: Dict[str, str] = Field(
        ...,
        description='The secret environment variables required for the tool to run.',
        title='Required Secret Envvars',
    )


class UserCreateInvitedUserRequestLoginLink(RootModel[AnyUrl]):
    root: AnyUrl = Field(
        ...,
        description="If specified, this link will be sent to the user's email as the link to start their Amigo experience. For Amigo's frontend, this would be the user's\norganization's login page with their email already filled in.",
        title='Login Link',
    )


class user__create_invited_user__Request__Preferences_preferred_language(
    RootModel[str]
):
    root: str = Field(..., pattern='^\\w{2}$', title='Preferred Language')


class UserCreateInvitedUserRequestPreferences(BaseModel):
    enable_response_recommendation: Optional[bool] = Field(
        False,
        description="Whether to automatically recommend responses to the user if the user hasn't replied to the coach for a while.",
        title='Enable Response Recommendation',
    )
    preferred_language: Optional[
        Union[
            OrganizationCreateAgentVersionRequestIdentityDefaultSpokenLanguage,
            user__create_invited_user__Request__Preferences_preferred_language,
        ]
    ] = Field(None, title='Preferred Language')
    conversations_visible_to_admins: Optional[bool] = Field(
        True,
        description="Whether the user's conversations are visible to the admins.",
        title='Conversations Visible To Admins',
    )
    user_model_visible_to_admins: Optional[bool] = Field(
        True,
        description="Whether the user's user model is visible to the admins.",
        title='User Model Visible To Admins',
    )
    timezone: Optional[OrganizationCreateOrganizationRequestPreferencesTimezone] = (
        Field(None, title='Timezone')
    )


class UserCreateInvitedUserResponse(BaseModel):
    user_id: str = Field(
        ..., description='The identifier of the new user.', title='User Id'
    )
    verify_link: Optional[str] = Field(
        ...,
        description='The link sent to the user. Only present if `login_link` is `True` in the request.',
        title='Verify Link',
    )


class UserGetMemoriesResponse(BaseModel):
    memories: List[MemoryInstance] = Field(
        ..., description='The memories satisfying the filters.', title='Memories'
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more memories to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of memories. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class UserGetUsersResponseUserInstanceUserStats(BaseModel):
    num_conversations: int = Field(
        ...,
        description='The number of conversations the user has created.',
        title='Num Conversations',
    )
    num_messages: int = Field(
        ...,
        description='The number of messages the user has sent and received.',
        title='Num Messages',
    )
    last_message_time: Optional[AwareDatetime] = Field(
        ...,
        description="The time of the last message the user sent or received. If `None`, the user hasn't started any conversations.",
        title='Last Message Time',
    )


class UserSearchUsersResponseUserInstance(BaseModel):
    org_id: str = Field(
        ...,
        description='The ID of the organization that this user belongs to.',
        title='Org Id',
    )
    user_id: str = Field(
        ..., description='The identifier of the user.', title='User Id'
    )
    first_name: str = Field(
        ..., description='The first name of the user.', title='First Name'
    )
    last_name: str = Field(
        ..., description='The last name of the user.', title='Last Name'
    )
    email: str = Field(..., description='Email of the user.', title='Email')
    user_stats: UserGetUsersResponseUserInstanceUserStats = Field(
        ..., description="Statistics about the user's usage of the Amigo platform."
    )
    role: str = Field(..., description='The ID of the role of the user.', title='Role')
    preferences: AmigoLibMongoCollectionsUserUserPreferences = Field(
        ..., description='The preferences of the user.'
    )


class UserSignInWithApiKeyResponse(BaseModel):
    id_token: str = Field(
        ...,
        description='The ID token that should be attached to the Authorization header for future API calls.',
        title='Id Token',
    )
    expires_at: AwareDatetime = Field(
        ..., description='The time at which the token expires.', title='Expires At'
    )


class UserSignInWithEmailRequest(BaseModel):
    redirect_link: AnyUrl = Field(
        ...,
        description='An Amigo platform link that the user gets redirected to after clicking the login link.',
        title='Redirect Link',
    )
    email: EmailStr = Field(
        ...,
        description='Email of the user. This must correspond to an existing, verified user in the Amigo platform.',
        title='Email',
    )


class UserSignInWithEmailResponse(BaseModel):
    user_id: str = Field(
        ...,
        description='The identifier of the user corresponding to the email.',
        title='User Id',
    )


class UserUpdateUserInfoRequest(BaseModel):
    first_name: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None,
        description='The first name of the user to update. If `null`, the first name is not modified.',
    )
    last_name: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None,
        description='The last name of the user to update. If `null`, the last name is not modified.',
    )
    enable_response_recommendation: Optional[bool] = Field(
        None,
        description="Whether to automatically recommend responses to the user if the user hasn't replied to the coach for a while. If `null`, the preference is not modified.",
        title='Enable Response Recommendation',
    )
    preferred_language: Optional[
        Union[
            OrganizationCreateAgentVersionRequestIdentityDefaultSpokenLanguage,
            FieldNotSet,
        ]
    ] = Field(
        {},
        description="The preferred language for the user. The agent will attempt to converse to the user in this language if set. This field must be in the [ISO 639-3](https://en.wikipedia.org/wiki/ISO_639-3) format.\nIf `null`, erase the user's preferred setting, and the specific language used will be the agent's default spoken language. In order to not update this field, leave it out of the request or\nset it to an empty object (`_NotSet`).",
        title='Preferred Language',
    )
    timezone: Optional[
        Union[OrganizationCreateOrganizationRequestPreferencesTimezone, FieldNotSet]
    ] = Field(
        {},
        description="The user's timezone in the IANA tz database format. If not specified, the organization's timezone is used.",
        title='Timezone',
    )
    conversations_visible_to_admins: Optional[bool] = Field(
        None,
        description='Whether conversations are visible to the admins. If `null`, the preference is not modified.',
        title='Conversations Visible To Admins',
    )
    user_model_visible_to_admins: Optional[bool] = Field(
        None,
        description="Whether the user's user model is visible to the admins. If `null`, the preference is not modified.",
        title='User Model Visible To Admins',
    )
    additional_context: Optional[
        List[AmigoLibPydanticBaseModelStrippedNonemptyString1]
    ] = Field(
        None,
        description='A list of additional context to update. If `null`, the context is not modified.',
        title='Additional Context',
    )


class WebhookDestinationCreateWebhookDestinationRequest(BaseModel):
    url: AnyUrl = Field(
        ...,
        description='The URL to which the webhook will be sent. The URL must be in HTTPS.',
        title='Url',
    )
    accepted_types: List[Literal['conversation-post-processing-complete']] = Field(
        ..., description='A list of webhook types to receive.', title='Accepted Types'
    )
    retry_attempts: Optional[int] = Field(
        3,
        description='The number of attempts to retry sending the webhook event in case of failure.',
        gt=0,
        le=5,
        title='Retry Attempts',
    )


class WebhookDestinationCreateWebhookDestinationResponse(BaseModel):
    webhook_destination_id: str = Field(
        ...,
        description='The ID of the created webhook destination.',
        title='Webhook Destination Id',
    )
    secret: str = Field(
        ...,
        description='The secret used to sign the webhook event. This is only visible once and cannot be retrieved later.',
        title='Secret',
    )


class WebhookDestinationGetWebhookDestinationsResponse(BaseModel):
    webhook_destinations: List[WebhookDestination] = Field(
        ...,
        description='The retrieved webhook destinations.',
        title='Webhook Destinations',
    )


class WebhookDestinationRotateWebhookDestinationSecretResponse(BaseModel):
    secret: str = Field(
        ...,
        description='The new secret used to sign the webhook event. This is only visible once and cannot be retrieved later. For the next 30 minutes, the webhook will be signed by both\nthe old and the new secret.',
        title='Secret',
    )
    dual_signing_stops_at: AwareDatetime = Field(
        ...,
        description='A UTC time where the dual-signing behavior stops. After this time, webhooks will only be signed using the new secret from this endpoint.',
        title='Dual Signing Stops At',
    )


class WebhookDestinationUpdateWebhookDestinationRequestRetryAttempts(RootModel[int]):
    root: int = Field(
        ...,
        description='The number of attempts to retry sending the webhook event in case of failure. If not specified, this field is not updated.',
        gt=0,
        le=5,
        title='Retry Attempts',
    )


class WebhookDestinationUpdateWebhookDestinationRequest(BaseModel):
    retry_attempts: Optional[
        WebhookDestinationUpdateWebhookDestinationRequestRetryAttempts
    ] = Field(
        None,
        description='The number of attempts to retry sending the webhook event in case of failure. If not specified, this field is not updated.',
        title='Retry Attempts',
    )
    accepted_types: Optional[List[Literal['conversation-post-processing-complete']]] = (
        Field(
            None,
            description='A list of webhook types to receive. If not specified, this field is not updated.',
            title='Accepted Types',
        )
    )


class GetAgentsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetAgentsParametersQuery(BaseModel):
    deprecated: Optional[bool] = Field(
        None, description='Whether the agent is deprecated.', title='Deprecated'
    )
    id: Optional[List[GetAgentsParametersQueryIdItem]] = Field(
        [], description='The IDs of the agents to filter for.', title='Id'
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of agents to return.',
        gt=0,
        le=20,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of agents.',
        title='Continuation Token',
    )


class CreateAgentVersionParametersQueryVersion(RootModel[int]):
    root: int = Field(
        ...,
        description="The version number of the new agent version. If specified, this endpoint throws an error if the next version of the agent in the database doesn't equal to the value of this parameter.",
        gt=0,
        title='Version',
    )


class CreateAgentVersionParametersQuery(BaseModel):
    version: Optional[CreateAgentVersionParametersQueryVersion] = Field(
        None,
        description="The version number of the new agent version. If specified, this endpoint throws an error if the next version of the agent in the database doesn't equal to the value of this parameter.",
        title='Version',
    )


class GetServiceHierarchicalStateMachinesParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetServiceHierarchicalStateMachinesParametersQuery(BaseModel):
    deprecated: Optional[bool] = Field(
        None, description='Whether the state machine is deprecated.', title='Deprecated'
    )
    id: Optional[List[GetServiceHierarchicalStateMachinesParametersQueryIdItem]] = (
        Field(
            [], description='The IDs of the state machines to filter for.', title='Id'
        )
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of service hierarchical state machines to return.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of state machines.',
        title='Continuation Token',
    )


class CreateServiceHierarchicalStateMachineVersionParametersQueryVersion(
    RootModel[int]
):
    root: int = Field(
        ...,
        description="The version number of the new state machine version. If specified, this endpoint throws an error if the next version of the state machine in the database doesn't equal to the value of this parameter.",
        gt=0,
        title='Version',
    )


class CreateServiceHierarchicalStateMachineVersionParametersQuery(BaseModel):
    version: Optional[
        CreateServiceHierarchicalStateMachineVersionParametersQueryVersion
    ] = Field(
        None,
        description="The version number of the new state machine version. If specified, this endpoint throws an error if the next version of the state machine in the database doesn't equal to the value of this parameter.",
        title='Version',
    )
    dry_run: Optional[bool] = Field(
        False,
        description='Whether to perform a dry run of the operation.',
        title='Dry Run',
    )


class CreateServiceHierarchicalStateMachineVersionResponse(
    RootModel[
        Optional[OrganizationCreateServiceHierarchicalStateMachineVersionResponse]
    ]
):
    root: Optional[OrganizationCreateServiceHierarchicalStateMachineVersionResponse] = (
        Field(..., title='Response Create-Service-Hierarchical-State-Machine-Version')
    )


class GetAgentVersionsParametersQuery(BaseModel):
    version: Optional[str] = Field(
        None,
        description='The versions of the agent to retrieve. One can specify an exact version to retrieve, which is either the version number or `latest`, which retrieves the latest version. Alternatively, one can specify a range of inclusive lower and upper bound for the version number separated by `-`, and every version within the range would be retrieved.',
        examples=['1', '1-latest', '2-5', 'latest'],
        title='Version',
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of agent versions to return.',
        gt=0,
        le=10,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of agent version.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `version`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetServiceHierarchicalStateMachineVersionsParametersQuery(BaseModel):
    version: Optional[str] = Field(
        None,
        description='The versions of the state machine to retrieve. One can specify an exact version to retrieve, which is either the version number or `latest`, which retrieves the latest version. Alternatively, one can specify a range of inclusive lower and upper bound for the version number separated by `-`, and every version within the range would be retrieved.',
        examples=['1', '1-latest', '2-5', 'latest'],
        title='Version',
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of state machine versions to return.',
        gt=0,
        le=10,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of state machine versions.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `version`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetServicesParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetServicesParametersQuery(BaseModel):
    id: Optional[List[GetServicesParametersQueryIdItem]] = Field(
        [], description='The IDs of the services to retrieve.', title='Id'
    )
    is_active: Optional[bool] = Field(
        None, description='Whether the service is active.', title='Is Active'
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the services by. Supported fields are `name` and `is_active`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )
    tags: Optional[List[str]] = Field(
        [],
        description='The tags to filter the services by. Must be specified using the syntax `key:value`, which means to match all services with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tags',
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of services to return.',
        gt=0,
        le=20,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of services.',
        title='Continuation Token',
    )


class CreateConversationParametersQueryAudioFormat(Enum):
    mp3 = 'mp3'
    pcm = 'pcm'


class CreateConversationParametersQuery(BaseModel):
    response_format: Format = Field(
        ...,
        description='The format of the response that will be sent to the user.',
        title='Response Format',
    )
    current_agent_action_type: Optional[str] = Field(
        '^.*$',
        description="A regex for filtering the type of the current agent action to return. By default, all are returned. If you don't want to receive any events, set this to a regex that matches nothing, for instance `^$`.",
        title='Current Agent Action Type',
    )
    audio_format: Optional[CreateConversationParametersQueryAudioFormat] = Field(
        None,
        description='The format of the audio response, if `response_format` is set to `voice`.',
        title='Audio Format',
    )


class GetConversationsParametersQueryServiceIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetConversationsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetConversationsParametersQuery(BaseModel):
    user_id: Optional[List[str]] = Field(
        [],
        description='The identifier of the user whose conversations to retrieve.',
        title='User Id',
    )
    service_id: Optional[List[GetConversationsParametersQueryServiceIdItem]] = Field(
        [],
        description='The identifier of the service whose conversation to retrieve.',
        title='Service Id',
    )
    is_finished: Optional[bool] = Field(
        None, description='Whether the conversation is finished.', title='Is Finished'
    )
    id: Optional[List[GetConversationsParametersQueryIdItem]] = Field(
        [], description='The ID of the conversation to retrieve.', title='Id'
    )
    limit: Optional[int] = Field(
        150,
        description='The maximum number of conversations to retrieve.',
        gt=0,
        le=150,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token returned from the previous response to retrieve the next set of conversations.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The field to sort the conversations by. Supported fields are `created_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetConversationMessagesParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetConversationMessagesParametersQueryInteractionIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetConversationMessagesParametersQuery(BaseModel):
    id: Optional[List[GetConversationMessagesParametersQueryIdItem]] = Field(
        [], description='The IDs of the messages to retrieve.', title='Id'
    )
    message_type: Optional[List[MessageType]] = Field(
        ['external-event', 'agent-message', 'user-message'],
        description='The type of messages to retrieve.',
        title='Message Type',
    )
    interaction_id: Optional[
        List[GetConversationMessagesParametersQueryInteractionIdItem]
    ] = Field(
        [],
        description='The IDs of the interactions to retrieve messages for.',
        title='Interaction Id',
    )
    limit: Optional[int] = Field(
        500,
        description='The maximum number of messages to return. At most 500 messages can be returned in one request.',
        gt=0,
        le=500,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token to use to retrieve the next set of messages.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The field to sort the messages by. Supported fields are `interaction_id` and `created_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class InteractWithConversationParametersQuery(BaseModel):
    request_format: Format = Field(
        ...,
        description='The format in which the user message is delivered to the server.',
        title='Request Format',
    )
    response_format: Format = Field(
        ...,
        description='The format of the response that will be sent to the user.',
        title='Response Format',
    )
    current_agent_action_type: Optional[str] = Field(
        '^.*$',
        description="A regex for filtering the type of the current agent action to return. By default, all are returned. If you don't want to receive any events, set this to a regex that matches nothing, for instance `^$`.",
        title='Current Agent Action Type',
    )
    request_audio_config: Optional[
        Union[MP3UserMessageAudioConfig, PCMUserMessageAudioConfig]
    ] = Field(
        None,
        description='Configuration for the user message audio. This is only required if `request_format` is set to `voice`.',
        title='Request Audio Config',
    )
    audio_format: Optional[CreateConversationParametersQueryAudioFormat] = Field(
        None,
        description='The format of the audio response, if `response_format` is set to `voice`.',
        title='Audio Format',
    )


class RetrieveMessageSourceParametersQuery(BaseModel):
    long_lived: Optional[bool] = Field(
        False,
        description="Whether to generate a long-lived URL which lasts 12 hours. For security purposes, it's recommended to set this to false as much as possible.",
        title='Long Lived',
    )


class GetUsersParametersQuery(BaseModel):
    user_id: Optional[List[str]] = Field(
        [], description='The ID of the user.', title='User Id'
    )
    email: Optional[List[EmailStr]] = Field(
        [], description='The email of the user.', title='Email'
    )
    limit: Optional[int] = Field(
        100,
        description='The maximum number of users to retrieve.',
        ge=0,
        le=100,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The token from the previous request to return the next page of users.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `first_name`, `last_name`, `email`, `user_stats.num_conversations`, `user_stats.num_messages`, and `user_stats.last_message_time`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetMemoriesParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetMemoriesParametersQueryConversationIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetMemoriesParametersQuery(BaseModel):
    id: Optional[List[GetMemoriesParametersQueryIdItem]] = Field(
        [], description='The IDs of the memories to retrieve.', title='Id'
    )
    conversation_id: Optional[List[GetMemoriesParametersQueryConversationIdItem]] = (
        Field(
            [],
            description='The IDs of the conversations to retrieve memories from.',
            title='Conversation Id',
        )
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of memories to retrieve.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The token from the previous request to return the next page of memories.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `conversation_id` and `created_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class SearchUsersParametersQuery(BaseModel):
    query: str = Field(
        ...,
        description='The search query. Any users whose name or email contains the query are returned.',
        title='Query',
    )


class GetRolesV1OrganizationRoleGetParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetRolesV1OrganizationRoleGetParametersQuery(BaseModel):
    return_permission_grants: Optional[bool] = Field(
        False,
        description='Whether to return permission grants.',
        title='Return Permission Grants',
    )
    id: Optional[List[GetRolesV1OrganizationRoleGetParametersQueryIdItem]] = Field(
        [], description='The IDs of the roles to retrieve.', title='Id'
    )
    name: Optional[List[str]] = Field(
        [], description='The names of the roles to retrieve.', title='Name'
    )


class GetPromptLogsParametersQuery(BaseModel):
    prompt_log_prefix: str = Field(
        ...,
        description='The prefix of the prompt log to retrieve.',
        title='Prompt Log Prefix',
    )


class GetWebhookDestinationsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetWebhookDestinationsParametersQuery(BaseModel):
    id: Optional[List[GetWebhookDestinationsParametersQueryIdItem]] = Field(
        [], description='The IDs of the webhook destinations to retrieve.', title='Id'
    )


class GetWebhookDeliveriesParametersQuery(BaseModel):
    status: Optional[WebhookDeliveryStatus] = Field(
        None, description='The status of the webhook delivery.', title='Status'
    )
    type: Optional[str] = Field(
        None, description='The type of the webhook.', title='Type'
    )
    created_after: Optional[AwareDatetime] = Field(
        None,
        description='An ISO8601 timestamp in UTC of the earliest creation time of the webhook deliveries to retrieve.',
        title='Created After',
    )
    created_before: Optional[AwareDatetime] = Field(
        None,
        description='An ISO8601 timestamp in UTC of the latest creation time of the webhook deliveries to retrieve.',
        title='Created Before',
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of webhook deliveries to retrieve.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The token from the previous request to return the next page of webhook deliveries.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `type`, `status`, and `created_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetDynamicBehaviorSetsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetDynamicBehaviorSetsParametersQueryAppliedToServiceItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetDynamicBehaviorSetsParametersQuery(BaseModel):
    id: Optional[List[GetDynamicBehaviorSetsParametersQueryIdItem]] = Field(
        [], description='The IDs of the dynamic behavior sets to retrieve.', title='Id'
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of dynamic behavior sets to return.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token to use to retrieve the next set of dynamic behavior sets.',
        title='Continuation Token',
    )
    is_active: Optional[bool] = Field(
        None,
        description='Whether the dynamic behavior set is active.',
        title='Is Active',
    )
    applied_to_service: Optional[
        List[GetDynamicBehaviorSetsParametersQueryAppliedToServiceItem]
    ] = Field(
        [],
        description='The IDs of the services that the dynamic behavior set is applied to.',
        title='Applied To Service',
    )
    creator: Optional[List[str]] = Field(
        [], description='The creators of the dynamic behavior sets.', title='Creator'
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the dynamic behavior sets. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `updated_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class CreateDynamicBehaviorSetVersionParametersQueryVersion(RootModel[int]):
    root: int = Field(
        ...,
        description="The version number of the new version. If specified, this endpoint throws an error if the next version in the database doesn't equal to the value of this parameter.",
        gt=1,
        title='Version',
    )


class CreateDynamicBehaviorSetVersionParametersQuery(BaseModel):
    version: Optional[CreateDynamicBehaviorSetVersionParametersQueryVersion] = Field(
        None,
        description="The version number of the new version. If specified, this endpoint throws an error if the next version in the database doesn't equal to the value of this parameter.",
        title='Version',
    )


class GetDynamicBehaviorSetVersionsParametersQuery(BaseModel):
    version: Optional[str] = Field(
        None,
        description='The versions of the dynamic behavior set to retrieve. One can specify an exact version to retrieve, which is either the version number or `latest`,\nwhich retrieves the latest version. Alternatively, one can specify a range of inclusive lower and upper bound for the version number separated by `-`,\nand every version within the range would be retrieved.',
        examples=['1', '1-latest', '2-5', 'latest'],
        title='Version',
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of dynamic behavior set versions to return.',
        gt=0,
        le=10,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of dynamic behavior set versions.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `version`. Specify a `+` before the field name to indicate ascending sorting and `-`\nfor descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class SearchDynamicBehaviorSetsParametersQueryAppliedToServiceItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchDynamicBehaviorSetsParametersQuery(BaseModel):
    query: str = Field(
        ...,
        description='The query to search for. Any sets containing the terms in its name and the triggers of its latest version would be returned.',
        min_length=1,
    )
    is_active: Optional[bool] = Field(
        None,
        description='Whether the dynamic behavior set is active.',
        title='Is Active',
    )
    applied_to_service: Optional[
        List[SearchDynamicBehaviorSetsParametersQueryAppliedToServiceItem]
    ] = Field(
        [],
        description='The IDs of the services that the dynamic behavior set is applied to.',
        title='Applied To Service',
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the dynamic behavior sets. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the dynamic behavior sets. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags.\nIf `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )


class GetDynamicBehaviorInvocationsParametersQuery(BaseModel):
    limit: Optional[int] = Field(
        30,
        description='The maximum number of dynamic behavior invocations to return.',
        gt=0,
        le=30,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of dynamic behavior invocations.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `invoked_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetMetricsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetMetricsParametersQueryAppliedToServiceItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetMetricsParametersQuery(BaseModel):
    id: Optional[List[GetMetricsParametersQueryIdItem]] = Field(
        [], description='The IDs of the metrics to retrieve.', title='Id'
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of metrics to return.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of metrics.',
        title='Continuation Token',
    )
    applied_to_service: Optional[
        List[GetMetricsParametersQueryAppliedToServiceItem]
    ] = Field(
        [],
        description='The IDs of the services that the metric is applied to.',
        title='Applied To Service',
    )
    type: Optional[List[MetricValueType]] = Field(
        [], description='The types of the metrics.', title='Type'
    )
    is_deleted: Optional[bool] = Field(
        False, description='Whether the metric is deleted.', title='Is Deleted'
    )
    creator: Optional[List[str]] = Field(
        [], description='The creators of the dynamic behavior sets.', title='Creator'
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the dynamic behavior sets. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `updated_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class SearchMetricsParametersQueryAppliedToServiceItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchMetricsParametersQuery(BaseModel):
    query: str = Field(
        ...,
        description='The query to search for. Any metrics containing the terms in its name and description would be returned.',
        min_length=1,
    )
    applied_to_service: Optional[
        List[SearchMetricsParametersQueryAppliedToServiceItem]
    ] = Field(
        [],
        description='The IDs of the services that the metric is applied to.',
        title='Applied To Service',
    )
    type: Optional[List[MetricValueType]] = Field(
        [], description='The types of the metrics.', title='Type'
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the metrics. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the metrics. Must be specified using the syntax `key:value`, which means to match all metrics with the given `key` and `value` pair among its tags.\nIf `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )


class GetMetricEvaluationResultsParametersQueryMetricIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetMetricEvaluationResultsParametersQueryConversationIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetMetricEvaluationResultsParametersQuerySimulationUnitTestSetRunIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetMetricEvaluationResultsParametersQuery(BaseModel):
    limit: Optional[int] = Field(
        500,
        description='The maximum number of metrics to return.',
        ge=0,
        le=500,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of metrics.',
        title='Continuation Token',
    )
    timestamp_after: Optional[AwareDatetime] = Field(
        None,
        description='An ISO8601 timestamp. Only results evaluated on or after this moment is returned.',
        title='Timestamp After',
    )
    timestamp_before: Optional[AwareDatetime] = Field(
        None,
        description='An ISO8601 timestamp. Only results evaluated on or before this moment is returned.',
        title='Timestamp Before',
    )
    metric_id: Optional[List[GetMetricEvaluationResultsParametersQueryMetricIdItem]] = (
        Field([], description='The ID of the metric to retrieve.', title='Metric Id')
    )
    source_type: Optional[List[EvaluationSourceType]] = Field(
        [],
        description='The type of the source of the metric evaluation results.',
        title='Source Type',
    )
    conversation_id: Optional[
        List[GetMetricEvaluationResultsParametersQueryConversationIdItem]
    ] = Field(
        [],
        description='For metric evaluation sources with type `post-session` or `manual`, this field filters the metric evaluation results to only include those that were computed from the given conversation IDs.',
        title='Conversation Id',
    )
    simulation_unit_test_set_run_id: Optional[
        List[GetMetricEvaluationResultsParametersQuerySimulationUnitTestSetRunIdItem]
    ] = Field(
        [],
        description='For metric evaluation sources with type `simulation`, this field filters the metric evaluation results to only include those that were computed from the given simulation unit test set run IDs.',
        title='Simulation Unit Test Set Run Id',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the metrics by. Supported fields are `created_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. \nMultiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetSimulationPersonasParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationPersonasParametersQuery(BaseModel):
    id: Optional[List[GetSimulationPersonasParametersQueryIdItem]] = Field(
        [], description='The IDs of the simulation personas to retrieve.', title='Id'
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of simulation personas to return.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of simulation personas.',
        title='Continuation Token',
    )
    is_deleted: Optional[bool] = Field(
        None,
        description='Whether the simulation persona is deleted.',
        title='Is Deleted',
    )
    role: Optional[List[str]] = Field(
        [], description='The roles of the simulation personas.', title='Role'
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation personas to retrieve. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation personas to retrieve. Each value must be of the format `key:value`. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `updated_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class CreateSimulationPersonaVersionParametersQueryVersion(
    CreateDynamicBehaviorSetVersionParametersQueryVersion
):
    pass


class CreateSimulationPersonaVersionParametersQuery(BaseModel):
    version: Optional[CreateSimulationPersonaVersionParametersQueryVersion] = Field(
        None,
        description="The version number of the new version. If specified, this endpoint throws an error if the next version in the database doesn't equal to the value of this parameter.",
        title='Version',
    )


class GetSimulationPersonaVersionsParametersQuery(BaseModel):
    version: Optional[str] = Field(
        None,
        description='The versions of the simulation persona to retrieve. One can specify an exact version to retrieve, which is either the version number or `latest`, which retrieves the latest version. Alternatively, one can specify a range of inclusive lower and upper bound for the version number separated by `-`, and every version within the range would be retrieved.',
        examples=['1', '1-latest', '2-5', 'latest'],
        title='Version',
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of simulation persona versions to return.',
        gt=0,
        le=10,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of simulation persona versions.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `version`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class GetSimulationScenarioVersionsParametersQuery(BaseModel):
    version: Optional[str] = Field(
        None,
        description='The versions of the simulation scenario to retrieve. One can specify an exact version to retrieve, which is either the version number or `latest`, which retrieves the latest version. Alternatively, one can specify a range of inclusive lower and upper bound for the version number separated by `-`, and every version within the range would be retrieved.',
        examples=['1', '1-latest', '2-5', 'latest'],
        title='Version',
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of simulation scenario versions to return.',
        gt=0,
        le=10,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of simulation scenario version.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `version`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class CreateSimulationScenarioVersionParametersQueryVersion(
    CreateDynamicBehaviorSetVersionParametersQueryVersion
):
    pass


class CreateSimulationScenarioVersionParametersQuery(BaseModel):
    version: Optional[CreateSimulationScenarioVersionParametersQueryVersion] = Field(
        None,
        description="The version number of the new version. If specified, this endpoint throws an error if the next version in the database doesn't equal to the value of this parameter.",
        title='Version',
    )


class GetSimulationScenariosParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationScenariosParametersQuery(BaseModel):
    id: Optional[List[GetSimulationScenariosParametersQueryIdItem]] = Field(
        [], description='The IDs of the simulation scenarios to retrieve.', title='Id'
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of simulation scenarios to return.',
        ge=0,
        le=200,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of simulation scenarios.',
        title='Continuation Token',
    )
    is_deleted: Optional[bool] = Field(
        None,
        description='Whether the simulation scenario is deleted.',
        title='Is Deleted',
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation scenarios. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation scenarios. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means to match any value. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `updated_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class SearchSimulationPersonasParametersQuery(BaseModel):
    query: str = Field(
        ...,
        description='The query to search for. Any simulation personas containing the terms in its name and the background of its latest version would be returned.',
        min_length=1,
    )
    role: Optional[List[str]] = Field(
        [], description='The roles of the simulation personas.', title='Role'
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation personas. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation personas. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )


class SearchSimulationScenariosParametersQuery(BaseModel):
    query: str = Field(
        ...,
        description='The query to search for. Any simulation scenarios containing the terms in its name would be returned.',
        min_length=1,
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation scenarios. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation scenarios. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )


class GetSimulationUnitTestsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestsParametersQueryServiceIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestsParametersQueryPersonaIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestsParametersQueryScenarioIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestsParametersQueryMetricIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestsParametersQuery(BaseModel):
    id: Optional[List[GetSimulationUnitTestsParametersQueryIdItem]] = Field(
        [], description='The IDs of the simulation unit tests to retrieve.', title='Id'
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of simulation unit tests to return.',
        ge=0,
        le=500,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of simulation unit tests.',
        title='Continuation Token',
    )
    is_deleted: Optional[bool] = Field(
        None,
        description='Whether the simulation unit test is deleted.',
        title='Is Deleted',
    )
    service_id: Optional[List[GetSimulationUnitTestsParametersQueryServiceIdItem]] = (
        Field(
            [],
            description='The IDs of the services that the simulation unit tests run on.',
            title='Service Id',
        )
    )
    persona_id: Optional[List[GetSimulationUnitTestsParametersQueryPersonaIdItem]] = (
        Field(
            [],
            description='The IDs of the personas that the simulation unit tests use.',
            title='Persona Id',
        )
    )
    scenario_id: Optional[List[GetSimulationUnitTestsParametersQueryScenarioIdItem]] = (
        Field(
            [],
            description='The IDs of the scenarios that the simulation unit tests use.',
            title='Scenario Id',
        )
    )
    metric_id: Optional[List[GetSimulationUnitTestsParametersQueryMetricIdItem]] = (
        Field(
            [],
            description='The IDs of the metrics that the simulation unit tests use.',
            title='Metric Id',
        )
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation unit tests. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation unit tests. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `updated_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class SearchSimulationUnitTestsParametersQueryServiceIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchSimulationUnitTestsParametersQueryPersonaIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchSimulationUnitTestsParametersQueryScenarioIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchSimulationUnitTestsParametersQueryMetricIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchSimulationUnitTestsParametersQuery(BaseModel):
    query: str = Field(
        ...,
        description='The query to search for. Any simulation unit tests containing the terms in its name would be returned.',
        min_length=1,
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation unit tests. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation unit tests. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    service_id: Optional[
        List[SearchSimulationUnitTestsParametersQueryServiceIdItem]
    ] = Field(
        [],
        description='The IDs of the services that the simulation unit tests run on.',
        title='Service Id',
    )
    persona_id: Optional[
        List[SearchSimulationUnitTestsParametersQueryPersonaIdItem]
    ] = Field(
        [],
        description='The IDs of the personas that the simulation unit tests use.',
        title='Persona Id',
    )
    scenario_id: Optional[
        List[SearchSimulationUnitTestsParametersQueryScenarioIdItem]
    ] = Field(
        [],
        description='The IDs of the scenarios that the simulation unit tests use.',
        title='Scenario Id',
    )
    metric_id: Optional[List[SearchSimulationUnitTestsParametersQueryMetricIdItem]] = (
        Field(
            [],
            description='The IDs of the metrics that the simulation unit tests use.',
            title='Metric Id',
        )
    )


class GetSimulationUnitTestSetsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestSetsParametersQueryUnitTestIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestSetsParametersQuery(BaseModel):
    id: Optional[List[GetSimulationUnitTestSetsParametersQueryIdItem]] = Field(
        [],
        description='The IDs of the simulation unit test sets to retrieve.',
        title='Id',
    )
    limit: Optional[int] = Field(
        20,
        description='The maximum number of simulation unit test sets to return.',
        ge=0,
        le=20,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of simulation unit test sets.',
        title='Continuation Token',
    )
    is_deleted: Optional[bool] = Field(
        None,
        description='Whether the simulation unit test set is deleted.',
        title='Is Deleted',
    )
    unit_test_id: Optional[
        List[GetSimulationUnitTestSetsParametersQueryUnitTestIdItem]
    ] = Field(
        [],
        description='The IDs of the unit tests that are part of the simulation unit test sets.',
        title='Unit Test Id',
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation unit test sets.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation unit test sets. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `updated_at`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class SearchSimulationUnitTestSetsParametersQueryUnitTestIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchSimulationUnitTestSetsParametersQuery(BaseModel):
    query: str = Field(
        ...,
        description='The query to search for. Any simulation unit test sets containing the terms in its name or description would be returned.',
        min_length=1,
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation unit test sets. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation unit test sets. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    unit_test_id: Optional[
        List[SearchSimulationUnitTestSetsParametersQueryUnitTestIdItem]
    ] = Field(
        [],
        description='The IDs of the unit tests that are part of the simulation unit test sets.',
        title='Unit Test Id',
    )


class GetSimulationUnitTestSetRunsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestSetRunsParametersQuerySimulationUnitTestSetIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetSimulationUnitTestSetRunsParametersQuery(BaseModel):
    id: Optional[List[GetSimulationUnitTestSetRunsParametersQueryIdItem]] = Field(
        [],
        description='The ID of the simulation unit test set run to retrieve.',
        title='Id',
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of simulation unit test set runs to return.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of simulation unit test set runs.',
        title='Continuation Token',
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the simulation unit test set runs to retrieve. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `created_at`.',
        title='Sort By',
    )
    simulation_unit_test_set_id: Optional[
        List[GetSimulationUnitTestSetRunsParametersQuerySimulationUnitTestSetIdItem]
    ] = Field(
        [],
        description='The IDs of the simulation unit test sets that the simulation unit test set runs belong to.',
        title='Simulation Unit Test Set Id',
    )
    is_completed: Optional[bool] = Field(
        None,
        description='Whether the simulation unit test set run is completed.',
        title='Is Completed',
    )
    failed_metrics: Optional[bool] = Field(
        None,
        description='Whether the simulation unit test set run has failed due to failing metrics. Note that this field could be `True` even if the run is still ongoing -- it simply means some unit test runs have failed.',
        title='Failed Metrics',
    )
    errored: Optional[bool] = Field(
        None,
        description='Whether the simulation unit test set run has encountered an error.',
        title='Errored',
    )
    created_after: Optional[AwareDatetime] = Field(
        None,
        description='Filter for simulation unit test set runs created at or after this time (inclusive).',
        title='Created After',
    )
    created_before: Optional[AwareDatetime] = Field(
        None,
        description='Filter for simulation unit test set runs created at or before this time (inclusive).',
        title='Created Before',
    )


class GetToolsParametersQueryIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetToolsParametersQuery(BaseModel):
    id: Optional[List[GetToolsParametersQueryIdItem]] = Field(
        [], description='The IDs of the tools to retrieve.', title='Id'
    )
    deprecated: Optional[bool] = Field(
        None, description='Whether the tools are deprecated.', title='Deprecated'
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `name` and `deprecated`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )
    tag: Optional[List[str]] = Field(
        [],
        description='The tags of the simulation personas. Must be specified using the syntax `key:value`, which means to match all sets with the given `key` and `value` pair among its tags. If `value` is `*`, it means the `value` does not matter. If `value` is empty, it matches against when the value is `None`.',
        title='Tag',
    )
    limit: Optional[int] = Field(
        10,
        description='The maximum number of tools to return.',
        gt=0,
        le=20,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of tools.',
        title='Continuation Token',
    )


class GetToolVersionsParametersQuery(BaseModel):
    deprecated: Optional[bool] = Field(
        None,
        description='Whether to filter by deprecated tool versions.',
        title='Deprecated',
    )
    versions: Optional[str] = Field(
        None,
        description='A semver constraint that specifies the versions to retrieve.',
        title='Versions',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the versions by. Supported fields are `created_at`, `version.major`, `version.minor`, `version.patch`, and `deprecated`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.    ',
        title='Sort By',
    )
    creator: Optional[List[str]] = Field(
        [],
        description='The creators of the tool versions. Each value must be of the format `org_id,user_id`.',
        title='Creator',
    )
    limit: Optional[int] = Field(
        50,
        description='The maximum number of tool versions to return.',
        ge=0,
        le=50,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The continuation token from the previous request used to retrieve the next page of tool versions.',
        title='Continuation Token',
    )


class GetToolInvocationsParametersQueryToolIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetToolInvocationsParametersQueryInvocationSourceTypeEnum(Enum):
    regular_conversation = 'regular-conversation'
    simulation_conversation = 'simulation-conversation'


class GetToolInvocationsParametersQueryConversationIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetToolInvocationsParametersQuerySimulationUnitTestSetRunIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class GetToolInvocationsParametersQuery(BaseModel):
    tool_id: Optional[List[GetToolInvocationsParametersQueryToolIdItem]] = Field(
        [], description='The IDs of the tools to get invocations for.', title='Tool Id'
    )
    version: Optional[List[str]] = Field(
        [],
        description='A list of semver constraints that specifies the versions to retrieve in the [Python packaging specification](https://packaging.python.org/en/latest/specifications/version-specifiers/#id5). This must be the exact same length as `tool_id`, and each entry corresponds to the tool ID at the same index.',
        title='Version',
    )
    invocation_source_type: Optional[
        List[GetToolInvocationsParametersQueryInvocationSourceTypeEnum]
    ] = Field(
        [],
        description='The source types of the invocations.',
        title='Invocation Source Type',
    )
    conversation_id: Optional[
        List[GetToolInvocationsParametersQueryConversationIdItem]
    ] = Field(
        [],
        description='The conversation IDs associated with the invocations if they are of invocation source `regular-conversation`.',
        title='Conversation Id',
    )
    simulation_unit_test_set_run_id: Optional[
        List[GetToolInvocationsParametersQuerySimulationUnitTestSetRunIdItem]
    ] = Field(
        [],
        description='The simulation unit test set run IDs associated with the invocations if they are of invocation source `simulation-conversation`.',
        title='Simulation Unit Test Set Run Id',
    )
    succeeded: Optional[bool] = Field(
        None, description='Whether the invocation succeeded.', title='Succeeded'
    )
    limit: Optional[int] = Field(
        100,
        description='The maximum number of tool invocations to retrieve.',
        ge=0,
        le=100,
        title='Limit',
    )
    continuation_token: Optional[int] = Field(
        0,
        description='The token from the previous request to return the next page of tool invocations.',
        title='Continuation Token',
    )
    sort_by: Optional[List[str]] = Field(
        [],
        description='The fields to sort the sets by. Supported fields are `created_at`, `version.major`, `version.minor`, `version.patch`, `tool_id`, `invocation_source.type`, and `invocation_status.succeeded`. Specify a `+` before the field name to indicate ascending sorting and `-` for descending sorting. Multiple fields can be specified to break ties.',
        title='Sort By',
    )


class SearchToolInvocationsParametersQueryQueryAgainstEnum(Enum):
    invocation_status_exception_message = 'invocation_status.exception_message'
    invocation_status_exception_type = 'invocation_status.exception_type'
    invocation_status_exception_stack_trace = 'invocation_status.exception_stack_trace'
    invocation_status_output = 'invocation_status.output'


class SearchToolInvocationsParametersQueryToolIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchToolInvocationsParametersQueryConversationIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchToolInvocationsParametersQuerySimulationUnitTestSetRunIdItem(
    DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
):
    pass


class SearchToolInvocationsParametersQuery(BaseModel):
    query: str = Field(..., description='The search query.', title='Query')
    query_against: List[SearchToolInvocationsParametersQueryQueryAgainstEnum] = Field(
        ...,
        description='The fields to query against. By default, all supported fields are queried against.',
        min_length=1,
        title='Query Against',
    )
    tool_id: Optional[List[SearchToolInvocationsParametersQueryToolIdItem]] = Field(
        [], description='The IDs of the tools to get invocations for.', title='Tool Id'
    )
    invocation_source_type: Optional[
        List[GetToolInvocationsParametersQueryInvocationSourceTypeEnum]
    ] = Field(
        [], description='The source of the invocation.', title='Invocation Source Type'
    )
    conversation_id: Optional[
        List[SearchToolInvocationsParametersQueryConversationIdItem]
    ] = Field(
        [],
        description="The conversation ID associated with the invocation if it's of invocation source `regular-conversation`.",
        title='Conversation Id',
    )
    simulation_unit_test_set_run_id: Optional[
        List[SearchToolInvocationsParametersQuerySimulationUnitTestSetRunIdItem]
    ] = Field(
        [],
        description="The simulation unit test set run ID associated with the invocation if it's of invocation source `simulation-conversation`.",
        title='Simulation Unit Test Set Run Id',
    )
    succeeded: Optional[bool] = Field(
        None, description='Whether the invocation succeeded.', title='Succeeded'
    )


class APIKey(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    key_id: str = Field(
        ...,
        description="The ID of the API key. Instead of the key's Mongo ID, this UUID is used as the identifier for the key for backwards compatibility reasons.",
        title='Key Id',
    )
    expires_at: AwareDatetime = Field(
        ...,
        description='The UTC time at which this key will expire.',
        title='Expires At',
    )
    hashed_value: str = Field(
        ..., description='The hashed value of the API key.', title='Hashed Value'
    )
    creator: AmigoLibMongoCollectionsApiKeyAPIKeyUserInfo = Field(
        ..., description='The user who created this key.'
    )
    role_id: str = Field(
        ..., description='The role ID of the creator of this key.', title='Role Id'
    )
    index: int = Field(
        ...,
        description='The index of this API key, which is an integer between 0 to 19. An org cannot have more than 1 API key with the same index.',
        title='Index',
    )


class ActionStateOutput(BaseModel):
    type: Literal['action'] = Field(..., title='Type')
    name: str = Field(..., description='The name of this state.', title='Name')
    objective: str = Field(
        ...,
        description='The objective that the `Agent` works towards when in this state.',
        title='Objective',
    )
    actions: List[str] = Field(
        ...,
        description='A list of specific actions that the `Agent` performs in this state.',
        title='Actions',
    )
    intra_state_navigation_guidelines: List[str] = Field(
        ...,
        description='A list of guidelines for how the agent will navigate between subgoals and exit conditions within this state.',
        title='Intra State Navigation Guidelines',
    )
    action_guidelines: List[str] = Field(
        ...,
        description='A list of guidelines for how the agent will behave when engaging with user.',
        title='Action Guidelines',
    )
    boundary_constraints: List[str] = Field(
        ...,
        description='A list of guidelines for how the agent will not behave when engaging with user.',
        title='Boundary Constraints',
    )
    exit_conditions: List[ExitConditionOutput] = Field(
        ...,
        description='A list of exit conditions for this state that describes under what condition would the session be allowed to transition to another state.',
        title='Exit Conditions',
    )
    action_tool_call_specs: List[ToolCallSpecOutput] = Field(
        ...,
        description='A list of tool calls that the agent can make in this state when executing an action.',
        title='Action Tool Call Specs',
    )
    exit_condition_tool_call_specs: List[ToolCallSpecOutput] = Field(
        ...,
        description='A list of tool calls that the agent can make in this state when evaluating exit conditions.',
        title='Exit Condition Tool Call Specs',
    )
    skip_active_memory_retrieval: bool = Field(
        ...,
        description='If `True`, the agent will not perform active memory retrieval at the start of an interaction in this state.',
        title='Skip Active Memory Retrieval',
    )


class ActionStateTransitionLog(BaseModel):
    previous_state: str = Field(
        ...,
        description='Name of the previous state to transition from.',
        title='Previous State',
    )
    previous_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the previous state is in.',
        max_length=2,
        min_length=2,
        title='Previous Service Hierarchical State Machine Version Info',
    )
    next_state: str = Field(
        ..., description='Name of the next state to transition to.', title='Next State'
    )
    next_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the next state is in.',
        max_length=2,
        min_length=2,
        title='Next Service Hierarchical State Machine Version Info',
    )
    type: Literal['action'] = Field(
        'action',
        description="The type of the state transition log, which is the type of the state we're transitioning from.",
        title='Type',
    )
    previous_state_exit_condition_description: str = Field(
        ...,
        description='The description of the exit condition that led to the transition to the next state.',
        title='Previous State Exit Condition Description',
    )
    tool_call_logs: List[List[ToolCallLog]] = Field(
        ...,
        description='A list of tool call logs that were performed during the `SelectNextAction` LLM call during this state.',
        title='Tool Call Logs',
    )


class AnnotationStateInput(BaseModel):
    type: Literal['annotation'] = Field(..., title='Type')
    name: str = Field(..., pattern='^[A-Za-z0-9_]+$')
    inner_thought: str = Field(..., min_length=1)
    next_state: Union[StateOrRefName, AnnotationStateInputNextState] = Field(
        ..., title='Next State'
    )


class CategoricalMetricSuccessCriterionInput(BaseModel):
    type: Literal['categorical'] = Field(..., title='Type')
    expected_values: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ..., min_length=1, title='Expected Values'
    )


class CategoricalMetricValueInput(BaseModel):
    type: Literal['categorical'] = Field(..., title='Type')
    categories: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ..., min_length=1, title='Categories'
    )


class DecisionStateOutput(BaseModel):
    type: Literal['decision'] = Field(..., title='Type')
    name: str = Field(..., description='The name of this state.', title='Name')
    exit_conditions: List[ExitConditionOutput] = Field(
        ...,
        description='A list of exit conditions for this state that describes under what condition would the session be allowed to transition to another state.',
        title='Exit Conditions',
    )
    decision_guidelines: List[str] = Field(
        ...,
        description='A list of action guidelines that the `Agent` follows when in this state for making a decision.',
        title='Decision Guidelines',
    )
    objective: str = Field(
        ...,
        description='The objective that the `Agent` works towards when in this state.',
        title='Objective',
    )
    tool_call_specs: List[ToolCallSpecOutput] = Field(
        ...,
        description='A list of tool calls that the agent can make in this state.',
        title='Tool Call Specs',
    )
    audio_fillers: List[str] = Field(
        ...,
        description='A list of audio fillers to play in the audio mode if the `select-next-state-for-decision-state` prompt is taking too long to process.',
        title='Audio Fillers',
    )
    audio_filler_triggered_after: float = Field(
        ...,
        description='The number of seconds to wait before playing an audio filler.',
        title='Audio Filler Triggered After',
    )


class DecisionStateTransitionLog(BaseModel):
    previous_state: str = Field(
        ...,
        description='Name of the previous state to transition from.',
        title='Previous State',
    )
    previous_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the previous state is in.',
        max_length=2,
        min_length=2,
        title='Previous Service Hierarchical State Machine Version Info',
    )
    next_state: str = Field(
        ..., description='Name of the next state to transition to.', title='Next State'
    )
    next_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the next state is in.',
        max_length=2,
        min_length=2,
        title='Next Service Hierarchical State Machine Version Info',
    )
    type: Literal['decision'] = Field(
        'decision',
        description="The type of the state transition log, which is the type of the state we're transitioning from.",
        title='Type',
    )
    previous_state_exit_condition_description: str = Field(
        ...,
        description='The description of the exit condition that led to the transition to the next state.',
        title='Previous State Exit Condition Description',
    )
    tool_call_logs: List[List[ToolCallLog]] = Field(
        ...,
        description='A list of tool call logs that were performed during the `SelectNextActionForDecisionState` LLM call during this state.',
        title='Tool Call Logs',
    )


class DeleteRequest(BaseModel):
    name: str = Field(
        ...,
        description='The name of the environment variable to delete.',
        min_length=1,
        pattern='[A-Z_]+',
    )


class DynamicBehaviorSetVersion(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    dynamic_behavior_set_id: str = Field(..., title='Dynamic Behavior Set Id')
    version: int = Field(..., title='Version')
    conversation_triggers: List[str] = Field(..., title='Conversation Triggers')
    action: AmigoLibMongoCollectionsDynamicBehaviorSetVersionAction


class InsertRequest(BaseModel):
    name: str = Field(
        ...,
        description='The name of the environment variable to insert.',
        min_length=1,
        pattern='[A-Z_]+',
    )
    value: str = Field(
        ...,
        description='The value of the environment variable to insert.',
        title='Value',
    )
    is_secret: bool = Field(
        ...,
        description='Whether the environment variable is a secret.',
        title='Is Secret',
    )


class InvocationResult(
    RootModel[Union[SucceededInvocationResult, FailedInvocationResult]]
):
    root: Union[SucceededInvocationResult, FailedInvocationResult] = Field(
        ..., discriminator='succeeded'
    )


class ManualEvaluationSource(BaseModel):
    type: Literal['manual'] = Field('manual', title='Type')
    conversation_id: str = Field(..., title='Conversation Id')
    evaluate_to_interaction_id: Optional[str] = Field(
        ..., title='Evaluate To Interaction Id'
    )
    invoked_by: (
        AmigoLibMongoCollectionsMetricEvaluationResultMetricEvaluationResultManualEvaluationSourceUserInfo
    ) = Field(..., description='The user who invoked the manual evaluation.')
    references: List[str] = Field(
        ...,
        description='A list of references to the messages that were used to compute this metric.',
        title='References',
    )


class MessageInstance(BaseModel):
    id: str = Field(..., title='Id')
    interaction_id: str = Field(
        ..., description='The identifier of the interaction.', title='Interaction Id'
    )
    timestamp: AwareDatetime = Field(
        ..., description='The time at which this message was sent.', title='Timestamp'
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The time at which this message was created.',
        title='Created At',
    )
    sender: str = Field(
        ...,
        description='A human-friendly name of the sender of the message.',
        title='Sender',
    )
    message: str = Field(
        ..., description='The text content of the message.', title='Message'
    )
    format: Format = Field(
        ..., description='The format in which the message was delivered.'
    )
    message_type: MessageType = Field(..., description='The type of the message.')


class NumericalMetricSuccessCriterion(BaseModel):
    type: Literal['numerical'] = Field(..., title='Type')
    verb: Verb
    threshold: float = Field(..., title='Threshold')


class RecallStateInput(BaseModel):
    type: Literal['recall'] = Field(..., title='Type')
    name: str = Field(..., pattern='^[A-Za-z0-9_]+$')
    queries: Optional[RecallStateInputQueries] = Field(..., title='Queries')
    requested_information: Optional[
        AmigoLibPydanticBaseModelStrippedNonemptyString1
    ] = None
    next_state: Union[StateOrRefName, RecallStateInputNextState] = Field(
        ..., title='Next State'
    )


class ReflectionStateOutput(BaseModel):
    type: Literal['reflection'] = Field(..., title='Type')
    name: str = Field(..., description='The name of this state.', title='Name')
    problem: str = Field(
        ..., description='The problem to reflect upon.', title='Problem'
    )
    word_limit: int = Field(
        ...,
        description='The word limit for the generated inner thought message.',
        title='Word Limit',
    )
    next_state: Union[str, ReflectionStateOutputNextState] = Field(
        ...,
        description="The state to transition to after the inner thought message is generated. If it's a string, the session will transition to a state within this contextual graph. If it's a tuple, the first element\nmust be of the form `{external_contextual_graph_reference_name}.{state_name}` and represents a state in another contextual graph that the session will transition to, and the second element must be a state\nin this contextual graph that the session will transition to after reaching the terminal state of the external graph.",
        title='Next State',
    )
    tool_call_specs: List[ToolCallSpecOutput] = Field(
        ...,
        description='A list of tool calls that the agent can make in this state.',
        title='Tool Call Specs',
    )
    audio_fillers: List[str] = Field(
        ...,
        description='A list of audio fillers to play in audio mode if the reflection is taking too long to be generated.',
        title='Audio Fillers',
    )
    audio_filler_triggered_after: float = Field(
        ...,
        description='The number of seconds to wait before playing an audio filler.',
        title='Audio Filler Triggered After',
    )


class ReflectionStateTransitionLog(BaseModel):
    previous_state: str = Field(
        ...,
        description='Name of the previous state to transition from.',
        title='Previous State',
    )
    previous_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the previous state is in.',
        max_length=2,
        min_length=2,
        title='Previous Service Hierarchical State Machine Version Info',
    )
    next_state: str = Field(
        ..., description='Name of the next state to transition to.', title='Next State'
    )
    next_service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The identifier of the service hierarchical state machine that the next state is in.',
        max_length=2,
        min_length=2,
        title='Next Service Hierarchical State Machine Version Info',
    )
    type: Literal['reflection'] = Field(
        'reflection',
        description="The type of the state transition log, which is the type of the state we're transitioning from.",
        title='Type',
    )
    inner_thought_message_id: str = Field(
        ...,
        description='The identifier of the inserted inner thought message.',
        title='Inner Thought Message Id',
    )
    tool_call_logs: List[List[ToolCallLog]] = Field(
        ...,
        description='A list of tool call logs that were performed during the `GenerateReflection` LLM call during this state.',
        title='Tool Call Logs',
    )


class RegularConversationInvocationSource(BaseModel):
    type: Literal['regular-conversation'] = Field('regular-conversation', title='Type')
    user_id: str = Field(
        ...,
        description='The ID of the user whose conversation invoked the tool.',
        title='User Id',
    )
    conversation_id: Optional[str] = Field(
        ...,
        description='The ID of the conversation where the tool was invoked. This conversation might not actually exist if later in the call the conversation is rolled back.',
        title='Conversation Id',
    )
    interaction_id: Optional[str] = Field(
        ...,
        description='The ID of the interaction where the tool was invoked. This interaction might not actually exist if later in the call the interaction is rolled back.',
        title='Interaction Id',
    )
    invocation_metadata: Union[
        StateTransitionInvocationMetadata,
        EngageUserInvocationMetadata,
        ToolCallStateInvocationMetadata,
    ] = Field(..., description='Metadata about the invocation.', discriminator='type')


class ServiceInstance(BaseModel):
    id: str = Field(..., description='The identifier of the service.', title='Id')
    name: str = Field(..., description='The name of the service.', title='Name')
    version_sets: Dict[str, AmigoLibMongoCollectionsServiceServiceVersionSet] = Field(
        ...,
        description='The available version sets of the service.',
        title='Version Sets',
    )
    description: str = Field(
        ..., description='A description of the service.', title='Description'
    )
    is_active: bool = Field(
        ..., description='Whether the service is active.', title='Is Active'
    )
    service_hierarchical_state_machine_id: str = Field(
        ...,
        description='The ID of the state machine that this service uses.',
        title='Service Hierarchical State Machine Id',
    )
    agent_id: str = Field(
        ..., description='The ID of the agent that this service uses.', title='Agent Id'
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the service.', title='Tags'
    )


class SimulationConversationInvocationSource(BaseModel):
    type: Literal['simulation-conversation'] = Field(
        'simulation-conversation', title='Type'
    )
    simulation_unit_test_set_run_id: Optional[str] = Field(
        ..., title='Simulation Unit Test Set Run Id'
    )
    unit_test_id: Optional[str] = Field(..., title='Unit Test Id')
    run_index: Optional[int] = Field(..., title='Run Index')
    invocation_metadata: Union[
        StateTransitionInvocationMetadata,
        EngageUserInvocationMetadata,
        ToolCallStateInvocationMetadata,
    ] = Field(..., description='Metadata about the invocation.', discriminator='type')


class SimulationUnitTestSet(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    name: str = Field(
        ..., description='The name of the simulation unit test set.', title='Name'
    )
    description: Optional[str] = Field(
        ...,
        description='The description of the simulation unit test set.',
        title='Description',
    )
    unit_test_runs: List[
        AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUnitTestRunDescriptor
    ] = Field(
        ...,
        description='The unit test runs that are part of this set.',
        title='Unit Test Runs',
    )
    last_triggered_run_id: Optional[str] = Field(
        ...,
        description='The last unit test set run that was triggered.',
        title='Last Triggered Run Id',
    )
    is_deleted: bool = Field(
        ...,
        description='Whether the unit test set has been deleted.',
        title='Is Deleted',
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the simulation unit test set.', title='Tags'
    )
    creator: AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUserInfo
    updated_by: (
        AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUserInfo
    )


class SimulationUnitTestSetInstance(BaseModel):
    id: str = Field(..., title='Id')
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    name: str = Field(
        ..., description='The name of the simulation unit test set.', title='Name'
    )
    description: Optional[str] = Field(
        ...,
        description='The description of the simulation unit test set.',
        title='Description',
    )
    unit_test_runs: List[
        AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUnitTestRunDescriptor
    ] = Field(
        ...,
        description='The unit test runs that are part of this set.',
        title='Unit Test Runs',
    )
    last_triggered_run_id: Optional[str] = Field(
        ...,
        description='The last unit test set run that was triggered.',
        title='Last Triggered Run Id',
    )
    is_deleted: bool = Field(
        ...,
        description='Whether the unit test set has been deleted.',
        title='Is Deleted',
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the simulation unit test set.', title='Tags'
    )
    creator: AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUserInfo
    updated_by: (
        AmigoLibMongoCollectionsSimulationUnitTestSetSimulationUnitTestSetUserInfo
    )


class SuccessCriterionDescriptionInput(
    RootModel[
        Union[
            NumericalMetricSuccessCriterion,
            BooleanMetricSuccessCriterion,
            CategoricalMetricSuccessCriterionInput,
        ]
    ]
):
    root: Union[
        NumericalMetricSuccessCriterion,
        BooleanMetricSuccessCriterion,
        CategoricalMetricSuccessCriterionInput,
    ] = Field(..., discriminator='type')


class ToolCallSpecInput(BaseModel):
    tool_id: str = Field(
        ...,
        description='The ID of the tool.',
        pattern='^[a-f0-9]{24}$',
        title='Tool Id',
    )
    version_constraint: str = Field(
        ...,
        description='A [Python packaging version constraint](https://packaging.python.org/en/latest/specifications/version-specifiers/#id5) of the tool.',
        title='Version Constraint',
    )
    additional_instruction: str = Field(
        ...,
        description="Additional instruction to be supplied to the LLM in addition to the tool's description.",
        min_length=1,
    )
    audio_fillers: List[StrippedNonemptyString] = Field(
        ...,
        description='A list of audio fillers to play in audio mode if the tool is taking a long time.',
        max_length=5,
        title='Audio Fillers',
    )
    audio_filler_triggered_after: float = Field(
        ...,
        description='The number of seconds to wait before playing an audio filler.',
        gt=0.0,
        le=10.0,
        title='Audio Filler Triggered After',
    )
    result_persistence: Optional[ResultPersistence] = Field(
        'persisted', description='The type of result persistence for this tool call.'
    )


class ToolCallStateInput(BaseModel):
    type: Literal['tool-call'] = Field(..., title='Type')
    name: str = Field(..., pattern='^[A-Za-z0-9_]+$')
    next_state: Union[StateOrRefName, ToolCallStateInputNextState] = Field(
        ..., title='Next State'
    )
    designated_tool: ToolCallSpecInput
    designated_tool_call_params_generation_audio_fillers: List[
        StrippedNonemptyString
    ] = Field(
        ..., max_length=5, title='Designated Tool Call Params Generation Audio Fillers'
    )
    designated_tool_call_params_generation_audio_filler_triggered_after: float = Field(
        ...,
        gt=0.0,
        le=10.0,
        title='Designated Tool Call Params Generation Audio Filler Triggered After',
    )
    designated_tool_call_objective: str = Field(..., min_length=1)
    designated_tool_call_context: str = Field(..., min_length=1)
    designated_tool_call_guidances: List[
        AmigoLibPydanticBaseModelStrippedNonemptyString1
    ] = Field(..., title='Designated Tool Call Guidances')
    designated_tool_call_validations: List[
        AmigoLibPydanticBaseModelStrippedNonemptyString1
    ] = Field(..., title='Designated Tool Call Validations')
    tool_call_specs: List[ToolCallSpecInput] = Field(..., title='Tool Call Specs')


class ToolInstance(BaseModel):
    id: str = Field(..., description='The identifier fo the tool.', title='Id')
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    name: str = Field(..., description='The name of the tool.', title='Name')
    description: str = Field(
        ...,
        description='A description of the tool. This description will be used to describe the tool to the LLM.',
        title='Description',
    )
    deprecated: bool = Field(
        ...,
        description='Whether the tool is deprecated. Deprecated tools are not usable.',
        title='Deprecated',
    )
    envvars: List[str] = Field(
        ...,
        description='A list of environment variables that some versions of this tool uses.',
        title='Envvars',
    )
    secret_envvars: List[str] = Field(
        ...,
        description='A list of encrypted environment variables that some versions of this tool uses.',
        title='Secret Envvars',
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the simulation persona.', title='Tags'
    )


class ToolVersionInstance(BaseModel):
    id: str = Field(..., description='The identifier of the tool version.', title='Id')
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    tool_id: str = Field(
        ...,
        description='The ID of the tool that this version belongs to.',
        title='Tool Id',
    )
    version: AmigoLibMongoCollectionsToolVersionToolVersionVersion = Field(
        ..., description='The version of the tool.'
    )
    required_envvars: List[str] = Field(
        ...,
        description='The environment variables that are required to run the tool.',
        title='Required Envvars',
    )
    required_secret_envvars: List[str] = Field(
        ...,
        description='The secret environment variables that are required to run the tool.',
        title='Required Secret Envvars',
    )
    input_schema: Dict[str, Any] = Field(
        ..., description='The input schema of the tool.', title='Input Schema'
    )
    tool_repo: ToolVersionInstanceToolRepo = Field(
        ...,
        description='Whether this tool is published from the main repository or the team-specific repository.',
        title='Tool Repo',
    )
    tool_commit_hash: str = Field(
        ...,
        description='The commit hash of the tool within the repository.',
        title='Tool Commit Hash',
    )
    amigo_scaffold_commit_hash: str = Field(
        ...,
        description='The commit hash of the Amigo scaffold that this tool version was created with.',
        title='Amigo Scaffold Commit Hash',
    )
    project_directory: str = Field(
        ..., description='The project directory of the tool.', title='Project Directory'
    )
    lambda_version: int = Field(
        ...,
        description='The version of the Lambda function that corresponds to this tool version.',
        title='Lambda Version',
    )
    creator: AmigoLibMongoCollectionsToolVersionToolVersionUserInfo = Field(
        ..., description='The user who created the tool version.'
    )
    deprecated: bool = Field(
        ...,
        description='Whether the tool version is deprecated. Deprecated tool versions are not usable and do not participate in version resolution.',
        title='Deprecated',
    )


class UnitTestRunResult(BaseModel):
    unit_test_id: str = Field(
        ..., description='ID of the unit test that was run.', title='Unit Test Id'
    )
    metric_evaluation_results: List[
        AmigoLibMongoCollectionsSimulationUnitTestSetRunSimulationUnitTestSetRunUnitTestRunResultMetricEvaluationResult
    ] = Field(
        ...,
        description="The metric evaluation results for the unit test run. There's as many elements in this list as there are metrics to evaluate for this unit test.\nThis field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTest` permission. Otherwise, it is an empty list.",
        title='Metric Evaluation Results',
    )
    run_errors: List[Optional[str]] = Field(
        ...,
        description='A list of errors that each run of this unit test has encountered. If the ith entry is `None`, it means that the run has not errored.',
        title='Run Errors',
    )


class UserModel(BaseModel):
    content: str = Field(..., title='Content')
    insight_ids: List[str] = Field(..., title='Insight Ids')
    dimensions: List[AmigoLibMongoCollectionsUserUserUserModelUserDimension] = Field(
        ..., title='Dimensions'
    )


class VersionSetInfo(BaseModel):
    name: str = Field(
        ...,
        description='The name of the version set. If the value is `unknown`, it means the conversation was created before this field was introduced and the version set name cannot be retroactively determined.',
        title='Name',
    )
    agent_version_info: List = Field(
        ...,
        description='The ID of the agent and version number used in this conversation.',
        max_length=2,
        min_length=2,
        title='Agent Version Info',
    )
    service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The ID of the state machine and version number used in this conversation.',
        max_length=2,
        min_length=2,
        title='Service Hierarchical State Machine Version Info',
    )
    llm_model_preferences: Dict[
        str,
        Union[AmigoLibLlmLlmBaseLLMConfig, AmigoLibLlmLlmBaseLLMLoadBalancingSetConfig],
    ] = Field(
        ...,
        description='The LLM model preferences for this version set.',
        title='Llm Model Preferences',
    )


class WebhookDeliveryInstance(BaseModel):
    id: str = Field(..., description='The ID of the webhook delivery.', title='Id')
    type: str = Field(..., description='The type of the webhook.', title='Type')
    webhook_content: Dict[str, Any] = Field(
        ..., description='The body of the webhook.', title='Webhook Content'
    )
    status: WebhookDeliveryStatus = Field(
        ..., description='The status of the webhook delivery.'
    )
    delivery_attempts: List[DeliveryAttempt] = Field(
        ...,
        description='The delivery attempts of the webhook.',
        title='Delivery Attempts',
    )
    dual_signed: bool = Field(
        ...,
        description='Whether the webhook was signed with two secrets.',
        title='Dual Signed',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='In UTC time, when the webhook send request was received.',
        title='Created At',
    )


class AmigoLibMongoCollectionsAgentAgentIdentity(BaseModel):
    name: str = Field(
        ..., description='A human friendly name of the agent.', title='Name'
    )
    role: str = Field(
        ..., description="The agent's role within the organization.", title='Role'
    )
    developed_by: str = Field(
        ...,
        description='A human-friendly name of the organization that developed this agent.',
        title='Developed By',
    )
    default_spoken_language: str = Field(
        ...,
        description="The agent's primary language. This must be specified in the ISO 639-3 format.",
        title='Default Spoken Language',
    )
    relationship_to_developer: (
        AmigoLibMongoCollectionsAgentAgentIdentityRelationshipToDeveloper
    ) = Field(..., description='Relationship of the agent to its developer.')


class AmigoLibMongoCollectionsRoleRolePermissionGrant(BaseModel):
    action: AmigoLibMongoCollectionsRoleRolePermissionGrantAction = Field(
        ...,
        description='Whether this grant allows or denies the specified access.',
        title='Action',
    )
    permission_name: str = Field(
        ..., description='The name of the permission.', title='Permission Name'
    )
    conditions: Dict[str, Union[EqualCondition, InCondition, NotEqualCondition]] = (
        Field(
            ...,
            description='A dictionary of attribute name to condition that must be met for this grant to be applicable.',
            title='Conditions',
        )
    )
    description: Optional[str] = Field(
        None, description='An optional explanation of this grant.', title='Description'
    )


class AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestSuccessCriterion(
    BaseModel
):
    name: str = Field(..., title='Name')
    metric_id: str = Field(..., title='Metric Id')
    criterion: Union[
        BooleanMetricSuccessCriterion,
        NumericalMetricSuccessCriterion,
        CategoricalMetricSuccessCriterionOutput,
    ] = Field(..., discriminator='type')


class ConversationGetConversationMessagesResponse(BaseModel):
    messages: List[MessageInstance] = Field(
        ..., description='The retrieved messages.', title='Messages'
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more, earlier messages in the conversation to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='The continuation token to use to retrieve the next set of messages.',
        title='Continuation Token',
    )


class ConversationGetInteractionInsightsResponse(BaseModel):
    current_state_name: str = Field(
        ..., description='The state the agent is in.', title='Current State Name'
    )
    current_state_action: str = Field(
        ...,
        description='The action taken in the current state.',
        title='Current State Action',
    )
    current_state_objective: str = Field(
        ...,
        description='The objective of the current state.',
        title='Current State Objective',
    )
    state_transition_logs: List[
        Union[
            ActionStateTransitionLog,
            DecisionStateTransitionLog,
            RecallStateTransitionLog,
            JumpbackStateTransitionLog,
            AnnotationStateTransitionLog,
            ReflectionStateTransitionLog,
            ToolCallStateTransitionLog,
        ]
    ] = Field(
        ...,
        description='The state transition log of the interaction.',
        title='State Transition Logs',
    )
    working_memory: List[WorkingMemory] = Field(
        ...,
        description='A list of active memories the agent used to generate the message.',
        title='Working Memory',
    )
    reflections: List[str] = Field(
        ...,
        description='A list of reflections the agent made during the generation of this message.',
        title='Reflections',
    )
    triggered_dynamic_behavior_set_version_info: Optional[
        ConversationGetInteractionInsightsResponseTriggeredDynamicBehaviorSetVersionInfo
    ] = Field(
        ...,
        description='The ID and version number of the dynamic behavior set that was activated during this interaction.',
        title='Triggered Dynamic Behavior Set Version Info',
    )
    select_next_action_tool_call_logs: List[List[ToolCallLog]] = Field(
        ...,
        description='A list of tool call logs that were performed during the final `SelectNextAction` LLM call during this interaction where an action was selected.',
        title='Select Next Action Tool Call Logs',
    )
    engage_user_tool_call_logs: List[List[ToolCallLog]] = Field(
        ...,
        description='A list of tool call logs that were performed during the `EngageUser` LLM call during this interaction.',
        title='Engage User Tool Call Logs',
    )


class DynamicBehaviorSetCreateDynamicBehaviorSetRequestInitialVersion(BaseModel):
    is_active: bool = Field(
        ...,
        description='After adding this initial version, whether the dynamic behavior set should be activated.',
        title='Is Active',
    )
    conversation_triggers: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = (
        Field(
            ...,
            description='The conversation triggers for the dynamic behavior set version.',
            max_length=50,
            min_length=1,
            title='Conversation Triggers',
        )
    )
    action: DynamicBehaviorSetCreateDynamicBehaviorSetRequestInitialVersionInjectInstructionAction = Field(
        ...,
        description='The action to perform when the dynamic behavior set version is activated.',
    )


class DynamicBehaviorSetCreateDynamicBehaviorSetVersionRequest(BaseModel):
    conversation_triggers: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = (
        Field(
            ...,
            description='The conversation triggers for the dynamic behavior set version.',
            max_length=50,
            min_length=1,
            title='Conversation Triggers',
        )
    )
    action: (
        DynamicBehaviorSetCreateDynamicBehaviorSetVersionRequestInjectInstructionAction
    ) = Field(
        ...,
        description='The action to perform when the dynamic behavior set version is activated.',
    )


class DynamicBehaviorSetGetDynamicBehaviorSetVersionsResponse(BaseModel):
    dynamic_behavior_set_versions: List[DynamicBehaviorSetVersion] = Field(
        ...,
        description='The retrieved dynamic behavior set versions.',
        title='Dynamic Behavior Set Versions',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more dynamic behavior set versions to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of dynamic behavior set versions. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class DynamicBehaviorSetGetDynamicBehaviorSetsResponse(BaseModel):
    dynamic_behavior_sets: List[
        DynamicBehaviorSetGetDynamicBehaviorSetsResponseDynamicBehaviorSetInstance
    ] = Field(
        ...,
        description='The retrieved dynamic behavior sets.',
        title='Dynamic Behavior Sets',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more dynamic behavior sets to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='The continuation token to use to retrieve the next set of dynamic behavior sets.',
        title='Continuation Token',
    )
    filter_values: Optional[
        DynamicBehaviorSetGetDynamicBehaviorSetsResponseFilterValues
    ] = Field(
        ...,
        description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the dynamic behavior sets, so they might differ from how many sets are actually\nretrieved.',
    )


class MetricCreateMetricRequest(BaseModel):
    name: str = Field(
        ...,
        description='The name of the metric. Must be unique within the organization.',
        min_length=1,
    )
    description: str = Field(
        ..., description='The description of the metric.', min_length=1
    )
    applied_to_services: List[MetricCreateMetricRequestAppliedToService] = Field(
        ...,
        description='The services that the metric is applied to.',
        title='Applied To Services',
    )
    additional_notes: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = (
        Field(..., description='Additional notes about the metric.')
    )
    tags: Dict[str, Optional[StrippedNonemptyStringWS]] = Field(
        ..., description='The tags of the metric.', title='Tags'
    )
    metric_value: Union[
        NumericalMetricValue, CategoricalMetricValueInput, BooleanMetricValue
    ] = Field(..., discriminator='type')


class OrganizationCreateAgentVersionRequestIdentity(BaseModel):
    name: str = Field(..., min_length=1)
    role: str = Field(..., min_length=1)
    developed_by: str = Field(..., min_length=1)
    default_spoken_language: (
        OrganizationCreateAgentVersionRequestIdentityDefaultSpokenLanguage
    ) = Field(..., title='Default Spoken Language')
    relationship_to_developer: (
        OrganizationCreateAgentVersionRequestIdentityRelationshipToDeveloper
    )


class OrganizationCreateOrganizationRequest(BaseModel):
    org_name: str = Field(
        ..., description='A human friendly name of the organization.', min_length=1
    )
    title: str = Field(
        ...,
        description='An advertising tagline for the services offered by this organization.',
        min_length=1,
    )
    main_description: str = Field(
        ...,
        description='A description of the services offered by this organization that is displayed on the login page for the Amigo frontend for this organization.',
        min_length=1,
    )
    sub_description: str = Field(
        ...,
        description='Additional descriptions of the services offered by this organization that is displayed below `main_description` in a smaller font.',
        min_length=1,
    )
    user_dimensions: List[OrganizationCreateOrganizationRequestUserDimension] = Field(
        ...,
        description='User dimensions for the organization.',
        title='User Dimensions',
    )
    logo: str = Field(
        ...,
        description='A logo for the organization that will be displayed on the Amigo frontend for this organization, as well as all Amigo communications to users on behalf of the organization.\nMust be provided as base64 encoded bytes of a PNG image of aspect ratio 5:2 with minimum size 400 * 160 pixels.',
        title='Logo',
    )
    square_logo: str = Field(
        ...,
        description='A square logo of the organization. Must be provided as base64 encoded bytes of a square PNG image of size at least 40 * 40 pixels.',
        title='Square Logo',
    )
    favicon: str = Field(
        ...,
        description="Favicon for the Amigo frontend for this organization. Must be provided as base64 encoded bytes of a square ICO image that's of size at least 40 * 40 pixels.",
        title='Favicon',
    )
    signup_page_headshot: str = Field(
        ...,
        description='An image of the main persona of the organization that is displayed on the signup page for this organization in base64 encoded bytes of a PNG image of size at least 292 * 400 pixels and aspect ratio\n0.73. If not specified, a default headshot is used.',
        title='Signup Page Headshot',
    )
    default_user_preferences: Optional[
        OrganizationCreateOrganizationRequestPreferences
    ] = Field(
        default_factory=lambda: OrganizationCreateOrganizationRequestPreferences.model_validate(
            {
                'enable_response_recommendation': False,
                'conversations_visible_to_admins': True,
                'user_model_visible_to_admins': True,
            }
        ),
        description='Default user preferences for users in this organization.',
    )
    onboarding_instructions: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = (
        Field(
            ...,
            description="A list of markdown text that's displayed during the onboarding flow of this organization. Each entry corresponds to a page in the onboarding flow.",
            title='Onboarding Instructions',
        )
    )
    azure_devops_team_name: str = Field(
        ...,
        description="The name of the Azure DevOps team to create (if it doesn't exist) for this organization. All orgs with the same Azure DevOps team name will share access to the same Azure DevOps resources, namely\nthe source code for tools.",
        max_length=20,
        min_length=1,
        pattern='^[a-z-]+$',
    )


class OrganizationGetAgentVersionsResponseAgentInstance(BaseModel):
    id: str = Field(..., description='The ID of the agent version.', title='Id')
    org_id: str = Field(
        ..., description='The ID of the organization of this agent.', title='Org Id'
    )
    agent_id: str = Field(..., description='The ID of this agent.', title='Agent Id')
    version: int = Field(..., description='The version of the agent.', title='Version')
    voice_config: AmigoLibMongoCollectionsAgentAgentVoiceConfig = Field(
        ..., description='The voice configuration of the agent.'
    )
    initials: str = Field(
        ..., description='The initials of the agent.', title='Initials'
    )
    identity: AmigoLibMongoCollectionsAgentAgentIdentity = Field(
        ..., description='The identity of the agent.'
    )
    background: str = Field(
        ...,
        description="A description of the `Agent`'s background.",
        title='Background',
    )
    behaviors: List[str] = Field(
        ...,
        description='A list of behavioral guidelines that this `Agent` follows.',
        title='Behaviors',
    )
    communication_patterns: List[str] = Field(
        ...,
        description='A list of descriptions that illustrate the communication styles of this `Agent`.',
        title='Communication Patterns',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The time at which this version was created.',
        title='Created At',
    )


class OrganizationGetAgentsResponse(BaseModel):
    agents: List[OrganizationGetAgentsResponseAgentInstance] = Field(
        ..., description='The agents for this organization.', title='Agents'
    )
    has_more: bool = Field(
        ..., description='Whether there are more agents to retrieve.', title='Has More'
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of agents. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class OrganizationGetApiKeysResponse(BaseModel):
    api_keys: List[APIKey] = Field(
        ..., description='The list of API keys for the organization.', title='Api Keys'
    )


class OrganizationGetOrganizationMetricsRequest(BaseModel):
    metrics: List[
        Union[
            TotalActiveUserMetricInput,
            TotalConversationCountMetricInput,
            TotalMessageCountMetricInput,
            ConversationByTimeMetricInput,
            TotalARRMetricInput,
        ]
    ] = Field(
        ...,
        description='A list of metrics to compute. Each type of metric can only appear once.',
        min_length=1,
        title='Metrics',
    )


class OrganizationGetOrganizationMetricsResponse(BaseModel):
    metrics: List[
        Union[
            TotalActiveUserMetricOutput,
            TotalConversationCountMetricOutput,
            TotalMessageCountMetricOutput,
            ConversationByTimeMetricOutput,
            TotalARRMetricOutput,
        ]
    ] = Field(
        ...,
        description='The metrics that were requested, in the same order as they were requested.',
        title='Metrics',
    )


class OrganizationModifyOrganizationRequest(BaseModel):
    title: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None,
        description='An advertising tagline for the services offered by this organization. If `null`, this field is not updated.',
    )
    main_description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = (
        Field(
            None,
            description='A description of the services offered by this organization that is displayed on the login page for the Amigo frontend for this organization. If `null`, this field is not updated.',
        )
    )
    sub_description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None,
        description='Additional descriptions of the services offered by this organization that is displayed below `main_description` in a smaller font. If `null`, this field is not updated.',
    )
    logo: Optional[str] = Field(
        None,
        description='A logo for the organization that will be displayed on the Amigo frontend for this organization, as well as all Amigo communications to users on behalf of the organization.\nMust be provided as base64 encoded bytes of a PNG image of aspect ratio 5:2 with minimum size 400 * 160 pixels. Only updated if not null.',
        title='Logo',
    )
    square_logo: Optional[str] = Field(
        None,
        description='A square logo of the organization. Must be provided as base64 encoded bytes of a square PNG image of size at least 40 * 40 pixels. Only updated if not null.',
        title='Square Logo',
    )
    favicon: Optional[str] = Field(
        None,
        description="Favicon for the Amigo frontend for this organization. Must be provided as base64 encoded bytes of a square ICO image that's of size at least 40 * 40 pixels. Only updated if not null.",
        title='Favicon',
    )
    signup_page_headshot: Optional[str] = Field(
        None,
        description='An optional image of the main persona of the organization that is displayed on the signup page for this organization in base64 encoded bytes of a PNG image of size at least 292 * 400 pixels and aspect ratio\n0.73. Only updated if not null.',
        title='Signup Page Headshot',
    )
    user_dimensions: Optional[OrganizationModifyOrganizationRequestUserDimensions] = (
        Field(
            None,
            description='User dimensions for the organization. If not set or `null`, this field is not updated.',
            title='User Dimensions',
        )
    )
    default_user_preferences: Optional[
        OrganizationModifyOrganizationRequestPreferences
    ] = Field(
        None,
        description='The default user preferences for the organization. If `null`, this field is not updated.',
    )
    onboarding_instructions: Optional[
        List[AmigoLibPydanticBaseModelStrippedNonemptyString1]
    ] = Field(
        None,
        description="A list of markdown text that's displayed during the onboarding flow of this organization. Each entry corresponds to a page in the onboarding flow.  If `null`, this field is not updated.",
        title='Onboarding Instructions',
    )


class RoleModifyRoleRequestPermissionGrant(BaseModel):
    action: AmigoLibMongoCollectionsRoleRolePermissionGrantAction = Field(
        ...,
        description='Whether this grant allows or denies the specified access.',
        title='Action',
    )
    permission_name: str = Field(..., title='Permission Name')
    conditions: Dict[str, Union[EqualCondition, InCondition, NotEqualCondition]] = (
        Field(
            ...,
            description='A dictionary of attribute name to condition that must be met for this grant to be applicable.',
            title='Conditions',
        )
    )
    description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = None


class ServiceCreateServiceRequestVersionSet(BaseModel):
    agent_version_number: Optional[int] = Field(
        ...,
        description='The version number of the agent to be used. If None, the latest agent version will be used.',
        title='Agent Version Number',
    )
    service_hierarchical_state_machine_version_number: Optional[int] = Field(
        ...,
        description='The version number of the state machine to be used. If None, the latest state machine version will be used.',
        title='Service Hierarchical State Machine Version Number',
    )
    llm_model_preferences: Dict[
        str,
        Union[
            ServiceUpsertServiceVersionSetRequestVersionSetLLMConfig,
            ServiceCreateServiceRequestVersionSetLLMLoadBalancingSetConfig,
        ],
    ] = Field(..., title='Llm Model Preferences')


class ServiceGetServicesResponse(BaseModel):
    services: List[ServiceInstance] = Field(
        ..., description='The services that are found.', title='Services'
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more services to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of services. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )
    filter_values: Optional[ServiceGetServicesResponseFilterValues] = Field(
        ...,
        description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the services, so they might differ from how many services are actually\nretrieved.',
    )


class ServiceUpsertServiceVersionSetRequest(BaseModel):
    version_set: ServiceCreateServiceRequestVersionSet = Field(
        ..., description='The version set to upsert.'
    )


class SimulationCreateSimulationPersonaRequest(BaseModel):
    name: str = Field(
        ..., description='The name of the simulation persona.', min_length=1
    )
    role: str = Field(
        ..., description='The role of the simulation persona.', min_length=1
    )
    tags: Dict[str, Optional[StrippedNonemptyStringWS]] = Field(
        ...,
        description='The tags of the simulation persona. Both the key and the value can only contain alphanumeric characters, underscores, or spaces.',
        title='Tags',
    )
    initial_version: SimulationCreateSimulationPersonaRequestInitialVersion = Field(
        ..., description='The initial version of the simulation persona.'
    )


class SimulationCreateSimulationScenarioRequest(BaseModel):
    name: str = Field(
        ..., description='The name of the simulation scenario.', min_length=1
    )
    tags: Dict[str, Optional[StrippedNonemptyStringWS]] = Field(
        ...,
        description='The tags of the simulation scenario. Both the key and the value can only contain alphanumeric characters, underscores, or spaces.',
        title='Tags',
    )
    initial_version: SimulationCreateSimulationScenarioRequestInitialVersion = Field(
        ..., description='The initial version of the simulation scenario.'
    )


class SimulationCreateSimulationUnitTestRequestSuccessCriterion(BaseModel):
    name: str = Field(..., min_length=1)
    metric_id: str = Field(..., pattern='^[a-f0-9]{24}$', title='Metric Id')
    criterion: Union[
        NumericalMetricSuccessCriterion,
        BooleanMetricSuccessCriterion,
        CategoricalMetricSuccessCriterionInput,
    ] = Field(..., discriminator='type')


class SimulationCreateSimulationUnitTestSetRequest(BaseModel):
    name: str = Field(
        ..., description='The name of the simulation unit test set.', min_length=1
    )
    description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ..., description='The description of the simulation unit test set.'
    )
    unit_test_runs: List[
        SimulationUpdateSimulationUnitTestSetRequestUnitTestRunDescriptor
    ] = Field(
        ...,
        description='The unit test runs that are part of this set.',
        min_length=1,
        title='Unit Test Runs',
    )
    tags: Dict[str, Optional[str]] = Field(
        ..., description='The tags of the simulation unit test set.', title='Tags'
    )


class SimulationGetSimulationPersonasResponse(BaseModel):
    simulation_personas: List[
        SimulationSearchSimulationPersonasResponseSimulationPersonaInstance
    ] = Field(
        ..., description='The list of simulation personas.', title='Simulation Personas'
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more simulation personas to fetch.',
        title='Has More',
    )
    continuation_token: Any = Field(
        ...,
        description='The continuation token to use to retrieve the next page of simulation personas.',
        title='Continuation Token',
    )
    filter_values: Optional[SimulationGetSimulationPersonasResponseFilterValues] = (
        Field(
            ...,
            description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the simulation personas, so they might differ from how many personas are actually\nretrieved.',
        )
    )


class SimulationGetSimulationScenariosResponse(BaseModel):
    simulation_scenarios: List[
        SimulationGetSimulationScenariosResponseSimulationScenarioInstance
    ] = Field(
        ...,
        description='The list of simulation scenarios.',
        title='Simulation Scenarios',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more simulation scenarios to fetch.',
        title='Has More',
    )
    continuation_token: Any = Field(
        ...,
        description='The continuation token to use to retrieve the next page of simulation scenarios.',
        title='Continuation Token',
    )
    filter_values: Optional[SimulationGetSimulationScenariosResponseFilterValues] = (
        Field(
            ...,
            description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the simulation scenarios, so they might differ from how many scenarios are actually\nretrieved.',
        )
    )


class SimulationGetSimulationUnitTestSetsResponse(BaseModel):
    simulation_unit_test_sets: List[SimulationUnitTestSetInstance] = Field(
        ...,
        description='The retrieved simulation unit test sets.',
        title='Simulation Unit Test Sets',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more simulation unit test sets to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='The continuation token to use to retrieve the next page of simulation unit test sets.',
        title='Continuation Token',
    )
    filter_values: Optional[SimulationGetSimulationUnitTestSetsResponseFilterValues] = (
        Field(
            ...,
            description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the simulation unit test sets, so they might differ from how many sets are actually\nretrieved.',
        )
    )


class SimulationSearchSimulationPersonasResponse(BaseModel):
    simulation_personas: List[
        SimulationSearchSimulationPersonasResponseSimulationPersonaInstance
    ] = Field(
        ..., description='The list of simulation personas.', title='Simulation Personas'
    )


class SimulationSearchSimulationUnitTestSetResponse(BaseModel):
    simulation_unit_test_sets: List[SimulationUnitTestSet] = Field(
        ...,
        description='The retrieved simulation unit test sets.',
        title='Simulation Unit Test Sets',
    )


SimulationUpdateSimulationUnitTestRequestSuccessCriterion = (
    SimulationCreateSimulationUnitTestRequestSuccessCriterion
)


class SimulationUpdateSimulationUnitTestSetRequestUnitTestRuns(
    RootModel[List[SimulationUpdateSimulationUnitTestSetRequestUnitTestRunDescriptor]]
):
    root: List[SimulationUpdateSimulationUnitTestSetRequestUnitTestRunDescriptor] = (
        Field(
            ...,
            description='The unit test runs that are part of this set.',
            min_length=1,
            title='Unit Test Runs',
        )
    )


class SimulationUpdateSimulationUnitTestSetRequest(BaseModel):
    name: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description='The name of the simulation unit test set.'
    )
    description: Optional[
        Union[AmigoLibPydanticBaseModelStrippedNonemptyString1, FieldNotSet]
    ] = Field(
        {},
        description='The description of the simulation unit test set. If not specified or an empty object is provided, the description will not be updated.',
        title='Description',
    )
    unit_test_runs: Optional[
        SimulationUpdateSimulationUnitTestSetRequestUnitTestRuns
    ] = Field(
        None,
        description='The unit test runs that are part of this set.',
        title='Unit Test Runs',
    )
    tags: Optional[Dict[str, Optional[str]]] = Field(
        None, description='The tags of the simulation unit test set.', title='Tags'
    )


class ToolGetToolVersionsResponse(BaseModel):
    tool_versions: List[ToolVersionInstance] = Field(
        ...,
        description='A list of tool versions that are found.',
        title='Tool Versions',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more tool versions to retrieve.',
        title='Has More',
    )
    continuation_token: Any = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of tool versions. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )
    filter_values: Optional[ToolGetToolVersionsResponseFilterValues] = Field(
        ...,
        description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the tool versions, so they might differ from how many tool versions are actually\nretrieved.',
    )


class ToolGetToolsResponse(BaseModel):
    tools: List[ToolInstance] = Field(
        ..., description='A list of tools that are found.', title='Tools'
    )
    has_more: bool = Field(
        ..., description='Whether there are more tools to retrieve.', title='Has More'
    )
    continuation_token: Any = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of tools. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )
    filter_values: Optional[ToolGetToolsResponseFilterValues] = Field(
        ...,
        description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the tools, so they might differ from how many tools are actually\nretrieved.',
    )


class ToolInvokeToolVersionRequest(BaseModel):
    inputs: List[ToolInvokeToolVersionRequestInput] = Field(
        ...,
        description='The list of inputs for the tool invocation.',
        max_length=10,
        min_length=1,
        title='Inputs',
    )


class ToolInvokeToolVersionResponse(BaseModel):
    invocation_results: List[
        Union[SucceededInvocationResult, FailedInvocationResult]
    ] = Field(..., title='Invocation Results')


class ToolModifyToolEnvvarsRequest(BaseModel):
    inserts: Optional[List[InsertRequest]] = Field([], title='Inserts')
    updates: Optional[List[UpdateRequest]] = Field([], title='Updates')
    deletes: Optional[List[DeleteRequest]] = Field([], title='Deletes')


ToolTestToolResponse = ToolInvokeToolVersionResponse


class UserCreateInvitedUserRequest(BaseModel):
    first_name: str = Field(
        ..., description='The first name of the user.', min_length=1
    )
    last_name: str = Field(..., description='The last name of the user.', min_length=1)
    email: EmailStr = Field(
        ...,
        description='The email of the user. This email uniquely identifies the user in the organization.',
        title='Email',
    )
    login_link: Optional[UserCreateInvitedUserRequestLoginLink] = Field(
        None,
        description="If specified, this link will be sent to the user's email as the link to start their Amigo experience. For Amigo's frontend, this would be the user's\norganization's login page with their email already filled in.",
        title='Login Link',
    )
    role_name: str = Field(
        ...,
        description='The role to assign to the user. Only roles that are returned from the [Get roles](get-roles) endpoint are allowed.',
        title='Role Name',
    )
    user_preferences: Optional[UserCreateInvitedUserRequestPreferences] = Field(
        None,
        description="If specified, the user's preferences will be set to this value instead of the organization default.",
    )


class UserGetUserModelResponse(BaseModel):
    user_models: List[UserModel] = Field(
        ..., description='The latest user models for the user.', title='User Models'
    )
    additional_context: List[str] = Field(
        ...,
        description='The additional context for the user.',
        title='Additional Context',
    )


class UserGetUsersResponse(BaseModel):
    users: List[UserSearchUsersResponseUserInstance] = Field(
        ..., description='Users in this organization.', title='Users'
    )
    has_more: bool = Field(
        ..., description='Whether there are more users to retrieve.', title='Has More'
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of users. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class UserSearchUsersResponse(BaseModel):
    users: List[UserSearchUsersResponseUserInstance] = Field(
        ..., description='Users in this organization.', title='Users'
    )


class WebhookDestinationGetWebhookDeliveriesResponse(BaseModel):
    webhook_deliveries: List[WebhookDeliveryInstance] = Field(
        ..., description='The retrieved webhook deliveries.', title='Webhook Deliveries'
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more webhook deliveries to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of webhook deliveries. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class ActionStateInput(BaseModel):
    type: Literal['action'] = Field(..., title='Type')
    name: str = Field(..., pattern='^[A-Za-z0-9_]+$')
    objective: str = Field(..., min_length=1)
    actions: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ..., min_length=1, title='Actions'
    )
    intra_state_navigation_guidelines: List[
        AmigoLibPydanticBaseModelStrippedNonemptyString1
    ] = Field(..., title='Intra State Navigation Guidelines')
    action_guidelines: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ..., title='Action Guidelines'
    )
    boundary_constraints: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = (
        Field(..., title='Boundary Constraints')
    )
    exit_conditions: List[
        OrganizationCreateServiceHierarchicalStateMachineVersionRequestActionStateExitCondition
    ] = Field(..., title='Exit Conditions')
    action_tool_call_specs: List[ToolCallSpecInput] = Field(
        ..., title='Action Tool Call Specs'
    )
    exit_condition_tool_call_specs: List[ToolCallSpecInput] = Field(
        ..., title='Exit Condition Tool Call Specs'
    )
    skip_active_memory_retrieval: bool = Field(
        ...,
        description='If `True`, the agent will not perform active memory retrieval at the start of an interaction in this state.',
        title='Skip Active Memory Retrieval',
    )


class ConversationInstance(BaseModel):
    id: str = Field(..., description='The identifier of the conversation.', title='Id')
    user_id: str = Field(
        ...,
        description='The identifier of the user who started this conversation.',
        title='User Id',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The timestamp at which this conversation was started.',
        title='Created At',
    )
    is_finished: bool = Field(
        ..., description='Whether the conversation is finished.', title='Is Finished'
    )
    is_analyzed: bool = Field(
        ...,
        description='Whether the conversation has gone through the post-conversation analysis after finishing.',
        title='Is Analyzed',
    )
    completed_post_processings: List[PostAnalysisType] = Field(
        ...,
        description='A list of post-processing types that have been completed for this conversation.',
        title='Completed Post Processings',
    )
    final_message: str = Field(
        ...,
        description='The most recent message from the conversation.\n\nThis field is empty if the authenticated user has no `Conversation:GetMessage` permission on the final message.',
        title='Final Message',
    )
    service_id: str = Field(
        ...,
        description='The ID of the service that this conversation uses.',
        title='Service Id',
    )
    version_set_info: Optional[VersionSetInfo] = Field(
        ...,
        description='Info of the service version set that this conversation uses. This field is only populated if the authenticated user has the `Service.GetVersionSet` permission on the version set.',
    )
    num_messages: int = Field(
        ...,
        description='The number of messages in this conversation.',
        title='Num Messages',
    )


class CurrentAgentActionEvent(BaseModel):
    type: Literal['current-agent-action'] = Field('current-agent-action', title='Type')
    action: Union[
        CheckIfActiveMemoryNeededAgentActionEvent,
        ExtractActiveMemoriesAgentActionEvent,
        Union[
            SelectDynamicBehaviorVectorGeneratedEvent,
            SelectDynamicBehaviorRelevanceRetrievalCompletedEvent,
            SelectDynamicBehaviorCompletedEvent,
        ],
        Union[
            NavigateStateMachineDynamicBehaviorOverrideEvent,
            NavigateStateMachineActionStateActionSelectedEvent,
            NavigateStateMachineDecisionStateDecisionStartedEvent,
            NavigateStateMachineExitConditionSelectedEvent,
            NavigateStateMachineRecallStateDynamicQueriesGeneratedEvent,
            NavigateStateMachineRecallStateStaticQueriesRetrievedEvent,
            NavigateStateMachineRecallStateActiveMemoryRetrievedEvent,
            NavigateStateMachineReflectionStatePromptRetrievedEvent,
            NavigateStateMachineReflectionStateReflectionGeneratedEvent,
            NavigateStateMachineAnnotationStateAnnotationRetrievedEvent,
            NavigateStateMachineStateTransitionedEvent,
            NavigateStateMachineToolCallStateToolOutputAvailableEvent,
            ToolCallStartedEvent,
            ToolCallEndedEvent,
            ActionTooLongEvent,
            Union[
                GenerateToolParamsDesignatedToolRetrievedEvent,
                GenerateToolParamsDesignatedToolCallParamsGeneratedEvent,
                ActionTooLongEvent,
                ToolCallStartedEvent,
                ToolCallEndedEvent,
            ],
        ],
        Union[
            EngageUserDynamicBehaviorOverrideEvent,
            EngageUserMessageFragmentGeneratedEvent,
            ToolCallStartedEvent,
            ToolCallEndedEvent,
            ActionTooLongEvent,
        ],
    ] = Field(..., description='The type of action the agent is performing right now.')


class DecisionStateInput(BaseModel):
    type: Literal['decision'] = Field(..., title='Type')
    name: str = Field(..., pattern='^[A-Za-z0-9_]+$')
    exit_conditions: List[
        OrganizationCreateServiceHierarchicalStateMachineVersionRequestActionStateExitCondition
    ] = Field(..., title='Exit Conditions')
    decision_guidelines: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        ..., title='Decision Guidelines'
    )
    objective: str = Field(..., min_length=1)
    tool_call_specs: List[ToolCallSpecInput] = Field(..., title='Tool Call Specs')
    audio_fillers: List[StrippedNonemptyString] = Field(
        ...,
        description='A list of audio fillers to play in audio mode if the `select-next-state-for-decision-state` prompt is taking too long to process.',
        max_length=5,
        title='Audio Fillers',
    )
    audio_filler_triggered_after: float = Field(
        ...,
        description='The number of seconds to wait before playing an audio filler.',
        gt=0.0,
        le=10.0,
        title='Audio Filler Triggered After',
    )


class Metric(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    name: str = Field(..., description='The name of the metric.', title='Name')
    description: str = Field(
        ..., description='The description of the metric.', title='Description'
    )
    applied_to_services: List[str] = Field(
        ...,
        description='The services that the metric is applied to.',
        title='Applied To Services',
    )
    additional_notes: Optional[str] = Field(
        ..., description='Additional notes about the metric.', title='Additional Notes'
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the metric.', title='Tags'
    )
    creator: AmigoLibMongoCollectionsMetricMetricUserInfo = Field(
        ..., description='The user who created the metric.'
    )
    updated_by: AmigoLibMongoCollectionsMetricMetricUserInfo = Field(
        ..., description='The user who last updated the metric.'
    )
    metric_value: Union[
        BooleanMetricValue, NumericalMetricValue, CategoricalMetricValueOutput
    ] = Field(
        ...,
        description='The type of value that this metric is measuring.',
        discriminator='type',
    )
    is_deleted: bool = Field(
        ..., description='Whether the metric has been deleted.', title='Is Deleted'
    )


class MetricEvaluationResultInstance(BaseModel):
    id: str = Field(
        ..., description='The ID of the metric evaluation result.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    metric_id: str = Field(
        ..., description='The ID of the metric that was evaluated.', title='Metric Id'
    )
    result: Optional[Union[float, bool, str]] = Field(
        ...,
        description='The result of the metric evaluation. If `None`, the metric was deemed not applicable.',
        title='Result',
    )
    justification: str = Field(
        ...,
        description='The justification for the result of the metric evaluation.',
        title='Justification',
    )
    source: Union[
        PostSessionEvaluationSource, ManualEvaluationSource, SimulationEvaluationSource
    ] = Field(..., discriminator='type')
    timestamp: AwareDatetime = Field(
        ...,
        description='The time at which the metric evaluation result was created.',
        title='Timestamp',
    )


class MetricInstance(BaseModel):
    id: str = Field(
        ..., description='The ID of the metric evaluation result.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    name: str = Field(..., description='The name of the metric.', title='Name')
    description: str = Field(
        ..., description='The description of the metric.', title='Description'
    )
    applied_to_services: List[str] = Field(
        ...,
        description='The services that the metric is applied to.',
        title='Applied To Services',
    )
    additional_notes: Optional[str] = Field(
        ..., description='Additional notes about the metric.', title='Additional Notes'
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the metric.', title='Tags'
    )
    creator: AmigoLibMongoCollectionsMetricMetricUserInfo = Field(
        ..., description='The user who created the metric.'
    )
    updated_by: AmigoLibMongoCollectionsMetricMetricUserInfo = Field(
        ..., description='The user who last updated the metric.'
    )
    metric_value: Union[
        BooleanMetricValue, NumericalMetricValue, CategoricalMetricValueOutput
    ] = Field(
        ...,
        description='The type of value that this metric is measuring.',
        discriminator='type',
    )
    is_deleted: bool = Field(
        ..., description='Whether the metric has been deleted.', title='Is Deleted'
    )


class MetricToEvaluate(BaseModel):
    metric_id: str = Field(..., title='Metric Id')
    success_criterion_name: str = Field(
        ...,
        description='The name of the success criterion.',
        title='Success Criterion Name',
    )
    success_criterion: Union[
        BooleanMetricSuccessCriterion,
        NumericalMetricSuccessCriterion,
        CategoricalMetricSuccessCriterionOutput,
    ] = Field(
        ...,
        description='The description of the success criterion.',
        discriminator='type',
    )


class ReflectionStateInput(BaseModel):
    type: Literal['reflection'] = Field(..., title='Type')
    name: str = Field(..., pattern='^[A-Za-z0-9_]+$')
    problem: str = Field(..., min_length=1)
    word_limit: int = Field(..., gt=0, title='Word Limit')
    next_state: Union[StateOrRefName, ReflectionStateInputNextState] = Field(
        ..., title='Next State'
    )
    tool_call_specs: List[ToolCallSpecInput] = Field(..., title='Tool Call Specs')
    audio_fillers: List[StrippedNonemptyString] = Field(
        ...,
        description='A list of audio fillers to play in audio mode if the reflection is taking too long to be generated.',
        max_length=5,
        title='Audio Fillers',
    )
    audio_filler_triggered_after: float = Field(
        ...,
        description='The number of seconds to wait before playing an audio filler.',
        gt=0.0,
        le=10.0,
        title='Audio Filler Triggered After',
    )


class RoleInstance(BaseModel):
    id: str = Field(..., description='The ID of the role.', title='Id')
    name: str = Field(..., description='The name of the role.', title='Name')
    description: str = Field(
        ..., description='A description of the role.', title='Description'
    )
    frontend_view: FrontendView = Field(
        ...,
        description='The frontend view of the role. This determines the UI that all users of a role will see.',
    )
    permission_grants: List[AmigoLibMongoCollectionsRoleRolePermissionGrant] = Field(
        ...,
        description='The permission grants given to the role. Only returned if the `return_permission_grants` query parameter is True. ',
        title='Permission Grants',
    )
    inherited_from: Optional[str] = Field(
        ...,
        description='The ID of the role that this role inherits from. Only returned if the role inherits from another role.',
        title='Inherited From',
    )
    is_base_role: bool = Field(
        ...,
        description='Whether this role is a base role. Base roles cannot inherit from other roles. One can only inherit from base roles.',
        title='Is Base Role',
    )


class ServiceHierarchicalStateMachineInstance(BaseModel):
    id: str = Field(..., description='The ID of the state machine version.', title='Id')
    org_id: str = Field(
        ...,
        description='The ID of the organization of this state machine.',
        title='Org Id',
    )
    service_hierarchical_state_machine_id: str = Field(
        ...,
        description='The ID of the state machine that this document is a version for.',
        title='Service Hierarchical State Machine Id',
    )
    version: int = Field(
        ...,
        description='Numerical version ID that describes how many iterations of this state machine occurred before this version.',
        title='Version',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The time at which this version was created.',
        title='Created At',
    )
    description: str = Field(
        ..., description='A description of the state machine.', title='Description'
    )
    states: List[
        Union[
            ActionStateOutput,
            DecisionStateOutput,
            RecallStateOutput,
            AnnotationStateOutput,
            ReflectionStateOutput,
            ToolCallStateOutput,
        ]
    ] = Field(..., description='The states in this state machine.', title='States')
    new_user_initial_state: str = Field(
        ...,
        description='The state a new user will be in when a session starts. This must be an action state.',
        title='New User Initial State',
    )
    returning_user_initial_state: str = Field(
        ...,
        description='The state a returning user will be in when a session starts. This must be an action state.',
        title='Returning User Initial State',
    )
    terminal_state: str = Field(
        ...,
        description='The state the user will be in when the session ends. This must be an action state.',
        title='Terminal State',
    )
    references: Dict[str, List] = Field(
        ...,
        description="A dictionary of other service hierarchical state machine versions that this references to. This field is a map of the reference name to the machine's ID and its version number.",
        title='References',
    )
    global_intra_state_navigation_guidelines: List[str] = Field(
        ...,
        description='A list of guidelines for how the agent will navigate between subgoals and exit conditions within this state. This is injected into the `intra_state_navigation_guidelines` field of every action state.',
        title='Global Intra State Navigation Guidelines',
    )
    global_action_guidelines: List[str] = Field(
        ...,
        description='A list of guidelines for how the agent will behave when engaging with user. This is injected into the `action_guidelines` field of every action state.',
        title='Global Action Guidelines',
    )
    global_boundary_constraints: List[str] = Field(
        ...,
        description='A list of guidelines for how the agent will not behave when engaging with user. This is injected into the `boundary_constraints` field of every action state.',
        title='Global Boundary Constraints',
    )


class SimulationUnitTest(BaseModel):
    field_id: str = Field(
        ..., alias='_id', description='The ID of the document.', title='Id'
    )
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    name: str = Field(..., description='The name of the unit test.', title='Name')
    description: str = Field(
        ..., description='A description of the unit test.', title='Description'
    )
    service_id: str = Field(
        ..., description='The service that the unit test runs on.', title='Service Id'
    )
    service_version_set_name: str = Field(
        ...,
        description='The version set of the service that the unit test runs on.',
        title='Service Version Set Name',
    )
    persona_id: str = Field(
        ..., description='The persona that unit test uses.', title='Persona Id'
    )
    scenario_id: str = Field(
        ..., description='The scenario that the unit test uses.', title='Scenario Id'
    )
    max_interactions: int = Field(
        ...,
        description='The max number of interactions after which the unit test fails.',
        title='Max Interactions',
    )
    success_criterions: List[
        AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestSuccessCriterion
    ] = Field(
        ...,
        description='The success criterions for the unit test.',
        title='Success Criterions',
    )
    is_deleted: bool = Field(
        ..., description='Whether the unit test has been deleted.', title='Is Deleted'
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the simulation persona.', title='Tags'
    )
    creator: AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestUserInfo
    updated_by: AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestUserInfo


class SimulationUnitTestInstance(BaseModel):
    id: str = Field(..., title='Id')
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    name: str = Field(..., description='The name of the unit test.', title='Name')
    description: str = Field(
        ..., description='A description of the unit test.', title='Description'
    )
    service_id: str = Field(
        ..., description='The service that the unit test runs on.', title='Service Id'
    )
    service_version_set_name: str = Field(
        ...,
        description='The version set of the service that the unit test runs on.',
        title='Service Version Set Name',
    )
    persona_id: str = Field(
        ..., description='The persona that unit test uses.', title='Persona Id'
    )
    scenario_id: str = Field(
        ..., description='The scenario that the unit test uses.', title='Scenario Id'
    )
    max_interactions: int = Field(
        ...,
        description='The max number of interactions after which the unit test fails.',
        title='Max Interactions',
    )
    success_criterions: List[
        AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestSuccessCriterion
    ] = Field(
        ...,
        description='The success criterions for the unit test.',
        title='Success Criterions',
    )
    is_deleted: bool = Field(
        ..., description='Whether the unit test has been deleted.', title='Is Deleted'
    )
    tags: List[AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestTag] = Field(
        ..., description='The tags of the simulation persona.', title='Tags'
    )
    creator: AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestUserInfo
    updated_by: AmigoLibMongoCollectionsSimulationUnitTestSimulationUnitTestUserInfo


class UnitTestRunSpec(BaseModel):
    unit_test_id: str = Field(
        ..., description='ID of the unit test to run.', title='Unit Test Id'
    )
    run_count: int = Field(
        ..., description='The number of times to run the unit test.', title='Run Count'
    )
    service_hierarchical_state_machine_version_info: List = Field(
        ...,
        description='The version of the service hierarchical state machine that the unit test runs on.',
        max_length=2,
        min_length=2,
        title='Service Hierarchical State Machine Version Info',
    )
    agent_version_info: List = Field(
        ...,
        description='The version of the agent that the unit test runs on.',
        max_length=2,
        min_length=2,
        title='Agent Version Info',
    )
    scenario_version_info: Optional[UnitTestRunSpecScenarioVersionInfo] = Field(
        ...,
        description='The version of the scenario that the unit test runs on. This field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTest` permission.',
        title='Scenario Version Info',
    )
    persona_version_info: Optional[UnitTestRunSpecPersonaVersionInfo] = Field(
        ...,
        description='The version of the persona that the unit test runs on. This field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTest` permission.',
        title='Persona Version Info',
    )
    llm_model_preferences: Dict[
        str,
        Union[AmigoLibLlmLlmBaseLLMConfig, AmigoLibLlmLlmBaseLLMLoadBalancingSetConfig],
    ] = Field(
        ...,
        description='The LLM model preferences for the unit test run.',
        title='Llm Model Preferences',
    )
    max_interactions: int = Field(
        ...,
        description='The max number of interactions after which the unit test fails.',
        title='Max Interactions',
    )
    metrics_to_evaluate: List[MetricToEvaluate] = Field(
        ...,
        description='The metrics to evaluate for the unit test run. This field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTest` permission. Otherwise, it is an empty list.',
        title='Metrics To Evaluate',
    )


class ConversationCreateConversationResponse(
    RootModel[
        Union[
            ConversationCreatedEvent,
            NewMessageEvent,
            InteractionCompleteEvent,
            CurrentAgentActionEvent,
            ErrorEvent,
        ]
    ]
):
    root: Union[
        ConversationCreatedEvent,
        NewMessageEvent,
        InteractionCompleteEvent,
        CurrentAgentActionEvent,
        ErrorEvent,
    ] = Field(..., discriminator='type')


class ConversationGetConversationsResponse(BaseModel):
    conversations: List[ConversationInstance] = Field(
        ...,
        description='The conversations satisfying the filters.',
        title='Conversations',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more conversations to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of conversations. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class DynamicBehaviorSetCreateDynamicBehaviorSetRequest(BaseModel):
    name: str = Field(
        ..., description='The name of the dynamic behavior set.', min_length=1
    )
    tags: Dict[str, Optional[StrippedNonemptyStringWS]] = Field(
        ...,
        description='The tags of the dynamic behavior set. Both the key and the value can only contain alphanumeric characters, underscores, or spaces.',
        title='Tags',
    )
    applied_to_services: List[
        DynamicBehaviorSetCreateDynamicBehaviorSetRequestAppliedToService
    ] = Field(
        ...,
        description='The services that the dynamic behavior set should be applied to.',
        title='Applied To Services',
    )
    initial_version: DynamicBehaviorSetCreateDynamicBehaviorSetRequestInitialVersion = (
        Field(
            ...,
            description='The configuration for the initial version of the dynamic behavior set.',
        )
    )


class MetricGetMetricEvaluationResultsResponse(BaseModel):
    metric_evaluation_results: List[MetricEvaluationResultInstance] = Field(
        ...,
        description='The list of retrieved metric evaluation results.',
        title='Metric Evaluation Results',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more metric evaluation results to retrieve.',
        title='Has More',
    )
    continuation_token: Any = Field(
        ...,
        description='The continuation token to use to retrieve the next set of metric evaluation results.',
        title='Continuation Token',
    )
    filter_values: Optional[MetricGetMetricEvaluationResultsResponseFilterValues] = (
        Field(
            ...,
            description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the metric evaluation results, so they might differ from how many are actually\nretrieved.',
        )
    )


class MetricGetMetricsResponse(BaseModel):
    metrics: List[MetricInstance] = Field(
        ..., description='The list of retrieved metrics.', title='Metrics'
    )
    has_more: bool = Field(
        ..., description='Whether there are more metrics to retrieve.', title='Has More'
    )
    continuation_token: Any = Field(
        ...,
        description='The continuation token to use to retrieve the next set of metrics.',
        title='Continuation Token',
    )
    filter_values: Optional[MetricGetMetricsResponseFilterValues] = Field(
        ...,
        description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the metrics, so they might differ from how many are actually\nretrieved.',
    )


class MetricSearchMetricsResponse(BaseModel):
    metrics: List[Metric] = Field(
        ..., description='The list of retrieved metrics.', title='Metrics'
    )


class OrganizationCreateAgentVersionRequest(BaseModel):
    initials: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString3] = Field(
        None, description="The agent's initials."
    )
    identity: Optional[OrganizationCreateAgentVersionRequestIdentity] = Field(
        None, description="Information about the agent's identity."
    )
    background: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description="A description of the agent's background."
    )
    behaviors: Optional[List[AmigoLibPydanticBaseModelStrippedNonemptyString1]] = Field(
        None,
        description='A list of behavioral guidelines that this agent follows.',
        title='Behaviors',
    )
    communication_patterns: Optional[
        List[AmigoLibPydanticBaseModelStrippedNonemptyString1]
    ] = Field(
        None,
        description='A list of descriptions that illustrate the communication styles of this agent.',
        title='Communication Patterns',
    )
    voice_config: Optional[OrganizationCreateAgentVersionRequestVoiceConfig] = Field(
        None,
        description='The Elevenlabs voice config for the agent. If set to null, it is not updated.',
    )


class OrganizationCreateServiceHierarchicalStateMachineVersionRequest(BaseModel):
    description: str = Field(
        ...,
        description='A description of the service hierarchical state machine.',
        min_length=1,
    )
    states: List[
        Union[
            ActionStateInput,
            DecisionStateInput,
            RecallStateInput,
            AnnotationStateInput,
            ReflectionStateInput,
            ToolCallStateInput,
        ]
    ] = Field(
        ...,
        description='The internal states in this service hierarchical state machine.',
        title='States',
    )
    new_user_initial_state: str = Field(
        ...,
        description='The state a new user will be in when a session starts. This must be an action state, and must be an internal state.',
        pattern='^[A-Za-z0-9_]+$',
    )
    returning_user_initial_state: str = Field(
        ...,
        description='The state a returning user will be in when a session starts. This must be an action state, and must be an internal state.',
        pattern='^[A-Za-z0-9_]+$',
    )
    terminal_state: str = Field(
        ...,
        description='The state the user will be in when the session ends. This must be an action state, and must be an internal state.',
        pattern='^[A-Za-z0-9_]+$',
    )
    references: Dict[str, List] = Field(
        ...,
        description="A dictionary of other service hierarchical state machines that this references to. This field is a map of the reference name to the machine's ID and its version number.",
        title='References',
    )
    global_intra_state_navigation_guidelines: List[
        AmigoLibPydanticBaseModelStrippedNonemptyString1
    ] = Field(
        ...,
        description='A list of guidelines for how the agent will navigate between subgoals and exit conditions within this state. This is injected into the `intra_state_navigation_guidelines` field of every action state.',
        title='Global Intra State Navigation Guidelines',
    )
    global_action_guidelines: List[AmigoLibPydanticBaseModelStrippedNonemptyString1] = (
        Field(
            ...,
            description='A list of guidelines for how the agent will behave when engaging with user. This is injected into the `action_guidelines` field of every action state.',
            title='Global Action Guidelines',
        )
    )
    global_boundary_constraints: List[
        AmigoLibPydanticBaseModelStrippedNonemptyString1
    ] = Field(
        ...,
        description='A list of guidelines for how the agent will not behave when engaging with user. This is injected into the `boundary_constraints` field of every action state.',
        title='Global Boundary Constraints',
    )


class OrganizationGetAgentVersionsResponse(BaseModel):
    agent_versions: List[OrganizationGetAgentVersionsResponseAgentInstance] = Field(
        ..., description='The returned agent versions.', title='Agent Versions'
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more agent versions to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of agent versions. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class OrganizationGetServiceHierarchicalStateMachineVersionsResponse(BaseModel):
    state_machine_versions: List[ServiceHierarchicalStateMachineInstance] = Field(
        ...,
        description='The returned state machine versions.',
        title='State Machine Versions',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more state machine versions to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='A token to supply to the next request to retrieve the next page of state machine versions. Only populated if `has_more` is `True`.',
        title='Continuation Token',
    )


class RoleCreateRoleRequest(BaseModel):
    role_name: str = Field(
        ...,
        description='The name of the role to create. The role must have a max length of 256 characters.',
        max_length=256,
        min_length=1,
    )
    description: str = Field(
        ..., description='A description about the role.', min_length=1
    )
    permission_grants: List[RoleModifyRoleRequestPermissionGrant] = Field(
        ...,
        description='A list of permission grants associated with this role.',
        title='Permission Grants',
    )
    frontend_view: FrontendView = Field(
        ..., description='The frontend view for users of this role.'
    )
    is_base_role: bool = Field(
        ...,
        description='Whether this role is a base role. Base roles cannot inherit from other roles. One can only inherit from base roles.',
        title='Is Base Role',
    )
    inherited_from: Optional[RoleCreateRoleRequestInheritedFrom] = Field(
        ...,
        description='The ID of the role that this role inherits from.',
        title='Inherited From',
    )


class RoleGetRolesResponse(BaseModel):
    roles: List[RoleInstance] = Field(
        ..., description='A list of roles in this organization.', title='Roles'
    )


class RoleModifyRoleRequest(BaseModel):
    description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None,
        description='A description about the role. Only updated if specified. This field is a mutable field.',
    )
    permission_grants: Optional[List[RoleModifyRoleRequestPermissionGrant]] = Field(
        None,
        description='A list of permission grants associated with this role. Only updated if specified. This field is an immutable field.',
        title='Permission Grants',
    )
    frontend_view: Optional[FrontendView] = Field(
        None,
        description='The frontend view for the user of this role. Only updated if specified. This field is an immutable field.',
    )
    inherited_from: Optional[Union[RoleModifyRoleRequestInheritedFrom, FieldNotSet]] = (
        Field(
            {},
            description='The ID of the role that this role inherits from. Only updated if specified. This field is an immutable field.',
            title='Inherited From',
        )
    )


class ServiceCreateServiceRequest(BaseModel):
    service_hierarchical_state_machine_id: str = Field(
        ...,
        description='The ID of the state machine that this service uses.',
        pattern='^[a-f0-9]{24}$',
        title='Service Hierarchical State Machine Id',
    )
    agent_id: str = Field(
        ...,
        description='The ID of the agent that this service uses.',
        pattern='^[a-f0-9]{24}$',
        title='Agent Id',
    )
    name: str = Field(..., description='The name of this service.', min_length=1)
    description: str = Field(
        ..., description='A description of this service.', min_length=1
    )
    is_active: bool = Field(
        ...,
        description='Whether the newly-created service is active. Only active services are visible to users on the dashboard. You can later adjust the activeness of this service.',
        title='Is Active',
    )
    release_version_set: Optional[ServiceCreateServiceRequestVersionSet] = Field(
        None,
        description='The `release` version set to use for this service. If not specified, the `release` version set will be the same as the `edge` version set, which uses the\nlatest agent and state machine versions with no model preference.',
    )
    tags: Dict[str, Optional[StrippedNonemptyStringWS]] = Field(
        ..., description='The tags of this service.', title='Tags'
    )


class SimulationCreateSimulationUnitTestRequest(BaseModel):
    name: str = Field(..., description='The name of the unit test.', min_length=1)
    description: str = Field(
        ..., description='A description of the unit test.', min_length=1
    )
    service_id: str = Field(
        ...,
        description='The service that the unit test runs on.',
        pattern='^[a-f0-9]{24}$',
        title='Service Id',
    )
    service_version_set_name: str = Field(
        ...,
        description='The version set of the service that the unit test runs on.',
        title='Service Version Set Name',
    )
    persona_id: str = Field(
        ...,
        description='The persona that unit test uses.',
        pattern='^[a-f0-9]{24}$',
        title='Persona Id',
    )
    scenario_id: str = Field(
        ...,
        description='The scenario that the unit test uses.',
        pattern='^[a-f0-9]{24}$',
        title='Scenario Id',
    )
    max_interactions: int = Field(
        ...,
        description='The max number of interactions after which the unit test fails.',
        gt=0,
        le=100,
        title='Max Interactions',
    )
    success_criterions: List[
        SimulationCreateSimulationUnitTestRequestSuccessCriterion
    ] = Field(
        ...,
        description='The success criterions for the unit test.',
        min_length=1,
        title='Success Criterions',
    )
    tags: Dict[str, Optional[str]] = Field(
        ..., description='The tags of the simulation persona.', title='Tags'
    )


class SimulationGetSimulationUnitTestsResponse(BaseModel):
    simulation_unit_tests: List[SimulationUnitTestInstance] = Field(
        ...,
        description='The retrieved simulation unit tests.',
        title='Simulation Unit Tests',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more simulation unit tests to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='The continuation token to use to retrieve the next page of simulation unit tests.',
        title='Continuation Token',
    )
    filter_values: Optional[SimulationGetSimulationUnitTestsResponseFilterValues] = (
        Field(
            ...,
            description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the simulation unit tests, so they might differ from how many sets are actually\nretrieved.',
        )
    )


class SimulationSearchSimulationUnitTestsResponse(BaseModel):
    simulation_unit_tests: List[SimulationUnitTest] = Field(
        ...,
        description='The retrieved simulation unit tests.',
        title='Simulation Unit Tests',
    )


class SimulationUpdateSimulationUnitTestRequestSuccessCriterions(
    RootModel[List[SimulationUpdateSimulationUnitTestRequestSuccessCriterion]]
):
    root: List[SimulationUpdateSimulationUnitTestRequestSuccessCriterion] = Field(
        ...,
        description='The success criterions for the unit test.',
        min_length=1,
        title='Success Criterions',
    )


class SimulationUpdateSimulationUnitTestRequest(BaseModel):
    description: Optional[AmigoLibPydanticBaseModelStrippedNonemptyString1] = Field(
        None, description='A description of the unit test.'
    )
    service_id: Optional[SimulationUpdateSimulationUnitTestRequestServiceId] = Field(
        None, description='The service that the unit test runs on.', title='Service Id'
    )
    service_version_set_name: Optional[str] = Field(
        None,
        description='The version set of the service that the unit test runs on.',
        title='Service Version Set Name',
    )
    persona_id: Optional[SimulationUpdateSimulationUnitTestRequestPersonaId] = Field(
        None, description='The persona that unit test uses.', title='Persona Id'
    )
    scenario_id: Optional[SimulationUpdateSimulationUnitTestRequestScenarioId] = Field(
        None, description='The scenario that the unit test uses.', title='Scenario Id'
    )
    max_interactions: Optional[
        SimulationUpdateSimulationUnitTestRequestMaxInteractions
    ] = Field(
        None,
        description='The max number of interactions after which the unit test fails.',
        title='Max Interactions',
    )
    success_criterions: Optional[
        SimulationUpdateSimulationUnitTestRequestSuccessCriterions
    ] = Field(
        None,
        description='The success criterions for the unit test.',
        title='Success Criterions',
    )
    run_count: Optional[SimulationUpdateSimulationUnitTestRequestRunCount] = Field(
        None,
        description='Each time this unit test is run, the number of sessions to simulate.',
        title='Run Count',
    )
    tags: Optional[Dict[str, Optional[str]]] = Field(
        None, description='The tags of the simulation persona.', title='Tags'
    )


class ToolGetToolInvocationsResponseToolInvocationInstance(BaseModel):
    id: str = Field(..., description='The ID of the tool invocation.', title='Id')
    org_id: str = Field(..., description='The ID of the organization.', title='Org Id')
    created_at: Optional[AwareDatetime] = Field(None, title='Created At')
    updated_at: Optional[AwareDatetime] = Field(None, title='Updated At')
    invocation_status: Union[SucceededInvocationStatus, FailedInvocationStatus] = Field(
        ..., description='The status of the tool invocation.', discriminator='succeeded'
    )
    invocation_source: Union[
        RegularConversationInvocationSource, SimulationConversationInvocationSource
    ] = Field(
        ..., description='The source of the tool invocation.', discriminator='type'
    )
    logs: List[str] = Field(..., title='Logs')
    duration_ms: int = Field(
        ...,
        description='The duration of the tool invocation in milliseconds.',
        title='Duration Ms',
    )
    tool_id: str = Field(
        ..., description='The ID of the tool that was invoked.', title='Tool Id'
    )
    tool_version: AmigoLibMongoCollectionsToolVersionToolVersionVersion = Field(
        ..., description='The version of the tool that was invoked.'
    )


class ToolSearchToolInvocationsResponse(BaseModel):
    tool_invocations: List[ToolGetToolInvocationsResponseToolInvocationInstance] = (
        Field(
            ..., description='The list of tool invocations.', title='Tool Invocations'
        )
    )


class SimulationUnitTestSetRunInstance(BaseModel):
    org_id: str = Field(..., title='Org Id')
    id: str = Field(..., title='Id')
    is_completed: bool = Field(
        ...,
        description='Whether the simulation unit test set run is completed.',
        title='Is Completed',
    )
    simulation_unit_test_set_id: str = Field(
        ...,
        description='The simulation unit test set that this run belongs to.',
        title='Simulation Unit Test Set Id',
    )
    failed_metrics: bool = Field(
        ...,
        description='Whether the unit test run has failed. If any of the unit test runs have failed, the unit test set run will be marked as failed, even if others might still be ongoing.',
        title='Failed Metrics',
    )
    errored: bool = Field(
        ...,
        description='Whether the unit test set run has encountered an error.',
        title='Errored',
    )
    artifacts_generated: bool = Field(
        ...,
        description='Whether the artifacts for this unit test set run have been generated.',
        title='Artifacts Generated',
    )
    unit_test_run_specs: List[UnitTestRunSpec] = Field(
        ...,
        description='The unit test run specs for the unit test set run. This field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTestSet` permission. Otherwise, it is an empty list.',
        title='Unit Test Run Specs',
    )
    unit_test_run_results: List[Optional[UnitTestRunResult]] = Field(
        ...,
        description='The unit test run results for the unit test set run. This field is only populated if the authenticated user has the `Simulation:GetSimulationUnitTestSet` permission. Otherwise, it is an empty list.',
        title='Unit Test Run Results',
    )
    created_at: AwareDatetime = Field(
        ...,
        description='The date and time when the unit test set run was created.',
        title='Created At',
    )
    creator: (
        AmigoLibMongoCollectionsSimulationUnitTestSetRunSimulationUnitTestSetRunUserInfo
    ) = Field(..., description='The user who created the unit test set run.')


class ConversationInteractWithConversationResponse(
    RootModel[
        Union[
            UserMessageAvailableEvent,
            ErrorEvent,
            Union[
                InteractionCompleteEvent,
                EndSessionEvent,
                NewMessageEvent,
                CurrentAgentActionEvent,
            ],
        ]
    ]
):
    root: Union[
        UserMessageAvailableEvent,
        ErrorEvent,
        Union[
            InteractionCompleteEvent,
            EndSessionEvent,
            NewMessageEvent,
            CurrentAgentActionEvent,
        ],
    ]


class SimulationGetSimulationUnitTestSetRunsResponse(BaseModel):
    simulation_unit_test_set_runs: List[SimulationUnitTestSetRunInstance] = Field(
        ...,
        description='The retrieved simulation unit test set runs.',
        title='Simulation Unit Test Set Runs',
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more simulation unit test set runs to retrieve.',
        title='Has More',
    )
    continuation_token: Optional[int] = Field(
        ...,
        description='The continuation token to use to retrieve the next page of simulation unit test set runs.',
        title='Continuation Token',
    )
    filter_values: Optional[
        SimulationGetSimulationUnitTestSetRunsResponseFilterValues
    ] = Field(
        ...,
        description='For each filter that this endpoint supports that can take on dynamic values, this field includes what these values are. This is only provided for the first page in the pagination results.\n\nNote that the values are counted assuming the authenticated user has access to all the simulation unit test set runs, so they might differ from how many sets are actually\nretrieved.',
    )


class ToolGetToolInvocationsResponse(BaseModel):
    tool_invocations: List[ToolGetToolInvocationsResponseToolInvocationInstance] = (
        Field(
            ..., description='The list of tool invocations.', title='Tool Invocations'
        )
    )
    has_more: bool = Field(
        ...,
        description='Whether there are more tool invocations to retrieve.',
        title='Has More',
    )
    continuation_token: Any = Field(
        ...,
        description='The continuation token to retrieve the next page of tool invocations, or null if there are no more tool invocations.',
        title='Continuation Token',
    )
