from setuptools import find_packages, setup

setup(
    name="djinitx",
    version="0.2.0",
    description="A CLI tool to setup Django projects",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    author="Sankalp Tharu",
    author_email="sankalptharu50028@gmail.com",
    url="https://github.com/S4NKALP/djinit",
    packages=find_packages(include=["djinit", "djinit.*"]),
    include_package_data=True,
    install_requires=[
        "ruff>=0.14.2",
        "click>=8.3.0",
        "rich>=14.2.0",
        "jinja2>=3.1.0",
    ],
    entry_points={
        "console_scripts": [
            "djinit=djinit.generator:main",
            "dj=djinit.generator:main",
        ]
    },
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Environment :: Web Environment",
        "Framework :: Django",
        "Framework :: Django :: 4.2",
        "Framework :: Django :: 5.1",
        "Framework :: Django :: 5.2",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Topic :: Internet :: WWW/HTTP",
        "Topic :: Internet :: WWW/HTTP :: Dynamic Content",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Software Development :: Code Generators",
    ],
    keywords=[
        "django",
        "cli",
        "project",
        "djinit",
        "djinitx",
        "dj",
        "django-init",
        "django project",
        "django starter",
    ],
    python_requires=">=3.13",
    project_urls={
        "Bug Reports": "https://github.com/S4NKALP/djinit/issues",
        "Source": "https://github.com/S4NKALP/djinit",
        "Documentation": "https://github.com/S4NKALP/djinit#readme",
    },
)
