import { Construct } from 'constructs';
export interface PloneServiceOptions {
    /**
     * targetPort number.
     */
    readonly targetPort: number;
    /**
     * Selector label.
     */
    readonly selectorLabel: {
        [name: string]: string;
    };
    /**
     * Extra labels to associate with resources.
     * @default - none
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Port name for the service.
     * @default - 'http'
     */
    readonly portName?: string;
    /**
     * Annotations to add to the Service metadata.
     * Common annotations include: external-dns config, load balancer settings,
     * service mesh configuration, etc.
     * @example { 'external-dns.alpha.kubernetes.io/hostname': 'plone.example.com' }
     * @default - no additional annotations
     */
    readonly annotations?: {
        [name: string]: string;
    };
}
/**
 * PloneService creates a Kubernetes Service for accessing Plone pods.
 *
 * This is an internal construct used by the Plone class.
 * It creates a ClusterIP service that routes traffic to the backend
 * or frontend deployment pods.
 */
export declare class PloneService extends Construct {
    /**
     * The name of the created Kubernetes service.
     * Can be used to reference this service from other resources.
     */
    name: string;
    constructor(scope: Construct, id: string, options: PloneServiceOptions);
}
