"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PloneService = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * PloneService creates a Kubernetes Service for accessing Plone pods.
 *
 * This is an internal construct used by the Plone class.
 * It creates a ClusterIP service that routes traffic to the backend
 * or frontend deployment pods.
 */
class PloneService extends constructs_1.Construct {
    constructor(scope, id, options) {
        super(scope, id);
        const targetPort = k8s.IntOrString.fromNumber(options.targetPort);
        const selectorLabel = options.selectorLabel;
        const service_labels = {
            ...options.labels ?? {},
            'app.kubernetes.io/part-of': 'plone',
            'app.kubernetes.io/managed-by': 'cdk8s-plone',
        };
        const serviceOpts = {
            metadata: {
                labels: service_labels,
                annotations: options.annotations,
            },
            spec: {
                ports: [{ port: options.targetPort, targetPort: targetPort, name: options.portName ?? 'http' }],
                selector: selectorLabel,
            },
        };
        const service = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = service.name;
    }
}
exports.PloneService = PloneService;
//# sourceMappingURL=data:application/json;base64,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