# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2018-03-04 23:14
from __future__ import unicode_literals
import json

from django.db import migrations


def populate_default(apps, schema_editor):
    ScriptParameter = apps.get_model('wooey', 'ScriptParameter')
    for obj in ScriptParameter.objects.all():
        try:
            obj.default = json.loads(obj.default)
        except Exception:
            obj.default = obj.default
        obj.save()


def reverse_populate_default(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('wooey', '0034_update-checksums'),
    ]

    operations = [
        migrations.RunPython(populate_default, reverse_populate_default)
    ]
