# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OceanArgs', 'Ocean']

@pulumi.input_type
class OceanArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[builtins.str],
                 security_groups: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 associate_ipv6_address: Optional[pulumi.Input[builtins.bool]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 attach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]]] = None,
                 autoscaler: Optional[pulumi.Input['OceanAutoscalerArgs']] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]] = None,
                 controller_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 detach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input['OceanFiltersArgs']] = None,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[builtins.int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']] = None,
                 instance_store_policy: Optional[pulumi.Input['OceanInstanceStorePolicyArgs']] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]]] = None,
                 logging: Optional[pulumi.Input['OceanLoggingArgs']] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]] = None,
                 spot_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 spread_nodes_by: Optional[pulumi.Input[builtins.str]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanUpdatePolicyArgs']] = None,
                 use_as_template_only: Optional[pulumi.Input[builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Ocean resource.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: One or more security group ids.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public IP.
               * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        :param pulumi.Input[builtins.bool] associate_ipv6_address: Configure IPv6 address allocation.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]] attach_load_balancers: Attach load balancers to the cluster.
        :param pulumi.Input['OceanAutoscalerArgs'] autoscaler: Describes the Ocean Kubernetes Auto Scaler.
        :param pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[builtins.str] controller_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]] detach_load_balancers: Detach load balancers from the cluster.
        :param pulumi.Input[builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[builtins.bool] fallback_to_ondemand: If not Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[builtins.int] grace_period: The amount of time, in seconds, after the instance has launched to start checking its health.
        :param pulumi.Input[builtins.int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, an existing instance should remain active after becoming unhealthy. After the set time out the instance will be replaced. The minimum value allowed is 60, and it must be a multiple of 60.
        :param pulumi.Input[builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input['OceanInstanceMetadataOptionsArgs'] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input['OceanInstanceStorePolicyArgs'] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[builtins.str] key_name: The key pair to attach the instances.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]] load_balancers: Array of load balancer objects to add to ocean cluster
        :param pulumi.Input['OceanLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[builtins.str] name: The cluster name.
        :param pulumi.Input[builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]] resource_tag_specifications: Specify which resources should be tagged with Virtual Node Group tags or Ocean tags. If tags are set on the VNG, the resources will be tagged with the VNG tags; otherwise, they will be tagged with the Ocean tags.
        :param pulumi.Input[builtins.int] root_volume_size: The size (in Gb) to allocate for the root volume. Minimum `20`.
        :param pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input[builtins.int] spot_percentage: The desired percentage of Spot instances out of all running instances. Only available when the field is not set in any VNG directly (launchSpec.strategy.spotPercentage).
        :param pulumi.Input[builtins.str] spread_nodes_by: Ocean will spread the nodes across markets by this value. Possible values: `vcpu` or `count`.
        :param pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
               When set to true, on Ocean resource creation please make sure your custom VNG has an initial_nodes parameter to create nodes for your VNG.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if associate_ipv6_address is not None:
            pulumi.set(__self__, "associate_ipv6_address", associate_ipv6_address)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if attach_load_balancers is not None:
            pulumi.set(__self__, "attach_load_balancers", attach_load_balancers)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if blacklists is not None:
            pulumi.set(__self__, "blacklists", blacklists)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if cluster_orientations is not None:
            pulumi.set(__self__, "cluster_orientations", cluster_orientations)
        if controller_id is not None:
            pulumi.set(__self__, "controller_id", controller_id)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if detach_load_balancers is not None:
            pulumi.set(__self__, "detach_load_balancers", detach_load_balancers)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if health_check_unhealthy_duration_before_replacement is not None:
            pulumi.set(__self__, "health_check_unhealthy_duration_before_replacement", health_check_unhealthy_duration_before_replacement)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if instance_store_policy is not None:
            pulumi.set(__self__, "instance_store_policy", instance_store_policy)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_enis is not None:
            pulumi.set(__self__, "reserved_enis", reserved_enis)
        if resource_tag_specifications is not None:
            pulumi.set(__self__, "resource_tag_specifications", resource_tag_specifications)
        if root_volume_size is not None:
            pulumi.set(__self__, "root_volume_size", root_volume_size)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if spread_nodes_by is not None:
            pulumi.set(__self__, "spread_nodes_by", spread_nodes_by)
        if startup_taints is not None:
            pulumi.set(__self__, "startup_taints", startup_taints)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if use_as_template_only is not None:
            pulumi.set(__self__, "use_as_template_only", use_as_template_only)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if utilize_commitments is not None:
            pulumi.set(__self__, "utilize_commitments", utilize_commitments)
        if utilize_reserved_instances is not None:
            pulumi.set(__self__, "utilize_reserved_instances", utilize_reserved_instances)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        One or more security group ids.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public IP.
        * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="associateIpv6Address")
    def associate_ipv6_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure IPv6 address allocation.
        """
        return pulumi.get(self, "associate_ipv6_address")

    @associate_ipv6_address.setter
    def associate_ipv6_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_ipv6_address", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="attachLoadBalancers")
    def attach_load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]]]:
        """
        Attach load balancers to the cluster.
        """
        return pulumi.get(self, "attach_load_balancers")

    @attach_load_balancers.setter
    def attach_load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]]]):
        pulumi.set(self, "attach_load_balancers", value)

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanAutoscalerArgs']]:
        """
        Describes the Ocean Kubernetes Auto Scaler.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @property
    @pulumi.getter
    def blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "blacklists")

    @blacklists.setter
    def blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "blacklists", value)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]:
        """
        Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter(name="clusterOrientations")
    def cluster_orientations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]:
        return pulumi.get(self, "cluster_orientations")

    @cluster_orientations.setter
    def cluster_orientations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]):
        pulumi.set(self, "cluster_orientations", value)

    @property
    @pulumi.getter(name="controllerId")
    def controller_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        """
        return pulumi.get(self, "controller_id")

    @controller_id.setter
    def controller_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "controller_id", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="detachLoadBalancers")
    def detach_load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]]]:
        """
        Detach load balancers from the cluster.
        """
        return pulumi.get(self, "detach_load_balancers")

    @detach_load_balancers.setter
    def detach_load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]]]):
        pulumi.set(self, "detach_load_balancers", value)

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If not Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanFiltersArgs']]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time, in seconds, after the instance has launched to start checking its health.
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "grace_period", value)

    @property
    @pulumi.getter(name="healthCheckUnhealthyDurationBeforeReplacement")
    def health_check_unhealthy_duration_before_replacement(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time, in seconds, an existing instance should remain active after becoming unhealthy. After the set time out the instance will be replaced. The minimum value allowed is 60, and it must be a multiple of 60.
        """
        return pulumi.get(self, "health_check_unhealthy_duration_before_replacement")

    @health_check_unhealthy_duration_before_replacement.setter
    def health_check_unhealthy_duration_before_replacement(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "health_check_unhealthy_duration_before_replacement", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance profile iam role.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @property
    @pulumi.getter(name="instanceStorePolicy")
    def instance_store_policy(self) -> Optional[pulumi.Input['OceanInstanceStorePolicyArgs']]:
        """
        Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        """
        return pulumi.get(self, "instance_store_policy")

    @instance_store_policy.setter
    def instance_store_policy(self, value: Optional[pulumi.Input['OceanInstanceStorePolicyArgs']]):
        pulumi.set(self, "instance_store_policy", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key pair to attach the instances.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]]]:
        """
        Array of load balancer objects to add to ocean cluster
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['OceanLoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['OceanLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region the cluster will run in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservedEnis")
    def reserved_enis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the count of ENIs to reserve per instance type for scaling purposes.
        """
        return pulumi.get(self, "reserved_enis")

    @reserved_enis.setter
    def reserved_enis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reserved_enis", value)

    @property
    @pulumi.getter(name="resourceTagSpecifications")
    def resource_tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]]]:
        """
        Specify which resources should be tagged with Virtual Node Group tags or Ocean tags. If tags are set on the VNG, the resources will be tagged with the VNG tags; otherwise, they will be tagged with the Ocean tags.
        """
        return pulumi.get(self, "resource_tag_specifications")

    @resource_tag_specifications.setter
    def resource_tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]]]):
        pulumi.set(self, "resource_tag_specifications", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size (in Gb) to allocate for the root volume. Minimum `20`.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]:
        """
        Set scheduling object.
        """
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The desired percentage of Spot instances out of all running instances. Only available when the field is not set in any VNG directly (launchSpec.strategy.spotPercentage).
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "spot_percentage", value)

    @property
    @pulumi.getter(name="spreadNodesBy")
    def spread_nodes_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Ocean will spread the nodes across markets by this value. Possible values: `vcpu` or `count`.
        """
        return pulumi.get(self, "spread_nodes_by")

    @spread_nodes_by.setter
    def spread_nodes_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spread_nodes_by", value)

    @property
    @pulumi.getter(name="startupTaints")
    def startup_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]]]:
        """
        Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        """
        return pulumi.get(self, "startup_taints")

    @startup_taints.setter
    def startup_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]]]):
        pulumi.set(self, "startup_taints", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]:
        """
        Optionally adds tags to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        When set to true, on Ocean resource creation please make sure your custom VNG has an initial_nodes parameter to create nodes for your VNG.
        """
        return pulumi.get(self, "use_as_template_only")

    @use_as_template_only.setter
    def use_as_template_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_as_template_only", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If savings plans exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_commitments")

    @utilize_commitments.setter
    def utilize_commitments(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "utilize_commitments", value)

    @property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @utilize_reserved_instances.setter
    def utilize_reserved_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "utilize_reserved_instances", value)

    @property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.input_type
class _OceanState:
    def __init__(__self__, *,
                 associate_ipv6_address: Optional[pulumi.Input[builtins.bool]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 attach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]]] = None,
                 autoscaler: Optional[pulumi.Input['OceanAutoscalerArgs']] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]] = None,
                 controller_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 detach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input['OceanFiltersArgs']] = None,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[builtins.int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']] = None,
                 instance_store_policy: Optional[pulumi.Input['OceanInstanceStorePolicyArgs']] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]]] = None,
                 logging: Optional[pulumi.Input['OceanLoggingArgs']] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 spot_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 spread_nodes_by: Optional[pulumi.Input[builtins.str]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanUpdatePolicyArgs']] = None,
                 use_as_template_only: Optional[pulumi.Input[builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Ocean resources.
        :param pulumi.Input[builtins.bool] associate_ipv6_address: Configure IPv6 address allocation.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]] attach_load_balancers: Attach load balancers to the cluster.
        :param pulumi.Input['OceanAutoscalerArgs'] autoscaler: Describes the Ocean Kubernetes Auto Scaler.
        :param pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[builtins.str] controller_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]] detach_load_balancers: Detach load balancers from the cluster.
        :param pulumi.Input[builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[builtins.bool] fallback_to_ondemand: If not Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[builtins.int] grace_period: The amount of time, in seconds, after the instance has launched to start checking its health.
        :param pulumi.Input[builtins.int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, an existing instance should remain active after becoming unhealthy. After the set time out the instance will be replaced. The minimum value allowed is 60, and it must be a multiple of 60.
        :param pulumi.Input[builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input['OceanInstanceMetadataOptionsArgs'] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input['OceanInstanceStorePolicyArgs'] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[builtins.str] key_name: The key pair to attach the instances.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]] load_balancers: Array of load balancer objects to add to ocean cluster
        :param pulumi.Input['OceanLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[builtins.str] name: The cluster name.
        :param pulumi.Input[builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]] resource_tag_specifications: Specify which resources should be tagged with Virtual Node Group tags or Ocean tags. If tags are set on the VNG, the resources will be tagged with the VNG tags; otherwise, they will be tagged with the Ocean tags.
        :param pulumi.Input[builtins.int] root_volume_size: The size (in Gb) to allocate for the root volume. Minimum `20`.
        :param pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: One or more security group ids.
        :param pulumi.Input[builtins.int] spot_percentage: The desired percentage of Spot instances out of all running instances. Only available when the field is not set in any VNG directly (launchSpec.strategy.spotPercentage).
        :param pulumi.Input[builtins.str] spread_nodes_by: Ocean will spread the nodes across markets by this value. Possible values: `vcpu` or `count`.
        :param pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public IP.
               * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
               When set to true, on Ocean resource creation please make sure your custom VNG has an initial_nodes parameter to create nodes for your VNG.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        if associate_ipv6_address is not None:
            pulumi.set(__self__, "associate_ipv6_address", associate_ipv6_address)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if attach_load_balancers is not None:
            pulumi.set(__self__, "attach_load_balancers", attach_load_balancers)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if blacklists is not None:
            pulumi.set(__self__, "blacklists", blacklists)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if cluster_orientations is not None:
            pulumi.set(__self__, "cluster_orientations", cluster_orientations)
        if controller_id is not None:
            pulumi.set(__self__, "controller_id", controller_id)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if detach_load_balancers is not None:
            pulumi.set(__self__, "detach_load_balancers", detach_load_balancers)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if health_check_unhealthy_duration_before_replacement is not None:
            pulumi.set(__self__, "health_check_unhealthy_duration_before_replacement", health_check_unhealthy_duration_before_replacement)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if instance_store_policy is not None:
            pulumi.set(__self__, "instance_store_policy", instance_store_policy)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_enis is not None:
            pulumi.set(__self__, "reserved_enis", reserved_enis)
        if resource_tag_specifications is not None:
            pulumi.set(__self__, "resource_tag_specifications", resource_tag_specifications)
        if root_volume_size is not None:
            pulumi.set(__self__, "root_volume_size", root_volume_size)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if spread_nodes_by is not None:
            pulumi.set(__self__, "spread_nodes_by", spread_nodes_by)
        if startup_taints is not None:
            pulumi.set(__self__, "startup_taints", startup_taints)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if use_as_template_only is not None:
            pulumi.set(__self__, "use_as_template_only", use_as_template_only)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if utilize_commitments is not None:
            pulumi.set(__self__, "utilize_commitments", utilize_commitments)
        if utilize_reserved_instances is not None:
            pulumi.set(__self__, "utilize_reserved_instances", utilize_reserved_instances)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @property
    @pulumi.getter(name="associateIpv6Address")
    def associate_ipv6_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure IPv6 address allocation.
        """
        return pulumi.get(self, "associate_ipv6_address")

    @associate_ipv6_address.setter
    def associate_ipv6_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_ipv6_address", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="attachLoadBalancers")
    def attach_load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]]]:
        """
        Attach load balancers to the cluster.
        """
        return pulumi.get(self, "attach_load_balancers")

    @attach_load_balancers.setter
    def attach_load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanAttachLoadBalancerArgs']]]]):
        pulumi.set(self, "attach_load_balancers", value)

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanAutoscalerArgs']]:
        """
        Describes the Ocean Kubernetes Auto Scaler.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @property
    @pulumi.getter
    def blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "blacklists")

    @blacklists.setter
    def blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "blacklists", value)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]:
        """
        Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter(name="clusterOrientations")
    def cluster_orientations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]:
        return pulumi.get(self, "cluster_orientations")

    @cluster_orientations.setter
    def cluster_orientations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]):
        pulumi.set(self, "cluster_orientations", value)

    @property
    @pulumi.getter(name="controllerId")
    def controller_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        """
        return pulumi.get(self, "controller_id")

    @controller_id.setter
    def controller_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "controller_id", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="detachLoadBalancers")
    def detach_load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]]]:
        """
        Detach load balancers from the cluster.
        """
        return pulumi.get(self, "detach_load_balancers")

    @detach_load_balancers.setter
    def detach_load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanDetachLoadBalancerArgs']]]]):
        pulumi.set(self, "detach_load_balancers", value)

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If not Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanFiltersArgs']]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time, in seconds, after the instance has launched to start checking its health.
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "grace_period", value)

    @property
    @pulumi.getter(name="healthCheckUnhealthyDurationBeforeReplacement")
    def health_check_unhealthy_duration_before_replacement(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time, in seconds, an existing instance should remain active after becoming unhealthy. After the set time out the instance will be replaced. The minimum value allowed is 60, and it must be a multiple of 60.
        """
        return pulumi.get(self, "health_check_unhealthy_duration_before_replacement")

    @health_check_unhealthy_duration_before_replacement.setter
    def health_check_unhealthy_duration_before_replacement(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "health_check_unhealthy_duration_before_replacement", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance profile iam role.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @property
    @pulumi.getter(name="instanceStorePolicy")
    def instance_store_policy(self) -> Optional[pulumi.Input['OceanInstanceStorePolicyArgs']]:
        """
        Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        """
        return pulumi.get(self, "instance_store_policy")

    @instance_store_policy.setter
    def instance_store_policy(self, value: Optional[pulumi.Input['OceanInstanceStorePolicyArgs']]):
        pulumi.set(self, "instance_store_policy", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key pair to attach the instances.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]]]:
        """
        Array of load balancer objects to add to ocean cluster
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['OceanLoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['OceanLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region the cluster will run in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservedEnis")
    def reserved_enis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the count of ENIs to reserve per instance type for scaling purposes.
        """
        return pulumi.get(self, "reserved_enis")

    @reserved_enis.setter
    def reserved_enis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reserved_enis", value)

    @property
    @pulumi.getter(name="resourceTagSpecifications")
    def resource_tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]]]:
        """
        Specify which resources should be tagged with Virtual Node Group tags or Ocean tags. If tags are set on the VNG, the resources will be tagged with the VNG tags; otherwise, they will be tagged with the Ocean tags.
        """
        return pulumi.get(self, "resource_tag_specifications")

    @resource_tag_specifications.setter
    def resource_tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanResourceTagSpecificationArgs']]]]):
        pulumi.set(self, "resource_tag_specifications", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size (in Gb) to allocate for the root volume. Minimum `20`.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]:
        """
        Set scheduling object.
        """
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more security group ids.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The desired percentage of Spot instances out of all running instances. Only available when the field is not set in any VNG directly (launchSpec.strategy.spotPercentage).
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "spot_percentage", value)

    @property
    @pulumi.getter(name="spreadNodesBy")
    def spread_nodes_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Ocean will spread the nodes across markets by this value. Possible values: `vcpu` or `count`.
        """
        return pulumi.get(self, "spread_nodes_by")

    @spread_nodes_by.setter
    def spread_nodes_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spread_nodes_by", value)

    @property
    @pulumi.getter(name="startupTaints")
    def startup_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]]]:
        """
        Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        """
        return pulumi.get(self, "startup_taints")

    @startup_taints.setter
    def startup_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanStartupTaintArgs']]]]):
        pulumi.set(self, "startup_taints", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public IP.
        * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]:
        """
        Optionally adds tags to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        When set to true, on Ocean resource creation please make sure your custom VNG has an initial_nodes parameter to create nodes for your VNG.
        """
        return pulumi.get(self, "use_as_template_only")

    @use_as_template_only.setter
    def use_as_template_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_as_template_only", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If savings plans exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_commitments")

    @utilize_commitments.setter
    def utilize_commitments(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "utilize_commitments", value)

    @property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @utilize_reserved_instances.setter
    def utilize_reserved_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "utilize_reserved_instances", value)

    @property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.type_token("spotinst:aws/ocean:Ocean")
class Ocean(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_ipv6_address: Optional[pulumi.Input[builtins.bool]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 attach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanAttachLoadBalancerArgs', 'OceanAttachLoadBalancerArgsDict']]]]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanClusterOrientationArgs', 'OceanClusterOrientationArgsDict']]]]] = None,
                 controller_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 detach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanDetachLoadBalancerArgs', 'OceanDetachLoadBalancerArgsDict']]]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanFiltersArgs', 'OceanFiltersArgsDict']]] = None,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[builtins.int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']]] = None,
                 instance_store_policy: Optional[pulumi.Input[Union['OceanInstanceStorePolicyArgs', 'OceanInstanceStorePolicyArgsDict']]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLoadBalancerArgs', 'OceanLoadBalancerArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanResourceTagSpecificationArgs', 'OceanResourceTagSpecificationArgsDict']]]]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 spot_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 spread_nodes_by: Optional[pulumi.Input[builtins.str]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanStartupTaintArgs', 'OceanStartupTaintArgsDict']]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']]] = None,
                 use_as_template_only: Optional[pulumi.Input[builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Clusters can be imported using the Ocean `id`, e.g.,

        hcl

        ```sh
        $ pulumi import spotinst:aws/ocean:Ocean nameOfTheResource o-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] associate_ipv6_address: Configure IPv6 address allocation.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanAttachLoadBalancerArgs', 'OceanAttachLoadBalancerArgsDict']]]] attach_load_balancers: Attach load balancers to the cluster.
        :param pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']] autoscaler: Describes the Ocean Kubernetes Auto Scaler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[builtins.str] controller_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanDetachLoadBalancerArgs', 'OceanDetachLoadBalancerArgsDict']]]] detach_load_balancers: Detach load balancers from the cluster.
        :param pulumi.Input[builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[builtins.bool] fallback_to_ondemand: If not Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[builtins.int] grace_period: The amount of time, in seconds, after the instance has launched to start checking its health.
        :param pulumi.Input[builtins.int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, an existing instance should remain active after becoming unhealthy. After the set time out the instance will be replaced. The minimum value allowed is 60, and it must be a multiple of 60.
        :param pulumi.Input[builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[Union['OceanInstanceStorePolicyArgs', 'OceanInstanceStorePolicyArgsDict']] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[builtins.str] key_name: The key pair to attach the instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLoadBalancerArgs', 'OceanLoadBalancerArgsDict']]]] load_balancers: Array of load balancer objects to add to ocean cluster
        :param pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']] logging: Logging configuration.
        :param pulumi.Input[builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[builtins.str] name: The cluster name.
        :param pulumi.Input[builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanResourceTagSpecificationArgs', 'OceanResourceTagSpecificationArgsDict']]]] resource_tag_specifications: Specify which resources should be tagged with Virtual Node Group tags or Ocean tags. If tags are set on the VNG, the resources will be tagged with the VNG tags; otherwise, they will be tagged with the Ocean tags.
        :param pulumi.Input[builtins.int] root_volume_size: The size (in Gb) to allocate for the root volume. Minimum `20`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: One or more security group ids.
        :param pulumi.Input[builtins.int] spot_percentage: The desired percentage of Spot instances out of all running instances. Only available when the field is not set in any VNG directly (launchSpec.strategy.spotPercentage).
        :param pulumi.Input[builtins.str] spread_nodes_by: Ocean will spread the nodes across markets by this value. Possible values: `vcpu` or `count`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanStartupTaintArgs', 'OceanStartupTaintArgsDict']]]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public IP.
               * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
               When set to true, on Ocean resource creation please make sure your custom VNG has an initial_nodes parameter to create nodes for your VNG.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OceanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Clusters can be imported using the Ocean `id`, e.g.,

        hcl

        ```sh
        $ pulumi import spotinst:aws/ocean:Ocean nameOfTheResource o-12345678
        ```

        :param str resource_name: The name of the resource.
        :param OceanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OceanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_ipv6_address: Optional[pulumi.Input[builtins.bool]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 attach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanAttachLoadBalancerArgs', 'OceanAttachLoadBalancerArgsDict']]]]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanClusterOrientationArgs', 'OceanClusterOrientationArgsDict']]]]] = None,
                 controller_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 detach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanDetachLoadBalancerArgs', 'OceanDetachLoadBalancerArgsDict']]]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanFiltersArgs', 'OceanFiltersArgsDict']]] = None,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[builtins.int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']]] = None,
                 instance_store_policy: Optional[pulumi.Input[Union['OceanInstanceStorePolicyArgs', 'OceanInstanceStorePolicyArgsDict']]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLoadBalancerArgs', 'OceanLoadBalancerArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanResourceTagSpecificationArgs', 'OceanResourceTagSpecificationArgsDict']]]]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 spot_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 spread_nodes_by: Optional[pulumi.Input[builtins.str]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanStartupTaintArgs', 'OceanStartupTaintArgsDict']]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']]] = None,
                 use_as_template_only: Optional[pulumi.Input[builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OceanArgs.__new__(OceanArgs)

            __props__.__dict__["associate_ipv6_address"] = associate_ipv6_address
            __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
            __props__.__dict__["attach_load_balancers"] = attach_load_balancers
            __props__.__dict__["autoscaler"] = autoscaler
            __props__.__dict__["blacklists"] = blacklists
            __props__.__dict__["block_device_mappings"] = block_device_mappings
            __props__.__dict__["cluster_orientations"] = cluster_orientations
            __props__.__dict__["controller_id"] = controller_id
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["detach_load_balancers"] = detach_load_balancers
            __props__.__dict__["draining_timeout"] = draining_timeout
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
            __props__.__dict__["filters"] = filters
            __props__.__dict__["grace_period"] = grace_period
            __props__.__dict__["health_check_unhealthy_duration_before_replacement"] = health_check_unhealthy_duration_before_replacement
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_metadata_options"] = instance_metadata_options
            __props__.__dict__["instance_store_policy"] = instance_store_policy
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["logging"] = logging
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_enis"] = reserved_enis
            __props__.__dict__["resource_tag_specifications"] = resource_tag_specifications
            __props__.__dict__["root_volume_size"] = root_volume_size
            __props__.__dict__["scheduled_tasks"] = scheduled_tasks
            if security_groups is None and not opts.urn:
                raise TypeError("Missing required property 'security_groups'")
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["spot_percentage"] = spot_percentage
            __props__.__dict__["spread_nodes_by"] = spread_nodes_by
            __props__.__dict__["startup_taints"] = startup_taints
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["use_as_template_only"] = use_as_template_only
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["utilize_commitments"] = utilize_commitments
            __props__.__dict__["utilize_reserved_instances"] = utilize_reserved_instances
            __props__.__dict__["whitelists"] = whitelists
        super(Ocean, __self__).__init__(
            'spotinst:aws/ocean:Ocean',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associate_ipv6_address: Optional[pulumi.Input[builtins.bool]] = None,
            associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
            attach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanAttachLoadBalancerArgs', 'OceanAttachLoadBalancerArgsDict']]]]] = None,
            autoscaler: Optional[pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']]] = None,
            blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]]] = None,
            cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanClusterOrientationArgs', 'OceanClusterOrientationArgsDict']]]]] = None,
            controller_id: Optional[pulumi.Input[builtins.str]] = None,
            desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
            detach_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanDetachLoadBalancerArgs', 'OceanDetachLoadBalancerArgsDict']]]]] = None,
            draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
            ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
            fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
            filters: Optional[pulumi.Input[Union['OceanFiltersArgs', 'OceanFiltersArgsDict']]] = None,
            grace_period: Optional[pulumi.Input[builtins.int]] = None,
            health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[builtins.int]] = None,
            iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
            image_id: Optional[pulumi.Input[builtins.str]] = None,
            instance_metadata_options: Optional[pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']]] = None,
            instance_store_policy: Optional[pulumi.Input[Union['OceanInstanceStorePolicyArgs', 'OceanInstanceStorePolicyArgsDict']]] = None,
            key_name: Optional[pulumi.Input[builtins.str]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLoadBalancerArgs', 'OceanLoadBalancerArgsDict']]]]] = None,
            logging: Optional[pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']]] = None,
            max_size: Optional[pulumi.Input[builtins.int]] = None,
            min_size: Optional[pulumi.Input[builtins.int]] = None,
            monitoring: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
            resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanResourceTagSpecificationArgs', 'OceanResourceTagSpecificationArgsDict']]]]] = None,
            root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
            scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            spot_percentage: Optional[pulumi.Input[builtins.int]] = None,
            spread_nodes_by: Optional[pulumi.Input[builtins.str]] = None,
            startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanStartupTaintArgs', 'OceanStartupTaintArgsDict']]]]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]]] = None,
            update_policy: Optional[pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']]] = None,
            use_as_template_only: Optional[pulumi.Input[builtins.bool]] = None,
            user_data: Optional[pulumi.Input[builtins.str]] = None,
            utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
            utilize_reserved_instances: Optional[pulumi.Input[builtins.bool]] = None,
            whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Ocean':
        """
        Get an existing Ocean resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] associate_ipv6_address: Configure IPv6 address allocation.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanAttachLoadBalancerArgs', 'OceanAttachLoadBalancerArgsDict']]]] attach_load_balancers: Attach load balancers to the cluster.
        :param pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']] autoscaler: Describes the Ocean Kubernetes Auto Scaler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[builtins.str] controller_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanDetachLoadBalancerArgs', 'OceanDetachLoadBalancerArgsDict']]]] detach_load_balancers: Detach load balancers from the cluster.
        :param pulumi.Input[builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[builtins.bool] fallback_to_ondemand: If not Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[builtins.int] grace_period: The amount of time, in seconds, after the instance has launched to start checking its health.
        :param pulumi.Input[builtins.int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, an existing instance should remain active after becoming unhealthy. After the set time out the instance will be replaced. The minimum value allowed is 60, and it must be a multiple of 60.
        :param pulumi.Input[builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[Union['OceanInstanceStorePolicyArgs', 'OceanInstanceStorePolicyArgsDict']] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[builtins.str] key_name: The key pair to attach the instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLoadBalancerArgs', 'OceanLoadBalancerArgsDict']]]] load_balancers: Array of load balancer objects to add to ocean cluster
        :param pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']] logging: Logging configuration.
        :param pulumi.Input[builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[builtins.str] name: The cluster name.
        :param pulumi.Input[builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanResourceTagSpecificationArgs', 'OceanResourceTagSpecificationArgsDict']]]] resource_tag_specifications: Specify which resources should be tagged with Virtual Node Group tags or Ocean tags. If tags are set on the VNG, the resources will be tagged with the VNG tags; otherwise, they will be tagged with the Ocean tags.
        :param pulumi.Input[builtins.int] root_volume_size: The size (in Gb) to allocate for the root volume. Minimum `20`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: One or more security group ids.
        :param pulumi.Input[builtins.int] spot_percentage: The desired percentage of Spot instances out of all running instances. Only available when the field is not set in any VNG directly (launchSpec.strategy.spotPercentage).
        :param pulumi.Input[builtins.str] spread_nodes_by: Ocean will spread the nodes across markets by this value. Possible values: `vcpu` or `count`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanStartupTaintArgs', 'OceanStartupTaintArgsDict']]]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public IP.
               * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
               When set to true, on Ocean resource creation please make sure your custom VNG has an initial_nodes parameter to create nodes for your VNG.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OceanState.__new__(_OceanState)

        __props__.__dict__["associate_ipv6_address"] = associate_ipv6_address
        __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
        __props__.__dict__["attach_load_balancers"] = attach_load_balancers
        __props__.__dict__["autoscaler"] = autoscaler
        __props__.__dict__["blacklists"] = blacklists
        __props__.__dict__["block_device_mappings"] = block_device_mappings
        __props__.__dict__["cluster_orientations"] = cluster_orientations
        __props__.__dict__["controller_id"] = controller_id
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["detach_load_balancers"] = detach_load_balancers
        __props__.__dict__["draining_timeout"] = draining_timeout
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__.__dict__["filters"] = filters
        __props__.__dict__["grace_period"] = grace_period
        __props__.__dict__["health_check_unhealthy_duration_before_replacement"] = health_check_unhealthy_duration_before_replacement
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_metadata_options"] = instance_metadata_options
        __props__.__dict__["instance_store_policy"] = instance_store_policy
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["logging"] = logging
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_enis"] = reserved_enis
        __props__.__dict__["resource_tag_specifications"] = resource_tag_specifications
        __props__.__dict__["root_volume_size"] = root_volume_size
        __props__.__dict__["scheduled_tasks"] = scheduled_tasks
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["spot_percentage"] = spot_percentage
        __props__.__dict__["spread_nodes_by"] = spread_nodes_by
        __props__.__dict__["startup_taints"] = startup_taints
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["use_as_template_only"] = use_as_template_only
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["utilize_commitments"] = utilize_commitments
        __props__.__dict__["utilize_reserved_instances"] = utilize_reserved_instances
        __props__.__dict__["whitelists"] = whitelists
        return Ocean(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associateIpv6Address")
    def associate_ipv6_address(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Configure IPv6 address allocation.
        """
        return pulumi.get(self, "associate_ipv6_address")

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @property
    @pulumi.getter(name="attachLoadBalancers")
    def attach_load_balancers(self) -> pulumi.Output[Optional[Sequence['outputs.OceanAttachLoadBalancer']]]:
        """
        Attach load balancers to the cluster.
        """
        return pulumi.get(self, "attach_load_balancers")

    @property
    @pulumi.getter
    def autoscaler(self) -> pulumi.Output[Optional['outputs.OceanAutoscaler']]:
        """
        Describes the Ocean Kubernetes Auto Scaler.
        """
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter
    def blacklists(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "blacklists")

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.OceanBlockDeviceMapping']]]:
        """
        Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter(name="clusterOrientations")
    def cluster_orientations(self) -> pulumi.Output[Optional[Sequence['outputs.OceanClusterOrientation']]]:
        return pulumi.get(self, "cluster_orientations")

    @property
    @pulumi.getter(name="controllerId")
    def controller_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        """
        return pulumi.get(self, "controller_id")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[builtins.int]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="detachLoadBalancers")
    def detach_load_balancers(self) -> pulumi.Output[Optional[Sequence['outputs.OceanDetachLoadBalancer']]]:
        """
        Detach load balancers from the cluster.
        """
        return pulumi.get(self, "detach_load_balancers")

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If not Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.OceanFilters']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of time, in seconds, after the instance has launched to start checking its health.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="healthCheckUnhealthyDurationBeforeReplacement")
    def health_check_unhealthy_duration_before_replacement(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of time, in seconds, an existing instance should remain active after becoming unhealthy. After the set time out the instance will be replaced. The minimum value allowed is 60, and it must be a multiple of 60.
        """
        return pulumi.get(self, "health_check_unhealthy_duration_before_replacement")

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The instance profile iam role.
        """
        return pulumi.get(self, "iam_instance_profile")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> pulumi.Output[Optional['outputs.OceanInstanceMetadataOptions']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @property
    @pulumi.getter(name="instanceStorePolicy")
    def instance_store_policy(self) -> pulumi.Output[Optional['outputs.OceanInstanceStorePolicy']]:
        """
        Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        """
        return pulumi.get(self, "instance_store_policy")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The key pair to attach the instances.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLoadBalancer']]]:
        """
        Array of load balancer objects to add to ocean cluster
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.OceanLogging']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[builtins.int]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The cluster name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The region the cluster will run in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="reservedEnis")
    def reserved_enis(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the count of ENIs to reserve per instance type for scaling purposes.
        """
        return pulumi.get(self, "reserved_enis")

    @property
    @pulumi.getter(name="resourceTagSpecifications")
    def resource_tag_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.OceanResourceTagSpecification']]]:
        """
        Specify which resources should be tagged with Virtual Node Group tags or Ocean tags. If tags are set on the VNG, the resources will be tagged with the VNG tags; otherwise, they will be tagged with the Ocean tags.
        """
        return pulumi.get(self, "resource_tag_specifications")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The size (in Gb) to allocate for the root volume. Minimum `20`.
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> pulumi.Output[Optional[Sequence['outputs.OceanScheduledTask']]]:
        """
        Set scheduling object.
        """
        return pulumi.get(self, "scheduled_tasks")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        One or more security group ids.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The desired percentage of Spot instances out of all running instances. Only available when the field is not set in any VNG directly (launchSpec.strategy.spotPercentage).
        """
        return pulumi.get(self, "spot_percentage")

    @property
    @pulumi.getter(name="spreadNodesBy")
    def spread_nodes_by(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Ocean will spread the nodes across markets by this value. Possible values: `vcpu` or `count`.
        """
        return pulumi.get(self, "spread_nodes_by")

    @property
    @pulumi.getter(name="startupTaints")
    def startup_taints(self) -> pulumi.Output[Optional[Sequence['outputs.OceanStartupTaint']]]:
        """
        Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        """
        return pulumi.get(self, "startup_taints")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public IP.
        * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.OceanTag']]]:
        """
        Optionally adds tags to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.OceanUpdatePolicy']]:
        return pulumi.get(self, "update_policy")

    @property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        When set to true, on Ocean resource creation please make sure your custom VNG has an initial_nodes parameter to create nodes for your VNG.
        """
        return pulumi.get(self, "use_as_template_only")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If savings plans exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_commitments")

    @property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @property
    @pulumi.getter
    def whitelists(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "whitelists")

